/*
 * gcc -Wall -O4 time_axpy.c -lf77BLAS -latlas -L/usr/local/lib -o time_axpy
 */
#include <stdio.h>       /* printf, fopen, fclose */
#include <time.h>        /* gettimeofday, timeval, CLOCKS_PER_SEC, clock_t, clock() */
#include <stdlib.h>      /* RAND_MAX */

#define SIZE  10000
float elapsed(struct timeval start, struct timeval end);
main (int argc, char** argv)
{
    double  double_5    =  5.0,
            X[SIZE], Y[SIZE];
    int     int_1       = 1,
            n, r, i, repetitions;
    float   C_time, BLAS_time;
    clock_t start_BLAS, end_BLAS, start_C, end_C;
    struct timeval start, end;
    FILE   *fh;
    char   *outfile = "results.txt";
    repetitions     = 100000;

    printf("Timing %d repetitions of Y = Y +a*X with DAXPY and straight C\n",
            repetitions);
    fh = fopen(outfile, "w");
    for (n = 0; n < SIZE; n++) {

        /* reassign X and Y so that Y doesn't overflow */
        for (i = 0; i < SIZE; i++) {
            X[i] = rand()/RAND_MAX;
            Y[i] = rand()/RAND_MAX;
        }

        gettimeofday(&start, 0);
        for (r = 0; r < repetitions; r++) {
            daxpy_(&n, &double_5, X, &int_1, Y, &int_1); /* Y = Y + 5.0*X */
        }
        gettimeofday(&end, 0);
        BLAS_time  = elapsed(start, end);

        gettimeofday(&start, 0);
        for (r = 0; r < repetitions; r++) {
            for (i = 0; i < n; i++) {
                Y[i] += double_5*X[i];                   /* Y = Y + 5.0*X */
            }
        }
        gettimeofday(&end, 0);
        C_time     = elapsed(start, end);

        fprintf(fh, "%3d  %14.6f  %14.6f\n",        n, BLAS_time, C_time);
        printf("n = %3d  BLAS=%14.6f  C=%14.6f\n",  n, BLAS_time, C_time);
        fflush(fh);
    }
    fclose(fh);

    exit(0);
}

float elapsed(struct timeval start, struct timeval end) {
    return  (float) (end.tv_sec - start.tv_sec) +
           ((float) (end.tv_usec - start.tv_usec)/1000000);
}
