#!/usr/bin/env perl
use strict;
(my $script) = ($0 =~ /^.*?(\w+)$/);

opendir(DIR, ".");
my @tests = readdir(DIR);
close(DIR);

$| = 1; # flush STDOUT
foreach my $s (@tests) {
    next if $s eq $script or 
             -d $s        or 
            !-x $s        or 
            $s =~ /\.swp$/;
    my $command = "./$s";
    print  "$command\n";
    open(IN, "$command|") or die "Cannot run $command  $!\n";
    while (<IN>) {
        if (!/\bERROR\b/) {
            if (/\bOK\b/) {
                chomp;
                print "$_\r";
            } else {
                print;
            }
        }
    }
    close(IN);
    print "\n";
}
