\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File term.v  August 2005

Copyright (c) 2005   D. R. Williamson

Words for remote login and running.

References:

   1. Postel, J., and Reynolds, J. K., "Telnet Protocol Specification,"
      RFC 854, May 1983.
         http://www.faqs.org/rfcs/rfc854.html
         http://rfc.sunsite.dk/rfc/rfc854.html

   2. Telnet source (netkit-telnet-0.17.tgz).
         ftp://ftp.uk.linux.org/pub/linux/Networking/netkit

   3. File usr/telnetd/README describes creation of the required
      telnetd daemon program using Reference 2.

   4. File doc/telnet.doc shows the steps during login to telnetd, and
      was used to design words CLIENT_LOGIN, REC, and SEND.

   5. D. Waitzman, RFC 1073, "Telnet Window Size Option," October 1988.
         http://www.ietf.cnri.reston.va.us/rfc/rfc1073.txt

------------------------------------------------------------------------

   Description of Parts I and II of this file:

      This shows a Client machine running a telnet client and a Server 
      machine serving it. 

        Client machine  |      Server machine
                        |
           telnet client|<---S---> ROUTER <---S1---> telnetd 

      Unix telnet (Reference 1) can be used for the client on a Client 
      machine.  It was used to write the Server words in this file.  

      Part I of this file has words for a telnet client to run on the 
      Client machine that also work with the Server words in this file.
      For example, word CLIENT_TELNET can replace the telnet client.

      Words for the Server are in Part II, and include word ROUTER to 
      send bytes between the Client and the telnetd daemon (also run-
      ning on the Server), as shown above.

      Reference 2 is an open source telnet program.  A copy of the tel-
      net program, with latest patches, accompanies this program in file
      /usr/telnetd/netkit-telnet-0.17.tgz.  It requires installation by
      root, following the steps given in Reference 3, to make a telnetd
      daemon that completes the network shown above.

   Testing:

      1. Starting TELNETD server in one window:

            "term.v" "Server Words" msource ntrace 9877 TELNETD

      2. Starting a client in another window after the message from 
         TELNETD server reports listening on port 9877:

            "term.v" "Client Words" msource 
            "clacker" 9877 CLIENT_TELNET 

      3. Running scripts in usr/ that run the code of this file, Parts
         I and II, to start a server and allow a client to log in:

            # Start server (run Part II), and show net trace in log:
            % usr/telserver -ntrace    
            % tail -f ~/telserver_XXXX.log 

            # Log in to server (run Part I):
            % usr/telclient -host clacker -port 9890 
}
\-----------------------------------------------------------------------
{
I. Words for a telnet client on the Client machine.

   inline: CLEAR (... qT nSocket --- ) \ clear stack and show display
   inline: CLIENT_LOGIN (qHost nPort --- ) \ remote machine login
   inline: CLIENT_NEGOTIATE (qIPaddr nPort --- qT nS) \ get login prompt
   inline: CLIENT_TELNET (qIPaddr nPort --- ) \ remote running
   inline: CLIENT_TELNET_CLOSE (nS --- ) \ S has been closed; exit
   inline: CLIENT_WINDOW (nRows nCols --- qS) \ window size for telnetd
   inline: REC ( --- hPTR) \ login strings received from telnetd server
   inline: SEND ( --- hPTR) \ login strings sent to telnetd server
}
   "term.v" "Client Words" msource
   private halt

   Script usr/telclient sources this region, "Client Words," when it 
   runs.

   Client Words 

   "CONNECT" missing IF " Networking words required" . halt THEN
   keys? not IF "key.v" "Keyboard words" msource keyboard THEN

   inline: CLEAR (... qT nSocket --- ) \ clear stack and show display
\     This word runs every time bytes appear from the remote server.

\     The stack contains socket numbers and text strings.  Clear the
\     stack by displaying all strings and dropping everything else.

      (... qT nSocket) depth any?
      IF (depth) dup push revn \ reverse so oldest is on top
         pull (depth) 1st
         DO (... qT nSocket) this type STR =
            IF any? 
               IF dotstr THEN
            ELSE drop
            THEN
         LOOP
      THEN
   end

   inline: CLIENT_LOGIN (qHost nPort --- ) \ remote machine login
\     Login through Unix telnetd running on remote machine.

      [ '"Login incorrect" nl . nl nl' "INCORRECT" book ]

      (qHost nPort) this 0= not
      IF 
\        Perform login negotiation, steps 1 through 4:
         (qHost nPort) CLIENT_NEGOTIATE (qT nS) "S" book "T" book

         S 0> not
         IF " CLIENT_LOGIN: failed to connect" ersys return THEN

\        When the connection to the server is closed, this word will
\        run to close down this client on socket S:
         "CLIENT_TELNET_CLOSE" ptr S ptrCls_upd \ runs when S closes

         S "CLIENT_TELNET" "S" bank 

      ELSE 2drop \ reentering to try login again; use same S and T
      THEN
      5 "step" book \ starting login name step

    \ Receive keys for login name:
      BEGIN
         T accept_keys (0 | qS -1) not
      WHILE
         INCORRECT loca
      REPEAT
      these chars "bytes" book

    \ Sending login name:
      SYSOUT push "/dev/null" set_sysout \ turn off display
      (qS) S remoteputf                  \ send login name
      S MAXBLOCK bytes remotercv (qT)    \ wait for echo of name
      pull set_sysout                    \ reset SYSOUT

      (qT) depth 1 <
      IF " CLIENT_LOGIN: stack error at login name" nl . nl
         " CLIENT_LOGIN: closing socket" . S .i nl
         S sclose return
      THEN
      (qT) drop \ drop login name echo

      SEND step pry exe S remoteputf \ send EOR for login name
    \ Expecting at least 10 bytes for string "Password: " (10 includes
    \ a trailing blank):
      S MAXBLOCK 9 remotercv \ hold to receive 9 bytes or more

      (qT) depth 1 <
      IF " CLIENT_LOGIN: stack error at password prompt" nl . nl
         " CLIENT_LOGIN: closing socket" . S .i nl
         S sclose return
      THEN

      6 "step" book   \ starting password step
      (qT) dup dotstr \ show the received password prompt

      SYSOUT push "/dev/null" set_sysout \ turn off echo

    \ Receive keys for Password:
      (qT) accept_keys (0 | qS -1) not IF "" THEN
      pull set_sysout \ reset SYSOUT

    \ Sending password:
      (qS) S remoteputf \ no echo is coming, so don't block for it

      SEND step pry exe S remoteputf \ send EOR for password
      S MAXBLOCK 4 remotercv \ hold to receive 4 bytes or more
      (qT) depth 1 <
      IF " CLIENT_LOGIN: stack error at password" nl . nl
         " CLIENT_LOGIN: closing socket" . S .i nl
         S sclose return
      THEN
      (qT) \ telnetd response to password

{     Examples of messages for bad login:

         netkit-telnet-0.17 in RH Linux 7.2: 
            Login incorrect

         telnet in AIX 4.3:
            You entered an invalid login name or password 
}
      (qT) this "invalid login" grepr rows any 
           that "gin incorrect" grepr rows any 
      or
      IF (qT) drop \ Bad login, try again:
         INCORRECT loca
         "login: " "T" book
         0 0 CLIENT_LOGIN \ reenter this word

      ELSE (qT) \ Good login.
         "CLIENT_TELNET_CLOSE" -ALARM      \ kill the login time out
         yes "CLIENT_TELNET" "LOGGED" bank \ set logged-in flag

       \ Change the future message in CLIENT_TELNET_CLOSE:
         "Client closing" "CLIENT_TELNET_CLOSE" "MSG" bank

       \ This will display the prompt just arrived from telnetd:
         (qT) S CLEAR

       \ From now on, run ptrRun(S)=ptr(CLEAR) to display bytes that
       \ arrive on socket S through drainf():  
         "CLEAR" ptr S ptrRun_upd

      THEN
   end

\  CNEG MARKER

   inline: CLIENT_NEGOTIATE (qIPaddr nPort --- qT nS) \ get login prompt
{     Perform the first four login steps, negotiating with Unix telnetd
      through this program's TELNETD.  When this word returns to word
      CLIENT_LOGIN, steps for user name and password will begin.

      See doc/telnet.doc for the trace of steps during Unix telnet
      login that was used to write this word.
}      
      [ -1 "S" book 20 "TRIES" book
        CRLF 1st catch (0x0D) "CR" book

      {" Check stack depth for returned T and look for login string:
\" Dcheck:" . step .i nl
         DONE IF return THEN
         S MAXBLOCK BLOCK
         depth d0 - any?
         IF drop this type STR = \ DONE=yes when get login string:
            IF "T" book T asciify "login:" grepr rows 0>
            ELSE drop no
            THEN (f)
         ELSE no (f)
         THEN (f) "DONE" book
\T INF xray . nl
\" DONE =" . DONE .i nl
      "} "Dcheck" macro
      ]
      "PORT" book
      "HOST" book
      0 "k" book

      BEGIN
         1 "step" book \ steps are noted in word SEND
         depth "d0" book
         " " "T" book
         no "DONE" book

         0 "CLIENT_F" "set_CONN" bank \ drainf returns only T on stack

       \ Making connection to TELNETD as a foreign client: 
         HOST PORT CLIENT_F (S) dup "S" book 0<
         IF "" (qT) -1 return THEN

         Dcheck \ receive inut from telnetd

         4 1 \ negotiate
         DO SEND step pry exe (qT)
\" step" . I .i " send:" . nl dup INF xray . nl
            S remoteputf 
            Dcheck 1 step bump 
         LOOP

         DONE

         IF 4 "step" book \ step 4

            os "aix" = \ must receive FF FE 01 tag that follows login:
            IF T 3 T cols min endcols "FF FE 01" hexbytes = not
               IF \ wait to receive:
                  depth push S 3 3 remotercv depth pull - dump
               ELSE \ FF FE 01 is in the tail of T; strip it off:
                  T 1st T cols 3 - 1st max thrulist catch "T" book
               THEN
               T asciify "login:" grepr rows 0> "DONE" book

               DONE 
               IF \ Strip the AIX login lines to a minimum:
                  T dup asciify "AIX" smap any?
                  IF ontop negate indent 
                     notrailing spaced 
                  ELSE drop "login: " 
                  THEN 
                  (qT) CR swap + "T" book \ 1st char is 0x0D
               THEN
            THEN

            os "linux" = \ linux telnetd, netkit-telnet-0.17
            IF T "login:" tug notrailing spaced 
               (qT) CR swap + "T" book \ 1st char is 0x0D
            THEN
            
         THEN

         DONE not IF S sclose 0.1 idle THEN

         1 k bump
         DONE k TRIES > or
      UNTIL

      DONE 
      IF T S \ success
      ELSE "" (qT) -1 \ failed
      THEN (qT nS)
   end

\  CNEG END

   inline: CLIENT_TELNET (qIPaddr nPort --- ) \ remote running
{     Connect to IPaddr where this program's TELNETD server is 
      listening on Port.  Then process keys and response back and 
      forth with TELNETD server until this client program is shut 
      down by the exit command.
}     
      [ 30 "SEC" book    \ this many seconds for login
        no "LOGGED" book \ good login is banked yes by CLIENT_LOGIN
        0 "S" book       \ socket to telnetd, banked by CLIENT_LOGIN
      ]
      SEC "CLIENT_TELNET_CLOSE" ALARM \ alarm to limit login time

      (qIPaddr nPort) CLIENT_LOGIN

      LOGGED IF BEGIN getkeys S remoteputf no UNTIL THEN S sclose
   end

   inline: CLIENT_TELNET_CLOSE (nS --- ) \ S has been closed; exit
\     This word is run by clientclose() when socket S has been closed,
\     or as a timeout ALARM during client login.
      [ {"
           set_stderr
           MSG dot nl
           clear
           "Connection closed by foreign host." dot nl 
           exit
        "} "CLOSE" macro
        0.2 "DELAY" book

      \ A new MSG is banked after login to override this one:
        "Client login timeout" "MSG" book 
      ] 
      (S) depth 0> IF drop THEN \ no S if login alarm went off

      "unblock," -ALARM \ remove any block

      DELAY "CLIENT_TELNET_CLOSE" "CLOSE" localref ALARM

      HALT \ unwind everything before the ALARM goes off
   end

\  CWIN MARKER

   inline: CLIENT_WINDOW (nRows nCols --- qS) \ window size for telnetd
{     Create the window-size string for sending to telnetd.

      Example:
         [tops@clacker] ready > 24 80 CLIENT_WINDOW INF xray .
                0  1  2  3  4  5  6  7  8   0123456789ABCDEF
            0  FF FA 1F 00 50 00 18 FF F0   ....P...........

      Usage: sending to telnetd on socket 7 a new window size 24-by-80:

         24 80 CLIENT_WINDOW 7 remoteputf

      If new size is different from the old one, telnetd sends back an 
      Esc[K to erase the current line, followed by the command prompt.
}
      [ " FF FA 1F 00 C 00 R FF F0 " "T" book
        "int '%x' format" "1hex" macro ]
      T   
      "C" rot (nCols) 1hex strrpl 
      "R" rot (nRows) 1hex strrpl 
      hexbytes
   end

\  CWIN END

{  REC is for reference, not used.
   inline: REC ( --- hPTR) \ login strings from Unix telnetd server
\     See RFC 854 (Reference 1) for the meaning of byte patterns.
      [ 
\     These patterns can be found in doc/telnet.doc, searching for 
\     the phrase "receive from telnetd socket 7."

      list: 
       (step)
         (1) "FF FD 18 FF FD 20 FF FD 23 FF FD 27" hexbytes hand

         (2) "FF FA 20 01 FF F0 FF FA 23 01 FF F0 FF FA 27 01" 
             "FF F0 FF FA 18 01 FF F0" pile hexbytes hand

         (3) "FF FB 03 FF FD 01 FF FD 1F FF FB 05 FF FD 21" hexbytes
             hand

         (4) "FF FB 01 0D 0A" hexbytes hand (first three, last two)

         (5) "login: " hand

         (6) "0D 0A" hexbytes "Password: " + hand
      end
      "REC" book
      ] REC
   end
}
\  SEND MARKER

   inline: SEND ( --- hPTR) \ login strings sent to Unix telnetd server
{     See RFC 854 (Reference 1) for the meaning of byte patterns.
      See RFC 1073 (Reference 5) for NAWS.

      Terminal definitions are in /etc/termcap.  Terminals rxvt, vt100 
      and vt102 appear to work correctly and return VT100 escape se-
      quences like these in response to command pwd:

 ROUTER: receive from socket 7 send on socket 3
 remoteputf: writing 42 bytes to socket 3
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0D 0A 2F 68 6F 6D 65 2F 64 61 6C 65 0D 0A 5B 64  ../home/dale..[d
   2  61 6C 65 40 63 6C 61 63 6B 65 72 5D 20 2F 68 6F  ale@clacker] /ho
   4  6D 65 2F 64 61 6C 65 20 3E 20 00 00 00 00 00 00  me/dale > ......
 2156 microsec delta: end remoteputf

      These terminal types have problems:

      Terminal linux does not appear to work properly with the
         version of telnetd being used (Reference 2).  Trying to
         quit vi with :q causes its window to hang.

      For terminal xterm, bytes from telnetd do not match escape
         sequences for VT100.  These are bytes received from telnetd 
         in response to command pwd:

 ROUTER: receive from socket 7 send on socket 3
 remoteputf: writing 61 bytes to socket 3
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0D 0A 2F 68 6F 6D 65 2F 64 61 6C 65 0D 0A 1B 5D  ../home/dale...]
   2  30 3B 64 61 6C 65 40 63 6C 61 63 6B 65 72 3A 7E  0;dale@clacker:~
   4  07 5B 64 61 6C 65 40 63 6C 61 63 6B 65 72 5D 20  .[dale@clacker]
   6  2F 68 6F 6D 65 2F 64 61 6C 65 20 3E 20 00 00 00  /home/dale > ...
 2237 microsec delta: end remoteputf

      If it is set, telnetd gets its terminal type from environmental
      variable TERM.  The export command sets it: export TERM=VT100     

      How SEND works:
       
      Using "hand" in the list below turns STR into VOL handle, and 
      then word list: turns all the handles into ptr NUMs, so a list
      of ptr NUMs is obtained which can be fetched and executed.

      SEND is then used as: exe(@SEND[k]) to fetch the kth ptr in 
      the list and run it, obtaining the kth hex string as in this 
      example:

>> exe(@SEND[ndx(2)]) INF xray .
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  FF FA 20 00 33 38 34 30 30 2C 33 38 34 30 30 FF  .. .38400,38400.
   2  F0 FF FA 23 00 63 6C 61 63 6B 65 72 3A 30 2E 30  ...#.clacker:0.0
   4  FF F0 FF FA 27 00 00 44 49 53 50 4C 41 59 01 63  ....'..DISPLAY.c
   6  6C 61 63 6B 65 72 3A 30 2E 30 FF F0 FF FA 18 00  lacker:0.0......
   8  72 78 76 74 FF F0 00 00 00 00 00 00 00 00 00 00  rxvt............
>> 
}
      [ 
      ""
      os "linux" =
      IF drop list:

\      These patterns can be found in doc/telnet.doc, searching for
\      phrase "received on socket 6."

       (step)
         (1) "FF FB 18 FF FB 20 FF FB 23 FF FB 27 "
             "FF FB 1F" + \ WILL negotiate about window size (NAWS)
             hexbytes hand 

         (2) \ Terminal properties:
             "FF FA 20 00" hexbytes "38400,38400" +

             "FF F0 FF FA 23 00" hexbytes + host "DISPLAY" env + +

             "FF F0 FF FA 27 00 00" hexbytes DISPLAY + +
             "01" hexbytes host "DISPLAY" env + + +

           \ Terminals that work:
           \ "FF F0 FF FA 18 00" hexbytes "rxvt" + + 
           \ "FF F0 FF FA 18 00" hexbytes "rxvt-basic" + + 
           \ "FF F0 FF FA 18 00" hexbytes "vt100" + + 
           \ "FF F0 FF FA 18 00" hexbytes "vt102" + + 
           \ CSI 'c' (DA, device attributes) sends response E[?6c which
           \ is VT102.  

           \ Choose rxvt over vt100.  Rxvt sends more advanced Esc
           \ sequences that allow two screens (for example, when exit
           \ vi, the screen before entering vi comes back):
             "FF F0 FF FA 18 00" hexbytes "rxvt" + + 

           { These terminals do not work properly as noted above:
             "FF F0 FF FA 18 00" hexbytes "xterm" + + 
             "FF F0 FF FA 18 00" hexbytes "linux" + + 

             Other terminals to experiment with (some do not work 
             right; see /etc/termcap for more):
             "FF F0 FF FA 18 00" hexbytes "mach" + + 
             "FF F0 FF FA 18 00" hexbytes "att6386" + + 
             "FF F0 FF FA 18 00" hexbytes "att7300" + + 
             "FF F0 FF FA 18 00" hexbytes "qnx" + + 
             "FF F0 FF FA 18 00" hexbytes "screen" + + 
           }
             "FF F0" hexbytes + hand

         (3) "FF FD 03 "                \ DO supress go ahead
             "FF FB 01 " +              \ WILL transmit echo
             "FF FD 05 " +              \ DO status
             "FF FB 21 " +              \ WILL remote flow control
             "FF F0" + hexbytes 
             24 80 CLIENT_WINDOW + hand

         (4) "FF FD 01" hexbytes hand \ DO transmit echo

         (5) "0D 00" hexbytes hand

         (6) "0D 00" hexbytes hand
      end

      THEN

      os "aix" =
      IF drop list:
\        Determined by tests on telnetd AIX version 4.3

       (step)
         (1) "FF FB 18" hexbytes hand

\                         v  t  1  0  0
         (2) "FF FA 18 00 76 74 31 30 30 FF F0" hexbytes hand

         (3) "FF FD 01 FF FD 03 FF FB 1F FF FC 01" hexbytes hand

         (4) "0D 00" hexbytes hand

         (5) "0D 00" hexbytes hand

         (6) "0D 00" hexbytes hand
      end
      THEN

      any?
      IF "SEND" book
      ELSE " SEND: no byte patterns for os " . os HALT
      THEN

      ] SEND
   end

   private halt

   End of Client Words.

\-----------------------------------------------------------------------

II. Words for the Server machine to send bytes back and forth between 
    the Client machine and telnetd on Server.

   inline: ROUTER (hT nS --- ) \ route bytes between client and telnetd
   inline: TELNET_CLIENT_CLOSE (nS1 --- ) \ close S of pair (S,S1)
  function TELNETD(P) // start the program's telnetd server
   inline: TELNETD_CONNECT (nS --- ) \ connect telnetd network
   inline: TELNETD_SERVER_CLOSE (nS --- ) \ close S1 of pair (S,S1)
   inline: TELNETD_START ( --- nPort) \ start telnetd, return its Port
 
   Script usr/telserver sources this region, "Server Words," when it 
   runs.

   Server Words 

   "CONNECT" missing IF " Networking words required" . halt THEN

   inline: ROUTER (hT nS --- ) \ route bytes between client and telnetd
{     This word services all bytes received on the listening server
      defined by TELNETD.

      Bytes T from socket S are sent to telnetd when S is the client,
      and to the client when S is telnetd.

      SERVE_F.SERVICE was given the ptr to this word when TELNETD was
      run at start up, so this word is run by SERVE_F whenever bytes
      arrive on the server.

        Client Machine | Server Machine
                       |
         client program|<---S1---> ROUTER <---S2---> telnetd server
}
      [
        100 "MAX_INDEX" book         \ max clients
        MAX_INDEX 1 null "RTAB" book \ gets values from TELNETD_CONNECT
      ]
      NTRACE
      IF " ROUTER: receive from socket" . dup (nS) .i
         " send on socket" . RTAB that pry (nSx) .i nl
      THEN

      (hT nS) RTAB swap pry (nSx)
      (hT nSx) remoteputf
   end

   inline: ROUTER1 (hT nS --- ) \ route bytes between client and telnetd
{     This word services all bytes received on the listening server
      defined by TELNETD.  

      Used for study, this word displays parsed escape sequences from
      vtparse3 (file vt.c).

      Run this phrase in the server window to redirect bytes through 
      ROUTER1, so parsed escape sequences can be viewed:
         "ROUTER1" ptr "TELNETD_CONNECT" "S1" yank ptrRun_upd
}
      2dup ROUTER

      dup "TELNETD_CONNECT" "S1" yank =
      IF drop (qT) -1 vtparse3 (qT) \ parse escape sequences
         " ROUTER1: output from vtparse3:" . nl (qT) 
         INF xray these rows 8000 < not
         IF drop " volume is too big to display" (qS) THEN . nl
      ELSE 2drop
      THEN
   end

   inline: TELNET_CLIENT_CLOSE (nS1 --- ) \ close S of pair (S,S1)
\     This word is run by clientclose().
      "ROUTER" "RTAB" yank swap (S1) pry (nS) sclose 
   end

{" Gather the following infix and parse it to postfix:

function TELNETD(P) // start the program's telnetd server
/* This function sets up the program SERVER to be a telnetd server to 
   clients connecting.  

   Listens on next available port, P or higher.

   Word ROUTER is set to handle bytes between Unix telnetd and clients.

   Finally, SERVER is started to listen for clients connecting to be
   routed to the Unix telnetd server.

   Example.

   This starts the program in TELNETD server mode:
      /home/dale % tops
               Tops 3.0.1
      Sat Sep  3 18:26:07 PDT 2005
      [tops@clacker] ready > "term.v" "Server Words" msource \
                              9877 TELNETD
        TELNETD: listening on port 9879

   In another window, the Unix telnet client can be connected to this 
   tops TELNETD server.  Below shows the telnet command to connect, and
   after connecting, running the cd and ls commands at the Unix prompt:

      /home/dale % telnet clacker 9879
      Trying 127.0.0.1...
      Connected to clacker (127.0.0.1).
      Escape character is '^]'.
      Red Hat Linux release 7.2 (Enigma)
      Kernel 2.4.7-10 on an i686
      login: dale
      Password:
      Last login: Sat Sep  3 18:24:26 from clacker
      You have mail.
      /home/dale % cd bin
      /home/dale/bin % ls
      dband*   label*  pppcon0* pppconE* xterm*      xterm_green*
      dtarin*  nclean* pppcon1* trim*    xterm1*     xterm_seashell*
      dtarout* pppcon* pppcon2* trscon*  xterm_blue*
      /home/dale/bin % 

   When the above is run with ntrace turned on in the TELNETD window, 
   every byte sent between telnet client and telnetd server is shown. */
{
// Setting up functions in SERVE_F (net.v), which is central to the
// program's server operations.

      SERVE_F.SERVICE = ptr("ROUTER"); // handle bytes from clients
      SERVE_F.TYPE    = 1;             // type TERM in drainf()
      new_client_timeout(60);          // connect timeout (sec)

   // As soon as a client connects, this function will start a 
   // telnetd daemon and connect this program to it:
      SERVE_F.ADDptr  = ptr("TELNETD_CONNECT"); // add connection

/* Starting the tops server if it is not already running. */

      if(serverport!=0) return;

      PORT = nextport(P); // next available port starting with P

      if(keys?) SERVER("*",PORT); 
      else DSERVER("*",PORT); 

      dot(" TELNETD: listening on port " + intstr(serverport));
}
"} >> parse main <<

   inline: TELNETD_CONNECT (nS --- ) \ connect telnetd network
{     This word is run by SERVE_F.ADD when a client first connects on
      socket S.  

      It starts a telnetd daemon, connects word ROUTER to it, and sets
      up socket array RTAB so that RTAB(S)=S1 and RTAB(S1)=S.

      Initial connection:

         telnet client ----S---> TELNETD_CONNECT

      Network with ROUTER in the middle:

        telnet client <---S---> ROUTER <---S1---> telnetd 
}        
      [
      { Since socket numbers S and S1 are small integers (and not equal
        to zero due to other sockets already defined), let each socket
        number be the index in the RTAB array in ROUTER.  This local 
        macro, VALID, checks these assumptions:
      } {" (nSocket --- nSocket) returns if valid, HALTs if invalid

           (nSocket) "ROUTER" "MAX_INDEX" yank
           that < that 0= or

           IF (nSocket) this sclose
              " TELNETD_CONNECT: socket number " swap intstr +
              " is invalid to use for an index" + ersys HALT
           THEN (nSocket)

        "} "VALID" macro
      ]
      (nS) VALID "S" book

      NTRACE
      IF " TELNETD_CONNECT: new client on socket" . S .i nl THEN 

    \ Running default SERVE_F.ADD:
      S "SERVE_F" "ADDdef" yank

    \ Start telnetd:
      IPloop TELNETD_START (nPort)

    \ Connect to telnetd Port on loopback:
      (IPloop nPort) "ROUTER" ptr CONNECT (nS1)
      (nS1) this -1 =
      IF " TELNETD_CONNECT: could not connect to telnetd" ersys HALT
      THEN

      (nS1) VALID "S1" book

    \ Set up ROUTER table RTAB for S <----> S1:
      S "ROUTER" "RTAB" yank (hRTAB) S1 poke \ RTAB(S1)=S
      S1 "ROUTER" "RTAB" yank (hRTAB) S poke \ RTAB(S)=S1

    \ Ptrs to words that clientclose() will run:
      "TELNET_CLIENT_CLOSE" ptr S1 ptrCls_upd
      "TELNETD_SERVER_CLOSE" ptr S ptrCls_upd
   end

   inline: TELNETD_SERVER_CLOSE (nS --- ) \ close S1 of pair (S,S1)
\     This word is run by clientclose().
      "ROUTER" "RTAB" yank swap (S) pry (nS1) sclose 
   end

\  TEL MARKER

   inline: TELNETD_START ( --- nPort) \ start telnetd, return its Port
{     Start a telnetd daemon and return the number of the Port on which
      it is listening.

      Uses standard telnet port 23 if system telnetd is running.

      Returns Port=-1 if required file telnetd_init is not found.

      Files for a telnetd daemon are in usr/telnetd/.  They are used
      beforehand to create the telnetd daemon for this program. 

      Also a wrapper program, telnetd_init, that allows a user to start
      a telnetd daemon, must be created.  See usr/telnetd/README.

      This word runs the wrapper program in a shell command of the form:
         telnetd_init PORT
      to start a telnetd daemon listening on the next available PORT.

      Word running waits for the telnetd daemon to start, using default
      time out of 30 seconds (word expectout),
}
    \ If the aix system telnetd is running, use it:
      os "aix" =
      IF "telnet" port_listening
         IF 23 "PORT" book
            " TELNETD_START: telnetd is listening on port" . PORT .i nl
            PORT return
         THEN
      THEN

      "telnetd_init" filefound not
      IF " TELNETD_START: cannot find telnetd_init" . nl -1 return
      THEN (qInit) spaced

      time "t0" book

      9923 nextport (nPort) dup "PORT" book intstr (qPort)
      (qInit qPort) + " &" + (qScript) running 

      IF time t0 less "%0.2f" format
         " TELNETD_START: telnetd start up (sec): " . . nl
         " TELNETD_START: telnetd is listening on port" . PORT .i nl
         PORT
      ELSE
         " TELNETD_START: telnetd start up failed" . nl -1
      THEN
   end

   private halt

   End of Server Words.
