\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

\  File task.v  March 2000

\  Copyright (c) 2000-2014   D. R. Williamson
{
------------------------------------------------------------------------

   Contents:

      How to gather names for contents:
         syspath "task.v" + asciiload this " inline:" grepr reach dot
         syspath "task.v" + asciiload this " function " grepr reach dot

   Words
   inline: task_on (qS --- f) \ f true if S is a running TASK or ALARM

   Multitasker queuing system
   Queuing system words
   inline: QHALT (f --- ) \ set flag QHALT to f in word queue_halt
   inline: queue_add (nPtr --- ) \ add task word ptr to the queue list
   inline: queue_add1 (nPtr --- ) \ add task word Ptr to the queue list
   inline: queue_clr ( --- ) \ clear the queue
   inline: queue_halt ( --- ) \ stop the queuing system
   inline: queue_len ( --- n) \ current length of the queue
   inline: queue_run ( --- ) \ run the first task in the queue
   Queuing example

   Remote queuing system words
   inline: rmtqueue_add (hT nS --- ) \ add task T to the remote queue
   inline: rmtrun_make (hT nS --- nPtr) \ make a macro to run T on S
   inline: svrqueue_add (hT --- ) \ add remote task T to queue list
   inline: svrqueue_rm (nS --- ) \ make inactive the macro for S
   Remote queuing example
   A remote queuing system in action
   Plot of performance versus time

   Multitasker Demo
   inline: remind ( --- ) \ display time and message
   inline: scan ( --- ) \ sourcing task file if found
   inline: scanning ( --- ) \ start scanning at 8 Hz
   inline: -scanning ( --- ) \ stop scanning

   Appendix
   Words added by sourcing this file
   Note on word QHALT
   Making a printer plot of remote server queuing performance

------------------------------------------------------------------------
}
   CATMSG push no catmsg

 \ Words

   inline: task_on (qS --- f) \ f true if S is a running TASK or ALARM
    \ Thu Dec 26 05:39:55 PST 2013

    \ Returns f equal to true if S is in the multitasker's list and it 
    \ is a running TASK (not asleep) or an ALARM.

    \ If f is false, either S is not in the list or S is a TASK and it 
    \ is asleep.

      "tasks" >stk (hT) dup rows 1 >
      IF (qS hT) \ look for S in list T of multitasker tasks
         swap plop (hT qS) grepr (hT hR) any?
         IF (hT hR) reach (hT) dup "task running" grepr rows 0>
            IF (hT) drop true                      \ have running TASK
            ELSE (hT) "alarm period" grepr rows 0> \ true if ALARM
            THEN (f)
         ELSE (hT) drop false \ S is not in list T
         THEN (f)
      ELSE (qS hT) 2drop false \ single row T says "No tasks defined."
      THEN (f)
   end
{
------------------------------------------------------------------------

   Multitasker queuing system, January 2008

   This queuing system works like the meter on a freeway on ramp.  

   Asynchronous tasks accumulate in a queue and are started one at a 
   time by the multitasker at a periodic rate.  Tasks in the queue are 
   ones that should be run as soon as possible, just like every car 
   waiting at a freeway on ramp would like to quickly get going.

   Word queue_add puts a task into the queue, and word queue_run runs 
   the oldest one.  When queue_run is a TASK in the multitasker, tasks 
   accumulating in the queue are run periodically, as shown in the 
   example below.

   Word queue_clr clears all tasks from the queue without running any, 
   and word queue_len shows the current backlog in the queue.

   Background.  A queuing capability was developed to level the load 
   on the machine in an application that runs various tasks every few 
   minutes on randomly set multitasker ALARMs.  

   Clashes can occur when several ALARMs happen to go off at about the 
   same time and each starts a time consuming task (of more than several
   seconds).  

   Using the queue, when ALARMs go off they now run queue_add and add 
   their tasks to the queue instead of starting them.

   Then queue_run, running at a low enough frequency (set by the multi-
   tasker RATE that is defined for task queue_run), will start a queued
   task at a rate that allows one task to finish, or nearly finish, be-
   fore the next one is started.

   File snd.v uses an adaptation of this queuing system to play sound 
   files: words wavque_add, wavque_play, wavque_clr and wavque_start.  

   That system differs from this one because the next wait in the queue
   depends upon the duration of the sound file currently playing, since
   two sound files cannot be played at the same time.  

   The purpose of the sound file queuing system is not to level the 
   load, but to control the playing of different voice files so they 
   run in close succession at times when everyone is trying to talk at
   once (see test/tsnd1 for a demo of voices and test/tsnd2 for a demo 
   of the sound file queuing system applied to resonating gongs played
   one after another).

------------------------------------------------------------------------
}
\  Queuing system words

   inline: QHALT (f --- ) \ set flag QHALT to f in word queue_halt
      (f) "queue_halt" "QHALT" bank
   end

   inline: queue_add (nPtr --- ) \ add task word ptr to the queue list
    \ Ptr is the ptr to a word in the catalog that runs a task.  The 
    \ stack diagram of a task word is ( --- ).
      (nPtr) dup ptr? 
      IF (nPtr) "queue_run" "add" localrun ELSE (nPtr) drop THEN
   end

   inline: queue_add1 (nPtr --- ) \ add task word Ptr to the queue list
    \ Mon Jun  8 05:46:20 PDT 2009

    \ Ptr is the ptr to a word in the catalog that runs a task.  The 
    \ stack diagram of a task word is ( --- ).

    \ This word adds Ptr to the queue if it is not already in the queue.

      (nPtr) dup ptr? 
      IF "queue_run" "queue" yank (hQ) any? (f)
         IF (hQ) yes sort over bsearch (r f) lop (f)
         ELSE no (f)
         THEN

         (nPtr f)
         IF (nPtr) drop                         \ yes, already in queue
         ELSE (nPtr) "queue_run" "add" localrun \ no, add to queue 
         THEN
      ELSE (nPtr) drop
      THEN
   end

   inline: queue_clr ( --- ) \ clear the queue
    \ The queue is a column vector of ptr numbers stored oldest first.
      0 1 null (hQ) "queue_run" "queue" bank
      yes QHALT
   end

   inline: queue_halt ( --- ) \ stop the queuing system
{     Remove queue_run from the multitasker tasks list if it is there.

      Word HALT() (ctrl.c) runs this word when there is a call to HALT,
      to stop continuous queuing when the system is broken.

      Running "no QHALT" will prevent halting the queuing system when-
      ever HALT runs.  But note that when queue_clr runs, it resets to 
      "yes QHALT."
}
      [ yes "QHALT" book ] \ default action is to halt queuing
      QHALT 
      IF "tasks" >stk "queue_run" grepr rows any \ looking in tasks list
         IF "queue_run" OMIT
            " queue_halt: queuing system task is omitted " date + . nl
         THEN
      THEN
   end

   inline: queue_len ( --- n) \ current length of the queue
      "queue_run" "queue" yank rows
   end

   inline: queue_run ( --- ) \ run the first task in the queue
    \ Runs the first task, then removes it from the queue. 
      [ 0 1 null (hQ) "queue" book 
        '(n) queue (hQ) swap pile "queue" book' "add" macro
      ]
      LOCKED IF return THEN
      queue (hQ) any?
      IF (hQ) @ (n) exe     \ execute the first task ptr in queue
         0 queue !          \ zero the first task ptr
         queue dup rake lop \ rake out the zeroes from queue
         (hQ) "queue" book  \ book the shortened queue
      THEN
   end
{
------------------------------------------------------------------------

   Queuing example  

   Note: Backslash on the right of some lines are only for running this
   example interactively.  They allow the interpreter to process mul-
   tiple lines pasted interactively (by ignoring added new line charac-
   ters), and they are ignored when the program reads and runs commands
   from a file such as this one.

   >> if(missing("queue_add")) source("task.v");

   /* Each of these tasks runs something and then queues itself to \
      run again.  A multitasker word usually has ( --- ) for its   \
      stack diagram, as these words do.  For illustration, T1 and  \
      T3 are written as macros in postfix, and T2 is written as an \
      infix function: */

      macro("nl 'Running task 1' . 'T1' ptr queue_add", "T1");

      function () = T2() {                                         \
         nl;                                                       \
         dot("Running task 2");                                    \
         queue_add(ptr("T2"));                                     \
      }

      macro("nl 'Running task 3' . 'T3' ptr queue_add", "T3");

   /* Add ptrs of task words to the queue: */
      queue_add(ptr("T1"));
      queue_add(ptr("T2"));
      queue_add(ptr("T3"));

      TASK(1/3, "queue_run"); // run once every 3 seconds
      tasks; // shows queue_run is asleep

      WAKE("queue_run"); // start the queuing system
      tasks; // shows queue_run is running

      .(queue_run.queue); // display the queue (just ptr numbers)

   /* Run the following to stop this queuing system example: \
      SLEEP("queue_run"); // stop the queuing system         \
   */
}
\-----------------------------------------------------------------------

{  Remote queuing system words, March 2008.

   To each client and the server, simply connected on a TCP/IP socket,
   the other looks like a remote machine.  But of course the server and
   all the clients are on the same machine, since this purpose of queu-
   ing is to reduce workload on that machine.

   For a server running the queuing system, the following words allow
   tasks on remote clients (one task per client) to be queued on the
   server.  

   On the server, each client is given its own macro.  When a client's 
   turn comes, its task is started remotely by the server when it runs 
   the client's macro (which is called "__Srun" for client on socket S).

}
   inline: rmtqueue_add (hT nS --- ) \ add task T to the remote queue
{     This word is run by a client connected to a remote that is run-
      ning the queuing system, to have its task T queued.  

      This word remotely runs word svrqueue_add on the server.

      Add task T, a task that runs the program here, to the queue of 
      the server on socket S.  When its turn comes, the remote server
      will cause this program to run T.
}
      (hT) "svrqueue_add" (hT1) swap (hT hT1 nS) remoterun2
   end

   inline: rmtrun_make (hT nS --- nPtr) \ make a macro to run T on S
{     On this queuing server, make a macro that runs T on the client 
      connected on socket S.  

      This word is run automatically by word svrqueue_add when a remote
      client runs its rmtqueue_add, or it can be run by the server when
      a client connects if T is known ahead of time.

      Note that svrqueue_rm is set by ptrCls_upd to run when socket S
      closes.  If the server needs additional notification, it can bank
      a ptr into svrqueue_rm.PTR that will also be run.

      Returned Ptr is the ptr to the macro made, and is suitable for
      the task word ptr that is input to queue_add.

      Each socket, S, has its own macro called __Srun.  For example, 
      the macro for socket 12 is called __12run.  If there already is 
      a macro __12run, it will be reused by banking new task T.
}
      "__Srun" "S" other (qName qS nS) intstr strp (qM)
      (qM) "MAC" book \ macro name, like __5run

      MAC exists? not 
      IF CATMSG push no catmsg                    \ hide catalog msg
         "S -1 > IF T S remoterun THEN" MAC macro \ create macro
         pull catmsg                              \ reinstate CATMSG
      THEN

    \ Set, or reset, the function that is run when socket S closes:
      (nS) "svrqueue_rm" ptr over (ptr nS) ptrCls_upd

      (nS) MAC "S" bank \ set or reset socket S
      (hT) MAC "T" bank \ set or reset task T
      MAC ptr (nPtr)
   end

   inline: svrqueue_add (hT --- ) \ add remote task T to queue list
{     This word is run on the server running the queuing system.  It
      is run automatically when a remote client runs rmtqueue_add.

      Add a task to the queue that will run a macro to run T on the 
      remote currently connected.  The number of the socket now con-
      nected is given by word remotefd:
}     (hT) remotefd (hT nS) rmtrun_make (nPtr) queue_add
   end

   inline: svrqueue_rm (nS --- ) \ make inactive the macro for S
{     Socket S has closed.  Make its macro inactive by banking S = -1.

      Word rmtrun_make sets ptrCls to use this word, depriving the 
      server of ptrCls for its own use.  However, the server can bank
      a ptr to its word here, into PTR, and its word will be run the
      first thing when this word runs.  The stack diagram for the word 
      of PTR is 
      (nS --- ).
}
      [ 0 "PTR" book ]

    \ Execute server's PTR if it is a valid ptr (assume it will mess up
    \ the stack (at least until it is debugged), so don't try floating 
    \ nS on the stack):
      (nS) "S" book
      PTR ptr? IF S PTR exe THEN

      "__Srun" "S" S (qName qS nS) intstr strp "MAC" book
      -1 MAC "S" bank
   end

\-----------------------------------------------------------------------
{
   Remote queuing example.

   /* Run these lines in a "server" window, to start a server that   \
      is running the queuing system: */

   >> if(missing("queue_add")) source("task.v");
      SERVER("", 9890); // listening for CLIENTs on port 9890
      PLAY(1/3, "queue_run"); // run once every 3 seconds

   /* Run these lines in a "client" window, to perform task U that   \
      is queued by the remote server: */

   >> if(missing("queue_add")) source("task.v");

   /* Make task U that prints a line and then requeues itself: */    
      macro("nl 'U run by remote' . 'U' 'S' main rmtqueue_add", "U");

      S = CLIENT(IPloop, 9890); // connected to server on socket S
      rmtqueue_add("U", S); // queue macro U to be run by remote on S

   /* Run the following in the server window to stop the queuing     \
      system example:                                                \
      SLEEP("queue_run"); // stop the queuing system                 \
   */

\-----------------------------------------------------------------------

   A remote queuing system in action.  

   On the server, the following shows the queuing system running in the
   multitasker at 0.183 Hz (about once every 5.5 seconds) to run one of
   22 clients that continually queue up by running their rmtqueue_add.

   Each connected client queues an update task at random times, about 
   once every 120 seconds, so the queuing system RATE in the multitasker
   has been set to the average rate given by:

      RATE = 22 clients/120 seconds = 0.183 cycles/sec (Hz)

   Just letting these 22 jobs run their updates whenever required was
   causing tremendous load spikes on the machine.  With other jobs run-
   ning, machine workload levels during heavy times spiked above 25 and
   ran in the 15 to 20 level when levels of 1 to 5 were typical (a
   workload of 1, called a system load average, is equivalent to one
   user running the CPU for the past minute).

   With queuing, these clients join the queue by running rmtqueue_add
   and wait their turn instead of running their update immediately.  
   Machine workload dropped significantly, and continuous whirring of 
   the disk ceased, apparently because job swapping stopped.  A printer
   plot below compares performance before and after.

   At the average queuing rate (0.183 Hz), the queue length was observed
   to vary from 0 to 2 jobs typically waiting to run, and some cases of
   7 or more jobs waiting (which is much better than 7 jobs trying to 
   run at once).  Since the average rate will hold over time, the queue
   must eventually empty out.

   For simple repetitive (periodic) tasks like these, this shows it is 
   better to use a queuing system that lines them up and runs one after
   the other, rather than to make the kernel try and figure out how to 
   schedule them when nearly all hit at once.  

   This shows the queuing system running on the server at 0.183 Hz:
      [tops@plunger] ready > tasks
       Multitasker tasks:
        queue_run,0:CODE__ task running at 0.18333 Hz; tics remaining 15

   This shows the 22 clients connected to the server for queuing:
      [tops@plunger] ready > clients
       Server local is listening on port 9878
       Clients:
        socket 6, port  1105, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 7, port  1106, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 8, port  1109, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 9, port  1111, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 10, port  1112, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 11, port  1114, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 12, port  1117, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 13, port  1118, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 14, port  1119, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 15, port  1123, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 16, port  1124, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 17, port  1125, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 18, port  1126, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 19, port  1131, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 20, port  1135, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 21, port  1136, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 22, port  1140, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 23, port  1149, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 24, port  1150, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 25, port  1151, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 26, port  1152, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 27, port  1153, conn S<C, 127.0.0.1 LOGIN dale plunger

   This shows the macros created for each client by rmtrun_make when 
   it was run by svrqueue_add.  Each macro is running the phrase

      "S -1 > IF T S remoterun THEN"

   to run T on socket S remote if S is valid (see rmtrun_make).  The
   phrase becomes 13 4-byte addresses (52 bytes total) when assembled 
   into an inline (which is all a macro is):
      [tops@plunger] ready > whos
       Stack items and words added to the main library:
        Name       Rows Cols Bytes Type  Description
        __10run    13   1    52    PTR   inline
        __11run    13   1    52    PTR   inline
        __12run    13   1    52    PTR   inline
        __13run    13   1    52    PTR   inline
        __14run    13   1    52    PTR   inline
        __15run    13   1    52    PTR   inline
        __16run    13   1    52    PTR   inline
        __17run    13   1    52    PTR   inline
        __18run    13   1    52    PTR   inline
        __19run    13   1    52    PTR   inline
        __20run    13   1    52    PTR   inline
        __21run    13   1    52    PTR   inline
        __22run    13   1    52    PTR   inline
        __23run    13   1    52    PTR   inline
        __24run    13   1    52    PTR   inline
        __25run    13   1    52    PTR   inline
        __26run    13   1    52    PTR   inline
        __27run    13   1    52    PTR   inline
        __6run     13   1    52    PTR   inline
        __7run     13   1    52    PTR   inline
        __8run     13   1    52    PTR   inline
        __9run     13   1    52    PTR   inline
        ...

   The printer plot below shows the same busy 3 hour period before and 
   after implementing the server queuing system for the case of 22 jobs
   described above.  

   Data for the plot comes from sampling system workload every minute.
   System workload obtained with the Unix w command is written to file
   WORK.LOG, using word WORKLOAD running in the multitasker at 1/60 Hz.

   Points * are without the queuing system, and points + are with.

   The vertical axis shows workload times 10, and the peak workload
   before using server queuing is about 26.4 (due to quirkiness in
   printer plot quantization, that point is not displayed but the 
   next highest, 24.5, is shown).  

   All points after server queuing (+) are below workload of 5.0.  

   In the last half hour of the plot, the 22 jobs had been turned off
   since performance was so bad, and the * points near zero are not
   indicative of the period of bad performance.

   The phrases used to read the WORK.LOG file and make this plot are
   in the Appendix.

264
254
245                                                     *
235
226                                             *
217
207                                                    *
198
188
179                                              *
170
160                                       *    *      *
151
141                                   **
132
122                                               *
113                                  *  *
104                         *       *
94                                 *       *         *    *
85                           *                *     *    *
75                             *
66                   *        *          *   *     *
57                        **    *                          *
47  ++  + +**  * ***   *          *         *
38   *++ +*+ **     *            *                      +        +
28  * ** *  ++     ++ *  *+       + +++       +++++    + +        +
19      *     ++*++  +++*  ++++  + +   +++++++     ++++   +++++    ++
9                        +     ++                           *  *+    +
0                                                            ** ******
   Plot of performance versus time, before (*) and after (+) server 
   queuing (showing system workload times 10 over a 3 hour period)
}
\-----------------------------------------------------------------------

   pull catmsg halt

\-----------------------------------------------------------------------

{  Multitasker Demo.  March 2000

   Using the multitasker:

      Running the program in a window, scanning for a task to perform. 

      Communication is through a file of words that the program runs
      and then deletes.

   To make this window the task window, start the program and source 
   this region of this file by running the following phrase at the 
   ready prompt:

      'task.v' 'DEMO' msource

   This task window remains available for input from the keyboard too, 
   while it scans for its task file to source.
}
   DEMO

   inline: remind ( --- ) \ display time and message
\     Time displayed will change every five seconds.
      [ defname is Me, 0.9 is secs 
        host " task window ready ..." cat is msg 
      ] 
      systime$ (qTime) time integer five mod any 
      IF (qTime) drop 
      ELSE (qTime) spaced msg cat cr dot
      THEN secs Me ALARM ; \ after secs, call Me again

   inline: scan ( --- ) \ sourcing task file if found
      [ ".taskfile" is file ] 
      file filefound IF source file deleteif THEN ;

   inline: scanning ( --- ) \ start scanning at 8 Hz
      [ "scan" "file" extract is file ] file deleteif, ok off 
      eight (Hz) "scan" PLAY 
      "remind" its "secs" extract rose ALARM ; \ **
{ 
   ** Alarms are best scheduled last, after all tasks (scan is a task).
      See notes in function tasker(), term.c, and changes.doc, 5-11-02.
}
   inline: -scanning ( --- ) \ stop scanning
      "scan" SLEEP, "remind" -ALARM ;

   {" Here are some instructions displayed at start up: 
     The task window is now running.

     In another window, called the command window, in the same sub-
     directory as this window, start the progaram and copy and drop 
     the following to make a shortcut called send that will send a 
     task to this window, called the task window:

        inline: send (qS --- ) ".taskfile" save ; \ assumes same subdir 

     Now to send a task to this task window from the command window, 
     enter in the command window:
        'phrase' send
     where phrase is any valid phrase not requiring user intervention. 

     Here are some examples to copy and drop into the command window:

        "1 2 + nl .i nl" send \ simple math

        "'math.v' source" send \ source a file

      \ Show multitasker tasks, including this one called scan:
        "nl tasks" send \ shows scan running

      \ Make a plot:
        "'sine' sourceof source" \
        " 1 10 2pi * 0 0.001 1000 sine plot" cat send

      \ Close the plot: 
        "plotclose" send 

     To close the task window, say:
        'nl bye' send
   "} -4 indent nl . nl \ displaying this text

   scanning \ starting the multitasker

   private halt

\-----------------------------------------------------------------------

;  Appendix

------------------------------------------------------------------------

   Words added by sourcing this file

      Does not include words added after November 30, 2012.

      [dale@plunger] /home/dale > tops
               Tops 3.2.0
      Fri Nov 30 12:04:24 PST 2012
      [tops@plunger] ready > 'task.v' source

      [tops@plunger] ready > whos
       Words added to the main library:
        Name         Rows Cols Bytes Type  Description
        QHALT        5    1    20    PTR   inline
        queue_add1   31   1    124   PTR   inline
        queue_add    12   1    48    PTR   inline
        queue_clr    10   1    40    PTR   inline
        queue_halt   20   1    80    PTR   inline
        queue_len    6    1    24    PTR   inline
        queue_run    21   1    84    PTR   inline
        rmtqueue_add 5    1    20    PTR   inline
        rmtrun_make  35   1    140   PTR   inline
        svrqueue_rm  22   1    88    PTR   inline
        svrqueue_add 5    1    20    PTR   inline
                               688   total

      [tops@plunger] ready > 

   Note on word QHALT

      [tops@plunger] ready > man QHALT
       Entry for QHALT:
        QHALT (f --- )
        set flag QHALT in word queue_halt
        usage: running "no QHALT" will prevent halting the queuing
          system whenever HALT() runs; but note that when queue_clr
          runs, it resets to "yes QHALT"
        related: tasks, HALT, queue_halt, queue_clr, queue_add,
          queue_len, queue_run
        category: multitasker, program control
        defined: task.v

      [tops@plunger] ready > 

------------------------------------------------------------------------

   Making a printer plot of remote server queuing performance

This shows the phrases used to read a workload log file and make the
printer plot shown above for remote server queuing performance.

\  Read the workload file:
   "WORK.LOG" asciiload notrailing "W" book
{

This is the form of workload display captured in WORK.LOG, from the
w command in Linux RH 7.3 (see man w).  It matches the first line in 
the top command and the line that is output by uptime, and differs 
from the style for Debian Linux shown beyond.

Mon Mar 31 1:00am up 10:06, 1 user, load average: 4.57, 4.53, 4.04
Mon Mar 31 1:01am up 10:07, 1 user, load average: 4.18, 4.44, 4.04
Mon Mar 31 1:02am up 10:08, 1 user, load average: 5.05, 4.54, 4.09
Mon Mar 31 1:03am up 10:09, 1 user, load average: 4.44, 4.49, 4.10
Mon Mar 31 1:04am up 10:10, 1 user, load average: 2.88, 4.02, 3.96
Mon Mar 31 1:05am up 10:11, 1 user, load average: 3.99, 4.01, 3.95
Mon Mar 31 1:06am up 10:12, 1 user, load average: 3.77, 3.94, 3.93
Mon Mar 31 1:07am up 10:13, 1 user, load average: 2.93, 3.69, 3.84
Mon Mar 31 1:08am up 10:14, 1 user, load average: 2.42, 3.40, 3.73
Mon Mar 31 1:09am up 10:15, 1 user, load average: 4.07, 3.78, 3.85
Mon Mar 31 1:10am up 10:16, 1 user, load average: 3.31, 3.67, 3.80

Workload display in the same time period from another machine running 
Debian Linux is shown below.  The display is superior in at least two 
ways: it uses 24 hour time, and it shows the nearest second.  The script
below for RH 7.3 needs a step to separate am from pm since RH 7.3 does 
not use 24 hour time.  Not having time to the nearest second is not an
issue here, but there have been cases where it would be useful to gauge
timing.

Mon Mar 31 01:00:41 up 162 days, 17:37, 0 users, load average: 0.29, 0.26, 0.19
Mon Mar 31 01:01:40 up 162 days, 17:38, 0 users, load average: 0.15, 0.22, 0.18
Mon Mar 31 01:02:40 up 162 days, 17:39, 0 users, load average: 0.50, 0.29, 0.20
Mon Mar 31 01:03:39 up 162 days, 17:40, 0 users, load average: 0.20, 0.24, 0.19
Mon Mar 31 01:04:39 up 162 days, 17:41, 0 users, load average: 0.32, 0.26, 0.19
Mon Mar 31 01:05:38 up 162 days, 17:42, 0 users, load average: 0.18, 0.22, 0.18
Mon Mar 31 01:06:37 up 162 days, 17:43, 0 users, load average: 0.06, 0.18, 0.17
Mon Mar 31 01:07:37 up 162 days, 17:44, 0 users, load average: 0.08, 0.16, 0.16
Mon Mar 31 01:08:36 up 162 days, 17:45, 0 users, load average: 0.03, 0.13, 0.15
Mon Mar 31 01:09:36 up 162 days, 17:46, 0 users, load average: 0.22, 0.19, 0.17
Mon Mar 31 01:10:35 up 162 days, 17:47, 0 users, load average: 0.31, 0.22, 0.18
}

\  Parse W for the hours 1, 2 and 3 am on Fri Mar 28:
   W W "Fri Mar 28 1:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach
   W W "Fri Mar 28 2:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach
   W W "Fri Mar 28 3:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach

   3 pilen "B" book \ before

\  Parse W for the hours 1, 2 and 3 am on Mon Mar 31:
   W W "Mon Mar 31 1:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach
   W W "Mon Mar 31 2:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach 
   W W "Mon Mar 31 3:" grepr reach dup "am" grepr reach
   "day," " " strp 12 word drop numerate 1st 60 items reach 

   3 pilen "A" book \ after

   B A park "P" book \ before in column 1, after in column 2

\  Pplot misses peaks depending upon plot width NX (it probably needs
\  to be worked on); 65 almost catches the peak and total plot width 
\  including vertical axis numbers, is under 72.
   65 "pplot" "NX" bank \ pplot.NX = 65
   P 1st P rows items pplot "PLOT" book

\  Make lookup table for Y axis value:
   list: 0 PLOT rows 1- ;
   list: 0, P maxfetch 2drop 10 * ;
   park "XY" book

\  Look up Y axis values to show on left of plot:
   XY 0 PLOT rows items lerp 
   reversed itext chop spaced (hTEXT)

\  Print the plot:
   (hTEXT) PLOT park (hT) .

------------------------------------------------------------------------
