\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}

{ File netbp.v  April 2002

   Copyright (c) 2002   D. R. Williamson

   Words for back-propagation networks that use native word stepping 
   (file wapp.c).
}
\-----------------------------------------------------------------------

   inline: makeNet (qNet hUnits --- ) \ creating network word Net
{     Incoming Net is the network name, and Units is an N-length vector 
      that gives the number of units in each of N layers.

      The word that makeNet creates completely defines a back-propaga-
      tion network for training with native word stepping, by making 
      all necessary matrices in the new word's local library.  

      Matrices created remain to be initialized before training can 
      begin.

      When the network word is fired, it puts its name on the stack, to
      be used as a handle for other words that access its local library
      during initialization, training, and later use.
}
      (hUnits) "Units" book, Units rows are Layers
      (qNet) "Net" book

      Net net? IF Net purgeNet THEN \ free old arrays

\     Making new word in main library with name given by string Net. 
\     The word's action will be to put its defname on the stack when 
\     it runs:
      "[ defname 'Net' book, 'net?' 'Magic' yank is net_magic ] Net"
      Net inlinex

\     Done.  Also created in the new word was net_magic, to use later
\     for authentication.

      Units Net "Units" bank \ install list of units in each layer

      Units 1st pry one null Net "NetIn" bank            \ inputs
      Units its rows ndx pry one null Net "NetGoal" bank \ output goal

\     Next, creating network arrays and banking them into the new word:
      "Out" Omat (hPtr) Net "Out" bank \ layer output matrices
      "W"   Wmat (hPtr) Net "W"   bank \ layer weight matrices
      "dW"  Wmat (hPtr) Net "dW"  bank \ layer delta weight matrices

\     Network learning parameters:
      UDEF Net "Alpha" bank
      UDEF Net "Eta" bank

\     New network word is complete.  Initialization of arrays is still 
\     required.

\     Utilities Omat and Wmat that bank matrices into the new word:
      [
        {" Omat (qA --- hO) \ O is list of ptrs to layer output matrices
         { The eight columns of an output matrix for a layer contain:
              1: values of each output unit
              2: gradient of each output value
              3: unit function type (see note below)
              4: sigmoid decay constant, a, for each unit
              5: sigmoid bias, b, for each unit
              6: sigmoid bias change, db, for each unit
              7: input to units (for debugging)
              8: output unit error during last stepping (for debugging)

              Note: Unit function types:
                 0: exponential function, 0 to 1 range
                 1: exponential function, -1 to +1 range
                 2: linear function
         }
         \ If qA name is "Out," then output matrices have names like 
         \ Out1, Out2, ..., OutN for layers 1 - N.
         (qA) push
         list: \ making output matrices and a list of their ptrs:
            Layers 1st \ output matrices banked into word Net:
            DO Units I pry eight (r c) null Net peek I qdx suffix bank
               Net peek I qdx suffix localref ptr
            LOOP pull drop
         end (hO)
        "} "Omat" inlinex

        {" Wmat (qA--- hW) \ W is list of ptrs to weight-sized matrices
         \ If qA is "dW," then weight matrices have names like dW1,
         \ dW2, ..., dWN for layers 1 - N.
         (qA) push
         list: Layers 1st \ making weight matrices and a list of ptrs:
            DO Units I pry (r) \ weight matrices banked into word Net:
               I 1st = IF one (c) ELSE Units I 1- pry (c) THEN (r c)
               (r c) null Net peek (qA) I qdx suffix bank 
               Net peek (qA) I qdx suffix localref ptr
            LOOP pull drop
         end (hW)
        "} "Wmat" inlinex
      ]
   end

   inline: net? (qNet --- f) \ true if stack item is a network
      [ "net_magic" is Mname, 99 is Magic ] 
      no STR stkok not IF drop no return THEN

      (qNet) this Mname localref exists?
      IF (qNet) Mname yank Magic = ELSE (qNet) drop no THEN
   end

   inline: netprops (qNet --- ) \ display properties of Net
\     For back-propagation networks modeled by word makeNet.
\     This is a snapshot of the network in its current state.
\     NOTE: some values may still be undefined if the network 
\     has not been stepped forward and back propagated.

      this net? not IF " not a network: " . . return THEN
      "Net" book
      nl

      " Properties of network " . Net . nl
      nl

      " Units per layer: " . Net "Units" extract
      "%5.0f" format vol2str crowd . nl
      nl

      " Learning constants: " .
      "Alpha" Net that extract swap . sp "%8.4f" format strchop . sp sp
      "Eta"   Net that extract swap . sp "%8.4f" format strchop . sp sp
      nl nl

      " Network input: " . Net "NetIn" extract bend nl .m nl
      nl

      " Network target: " . Net "NetGoal" extract bend nl .m nl
      nl

      " Output matrix cols: " 
      "value,grad,utype,decay,bias,dbias,input,error"
      cat . nl
      " Notes:" . nl
      "    Outputs may not apply to Network input and target shown" . nl
      "    Input and error cols are null if compiled with DEBUG=0" . nl
      Net "Out" extract these rows 1st
      DO " Output layer" . I .i dup I pryexe nl .m nl LOOP
      drop nl

      Net "W" extract, these rows 1st
      DO " Weights in layer" . I .i dup I pryexe nl .m nl LOOP
      drop nl

      Net "dW" extract, these rows 1st
      DO " Delta weights in layer" . I .i dup I pryexe nl .m nl LOOP
      drop
   end

   "onet" "value,grad,utype,decay,bias,dbias,input,error" struct

   inline: purgeNet (qNet --- ) \ freeing the arrays of Net
      this net? not IF " not a network: " . . return THEN

      (qNet) "Net" book

      purged Net "Units" bank   \ list of units in each layer
      purged Net "NetIn" bank   \ network inputs
      purged Net "NetGoal" bank \ output goal

\     Freeing the arrays in the pointer lists of word Net:
      Net "Out" yank freeing \ layer outputs
      Net "W" yank freeing   \ layer weights
      Net "dW" yank freeing  \ layer delta weights

\     Freeing the pointer lists of word Net:
      purged Net "Out" bank \ list of output ptrs
      purged Net "W" bank   \ list of weight ptrs
      purged Net "dW" bank  \ list of delta weight ptrs

      no Net "net_magic" bank \ destroy the magic number

\     Utility used by this word:
      [ {" freeing (hA --- ) \ free ptrs in list A
           (hA) any? not IF return THEN these rows 1st
           DO purged that I pryexe named book LOOP drop
        "} "freeing" inlinex
      ]
   end

   private halt   
