>> 
function (C) = indexed_add(A,B) {
{# man entry:  indexed_add {{{2
# (hA hB --- hC) Add two dense, internally indexed matrices.
# category: math::matrix::operator
# related:  inflate, index_merge
# 2}}}
#}

(A_row_idx, A_col_idx) = get_idx(A);
(B_row_idx, B_col_idx) = get_idx(B);

(A_row_align, B_row_align) = index_align(A_row_idx, B_row_idx);
(A_col_align, B_col_align) = index_align(A_col_idx, B_col_idx);
(B_row_map, row_merged)    = index_merge(A_row_idx, B_row_idx);
(B_col_map, col_merged)    = index_merge(A_col_idx, B_col_idx);

C_nRows = rows(row_merged);
C_nCols = rows(col_merged);

C = inflate( A, items(1,rows(A)), items(1,cols(A)), C_nRows, C_nCols) +
    inflate( B, B_row_map       , B_col_map       , C_nRows, C_nCols);

}
