\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2011  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{  File clu.v  June 2003

   Copyright (c) 2003   D. R. Williamson

   Processing on a cluster 

   Using TCP/IP networking to communicate with instances of this program
   running on the nodes of a cluster.

   Functions for networking are located in src/term.c, src/net.c, and 
   sys/net.v.

   These appendices follow the words for clusters:

      Appendix A: Make-pi demo.

      Appendix B: Running the Make-pi demo on a cluster or on a serial
         machine.

      Appendix C: Words for networking machines as a cluster.

      Appendix D: Running the Make-pi demo on networked machines.

   Script file cluster in tops/test runs the Make_pi demo standalone.  
   But the file can also be run interactively so that the node windows 
   it creates can be used to develop other words for a cluster.
}
\-----------------------------------------------------------------------

   "CONNECT" missing 
   IF " words for networking are missing (use compiler switch -DNET)" 
      . nl halt 
   THEN 

\-----------------------------------------------------------------------
{
   Words for nodes.

   Words in this section run scripts, also created in this section, that
   manage this program's code on the nodes of a cluster.  

   These words are run by this program running on the head node of the 
   cluster.  The head node is number 0, and nodes are numbered starting
   at 1.

   Path and names in the following three words will be made to apply to
   a specific cluster and user in the lines following the creation of 
   these words.  

   They will be specialized to a particular cluster and user by banking
   specific names into the local libraries of the words.  File myclu.v 
   can be used to supply specific names (see template usr/myclu.v) or
   the names can be added below by editing this file.
}
   inline: $node ( --- qPRE) \ prefix of any node on the cluster
\     The name of a node on the cluster is its number preceded by the 
\     string provided by this word.  See word node_name.
\     Example: if PRE=msca, and number=8, then name=msca08.
      [ "noname" "NodePrefix" book ] NodePrefix ;

   inline: $NODE ( --- qNODE) \ user's home directory on any node
\     The home directory name of the user on any of the cluster nodes:
      [ "noname" "UserNodeHome" book ] UserNodeHome ;

   inline: $HOME ( --- qS) \ user's home directory on the head node
\     The home directory name of the user on the head node:
      [ "nopath" "UserHeadHome" book ] UserHeadHome ;

\  Specializing words $node, $NODE, and $HOME for a particular cluster
\  and user by banking names into their libraries. 

   usrpath "myclu.v" catpath file? \ put info on this file
   IF usrpath "myclu.v" catpath "My cluster." msource

   ELSE \ or put info right here in this file:
      "msca"          "$node" "NodePrefix"   bank
      "/scratch/user" "$NODE" "UserNodeHome" bank
      "/home/user"    "$HOME" "UserHeadHome" bank
   THEN

\  The words below use words $node, $NODE, and $HOME, specialized as
\  above for a particular cluster and user, to set up scripts for run-
\  ning the cluster.

   inline: node_code ( --- ) \ gather program code that every node gets
      [ \ Code gathered is placed in directory ~/topsnode/.
        {"
           #!/bin/bash
           # Place code that every node will use in directory topsnode/.
           HOME=
           cp -p $HOME/tops/src/tops    $HOME/topsnode/src
           cp -p $HOME/tops/usr/ukey.v  $HOME/topsnode/usr
           cp -p $HOME/tops/usr/uboot.v $HOME/topsnode/usr
           cp -p $HOME/tops/usr/tserv   $HOME/topsnode/usr
           # Write over previous if a custom one exists in mytops:
           cp -p $HOME/mytops/usr/tserv $HOME/topsnode/usr
           cp -p $HOME/tops/sys/*.v     $HOME/topsnode/sys
        "} chop (hT)
        (hT) "HOME=" "HOME=" $HOME cat qreplace (hT) "CODE" book
      ] CODE (qS) shell
   end

   inline: node_copies (N --- ) \ copy this program's code to N nodes
      (N) qdx 1 DO I node_copy LOOP
   end

   inline: node_copy (n --- ) \ copy this program's code to node n
{     Copying program directories to node n, into directory called tops.

      Example shell script created and run by this word for n=1024:
         HOME=/home2/dwil; 
         NODE=/home/dwil; 
         rcp -p $HOME/topsnode/ -r msca1024:$NODE/tops
}
      [ "HOME=" $HOME "; " cat cat
        "NODE=" $NODE "; " cat cat cat
        "rcp -p $HOME/topsnode/ -r " cat "COPY" book
      ]
      this (n) node_destroy
      COPY swap node_name strchop cat ":$NODE/tops" cat (qS)
      shell
   end

   inline: node_destroy (n --- ) \ destroy this program's code on node n
{     Destroying directory called tops on node n.

      Example shell script created and run by this word for n=1024:
         NODE=/home/dwil; 
         rsh -n msca1024  /bin/rm -r $NODE/tops
}
      [ "NODE=" $NODE "; rsh -n " cat cat
        "NAME_XXXX /bin/rm -r $NODE/tops" cat "DESTROY" book 
      ]
      DESTROY "NAME_XXXX" rot node_name replace$ (qS) 
      shell
   end

   inline: node_name (n --- qS) \ the host name of node n
\     Creates the name for node n on the cluster using the prefix from
\     word $node.  Example: if $node=msca, and n=8, then S=msca08.
      $node swap (n) "%02.0f" format cat ;

   inline: node_start (n pro --- ) \ start background program on node n
{     Tue Mar 15 14:13:25 PDT 2011.  Allow SSL connections.

      Runs script usr/tserv located on node n, which starts this program
      running in background and listening as a server.

      For a single processor node, pro is 1.
      For a dual processor node, pro is 1 or 2.

      Initial listening ports are defined as 9877 for pro=1, and 9878
      for pro=2.

      These port numbers are needed when connecting using word CLIENT,
      and may be changed by cluster_start if LAST_CLOSE < LINGER.

      For n=1024 and pro=1, here is an example shell script created and
      run by this word to start this program listening on a node using 
      script tserv:
         NODE=/home/dwil; 
         rsh -n msca1024  $NODE/tops/usr/tserv -port 9877  &
}
      [ "NODE=" $NODE "; " cat cat
        "rsh -n " "NAME_XXXX " cat cat
        "$NODE/tops/usr/tserv -port YYYYY SSL &" cat
        "RUN" book 
      \ Note: rsh -n in the above redirects input (STDIN) to /dev/null.

      \ Initial port numbers (may be reset by cluster_start):
           9877 "PORT1" book
           PORT1 1+ "PORT2" book
      ]
      (pro) 1 = IF PORT1 ELSE PORT2 THEN (p) "PORT" book

      RUN "NAME_XXXX" rot node_name replace$ (qS)
      (qS) dup $node tug 1st word drop "NAME" book
      "YYYYY" PORT (p) int$ strp (qS) 
      SSL_CONNECT IF "SSL" "-ssl" ELSE "SSL" "" THEN strp
      vol2str neat dup "command" book \ save command string for ref
      (qS) shell
   end

\-----------------------------------------------------------------------

{  General words for a cluster.

   These words for a cluster are needed only in the library of the head 
   node.  

   The cluster nodes on machines running this program, started by the 
   head node, do not require any cluster words, even when they are in-
   terconnected to each other by word cluster_interconnect.
}
   inline: >node (nSocket --- nNode) \ socket num to cluster node num
\     Assumes socket numbers are in ascending order (for binary search)
\     as they are assigned in the loop of cluster_connect.

      "cluster_connect" "SOCK" yank any?
      IF swap bsearch
         IF qdx \ 1-based index
         ELSE " >node: socket number not found" . nl no
         THEN (nNode)
      ELSE drop " >node: cluster is not connected" . nl no
      THEN (nNode)
   end

   inline: cluster_ack ( --- f) \ all nodes acknowledge connection
      localsockets remoteack (f)
      "remoteack" "ACK" yank "ACK" book
   end

   inline: cluster_close ( --- ) \ close the cluster nodes
{     Connections made by word cluster_connect, tying the head node to
      all the nodes, will be closed and instances of this program run-
      ning on all the nodes will exit.

      Additional connections made by word cluster_interconnect, tying
      every node to all the other nodes, will also be closed.

      Word sclose, using function clientclose() of term.c, takes steps
      for an orderly shutdown of each connection to ensure that no port
      is left lingering because the server end of a connection is closed
      instead of the client end.

      It takes a number of seconds when there are many nodes to close, 
      and word clients may briefly show some sockets still connected.

      Cluster shutdown will not be clean if a server exits before its
      clients have closed their connections.  This will leave the lis-
      tening port used by the server in a lingering (TIME_WAIT) state.  

      Running cluster_start again for ports in the TIME_WAIT period will
      produce errors.  The TIME_WAIT period can be from 1 to 15 minutes
      depending upon the way the operating system has been set up.

      To account for TIME_WAIT, the time of close, LAST_CLOSE, is banked
      into cluster_start in the phrases below.  When cluster_start runs
      again and not enough time (about 900 seconds) has elapsed between
      LAST_CLOSE and the new start time, the port numbers are nudged 
      higher.
}
      localsockets any?
      IF (hS) these rows 1st
         DO this I pry (S) 
            "remotefd sclose one 'exit' ALARM" 
            that remoterun \ the program running on node I will exit
            (S) MAXBLOCK BLOCK
         LOOP (hS) drop
         time "cluster_start" "LAST_CLOSE" bank
      THEN
      cluster_initialize
   end

   inline: cluster_connect ( --- ) \ connect to running cluster nodes
\     Tue Mar 15 14:13:25 PDT 2011.  Allow SSL connections.

\     Connecting the head node to all the cluster nodes that were 
\     started by word cluster_start and are now running this program
\     and listening as servers.
      [ no "HOST" book ]

      SSL_CONNECT "SSLflag" book

      "cluster_start" "JOBS" yank (hT) any?
      IF (hT) dup 1st word drop "HOST" book
         (hT) 2nd word drop numerate "PORT" book
         list:
            HOST rows 1st 
            DO SSLflag IF yes ssl_connect THEN
               HOST I quote IPhost PORT I pry CLIENT (nS)
            LOOP
         end "SOCK" book
      ELSE " cluster_connect: cluster is not running" . nl 
      THEN
   end

   inline: cluster_finger ( --- hT) \ run Unix finger on all nodes
      "finger" cluster_run (hT) cluster_ack (f)
      IF localsockets rows 1st
         DO localsockets I pry remoteget LOOP
         localsockets rows pilen "_cluster_finger" naming
      ELSE " cluster_finger: cluster acknowledgement failed" ersys
      THEN
   end
{
\  This version of cluster_finger is much faster, but entries are in 
\  random socket order.
  _inline: cluster_finger ( --- hT) \ run Unix finger on all nodes
      depth push
      "finger remotefd remoteput" cluster_run1
      depth pull less
      pilen "_cluster_finger" naming
   end
}
   inline: cluster_initialize ( --- ) \ initialization tasks
      "" "cluster_start" "JOBS" bank   \ zero the jobs table 
      no "cluster_connect" "HOST" bank \ zero the connection table
      no "cluster_connect" "SOCK" bank \ zero the sockets table

      no "cluster_interconnect" "CONNECTED" bank
   end

   inline: cluster_interconnect ( --- ) \ connect node-to-node
{     Tue Mar 15 14:13:25 PDT 2011.  Allow SSL connections.

      Connect each cluster node to all the other ones.

      Run this word after running cluster_connect, and only on networks
      that allow node-to-node connection.

      Running this word produces all combinations of network intercon-
      nections:  

         node 1 to nodes 2 3 4 5 6 ... N
         node 2 to nodes 3 4 5 6 ... N
         ...
         node N-1 to node N

      in addition to the connections already made to the head node (0)
      by word cluster_connect:

         node 0 to nodes 1 2 3 4 5 6 ... N

      When the cluster is closed, either by running word cluster_close
      or by the head node exiting, these interconnections and the orig-
      inal ones tying the head node to all the nodes, will be closed
      cleanly with no ports left lingering.

      An important element in smooth shutdown is function clientclose() 
      in term.c, where the closing node tells the node on the other end
      of the connection to close too, resulting in an active close on
      both ends of the connection.

      When shutdown is smooth, "netstat -a" on all machines should show 
      no TIME_WAIT connections after a few seconds.
}
      [ no "CONNECTED" book ]
      CONNECTED 
      IF " cluster_interconnect: nodes are already interconnected" . nl
         return 
      THEN
      cluster_props "CPROPS" book
      SSL_CONNECT "SSLflag" book

      CPROPS rows nit 1st
      DO CPROPS I quote \ higher numbered socket (client):
         2nd word drop number drop (nSocket) "SOCK" book
         CPROPS rows I tic
         DO CPROPS I quote \ to all lower numbered sockets (servers):
            dup 1st word drop IPhost quoted spaced
            swap 3rd word drop cat (qIPhost qPort) 
            SSLflag IF " CLIENT_SSL" ELSE " CLIENT" THEN cat
            dup . sp SOCK .i nl
            SOCK remoterun 
            one idle \ pause for a second
         LOOP
      LOOP
      "xx" cluster_run
      yes "CONNECTED" book
   end

   inline: cluster_props ( --- hT) \ cluster hosts, sockets and ports
\     Properties after head node is connected to cluster nodes.

      "cluster_connect" "HOST" yank (hT) any?              \ host name
      IF "cluster_connect" "SOCK" yank "%4.0f" format hand \ socket
         "cluster_connect" "PORT" yank "%6.0f" format hand \ port
         3 parkn (hT) neat
      ELSE " cluster_props: cluster is not connected" hand 
      THEN
   end

   inline: cluster_run (hT --- ) \ run T on all nodes in cluster
\     Words in T are run remotely on every node.

      (hT) chop
      localsockets any?
      IF (hT hSockets) remoterun
      ELSE " cluster_run: cluster is not running" . nl 
      THEN
   end

   inline: cluster_run1 (hT --- ... X) \ run T on all nodes in cluster
{     Words in T are run remotely on every node.  The head node waits
      up to SEC seconds until every node has sent back a stack item.

      T must contain a phrase that returns one (and only one) item to
      the head node's stack.  If there are more nodes than returned
      stack items, the program will wait the entire period.

      Examples:

         1. This runs on each node, and grabs Cases_Done, a number,
            and returns it to the head node:
               "Cases_Done remotefd remoteput" (hT) cluster_run1

         2. Each node makes the head node place the node's socket
            number on the head node's stack:
               "'remotefd' remotefd remoterun" cluster_run1
}
      [ 30 "SEC" book ]

      (hT) chop
      localsockets any?
      IF "remoterun1" "SEC" yank push 
         SEC "remoterun1" "SEC" bank

         (hT hSockets) remoterun1

         pull "remoterun1" "SEC" bank
      ELSE " cluster_run1: cluster is not running" . nl
      THEN
   end

   inline: cluster_source (hT --- ) \ source the code in T on head node
{     Incoming T runs on the head node with this stack diagram: 
         (nSocket --- )
      where Socket is the socket number of a node connection.

      This word loops over all the Socket numbers of the nodes, running
      T on the head node for each one.
}
      chop "T" book
      localsockets any?
      IF (hSockets) these rows 1st
         DO (hSockets) this I pry (nSocket) T main LOOP (hSockets) drop
      ELSE " cluster_source: cluster is not running" . nl
      THEN
   end

   inline: cluster_start (N p --- ) \ start N nodes running
{     Starting this program as a server on the first N nodes of the 
      cluster, by running script usr/tserv on each (see node_start).

      Incoming p=1 for processor 1, p=2 for processor 2.  Different
      processors use different ports on the same host.

      Starting again too soon after cluster_close will produce errors;
      see note in cluster_close.  

      If a restart is within LINGER seconds of LAST_CLOSE, banked here 
      by cluster_close the last time it ran, new port numbers are used 
      in case the former ones have not timed out.

      Keeps a table of node name and port in array JOBS, initialized 
      by word cluster_initialize and used later by word cluster_connect.
}
      [ "" "JOBS" book, zero "LAST_CLOSE" book, 900 is LINGER ]
      
    \ Checking the incoming stack:
      false (N p false) 
      two NUM stkok or
      one NUM stkok and not 
      IF "cluster_start" stknot return THEN

      "cluster_connect" "HOST" yank any?
      IF " cluster_start: must close running cluster first" 
         ersys return
      THEN

    \ Accounting for restarts less than LINGER seconds apart:
      time LAST_CLOSE less LINGER >

      IF \ set the initial port numbers in node_start:
         USE_PORT (p) dup "node_start" "PORT1" bank
         (p) tic (p+1) "node_start" "PORT2" bank

      ELSE \ lingering; bump the port numbers in node_start by two:
         "node_start" "PORT1" yank two + "node_start" "PORT1" bank
         "node_start" "PORT2" yank two + "node_start" "PORT2" bank

      THEN

      (p) this 1 2 within not
      IF " cluster_start: processor out of range" ersys return THEN

      "p" book, "N" book
      JOBS N qdx 1      \ beginning with node 1
      DO I p node_start \ this program running as server on Ith node

         "node_start" "NAME" yank spaced
         "node_start" "PORT" yank int$ cat (new_JOBS)

      LOOP (JOBS new_JOBS) N tic pilen
      noblanklines "JOBS" book
   end

  inline: cluster_timesync ( --- hT) \ nodes to within 1 second of head
    \ Synchronize this program's time running on server nodes to within
    \ one second of the program time on the head node.

      systime$ quoted " set_time" cat (qS)
      (qS) cluster_run cluster_ack drop \ run word set_time on all

    \ The following determines the time difference between the head
    \ node and all the nodes.  Use a loop over sockets to obtain times
    \ in socket order; they would be in random order if cluster_run1
    \ were used:
      localsockets push
         list: peek rows 1st
            DO time
               "time remotefd remoteput" peek I pry remoterun1
               (htNode) ontop (tNode) less
            LOOP
         end 
      pull drop
      (hError) "%0.3f sec" format right justify
      cluster_props 1st word drop spaced swap park
      "_timesync" naming
   end
{
   This is a version of cluster_timesync that uses time instead of date:
  _inline: cluster_timesync ( --- hT) \ nodes to within 1 second of head
    \ Synchronize this program's time on server nodes to within one
    \ second of the program time on the head node.

      [ {"
           "time remotefd remoteput"
           remotefd remoterun1 \ fetch head node time
           time1 less ontop    \ less local time
           (deltaT) GMTdelta   \ set program time delta
        "} chop "SET_TIME" (hT) book
      ]
      SET_TIME (hT) cluster_run cluster_ack (f) drop
{
      Running cluster_ack above holds things until all the nodes have 
      run, prior to running the loop below.

      Here is another way that works:
         1) Adding this last line to SET_TIME above:
            "OK" remotefd remoteput
         2) Replacing the phrase above:
               SET_TIME (hT) cluster_run cluster_ack (f) drop
            with the phrase:
               list: SET_TIME (hT) cluster_run1 (OK) end (hOK) drop
            to gather OK responses and then drop them.
}
    \ The following determines the time difference between the head
    \ node and all the nodes.  Use a loop over sockets to obtain times
    \ in socket order; they would be in random order if cluster_run1
    \ were used:
      localsockets push
      list: peek rows 1st
         DO time
            "time remotefd remoteput" peek I pry remoterun1
            (tHead tNode) less ontop
         LOOP
      end pull drop
      (hError) "%0.3f sec" format right justify
      cluster_props 1st word drop spaced swap park
      "_timesync" naming
   end
}
   inline: USE_PORT ( --- nPort) \ port number for cluster nodes
      [ def_port "PORT" book ] PORT 
   end

   cluster_initialize

   private halt

\-----------------------------------------------------------------------
{
   Example usage of some words in this file, for a cluster of 64 two-
   processor nodes.

   These can be pasted at the ready prompt of this program running on 
   the head node:
}
      'clu.v' source \ source the words of this file
      node_code      \ gather minimal program code for nodes
    \ This will show harmless "cannot remove" messages if there are
    \ no old files to remove:
      64 node_copies \ copy minimal program code to all nodes

      cluster_initialize  
      64 1 cluster_start  \ nodes running as servers on processor 1
      64 2 cluster_start  \ nodes running as servers on processor 2
      'ps -af' shell      \ view jobs running
      cluster_connect     \ connect to all servers
      clients             \ show remote clients (128 of them)
      cluster_props eview \ view hosts, sockets, ports (:q to exit)
      cluster_close       \ shut down all nodes
      clients             \ no more clients (may take a few seconds)
      'ps -af' shell      \ view jobs running

    \ Destroy program code copies made above:
      64 1 DO I node_destroy LOOP

\  If something goes wrong and a bunch of rsh jobs to nodes are running:
      'killall rsh' shell

\-----------------------------------------------------------------------

   Simulated cluster_start.

{  A special version of word cluster_start in this section is for simu-
   lating a cluster on a serial machine.  With this simulated cluster 
   word, new words can be developed and tested on a serial machine.  

   Later the new words will run in parallel on a cluster.  The Make-pi 
   demo given below is an example that was developed on a serial ma-
   chine and then run on a cluster with no changes.

   To simulate a cluster, four instances of this program are running
   as servers on the serial machine's IPloop, listening on ports 9877, 
   9878, 9879 and 9880.  Word nodewin can be run to create some windows
   and start this program for these servers; see below: "Running the 
   Make-pi demo on a cluster or on a serial machine."

   For a serial machine, word cluster_start is overwritten by the ver-
   sion below when this region is sourced.  All other general words 
   for clusters given above work as-is on a serial machine.
 
   Source this region for a simulated cluster with the following:
      "clu.v" "Simulated cluster_start." msource
}
   "cluster_start" missing IF "clu.v" source THEN \ need real one first

\  This version of cluster_start simply records the ports that should
\  be listening in the demo windows started by nodewin in Appendix B,
\  step 2:
   inline: cluster_start (N p --- ) \ start N nodes running
      [ "" "JOBS" book, zero "LAST_CLOSE" book, 900 is LINGER ]

      2drop
      host spaced 9877 int$ cat
      host spaced 9878 int$ cat
      host spaced 9879 int$ cat
      host spaced 9880 int$ cat
      4 pilen "JOBS" book
   end
   private halt

\-----------------------------------------------------------------------

   Appendix A

   Make-pi demo.
{
   Words for this demo are in the next two sections:
      1. words that run on every node
      2. words that run on only the head node

   Phrases to copy and drop and run the Make-pi demo are in:
      Appendix B - for a real cluster or serial machine 
      Appendix D - for ordinary networked machines run as a cluster

\-----------------------------------------------------------------------

   This section contains the words for the Make-pi demo that are run on 
   every node except the head node.

   The text given next is collected by word {", brace-quote, and word 
   "}, quote-brace, into a volume of text that is sent to the stack of 
   this program running as a server on each node.

   Word cluster_run causes the program running on each node to source
   the volume of text received on its stack.  The resulting words will 
   go into the program's catalog, ready to be run on the node when the
   make_pi job is set in motion.
}

{" Words for making pi.
   xx     \ clearing the node's stack

\  "/dev/null" set_sysout \ uncomment this to make node display nothing

   inline: dispatch (hX --- ny) \ make a piece
{  
      Word dispatch computes the node's contribution to pi and keeps
      track of the number of pieces.

      Word dispatch runs locally, but it is commanded remotely by the 
      head node when another step is to be taken; see head node word 
      make_piece.
 
      Incoming X is a 1-by-2 MAT defining integration range x1 to x2.
}     
      [ 1 (sec) "WASTE_TIME" book 
        no '"pieces" book' main \ initialize in main lib
      ]
      (hX) piece (y)         \ run word piece to compute number y
      one "pieces" main bump \ add one to the count
      WASTE_TIME idle        \ waste some time**
   end
{
   ** Note: WASTE_TIME is an artifact to make all windows run uniformly
      in a visual demo on a serial machine.  Otherwise, some may appear
      busy while others are idle most of the time.  

      With WASTE_TIME of this order, do not ask for very many pi pieces
      on a serial machine demo without changing SEC.
}

   inline: piece (hX --- ny) \ compute a partial sum for pi
{     Computes a trapezoidal integration step of function f(x), to pro-
      vide a contribution to pi.

      Integrate f(x)=4/(1 + x^2) from x1 to x2 in one trapezoidal step:

         y = (x2 - x1)*[f(x1) + f(x2)]/2

      Incoming X is a 1-by-2 MAT containing x1 and x2:
         X(1,1) = x1
         X(1,2) = x2
}
      [ \ Making f(x), a word in the local library of this word piece:
        \    Stack diagram for f(x): (x --- f[x])
             "4 swap dup * tic slash" \ f(x)=4/(1 + x^2)
             (qS) "f(x)" macro \ call this local function f(x)
      ]
      (hX) dup (hX hX)
      (hX) 1st pry "x1" book
      (hX) 2nd pry "x2" book

      x1 f(x), x2 f(x), plus, 2 slash (fxbar) \ [f(x1) + f(x2)]/2
      x2 x1 less (dx)                         \ width of base, x2 - x1
      (fxbar dx) star (y)                     \ area; number y on stack
   end
"} (hT) 

(hT) cluster_run \ running this text on all nodes

" Required words have been installed on all the nodes" . nl

\-----------------------------------------------------------------------

\  This section contains the words for the Make-pi demo that run only
\  on the head node.

\  Words add_piece, awhile, INIT, and make_piece run on the head node.

   inline: add_piece ( --- ) \ add another piece to PI
{     This word runs locally, but it is commanded by a remote node as
      soon as the remote node has placed its contribution, a number
      Y, on its stack.  See above, word dispatch, in the words that 
      were sent to the nodes.

      When this word runs, the number Y is added to the growing number 
      PI, in the main library, that will approach the true value of pi.

      As this word runs locally, word remotefd gives the file descriptor
      of the socket that leads to the remote client running this word.
}
      remotefd (nSocket) remoteget (nY) \ getting NUM Y from remote stk

      (Y) "PI bump" main \ add number Y to number PI in main library

      remotefd (nSocket) make_piece \ go back and make another
   end

\  Word awhile is used in script test/cluster.  Without it, the demo
\  script would run to completion and exit before the cluster nodes
\  finish making pi:
   inline: awhile ( --- f) \ false flag while nodes are working
{     Until the number of nodes reporting done in word make_piece 
      equals the number of sockets, this word returns false on the 
      stack of the head node.

      This word is run during WAIT period, by multitasker word WAITING.

}     "make_piece" "NODES_DONE" yank rows (r1)
                        localsockets rows (r2)
                                          (r1 r2) = (f)
   end

   inline: INIT (N --- ) \ initialize for N pieces
      (N) "make_piece" "init" localrun ;

   inline: make_piece (nSocket --- ) \ run remote S for a pi piece
{     This word will start the node at Socket making the next piece.

      This word also contains a local inline called init that initial-
      izes the problem.  Local words like init use the library of the
      word they are within.  This is convenient here because init and
      make_piece share variables STEPS, RANGES, and MAX_STEPS.

}     [ \ This local word makes nsteps in the range 0 to 1 for all N
        \ pieces of pi:
        {" init (N --- ) \ initialize for N pieces

           (nsteps) "MAX_STEPS" book

           zero "'PI' book" main \ PI is a number in the main library
           zero "STEPS" book

         \ Make matrix RANGES, containing steps x1 to x2 for MAX_STEPS
         \ in the interval 0 to 1:

           zero one MAX_STEPS intervals (hInter)
           (hInter) dup -1 lag park (hX1:X2)
           (hX1:X2) 1st MAX_STEPS items reach (hR)
           (hR) "RANGES" book

           "no 'pieces' book" cluster_run \ set count on nodes to zero

           zero one null "NODES_DONE" book

         \ Note: this phrase will display N-by-2 matrix RANGES:
         \    "make_piece" "RANGES" yank .m

        "} "init" macro
      ]
      (nSocket) "S" book \ S is where to send work
      STEPS MAX_STEPS <  \ more steps to do?
      IF one STEPS bump  \ bump the step count

       \ Put next step range, a 1x2 MAT, on stack of remote S:
         RANGES STEPS ndx reach (hR) S remoteput 
{
         Have node(S) run these two phrases.  The first runs word
         dispatch(S) and makes another pi piece; the second makes
         node(S) send a command here to have the head node run its 
         word "add_piece" to fetch the piece and add it to the tally.

}        "dispatch, "                     \ node(S) makes another piece,
         "'add_piece' remotefd remoterun" \ then tells head to add piece

         + S remoterun                    \ run these on node(S) 

      ELSE 
         S NODES_DONE pile "NODES_DONE" book

       \ Don't wait for next multitasker cycle to run WAITING.  
       \ Maybe all the nodes are done now:
         WAITING \ runs word awhile if it is being used (test/cluster)
      THEN
   end

" Required words have been installed on the head node" . nl

   private halt

\-----------------------------------------------------------------------

   Appendix B

   Running the Make-pi demo on a cluster or on a serial machine.

   1. Start with this step if working on a cluster:

      Sourcing the words for clusters (running node_code and 
      node_copies is only necessary if program source has been 
      recompiled):

         "clu.v" source
         node_code      \ gather minimal program code for nodes
         64 node_copies \ copy minimal program code to all nodes

      The cluster is ready to be connected.  Go to step 3.

   2. Start with this step to simulate a cluster on a serial machine:

      Sourcing this file and substituting new words for cluster_connect
      and cluster_start:

         "clu.v" "Simulated cluster_start." msource

      Run one of these to make four "node" windows; something like the 
      second one may be necessary to force execution of a desired ver-
      sion of the program:

         4 1 DO "tops" nodewin LOOP

      or

         4 1 DO "/home/dwil/tops/src/tops" nodewin LOOP

      Move the node windows somewhere convenient, and in each of them 
      run one of the following lines to make "node" servers (wtrace 
      will display a trace of operations as the demo runs; nowtrace 
      turns wtrace off):

         "*" 9877 SERVER wtrace
         "*" 9878 SERVER wtrace
         "*" 9879 SERVER wtrace
         "*" 9880 SERVER wtrace

      Go to the next step to connect the simulated cluster.

   3. On the head node (the window of step 1 or step 2), start the 
      cluster for 4 nodes and connect the cluster nodes to the head 
      node:

         wtrace \ will trace operations; nowtrace turns it off

         cluster_initialize 

       \ yes ssl_connect \ connections are encrypted (require OpenSSL)

         4 1 cluster_start \ start the nodes running this program

         cluster_connect \ connect head node to the cluster nodes

         clients \ show that nodes are connected

         cluster_props . \ showing node names, sockets and ports

      Note: on a serial machine, the simulated nodes are already run-
      ning from step 2, and cluster_start run above (a simulated ver-
      sion loaded in step 2) just stores their port numbers in its 
      JOBS array.

   4. Load the Make-pi demo and run the cluster:

         "clu.v" "Make-pi demo." msource 

         10 (pieces) INIT "make_piece" cluster_source

   5. Look at results compared to the program's double precision pi:

         PI "%19.17f" format . nl pi "%19.17f" format .

      The upper number is PI just computed, and the lower number is the
      program's pi.

   6. Rerun with more pieces:

         100 (pieces) INIT "make_piece" cluster_source

         PI "%19.17f" format . nl pi "%19.17f" format .

   7. Who did the work:

         depth push
         "host spaced pieces int$ cat remotefd remoteput" cluster_run1 \
         depth pull less pilen .m

   8. More to do (after running steps 1 or 2, then 3, at minimum):

         nowtrace \ turning off trace on head node

       \ Sitting on the 3rd node:
            localsockets 3rd pry remoteprompt
          \ Running commands on the 3rd node:
               host .
               clients
          \ Returning to head node from the 3rd node (pressing Esc 
          \ and then q):
          \    [Esc] q

       \ Making full interconnection (do this on head node):
            cluster_interconnect

       \ Returning to the 3rd node:
            localsockets 3rd pry remoteprompt
          \ Viewing clients on 3rd node, indicating full connection:
               clients
          \ Returning to head node from the 3rd node (pressing Esc 
          \ and then q):
          \    [Esc] q

   9. Stop the nodes running this program, and on a serial machine 
      close the simulated node windows made in step 2:

         cluster_close

   Here is the result for 1000 pieces using 64 nodes on a real cluster:

   [tops@amal] ready > 1000 (pieces) INIT "make_piece" cluster_source
   [tops@amal] ready > PI "%19.17f" format . nl pi "%19.17f" format .
   3.14159248692312865
   3.14159265358979312 (this is the program's pi)

\-----------------------------------------------------------------------
 
   Appendix C

   Words for networking machines as a cluster.

\  Run this section using:

\     "clu.v" "Words for networking machines as a cluster." msource

   "clu.v" source

\-----------------------------------------------------------------------

\  Additional and replacement words for clu.v:

   inline: $RUN ( --- qRUN) \ program to run, path+filename
      [ "norun" "NodeRun" book ] NodeRun ;

   inline: node_name (n --- qS) \ the host name of node n
      [ "" "Names" book ]
      Names asciify noblanklines chop 
      swap quote strchop
   end

   inline: node_start (n pro --- ) \ start background program on node n
{     Tue Mar 15 14:13:25 PDT 2011.  Allow SSL connections.

      Runs $RUN located on node n, which starts this program running
      in background and listening as a server.

      Initial listening ports are defined as 9877 for pro=1, and 9878
      for pro=2.

      These port numbers are needed when connecting using word CLIENT,
      and may be changed by cluster_start if LAST_CLOSE < LINGER.
}
      [ {"
          rsh
          $node_name
          -n
          $RUN
          -port
          $PORT
          $SSL
          &
        "} "RUN" book

      \ Note: rsh -n redirects input (STDIN) to /dev/null.

      \ Initial port numbers (may be reset by cluster_start):
           9877 "PORT1" book
           PORT1 1+ "PORT2" book
      ]
      RUN "$RUN" $RUN qreplace (hT)

      (hT) "$PORT" rot (pro) 1 = IF PORT1 ELSE PORT2 THEN "PORT" book
      (hT $PORT) PORT int$ qreplace
      (hT) "$SSL" SSL_CONNECT IF "-ssl" ELSE "" THEN strp (hT) 
      (n hT) "$node_name" rot node_name dup "NAME" book qreplace (hT)

      vol2str neat dup "command" book \ save string for ref
      shell
   end

   inline: nodes_all ( --- n) \ total nodes
      "node_name" "Names" yank asciify noblanklines rows ;

   inline: nodes_kill ( --- ) \ kill nodes when things mess up 
\     Tue Mar 15 14:13:25 PDT 2011.  Allow SSL connections.

\     Trying to clean up after errors during debugging.  Use list in
\     cluster_props.

      SSL_CONNECT "SSLflag" book

      cluster_props any?
      IF push peek rows 1st
         DO peek I quote 2nd word drop (nSocket) number drop
            this socket_open
            IF "bye" that remoterun sclose
            ELSE drop peek I quote 1st word drop IPhost
               peek I quote 3rd word drop (nPort) number drop
               SSLflag IF yes ssl_connect THEN
               (IPaddr nPort) CLIENT (nSocket) any?
               IF "bye" that remoterun sclose
               ELSE 2drop
                  " nodes_kill: cannot kill " . peek I quote . nl
               THEN
            THEN
         LOOP pull drop
      THEN
   end

   private halt

\-----------------------------------------------------------------------

   Appendix D

   Running the Make-pi demo on a network of machines.

   Set up file usr/myclu.v, or modify the phrases below that follow 
   ELSE, to name your user paths and network machines.  

   Then run steps 1 - 6 below.

   Demo network.

   usrpath "myclu.v" catpath file?

   IF \ file usr/myclu.v has lines like the lines below ELSE, but 
      \ for your network:
      usrpath "myclu.v" catpath "My network." msource 

   ELSE
\  Specializing words $NODE, $HOME, node_name, and $RUN for a particu-
\  lar network and user by banking names into their libraries:

    \ User's home directory on each machine in the network:
         "/home/user/" "$NODE" "UserNodeHome" bank

    \ User's home directory on the head machine:
         "/home/user/" "$HOME" "UserHeadHome" bank

    \ Machines on the network being used for cluster nodes (this list
    \ can include the head node if it is also acting as a node):
         {" 
            bach
            blake
            handel
            hopkins
            hurt
            motzart
            reed
         "} "node_name" "Names" bank

    \ The script on each machine that runs this program as a server 
    \ (see example file usr/tserv):
         "/home/user/mytops/usr/tserv" "$RUN" "NodeRun" bank

   THEN

   private halt

   1. Sourcing this file and substituting new words for running a 
      network of machines:

      "clu.v" "Words for networking machines as a cluster." msource
      "clu.v" "Demo network." msource

   2. Start this program running on all machines (nodes) and connect 
      them to the head machine (node), the one where these commands 
      are being issued:

         wtrace \ will trace operations; nowtrace turns it off

         cluster_initialize

       \ yes ssl_connect \ connections are encrypted (require OpenSSL)

         nodes_all 1 cluster_start \ start the nodes running this prog

       \ WARNING: Allow a delay for this program to start up on the
       \ nodes before trying to connect them:

         20 idle cluster_connect \ head node to the cluster nodes

         clients \ show that nodes are connected

         cluster_props . \ showing node names, sockets and ports

         "wtrace" cluster_run \ trace operations on all nodes

   3. Load the Make-pi demo and run the cluster:

         "clu.v" "Make-pi demo." msource

         10 (pieces) INIT "make_piece" cluster_source

   4. Look at results compared to the program's double precision pi:

         PI "%19.17f" format . nl pi "%19.17f" format .

      The upper number is PI just computed, and the lower number is the
      program's pi.

   5. Rerun with more pieces:

         100 (pieces) INIT "make_piece" cluster_source

         PI "%19.17f" format . nl pi "%19.17f" format .

   6. Who did the work:

         depth push
         "host spaced pieces int$ cat remotefd remoteput" cluster_run1 \
         depth pull less pilen .m

   7. Stop the program on the network machines connected in Step 2:

         cluster_close

------------------------------------------------------------------------
