/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* xterm.h  October 1999

Copyright (c) 1999-2014  D. R. Williamson

   X11 references:
     Redhat 5.2 Linux: /usr/doc/HOWTO/XFree86-HOWTO
     Linux and Unix:
        xterm -help
        man xterm
        man XXX for X11 command XXX, i.e., man XrmMergeDatabases

   Some X11 elements adapted from:
   Gnuplot, gplt_x11.c, distributed with Redhat 5.2 Linux
   Copyright 1986 - 1993, 1998   Thomas Williams, Colin Kelley
*/

/* Messages for X11 errors: */
#define ATOMOUT "atom id is out of range"
#define XTERMNOT "error sourcing xterm vocabulary"

/* Messages for window errors: */
#define COLORNOT "color not found"
#define FONTNOT "font not found"
#define GCATTNOT "graphics context attributes vector not specified"
#define GCCATNOT "graphics context must be in catalog"
#define PIXCATNOT "pixmap control block must be in catalog"
#define WINATTNOT "window attributes vector not specified"
#define WINCATNOT "window control block must be in catlog"
#define WINDESNOT "error destroying window"
#define WINDUPE "window already exists"
#define WINNOT "window not found"
#define WINSNOT " No windows exist"
#define WINUNINIT "window not created"

struct wcb { /* window control block in linked list */
/* NOTE: This wcb is for the linked list of windows.  It is different
         from the stack-based wcb in xterm.v, for which enum _wcb is 
         defined in term.h. */

   Window win; /* ptr same as hW+WIN; used to verify, as in winshow() */
   catitem *cat; /* cat addr of matrix hW, a wcb in xterm.v */
   int vis; /* 0 when not mapped, 1 when mapped and visible */
   struct wcb *nex; /* next in linked list */
   struct wcb *pre; /* previous in linked list */
};

int bitmapf(); /* bitmapf (qFile --- hP) */
int bounds(double x1, double y1, double x2, double y2, \
   double xMin, double xMax, double yMin, double yMax, \
   double *X, double *Y);
int bounds1(double x1, double y1, double x2, double y2, \
   double yMin, double yMax, double *X, double *Y);
int colorpix(); /* colorpix (qColor --- pix) */
int defButtonPressedEvent(); /* (hE --- ) */
int defButtonReleasedEvent(); /* (hE --- ) */
int defClientMessageEvent(); /* (hE --- ) */
int defConfigureEvent(); /* (hE --- ) */
int defExposeEvent(); /* (hE --- ) */
int defKeyPressedEvent(); /* (hE --- ) */
int defKeyReleasedEvent(); /* (hE --- ) */
int defMotionEvent(); /* (hE --- ) */
int defVisibilityEvent(); /* (hE --- ) */
int fontload(); /* fontload (qS --- 0 | XFont fid) */
int GCclip(); /* GCclip (hL hGCB --- ) */
int GCcreate(); /* GCcreate (hW hGC --- ) */
int GCfore(); /* GCfore (pix hGC --- ) */
int GCfree(); /* GCfree (hGC --- ) */
int GCline(); /* GCline (linestyle hGC --- ) */
int interpolate(double x1, double y1, double x2, double y2, \
   double *X, double *Y);
int line(); /* line (hW hGC hP --- ) */
int line_seg(); /* line_seg (hW hGC hC hS hY1 hY2 hX1 hX2 hL --- ) */
int lineb(); /* lineb (hW hGC hR hf hY hX hL --- ) */
int lineb1(); /* lineb1 (hW hGC hR hf hY hX hL --- ) */
int lineb2(); /* lineb2 (hW hGC hR hf hY hX hL --- ) */
int linec(); /* linec (hW hGC hY hX hL --- ) */
int linef(); /* linef (hW hGC hR hf hY hX hL --- ) */
int lineg(); /* lineg (hW hGC hR hN hP hY hX hL --- ) */
int linem(); /* linem (hW hGC hR hV hY hX hL hD --- ) */
int linem1(); /* linem1 (hW hGC hP hR hV hY hX hL --- ) */
int linet(); /* linet (hW hGC hY hX hL --- ) */
int linet1(); /* linet1 (hW hGC hR hY hX hL --- ) */
int linetX(); /* linetX (hW hGC hR hY hX --- ) */
int pminmax(); /* pminmax (hA --- min max) */
int rgnt(); /* rgnt (hW hGC hY1 hY2 hX hL --- ) */
int rgnt1(); /* rgnt1 (hW hGC hR hY1 hY2 hX hL --- ) */
int wdemo(); /* wdemo ( --- ) */
int winadd(struct wcb *new, struct wcb **table, struct wcb **end);
int winclear(); /* winclear (hW x y w h) */
int wincopy(); /* wincopy (hWfrom hWto hGC --- ) */
int wincreate(); /* wincreate (hW qTitle --- ) */
int windisp(); /* windows ( --- ) */
struct wcb *winfind(Window window, struct wcb *table);
struct wcb *winfindname(char *nam, struct wcb *table);
int winfree(); /* winfree (hW --- ) */
void winlist(struct wcb *windows);
int winraise(); /* winraise (hW --- ) */
void winrem(struct wcb *p, struct wcb **table, struct wcb **end);
int winresize(); /* winresize (hW w h --- ) */
int winshow(); /* winshow (hW --- ) */
int xclip(); /* xclip (hY hX hL --- hY1 hX1 hL1) */
void XDrawLine1(Display *d, Window w, GC gc, int style, \
   short x1, short y1, short x2, short y2);
void XEventHandler(int event); /* (hE --- ) */
int Ximageprops(); /* XImage (d --- ) */
int XRegionFree(); /* winregionfree (hR --- ) */
int XRegionSet(); /* winregion (hEv hGC --- hR) */

/* end xterm.h headers */


