/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* word.h  November 2000

   Copyright (c) 2000   D. R. Williamson

   Notes about word patterns and compiling new words follow these
   headers.

*/

#include "main.h"
#include "stk.h"

#include "exe.h"
#include "hash.h"
#include "inpo.h"
#include "key.h"
#include "lib.h"
#include "mat.h"
#include "math1.h"
#include "mmath.h"
#include "mem.h"
#ifdef NET
   #if defined(VT) || defined(VTAIX)
      #include "vt.h"
   #endif
#endif
#include "prs.h"
#include "sparse.h"
#ifdef UMFPACK
   #include "spsolve.h"
#endif
#ifdef UMFPACK
   #include "speig.h"
#endif
#ifdef SQLITE
   #include "sql.h"
#endif
#include "stp.h"
#include "tag.h"
#include "sys.h"
#include "tex.h"
#ifndef TERMNOT  
   #include "term.h" /* terminal support */
#endif
#include "ctrl.h"
#include "wapp.h"
#include "ordering.h"
#include "op4.h"
#ifdef XDB
    #include "xdbfetch.h"     /* driver to rexdb's API routine */
#endif
#if defined(FFTW) || defined(FFTW3)
    #include "fftw_driver.h"  /* driver to FFTW library routines */
#endif

#if defined(ESSL)
   #include "essl.h" /* engineering and scientific subroutine library */
#endif

#if defined(LAPACK)
   #include "lapack.h"
   #include "essl.h" /* engineering and scientific subroutine library */
#endif

#ifdef MLAB
   #include "matlab.h" /* matlab application program interface */
#endif

#ifdef VMO
   #include "vmo.h" /* mgetty voice modem */
#endif

#ifdef DYNLOAD
   int loadtx();    /* dynamically load shared objects with '.tx' extension */
#endif

int nativewords(); /* nativewords (nLib --- ) */

/* end of word.h headers */

/*----------------------------------------------------------------------

   Patterns and functions for native words and constant numbers.

   Native words are those that run basic functions already compiled
   into the executable file of the program.  The purpose of file word.p
   is to link the compiled function names to chosen word patterns that
   will allow them to be run from a text file.

   For example, within file word.p the lines

      && native("+",(unsigned long (*)()) plus)
      && native("plus",(unsigned long (*)()) plus)

   link word patterns, "+" and "plus" to compiled function plus().  From
   a text file run by the program, words + and plus will act as syno-
   nyms, both performing the same action.

   Constant numbers and their word patterns are also defined in file
   word.p.  The definition of pi, for instance, is made there using

         && constant("pi","3.14159265358979323846")

   so that whenever word pattern pi is encountered in a text file, the
   binary (not text) representation of number 3.1415... is pushed to 
   the stack.  All numbers on the stack (and in matrix arrays) are de-
   fined by 64 binary bits (52 for the mantissa, 11 for the exponent,
   and 1 for the sign) and are equivalent to about 18 digits when view-
   ed in text form.

   Recompile word.c when new native words or constants are added to
   file word.p (basic words for the program) or file wapp.p (words for
   applications and projects).  More information on compiling is given
   below.

------------------------------------------------------------------------

   Word patterns.

   The program runs by matching words in text to patterns stored in the
   catalog.  A word in text is a series of characters surrounded by
   blanks, just like these words being read.  All word patterns are 
   taken in a continuous stream where new lines do not matter and a 
   blank space is assumed to follow the last word on each line. 

   Generally, words are read and acted upon one at a time.  Words that
   look like numbers take precedence and are passed directly to the 
   program.  A word that is not a number undergoes pattern matching 
   with the catalog.  Pattern matching is literal--no parsing is done 
   to find additional symbols or words within a word pattern.  For 
   example:

      the word A+B is taken literally to be something called 
      "A-plus-B," not the operation of adding A and B (which to 
      the program would be: A B plus)

      word -A is simply something called "minus-A" or "dash-A," 
      not something with the values of A negated (which to the 
      program would be the two words: A negate); nor is it the 
      negation of the values of A into itself (which would be: 
      A negate into A)

      3.2; might be called "three-point-two-semicolon," but cer-
      tainly not the number 3.2 followed by an ending semicolon 
      (which would be: 3.2 ;)

   The maximum length of a word pattern is 255 characters, subject to
   some restrictions described next, to avoid conflict with built-in 
   words we use for skipping or gathering text, and with patterns that 
   look like numbers.

   Patterns to be seen as words cannot contain blank or comma, and 
   cannot start with any of the following:

                       "   '   {  )  (  \  #

   because these characters are used in token parsing code to skip over
   or gather blocks of text.  Commas in text can be used to make it more
   readable, but to the program all are seen as blank spaces.

   Each word pattern is first tested to see if it can be taken as a 
   number, and if so, pattern matching with the catalog is skipped and 
   the program receives the number.

   Number patterns can contain the characters

                 + - . 0 1 2 3 4 5 6 7 8 9 e E d D

   and while word patterns can also contain these characters, their
   arrangement cannot be in the form of a number since numbers take
   precedence.  

   Numbers must begin with a number, +, -, or decimal point, and must
   end with either a number or decimal point (of course no more than
   one decimal point per number).  Within a number pattern, e, E, d, D,
   +, or - denote an exponent to follow.  For example, these patterns
   are taken to be numbers, not words:

               1e3  3.2E5  51.4  -23.4  +5.  6d-3  -1-1

   while these make valid names for words:

            1e  e3  .3.2E5  51*4  -23f4  +5..  6d.3  1-1-

------------------------------------------------------------------------

   Adding new native functions.

   Words define:, inline:, inline and inlinex all allow immediate cre-
   ation of high level words without compilation.  But when low level, 
   native functions are required, say for greater speed than inline pro-
   vides, they can be compiled into the program with relative ease.

   All functions that interface with high level words, as the ones de-
   clared in file word.p do, have a form that returns an integer (1 if
   successful, 0 if not) and contains no parameters (other supporting
   functions, of course, may have any form):

      int myword();

   Functions already in the program are resources for new ones, and the
   line becomes blurred between programming C and arranging functions
   of words in a new function to take advantage of the stack and mimic
   phrases performed at a higher level from an interactive prompt or
   text file.  For example: 

      function parkm() that parks two matrices into one may need to 
      first convert a number on the stack into a 1x1 matrix.  If, say, 
      the second on stack is a number, then the following line found in
      parkm() swaps the stack items, converts the top of stack into a
      matrix, swaps it back, then recurses into parkm() to do the park:

         return( swap() && typnum2mat() && swap() && parkm() );

      which is equivalent to the following high level phrase run inter-
      actively or from a text file:

         swap num2mat swap park

   To keep basic compiled words of the program (defined in word.p) sep-
   arate from new compiled words for applications, files wapp.p, wapp.h
   and wapp.c are recognized by the program.  Here is their parallel to
   the program's word.p, word.h and word.c files:

             purpose         for program   for applications
      define word patterns:    word.p          wapp.p
       prototypes of words:    word.h          wapp.h
      source code of words:    word.c          wapp.c

   Files wapp.c and prototype file wapp.h are used to store application
   functions and their headers, and wapp.p--analogous to word.p--to de-
   fine the patterns for the functions that will be used in the catalog.

   For example, a new function alpha() matching the prototype described
   above (returning int and no parameters) might be in file wapp.c:

      int alpha()
      {
         gprintf(" This is new function alpha\n");
         return 1;
      }

   with a corresponding prototype entry in wapp.h (including its stack
   diagram for information) such as 

      int alpha(); // alpha (hA hB --- hC) //

   (in the above, // replaces the common C delimiters normally surround-
   ing comments, so this file can be loaded) and finally, an entry in 
   file wapp.p that looks like this:

      && native("alpha",(unsigned long (*)()) alpha)

   to link catalog word pattern "alpha" to C function alpha().

   This completes the code that links function alpha() to the program, 
   and effort can focus on making alpha() work in the usual compile-
   debug cycle:

      /home/dev/tops-2.4.1 > make # compile program
      /home/dev/tops-2.4.1 > tops # run program

   Easing the pain of debugging.

   No additional C functions or drivers--and no main program--have to 
   be written to run and test C function alpha() because you can run it
   from the interactive prompt as step 3 has shown.  

   This has been found to save significant time and effort in develop-
   ing these low level functions by allowing loops, branches, and error
   conditions to be run simply by keying or copying and dropping a few 
   different items (sometimes erroneous ones to test error handling) on
   the stack.

   Input to function alpha() (or word alpha) will come from the stack,
   and perhaps from files it will read.  To avoid repetitious keying of 
   stack items as alpha is tested over and over, words can be added to 
   a file, say work.v, to set up the stack and then fire word alpha, 
   perhaps in various ways to test its loops and branches. 

   Eventually, these lines in work.v become your record of notes con-
   cerning alpha and the test cases that alpha is known to run.

   For example, if alpha() pops a couple of vectors from the stack to 
   perform its function, lines in text on local file work.v might say:

      \ File work.v:  Testing function alpha.

      \ This is the stack diagram of word alpha:
      \    alpha (hA hB --- hC)
      \ where
      \    hA is handle to column matrix A of ...

      { Parenthetical items below, like (hA hB), denote items on the 
        stack at various points and are ignored by the program; and all
        text to the right of backslash or between braces is ignored by 
        the program.  (A brace must have spaces surrounding.)
      }
         vector: 0 0 1 ; (hA)
         vector: 1 0 1 ; (hB)

         (hA hB) alpha (hC) \ this will fire alpha

         (hC) .m \ this prints small matrix, C, produced by alpha

         private halt \ stop sourcing this file; all below here ignored 

   where existing word vector: places two 3x1 matrices on the stack
   ready for alpha to grab.  

   Including file work.v to run alpha in this way is done at the inter-
   active prompt by entering

       [tops@gutter] ready > xx 'work.v' source

   where xx clears the stack for a fresh start; or alternately, by 
   entering 

       [tops@gutter] ready > xx ww

   since ww is a word already built-in that simply fires the phrase
   'work.v' source.  

   The program's vi-style command line interface allows recall and ed-
   iting of previous commands keyed at the ready prompt.  Since this 
   interface is an integral part of the operating system, it is worth 
   mastering by anyone planning to work this close to the machine.

   To make alpha() receive matrices from the stack, there are numerous 
   examples in files such as mat.c, wapp.c and tex.c.  For example, 
   scanning prototypes in wapp.h for words with similar stack diagrams 
   shows the following potential references for writing the input and 
   output interface code of alpha():

      int cgm() // cgm (hf hA --- hx) //
      int cmagphase(); // cmagphase (Ar Ai --- hMag hPhase) //
      int solve() // solve (hb hA --- h[Ainv*b]) //
      int stardircos9() // *dircos9 (hCba hXa --- hXb) //

   Documenting new word alpha.

   When alpha() is complete, its definition and stack diagram can be 
   added to a growing catalog of your words, say to file appman.doc, 
   to display the definition whenever phrase man alpha is keyed at the
   ready prompt: 

      [tops@gutter] ready > man alpha
       Entry for alpha:
        alpha (hV1 hV2 --- hA) this is what alpha does ...
        alpha use > vector: 1 0 0 ; vector: 0 0 1 ; alpha .m
        alpha related: ...

      [tops@gutter] ready > 

   Your version of appman.doc can reside in your USRPATH subdirectory,
   and the program will load it along with the program's manual when 
   word man is fired at the ready prompt.

----------------------------------------------------------------------*/

/* end of file word.h */
