/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* word.c  November 2000

   Copyright (c) 2000   D. R. Williamson

   Compile this file when native words in word.p or wapp.p are added 
   or changed. 
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "word.h"

int nativewords(int lib)
/* Load native words into catalog library lib.  If native words have 
   already been loaded into lib, simply return after libset() has set 
   the catalog library context to lib. */
{
/* This list matches enum libs in lib.h: */
   static int loaded[]={LIB0,LIB1,LIB2,LIB3,LIB4};

   int ret=1;

   if(lib<LIB0 || lib>NLIBS) {
      gprintf(" nativewords: library number %d is out of bounds",lib);
      nc();
      stkerr("","");
      return 0;
   }
   if(*(loaded+lib)==-1)   /* lib already loaded? */
      return(libset(lib)); /* set context to lib and return */
   
   *(loaded+lib-LIB0)=-1;  /* -1 will indicate lib has been loaded */

   if(!libinit(lib)) {
      gprintf(" nativewords: failed to initialize library %d",lib);
      stkerr("","");
      nc();
      return 0;
   }
/* Load the native words for lib: */
   switch(lib) { 

      case LIB0:
         return(ret
#include "word.p"
#include "wapp.p"
#ifdef DYNLOAD
   && loadtx()
#endif
         );

      case LIB1:
         return(ret
#include "lib1.p"
         );

      default:
         return(ret
         );
   }
}
