/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* wapp.p  December 1999

Words patterns for applications and projects

This file is included when word.c is compiled

------------------------------------------------------------------------

Note: The name in quotes below is the word pattern matched by the
program, and the rightmost name is the C function name.

   Example:

      && native("*dircos9",(unsigned long (*)()) stardircos9)

   is word *dircos9 when invoked at the keyboard or from a text file,
   and stardircos9() is the function (in wapp.c) that the program 
   runs. */

/*--------------------------------------------------------------------*/

/* For the example of word compilation given in file word.h */
/* Decommissioning this, so word alpha is available for real work
&& native("alpha",(unsigned long (*)()) alpha)
*/

/*--------------------------------------------------------------------*/

/* Functions to demonstrate overloading */
&& native("*A",(unsigned long (*)()) starA)
&& native("*B",(unsigned long (*)()) starB)
&& native("*C",(unsigned long (*)()) starC)

/*--------------------------------------------------------------------*/

/* Functions for dynamic analysis (wapp.c) */
&& native("centroid",(unsigned long (*)()) centroid)
&& native("cgm",(unsigned long (*)()) cgm)
&& native("cmagphase",(unsigned long (*)()) cmagphase)
&& native("-cmagphase",(unsigned long (*)()) cmagphase1)
&& native("detrend",(unsigned long (*)()) detrend)
&& native("*dircos9",(unsigned long (*)()) stardircos9)
&& native("logarea",(unsigned long (*)()) logarea)
&& native("ma",(unsigned long (*)()) moveave)
&& native("mtot",(unsigned long (*)()) movetot)
&& native("retrend",(unsigned long (*)()) retrend)
&& native("solve",(unsigned long (*)()) solve)
&& native("steady",(unsigned long (*)()) steady)
&& native("tr",(unsigned long (*)()) tr)
&& native("tr1",(unsigned long (*)()) tr1)
&& native("trend",(unsigned long (*)()) trend)

/*--------------------------------------------------------------------*/

/* Functions for net.v */
&& native("logistic",(unsigned long (*)()) logistic)
&& native("stepping",(unsigned long (*)()) net_step)

/*--------------------------------------------------------------------*/

/* Functions for linear prediction.  */
&& native("lpcoef",(unsigned long (*)()) lpcoef)
&& native("lpeval",(unsigned long (*)()) lpeval)

/*--------------------------------------------------------------------*/

/* Functions for bdf.v (wapp.c) */
&& native("cylvec",(unsigned long (*)()) cylvec)
&& native("op2mat1",(unsigned long (*)()) op2mat1)
&& native("render",(unsigned long (*)()) render)
&& native("sphvec",(unsigned long (*)()) sphvec)

/*--------------------------------------------------------------------*/

/* Functions for genetic algorithm (wapp.c) */
&& native("ga_bit",(unsigned long (*)()) ga_bit)
&& native("ga_bitoff",(unsigned long (*)()) ga_bitoff)
&& native("ga_biton",(unsigned long (*)()) ga_biton)
&& native("ga_crossover",(unsigned long (*)()) ga_crossover)
&& native("ga_fill",(unsigned long (*)()) ga_fill)
&& native("ga_random",(unsigned long (*)()) ga_random)
&& native("ga_toggle",(unsigned long (*)()) ga_toggle)

/*--------------------------------------------------------------------*/
/* Functions for mday.n and other related files (wapp.c) */
&& native("cposn",(unsigned long (*)()) cposn)
&& native("crossing",(unsigned long (*)()) crossing)
&& native("crossing1",(unsigned long (*)()) crossing1)
&& native("dposn",(unsigned long (*)()) dposn)
/*&& native("dposn1",(unsigned long (*)()) dposn1)*/
&& native("dposn2",(unsigned long (*)()) dposn2)
&& native("mmax",(unsigned long (*)()) mmax)
&& native("mmaxf",(unsigned long (*)()) mmaxf)
&& native("mmaxN",(unsigned long (*)()) mmaxN)
&& native("mmaxN2",(unsigned long (*)()) mmaxN2)
&& native("mmaxr",(unsigned long (*)()) mmaxr)
&& native("mmaxV",(unsigned long (*)()) mmaxV)
&& native("mmaxv",(unsigned long (*)()) mmaxv)
&& native("mmin",(unsigned long (*)()) mmin)
&& native("mminf",(unsigned long (*)()) mminf)
&& native("mminN",(unsigned long (*)()) mminN)
&& native("mminN2",(unsigned long (*)()) mminN2)
&& native("mminr",(unsigned long (*)()) mminr)
&& native("mminv",(unsigned long (*)()) mminv)
&& native("mminV",(unsigned long (*)()) mminV)
&& native("newHL",(unsigned long (*)()) newHL)
&& native("pnckclps",(unsigned long (*)()) pnckclps)
&& native("rolldelta",(unsigned long (*)()) rolldelta)
&& native("runs",(unsigned long (*)()) runs)
&& native("vec_origin",(unsigned long (*)()) vec_origin)

/*--------------------------------------------------------------------*/

/* Transient analysis (wapp.c, wapp_f.f) */
&& native("uncoupled",(unsigned long (*)()) uncoupled)
