/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* vmo.h  December 2000

Copyright (c) 1999  D. R. Williamson

   Functions that use mgetty and vgetty for voice modem.

   The Makefile for tops will use the library and object files of the
   mgetty distribution (which includes vgetty) once it has been instal-
   led.  See sample scripts in usr/voice to create the include and li-
   brary files required.

   Source for mgetty download:
      vgetty-maintainer@alphanet.ch

   The November 2002 distribution of mgetty:
      mgetty1.1.29-Nov25.tar.gz 983945 (bytes) 

   Documentation:
      http://alpha.greenie.net/mgetty/index.html
      http://www.leo.org/~doering/mgetty/index.html

----------------------------------------------------------------------*/
 
/* Notes: 
      In mgetty voice functions, OK=0 and FAIL=-1 

      These are the flags for DTMF code handling 
         IGNORE_DTMF      (0)
         READ_DTMF_DIGIT  (1)
         READ_DTMF_STRING (2)
*/

#include <voice.h>
#include <voice_config.h>

void setdog(int n);
int vfprops(); /* vfprops (hFile --- ) */
int vmcommand(); /* vmcommand (qC qE --- f) */
int vmcompression(); /* vmcompression (comp speed bits --- f) */
int vmdiagnostics(); /* vmdiagnostics ( --- ) */
int vmdial(); /* vmdial (qS --- f) */
int vmevent(int event, event_data data);
int vmflow(); /* vmflow (flow --- f) */
int vmlog(); /* vmlog (qS --- ) */ 
int vmhandle_event(int event, event_data data);
int vmlog(); /* vmlog (qWord qText qData) */
int vmopen(char *device);
int vmplay(); /* vmplay (hFile --- f) */
int vmrecord(); /* vmrecord (hFile secs --- f) */
int vmregister(); /* vmregister (qS --- f) */
int vmstate(); /* vmstate ( --- qS) */
int vmstop(); /* vmstop ( --- ) */
int vmstruct(); /* vmstruct ( --- ) */
int vmunregister(); /* vmunregister ( --- ) */
int vmwatch(); /* vmwatch (n --- ) */

/* end vmo.h headers */
