/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
 /* define's for BIT_00 through BIT_29 {{{1 */
#define BIT_00 ((long long) 1 <<  0)
#define BIT_01 ((long long) 1 <<  1)
#define BIT_02 ((long long) 1 <<  2)
#define BIT_03 ((long long) 1 <<  3)
#define BIT_04 ((long long) 1 <<  4)
#define BIT_05 ((long long) 1 <<  5)
#define BIT_06 ((long long) 1 <<  6)
#define BIT_07 ((long long) 1 <<  7)
#define BIT_08 ((long long) 1 <<  8)
#define BIT_09 ((long long) 1 <<  9)
#define BIT_10 ((long long) 1 << 10)
#define BIT_11 ((long long) 1 << 11)
#define BIT_12 ((long long) 1 << 12)
#define BIT_13 ((long long) 1 << 13)
#define BIT_14 ((long long) 1 << 14)
#define BIT_15 ((long long) 1 << 15)
#define BIT_16 ((long long) 1 << 16)
#define BIT_17 ((long long) 1 << 17)
#define BIT_18 ((long long) 1 << 18)
#define BIT_19 ((long long) 1 << 19)
#define BIT_20 ((long long) 1 << 20)
#define BIT_21 ((long long) 1 << 21)
#define BIT_22 ((long long) 1 << 22)
#define BIT_23 ((long long) 1 << 23)
#define BIT_24 ((long long) 1 << 24)
#define BIT_25 ((long long) 1 << 25)
#define BIT_26 ((long long) 1 << 26)
#define BIT_27 ((long long) 1 << 27)
#define BIT_28 ((long long) 1 << 28)
#define BIT_29 ((long long) 1 << 29)
/* 1}}} */

#define NOTAG            0
#define TAG_SPARSE       BIT_00
#define TAG_COMPLEX      BIT_01
#define TAG_SYMMETRIC    BIT_02
#define TAG_LOWER_TRI    BIT_03
#define TAG_UPPER_TRI    BIT_04
#define TAG_FACTOR_LU    BIT_05
#define TAG_FACTOR_L     BIT_06
#define TAG_FACTOR_U     BIT_07
#define TAG_OUT_OF_CORE  BIT_08
#define TAG_SYMBOLIC     BIT_09

/* LAPACK, MUMPS, UMFPACK, SPOOLES encoded in bits 10, 11, 12 */
#define TAG_LAPACK       BIT_10
#define TAG_MUMPS       (BIT_10 + BIT_11         )
#define TAG_UMFPACK     (BIT_10          + BIT_12)
#define TAG_SPOOLES     (BIT_10 + BIT_11 + BIT_12)
#define TAG_10_12       (BIT_10 + BIT_11 + BIT_12)

#define TAG_INDEXED      BIT_13
#define TAG_USE_INDEX    BIT_14

/* catalog pointer, file handle, database handle, port, socket, client
 * encoded in bits 15, 16, 17, 18 */
#define TAG_CATPTR       BIT_15
#define TAG_FILEH       (BIT_15 + BIT_16                  ) 
#define TAG_DBH         (BIT_15          + BIT_17         )
#define TAG_PORT        (BIT_15 + BIT_16 + BIT_17         )
#define TAG_SOCKET      (BIT_15                   + BIT_18)
#define TAG_CLIENT      (BIT_15 + BIT_16          + BIT_18)
#define TAG_15_18       (BIT_15 + BIT_16 + BIT_17 + BIT_18)

#define MAT_ROW_IDX(x) ((int *) ((x)->mat + (x)->row*(x)->col))
#define MAT_COL_IDX(x) ((int *) ((x)->mat + (x)->row*(x)->col) + (x)->row)

/* Functions for checking, setting, and clearing tag bits. */
void clear_tag     (stkitem *x);
void copy_tag      (stkitem *dest, stkitem src);
int  tag_is_null   (stkitem *x);
void dump_tag      (stkitem *x);
int   is_sparse    (stkitem *x);
void set_sparse    (stkitem *x);
void clr_sparse    (stkitem *x);
int   is_complex   (stkitem *x);
void set_complex   (stkitem *x);
void clr_complex   (stkitem *x);
int   is_symm      (stkitem *x);
void set_symm      (stkitem *x);
void clr_symm      (stkitem *x);
int   is_factor_lu (stkitem *x);
void set_factor_lu (stkitem *x);
void clr_factor_lu (stkitem *x);
int   is_factor_l  (stkitem *x);
void set_factor_l  (stkitem *x);
void clr_factor_l  (stkitem *x);
int   is_factor_u  (stkitem *x);
void set_factor_u  (stkitem *x);
void clr_factor_u  (stkitem *x);
int   is_symbolic  (stkitem *x);
void set_symbolic  (stkitem *x);
void clr_symbolic  (stkitem *x);
int   is_lapack    (stkitem *x);
void set_lapack    (stkitem *x);
void clr_lapack    (stkitem *x);
int   is_mumps     (stkitem *x);
void set_mumps     (stkitem *x);
void clr_mumps     (stkitem *x);
int   is_umfpack   (stkitem *x);
void set_umfpack   (stkitem *x);
void clr_umfpack   (stkitem *x);
int   is_spooles   (stkitem *x);
void set_spooles   (stkitem *x);
void clr_spooles   (stkitem *x);
int   is_oo_core   (stkitem *x);
void set_oo_core   (stkitem *x);
void clr_oo_core   (stkitem *x);
int   is_low_tri   (stkitem *x);
void set_low_tri   (stkitem *x);
void clr_low_tri   (stkitem *x);
int   is_up_tri    (stkitem *x);
void set_up_tri    (stkitem *x);
void clr_up_tri    (stkitem *x);
int   is_indexed   (stkitem *x);
void set_indexed   (stkitem *x);
void clr_indexed   (stkitem *x);
int   is_index_used(stkitem *x);
void set_index_used(stkitem *x);
void clr_index_used(stkitem *x);
int   is_catptr    (stkitem *x);
void set_catptr    (stkitem *x);
void clr_catptr    (stkitem *x);
int   is_fileh     (stkitem *x);
void set_fileh     (stkitem *x);
void clr_fileh     (stkitem *x);
int   is_dbh       (stkitem *x);
void set_dbh       (stkitem *x);
void clr_dbh       (stkitem *x);
int   is_port      (stkitem *x);
void set_port      (stkitem *x);
void clr_port      (stkitem *x);
int   is_socket    (stkitem *x);
void set_socket    (stkitem *x);
void clr_socket    (stkitem *x);
int   is_client    (stkitem *x);
void set_client    (stkitem *x);
void clr_client    (stkitem *x);

int  get_set_tag( int   get_set,   /* in       0 => get    !0 => set */
                  char *tag    ,   /* in */
                  int   tag_len,   /* in */
                  int  *is_set);   /* out */

void int2bin(char bits[65], long long value);
 
/* words for tag checking/setting */ 
int  is_sparse_word();  /* is_sparse   (hA --- f) */
int  show_tag();        /* show_tag    (hA ---  ) */
int  set_tag();         /* set_tag     (A qTag --- A) */
int  clr_tag();         /* clr_tag     (A qTag --- A) */
int  get_tag();         /* get_tag     (A qTag --- f) */
