/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2007  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* stp.c  June 2007

State processor.

Copyright (c) 2007  D. R. Williamson
*/

#define _POSIX_SOURCE /* GNU C Lib: features.h will set __USE_POSIX */
#include <stdio.h>

#include <ctype.h>

#define __USE_SVID

#undef  __EXTENSIONS__
#define __EXTENSIONS__ /* for stdlib.h, Sun */
#include <stdlib.h>

#include <setjmp.h>
#include <string.h>
#include <math.h>

#include "main.h"
#include "stk.h"

#include "ctrl.h"
#include "inpo.h"
#include "stp.h"
#include "sys.h"
#include "tex.h"

/*--------------------------------------------------------------------*/

/* MODEL = [C, P, M, G, H, L, D, XUP, XDN, CP1, CN1, C6];
   where columns are defined in the map given in file mday.n,
   word Model(). */

/* Local headers. */
double *C;
char LIB[16];    /* using this library */
double *MODEL;   /* array of data from LIB; see above */
void next(void); /* take next step */
int State;       /* current state */
double *STATES;  /* array of states from LIB */
int step;        /* current step */
int Steps;       /* max steps and number of rows in arrays */

/* State functions: */
void sn01(void);
void sn02(void);
void sn03(void);
void sn04(void);
void sn05(void);
void sn06(void);
void sn07(void);
void sn08(void);
void sn09(void);
void sn10(void);
void sn11(void);
void sn12(void);

void sp01(void);
void sp02(void);
void sp03(void);
void sp04(void);
void sp05(void);
void sp06(void);
void sp07(void);
void sp08(void);
void sp09(void);
void sp10(void);
void sp11(void);
void sp12(void);

/*--------------------------------------------------------------------*/

#define IFSHOWTRACE \
   if(RTRACE) { \
      gprintf(" State %d",State); \
      nc(); \
   } \

void next()
{
   if(step<Steps) {
      State=*(STATES+step);
      step++;
   }
   else State=0; /* done */

   if(0 && RTRACE) {
      gprintf(" step: %d State: %d",step,State);
      nc();
   }
}

void sn01()
{
   IFSHOWTRACE
}

void sn02()
{
   IFSHOWTRACE
}

void sn03()
{
   IFSHOWTRACE
}

void sn04()
{
   IFSHOWTRACE
}

void sn05()
{
   IFSHOWTRACE
}

void sn06()
{
   IFSHOWTRACE
}

void sn07()
{
   IFSHOWTRACE
}

void sn08()
{
   IFSHOWTRACE
}

void sn09()
{
   IFSHOWTRACE
}

void sn10()
{
   IFSHOWTRACE
}

void sn11()
{
   IFSHOWTRACE
}

void sn12()
{
   IFSHOWTRACE
}

void sp01()
{
   IFSHOWTRACE
}

void sp02()
{
   IFSHOWTRACE
}

void sp03()
{
   IFSHOWTRACE
}

void sp04()
{
   IFSHOWTRACE
}

void sp05()
{
   IFSHOWTRACE
}

void sp06()
{
   IFSHOWTRACE
}

void sp07()
{
   IFSHOWTRACE
}

void sp08()
{
   IFSHOWTRACE
}

void sp09()
{
   IFSHOWTRACE
}

void sp10()
{
   IFSHOWTRACE
}

void sp11()
{
   IFSHOWTRACE
}

void sp12()
{
   IFSHOWTRACE
}

int stp() /* stp (qLIB --- ) */
{
    if(tos->typ!=STR && tos->typ!=VOL) {
      stkerr(" stp: ",STRORVOLNOT);
      return 0;
   }
   strncpy(LIB,tos->tex,15);
   *(LIB+15)='\0';
   drop();

   if(!extract1(LIB,"MODEL0")) {
      gprintf(" stp: in library %s, no array MODEL0",LIB);
      stkerr("","");
      nc();
      return 0;
   }
   MODEL=tos->mat; /* data array from LIB */
   Steps=tos->row;
   drop();

   C=MODEL+locvec(1,Steps);

   if(!extract1(LIB,"STATE")) {
      gprintf(" stp: in library %s, no array STATE",LIB);
      stkerr("","");
      nc();
      return 0;
   }
   STATES=tos->mat; /* states array from LIB */
   drop();

   RTRACE=1;

   State=0;
   step=0;

   while(step<Steps) {
      next();
      switch(State) {
         case -1: sn01(); break;
         case -2: sn02(); break;
         case -3: sn03(); break;
         case -4: sn04(); break;
         case -5: sn05(); break;
         case -6: sn06(); break;
         case -7: sn07(); break;
         case -8: sn08(); break;
         case -9: sn09(); break;
         case -10: sn10(); break;
         case -11: sn11(); break;
         case -12: sn12(); break;

         case 1: sp01(); break;
         case 2: sp02(); break;
         case 3: sp03(); break;
         case 4: sp04(); break;
         case 5: sp05(); break;
         case 6: sp06(); break;
         case 7: sp07(); break;
         case 8: sp08(); break;
         case 9: sp09(); break;
         case 10: sp10(); break;
         case 11: sp11(); break;
         case 12: sp12(); break;
      }
   }
   if(RTRACE) gprintf(" END\n"); 
   return 1;
}

/* end stp.c functions */
