/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* sql.h

   Albert Danial November 23 2003

*/

#include <sqlite3.h>
int sqlite3OsFileExists(const char*); /* doesn't appear in <sqlite3.h> */

#define SQL_BLOCK_SIZE 1000 /* max # element data rows returned by SQL query */
/*
  
  +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +

  +                              Note!                                        +

  +  The optimal size of SQL_BLOCK_SIZE depends on SQLite I/O speed on the    +
     target platform.  If SQL_BLOCK_SIZE is too small, performance will
  +  suffer severely.  On the other hand, making it larger than the "sweet    +
     spot" value will chew up a lot of memory without additional performance
  +  gains and possibly cause runtime crashes in any function that declares   +
     a variable of type 'callback_data'.  For reference, the optimal size of
  +  SQL_BLOCK_SIZE on a PIII 730 MHz system with "hdparm -tT" values of 162  +
     and 23 MB/sec is about 10000 (which makes the 'callback_data' variable
  +  18.4 MB).  On the otherhand if this exceeds memory available at runtime  +
     (issue the command 'cat /proc/meminfo | grep -i memtotal') the code may
  +  segfault at runtime.                                                     +
     On faster computers with more memory, experiment with larger values of
  +  SQL_BLOCK_SIZE.  Memory used by the variable 'callback_data' in bytes =  +
         SQL_BLOCK_SIZE x (1 + SQL_MAX_COLUMNS x (SQL_MAX_ID_LEN + 12))        
  +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +   +

 */


#define SQL_STR_SIZE   200   /* database file name length                     */
#define SQL_MAX_COLUMNS 20   /* max columns of int, double, and strings       * 
                              * returned by SQLite callback from an SQL query */
#define SQL_MAX_ID_LEN  80   /* max length of element, node, property, etc ID */

typedef struct {
  sqlite3 *db;                    /* database handle                         */
  FILE   *out;                    /* output file handle                      */
  char    nullvalue[SQL_MAX_COLUMNS]; /* string to display for NULL's        */
  char    zDbFilename[SQL_STR_SIZE];  /* db filename                         */
  int     nRows;                  /* size of a[]/i[]/x[] with valid data     */
  int     nCols;                  /* number of columns in a/i/x              */
  int     row_index;              /* pointer to current row within the table */
  int     type[SQL_MAX_COLUMNS];  /* datatype for a given column; one of
                                   *   SQLITE_INTEGER
                                   *   SQLITE_FLOAT  
                                   *   SQLITE_TEXT   
                                   *   SQLITE_BLOB   
                                   *   SQLITE_NULL   
                                   * (values from <sqlite3.h> )              */
  char    name[SQL_MAX_COLUMNS][SQL_MAX_ID_LEN];  /* column's name           */
  char    a[SQL_BLOCK_SIZE][SQL_MAX_COLUMNS][SQL_MAX_ID_LEN];  /* string data*/
  int     i[SQL_BLOCK_SIZE][SQL_MAX_COLUMNS];              /* integer data   */
  double  x[SQL_BLOCK_SIZE][SQL_MAX_COLUMNS];              /* double  data   */
  char    err_msg[SQL_STR_SIZE];
} callback_data;

/* words */
int db_open();              /* db_open  ( qFilename --- dbh ) */
int db_open2();             /* db_open2 ( qFile1 qFile2 qAlias --- dbh ) */
int db_close();             /* db_close ( dbh --- )           */
int db_attach();            /* db_attach( dbh qFilename qAlias --- ) */
int db_detach();            /* db_detach( dbh qAlias --- )    */
int sql();                  /* sql      ( dbh qSQL --- )      */

/* internal functions */
int open_db(callback_data *p);
int sql_scalar_i(sqlite3 *dbh, char *query, char *error_string);
int sql_push_scalar(int r, int c, callback_data buffer);
int sql_cmd(sqlite3 *sql_dbh,
            char    *caller_name,
            char    *command);

/* SQLite callback functions.  a=string   i=int   d=double */
int sql_do_query(sqlite3 *dbh, char *query, callback_data *buffer);
