/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* matlab.h  April 2001

   Copyright (c) 2001   D. R. Williamson

   Reference:
      "Matlab Application Program Interface Guide, Version 5,"
      The Math Works, January 1997.
*/

/*--------------------------------------------------------------------*/
/* Prototypes from Matlab's /usr/local/matlab/extern/include/engine.h
   and /usr/local/matlab/extern/include/matrix.h: */

typedef struct mxArray_tag mxArray;
typedef struct engine Engine;
typedef enum {
   mxREAL,
   mxCOMPLEX
} mxComplexity;

extern int engClose(Engine *ep /* engine pointer */);
extern int engEvalString(
   Engine *ep,        /* engine pointer */
   const char *string /* string for matlab to execute */
   );
extern int engGetFull(
   Engine *ep,  /* engine pointer */
   char *name,  /* full array name */
   int *m,      /* returned number of rows */
   int *n,      /* returned number of columns */
   double **pr, /* returned pointer to real part */
   double **pi  /* returned pointer to imaginary part */
   );
extern Engine *engOpen(const char *startcmd);
extern int engPutArray(
   Engine *ep, /* engine pointer */
   const mxArray *ap /* array pointer */
   );
extern mxArray *mxCreateDoubleMatrix(int m, int n, mxComplexity flag);
extern double *mxGetPi(
   const mxArray *ap /* array pointer */
   );
extern double *mxGetPr(
   const mxArray *ap /* array pointer */
   );
extern void mxSetName(
   mxArray *ap, /* array pointer */
   const char *string /* string for name */
   );

/*--------------------------------------------------------------------*/

/* This program's matlab functions: */
int _engClose(); /* _engClose (ep --- f) */
int _engEval(); /* _engEval (qS ep --- f) */
int _engGet(); /* _engGet (qA ep --- -1 | hA 0) */
int _engOpen(); /* _engOpen (qS --- ep) */
int _engPut(); /* _engPut (hA ep --- f) */

/* end matlab.h headers */
