/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* mat.h  April 1999

Copyright (c) 1999  D. R. Williamson
*/

int bang(); /* bang (x hA --- ) */
int bend(); /* bend (hA --- hB) */
int byte(); /* byte (qS n --- c) */
int bytestore(); /* byte! (qS c n --- qS1) */
int catch(); /* catch (hA n | hA hCols --- hB) */
int cats(); /* (qS n --- qS1) */
int chain(); /* chain (hA --- hV) */
int chainr(); /* chainr (hA --- hV) */
int character(); /* character (qS k --- qS1) */
int chop(); /* chop (qS --- qS1) */
int claw(); /* claw (hA hRake --- hA0 hA1) */
int clone(); /* clone (hA n --- hB) */
int compint(const void *, const void *);
int cram(); /* cram (hB hC hA --- ) */
int crop(); /* crop (hT n1 n2 --- hT1) */
int export1(); /* export1 (hA --- hT) */
int export2(); /* export2 (hA toendian --- hT) */
int export4(); /* export4 (hA toendian --- hT) */
int export8(); /* export8 (hA toendian --- hT) */
int fetch(); /* fetch (hA i j --- x) */
int fold(); /* fold (hV r --- hA) */
int foldr(); /* foldr (hV r --- hA) */
int goose(); /* goose (d hV n --- ) */
int gram_schmidt(); /* gram-schmidt (hA --- hG) */
int hand(); /* hand (x --- hA) or (qS --- hT) */
int I3x3(); /* I3x3 ( --- hI3x3) */
int inclusive(); /* inclusive (hA x1 x2 --- hRake) */
int identity(); /* identity (n --- hA) */
int import1(); /* import1 (hT --- hA) */
int import2(); /* import2 (hT fromendian --- hA) */
int import4(); /* import4 (hT fromendian --- hA) */
int import4f(); /* import4f (hT fromendian --- hA) */
int import8(); /* import8 (hT fromendian --- hA) */
int items(); /* items (n0 N --- hList) */
int limited(); /* limited (hA Amin Amax --- hA1) */
int listfin(); /* listn ( ... n --- hA) */
int matrix(); /* matrix (hV r --- hA) */
int mesh(); /* (hA0 hA1 hRake --- hA) */
int move1(); /* move (hB hA --- ) */
int movec(); /* movec (hV hA c --- ) */
int nodupes(); /* nodupes (hA --- hA1) */
int nodupes1(); /* nodupes1 (hA --- hA1) */
int nullc(); /* nullc (hA --- hNcols) */
int nullr(); /* nullr (hA --- hNrows) */
int origin(); /* Origin ( --- null3x1) */
int ontop(); /* ontop (hA --- x) */
int park(); /* park (hA hB --- hC) */
int parkm(); /* park (hA hB --- hC) */
int parkn(); /* parkn (hA1 ... hAn n --- hA) */
int pile(); /* pile (hA hB --- hC) or (hT hU --- hV) */
int pilem(); /* pile (hA hB --- hC) */
int pilen(); /* pilen (hA1 ... hAn n --- hA) */
int pileof(); /* pileof (qS n --- hT) */
int place(); /* place (hB hA r c --- ) */
int place1(); /* place1 (hB hA hR hC op --- hA1) */
int placevec(); /* placevec (hA hC --- hB) */
int poke(); /* poke (x hA n --- ) */
int pry(); /* pry (hA n --- x) */
int rake(); /* rake (hA hRake --- hA0 hA1) */
int ram(); /* ram (hB hC hA --- ) */
int reach(); /* reach (hA n | hA hRows --- hB) */
int reach1(); /* reach1 (hA hR --- hB) */
int reach2(); /* reach2 (hA hR --- hB) */
int repeat1(); /* repeat (hA n --- hB) */
int replace(); /* replace (hA hOff d --- hB) */
int reversed(); /* reversed (hA --- hB) */
int reversed1(); /* (hA --- hB) */
int sling(); /* sling (hV --- hRake) */
int sling1(); /* sling1 (hV --- hRake) */
int sq1(); /* sq (hV --- hA) vector V into square, diagonal A */
int store(); /* store (x hA i j --- ) */
int stretch(); /* stretch (hA r --- hA1) */
void stretch4(float *A, double *B, int len);
int sym_unpack(); /* sym_unpack (hV --- hA) */
int thereat(); /* thereat (hA hX --- hRake) */
int thrulist(); /* thrulist (n1 nK --- hN) */
int tier(); /* (hA0 hA1 hRake --- hA) */
int tovector(); /* diag (hA --- hV) diagonal of A into vector */
int tril(); /* tril (hA n --- hL) */
int trilp(); /* trilp (hA --- hL) */
int triu(); /* triu (hA n --- hU) */
int triup(); /* triup (hA --- hU) */
int uimport1(); /* uimport1 (hT --- hA) */
int uimport2(); /* uimport2 (hT fromendian --- hA) */
int uimport4(); /* uimport4 (hT fromendian --- hA) */
int uniform(); /* uniform (x n --- hN) */
int within(); /* within (x x1 x2 --- f) */
int Xvec(); /* Xvec ( --- h3x1) */
int Yvec(); /* Yvec ( --- h3x1) */
int Zvec(); /* Zvec ( --- h3x1) */
int inflate(); /* inflate (hA hRind hCind R C --- hB) */
int shuffle(); /* shuffle (hA --- hB) */

/* end mat.h headers */

