/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* lib.h  April 1999

Copyright (c) 1999  D. R. Williamson
*/

#if !defined(HAVE_MEM)
#include "mem.h"
#endif
/*
   Catalog description: 

      The catalog is divided into a main library and many local 
      libraries:

         The main library has two regions (symbol=DATA__):

            DATA__ (catalog types VARI, MATR, STRI, VOLU)
            CODE__ (catalog types NATI, CONS, DEFN, INLI)

         Local libraries (symbol=word name):

            Every word has a local library.  Possible catalog 
            types in the library of a word are: 
               VARI, MATR, STRI, VOLU, INLI

      The Main library is also called "main."  A search of main for 
      matches to patterns involves looking in DATA__ and then in 
      CODE__.  

   Searching the catalog for names:

      Names in the catalog are tagged with symbols that control
      how they are found.  A tag consists of a separation pattern
      followed by the name of the library where it resides, in
      the form:

         cat_name+SEP+lib_name

      The separation pattern separates the library name where an
      item is located from the name of the catalog that contains
      the named library.

      Function caton2() implements the program's search strategy 
      described as follows:

         Look first for an item booked in the local library 
         having the tag at the current run level (called the 
         context), cattag+onbuf.

         Failing to find an item in the local library, look next 
         in the CODE__ region of main for a native word, constant, 
         define or inline word to fire.

      Local library means the library of the currently running word.

      By defining DATA__ to be the "local" library of main, caton2() 
      works as described above for finding items stored in the two
      regions of main.

      Function book() that places items into the catalog ensures that 
      DATA__ and CODE__ never contain items names that match, so all
      names in these two main regions are unique. */
      
/* The symbol for the local library of a word is the name of the word. 
   Here is the symbol for the "local" library of main: */
#define MAINLIB "DATA__" /* the word where main data goes */

/* The description above applies to a single catalog.  

   By defining a variable SEP symbol in the pattern 
      "cat_name+SEP+lib_name,"
   the catalog can contain a number of catalogs, each with separate
   code and data.

   Each of these different catalogs will be called a catalog library.

   Allowing catalog libraries: */
int onlib;     /* current library number */
char LIBID[4]; /* current library identifier (see libset()) */

/* These are the numbers of the catalog libraries (update these in 
   word.p if this enumeration changes); LIB0 is the one the program 
   always starts up within: */
enum libs {LIB0=0,LIB1,LIB2,LIB3,LIB4,
           NLIBS}; /* this last element is the count */

/*--------------------------------------------------------------------*/

char DEFNAM[DEFNC+1]; /* name of the word being built by define: */
char DEFTAG[DEFNC+1]; /* local library tag of word being defined */
#define DEFCH 16384   /* max bytes of text in each defined word */

#define CATBINS 4096 /* hash bins for catalog lookup */
int catwords; /* number of words currently in the catalog (no limit) */

enum cattyp {UNK=0,NATI,DEFN,CONS,VARI,MATR,STRI,VOLU,INLI};

typedef struct catitem_ {
   char typ; /* word type (one of enum cattyp listed above) */
   char *nam; /* word name */
   unsigned long (*exe)(); /* exe addr to fire this word (nam):
      If typ NATI: exe runs a function directly
         typ DEFN: exe will run stk typ VOL or PTR
         typ CONS: exe will push stk typ NUM to stack
         typ VARI: exe will push stk typ NUM to stack
         typ MATR: exe will push stk typ MAT to stack
         typ STRI: exe will push stk typ STR to stack
         typ VOLU: exe will push stk typ VOL to stack
         typ INLI: exe will push stk typ PTR to stack */

/* exe1 and nam2 are used when (*EXE_REMOTE)() has replaced (*exe)(); 
   see exe_remote() in exe.c): */
   unsigned long (*exe1)(); /* exe addr to fire when not remote */
   char *nam2;              /* word name to run when remote */

   stkitem *stk; /* NOTE: catitem->stk==0 if not a stack item */
   unsigned int seq; /* when word was defined: for fence */
   struct catitem_ *nex; /* next *catitem in linked list */
} catitem;

/* Global catitems */
catitem catalog[CATBINS];
catitem *oncat; /* ptr to catalog item found by caton or catloc */
patitem *ptrnum; /* global table of oncat pointers for ptr NUMs */

/* Balance of local stack push/pull, checked during assembly: */
int tdepth1; /* used by define() and inline1() */

/* Header for function in word.c: */
extern int nativewords(int lib);

/* Headers for functions in lib.c: */
int begind(); /* BEGIN ( --- ) */
int book(int v);
int book1(); /* book (hA qS --- ) */
int bump(); /* bump (x X --- ) */
int catadd(int type, char *word, unsigned long (*exe)(), 
   stkitem *stk, int verbose);
int catbins(); /* catbins ( --- ) */
void catinit();
int catitems(); /* _catitems (k --- hT) */
catitem *catfetch(char *name);
void catfree (catitem **catptr, int len);
catitem *catloc(char *word, int *new);
int catnames(); /* catnames ( --- hT) */
int caton(char *word);
int caton2(char *word);
int caton3(char *word);
int catsearch1(); /* catsearch (qS --- hT) */
int catseq(); /* catseq (qS --- n) */
int constant(char *word, char *number);
int container(); /* _container (qWord --- ) or library (qWord --- ) */
void context(char *tag);
int cprops(); /* cprops (qS --- ) */
int ctype(); /* ctype() (qS --- N) */
int define(); /* define: ( --- ) */
int define1(int opt);
int definenot(); /* define: ( --- ) */
int defname(); /* defname ( --- qS) */
int dojmpd(); /* LOOP ( --- ) or +LOOP (n --- ) */
int doloopd(); /* DO (n2 n1 --- ) and ?DO (n2 n1 --- ) */
int end1d(); /* ( --- ) */
int _exists(char *S);
int exists(); /* exists? (qS --- f) */
int extract(); /* extract (qW qS --- hA) */
int fence(); /* fence ( --- ) */
int fence_at(); /* fence_at ( --- n) */
int ifbranchd(); /* IF (f --- ) */
int global(); /* global (qA --- ) */
int implant(); /* implant (hA qW qS --- )  bank (hA qW qS --- ) */
int implant2(); /* bank* (d qW qA --- ) */
int inline2(); /* inline: ( --- ) */
int into(); /* into (hA --- ) */
int lcatitems(); /* lcatitems (nLib --- hT) */
int lexists(); /* lexists? (qS nLib --- f) */
int libget(); /* libget (qS nLib --- hA) */
int libglobals();  /* libglobals ( --- ) */
int libinit(int nlib);
int libpry(); /* libpry (qS --- hA) */
int libput(); /* libput (X qS nLib --- )*/
int libset(int lib);
int libset1(); /* libset (nLib --- ) */
int listd(); /* list: ( --- hA) */
int localq(); /* local? (qS --- f) */
int localref(); /* localref (qWord qName --- qS) */
int matptr(); /* matptr (hA --- ptr) */
int native(char *word, unsigned long (*exe)());
int notag(); /* notag (qS --- qS1) */
void performd();
int ptr(); /* ptr (qS --- ptr) */
int ptrq(); /* ptr? (ptr --- f) */
int ptrtable(); /* ptrtable ( --- ) */
int ptrtok(); /* ptrtok (ptr --- qS) */
int quoted(char *word, char *token);
int repeatd(); /* REPEAT ( --- ) */
void strlocal(char *local_context); /* (qS --- qS || qS1) */
int tag(); /* tag ( --- qS) */
char *tagged(char *word, char *CONTEXT);
char *tagnative(char *word);
void tagmake(char *tag, char *text);
int tagon(char *word);
int tagsep(); /* tagsep ( --- qTAG) */
char *untagged(char *word);
int untild(); /* UNTIL (f --- ) */
int variable(char *word, double d);
int while1d(); /* WHILE (f --- ) */
int wordadd(char *token);

/* end lib.h headers */
