/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* inpo.h  March 1999   

Copyright (c) 1999  D. R. Williamson
 
*/
#define TOKBUF DEFNC+1
char *token; /* token for current run level in tokenArray */
char *tokenq; /* mallocked ptr to quote string, from tokenget() */

/* Max characters in array to hold one keyed text line: */
/* #define GOMAX 2+DEFNC*2 

GOMAX is being increased for instances when gprintf() contains \n.  
Recommended practice for good interactive response is to use is nc() 
with gprintf() so each displayed line is roughly the characters seen 
in the display on one line.  But the program will not fail if more 
than GOMAX characters flood the screen: */
#define GOMAX 4096

/* Current text line, same as line displayed on screen: */
char *GOUT;
char *GOUT1;

/* Characters in current displayed line: */
int chout; /* = strlen(GOUT) */

/* These enum items correspond to similarly ordered elements in the 
   "file" struct created in file.v: */
enum _file {fHAN,fTYP,fSTA,fSIZ,fREC,fHED,fPOS,fMOD,fMAG,fLEN};

int blank(char c);
char *blockget(char *str);
int bootfile(); /* ( --- qFile) */
char braceskip();
int copy4(); /* copy4 (hFile1 qS1 hFile2 qS2 --- ) */
int cr(); /* cr ( --- ) */
int dirq(); /* dir? (qS --- f) */
int dirnames(); /* dirnames (qDir --- hT) */
int dirsize(); /* dirsize (qS --- s) */
int dotreprint(); /* reprint (qS n --- ) */
int echo1(); /* echo (hA --- ) */
int emit(); /* emit (n --- ) */
int export(int size, int toendian); /* (hA --- hT) */
int fallow(); /* fallow (qFile --- f) */
int fappend(); /* append (hT qS --- ) */
int feed(); /* feed ( --- qS or NULL(error)) */
int fileatime(); /* fileatime (qS --- s) */
int fileclose(); /* fclose (hFile --- ) */
int filectime(); /* filectime (qS --- s) */
int filefound(); /* filefound (qS --- 0 or qFile1 f) */
int fileget(); /* fget (hFile bytes --- hA) */
int filegetr(); /* fgetr (hFile hR --- hA) */
FILE *filehand(double *F, int len);
int fileid(); /* filetrue (hFile --- f) */
char *fileload(char *filename);
int fileopen(); /* file (qFile qS --- ) */
int fileopen1(); /* filetemp (qFile qS --- ) */
int fileput(); /* fput (hA hFile --- ) */
int fileput2(); /* fput2 (hA hFile --- ) */
int fileputr(); /* fputr (hA hFile hR --- ) */
int fileq(); /* file? (qS --- f) */
int fileseek(); /* fseek (hFile bytes --- ) */
int filesize(); /* filesize (qFile --- bytes | -1) */
int filesize1(); /* fsize (hFile --- bytes) */
int filestep(); /* fstep (hFile bytes --- ) */
int filetime(); /* filetime (qS --- s) */
int format(); /* format (hA qS --- hT) */
int fortmap(); /* fortmap (hFile endian --- hMap) */
int fortput(); /* fortput (hA hFile --- ) */
int fortread(FILE *fp, double *hFile, unsigned int *array,\
   unsigned int lenmax, unsigned int *lenread);
int fortrecs(); /* fortrecs (hFile endian qWord --- ) */
int fortwrite(FILE *fp, double *hFile, unsigned int *p,\
   unsigned int bytes);
int fpos1(); /* fpos (hFile --- fpos) */
int fsave(); /* save (hT qS --- ) */
void fupdate(double *F, FILE *fp);
int fxray(); /* (hFile bytes --- hT) */
int get(); /* get (hFile qS --- hA) */
int get4(); /* get4 (hFile qS --- hA) */
int get4c(); /* get4c (hFile qS hC --- hA) */
int getn(); /* getn (hFile n --- hA1, ..., hAn) */
int gprintf(char *format, ...);
int import(int size, int fromendian); /* (hT --- hA) */
void _import4(int terms, int fromend, int *Afrom, int toend, int *Ato);
void inpoinit();
void insbks(char *str, int offset);
int lf(); /* lf ( --- ) */
char *mprintf(char *format, ...); /* WARNING: returned character 
                                     pointer must be freed by the 
                                     calling function. */ 
int nc(); /* nl ( --- ) */
int number(char *str, double *x);
int numbers(); /* numbers (qS --- hV) */
int out(); /* out ( --- c) */
char *patskip(char *s, char *s1, char c1, char d1,
                       char *s2, char c2, char d2, int *ok);
int printf1(); /* printf (qS --- qS1) */
int put(); /* put (hA hFile --- ) */
int put4(); /* put4 (hA hFile --- ) */
int putch1(); /* putch (n --- ) */
int putn(); /* putn (hA1 ... hAn n hFile --- ) */
char *quoteget(char *str);
int rembks(char *str);
int rembks1(); /* rembks (hT --- hT1) */
int reprint(unsigned int nchars, int chop);
int sp(); /* sp ( --- ) */
int stradv(char *s, char *s1);
int stradv1(char *s, char *s1, unsigned char c, unsigned char d);
int strlen1(char *str, int len);
int strmatch(char *str, char *pat);
int strnmatch(char *str, char *pat, int len);
int strsame(char *str1, char *str2);
int toc(); /* toc (hFile --- ) */
int _toc4(); /* _toc4 (hFile --- hT) */
int toc4(); /* toc4 (hFile --- ) */
int token0();
char *tokenget();
char *tokengetc();
int tout(); /* tout ( --- qS) */
int uimport(int size, int fromendian); /* (hT --- hA) */
int xray(); /* xray (hA or hFile bytes --- hT) */
int xray255(); /* xray255 (f --- ) */

/* end inpo.h headers */

