{  File tch1.v  June 2009 

   Copyright (c) 2009-2014   D. R. Williamson

   Source this file at the ready prompt so X11 is present.  X11 is
   required for controlling mouse clicks on the Netscape browser that
   is collecting data.

   IMPORTANT: remote LAN machine plunger is assumed to be the one to 
   reach when there is a problem with Netscape and the Internet con-
   nection.  See ServerHost in word clickRefresh1 below.

   The bottom of this file sets up multitasker jobs for collecting data
   from the Netscape browser cache.  

   When started on Sunday, this program will run unattended all week, 
   stopping and starting between 24-hour sessions.  

   For debug and test, search for "testing and debugging" and uncomment
   the line that follows.  Even when debugging, Netscape should be run-
   ning and logged into tradingcharts.com.

------------------------------------------------------------------------

   "tch1.v" asciiload this " inline:" grepr reach dot  

   Issues and revisions.

   Overview.

   Hint.

   Rollover.

\  Processing data.
   inline: BEEP ( --- ) \ error alarm
   inline: BOND (hT qTIME qCON qSYM --- ) \ process bond market prices
   inline: cache_process ( --- ) \ process market data from cache
   inline: CH>LA (qHH:MM:SS --- qHH1:MM:SS)
   inline: clickRefresh1 ( --- ) \ click mouse button and process cache
   inline: DECIMAL (hT qTIME qCON nFAC qSYM --- ) \ decimal prices
   inline: FILE_IN ( --- qFile) \ name of input file
   inline: FILE_OUT (qSYM --- qFile) \ name of output file
   inline: FILE_SEND (qFile --- ) \ send file to remote collector
   inline: FIX (hA --- hA1) \ fix bad values in A
   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
   inline: mrc_close ( --- ) \ close market data resources
   inline: mrc_open ( --- ) \ open market data resources
   inline: PROCESS (hA qTIME qCON qSYM --- )
   inline: setmkt (f qMkt --- ) \ set flag to process Mkt or not
   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
   inline: timequote (qS --- s) \ convert quote date to machine time

\  Testing and debugging.

\  Collecting data.
   inline: CLICK_START ( --- ) \ start multitasker clickRefresh
   inline: CLICK_END ( --- ) \ end multitasker clickRefresh
   inline: START ( --- ) \ depending on time of day, set the start task

   Appendix.
   Logging into the running program and doing repairs.
   System missed sending files at 22:15:04, but no errors in log.

------------------------------------------------------------------------

   Issues and revisions.

   Sat Mar 29 13:42:58 PDT 2014.  Two entries from the cache for each
   market are being read.  It turns out that one of them can be cor-
   rupted (after all, they are from a cache).  To read a saved cache
   of corrupted data, FILE_IN has added lines just for this session to
   debug and fix.  

   This shows string S going into timequote() (for market DJ); the 
   first one is good, the second one is not and causes an error to be 
   reported:

      [dale@riggo] /home/dale > tops
               Tops 3.2.1
      Sat Mar 29 13:40:44 PDT 2014
      [tops@riggo] ready > ww
       WORKING IN TEST MODE

       timequote incoming S:
      mar
      27
      19:24
      </td>
      <td
       timequote returned machine sec and date:
       1395966240 Thu Mar 27 19:24:00 CDT 2014 


       timequote incoming S:
      mar
      27
      n
      1
      
      b
      b
      <td
       ontop: term is out of bounds
       timequote returned machine sec and date:
       0 Wed Dec 31 18:00:00 CST 1969 

       FILE_SEND: testing; file /tmp1/DJ_TC1.eDAT not sent
       fault at word: cache_process
       faulty phrase: "tch1.v" source cache_process halt

      [tops@riggo] ready > 

   After fixing, this shows volume T (previously string S) going into
   timequote() (for market DJ); the first and only one is good, the
   second was detected as bad and the call to timequote() was never
   made:

      [dale@riggo] /home/dale > tops
               Tops 3.2.1
      Sat Mar 29 14:55:35 PDT 2014
      [tops@riggo] ready > ww
       WORKING IN TEST MODE

       timequote incoming T:
      mar
      27
      19:24
       timequote returned machine sec and date:
       1395966240 Thu Mar 27 19:24:00 CDT 2014 

       FILE_SEND: testing; file /tmp1/DJ_TC1.eDAT not sent

      [tops@riggo] ready > 

   Thu Mar 27 15:31:20 PDT 2014.  Word START has been revised to start
   a listening server and put its port number on the interprocess mes-
   sage file.  The port provides a point for entering the program for
   debugging.  

   The following session (with blank lines added for clarity) lists the
   message file to find that the listening port (TCH1_SERVER) is 10203,
   then connects with word CLIENT to the running program.  

   Once inside the program, we see from its list of multitasker tasks
   that 118 seconds remain, in its 180 second duty cycle, before the 
   Refresh button will be clicked:

      [dale@riggo] /home/dale > tops
               Tops 3.2.1
      Thu Mar 27 14:53:11 PDT 2014
      [tops@riggo] ready > msgToc

       Mar 27 14:53:16 PDT 2014 Messages in /home/dale/msgcomm:
        riggo 174.47.228.170
        STARTUP Sun Mar 23 10:35:16 PDT 2014
        TCONSERVER 10200
        TOPSE_SERVER 10202
        skipINO yes
        skipTC yes
        NIST_DELTA -17
        TCH1_SERVER 10203

      [tops@riggo] ready > IPloop 10203 CLIENT

       stack elements:
             0 number: 3
       [1] ok!
      [tops@riggo] ready > remoteprompt

      tops@socket3 > clients

       Server local is listening on port 10203
       Clients:
        socket 6, port  4399, conn S<C, 127.0.0.1 LOGIN dale riggo

      tops@socket3 > tasks

       Multitasker tasks:
        CLICK_END,0:CODE__ alarm period 84300 seconds; remaining 83157
        NIST_DELTA,0:CODE__ alarm period 14400 seconds; remaining 11843
        QT2,0:wavque_play 2 Hz; asleep
        clickRefresh1,0:CODE__ alarm period 180 seconds; remaining 118

      tops@socket3 > 

   Tue Mar 18 08:21:27 PDT 2014.  Intermittent errors began showing up
   in the program responsible for clicking the browser button and ex-
   tracting data from the browser cache.  A server on a listening port
   was started in that program to enable it to keep running while debug
   output was enabled and repairs were made remotely by connecting to 
   the port.  See Appendix, "Logging into the running program and doing
   repairs."

   Thu May  9 05:02:24 PDT 2013.  An alternate Internet connection on
   Verizon DSL goes out intermittently, but comes back soon enough that
   the system is generally not affected.  But clicking the refresh but-
   ton when there is no connection causes a Netscape popup window that
   reports "connection refused" and nothing works until the window is
   manually removed (by clicking OK).  Word clickRefresh1() has been
   modified to check for an Internet connection, and if there is not
   one, just return without clicking the refresh button.  

   On May 3, 2010, near the end of the Sunday-Monday session, the cache
   containing data to be processed became filled with random data that
   looked like encryption or just plain garbage.  The LAN check on
   plunger caught that no new data was coming.

   A call to TradingCharts revealed that they had changed nothing.  Re-
   starting Netscape and clearing the cache did no good.  But after 3 PM
   when the markets started up for the next session, everything worked 
   just fine.  The cache contained readable HTML.

------------------------------------------------------------------------

   Rollover.

   When contracts are rolled, the Member's quote table must be updated;
   the program will ignore markets in the Member's table that do not 
   have contracts matching the ones being collected.  Be careful to get 
   the electronic prices and not the pit prices (if prices do not up-
   date when the session starts, you'll know you did not get electronic
   prices).

   It may be that the former contract, which is still in the Netscape 
   cache, will be found by the processor and used, resulting in a mis-
   match and this message when files are being sent to the host:
      DECIMAL: wrong contract for CL

   The processor code has not been changed to correct this.

   To correct this problem, exit Netscape and run nclean to clear the 
   cache.  Then start Netscape and log in again:
      [dale@diego] /home/dale > nclean
      rm: cannot remove `lock': No such file or directory
      .  ..  _CACHE_MAP_  _CACHE_001_  _CACHE_002_  _CACHE_003_  
      C39DAB07d01  D2F762C6d01  69F762C6d01
      [dale@diego] /home/dale > netscape &

------------------------------------------------------------------------

   Overview.

   Process price data from the Netscape cache, written by Netscape when
   the update button has been clicked on a Member's custom quote web 
   page for tradingcharts.com.

   Netscape is running at http://members.tradingcharts.com/myquotes/
   which is a paid service requiring login with user name and password:
      Site address: http://members.tradingcharts.com
      User name: xxxxxx
      Password: *******
      Email: sales@tradingcharts.com
      Telephone: 1-306-445-7330

   Once logged in, this file will process tradingcharts.com Netscape 
   cache data, and write files in /tmp that match files from the regular
   collector, so they will be picked up when hist_add() runs to append 
   latest data to each market's history file.

   Note that updated data contributed by this file's cache_process() is
   effectively tied to the queue that controls the collections.  It will
   not appear at a market console until the next collection job runs 
   (once every 7 minutes), the history-add job runs (immediately after
   the collection job), and the real time server picks up the new data 
   and informs the market console (about 1 to 2 minutes). 

   [Update: Word FILE_SEND has been modified to connect to the collector
   and run its history-add as if this script was one the collector had
   dispatched.  That eliminates the delay waiting for the collector to
   run one of its own collection jobs.]

   Unlike the free web pages at tradingcharts.com, the Member's quote
   page entries show Chicago time, even for New York markets, and the
   time does not include the mandated exchange delay (about 10 minutes).
   These differences are accounted for below when processing the time, 
   by converting to LA time (the convention for collected files) and 
   deducting the provided delay time (in minutes).

   Here are notes from mget.v about the order of collected prices:

      From bch.v, this is the order of things from way back when:

         "Showing: Open High Low Settle Close Chg Vol OpenInt"

      and here is some code in bch.v showing that close follows settle 
      and is preceded with character c:
            peek 4 ndx quote SCALE       \ open
            peek 5 ndx quote SCALE       \ high
            peek 6 ndx quote SCALE       \ low
            peek 2 ndx quote SCALE       \ settle
            "c" over cat hand            \ close [or last]

       So here [in mget.v], grab the fifth item (actually the sixth 
       because open is the second item) and expect that collectors 
       place the settle fourth and the close fifth as above.

   The words in this file (like BOND and DECIMAL) adhere to this con-
   vention, where the order is:

      Open, High, Low, Settle, Last (or close)

   with character c preceding the Last price.

------------------------------------------------------------------------

   Hint.

   The best way to write a file like this one is to step through writ-
   ing and testing the code one line at a time, moving a line like the 
   following in the word being written:

      "HALTING" . nl S HALT

   lower and lower to view processing so far and invent the next line,
   or phrase, right there on the stack.  In the above, S had just been 
   booked so it is placed on the stack before HALT.

   Text arrays on the stack can be viewed by running "dup eview" or 
   "dup iview" to dup the topmost stack item and pop it into an editor.

   Setting work.v to have its first line source this file and run the 
   word being worked on, like cache_process,

      "tch1.v" source cache_process halt

   makes stepping as easy moving the HALTING phrase, saving the change 
   (:w in vi) and typing ww (the word that sources work.v) to run that 
   first line in work.v.

------------------------------------------------------------------------

   Rollover.

   When contracts are rolled, the Member's quote table must be updated;
   the program will ignore markets in the Member's table that do not
   have contracts matching the ones being collected.  Be careful to get
   the electronic prices and not the pit prices (if prices do not up-
   date when the session starts, you'll know you did not get electronic
   prices).

   It may be that the former contract, which is still in the Netscape
   cache, will be found by the processor and used, resulting in a mis-
   match and this message when files are being sent to the host:
      DECIMAL: wrong contract for CL

   The processor code has not been changed to correct this.

   To correct this problem, exit Netscape and run nclean to clear the
   cache.  Then start Netscape and log in again:
      [dale@diego] /home/dale > nclean
      rm: cannot remove `lock': No such file or directory
      .  ..  _CACHE_MAP_  _CACHE_001_  _CACHE_002_  _CACHE_003_
      C39DAB07d01  D2F762C6d01  69F762C6d01
      [dale@diego] /home/dale > netscape &

------------------------------------------------------------------------

}
   CATMSG push no catmsg
   "tsession" missing IF "mrc.v" source THEN

   "soonest_task" missing 
   IF usrpath "mget.v" + "#def timeline" "#end timeline" msource1 THEN

   usrpath "mget.v" + "#def Mo_fix" "#end Mo_fix" msource1

   "R-ATTENTION" missing IF syspath "snd.v" + source THEN

\-----------------------------------------------------------------------

\  Processing data.

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

   inline: BOND (hT qTIME qCON qSYM --- ) \ process bond market prices
\     Format bond and note prices and write collection file.

      "SYM" book "CON" book "TIME" book "T" book

      SYM MOdo CON <>
      IF " BOND: wrong contract for " SYM + . nl return THEN

      SYM "US" = IF no ELSE yes THEN "64ths" book

      [ "32 / +" "DIV"  macro  
        "64 / +" "DIV1" macro ]
{
      August 30, 2009: the site has changed divisor for US from 64 to 
      32, divisor for TN from 128 to 64.  The examples below reflect
      the former divisors.

      These are six typical rows of incoming T for US:
         116 56 DIV  (Open)
         117         (High)
         116 56 DIV  (Low)
         000         (Settle; make equal to Last when 000)
         117         (Last)
         0 15 DIV    (Change)

      DIV is a macro for US to perform the postfix operation 64 / +, 
      to make a 64ths fraction and add it to the preceding term.  For 
      example, the first row above (Open) would give: 116 56 64 / + 
      equals 116.875.

      For TN, the site uses a divisor of 128, not 64, and macro DIV1 
      applies.

      For US, this is what a typical output file looks like.  Note that
      32nds are output; eventually, US output should be like TN--see 
      further below:
         Tue Jun  2 16:10:40 PDT 2009 SESS 1243980000
         USU09 11515 11517 11514 11517 c11517 6  ----- ----- 15:53:00

      For TN, this is what a typical output file looks like.  Note that
      pseudo 64ths are output, like 115215, which is 115 and 21.5 32nds
      or 43 64ths:
         Tue Jun  2 16:16:02 PDT 2009 SESS 1243980000
         TNU09 115220 115240 115215 115235 c115235 0045 --- --- 15:49:00

      The guys trading bonds probably never want to get away from 32nds
      (I don't blame them), and the recently mandated 64th works within
      32nds by simply defining a 64th to be half of a 32nd.
}
    \ Look for negative change and note it, then remove negative sign:
      T 6 quote "-" grepr (hR f) any?
      IF (hR) drop yes T "-" " " strp "T" book 
      ELSE no 
      THEN "NEG_CHG" book

    \ Run the phrases in VOL T and make six-row matrix A: 
      T local (hA) 6 listn FIX "A" book 

    \ Format the numbers in A:
      A rows 1st 64ths
      IF DO A I pry 32 * 32 /mod (nQuot nRem) intstr swap
            2 * 0.5 + integer 2 / 10 *
            "%03.0f" format +
         LOOP
      ELSE
         DO A I pry 32 * 32 /mod (nQuot nRem) intstr swap
            0.5 + integer "%02.0f" format +
         LOOP 
      THEN
      A rows pilen dup chars 2 + blpad "T" book \ pad spaces for "c"

      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      NEG_CHG IF "-" T 6 quote strchop + T 6 said THEN

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file?
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile
      ELSE drop
      THEN

      SYM CON +
      T
      "----- -----"
      TIME (qTIME)
      4 pilen vol2str neat (qS)

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " BOND: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end
      
   inline: cache_process ( --- ) \ process market data from cache
{     Process tradingcharts.com Netscape cache data, and write files
      in /tmp that match files from the regular collector, so they 
      will be picked up when hist_add() runs to append latest data 
      to each market's history file.

      This word was written in stages, step by step, using HALT at 
      each stage to set things up for interactively writing the next 
      phrase.  See HALTING note at the top of this file.
}
      [ list: \ Market symbols (this program's symbols shown on right):
           ZN \ TN 10-year Treasury Notes
           ZB \ US 30-year Treasury Bonds
           CL \ CL Crude Oil
           HG \ HG High Grade Copper
           GC \ GC Gold Comex
           E6 \ EU Euros
           S6 \ SF Swiss Francs
           J6 \ JY Japanese Yen
           YM \ DJ Dow Jones Industrial Average
           ES \ SP Standard and Poors Stock Index
           NQ \ NQ Nasdaq Stock Index
        end words noq_alike "SYM_TABLE" book
{
        list: \ Market symbols (this program's symbols shown on right):
           YM \ DJ Dow Jones Industrial Average
        end words noq_alike "SYM_TABLE" book
} 
        SYM_TABLE rows ones "SYM_DO" book

        -1 "BIN" book \ file handle

         {"
            BAD / 10
            000
            000
            000
            000
            0 00:00
            000
            000
         "} chop "8BAD" book
      ]
      BIN filetrue IF BIN fclose THEN

      FILE_IN any?
      IF (qFile) old binary "BIN" file \ data file handle called BIN
      ELSE return 
      THEN 

      BIN fsize "DMAX" book
      BIN INF fget asciify "T" book \ HTML data to parse into T
      BIN fclose

      T "?market=" smap (hD1 f) any? \ offsets to each starting string
      IF (hD1) 1+ "D1" book \ add 1 to make one-based offsets

       \ Each line ends with the string Remove:
         T ">Remove<" smap any? (hD2 f) \ offsets to each ending string
         IF (hD2) \ points to the > in >Remove<

          \ Add 7 to step over Remove< and add 1 to make one-based:
            (hD2) 8 + 
            D1 pile DMAX pile yes sort (hD1D2) push \ pile and sort

          \ Find D1(i) in the sorted list and the ending offset for
          \ its string is the very next number:
            D1 rows 1st 
            DO peek dup D1 I pry bsearch drop 1+ pry LOOP pull drop 
            D1 rows listn (hD2) 
            (hD2) D1 - 1+ "D2" book \ D2 is length: number of chars

         ELSE " cache_process: error mapping ending offsets " date +
            . nl BEEP mrc_close HALT
         THEN
      ELSE " cache_process: error mapping starting offsets " date + 
         . nl BEEP mrc_close HALT
      THEN

    \ Legitimate HTML strings for the browser display are 500 to 750 
    \ bytes long.  Eliminate strings where D2 is greater than 1000 
    \ chars, because they probably include garbage cookie strings:
      D2 dup 1000 > dup push rake drop "D2" book
      D1 pull rake drop "D1" book

    \ Candidate strings in T are at offsets D1 with length D2.  Fetch
    \ them and make a new T:
      D1 rows 1st 
      DO T D1 I pry D2 I pry items catch LOOP 
      D1 rows pilen noq_alike "T" book


    \ Loop over T for each symbol and extract its data:
      SYM_TABLE rows 1st
      DO SYM_TABLE I quote strchop "SYM" book

       \ Valid lines in T are expected to begin with strings like
       \    ?market=HG">HG
       \ for symbol HG.

         SYM_DO I pry 0<>
         IF T '?market=XX">XX' "XX" SYM strp grepr (hR) any?
         ELSE 0
         THEN
         (f) 

         IF T swap (hT hR) reach (hU)

          \ Valid strings, of various lengths, end with >Remove<:
            (hU) dup backward left justify 1st 8 items catch (hU1)
            (hU hU1) "<evomeR>" grepr (hR) any?
            IF (hU hR) reach (hU) yes
            ELSE (hU) drop no
            THEN
            (no or hU yes)

         ELSE no
         THEN
         (no or hU yes)

         IF (hU) dup push rows 1st
            DO peek (hU) I quote
 
               (qS) ">" "> " strp "<" " <" strp (qS) "S" book

             \ Fetch market name and contract:
               S 2nd word 
               IF (qSymCon) SYM "" strp (qCon) 
                  dup chars 3 < \ if Con is like M9, make it M09
                  IF Mo_fix vol2str strchop THEN "CON" book
               ELSE " cache_process: error fetching market name " 
                  SYM spaced + date + . nl BEEP mrc_close HALT
               THEN

             \ Make a map to strings that begin with align="center":
               S 'align="center"' smap S chars pile 
               dup delta -1 lag park 
               1st over rows 1- items reach "M" book

               M rows 0>
               IF M rows 1st 
                  DO S M I 1 fetch M I 2 fetch items catch LOOP 
                  M rows pilen chop (hT)

                  (hT) 'align="center">' "" strp
                  (hT) lowercase

                \ Expect more like these when grains are handled.
                \ August 30, 2009: the site has changed US to 32 and
                \ TN to 64:
                \ (hT) "</sup> / <sub> 64 </sub>" " DIV" strp   \ US
                \ (hT) "</sup> / <sub> 128 </sub>" " DIV1" strp \ TN
                  (hT) "</sup> / <sub> 32 </sub>" " DIV" strp  \ US
                  (hT) "</sup> / <sub> 64 </sub>" " DIV1" strp \ TN

                  (hT) "<center> - </center" " 000 " strp \ dash to zero
                  (hT) noblanklines 
                  (hT) textput
               ELSE ""
               THEN
            LOOP pull rows pilen noblanklines "U" book
{
            Each row of U is for a different time, and each row con-
            tains newline characters allowing it to be displayed like
            the following for SP:
               cme / 10 </td>  </td>  <td
               941.00 </td>  <td
               957.50 </td>  <td
               933.25 </td>   <td
               <b> 940.50 </b>  </td>  <td
               jun 05, 16:54,  </td>  <td
               <b> 940.50 </b>  </td>   <td
               <font color="#006600"> <b>  000 </b> </font> </td> <td

            The 000 in the last line is a case handled above where a 
            dash in the html has been replaced by number 000.

            The next job is to test the date and time of each row of 
            U and pick the one that is most recent.
}
            U rows 1 null "Ubad" book
            list: U rows 1st 

\ Tue Mar 18 19:38:30 PDT 2014.  Debug.  The error is in textget().  It 
\ returns 10 instead of 9 rows, and that makes bad all of Ubad. 

             \ Sat Mar 29 14:49:17 PDT 2014.  To get time, drill into
             \ the 6th row of U, which should yield something like 
             \ "mar 27, 19:24," after removing html strings; that will
             \ give a VOL of 3 rows to send to timequote():
               DO U I quote textget (hT) dup rows 9 =
                  IF (hT) 6 quote (qS) html2text (qS) \ mar 27, 19:24, 
                     (qS) words (hT1) dup rows 3 = 
                     IF (hT1) timequote (s)
                     ELSE (hT1) drop true Ubad I poke \ bad line
                     THEN
                  ELSE (hT) drop true Ubad I poke \ bad line
                  THEN
               LOOP
            end (hSec) bend (hSec') 

{ ===
\ Tue Mar 18 08:14:28 PDT 2014.  Debug:
dup "Sec" book
U "U1sav" book
=== }
            U Ubad rake drop (hSec' hU) swap
          \ Picking the row with the latest time (max1):
            (hU hSec') max1 2nd pry (U nRow) quote (qS) textget (hT)

\ Tue Mar 18 19:38:30 PDT 2014.  This U is purged because rake Ubad
\ was all -1.
            (hT) "U" book
{ ===
\ Tue Mar 18 08:14:28 PDT 2014.  Debug:
U "U2sav" book
=== }
          \ VOL U has these 8 lines:
          \    Delay, Open, High, Low, Last, Datetime, Settle, Change

          \ Remove junk from each line:
            depth push
            U rows 1st
            DO U I reach (qS)
{            
               Thu Mar 27 18:12:37 PDT 2014.  Data is being taken from
               a cache, and it contains old and possibly corrupted 
               bytes.  This could explain ASCII characters like .
               A fix to handle corrupted strings in timequote() led to
               this conclusion.
 
               Thu Dec 17 16:38:54 PST 2009.  A string with  (charac-
               ter 223) was obtained, which this loop did not remove, 
               causing failure below because the final matrix had more
               than 8 rows.

               This loop shows the ASCII characters above 127 (see man
               emit): 255 128 DO I .i sp I emit LOOP

               The following removes nulls and characters above 127:
}              (qS) uimport1 dup 0= over 127 > or rake drop export1

               (qS) words (hT) \ STR into VOL, one word per line

               (hT) "<" "" qreplace ">" "" qreplace
               (hT) "href=" "" qreplace
               (hT) "/abcdefghijklmnopqrstuvwxyz" chblank
               (hT) '"' " " strp
               (hT) "'" " " strp

               (hT) noblanklines 
               vol2str (qS) any? drop
            LOOP 
            depth pull - pilen (hT)

            (hT) dup rows 8 <>
            IF " cache_process: final matrix does not have 8 rows" . nl
{ ===

\ Tue Mar 18 08:14:28 PDT 2014.  Debug:
[ "/home/dale/tch_20140318_debug.txt_"
  ftemp (qLog) "__DEBUG_LOG" book

  "/home/dale/tch_20140318_debug.bin_"
  ftemp (qLog) "__FBIN" book
]

SYSOUT "__SYSOUTsav" book
__DEBUG_LOG (qLOG) set_sysout
__FBIN old binary "__BIN" file

date . nl
"U1 xray:" . nl
U1sav INF xray . nl
U1sav __BIN put

"U2 xray:" . nl
U2sav INF xray . nl
U2sav __BIN put

" Sec'  props:" . nl Sec props nl
" T  props:" . nl (hT) dup props nl

nl nl

__SYSOUTsav set_sysout
__BIN fclose

=== }
               (hT) . nl \ BEEP mrc_close HALT
               8BAD \ make processed data that will be ignored
            THEN (hT)

          \ Get the time from row 6 and subtract the delay in row 1:
            (hT) dup 6 ndx reach 2nd word (qTIME f)
            IF (hT qTIME) ":00" + >SEC (nTime)
               over (hT) 1st quote numerate @ 60 * (nDEL) \ sec delay

               (nTime DEL) - time_breakdown \ all times are Chicago
               CH>LA (qTIME) "TIME" book    \ LA time goes in the file
            ELSE (hT) drop
               " cache_process: error fetching time for " SYM spaced +
               date + . nl BEEP mrc_close HALT
            THEN (hT)

          \ Do not use rows 1 and 6 from U, and reverse the order of
          \ Last and Settle, rows 5 and 7 to match the convention for
          \ data collectors (see note at top of this file):
          \    Open, High, Low, Settle, Last (or Close)
            (hT) list: 2 3 4 7 5 8 ; reach (hT)

            (hT) TIME CON SYM PROCESS

         ELSE " cache_process: no data for " SYM spaced + date + . nl 
         THEN
      LOOP

      mrc_close \ close resources
   end

   inline: CH>LA (qHH:MM:SS --- qHH1:MM:SS)
{     Example:
         [tops@plunger] ready > "00:28:00" "13:38:00" pile CH>LA .
         22:28:00
         11:38:00
}     this type push
      >SEC (2 3600 *) 7200 - dup 0< 86400 * - >OCLOCK
      pull STR = IF 1st quote strchop THEN
   end

   inline: clickRefresh1 ( --- ) \ click mouse button and process cache
      [ 10 "SEC" book, 0 "TRIES" book, 2 "MAX_TRIES" book

      \ 300 "CLICK_SEC" book  \ every 5 minutes
        180 "CLICK_SEC" book  \ every 3 minutes 7-12-2009
        60 "CLICK_RETRY" book \ every minute 11-08-2013

        no "BUSY" book \ Thu May  9 16:09:38 PDT 2013

        "plunger" "ServerHost" book

        "" "lastIP" book

      {"
         tradingcharts.com has address 209.68.63.242
         tradingcharts.com has address 209.68.63.242
         tradingcharts.com has address 209.68.63.242

         google.com has address 74.125.226.14
         google.com has address 74.125.226.9
         google.com has address 74.125.226.8
         google.com has address 74.125.226.6
         google.com has address 74.125.226.3
         google.com has address 74.125.226.5
         google.com has address 74.125.226.2
         google.com has address 74.125.226.1
         google.com has address 74.125.226.7
         google.com has address 74.125.226.4
         google.com has address 74.125.226.0

         ipmonkey.com has address 209.240.132.16
         ipmonkey.com has address 209.240.132.16
         ipmonkey.com has address 209.240.132.16
         ipmonkey.com has address 209.240.132.16

         fortycoupe.com has address 205.134.240.76
         rilefile.com has address 66.249.8.119
         topsdog.com has address 205.134.240.77
      "} 4th word drop noblanklines "IPs" book

    \ Mon May  5 17:33:37 PDT 2014.  Choose an IP address to ping:
      {" ( --- qIP)
         BEGIN IPs dup rows ndx urn * integer xbase + pry strchop
            dup lastIP = (qIP f)
            IF (qIP) drop false ELSE (qIP) true THEN (f)
         UNTIL (qIP) dup "lastIP" book
      "} "tryIP" macro
      ]
      BUSY 
      IF " clickRefresh1: busy" . nl return
      ELSE yes "BUSY" book
      THEN

    \ PING run below takes 10 to 15 seconds.  Set the next alarm now
    \ to avoid any delay in the 3 minute period:
      CLICK_SEC "clickRefresh1" ALARM

    \ Thu May  9 04:38:25 PDT 2013.  Ping Internet sites to make sure
    \ we're connected (each PING takes 10 to 15 seconds):
      tryIP PING dup not
      IF drop tryIP PING THEN (f)

      (f) 
      IF logLAN1 (f)
         IF clickRefresh "clickRefresh" "OK" yank (f)
            IF SEC "cache_process" ALARM \ begin processing in SEC
               beep
               0 "TRIES" book \ Wed Jul  3 13:34:31 PDT 2013
            ELSE 
             \ Run BEEP on an ALARM because it runs idle and this word
             \ is running in the multitasker and will produce a tasker
             \ busy message if run here:
             \ Thu May  9 16:13:32 PDT 2013.  Disable BEEP; it is barely
             \ audible:
             \ SEC 5 / "BEEP" ALARM

             \ Thu May  9 16:13:32 PDT 2013.  Run an alarm on server:
               " clickRefresh1 on riggo: cannot click refresh button" 
               ServerHost R-ATTENTION

               " clickRefresh1: cannot click refresh button;" 
               " message sent to " ServerHost + + . nl 
            THEN
         ELSE 1 TRIES incr TRIES MAX_TRIES <=
            IF " clickRefresh1: failed LAN connection;"
               " is topse running?; trying again" +
               . nl SEC "clickRefresh1" ALARM \ set an ALARM
               no "BUSY" book
               return
            ELSE 
             \ Thu May  9 16:13:32 PDT 2013.  Run an alarm on server:
               " clickRefresh1 on riggo: LAN connection failed;" 
               " is topse running?" +
               ServerHost R-ATTENTION

               " clickRefresh1: failed LAN connection; giving up" . nl
               0 "TRIES" book
            THEN
         THEN
      ELSE 
       \ This may be a momentary disconection (seen with Verizon DSL).

       \ If there really is no Internet connection, other machines on
       \ the LAN have bigger problems than the one here.

       \ If we click Netscape's refresh button a pop up window will
       \ appear ("connection refused") that requires manual inter-
       \ vention to clear.  It's better to wait for the next time. 

         " clickRefresh1: no Internet connection; retry in " 
         CLICK_RETRY intstr + " seconds" + . nl 

       \ Fri Nov  8 10:47:10 PST 2013.  Don't wait the full time; click
       \ a little sooner:
         CLICK_RETRY "clickRefresh1" ALARM
      THEN
      no "BUSY" book
   end
      
   inline: DECIMAL (hT qTIME qCON nFAC qSYM --- ) \ decimal prices
\     Apply factor, FAC, to decimal data and write collection file.

      "SYM" book "FAC" book "CON" book "TIME" book "T" book

      SYM MOdo CON <>
      IF " DECIMAL: wrong contract for " SYM + . nl return THEN
{
      These are six typical rows of incoming T for decimal processing
      of CL, where FAC is 100:
         68.25  (Open)
         68.72  (High)
         67.98  (Low)
         000    (Settle; make equal to Last when 000)
         68.63  (Last)
         0.08   (Change)

      For CL, this is what a typical output file looks like:
         Tue Jun  2 22:50:46 PDT 2009 SESS 1243980000
         CLN09 6825 6872 6798 6867 c6867 12  ----- ----- 22:34:00
}
      T numerate FIX FAC * 0.5 + integer

      "%0.0f" format dup chars 2 + blpad "T" book \ pad for "c"
      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file? 
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile 
      ELSE drop
      THEN 

      SYM CON +
      T
      "----- -----"
      TIME (qTIME)
      4 pilen vol2str neat (qS) 

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " DECIMAL: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: FILE_IN ( --- qFile) \ name of input file
      [ "" dup "PATH" book "FILE" book

        host "plunger" = 
        IF "/home/dale/.mozilla/dale-1/k3m2pr5w.slt/Cache/" "PATH" book
           "_CACHE_003_" "FILE" book
        THEN

        host "diego" =  
        IF "/home/dale/.mozilla/default/87cf9sig.slt/Cache/" "PATH" book
           "_CACHE_003_" "FILE" book
        THEN

        host "riggo" =  
        IF "/home/dale/.mozilla/dale/g0xww60c.slt/Cache/" "PATH" book
           "_CACHE_003_" "FILE" book
        THEN
{
      \ Sat Mar 29 13:37:53 PDT 2014.  Testing to fix timequote():
        host "riggo" =  
        IF \ testing on riggo; file _CACHE_003_ moved back one subdir:
           "/home/dale/.mozilla/dale/g0xww60c.slt/" "PATH" book
           "_CACHE_003_.sav" "FILE" book
        THEN
}
        PATH FILE + file? not
        IF " FILE_IN: file " FILE + " not found, halting" + . nl
           HALT
        THEN

        0 "prevtime" book
      ]
      PATH FILE + file? not 
      IF " FILE_IN: file " FILE + " not found " + date + . nl
         "" (qFile) \ return empty string
      ELSE PATH FILE + filetime dup prevtime >
         IF (ntime) "prevtime" book PATH FILE + (qFile)
         ELSE drop "" (qFile) \ file old, return empty string
         THEN
      THEN
   end

   inline: FILE_OUT (qSYM --- qFile) \ name of output file
\     Make PATH_OUT equal to "/tmp1/" during testing.
      [ "/tmp/" "PATH_OUT" book ]
        PATH_OUT "MKT_TC1.eDAT" + "MKT" rot uppercase strp 
   end

   inline: FILE_SEND (qFile --- ) \ send file to remote collector
{     Sun Dec  4 16:14:09 PST 2011

      There is no need to send File to the remote collector because it 
      is running locally.  Just send the string to the remote collector
      that makes it add the data of File to the history file.
}
      (qFile) dup -filename "/tmp1/" =
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN

      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book
      "mrc_open" "S1" yank "S1" book

      S1 -1 >
      IF
{        Make a string to run on REMOTE that will add a job to
         the collector queue that will update the history file
         with the data just sent.  A typical string to do this
         is: "eGC-COLLECT" "hist" localref ptr queue_add1.

         Word queue_add1 will add a job to the queue if there
         isn't a matching one already.  A matching job would
         be one from the collector, and when it runs the file
         just written will be processed along with the ones made
         by the collector, so there is no need to add another
         one to the queue.

         The collector job is presently on socket S1 connected
         to REMOTE.
}
         "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
         "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

         (hT) S1 remoterun1 (f)

         IF " FILE_SEND: " FILE SYM_OUT +
            " update queued on " + 
          \ Sun Jun  1 17:02:03 PDT 2014.  Add socket number S1:
            REMOTE notrailing ":" + S1 intstr + +
            spaced date + . nl

         ELSE " FILE_SEND: " FILE SYM_OUT +
            " update queue error on " + REMOTE + date + . nl
            BEEP
         THEN
      ELSE " FILE_SEND: S1 not connected to " REMOTE + date +
         . nl BEEP
      THEN
   end

{ ----- obsolete

   inline: FILE_SEND (qFile --- ) \ send file to remote
      (qFile) dup -filename "/tmp1/" = 
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN
      
      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book 
      "mrc_open" "S1" yank "S1" book 

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            FILE FILE S fremoteput (f) 

            (f) dup false =
            IF " FILE_SEND: error sending " FILE + 
               "; see ERRLOG below:" + . nl
               ERRLOG asciiload (hT) 3 indent . nl
            THEN (f)


            ERRLOG deleteif
            SYSOUTsav set_sysout \ back to regular output
         ELSE true
         THEN

         IF " FILE_SEND: OK " FILE + " to " + REMOTE + date + . nl
            S1 -1 >
            IF
{              Make a string to run on REMOTE that will add a job to 
               the collector queue that will update the history file 
               with the data just sent.  A typical string to do this 
               is: "eGC-COLLECT" "hist" localref ptr queue_add1.

               Word queue_add1 will add a job to the queue if there
               isn't a matching one already.  A matching job would
               be one from the collector, and when it runs the file
               just written will be processed along with the ones made 
               by the collector, so there is no need to add another
               one to the queue.

               The collector job is presently on socket S1 connected
               to REMOTE.
}
               "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
               "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

               (hT) S1 remoterun1 (f)

               IF " FILE_SEND: " FILE SYM_OUT + 
                  " update queued on " + REMOTE + date + . nl

               ELSE " FILE_SEND: " FILE SYM_OUT + 
                  " update queue error on " + REMOTE + date + . nl
                  BEEP
               THEN
            THEN

         ELSE " FILE_SEND: error sending " FILE + " to " + 
            REMOTE + date + . nl BEEP
         THEN
      ELSE " FILE_SEND: not connected to " REMOTE + date + 
         . nl BEEP
      THEN 
   end

----- }

   inline: FIX (hA --- hA1) \ fix bad values in A
{     Typical values of six-row A are:
         68.25  (Open)
         68.72  (High)
         67.98  (Low)
         000    (Settle; make equal to Last when 000)
         68.63  (Last)
         0.08   (Change)
}
    \ Fix up bad values:
      (hA) push

      peek 4th pry 0= \ check Settle, row 4
      IF peek 5 ndx pry peek 4th poke THEN \ if Settle is 0, set to Last

      peek 2nd pry 0= \ check High, row 2
      IF peek 5 ndx pry peek 2nd poke THEN \ if High is 0, set to Last

      peek 3rd pry 0= \ check Low, row 3
      IF peek 5 ndx pry peek 3rd poke THEN \ if Low is 0, set to Last

      pull
   end

   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
      "mrc_open" "REMOTE" yank "mrc_open" "PORT" yank
      (qIP nPORT) logLAN (f)
      IF mrc_open (f)
      ELSE false
      THEN (f)
   end

   inline: mrc_close ( --- ) \ close market data resources
      "mrc_open" "S" yank sclose
      -1 "mrc_open" "S" bank

      "mrc_open" "S1" yank sclose
      -1 "mrc_open" "S1" bank
   end

   inline: mrc_open ( --- f) \ open market data resources on plunger
    \ Sun Dec  4 14:03:08 PST 2011

    \ Communicate with locally running http server.

      [ IPloop spaced "REMOTE" book
        p_http "PORT" book \ http port

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector

         ftempsys (qLOG) "ERRLOG" book
      ]

    \ Tue Mar 18 08:14:28 PDT 2014.  Don't run "sockets sclose."  That
    \ closes all socket connections.  For debug, this job can have a
    \ listening SERVER and a client can connect to make repairs or add
    \ debug output, but it gets closed every 3 minutes when mrc_open()
    \ runs phrase: sockets sclose.  

    \ Connecting to SERVER for repair is through a remote socket, while
    \ the ones connected through mrc_open() are local sockets to remote
    \ servers.  So just close the local sockets:
      localsockets sclose \ close local connections to servers

      SYSOUT "SYSOUTsav" book
      ERRLOG (qLOG) set_sysout
      REMOTE PORT CLIENT "S" book

      SYSOUTsav set_sysout

      S -1 >
      IF SYSOUTsav set_sysout

       \ Connect to the http server on REMOTE and get the port number
       \ for the collector on REMOTE:
         -1 "S1" book
         "TOPSE_SERVER" S msgPeekSocket (qPort) any?
         IF number (no || nPort yes)
            IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
               IF true (f)
               ELSE " mrc_open: cannot connect to collector on "
                  REMOTE + date + . nl BEEP false (f)
               THEN
            ELSE " mrc_open: bad port number from "
               REMOTE + date + . nl BEEP false (f)
            THEN
         ELSE " mrc_open: error fetching collector port from "
            REMOTE + date + . nl BEEP false (f)
         THEN

      ELSE 
         " mrc_open: cannot connect to " REMOTE + date + . nl
         ERRLOG asciiload 2 indent . nl
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

{ --- obsolete

   inline: mrc_open ( --- f) \ open market data resources on plunger
      [ host "plunger" =
        IF IPloop ELSE plunger THEN spaced "REMOTE" book 
        "plunger" "p0" yank 80 + "PORT" book \ http on plunger

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector
      ]
      sockets sclose \ close any connections (there should be none)

      REMOTE PORT CLIENT "S" book

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            "/mdat/latest.dat" mpath "latest.dat" + S fremoteget (f1)
            "/mdat/con.dat"    mpath "con.dat" + S fremoteget (f2)
            SYSOUTsav set_sysout \ back to regular output
         ELSE true true (f1 f2)
         THEN

         (f1 f2) and

         IF " mrc_open: OK files from " REMOTE + date + . nl

          \ Connect to the collector on REMOTE:
            -1 "S1" book
            "TOPSE_SERVER" S msgPeekSocket (qPort) any?
            IF number (no || nPort yes)
               IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
                  IF true (f)
                  ELSE " mrc_open: cannot connect to collector on " 
                     REMOTE + date + . nl BEEP false (f)
                  THEN
               ELSE " mrc_open: bad port number from " 
                  REMOTE + date + . nl BEEP false (f)
               THEN
            ELSE " mrc_open: error fetching collector port from " 
               REMOTE + date + . nl BEEP false (f)
            THEN

         ELSE " mrc_open: error fetching files from " REMOTE + 
            date + . nl BEEP false (f) 
         THEN
      ELSE " mrc_open: cannot connect to " REMOTE + date + . nl
         ERRLOG asciiload 2 indent . nl 
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

--- }

   inline: PROCESS (hA qTIME qCON qSYM --- )
\     Incoming SYM is the tch symbol; file created will use the 
\     program's symbol.

      "SYM" book 

      SYM "E6" = IF (hA qTIME qCON) 10000 "EU" DECIMAL return THEN
      SYM "S6" = IF (hA qTIME qCON) 10000 "SF" DECIMAL return THEN
      SYM "J6" = IF (hA qTIME qCON) 10000 "JY" DECIMAL return THEN

      SYM "YM" = IF (hA qTIME qCON) 1  "DJ" DECIMAL return THEN
      SYM "ES" = IF (hA qTIME qCON) 10 "SP" DECIMAL return THEN
      SYM "NQ" = IF (hA qTIME qCON) 10 "NQ" DECIMAL return THEN

      SYM "ZB" = IF (hA qTIME qCON) "US" BOND return THEN
      SYM "ZN" = IF (hA qTIME qCON) "TN" BOND return THEN

      SYM "CL" = IF (hA qTIME qCON) 100   "CL" DECIMAL return THEN
      SYM "HG" = IF (hA qTIME qCON) 10000 "HG" DECIMAL return THEN
      SYM "GC" = IF (hA qTIME qCON) 10    "GC" DECIMAL return THEN
   end

   inline: setmkt (f qMkt --- ) \ set flag to process Mkt or not
    \ Incoming f is 1 to process Mkt, 0 to not process Mkt.

    \ Symbol Mkt is the tradingcharts symbol, like one of these:
    \    ZN ZB CL HG GC E6 S6 J6 YM ES NQ

    \ Example:
    \    Make GC inactive: 0 "gc" setmkt

      over 0=
      IF \ Remove all old files to eliminate the bad one:
         " setmkt: removing old *TC1.eDAT files from /tmp. " . nl
         "/bin/rm /tmp/*TC1.eDAT" shell
      THEN

      strchop uppercase "cache_process" "SYM_TABLE" yank (hT)
      swap (hT qMkt) grepr any?
      IF "cache_process" "SYM_DO" yank "V" book
         V swap @ (f V r) poke
         V "cache_process" "SYM_DO" bank
      ELSE " setmkt: Mkt not found" . nl 
      THEN
   end

   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
      (qFile) "FILE_OUT" "PATH_OUT" yank "" strp (qSYM)
      (qSYM) "_TC1.eDAT" "" strp (qSYM)
   end

   inline: timequote (hT --- s) \ convert quote date to machine time
{     Sat Mar 29 14:53:08 PDT 2014.  Revised.
      Incoming volume T has the form: 
         Jun 
         05  
         16:54 
      where the time is in Chicago.
}
      [ list: jan feb mar apr may jun jul aug sep oct nov dec ; 
        words "MON" book 

      \ Fetch the year from input file date (could also use tsession):
        "FILE_IN" "PATH" yank "FILE_IN" "FILE" yank + filetime
        ctime 6 word drop numerate @ 1900 - 10000 * "YYY" book
      ]

{ === 

{
Thu Mar 27 17:47:05 PDT 2014.  This debug found that one of the pair
of lines for each market had the date corrupted.  

It is a cache we're reading, and no attempt has been made to learn to
tell the new records from the old ones.  A fix is being planned.  See 
notes in the saved file of debug output:
   /home/dale/tch_2014Mar27_debug.txt_mhqWpY.
}

\ Thu Mar 27 08:19:19 PDT 2014.  Debug:
[ "/home/dale/tch_" bdate + "_debug.txt_" +
  (qFil) ftemp (qLog) "__DEBUG_LOG" book
]
SYSOUT "__SYSOUTsav" book
__DEBUG_LOG (qLOG) set_sysout
ercnt "E" book

=== }

{     Requirements for good times:

         The first string must match a month.
         The second string contains only numerals, and must be a day
            between 1 and 31.
         The third string contains only numerals and a required colon.

      T(1) must match a MON string.
}
      (hT) "T" book
      YYY
      MON T 1st quote 1st 3 items catch lowercase grepe any?
      IF @ 100 * +
         T 2nd quote numerate @ + (qYYYMMDD)
         (qYYYMMDD) 0 ltime (ns1)                 \ 00:00 in Greenwich
         T 3rd quote strchop ":00" + >SEC (ns2) + \ plus sec in Chicago
         (ns1+ns2) CHdiff - (s)                   \ less Greenwich diff
      ELSE (YYY) drop 
         " timequote: error in time string month " T vol2str + 
         . nl BEEP 0 (s)
      THEN
      (s) dup time > 
      IF drop 0 THEN \ time cannot be in the future
      (s) 

{ ===

\ Thu Mar 27 08:19:19 PDT 2014.  Debug:
ercnt E <>
IF " timequote: error, " date + . nl
   " timequote: T:" . nl T . nl
   T INF xray . nl
   nl nl
THEN
__SYSOUTsav set_sysout

=== }

   end

   pull catmsg

\-----------------------------------------------------------------------

\  Testing and debugging.

\  For testing and debugging, uncomment the following line:
\  "/tmp1/" "FILE_OUT" "PATH_OUT" bank " WORKING IN TEST MODE" . nl halt

\  Then set SYM_TABLE in cache_process to the market to test, and run
\     "tch1.v" source cache_process halt
\  with HALT placed at various locations to find the bug.

\-----------------------------------------------------------------------

\  Collecting data.
{
   Log into

      http://members.tradingcharts.com/

   with user name and password and choose "myquotes" to display the
   browser page with the table of selected markets.  Then source this 
   file and follow the instructions to set up the collection process:

      ready > "tch1.v" source
}
\  Remove old files:
   " Removing old *TC1.eDAT files from /tmp. " . nl
   "/bin/rm /tmp/*TC1.eDAT" shell

\  Fetch window number:
   winreg (qWIN) "clickRefresh" "WIN" bank

   nl
   "To start: with focus in this window, press the Enter key and then "
   "move the mouse arrow to the Browser refresh button within " +
   "5 seconds." +   
   COLS 2 - 64 min ".out" >stk 1 indent . nl
   "" query drop
   5 idle nl

   CATMSG push no catmsg

   inline: CLICK_START ( --- ) \ start multitasker clickRefresh
      [ 300 "SOONER" book ]

    \ Set an alarm to run CLICK_END:
      time soonest_end SOONER - (sec)
      " CLICK_START: collection ends in about "
      over 3600 / 0.5 + integer intstr + " hours" + . nl
      (sec) "CLICK_END" ALARM

    \ Start the multitasker job to double click the refresh button; 
    \ the mouse cursor must remain over the button to be clicked:
      clickRefresh1 \ run it now
   end

   inline: CLICK_END ( --- ) \ end multitasker clickRefresh
      [ 900 "LATER" book ]

      soonest_task 
      IF clickRefresh1 THEN \ run for the last time this session

    \ End the multitasker job:
      "clickRefresh1" -ALARM

    \ Set an alarm to run CLICK_START:
      time soonest_start LATER + (sec)
      " CLICK_END: " date + ", collection begins in " +
      over 60 / 0.5 + integer intstr + " minutes" + . nl
      (sec) "CLICK_START" ALARM
   end

   inline: START ( --- ) \ depending on time of day, set the start task

    \ Thu Mar 27 09:13:21 PDT 2014.  Start a server for repairs and
    \ debugging, and put its port on the messages file:
      "*" def_port nextport SERVER
      " START: server is listening on port" . serverport .i nl
      "TCH1_SERVER" msgDel serverport intstr "TCH1_SERVER" msgPut

    \ Thu Apr  4 14:59:03 PDT 2013.  The start-up server runs NIST_SYNC.
    \ Run NIST_DELTA every 4 hours and comment out NIST_SYNC:
      14400 "NIST_DELTA" "SEC" bank NIST_DELTA
{ 
      NIST_SYNC \ sync the program time with NIST

    \ Next time, and every time thereafter, run NIST_SYNC in the lull 
    \ between 14:45 and 15:00 (LA) time:
      "14:50:00" "todayat" >stk (n qT) chars 0>
      IF drop "38:50:00" todayat THEN "NIST_SYNC" ALARM
}
    \ Set the start task:
      soonest_task (f) IF CLICK_START ELSE CLICK_END THEN
   end

   pull catmsg

   START nl tasks 

   private halt

------------------------------------------------------------------------

   Appendix.

   Logging into the running program and doing repairs.

      An intermittent error appeared in the output of collector tch1.v
      as it clicked on the browser Refresh button and processed data.

      Work directly on its machine (riggo) cannot be done because the
      mouse cursor must remain on the Refresh button.  So a listening
      server was started in the program to allow connection to it re-
      motely, the mouse cursor was returned to the Refresh button, and
      the program was left running while the display was switched from
      riggo to machine plunger.
     
      The notes below document connecting to that listening server on
      riggo from plunger and installing phrases in the running program
      to write debug information to text and binary log files.

      After starting a listening server on the running collector
      (using: "*" def_port nextport SERVER, and noting that SERVER was
      listening on 10203), this shows connecting and redefining 
      word mrc_open() with "sockets sclose" commented out (that was
      necessary because every three minutes when the collector clicked
      the Refresh button, all sockets, including the one for repair,
      were closed):

         [tops@riggo] ready > IPloop 10203 CLIENT

          stack elements:
                0 number: 3
          [1] ok!
         [tops@riggo] ready > remoteprompt
         tops@socket3 > "tch1.v" "DOY" msource
          word mrc_open is redefined
         tops@socket3 > clients
          Server local is listening on port 10203
          Clients:
           socket 6, port  2171, conn S<C, 127.0.0.1 LOGIN dale riggo
         tops@socket3 > date .
         Tue Mar 18 08:21:27 PDT 2014
         tops@socket3 > 

      Phrases for debugging inside word cache_process() were developed
      on the side interactively and when they worked with no errors
      they were pasted into cache_process() in this file, then the file
      was sourced with word msource to redefine cache_process() as shown
      next.

      Below is redefining cache_process() with debug output.  Strings
      "DOY" and "halt" have been placed above and below, respectively,
      the set of lines for msource to read, i.e., DOY was placed above
      "inline: cache_process" and halt was placed below its last line
      "end").

      The following runs msource and echoes that cache_process() has
      been redefined:
         tops@socket3 > "tch1.v" "DOY" msource
          word cache_process is redefined

      This shows clients right after the browser Refresh button was
      pushed by the program; the program hooks to servers listening 
      on 10280 and 10202; we are still connected on port 2171:
         tops@socket3 > clients
          Server local is listening on port 10203
          Clients:
           socket 6, port  2171, conn S<C, 127.0.0.1 LOGIN dale riggo
           socket 8, port 10280, conn C>S, 127.0.0.1 dale riggo
           socket 7, port 10202, conn C>S, 127.0.0.1 dale riggo

      After the snapshot is taken and results sent off to the servers,
      sockets 7 and 6 are closed and just this connection remains:
         tops@socket3 > clients
          Server local is listening on port 10203
          Clients:
           socket 6, port  2171, conn S<C, 127.0.0.1 LOGIN dale riggo
         tops@socket3 > 

      The program appears to be running ok with the debug phrases in 
      place.  Exit this session and check on the debug log file during
      the week:
         tops@socket3 > 

         [tops@riggo] ready > bye
         603 keys
                   Good-bye
         Tue Mar 18 09:19:48 PDT 2014
         [dale@riggo] /home/dale/.mozilla/dale/g0xww60c.slt/Cache > 

      The debug log file is /home/dale/tch_20140318_debug.txt_27xZi7.

      Keep this ssh window to riggo open and put a tail on the log file
      and check on it once in a while:
         [dale@riggo] /home/dale > tail -f tch_20140318_debug.txt_27xZi7

      Tue Mar 18 13:53:03 PDT 2014.  Results from debug.txt_27xZi7 have
      led to revised debug and interactive updating of the running
      program.  Results are now being saved to these two files, one
      text and the other binary:
         [dale@riggo] /home/dale > ls -1 tch_20*
         tch_20140318_debug.bin_hLtkYw
         tch_20140318_debug.txt_HrrO2l
         [dale@riggo] /home/dale > 

      Back to waiting with a tail on tch_20140318_debug.txt_HrrO2l:
         [dale@riggo] /home/dale > tail -f tch_20140318_debug.txt_HrrO2l


      Problem solved.  

      From debug output it appeared there was an error in word textget,
      which recently was revised (surprise).

      Saved binary file tch_20140318_debug.txt_HrrO2l was read to obtain
      a saved array called U and running it through textget.

      Output below shows processing textget(U) on riggo and the on
      web machine fortycoupe that is running the earlier version of
      textget.

      Comparing the xrays of textget(U) from riggo and textget(U) from
      fortycoupe shown below shows the bad result on riggo and led
      to revisions of textget.

      Wed Mar 19 11:07:05 PDT 2014.  The collector on riggo has been
      restarted with corrected textget() and appears to be running
      correctly.

Below is xray output that shows the error.  

An incorrectly updated version of textget(), now running in the col-
lector on riggo, intermittently produces a 10-by-80 array and that
is causing the error message seen. 

A version of textget() without the mistake, run remotely on machine
fortycoupe.com, correctly produces a 9-by-80 array.

On riggo (running an updated version of textget() with an error):

The error is the 0Ah byte (a newline character) shown at line 92, 
column 6 of the xray.

[tops@riggo] ready > U 1st quote

 stack elements:
       0 string:  cme / 10 </td>  </td>  <td  1864.0...  340 characters
 [1] ok!
[tops@riggo] ready > U textget

 stack elements:
       0 volume: _textget  10 by 80
 [1] ok!
[tops@riggo] ready > INF xray .
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  20 63 6D 65 20 2F 20 31 30 20 3C 2F 74 64 3E 20   cme / 10 </td>
   2  20 3C 2F 74 64 3E 20 20 3C 74 64 0A 20 20 20 20   </td>  <td.
   4  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
   6  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
   8  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
...
  78  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  80  20 20 3C 61 20 68 72 65 66 3D 22 6A 61 76 61 73    <a href="javas
  82  63 72 69 70 74 3A 70 6F 70 75 70 28 27 2F 6D 79  cript:popup('/my
  84  71 75 6F 74 65 73 2F 6D 61 6E 61 67 65 2E 70 68  quotes/manage.ph
  86  70 3F 77 3D 72 26 73 3D 65 73 6D 34 2E 67 27 29  p?w=r&s=esm4.g')
  88  22 3E 20 72 65 6D 6F 76 65 20 3C 0A 20 20 20 20  "> remove <.
  90  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  92  20 20 20 20 20 20 0A 20 20 20 20 20 20 20 20 20        .
  94  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  96  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  98  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
 stack elements:
       0 volume: _textget  10 by 80
 [1] ok!
[tops@riggo] ready > 


On fortycoupe (running an old version of textget() without the error):

tops@socket3 > U 1st quote

 stack elements:
       0 string:  cme / 10 </td>  </td>  <td  1864.0...  340 characters
 [1] ok!
tops@socket3 > textget

 stack elements:
       0 volume: _textget  9 by 80
 [1] ok!
tops@socket3 > INF xray .
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  20 63 6D 65 20 2F 20 31 30 20 3C 2F 74 64 3E 20   cme / 10 </td>
   2  20 3C 2F 74 64 3E 20 20 3C 74 64 0A 20 20 20 20   </td>  <td.
   4  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
   6  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
   8  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  10  20 31 38 36 34 2E 30 30 20 3C 2F 74 64 3E 20 20   1864.00 </td>
  12  3C 74 64 0A 20 20 20 20 20 20 20 20 20 20 20 20  <td.
...

  64  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  66  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  68  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  70  20 20 3C 66 6F 6E 74 20 63 6F 6C 6F 72 3D 22 23    <font color="#
  72  30 30 36 36 30 30 22 3E 20 20 3C 62 3E 20 20 20  006600">  <b>
  74  30 30 30 20 20 3C 2F 62 3E 20 20 3C 2F 66 6F 6E  000  </b>  </fon
  76  74 3E 20 20 3C 2F 74 64 3E 20 20 3C 74 64 0A 20  t>  </td>  <td.
  78  20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20
  80  20 20 3C 61 20 68 72 65 66 3D 22 6A 61 76 61 73    <a href="javas
  82  63 72 69 70 74 3A 70 6F 70 75 70 28 27 2F 6D 79  cript:popup('/my
  84  71 75 6F 74 65 73 2F 6D 61 6E 61 67 65 2E 70 68  quotes/manage.ph
  86  70 3F 77 3D 72 26 73 3D 65 73 6D 34 2E 67 27 29  p?w=r&s=esm4.g')
  88  22 3E 20 72 65 6D 6F 76 65 20 3C 0A 20 20 20 20  "> remove <.
tops@socket3 > 

------------------------------------------------------------------------

System missed sending files at 22:15:04, but no errors in log.

 FILE_SEND: NQ update queued on 192.168.0.1 Mon Jun 29 22:10:24 PDT 2009

 logLAN: OK Mon Jun 29 22:15:04 PDT 2009
  <<<<<<<< No files sent here

 logLAN: OK Mon Jun 29 22:20:04 PDT 2009
 mrc_open: OK files from 192.168.0.1 Mon Jun 29 22:20:15 PDT 2009
 FILE_SEND: OK /tmp/TN_TC1.eDAT to 192.168.0.1 Mon Jun 29 22:20:16 PDT 2009


THESE MAY BE DUE TO NOT HAVING THE MOUSE ARROW ON THE REFRESH BUTTON:

For a period, no files were sent.  The watchdog on plunger finally
noticed and went off:

 logLAN: OK Fri Dec  4 08:53:50 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 08:53:51 PST 2009
 logLAN: OK Fri Dec  4 08:56:51 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 08:56:54 PST 2009
 logLAN: OK Fri Dec  4 08:59:53 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 08:59:56 PST 2009
 logLAN: OK Fri Dec  4 09:02:57 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:03:00 PST 2009
 logLAN: OK Fri Dec  4 09:05:59 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:06:02 PST 2009
 logLAN: OK Fri Dec  4 09:09:02 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:09:05 PST 2009
 logLAN: OK Fri Dec  4 09:12:04 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:12:07 PST 2009
 logLAN: OK Fri Dec  4 09:15:08 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:15:11 PST 2009
 logLAN: OK Fri Dec  4 09:18:10 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:18:13 PST 2009
 logLAN: OK Fri Dec  4 09:21:12 PST 2009
 mrc_open: OK files from 192.168.0.1 Fri Dec  4 09:21:15 PST 2009
 FILE_SEND: OK /tmp/TN_TC1.eDAT to 192.168.0.1 Fri Dec  4 09:21:25 PST 2009
 FILE_SEND: TN update queued on 192.168.0.1 Fri Dec  4 09:21:25 PST 2009
 FILE_SEND: OK /tmp/US_TC1.eDAT to 192.168.0.1 Fri Dec  4 09:21:26 PST 2009
Normal sending of files has resumed.
