{  File tch.v  August 2004

   Copyright (c) 2004   D. R. Williamson

   Words for fetching data from tradingcharts.com

   Status July 2010
      The site has changed its format and web data appears to not be
      accessible, putting this file out of business.

   Update January 2009 
      Correct the rounding in tc64ths_tmp to really round.

   Update January 2008
      Collect electronic markets data.

   Update October 2007
      The format of site pages has changed, requiring tcPROCESS() to
      be updated.

      The volume is claimed to be estimated on the current day, unlike
      other published volumes that are for the previous day.  The open
      interest is claimed to be for the previous day.

      Comparing tch.v volume and open interest with data from bch.v,
      most were found to be very close.  

      Probably the claimed current volume is for yesterday, like the
      open interest.  This is how the exchanges have always put out the
      data to publishers like the Wall Street Journal, which I have 
      verified over many years of use.

      When bch.v was first developed, its volume and open interest were
      checked and found to agree with the lagged values in the Wall 
      Street Journal.  
}
\-----------------------------------------------------------------------

   "tracklist" missing IF " tch.v: require tracklist " . nl halt THEN

\-----------------------------------------------------------------------

   inline: tc8ths (qS --- hT) \ process S
      [ {" (qS) \ 788 into 7880 (788 and zero eights); 788-6 into 7886
         strchop
         dup 1st character "-" = 
         IF -1 indent true \ remove minus sign
         ELSE false 
         THEN (f) push \ minus sign 
         dup "-" grepr rows 0> 
         IF "-" "" strp \ replace - with nothing
         ELSE "0" + \ append 0 eights
         THEN pull 
         IF "-" swap + \ replace minus sign
         THEN (qS)
        "} "tcGRAIN" macro
      ]
    \ Set tcPROCESS.SPECIAL = ptr(tc8ths.tcGRAIN) and then run
    \ word tcPROCESS.
      "tc8ths" "tcGRAIN" localref ptr "tcPROCESS" "SPECIAL" bank
      (qS) tcPROCESS
   end

   inline: tc32nds (qS --- hT) \ process S
      [ {" (qS) \ 111 into 11100 (111 and zero 32nds); 111-06 into 11106
         strchop
         dup 1st character "-" =
         IF -1 indent true \ remove minus sign
         ELSE false
         THEN (f) push \ minus sign
         dup "-" grepr rows 0>
         IF "-" "" strp \ replace - with nothing
         ELSE "00" + \ append 00 32nds
         THEN pull
         IF "-" swap + \ replace minus sign
         THEN (qS)
        "} "tcBOND" macro
      ]
    \ Set tcPROCESS.SPECIAL = ptr(tc32nds.tcBOND) and then run
    \ word tcPROCESS.
      "tc32nds" "tcBOND" localref ptr "tcPROCESS" "SPECIAL" bank
      (qS) tcPROCESS
   end

   inline: tc64ths (qS --- hT) \ process S
      [ {" (qS) 
       { Using word 32nds+ (file tex.v), 64ths are converted to 32nds 
         with a half added, so 61/64 becomes 30.5/32 (shown as 305), 
         and 16/64 becomes 8/32 (shown as 008).
       } strchop
         dup 1st character "-" =
         IF -1 indent true \ remove minus sign
         ELSE false
         THEN (f) push \ minus sign
         dup "-" grepr rows 0>
         IF "-" " " strp numerate (hA)
            (hA) dup 1st pry (nQuo) swap 2nd pry (nRem) 64 / + 
            (N) 32nds+ 1st quote
         ELSE "000" + \ append 000 32nds
         THEN pull
         IF "-" swap + \ replace minus sign
         THEN (qS)
        "} "tcBOND" macro
      ]
    \ Set tcPROCESS.SPECIAL = ptr(tc64ths.tcBOND) and then run
    \ word tcPROCESS.
      "tc64ths" "tcBOND" localref ptr "tcPROCESS" "SPECIAL" bank
      (qS) tcPROCESS
   end

   inline: tc64ths_tmp (qS --- hT) \ process S
      [ {" (qS)
       { Using word 32nds+ (file tex.v), 64ths are converted to 32nds
         with a half added, so 61/64 becomes 30.5/32 (shown as 305),
         and 16/64 becomes 8/32 (shown as 008).
       } strchop
         dup 1st character "-" =
         IF -1 indent true \ remove minus sign
         ELSE false
         THEN (f) push \ minus sign
         dup "-" grepr rows 0>
         IF "-" " " strp numerate (hA)
            (hA) dup 1st pry (nQuo) swap 2nd pry (nRem) 64 / +
            (N) 32nds+ 1st quote
         ELSE "000" + \ append 000 32nds
         THEN 

         number drop 
         10 / 0.5 + integer intstr spaced

         pull
         IF "-" swap + \ replace minus sign
         THEN (qS)
        "} "tcBOND" macro
      ]
    \ Set tcPROCESS.SPECIAL = ptr(tc64ths.tcBOND) and then run
    \ word tcPROCESS.
      "tc64ths_tmp" "tcBOND" localref ptr "tcPROCESS" "SPECIAL" bank
      (qS) tcPROCESS
   end

   inline: tcCOLLECT ( --- hT) \ data from tch
      tracklist "TRACK" book

      time push
      depth push
      "From tcCOLLECT, file tch.v"
      date neat

      "tcDATA" "PIT" yank
      IF "Pit trading" ELSE "Electronic trading" THEN
      "Showing: Open High Low Settle Close Chg Vol OpenInt"
      
      " "
      TRACK rows 1st
      DO
         TRACK I quote tcDATA any?
         IF this 8 ndx word drop
            numerate totals ontop int$ "V" book
            this 9 ndx word drop
            numerate totals ontop int$ "OI" book

            TRACK I quote spaced
            " VOL and OI totals: " cat V cat spaced OI cat neat

            swap

         ELSE TRACK I quote spaced date cat " no data" cat
         THEN
         " "
      LOOP
      depth pull less pilen

      "ET: " time pull less 60 slash "%0.1f" format cat
      " minutes" cat pile

      "_tcCOLLECT" naming
   end

   inline: tcDATA (qS --- hT) \ data for S
      [ true "PIT" book \ default

        "'w' tcSYM tc8ths" "w" macro
        "'c' tcSYM tc8ths" "c" macro
        "'s' tcSYM tc8ths" "s" macro
        "'sm' tcSYM  10 tcDECIMAL" "sm" macro
        "'bo' tcSYM 100 tcDECIMAL" "bo" macro

	"'lc' tcSYM 100 tcDECIMAL" "lc" macro
        "'lh' tcSYM 100 tcDECIMAL" "lh" macro
        "'pb' tcSYM 100 tcDECIMAL" "pb" macro

        "'cc' tcSYM   1 tcDECIMAL" "cc" macro
        "'kc' tcSYM 100 tcDECIMAL" "kc" macro
        "'sb' tcSYM 100 tcDECIMAL" "sb" macro
        "'jo' tcSYM 100 tcDECIMAL" "jo" macro

        "'hg' tcSYM 1E4 tcDECIMAL" "hg" macro
        "'gc' tcSYM  10 tcDECIMAL" "gc" macro
        "'pl' tcSYM  10 tcDECIMAL" "pl" macro
        "'si' tcSYM 1E3 tcDECIMAL" "si" macro

        "'ct' tcSYM 100 tcDECIMAL" "ct" macro
        "'cl' tcSYM 100 tcDECIMAL" "cl" macro
        "'ho' tcSYM 1E4 tcDECIMAL" "ho" macro
        "'hu' tcSYM 1E4 tcDECIMAL" "hu" macro
        "'ng' tcSYM 1E3 tcDECIMAL" "ng" macro

        "'sf' tcSYM 1E4 tcDECIMAL" "sf" macro
        "'eu' tcSYM 1E4 tcDECIMAL" "eu" macro
      \ 5-5-2008: change JY factor from 1E6 to 1E4
        "'jy' tcSYM 1E4 tcDECIMAL" "jy" macro
      \ "'jy' tcSYM 1E6 tcDECIMAL" "jy" macro
        "'mp' tcSYM 1E6 tcDECIMAL" "mp" macro
        "'bp' tcSYM 1E4 tcDECIMAL" "bp" macro

\ NOT TRUE 64ths, but rounded 64ths.  There is a problem with real
\ time data, because it is saved in quoted integer so there is a 
\ factor of 10 when go to 64ths.
        "'us' tcSYM       tc64ths_tmp" "us" macro \ to 64ths 3-04-2008
        \"'us' tcSYM       tc32nds" "us" macro
        "'tn' tcSYM       tc64ths" "tn" macro
        "'ff' tcSYM 1E3 tcDECIMAL" "ff" macro
        "'ed' tcSYM 1E3 tcDECIMAL" "ed" macro

        "'dj' tcSYM 1    tcDECIMAL" "dj" macro
        "'sp' tcSYM 10   tcDECIMAL" "sp" macro
        "'nq' tcSYM 10   tcDECIMAL" "nq" macro
        "'yx' tcSYM 10   tcDECIMAL" "yx" macro
        "'nk' tcSYM 1    tcDECIMAL" "nk" macro
      ]
      " tcDATA: PIT =" . PIT .i nl
      strchop uppercase "S1" book \ tops symbol
      S1 tcSYM any?
      IF "S2" book \ tch symbol
         S1 lowercase (qS) local \ run local word
         (hT) S2 S1 strp \ substitute the tops symbol
      ELSE VOL tpurged
      THEN
      "_" S1 lowercase (qS) + naming
   end

   inline: tcDECIMAL (qS n --- hT) \ process S
      (n) "tcPROCESS" "FAC" bank
      (qS) tcPROCESS
   end

   inline: tcECOLLECT ( --- hT) \ electronic data from tch
      "tcDATA" "PIT" yank "pit" book
      no "tcDATA" "PIT" bank
      tcCOLLECT "_tcECOLLECT" naming
      pit "tcDATA" "PIT" bank
   end

   inline: tcEDATA (qS --- hT) \ electronic data for S
      "tcDATA" "PIT" yank "pit" book
      no "tcDATA" "PIT" bank
      tcDATA
      pit "tcDATA" "PIT" bank
   end

   inline: tcGET (qS --- hT) \ data from tradingcharts.com
      (qS) uppercase "S" book

      time "t0" book

      "http://classic.tradingcharts.com" \ Tue Jul  5 13:59:40 PDT 2011
    \ "http://data.tradingcharts.com" 
    \ Put the site name into HTTPget.Host_alias and it will
    \ go into the credentials, then use IPhostr to get an IP:
      (qHost) dup "HTTPget" "Host_alias" bank

      (qHost) IPhostr (qIPaddr) \ get IP 

    \ (qIP) "/futures/quotes/" S + ".html" + HTTPget (hT)
      (qIP) "/marketquotes/" S + ".html" + HTTPget (hT)

      any?
      IF S (qS) spaced "tcGET" + spaced
         those textput chars (bytes) time t0 less
         (qS bytes delta) msgSPEED
      THEN
   end

   inline: tcPROCESS (qS --- hT) \ get and process S
      [ 
      \ Defaults:
        no "SPECIAL" book
        1 "FAC" book

        " %0.0f %0.0f %0.0f %0.0f c%0.0f %0.0f" "FORM" book

        "(qS) SPECIAL 0<> IF SPECIAL exe (qS) THEN" "special" macro

        '<tr><td align="center"><a href=' "REF" book
      ]
      ercnt push \ monitor the error count from HTTPget (tcGET)

      (qS) dup tcSYM' "SYM" book
      SYM tcTIME "qTIME" book
      (qS) tcGET (hT) 

      ercnt pull - 0<>
      IF " tcPROCESS: nonzero ercnt, returning empty string" . nl
         drop "" return
      THEN

      (hT) any? not IF "" return THEN
      dup "TSAVE" book

      textget (hT) REF tug noblanklines (hT) any? not
      IF drop "" return THEN
      (hT)
 
      (hT) "<center>-</center<" "0.0<" strp (erroneous HTML)
      (hT) "<center>-</center>" "0.0" strp
      " <font size=-1><sup>" "-" strp
      "<font size=-1><sup>" "-" strp
      "/sup>/<sub>8</sub" "" strp
      "/sup>/<sub>32</sub" "" strp
      "/sup>/<sub>64</sub" "" strp
      '<font size="-1">*</font>'  " OLD " strp (hT) 
      (hT) "T" book

      "tcDATA" "PIT" yank "pit" book

      VOL tpurged "CON" book
      VOL tpurged "TIME" book
      VOL tpurged "Vol" book
      VOL tpurged "OpnInt" book

      T rows 1st
      DO T I reach "D" book
         D "/intraday/" "'" between Mo_fix (qCon)
         CON swap pile "CON" book

         D 'align="left"' tug ">" "<" between (qS)
         dup "OLD" grepr rows any
         IF (qS) "OLD" "" strp true ELSE false THEN "Old" book
         (qS) words "W" book

         W rows 12 < 
         IF " tcPROCESS: not enough words extracted" . nl "" return THEN

         W 1st quote special   \ open
         W 2nd quote special   \ high
         W 3rd quote special   \ low
         W 4th quote special   \ last

         pit 
         IF W 8 ndx quote dup strchop "0.0" = 
            IF drop dup (last) 
            ELSE special
            THEN "c" swap + \ settle
         ELSE (last) "c" over + 
         THEN

         W 9 ndx quote special \ change
         6 listn

         W 7 ndx reach 
         "0123456789:" chkeep strchop dup chars 1 >
         IF ":00" + ELSE drop "00:00:00" THEN

         (qTime) Old IF drop "00:00:00" THEN \ make time invalid if Old
         TIME swap pile "TIME" book

         W 10 ndx reach dup number IF drop ELSE drop "0" THEN (qVOL)
         Vol swap pile "Vol" book

         W 12 ndx reach dup number IF drop ELSE drop "0" THEN (qOpnInt)
         OpnInt swap pile "OpnInt" book

      LOOP
      T rows pilen (hDATA) 
      purged "T" book

\     Columns of DATA: open high low settle close change
      SPECIAL 0= \ apply FAC to the non-special data
      IF (hDATA) "c" " " strp (hDATA)
       \ Scale the six columns of price data by FAC, format to integer:
         (hDATA) dup numbers (hA) those rows matrix
         1st six items catch FAC * 
         FORM format 
         spaced hand (hT) lop
      THEN (hDATA)

      CON spaced swap (hDATA) spaced Vol spaced OpnInt spaced 4 parkn

    \ Last minute fixups:
      "inf" "0" strp \ items not caught that should have been 0
      " 0.0000 " " 0 " strp \ tn
      " 0.000 " " 0 " strp  \ us
      " 0.00 " " 0 " strp   \ w, c, s
      " 0.0 " " 0 " strp    \  Vol or OpnInt

      (hT) any?
      IF TIME any? not
         IF DTIME those rows repeat
         ELSE qTIME main
         THEN
         (hT Time) park
         neat
      ELSE VOL tpurged
      THEN

    \ Reset the defaults:
      no "SPECIAL" book
      one "FAC" book
   end

   inline: tcREF ( --- qS) \ text at beginning of each data block
      [ "<tr>" "KEY" book ] KEY
   end

   inline: tcSAVE (hT --- ) \ save data to file
      mpath "tc_" cat
      date sysdate lop "%06.0f" format cat
      ".dat" cat
      save
   end

\  Make hashes tcSYM# and tcESYM# that are used by word tcSYM:

\  Hash of tops symbols and pit symbols:
\  Tops symbols:

   "w c s sm bo lc lh pb cc kc sb jo hg gc pl si "
   "ct cl ho hu ng sf eu jy mp bp us tn ff ed " pile
   "dj sp nq yx nk" pile lowercase words (hKeys)

   "w c s sm bo lc lh pb cc kc sb oj hg gc pl si "
   "ct cl ho rb ng sf ec jy mq bp us ty ff ed " pile
   "dj sp nd yv nk" pile lowercase words (hVals)

   (hKeys hVals) 100 "tcSYM#" hash_make

\  Hash of tops symbols and electronic symbols:
   depth push
\  Tops Electronic
   "w   ZW"
   "c   ZC"
   "s   ZS"
   "sm  ZM"
   "bo  ZL"

   "lc  LE"
   "lh  HE"
   "pb  PD"
{
   "cc  OA"
   "kc  KN"
   "sb  SD"
   "jo  OK"
}
   "cc  CC"
   "kc  KC"
   "sb  SB"
   "jo  OJ"

   "hg  HG_"
   "gc  GC_"
   "pl  PL_"
   "si  SI_"

   "ct  CT"
\  "ct  CY"
   "cl  CL_"
   "ho  HO_"
   "hu  RB_"
   "ng  NG_"

   "sf  S6"
   "eu  E6"
   "jy  J6"
   "mp  M6"
   "bp  B6"

   "us  ZB"
   "tn  ZN"
   "ff  ZQ"
   "ed  GE"

   "dj  YM"
   "sp  ES"
   "nq  NQ"
   "nk  NY"

   depth pull less pilen lowercase
   dup 1st word drop swap 2nd word drop (hKeys hVals)

   (hKeys hVals) 100 "tcESYM#" hash_make

\  Make hashes tcSYM#' and tcESYM#' that are used by word tcSYM'
\  (they are the inverses of hashes tcSYM# and tcESYM#):
   tcSYM# (hHASH)
   dup hash_Vals swap hash_Keys
   (hKeys hVals) 100 "tcSYM#'" hash_make

   tcESYM# (hHASH)
   dup hash_Vals swap hash_Keys
   (hKeys hVals) 100 "tcESYM#'" hash_make

   inline: tcSYM (qS --- qS1) \ tc symbol
      "tcDATA" "PIT" yank
      IF (qS) lowercase tcSYM# 
      ELSE (qS) lowercase tcESYM#
      THEN
      swap hash_lookup drop any? IF 1st quote uppercase ELSE "" THEN
   end

   inline: tcSYM' (qS1 --- qS) \ tc inverse symbol
      "tcDATA" "PIT" yank
      IF (qS1) lowercase tcSYM#'
      ELSE (qS1) lowercase tcESYM#'
      THEN
      swap hash_lookup drop any? IF 1st quote uppercase ELSE "" THEN
   end

   inline: tcTIME (qMkt --- qTIME) \ word to run to convert time string
   \ Thu May  6 16:30:21 PDT 2010 Revised to use internal string MKT
      [ {"
           CH>LA W
           CH>LA C
           CH>LA S
           CH>LA SM
           CH>LA BO

           CH>LA LC
           CH>LA LH
           CH>LA PB

           NY>LA CC
           NY>LA KC
           NY>LA SB
           NY>LA JO

           NY>LA HG
           NY>LA GC
           NY>LA PL
           NY>LA SI

           NY>LA CT
           NY>LA CL
           NY>LA HO
           NY>LA HU
           NY>LA NG

           CH>LA SF
           CH>LA EU
           CH>LA JY
           CH>LA MP
           CH>LA BP

           CH>LA US
           CH>LA TN
           CH>LA FF
           CH>LA ED

           CH>LA DJ
           CH>LA SP
           CH>LA NQ
           NY>LA YX
           CH>LA NK
        "} asciify noblanklines chop
        dup 1st word drop "qTIME" book
        2nd word drop "MKT" book
      ]
      strchop "N" book
      MKT N uppercase grepe any? not
      IF " tcTIME: market " N + " not found" + ersys return THEN
      qTIME swap reach chop
   end

   private halt

\-----------------------------------------------------------------------
