{ File mrc.v  July 2000 

   Copyright (c) 2000-2012   D. R. Williamson

   Resource file of general words and data.

\-----------------------------------------------------------------------

   Note and warning: If a jan-mar.YY file appears, a new mdataYY.bin 
   file is created and the previous yearly file, mdataXX.bin, is as-
   sumed to be complete.  

   But if the old oct-dec.XX file was not run at the end of year XX, 
   then there will be days missing in the yearly file mdataXX.bin.

   To make the yearly file for XX complete, it can be remade as shown
   in this example to remake mdata01.bin for the year 2001:

      "mrc.v" source                 # sources required mfil.v
      101 ycreate                    # 2001 (years are 1900 based)

   For this example of 2001, ycreate in mfil.v will use these ascii 
   files: jan-mar.01, apr-jun.01, jul-sep.01, oct-dec.01

   Also see notes about ycreate in file mfil.v.

------------------------------------------------------------------------

   Problem when PB market was discontinued.

   On November 17, 2010, market PB was discontinued.  The open interest
   had dropped to only 5 contracts, and on this day the site collection
   at end of day failed.  Various places in this file and uboot.v needed
   minor editing to remove PB so that word tracklist and others do not
   reference it.  

   On starting an electronic market console, an error in yget() (file
   mfil.v) hit an error with fold(), saying rows would be lost.  Binary
   files for years 2009 and 2010 were remade (109 ycreate, 110 ycreate)
   and the console worked fine.  

   This means that earlier files will hit the same error if they are 
   ever read (which is becoming more and more doubtful all the time).

------------------------------------------------------------------------

   Specific new year problems.

------------------------------------------------------------------------

   January 3, 2011.  Making the initial mdata11.bin file.

   After running end of day on the first trading day in this new year,
   a new file jan-mar.11 appears, but the system is not smart enough to
   make a binary file mdata11.bin from it.  Here is the response when
   trying to open a market condole:

      Electronic Market Console
      Enter ? for help, exit to quit
      Enter a market symbol to connect to the real time data server: 
        eu sf jy cl hg gc dj sp nq us tn 
      % eu
      EU real time
      Analyzing the last 40 days ...
       file: cannot open old file: /mdat/mdata11.bin
       null: r or c is negative
       faulty phrase: prompter
      % 

   File mdata11.bin was created by running:

      "mrc.v" source
      111 ycreate

   and everything is ready for the new year.

   Expect this problem every year until eod.v or word newday in mday.v
   are fixed.

------------------------------------------------------------------------

   January 4, 2010.

   End of day did not work (pre-eod) because there was no jan-mar.10
   quarterly file:

      [dale@plunger] /home/dale > tops
               Tops 3.1.0
      Mon Jan  4 15:47:26 PST 2010
      [tops@plunger] ready > eod
       eod: reverting to files before pre-eod?
       eod: say yes for pit eod and no for pre-eod. > no
       eod: pre-eod: do not continue if con_update.dat has
          rollover changes and COLLECTOR has not made new
          con.dat file; WAIT UNTIL AFTER 3 PM
       CONTINUE?  Say yes. > yes
       eod: pre-eod, saving files for reverting:
         con.dat.rev
         latest.dat.rev
       eod: quarterly file not found; halting

      [tops@plunger] ready > bye
      15 keys
               Good-bye
      Mon Jan 4 15:47:57 PST 2010

   Here is running the touch command to make a zero byte file:

      [dale@plunger] /mdat > touch jan-mar.10
      [dale@plunger] /mdat > ll jan-mar.10
      -rw-r--r--    1 dale     comm         0 Jan  4 15:50 jan-mar.10

   With the dummy file, eod ran fine and, unlike last year (see below),
   mdata10.bin was written, perhaps because the eod.v program has been
   changed to explicitly write it.

------------------------------------------------------------------------

   January 2, 2009.  Making the initial mdata09.bin file.

   After running end of day on the first trading day in this new year, 
   a new file jan-mar.09 appears, but the system is not smart enough to
   make a binary file mdata09.bin from it.

   File mdata09.bin was created by running:

      "mrc.v" source   
      109 ycreate 

   and everything is ready for the new year.

   Expect this problem every year until eod.v or word newday in mday.v 
   are fixed.
}
\-----------------------------------------------------------------------

{  Make sure there is an ascii data file "jan-mar.YY" for this year,
   YY.  If not, the first day of trading data for new year YY has not
   been collected yet, and it is too soon to switch:
}  date sysdate drop 10000 / integer (YYY) is this_year
   mpath "jan-mar." + this_year 100 - "%02.0f" format + file? not
   IF this_year 1- "this_year" book \ still on last year's database
   THEN

\  1988 is the very first year:
   list: 88 this_year thru end makes allyears
{
\  The default database to load is 10 years long:
   list: this_year 10 less 88 max, this_year thru end makes years
}
\  The default database to load is 5 years long (March 2008):
   list: this_year 5 less 88 max, this_year thru end makes years

\  To recreate a year's binary file, like mdata01.bin for 2001, see 
\  the note above or notes at the top of file mfil.v.

\-----------------------------------------------------------------------

   260 is year \ days per year, for phrase like: year last
   inline: mo "year" main * 12 / 0.5 + integer ;

   public

   inline: yl (hC --- hC) year last ;
   inline: 2yl (hC --- hC) year again plus last ;
   inline: 3yl (hC --- hC) year three star last ;
   inline: 4yl (hC --- hC) year four star last ;
   inline: 5yl (hC --- hC) year five star last ;
   inline: 6yl (hC --- hC) year six star last ;
   inline: 7yl (hC --- hC) year seven star last ;

   inline: ql (hC --- hC) three mo last ; \ last quarter
   inline: 2ql (hC --- hC) six mo last ; \ last two quarters
   inline: 3ql (hC --- hC) nine mo last ; \ last three quarters
   inline: 4ql (hC --- hC) year last ; \ last four quarters

   inline: 3l (hC --- hC) 3 last ;
   inline: 5l (hC --- hC) 5 last ;
   inline: 10l (hC --- hC) 11 last ; \ note really 11, for 1/2 mo. span
   inline: 20l (hC --- hC) 20 last ;
   inline: 30l (hC --- hC) 30 last ;
   inline: 60l (hC --- hC) 60 last ;
   inline: 90l (hC --- hC) 90 last ;

   inline: name ( --- ) "Name" main . ;

   3 mo is show

   inline: sl (hC --- hC) show last ;

   private

   "32nds" missing IF tex.v source THEN
   "qfilename" missing IF cal.v source THEN
   "_pppconnect" missing IF "web.v" source THEN

\  NOTE: mfil.v is sourced below after mKey is defined

   1based private

\-----------------------------------------------------------------------
{
   The following struct is shown only for reference; mfil.v actually 
   runs these phrases.

\  This is the structure of the matrix columns that are returned by
\  word data and placed into _DATA by word dataget (given below):
\  Structure of matrix columns returned by word data:

   "data" list:
      "date"                          \ YYYMMDD

    \ These 12 items are read in yget():

      "delmo"                         \ del month

      "Chg"                           \ change (used when roll del mo)

      "Open"  "High"  "Low"  "Close"  \ scaled pit quotes for del mo
      "eOpen" "eHigh" "eLow" "eClose" \ scaled elec quotes for del mo

      "vol" "int" (added May 2011)    \ volume and open interest

    \ These perpetual quotes and rollover are appended in word data():
      "open"  "high"  "low"  "close"  \ perpetual pit for del mo
      "eopen" "ehigh" "elow" "eclose" \ perpetual electronic for del mo
      "roll"                          \ rollover add on

   end struct
}
\  This macro, DATA, seen by all, puts matrix _DATA on the stack:
   "'_DATA' main" "DATA" macro
{
   Example use of inline DATA and struct data for some of its names:
      DATA data.high catch \ column of pit market highs
      DATA data.elow catch \ column of electronic market lows
      DATA data.date catch \ list of dates
}
\-----------------------------------------------------------------------

\  Markets and scaling:

   inline: C ( --- hC) \ perpetual closing price
      DATA data.close catch (hC) "_C" naming ;

   inline: C(k) (k --- Ck) \ perpetual price on step k
      [ 0 "C" book ]
      "WHATIF" exists?  
      IF WHATIF IF C ELSE "C" main THEN 
      ELSE "C" main 
      THEN swap pry ;

   inline: Cperp (hCsq k --- hC) \ scaled quote to perpetual C
{     Given step k population scaled data, Csq, return perpetual value
      containing rollover offsets.

      This word reverses the work of Csq.

      To see how scaling works, see demo in word Csq.
}
      dup (k) DATA_Close
      swap (k) C(k)
      less (rolldelta) less
   end

   inline: Cqs (hCq --- hCs) \ price quoted from web into scaled price
{    This word scales web quote Cq for the current market into the
     format that appears in the ascii data files, then uses the
     related scaling function.

     Web quotes come from words like mfetch and cfetch that obtain data
     from tables at sites topsdog and fortycoupe, using HTTPget.

     Resulting Cs is scaled but not offset to perpetual.  Word Cperp
     does that.
}     [
        "10 those dims fill /mod swap 8 / +" "w"  inlinex \ 2896
        "10 those dims fill /mod swap 8 / +" "c"  inlinex
        "10 those dims fill /mod swap 8 / +" "s"  inlinex
        "10 /"                               "sm" inlinex \ 1559
        "100 /"                              "bo" inlinex \ 1939

        "100 /"                              "lc" inlinex
        "100 /"                              "lh" inlinex
        "100 /"                              "pb" inlinex

        "noop"                               "cc" inlinex
        "100 /"                              "kc" inlinex
        "100 /"                              "sb" inlinex
        "100 /"                              "jo" inlinex

        "100 /"                              "hg" inlinex
        "10 /"                               "gc" inlinex
        "10 /"                               "pl" inlinex
        "10 /"                               "si" inlinex

        "100 /"                              "ct" inlinex
        "100 /"                              "cl" inlinex
        "100 /"                              "ho" inlinex
        "100 /"                              "hu" inlinex
        "10 /"                               "ng" inlinex

        "100 /"                              "sf" inlinex
        "100 /"                              "eu" inlinex
        "100 /"                              "jy" inlinex
        "1000 /"                             "mp" inlinex
        "100 /"                              "bp" inlinex

        "100 those dims fill /mod swap 32 / +"   "us" inlinex \ 11104
      \ 64ths are displayed as 32.5nds:
        "1000 those dims fill /mod swap 320 / +" "tn" inlinex \ 111045
        "1000 /"                                 "ff" inlinex
        "1000 /"                                 "ed" inlinex

        "noop"                               "dj" inlinex
        "10 /"                               "sp" inlinex \ 11854
        "10 /"                               "nq" inlinex \ 15095
        "100 /"                              "yx" inlinex \ 70400
        "100 /"                              "nk" inlinex \ 12050
      ]
      (hCq) hand
      dup 0< 2 * 1+ (hSigns) push abs

      "Name" main               \ name of current market
      (qS) lowercase (qS) local \ scale like ascii files
      "scale" main main         \ scale to perpetual

      pull (hSigns) *by

      "_" "Name" main cat naming
      these dims * one = IF ontop THEN
   end

   inline: Cquote (hC --- hCquote) \ C scaled to quoted
{     NOTE: Cquote values cannot be used to compute percentage changes.

      For percentage changes in daily price, use "C delta" for the 
      numerator and use "DATA data.Close catch" for denominator (see 
      note in word s1).

      To see how scaling works, see demo in word Csq.
}
      this type NUM = IF yes ELSE no THEN "num" book 
      hand this push cols 1st
      DO peek (hC) I catch "Name" main prices 
         "Name" main priceformat1 numerate 
      LOOP pull cols parkn
      num IF ontop THEN
   end

   inline: Csq (hC k --- hCsq) \ perpetual C into scaled quote (sq)
{     Given step k population perpetual scaled data, C (containing
      offsets), return scaled quoted values for step k, Csq.

      Scaled quoted values are raw quoted values that have been multi-
      plied by a scale factor to remove any fractions, thus allowing 
      them to be treated as 2- or 4-byte integers.  

      For example, the minimal change in grain quotes is 1/4 cent, so 
      they are multiplied by 4 (word _s4), making a change of 1 in the 
      scaled value equivalent to the smallest tic change, in this case 
      one-quarter of a cent.  The one-tic change in 30 year bonds is 
      1/32, so they are multiplied by 32 (word _s32).

      Word Cperp is used to reverse this process.

      WARNING: Due to rollover, Csq values (just like raw quotes) are 
      not usually valid from one step to another.
}
      DATA rows that < IF drop return THEN \ no offset on newest

      dup (k) DATA_Close
      swap (k) C(k)
      less (rolldelta) plus
   end

   inline: DATA_Close (k --- C) \ scaled quoted close on k
\     Returned C is scaled from actual data, but has no offset.
      [ 0 "C" book
        {" After C(k) is banked, whatif_init runs this local word:
           "C(k)" "C" yank (C1)
           these dims null (hC2) "C" main (hC0)
           (hC2 hC0) 1st those rows items them ram (hC2)
           (hC1 hC2) less (hCdel)
           these dims null (hD) DATA data.Close catch (hC)
           (hD hC) 1st those rows items them ram (hCdel hD) plus
           (hC) "C" book
        "} "makeC" inlinex
      ]
      "WHATIF" exists?
      IF WHATIF IF C swap pry ELSE DATA swap data.Close fetch THEN
      ELSE DATA swap data.Close fetch 
      THEN
   end

   inline: dataget (qM --- f) \ get database for M during years
{     February 2008.  Now that the program runs for a full week instead
      of being started every day, it is necessary to check to see if 
      new daily data has been added and if so, run newday() again to 
      make the latest yearly binary file with the new day.
}     
      [ 0 "DATA_TIME" book 
        "" "DATA_MKT" book
        yes "DATA_RELOAD" book

      \ purged '"_DATA" fbook' main
        purged "_DATA" mainbook \ July 2009: use RAM
      ]
      true one STR stkok and not
      IF "dataget" stknot no (f) return THEN

      (qM) uppercase "MKT" book

      MKT "'Name' book" main
      "years" main yearfix hand "years" book

\" begin dataget" . timeprobe nl

    \ First check the time of daily update against DATA_TIME:
      mpath "latest.dat" + filetime DATA_TIME <>
      IF "newday" ERRset

       \ Update: Wed Nov 11 15:32:13 PST 2009
       \ The end-of-day program takes care of running newday, so do
       \ not run newday if this is an electronic market console:
         "TGRAPH" exists? not \ don't do if electronic market console
         IF newday THEN loadref 

         "loadref" "reftime" yank "DATA_TIME" book

         yes "DATA_RELOAD" book

         ERR
\" dataget: newday done" . timeprobe nl
      ELSE no "DATA_RELOAD" book
      THEN

    \ Next check the MKT against DATA_MKT:
      DATA_RELOAD not
      IF MKT DATA_MKT <>
         IF yes "DATA_RELOAD" book THEN
      THEN

      DATA_RELOAD 
      IF
{        Load data from yearly binary files.  The latest yearly binary
         file is created when word newday() runs (file mday.v).  It
         holds data (called end-of-day data) up to when the pit and 
         electronic markets were closed for the last session:
}
         "calling word data for " MKT + ERRset

         years (hYYY) MKT kID data (hData qS qU)
\" dataget: quarterly DATA loaded" . timeprobe nl
         (qU) "'unscale' book" main 
         (qS) "'scale' book" main 

         (hData) dup rows "DATA_ROWS" book 
       \ (hData) '"_DATA" fbook' main \ fbook this big array
         (hData) "_DATA" mainbook \ July 2009: use RAM

\" dataget: quarterly DATA fbooked" . timeprobe nl

         ERR

         DATA_ROWS any not 
         IF "" "DATA_MKT" book
            no (f) return 
         THEN
{
Nov 27 2009: This error is due to purging DATA in the "newday" branch 
of this word.  Purging of DATA has been moved so it is done only at 
start up, and it is now ok to run this branch again from TGRAPH.

This is the error in TGRAPH when try to run this branch again:
... 
 catch: seeking column that is out of bounds
 popd: expect number on stack
 ERR: error in yget
 ERR: error in data calling yget for I=2
 pilen: expect matrix on stack
 ERR: error in yget
 ERR: error in data calling yget for I=2
 pilen: expect matrix on stack
 park matrix rows: matrices are not compatible
 ERR: error in word data loop
 ERR: error in calling word data for CL
 libload: no data found for CLlib
}
         MKT "DATA_MKT" book
      THEN

    \ If it exists, add a row of latest real time data to _DATA.
      "calling latest_rt for " MKT + ERRset
      MKT latest_rt words "T" book \ latest real time data
      T "closed" grepr rows 0= (f) \ true if not closed
\" dataget: ran latest_rt" . timeprobe nl
      ERR
      (f)
      IF \ later real time data is present

         "loading real time data" ERRset

         "_DATA" main 1st data.int (OI) items catch (hData)
         (hData) dup rows DATA_ROWS > \ any added row?
         IF 1st DATA_ROWS items reach (hData) \ remove old added latest
         THEN (hData)

\" dataget: reached data from _DATA" . timeprobe nl

       \ Sun May 22 16:33:38 PDT 2011.  This region has been revised
       \ for two additional columns of pit volume and open interest.

       \ The matrix now on the stack contains these columns matching
       \ the order of the first 13 columns specified by the struct
       \ called data (to item data.int):
       \    date delmo Chg O H L C eO eH eL eC V I

       \ Fetch V and I numbers to use in latest row built below:
         (hData) dup 1 endmost (hR)
         (hR) dup data.vol catch @ "vol" book
         (hR) data.int catch @ "int" book 
         (hData)

       \ From latest electronic data in T, make a latest row with 13 
       \ columns as shown above and append to Data on the stack and do 
       \ rollover (which adds 9 more columns):
         T 2nd 5 items reach numerate (hP) Cqs (hP) \ scaled prices
         (hP) "P" book \ O, H, L, C, Chg

         list:
            MKT 0 1 rtfiles rtdates @ (nDate)
            T 1st quote sym_decode lop (nDelmo)
            P 5 ndx pry (nChg)
            4 1st DO P I pry LOOP (nO nH nL nC) \ pit
            4 1st DO P I pry LOOP (nO nH nL nC) \ electronic
            vol
            int
         end
         bend 
         pile (hData)

\" dataget: have electronic data" . timeprobe nl

       \ Making perpetual quotes (if contract month changed today,
       \ rolled prices of previous days will differ slightly from
       \ rolled prices when end-of-day data is processed later after
       \ the pits have closed and the settle price is used):
         
       \ The following code was taken from word data() in mfil.v:
         "data" "Quotes" yank "Quotes" book

         (hData) this again push
         (hData) Quotes catch (hOHLC)
         peek data.delmo catch (hDelmo)
         peek data.Close catch (hC)
         pull data.Chg catch (hChg) rolldelta (hDel) dup push

         (hOHLC hDel) those cows clone plus (hPerp)
         (hData hPerp) park (hData) \ append cols of perpetual data
         pull (hDel) park (hData) \ last column is roll delta

\" dataget: rolldelta done" . timeprobe nl

       \ Done.  Fbook the new matrix:
       \ (hData) '"_DATA" fbook' main
         (hData) "_DATA" mainbook \ July 2009: use RAM

         ERR

\" dataget: real time data loaded" . timeprobe nl

      THEN
      yes (f)
   end

   inline: dprices (hdC qName --- hdC1) \ remove scaling from changes
      push hand integer 
      mKey peek
      (qS) kID mKeyRow key.unscale fetch num2str main
      pull factors fac.D pry (D) *f 
   end

   inline: eC ( --- heC) \ electronic perpetual closing price
      DATA data.eclose catch (hC) "_eC" naming ;

   inline: H ( --- hH) \ high price
      DATA data.high  catch (hH)
      DATA data.ehigh catch (hH) max \ take electronic and pit max
      "_H" naming
   end

   inline: ID ( --- hID) \ list of ref IDs (ascending order)
\     These IDs match the ones returned by word kID; they are in
\     ascending order.
      "loadref" "Ref" yank, four ndx catch ; (Rev Jan 2008.)

   inline: L ( --- hL) \ low price
      DATA data.low catch (hL1) \ pit low

    \ There are problems with electronic low being zero, so we just
    \ can't take the lowest of pit and electronic.  When electronic
    \ low is zero, it becomes equal to roll delta so it is easy to
    \ spot at this point.
      DATA data.elow catch (hL2) dup DATA data.roll catch =
      (hRAKE) push

    \ Rake out the zero terms and replace them with terms from L1, the
    \ pit lows:
      (hL2) peek (hRAKE) rake (hL hL0) drop
      over (hL1) peek (hRAKE) rake lop (hL hL0) pull (hRAKE) tier (hL2)

      (hL1 hL2) min
      "_L" naming
   end

   inline: LATEST1 (qM --- hT)
\     Revised January 2008 for new quarterly file format.

\     Scale values for market M from loadref.latest (values as in 
\     quarterly files like jan-mar.08) into format as seen from web 
\     collection.  (Revised January 2008; will not work on earlier
\     quarterly files.)

      [ "F G H J K M N Q U V X Z" words "Months" book ]

      (hM) strchop uppercase "M" book

      M kID dup 0= IF drop VOL tpurged return THEN
      "ID" book

      "loadref" "latest" yank (hA) dup
      1st catch 10000 / integer
      "%0.0f" format ID intstr grepr (hA hR) reach bend "A" book

      M A 1st pry 10000 mod 100 /mod Months
      swap reach swap "%02.0f" format spaced + +
{
      This is how A looks:
         [tops@plunger] ready > 'LATEST1' 'A' yank .m
           Row 1: 1.103e+05   (ID+MO)
           Row 2: 1.231e+04   (date)
           Row 3:       945   (pit open)
           Row 4:       945   (pit high)
           Row 5:       904   (pit low)
           Row 6:       905   (pit close)
           Row 7:       -29   (pit change)
           Row 8:       935   (electronic open)
           Row 9:       951.8 (electronic high)
           Row 10:      904.8 (electronic low)
           Row 11:      905   (electronic close)
 
      Take items the way dataget() does:
}     list:
         A 3 ndx pry (open)
         A 4 ndx pry A 9 ndx pry max (highest of pit and electronic)
         A 5 ndx pry A 10 ndx pry park nzmin1 1st pry (lowest not zero)
         dup abs INF = IF drop 0 THEN
         A 6 ndx pry (pit close)
         A 7 ndx pry (pit change)
      end (hA)

\     Word priceformat1 handles scaling from database values to web
\     values.
      M priceformat1 vol2str + "closed" +
   end

   inline: loadref ( --- ) \ loading reference data
\     Revised January 2008 for new quarterly file format.

      mpath "latest.dat" + filetime "reftime" book

      mpath "latest.dat" + asciiload
      one endmost 2nd word drop dup "D" book numerate revdate @
      "refdate" book

    \ If quarterly file is not present, assume this is not a run that
    \ needs this word loadref() and silently return:
      mpath refdate qfilename + (qFile) dup file? not
      IF (qFile) drop return THEN \ silently return

    \ Using quarterly file--it may have corrections not in latest.dat
      (qFile) dup "reffile" book
      (qFile) asciiload 
      dup 2nd word drop D grepr reach (hT) any?
      IF these rows swap numerate swap matrix (hA) dup "latest" book
      ELSE no "latest" book
         " loadref: no quarterly data for date: " nl . refdate .u nl 
         return
      THEN

      (hA) dup 6 ndx catch (Last) (Rev Jan 2008; no Vol or Opn Int.)
      swap 1st catch
      100 those dims fill /mod
      100 those dims fill /mod
      (Last YY MM ID) four parkn yes four ndx (ID) sorton
      "Ref" book

    \ Handling transition to new year:
      refdate 10000 /mod lop "this_year" main <>
      IF "this_year" main 10000 * 0101 + (refdate)
         mpath swap qfilename + (qFile)
         dup file? not IF "" over save THEN
      ELSE reffile 
      THEN "reffile_to" book
   end

\  Always run loadref when sourcing this file:
  \host "plunger" = IF loadref THEN
   loadref

   inline: loadref_row (qName --- n) \ row of Name in loadref matrix
      "loadref" "Ref" yank 4 ndx catch (Rev Jan 2008.)
      swap kID (hV x) bsearch not
      IF drop zero " loadref_row: Name not found" ersys THEN
   end

   inline: MM ( --- hMM) \ list of ref MMs
\     These match ascending order list from word ID. (Rev Jan 2008.)
      "loadref" "Ref" localpry 3 ndx catch ;

   inline: Mnum (qM --- qn) \ month number corresponding to symbol M
      [ "F  G  H  J  K  M  N  Q  U  V  X  Z " words (hKeys)
        "01 02 03 04 05 06 07 08 09 10 11 12" words (hVals)
        (hKeys hVals) 12 defname "M$" localref hash_make
      ]
      (qM) dup uppercase M$ swap hash_lookup drop any?
      IF 1st quote (qM qn) lop
      ELSE (qM) " Mnum: month number not found for " swap + ersys
      THEN
   end

   inline: MO (qMkt --- qMo) \ contract from mpath/latest.dat
\     This was LATEST1 in an old version of mget.v.
\     See MOdo() for the version used in real time collection.

      [ "F G H J K M N Q U V X Z" words "Months" book ]
{
      Return delivery month, Mo from file latest.dat.
      For today's trading, latest.dat is yesterday's data.
}
      mpath "latest.dat" cat asciiload chop
      these 1st two items catch rot trackID int$ grepr any?
      IF one endmost ontop quote words

         this 1st reach
         Months those 3rd two items catch numerate ontop reach
         swap 5 ndx two items catch cat 1st quote (qMo)

         swap 6 ndx reach numerate ontop (nC) drop \ don't return C

      ELSE " MO: Mkt not found" ersys ""
      THEN
   end

   inline: prices (hC qName --- hC1) \ remove scaling
      dprices
   end

   inline: PRICES ( --- hC) \ quoted prices for mkt now loaded
\     NOTE: PRICES values cannot be used for percentage changes.
\     To make text ints: PRICES int$
      "C" main Cquote ;

   inline: qtic (qName --- n) \ minimum movement in quoted price
      one swap dprices ontop
   end

   inline: qticDollars (qName --- d) \ dollar movement per qtic
      dup qtic hand swap factors fac.$F pry *f ontop
   end

   inline: refdate ( --- YYYMMDD) \ date of reference data
      "loadref" "refdate" localpry ;

   inline: reffile ( --- qFile) \ from file of reference data
      "loadref" "reffile" localpry ;

   inline: reffile_to ( --- qFile) \ to file of reference data
      "loadref" "reffile_to" localpry ;

   inline: RS (hA hB --- hRS) \ relative strength of A above B
   {  RS = (A - B)/(A + B) for all elements of A and B.

      Assumes A and B are non-negative, so if denominator A+B=0, both
      A and B must equal zero.  In this case, RS is set to 0.
   }
      2dup minus rev plus
      dup 0= abs plus \ computing 0/0 as 0/1
      /by
   end

   inline: RS1 (hA hB --- hRS) \ relative strength of A above B
\     Range of RS is -99 to +99.
      RS 100 * 0.5 + integer -99 +99 limited ;

   inline: Settle ( --- hC) \ list of settle prices
      "loadref" "Ref" localpry 1st catch ; 

   inline: spec ( --- ) \ show contract specs in eview window
      specs
   end

   inline: specs ( --- ) \ show contract specs in eview window
      [ mpath "contract_spec.txt" + "FILE" book ]
      FILE filefound
      IF asciiload eview
      ELSE " specs: " FILE + " file not found" + . nl
      THEN
   end

   inline: sym_decode (qSYM --- nID nMoYr) \ decode symbol  
\     Decode symbol into ID, MoYr as used in database (this would never \     be if things could be redone without a lot of work; SYM is the 
\     way it should have been done originally).

\     Number nMoYr is in the second column of array _DATA.

      strchop "S" book

      S 1st S chars 5 = IF 2 items THEN catch (qS) kID (nID)

      S chars 4 = IF S 2nd ELSE S 3rd THEN 3 items catch
      dup 1st catch Mnum number drop (nMo) 100 *
      swap -1 indent number drop (nYr)         
      (nMo*100 nYr) + (nMoYr)
   end

   inline: YY ( --- hYY) \ list of ref YYs
      "loadref" "Ref" localpry two ndx catch ; (Rev Jan 2008.)

   "trackID" missing
   IF " mrc: require trackID, which should be in uboot.v" . nl
      halt
   THEN

   "tracklist" missing 
   IF " mrc: require tracklist, which should be in uboot.v" . nl
      halt
   THEN

\-----------------------------------------------------------------------

\  Real time data collection.  January 2008.

   inline: latest_rt (qMKT --- hT) \ latest real time data for MKT
{     
      Thu Mar 15 05:19:49 PDT 2012.  This word is important for word
      libload() to get electronic data before the pit opens so that the
      market library is correctly set up with ROLLDELTA in cases where
      the contract month is rolled in the next pit session.  This is be-
      cause prices must also be rolled in the electronic session that
      starts the day before, and roll information must be present when
      LIB.ROLLDELTA is accessed in word rtget() as electronic files are
      loaded.
}
      [
{       Mon Dec  5 02:57:16 PST 2011.  After November 29, 2011, returned
        matrix HGET.D has nine columns:
           O, H, L, C, Chg, Vol, Op Int, Settle, GMT

        But for this word, just fetch the original six:
           O, H, L, C, Chg, GMT
}       list: 1 2 3 4 5 9 ; "Rorig" book
      ]
      strchop uppercase "MKT" book
      "latest_rt for " MKT + ERRset

      refdate "n1" book

      MKT 0 1 rtfiles any?
      IF dup "RTFILE" book rtdates @ 
      ELSE 0 
      THEN "n2" book

\"latest_rt n1, n2:" . n1 .i n2 .i nl
      n2 n1 < \ is real time date earlier than quarterly refdate?
      n2 date sysdate drop < or \ or is real time earlier than now?
      IF MKT LATEST1 \ closed; return quarterly file values
\"latest_rt return closed" . nl
      ELSE
         "hget1 branch" ERRset
         RTFILE hget1 (hA)
         (hA) dup rows 0>
         IF (hA) 
            n2 1111129 > \ see hget1() in mfil.v
            IF (hA) Rorig catch THEN (hA)
         THEN
         "A" book

         ERR \ end "hget1 branch" ERRset

       \ Remove rows with zero entries for O, H, L or C (these are in
       \ columns 1 through 4):
         A rows 0>
         IF A dup rows 1 null (hA hR)
            4 1st DO over I catch 0= or LOOP (hA hR) 
            (hA hR) rake drop (hA0) any?
         ELSE no
         THEN 

         (no || hA0 yes)
         IF (hA0) 1 endmost bend "A" book \ take the latest row
{
            Using real time data in A, and depending upon whether MKT
            is open or closed, make a string that looks like one of 
            these:
               CCH08 2332 2390 2321 2378 44 12:14:00
               CCH08 2332 2390 2321 2378 44 closed
}
            n1 n2 =
            IF \ electronic and pit markets are closed
               MKT dup MO + \ use contract of quarterly file
            ELSE \ electronic is open, quarterly data is yesterday,
             \ so use latest contract being collected:
               MKT dup MOdo + \ use "do" contract
            THEN (qMO) spaced

            A 1st 5 items reach bend itext + spaced \ O, H, L, C, Chg
            n1 n2 =
            IF "closed" \ electronic and pit markets are closed
            ELSE A 6 ndx reach ctime (qS) 4th word drop  \ local time
               1st 5 items catch \ HH:MM (no seconds)
            THEN
            + crowd
\"latest_rt take latest row" . nl
         ELSE 
            MKT LATEST1 \ no valid rows; return quarterly file values
\"latest_rt no valid rows, return closed" . nl
         THEN
      THEN
      ERR \ end "latest_rt for " MKT + ERRset
   end

   inline: MOdo (qMkt --- qMo) \ contract month symbol to collect
\     Read contract specification table from file con.dat, and get
\     the current contract for Mkt.

      (qMkt) uppercase (qMkt)

\     Read the contract definition file (warning: do nothing to change
\     text column justification, like running chop or justify):
      mpath "con.dat" + asciiload (hT)

      (hT) dup 1st 2 items catch "++" grepr (hT hRows)
      (hT hRows) reach -2 indent chop (hT)

      (hT) dup rot (qMkt) 2 blpad grepr 1st pry (hT nRow) quote (qS)
      (qS) 2nd word drop (qMo) uppercase
   end
      
   inline: schedule (sec --- ) \ make the current schedule for sec
{     Make the schedule of daily collection sessions for the current 
      week, or the upcoming week if the current one has ended.

      Incoming sec is the current machine time.

      Tables start_day and end_day in this word's library hold the 
      machine times (sec) for start and end of each of the five col-
      lection sessions this week.

      Sessions are 23.75 hours long, beginning at 17:00 CST and ending
      the next day at 16:45 CST.

      Examples (showing times in my time zone, PST): 

         >> time schedule schedule.start_day ctime .
            Sun Jan 27 15:00:00 PST 2008
            Mon Jan 28 15:00:00 PST 2008
            Tue Jan 29 15:00:00 PST 2008
            Wed Jan 30 15:00:00 PST 2008
            Thu Jan 31 15:00:00 PST 2008

         >> schedule.end_day ctime .
            Mon Jan 28 14:45:00 PST 2008
            Tue Jan 29 14:45:00 PST 2008
            Wed Jan 30 14:45:00 PST 2008
            Thu Jan 31 14:45:00 PST 2008
            Fri Feb  1 14:45:00 PST 2008

      This shows the tasks on Friday afternoon at about 3:00 PM, after
      COLLECT_END has set up for the next trading day:

         [tops@plunger] ready > date . nl tasks
         Fri Feb  1 14:58:18 PST 2008 
          Multitasker tasks:
           COLLECT_START,0:CODE__ alarm period 173670 seconds; 
                remaining 172871
           queue_run,0:CODE__ task running at 0.2 Hz; tics remaining 1

      The time remaining before COLLECT_START begins is 48 hours, or 
      next Sunday at about 3:00 PM:
         [tops@plunger] ready > 172871 3600 / .i
          48

      which agrees with the schedule the machine knows about right now:
         [tops@plunger] ready > time schedule 

         [tops@plunger] ready > 'schedule' 'start_day' yank ctime .
         Sun Feb  3 15:00:00 PST 2008
         Mon Feb  4 15:00:00 PST 2008
         Tue Feb  5 15:00:00 PST 2008
         Wed Feb  6 15:00:00 PST 2008
         Thu Feb  7 15:00:00 PST 2008
}
      [ 86400 900 - "TSESSION" book ]

      (sec) "Time" book

    \ Get last Sunday in Chicago (YYYMMDD = today if this is Sunday):
      Time dup CHdiff1 + 1 (Sun) daylast (YYYMMDD)

    \ Decode UTCstart for the starting HHMMSS:
      Time UTCstart oclock (HHMMSS)
      (YYYMMDD HHHMMSS) ltime (sec) "start_week" book

      start_week 86400 5 uniform + "start_day" book
      start_week 86400 5 uniform + TSESSION + "end_day" book

    \ Check the last end_day:
      end_day dup rows pry Time < \ has last end time past?
      IF \ redo the table for the upcoming week

       \ Get next Sunday in Chicago:
         Time dup CHdiff1 + 1 (Sun) daynext (YYYMMDD)

       \ Decode UTCstart for the starting HHMMSS:
         Time UTCstart oclock (HHMMSS)
         (YYYMMDD HHHMMSS) ltime (sec) 

       \ The following accounts for the hour gained or lost on just
       \ the day when clocks are changed for standard or daylight
       \ saving time (this is also done in words session_start and
       \ soonest_start):
         (sec) dup delta_tchg - (sec) "start_week" book

         start_week 86400 5 uniform + "start_day" book
         start_week 86400 5 uniform + TSESSION + "end_day" book

      THEN
   end

   inline: session_start (nYYYMMDD --- sec) \ machine time for start
{     Return the machine time for the start of the session that ends
      on YYYMMDD, the day contained in session file names.

      Sessions with dates like YYYMMDD end on Monday through Friday and
      start the previous day at the time given by UTCstart.

      Example: The session that ends on Feb 1, 2008 started on 
         Jan 31, 2008 at 17:00:00 Central time (this machine
         shows the equivalent Pacific time):

            [tops@plunger] ready > 1080201 session_start ctime .
            Thu Jan 31 15:00:00 PST 2008
}   
      hand push
      list: peek rows 1st
         DO peek I pry dup push (nYYYMMDD) weekday (nd)
            (nd) 2 6 within (f) \ Mon through Fri?
            IF peek datevalid
               IF peek greg 1- gdate (nYYYMMDD) 0 ltime (sec)
                  dup (sec) UTCstart >SEC + 
               ELSE " session_start: " peek intstr +
                  " is not a valid date" + ersys 0 
               THEN
            ELSE " session_start: " peek intstr +
              " does not have a valid session start day" + ersys 0 
            THEN pull drop
         LOOP
      end 

    \ Account for the hour lost or gained when time is changed for
    \ daylight saving time or standard time (on a Sunday; this is 
    \ also done in words schedule and soonest_start):
    \ Sunday March 14, 2010 (daylight saving time): the following is 
    \ what gets the right SStart in word rtget, file mfil.v.  Other 
    \ uses of delta_tchg in this file are dubious, and my whole under-
    \ standing of it is cloudy.
      (hsec) dup delta_tchg - (hsec) 

      pull rows 1 = IF @ THEN
   end

   inline: soonest_end (sec --- s) \ this session ends in s seconds
\     Daily sessions begin and end according to word schedule.

      "Time" book

      Time schedule "schedule" "end_day" yank "T" book

      T Time bsearch drop "r" book

      Time T r pry (Time Tstart) <
      IF T r pry (nSec) \ waiting for Tstart
      ELSE r 1+ T rows ndx <=
         IF T r 1+ pry (nSec) \ Tstart is past, get next one
         ELSE \ week has ended; look at next Sunday
            Time dup CHdiff1 + 1 daynext \ next Sunday
            Time UTCstart oclock (HHMMSS)
            (YYYMMDD HHHMMSS) ltime "schedule" "TSESSION" yank + (nSec)

          \ Note: the correction using delta_tchg done in soonest_start
          \ is not necessary here because no session ends on Sunday.

         THEN
      THEN
      (nSec) Time - (s)
   end 

   inline: soonest_start (sec --- s) \ next session starts in s seconds
\     Daily sessions begin and end according to word schedule.
      "Time" book

      Time schedule "schedule" "start_day" yank "T" book

      T Time bsearch drop "r" book

      Time T r pry (Time Tstart) <
      IF T r pry (nSec) \ waiting for Tstart
      ELSE r 1+ T rows ndx <=
         IF T r 1+ pry (nSec) \ Tstart is past, get next one
         ELSE \ week has ended; look at next Sunday
            Time dup CHdiff1 + 1 daynext \ next Sunday
            Time UTCstart oclock (HHMMSS)
            (YYYMMDD HHHMMSS) ltime (nSec)

          \ The following accounts for the hour gained or lost on just
          \ the day when clocks are changed for standard or daylight 
          \ saving time (this is also done in words schedule and 
          \ session_start):
            (nSec) dup delta_tchg - (nSec)

         THEN
      THEN
      (nSec) Time - (s)
   end

   inline: srt ( --- ) \ update the summary_rt window right now
   \  Sockets are set up in word mday, file uboot.v.  The program on
   \  the second socket is the one running word summary_rt_show.
      "summary_rt_show" sockets 2nd pry remoterun
   end

   inline: summary_rt ( --- hT) \ summary of all real time prices
      tracklist rows 1st
      DO tracklist I quote latest_rt LOOP
      tracklist rows pilen neat 
   end

   inline: summary_rt_show ( --- ) 
      [ tracklist vol2mat bend 1st over rows items park yes sort 
        "Tnames" book \ names in the order of rows of T from summary_rt

        "W C S BO CT LC LH CC SB HG GC SI PL CL HO HU NG EU SF JY BP "
        "US TN DJ SP NQ" + words 
        vol2mat bend "Knames" book \ names to keep for display

      \ Tricky way to use lerp on VOLs (turn them into MATs):
        Tnames Knames lerp "Krows" book \ rows to keep for display
      ] 
\     Word "clock" in the string from summary_rt is temporarily replaced
\     by string "@" so it is shorter than the clock string HH:MM and 
\     will not mess up spacing related to the clock string.

      [ VOL tpurged "SAVE" book ]
      summary_rt (hT) "closed" "@" strp
      SAVE rows over rows =
      IF dup push dup 
         no "changed" book
         (hT) chpack \ pack out blanks and remove last 5 clock chars:
         right justify 1st over chars 5 - items catch push rows 1st
         DO peek SAVE I quote (qS)
            chpack 1st over chars 5 - items catch \ remove 5 clock chars
            grepe rows 0= \ equals 0 if no exact match found 
          \ Put an asterisk in the rows that have changed:
            IF "*" yes "changed" book
            ELSE " "
            THEN
         LOOP
         pull rows pilen "R" book
         pull "SAVE" book
         changed 
         IF SAVE dup chars 6 - 
            split (hLeft hRight) \ split at clock
            chop R swap park (hLeft hRight) park
         ELSE SAVE
         THEN
      ELSE dup "SAVE" book
      THEN (hT) "@" "closed" strp
      (hT) 1st those chars COLS min items catch \ trim to window
      Krows reach \ keep rows

      nl
      date swap pile
      LINES over rows - 0 max 1 blockofblanks pile . cr
   end

   inline: tsession ( --- sec) \ seconds elapsed in trading session
\     Returned sec is the time in the market session timeline right now.

\     Only valid if a session is really going on; this word does not
\     check.

\     Each trading session starts at the time given by word UTCstart:
      time dup push UTCstart >SEC 3600 /  \ UTC hour trading started
      pull 86400 mod 3600 /               \ UTC hour now
      (tStart tNow) 2dup > IF 24 + THEN swap - 3600 *
   end

   inline: UTCstart (sec --- hHH:MM:SS) \ local GMT of session start
{     UTCstart computed below is the time in Greenwich, England when 
      the market session starts.

      Incoming sec is current machine time, and is necessary to obtain
      the difference between Greenwich, England and Chicago, where 
      start is always at 17:00.  

      During standard time, Chicago is six hours earlier than Green-
      wich, and during daylight saving time Chicago is 5 hours earlier,
      so returned HH:MM:SS is either 23:00:00 or 22:00:00.

      The session timeline is relative to UTCstart when setting alarms
      using machine time.
}     
      [ "17:00:00" "Chicago_start" book ]
      (sec) Chicago_start >SEC swap CHdiff1 - >OCLOCK
   end

\-----------------------------------------------------------------------

\  More scaling.

   define: rslash (hA f --- hA1)
    \ [ "/f" "r/" inlinex ] r/ ;
      slash ;

   define: rstar (hA f --- hA1) \ every bit to int
    \ [ "*f rounded" "r*" inlinex ] r* ;
      [ "* 0.5 + integer" "r*" inlinex ] r* ;

   define: _s1 (hQ --- hS) ; \ quoted hQ to scaled hS
   define: _u1 (hS --- hQ) ; \ scaled hS to quoted hQ

   define: _s4 (hQ --- hS) hand 4 rstar ;
   define: _u4 (hS --- hQ) hand 4 rslash ;

   define: _s10 (hQ --- hS) hand 10 rstar ;
   define: _u10 (hS --- hQ) hand 10 rslash ;

   define: _s20 (hQ --- hS) hand 20 rstar ;
   define: _u20 (hS --- hQ) hand 20 rslash ;

   define: _s32 (hQ --- hS) hand 32 rstar ;
   define: _u32 (hS --- hQ) hand 32 rslash ;

\  Mon Aug 31 12:15:06 PDT 2009: Added _s64 and _u64 for TN
   define: _s64 (hQ --- hS) hand 64 rstar ;
   define: _u64 (hS --- hQ) hand 64 rslash ;

   define: _s40 (hQ --- hS) hand 40 rstar ;
   define: _u40 (hS --- hQ) hand 40 rslash ;

   define: _s50 (hQ --- hS) hand 50 rstar ;
   define: _u50 (hS --- hQ) hand 50 rslash ;

   define: _s100 (hQ --- hS) hand 100 rstar ;
   define: _u100 (hS --- hQ) hand 100 rslash ;

{  This trailer table is added to each file made by ycreate, after it 
   stores file ptr, len and size (for example, yput sets size=2 when 
   OHLC prices are stored as 2-byte integers) in each id's row (names
   of scaling functions are stored too, as numbers, and so must be less 
   than 8 characters).

   When a market is read later, this table remains in the library of
   word yget, and can be accessed by:
      "yget" "Key" yank
}
   "key" "id ptr len, scale,         unscale,       size" struct

   list: 11, 0,   0, "_s4"   str2num  "_u4"   str2num 0   ;      \ W
   list: 12  0,   0, "_s4"   str2num  "_u4"   str2num 0   ; park \ C
   list: 13  0,   0, "_s4"   str2num  "_u4"   str2num 0   ; park \ S
   list: 14  0,   0, "_s10"  str2num  "_u10"  str2num 0   ; park \ SM
   list: 15  0,   0, "_s100" str2num  "_u100" str2num 0   ; park \ BO

   list: 21  0,   0, "_s40"  str2num  "_u40"  str2num 0   ; park \ LC
   list: 22  0,   0, "_s40"  str2num  "_u40"  str2num 0   ; park \ LH
\  Discontinue PB Wed Nov 17 15:02:21 PST 2010
\  list: 23  0,   0, "_s40"  str2num  "_u40"  str2num 0   ; park \ PB

   list: 32  0,   0, "_s100" str2num  "_u100" str2num 0   ; park \ SB
   list: 33  0,   0, "_s20"  str2num  "_u20"  str2num 0   ; park \ KC
   list: 34  0,   0, "_s20"  str2num  "_u20"  str2num 0   ; park \ JO
   list: 35  0,   0, "_s1"   str2num  "_u1"   str2num 0   ; park \ CC

   list: 41 0,   0,  "_s20"  str2num  "_u20"  str2num 0   ; park \ HG
   list: 42 0,   0,  "_s10"  str2num  "_u10"  str2num 0   ; park \ SI
   list: 43 0,   0,  "_s10"  str2num  "_u10"  str2num 0   ; park \ PL
   list: 44 0,   0,  "_s10"  str2num  "_u10"  str2num 0   ; park \ GC

   list: 53 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ CT
   list: 54 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ HO
   list: 55 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ CL
   list: 56 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ HU
   list: 57 0,   0,  "_s10"  str2num  "_u10"  str2num 0   ; park \ NG

   list: 61 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ SF
   list: 62 0,   0,  "_s50"  str2num  "_u50"  str2num 0   ; park \ BP
\  list: 63 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ DM
   list: 64 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ JY
   list: 66 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ MP
   list: 68 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ EU

   list: 65 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ ED
\  Mon Aug 31 12:15:06 PDT 2009: Use _s64 and _u64 for TN:
   list: 71 0,   0,  "_s64"  str2num  "_u64"  str2num 0   ; park \ TN
\  list: 72 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ TB
   list: 79 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ FF
   list: 73 0,   0,  "_s32"  str2num  "_u32"  str2num 0   ; park \ US

   list: 74 0,   0,  "_s20"  str2num  "_u20"  str2num 0   ; park \ SP
\  list: 75 0,   0,  "_s20"  str2num  "_u20"  str2num 2   ; park \ YX
   list: 76 0,   0,  "_s1"   str2num  "_u1"   str2num 0   ; park \ DJ
   list: 77 0,   0,  "_s100" str2num  "_u100" str2num 0   ; park \ NK
   list: 78 0,   0,  "_s10"  str2num  "_u10"  str2num 0   ; park \ NQ

   list: 00  0,   0, "_s1"   str2num  "_u1"   str2num 0   ; park \ RATIO
   bend yes sort into _mKey

\  Inline mKey, seen by all, puts matrix _mKey on the stack:
   "'_mKey' main" "mKey" inlinex

\  Source mfil.v after mKey is defined:
   "data" missing IF "mfil.v" source THEN

   inline: kID (qS --- id) \ return id for symbol
      [ "C S SM BO W "
        "LC LH " cat
        "CC KC SB CT JO " cat
        "HG GC PL SI " cat
        "CL HO HU NG " cat
        "US TN TB FF ED DJ SP NK NQ " cat
        "JY DM BP SF MP EU " cat
        "RATIO" cat
        words vol2mat bend

        list:
          12 13 14 15 11
          21 22
          35 33 32 53 34
          41 44 43 42
          55 54 56 57
          73 71 72 79 65 76 74 77 78
          64 63 62 61 66 68 
          0
        end
        park yes sort into IDs
      ] uppercase IDs 1st catch swap str2num bsearch
        IF IDs 2nd catch swap pry
        ELSE drop zero " kID: symbol not found" ersys
        THEN
   end

   inline: kS (id --- qS) \ return symbol S for id
      [ "kID" "IDs" localpry "2 1" numbers catch
        yes sort "SYMs" book
      ] SYMs again rot bsearch
      IF 2nd fetch num2str notrailing uppercase
      ELSE 2drop " id not found" .
      THEN
   end

   inline: kS1 (id --- qS1) \ return alternate S for id
      [ list:
         34 35 66 68 71 ;
        "OJ CO ME EC TY" words vol2mat bend
        park yes sort into SYMs
      ] SYMs again other bsearch
      IF 2nd fetch num2str notrailing uppercase lop
      ELSE 2drop kS
      THEN
   end

   inline: mKeyRow (id --- nrow) \ row in mKey for id
      mKey key.id catch swap bsearch not
      IF " row not found" ersys drop fail THEN
   end

\-----------------------------------------------------------------------

\  Latest data from web.

   inline: LATEST (qMkt --- hT) \ latest price, chg, time
{     Example:

         [tops@plunger] ready > "hg" latest_rt .
         HGH08 35200 35990 35195 35450 55 07:42:00

         [tops@plunger] ready > "hg" LATEST . 
         HGH08
         35450
         55
         07:42:00
}
      [ list: 1 5 6 7 ; ndx "R" book ]
      latest_rt any?
      IF "closed" "CLOSED" strp
         " c" " " strp
         words R reach
      ELSE ""
      THEN
   end

   inline: LATEST_HLC (qMkt --- hHLC) \ HLC = [H, L, C]
      [ list: 3 4 5 ; ndx "R" book ]
      "mkt" book

    \ Latest from quarterly files:
      mkt LATEST1 (hT) words R reach " c" chblank chop
      numerate "REF" book

      mkt latest_rt
      any? not
      IF REF \ use loadref.latest
      ELSE (hT) words R reach "c" chblank chop numerate "A" book
       \ Check bounds and return REF(i) if A(i) is outside:
         REF A 1.5 * A 0.67 * within "F" book
         F rows 1st
         DO F I pry
            IF A I pry ELSE REF I pry THEN
         LOOP F rows listn
      THEN
   end

   inline: mfetch (qM --- qR) \ row for M from data in WEB_FETCH
      [ {" (hT --- hT1) 
          \ Strip unwanted lines from SUMMARYR.TXT or from WDATA.T:
            "SUMMARYR" "" qreplace 
            "not" "" qreplace \ strip lines with "not    trading"
            "closed" "" qreplace
            dup 1st five items catch (hN) \ have names, like WH05, SFH05
            (hN) right justify 1st two items catch M grepr any?
            IF (hT) reach 1st quote notrailing ELSE (hT) drop "" THEN
         "} "STRIP" macro

         {" (s --- f) \ is day s on a Saturday or Sunday?
            ctime sysdate drop weekday (n)
            (n) dup 0= swap 1 = or \ 0=Sat, 1=Sun
         "} "WEEKEND" macro
      ] 
      (hM) strchop two +trailing right justify uppercase "M" book
      
    \ If wdata.TREMOTE holds any data, it should be returned:
      "wdata" "TREMOTE" yank any? 
      IF (hT) "WEB_FETCH" "TD" bank \ remote data into WEB_FETCH.TD
         ""   "WEB_FETCH" "FC" bank \ no data in WEB_FETCH.FD
      THEN

    \ Latest GMT of data from servers is saved in 1st line:
      "WEB_FETCH" "FC" yank any?
      IF 1st reach numerate any? 
         IF @ \ dup WEEKEND IF drop 0 THEN (disable for electronic)
         ELSE 0 
         THEN 
      ELSE 0 
      THEN (t1) 

      "WEB_FETCH" "TD" yank any? 
      IF 1st reach numerate any? 
         IF @ \ dup WEEKEND IF drop 0 THEN (disable for electronic)
         ELSE 0 
         THEN 
      ELSE 0 
      THEN (t2)

      max (tweb)

    \ Latest GMT for local data:
      "loadref" "reftime" yank (tweb tlocal) > (f)

      IF \ during trading hours:
         "WEB_FETCH" "TD" yank any? \ data from topsdog
         IF (hT) STRIP (hT) ELSE "" THEN "TD" book
      
         "WEB_FETCH" "FC" yank any? \ data from fortycoupe
         IF (hT) STRIP (hT) ELSE "" THEN "FC" book
    
       \ Take the row with the latest time in word seven:
         TD any?
         IF seven ndx word 
            IF dup "closed" <> 
               IF oclock ELSE drop zero THEN
            ELSE zero 
            THEN
         ELSE zero
         THEN (nTD)

         FC any?
         IF seven ndx word 
            IF dup "closed" <> 
               IF oclock ELSE drop zero THEN
            ELSE zero 
            THEN
         ELSE zero
         THEN (nFC)

         (nTD nFC) > IF TD ELSE FC THEN (qR)
      ELSE ""
      THEN

      (qR) any? not

      IF \ web station collections failed, or it is after trading 
         \ hours:
         "WDATA" "T" yank any?
         IF STRIP any? not 
            IF M LATEST1 \ use yesterday's
            ELSE \ check the time; it must be earlier than now
               (qT) dup seven ndx word
               IF dup "closed" <>
                  IF oclock ELSE drop INF THEN
                  (qT time) 
               ELSE INF
               THEN (qT time) date sysdate lop (tnow)
               (time tnow) < not \ time must be earlier than now
               IF drop M LATEST1 THEN \ use yesterday's
            THEN
         ELSE M LATEST1 \ use yesterday's
         THEN
      THEN
   end

   inline: WDATA ( --- ) \ latest data from web servers
{     This word is run periodically in the multitasker.

      Used by a server collecting data from web servers and writing
      FILE. 

      Also used by clients reading FILE and placing data into array
      wdata.TREMOTE.
}
      [ "/tmp/WDATA_SERVER.txt" "FILE" book
        VOL tpurged "T" book
        143000 "PDT" book \ 3:00:00 PM, PDT
      ]

      "WDATA_SERVER" "SERVING" yank (f)
      IF \ server running:
         WEB_FETCH not 
         IF " WDATA: data fetch failed" . nl return THEN

         wdata "T" book

         T rows 0>
         IF "WEB_FETCH" "LAST" yank T pile "T" book \ 1st T line is GMT
            T FILE save

{
            date sysdate lop PDT > (f1)   \ after PDT
            date sysdate drop weekday     \ 0=Sat, 1=Sun
            dup 0= swap 1 = or (f1 f2) or \ after PDT or Sat or Sun

            IF "WDATA" SLEEP THEN
}

         ELSE " WDATA: no data from web servers" . nl
         THEN
      ELSE \ client running: 
         FILE file?
         IF FILE asciiload (hT) "wdata" "TREMOTE" bank THEN
      THEN
   end

   inline: wdata ( --- hT) \ get latest data from WEB_FETCH
      [ VOL tpurged "TREMOTE" book ]
    \ If TREMOTE holds any data, it should be returned:
      TREMOTE any? 
      IF (hT)
      ELSE \ WDATA_SERVER always runs here:
         tracklist rows 1st DO tracklist I quote mfetch LOOP
         tracklist rows pilen noblanklines neat (hT)
         these chars 0>
         IF (hT) date swap pile (hT)
            1st those chars COLS min items catch (hT)
         THEN
      THEN
   end

   inline: wdata_closed ( --- ) \ initialize WDATA.FILE to closed data
      [ "WDATA" "FILE" yank "FILE" book ]
      time 600 - intstr \ ten minutes ago
    \ Purge all the places where there could be data:
         VOL tpurged "WEB_FETCH" "TD" bank
         VOL tpurged "WEB_FETCH" "FC" bank
         VOL tpurged "WDATA" "T" bank
         VOL tpurged "wdata" "TREMOTE" bank
    \ Run wdata; it will load data from loadref.latest:
      wdata (hT) 
      pile FILE save 
   end

   inline: WDATA_SERVER ( --- ) \ start server of web data
{     This word starts a daemon server to collect data from the web 
      collection sites by running word WDATA in the multitasker.

      IF a server is already running, this word connects to it and
      makes sure the WDATA task is awake.

      Word WDATA saves the collected data on file name given by
      WDATA.FILE.
}
      [ "PORT dup nextport <> (f)" "PORT_ON" macro
        10 "SEC" book 10 "Hz" book
        no "SERVING" book
        no "PORT" book
        no "STARTED" book
      ]
{     Check the running jobs table to see if WDATA_SERVER was started
      by another program and is currently running. 

      When starting the server, use WAITING and local macro PORT_ON to 
      detect as soon as the server is running.
} 
      pidtable (hT) dup 
    \ Unique string (just WDATA_SERVER is not enough as learned when
    \ there was a pid for a vi session editing file WDATA_SERVER and 
    \ it tripped up this test):
      "dserv1 -source mrc.v WDATA_SERVER -port" grepr any?
      IF (hT hRow) reach "-port" tug 2nd word
       \ If WDATA_SERVER is running, the WDATA task may be asleep.  
       \ Connect to it and wake the WDATA task:
         IF numerate @ (nPORT)
            IPloop swap CLIENT (nSocket) dup -1 >
            IF (nSocket) "'WDATA' WAKE" over remoterun     
               (nSocket) sclose
            ELSE drop
            THEN
         THEN
         return
      ELSE (hT) drop
      THEN

      SEC "WDATA_SERVER" "PORT_ON" localref WAIT_INIT
      9877 nextport "PORT" book

      "dserv1 -source mrc.v WDATA_SERVER -port " PORT intstr + shell 
      yes "STARTED" book \ flag for uclean: this run started server

      Hz "WAITING" RATE
      WAIT_BEGIN \ wait for confirmation that PORT is on
      PORT_ON (f)

    \ Connect to WDATA_SERVER and start it collecting, then disconnect:
      IF IPloop PORT CLIENT "S" book S -1 = 
         IF " WDATA_SERVER: failed to connect to server" ersys return 
         THEN

         "ntrace" S remoterun \ set trace level in WDATA_SERVER log

       \ Tell remote WDATA_SERVER that it is serving:
         "yes 'WDATA_SERVER' 'SERVING' bank" S remoterun

       \ Initialize WDATA.FILE to "closed:"
         "wdata_closed" S remoterun

       \ Start the multitasker on the connected daemon to run word
       \ WDATA and collect data from remote tops sites periodically:  
         host "plunger" = 
         \ IF "1 150 / 'WDATA' PLAY " \ dsl every 2.5 minutes
         IF "1 30 / 'WDATA' PLAY " \ dsl every 30 seconds
         ELSE (default) "1 300 / 'WDATA' PLAY " \ dial up every 5 min
         THEN
       \ and don't wait for the first collect--start it now:
         "WDATA" + (qS) S remoterun
         S sclose

      ELSE " WDATA_SERVER: failed to start server" ersys return
      THEN
   end

   inline: wdata_show ( --- ) \ show latest data from web data server
\     Show data stored in wdata.TREMOTE by the web data server.
      [ VOL tpurged "S" book ] 
      WDATA

      "wdata" "TREMOTE" yank any? 
      IF 2nd those rows 1- items reach (hT) \ remove 1st GMT line
         (hT) 1st those chars COLS min items catch \ trim to window
         (hT) S over 1st quote strchop strmatch 0<>
         IF (hT) dup 1st quote strchop "S" book 
            nl nl nl nl .
         ELSE (hT) drop
         THEN
      THEN
   end

   inline: WEB_FETCH ( --- f) \ latest data into local library
\     Data from web servers into tables TD and FC.  The first line in
\     each table from a web server contains GMT, and the max value is
\     saved here as LAST.
      [ no no blockofblanks "TD" book
        no no blockofblanks "FC" book
        60 "TIMEOUT" book
        "" "LAST1" book
      ]
      "" "LAST" book

      host "fortycoupe" =
      host "topsdog" = or

host "plunger" = or \ testing Jan 23, 2008

      IF mpath "SUMMARYR.DAT" + asciiload chop (hT)
         (hT) dup "TD" book "FC" book
      ELSE
         no "www_here" book 

         www_open not 
         IF WWW \ also starts watchdog
            yes "www_here" book 
         THEN 

         www_open
         IF "HTTPget" "timeout" yank push
            TIMEOUT "HTTPget" "timeout" bank
  
            "http://" fortycoupe.com + "/SUMMARYR.TXT" HTTPget (hT)
            textget asciify "</HEAD>" tear lop chop "FC" book

            "http://" topsdog.com + "/SUMMARYR.TXT" HTTPget (hT)
            textget asciify "</HEAD>" tear lop chop "TD" book

            pull "HTTPget" "timeout" bank

         ELSE " WEB_FETCH: failed to connect to Internet" . nl
            false (f) return
         THEN

         www_here 
         IF pppclose \ close if opened here
            "WWW" "KILL_WATCHDOG" localrun
         THEN 
      THEN

      LAST1 number not IF 0 THEN "t0" book

    \ Latest GMT seconds string into LAST:

      FC any? 
      IF 1st reach numerate any? IF @ ELSE 0 THEN 
      ELSE 0
      THEN (t1) 
    \ If t1 is old, collection server may be down and the site sent
    \ an old file.  Reject FC by purging it (TD may be good):
      (t1) dup t0 < IF (t1) drop 0, VOL tpurged "FC" book THEN (t1)

      TD any? 
      IF 1st reach numerate any? IF @ ELSE 0 THEN 
      ELSE 0
      THEN (t2)
    \ If t2 is old, collection server may be down and the site sent
    \ an old file.  Reject TD by purging it (FC may be good):
      (t2) dup t0 < IF (t2) drop 0, VOL tpurged "TD" book THEN (t2)

      (t1 t2) max (t) dup 0>
      IF (t) intstr "LAST" book
         LAST "LAST1" book
      ELSE \ assume connection to both sites failed, and use
        \ saved LAST GMT:
        (t) drop LAST1 "LAST" book
      THEN

      true (f)
   end

\-----------------------------------------------------------------------

\  Factors for accounting.

   inline: dollars (hC qS --- hD) \ quoted prices to dollars
      factors fac.$F pry *f 0.5 + integer ;

   "fac" "$F D fW" struct \ for items in vector from factors 

   inline: factors (qS --- hF) \ factors for S from Factors matrix
\     In returned column vector F:
\        F(1) = $F = dollar factor
\        F(2) = D = additional factor for price display (word prices)
\        F(3) = fW = scale web price to quoted price (not used)
   [
   {" mkt   $F   D    fW
      W     50   1    1
      C     50   1    1
      S     50   1    1
      SM    100  1    1
      BO    600  1    1

      LC    400  1    1
      LH    400  1    1
      PB    400  1    1

      CC    10   1    1
      KC    375  1    1
      SB    1120 1    1
      JO    150  1    1

      HG    250  1    1
      GC    100  1    1
      PL    50   1    1
      SI    50   1    1

      CT    500  1    1
      CL    1000 1    1
      HO    420  1    1
      HU    420  1    1
      NG    100  1    1

      SF    1250 1    1
      DM    1250 1    1
      EU    1250 1    0.1
      JY    1250 1    1
      MP    500  1    0.1
      BP    625  1    1

      US    1000 1    1
      TN    1000 1    1
      TB    2500 1    0.1
      FF    2500 1    0.1
      ED    2500 1    0.1

      DJ    10   1    1
      SP    250  1    0.1
      NQ    20   1    0.1 (20 $F is mini Nasdaq)
      YX    500  1    1
      NK    500  1    1
      RATIO 1    1    1
   "}
      asciify chop noblanklines
      these one five crop vol2mat bend
      swap numerate these rows three slash matrix
      park yes sort into Factors
   ]
      Factors these rot
      uppercase str2num bsearch
      IF reach bend these rows nit endmost
      ELSE 2drop " name not found" ersys
      THEN
   end

   inline: GAP ( --- nG) \ return gap G for current Name
{     A gap from the table below is returned, to use in computing dif-
      ferences between functions when generating signals.

      Values in this table are as-quoted, and correspond to a vertical
      difference that would be seen between two points in a graph like
      the ones made in mrtim.n.

      The value G returned from this table is scaled to perpetual.

      This word works only if daily data for MKT has already been
      loaded, as when dataget has been run and Name has been created.

      Examples:
         52 for wheat would mean 5 and 2/8 (one-quarter) cents (the 
         value in the table for wheat is 50, meaning simply 5 cents.

         10 for us is 10/32; 100 for us would be 32/32, a full point.

         100 for tn is 10.0/32, 105 for tn would be 10.5/32, or 21/64.
}
      [ {" Table of gaps for MKTs:
          w 50 c 50 s 50 sm 10 bo 10
          lc 25 lh 25 pb 25
          cc 10 kc 20 sb 5 jo 25
          hg 50 gc 50 pl 50 si 50
          ct 50 cl 50 ho 50 hu 50 ng 05
          sf 20 eu 20 jy 20 mp 20 bp 20
          us 4 tn 40
          dj 50 sp 50 nq 150 nk 50
        "} words vol2mat bend dice park yes sort "G" book
      ]
      "Name" main "MKT" book
      G dup MKT lowercase 8 blpad str2num bsearch
      IF reach 2nd pry num2str strchop
      ELSE (hG) drop " GAP: symbol not in table" . nl
         "10" \ return 10 when none is found
      THEN (qG)

    \ Convert gap into perpetual number (since gap is a relative price,
    \ rollover need not be considered):
      (qG) MKT q>n        \ into scaled number
      "scale" main main @ \ into perpetual number
   end

   inline: GOAL ( --- nG) \ return goal percentage G for current Name
{     Returned G is a goal percentage return for Name, the market
      already loaded by word dataget.

      Values in the table are percent; the default is NUM G%.
}

      [ 0.2 "G%" book \ default
        {" Table of goals for MKTs:
          w  G%   c  G%   s  3.0  sm G%   bo G%
          lc G%   lh G%   pb G%
          cc G%   kc G%   sb G%   jo G%
          hg 3.0  gc 2.0  pl G%   si G%
          ct G%   cl 2.0  ho G%   hu G%   ng G%
          sf 1.0  eu 1.0  jy 1.0  mp G%   bp 1.0
          us 1.0  tn 0.5
          dj 3.0  sp 3.0  nq 3.0  nk 3.0
        "} (hT) "G%" G% hand mtext strp (hT)
        (hT) words vol2mat bend dice park yes sort "G" book

      \ Note: to see table G, run this phrase at the ready prompt:
      \    "mrc.v" source "GOAL" "G" yank bend mat2vol . 
      ]
      "Name" main "MKT" book
      G dup MKT lowercase 8 blpad str2num bsearch
      IF reach 2nd pry num2str number drop
      ELSE (hG) drop " GOAL: symbol not in table" . nl
         G% \ return default when none is found
      THEN (qG)
   end

   define: Months ( --- hT)
      [ "F-Jan G-Feb H-Mar J-Apr K-May M-Jun "
        "N-Jul Q-Aug U-Sep V-Oct X-Nov Z-Dec"
        cat words "Months" book
      ] Months ;

   inline: priceformat (hC qName --- hT) \ format a column of prices
\     Incoming C contains unscaled (quoted) prices.
      swap into Y
      (qName) uppercase

      this "W" alike
      that "C" alike or
      that "S" alike or
      IF drop Y 8ths 
      ELSE
         this "US" alike
         that "TN" alike or
         IF drop Y 32nds 
         ELSE 
\           default:
            drop Y "%6.2f" format chop
         THEN
      THEN
      purged is Y
   end

   inline: priceformat1 (hC qName --- hT) \ quoted price to display
\     Incoming C contains unscaled (quoted) prices.
      [ {"
           W 8ths  C 8ths  S 8ths  SM 10ths  BO 100ths
           LC 100ths LH 100ths  PB 100ths
           SB 100ths  KC 100ths  JO 100ths   CC textint
           HG 100ths  SI 10ths  PL 10ths  GC 10ths
           CT 100ths  HO 100ths  CL 100ths  HU 100ths NG 10ths
           SF 100ths BP 100ths DM 100ths JY 100ths MP 100ths+ EU 100ths
           ED 100ths TN 32nds+ TB 100ths FF 100ths US 32nds
           SP 10ths YX 100ths DJ textint NK 100ths NQ 10ths 
           RATIO textint
        "} words vol2mat bend these rows two slash matrix
        yes sort "functions" book
      ]
      uppercase functions those str2num bsearch
      IF lop functions swap two fetch num2str main
      ELSE drop sp . " not found" . drop purged
      THEN
   end

   inline: textfield (hT n --- qS) \ rows of T into S fields of n chars
      nit nit +trailing NULLch tail vol2str ;

   inline: textint (hA --- hT) \ matrix A formatted to integers
      hand "%8.0f" those cols cats format chop ;

\-----------------------------------------------------------------------

{  Scaling functions.

      2score - 40 (every .025)
      32m - 32 (every 1/32 = .03125)
      4bits - 50 (every .02)
      Cen - 100 (every .01)
      Dec - 10 (every .1)
      Oct - 8 (every .125)
      Score - 20 (every .05)
      Unit - 1 (every 1.0)

   Word qdecimal below uses some of these scaling functions to 
   transform quoted to decimal.

   Note that these functions are created with word inline.  That means
   saying their name simply puts their inline on the stack (a PTR type
   stack item).  To run them, word run must then be said.
}
   (n --- qr) "dup 0< swap abs 40 * 0.5 + integer 40 / 100 * 100 /mod,"
              "int$ that int$ rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 66.33 66.83 66.48 66.03 -.03
   "2score" inline

   (qr --- n) "number drop 100 / 40 * 0.5 + integer 40 /"
   \ Typical qr: 6632 6682 6647 6603 -002
   "-2score" inline

   (n --- qr) "dup 0< swap abs 32 * 0.5 + integer 32 /mod,"
              "int$ that int$ rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 120.69 121.47 120.25 121.03 -.03
   "32m" inline

   (qr --- n) "number drop, dup 0< swap abs 100 /mod swap 32 / + swap,"
              "IF negate THEN" pile
   \ Typical qr: 12022 12115 12008 12101 -001
   "-32m" inline

{  Aug 8, 2004: -32m1 is no longer necessary; using new -64m for TN
   (qr --- n) "number drop, 10 / integer " \ take off 10 factor from web
              "dup 0< swap abs 100 /mod swap 32 / + swap," pile
              "IF negate THEN" pile
   \ Typical qr: 120225 121150 120085 121010 -0015
   "-32m1" inline
}
   (n --- qr) "dup 0< swap abs 50 * 0.5 + integer 50 / 100 * 100 /mod,"
              "int$ that int$ rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 161.28 161.08 160.94 161.02  -.02
   "4bits" inline

   (qr --- n) "number drop 100 / 50 * 0.5 + integer 50 /"
   \ Typical qr: 6632 6682 6647 6603 -002
   "-4bits" inline

   (n --- qr) "dup 0< swap abs 320 * 0.5 + integer 320 /mod int$ "
{
    \ A loop for checking 64m and -64m:
      32 0 
      DO 121 I 0.5 + 32 / + 64m run I .i sp dup .      
         -64m run "%8.4f" format sp . nl
      LOOP
}
   "swap int '%03d' format " pile
   "cat swap IF '-' swap cat THEN" pile
   "64m" inline

   (qr --- n) "number drop, dup 0< swap abs 1000 /mod swap "
              "10 / 32 / + swap IF negate THEN" pile
   \ Typical qr: 120225 121155 120080 121015 -0115
   \ For TN having "pseudo" 64ths, that are really 32.5ths
   "-64m" inline

   (n --- qr) "dup 0< swap abs 100 * 0.5 + integer"
              "100 /mod int$ that int$" pile
              "rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 66.53 66.67 66.32 66.40 -.14
   "Cen" inline

   (qr --- n) "number drop 100 /"
   \ Typical qr: 8439 8450 8346 8359 -134
   "-Cen" inline

   (qr --- n) "number drop 1000 / " \ for qr with extra digit
   \ Typical qr: 84395 84505 83460 83595 -1345
   "-Cen1" inline

   (n --- qr) "dup 0< swap abs 10 * 0.5 + integer"
              "10 /mod int$ swap int$" pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 131.00 133.00 131.00 132.80 -1.70
   "Dec" inline

   (qr --- n) "number drop 10 /"
   \ Typical qr: 1324 1335 1306 1309 -86
   "-Dec" inline

   (qr --- n) "number drop 10 / integer 10 /" \ for qr with extra digit
   \ Typical qr: 13245 13350 13065 13090 -865
   "-Dec1" inline

   (n --- qr) "dup 0< swap abs 1000 * 0.5 + integer 1000 /mod int$ "
              "swap int '%03d' format " pile
              "cat swap IF '-' swap cat THEN" pile
   "Mil" inline

   (qr --- n) "number drop 1000 /"
   "-Mil" inline

   (n --- qr) "dup 0< swap abs 8 * 0.5 + integer 8 /mod int$ swap int$,"
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 225.25 227.75 224.50 225.75 -.50
   "Oct" inline

   (qr --- n) "number drop, dup 0< swap abs 10 /mod swap 8 / + swap,"
              "IF negate THEN" pile
   \ Typical qr: 2262 2300 2262 2296 -34
   "-Oct" inline

   (n --- qr) "dup 0< swap abs 20 * 0.5 + integer 20 / 100 * 100 /mod,"
              "int$ that int$ rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 99.50 101.45 98.75 100.05 -.05
   "Score" inline

   (qr --- n) "number drop 100 / 20 * 0.5 + integer 20 /"
   \ Typical qr: 9950 10145 9875 10005 -005
   "-Score" inline

   (n --- qr) "integer int$"
   \ Typical n: 10775. 10910. 10751. 10905. -5.
   "Unit" inline

   (n --- qr) "dup 0< swap abs 8 * 0.5 + integer 8 /mod int$ swap int$,"
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 225.25 227.75 224.50 225.75 -.50
   "Oct" inline

   (qr --- n) "number drop, dup 0< swap abs 10 /mod swap 8 / + swap,"
              "IF negate THEN" pile
   \ Typical qr: 2262 2300 2262 2296 -34
   "-Oct" inline

   (n --- qr) "dup 0< swap abs 20 * 0.5 + integer 20 / 100 * 100 /mod,"
              "int$ that int$ rot 10 < IF '0' swap cat THEN," pile
              "cat swap IF '-' swap cat THEN" pile
   \ Typical n: 99.50 101.45 98.75 100.05 -.05
   "Score" inline

   (qr --- n) "number drop 100 / 20 * 0.5 + integer 20 /"
   \ Typical qr: 9950 10145 9875 10005 -005
   "-Score" inline

   (n --- qr) "integer int$"
   \ Typical n: 10775. 10910. 10751. 10905. -5.
   "Unit" inline

   (qr --- n) "number drop"
   \ Typical qr: 10775 10910 10751 10905 -5
   "-Unit" inline

{  Some words that use the scaling functions (words elsewhere in this 
   file that also do scaling include: Cqs, Cquote, Csq, dprices, prices,
   priceformat, scaled_quoted):
}
   inline: n>q (hA qName --- qA) \ database numbers into quoted numbers
{     Convert database decimal numbers into quoted number strings.

      Note: quoted numbers are generally unsuitable for math operations
      and are usually handled as strings.

      Examples:
         546.25 "w" n>q (5462)

         84.025 "lc" n>q (8402)

         105.921875 "tn" n>q (105295)
}
      priceformat1 words dup rows 1 =
      IF vol2str THEN chop
   end

   inline: q>n (qA qName --- hA) \ quoted numbers into database numbers
{     Convert quoted number strings into decimal numbers like the ones 
      stored in quarterly files such as apr-jun.07.

      Note: quoted numbers are generally unsuitable for math operations
      and are usually handled as strings.

      Examples:
         5462 "%0.0f" format "w" q>n (546.25)

         "8402" "lc" q>n (84.025)

         "105295" "tn" q>n (105.921875)
         "106185" "tn" q>n (106.578125) - "tn" n>q (-0210)
         "210" "tn" q>n 105.921875 + (106.578125)
}
      swap hand swap qdecimal-web dup rows 1 = IF @ THEN
   end

   inline: qdecimal (hT qS --- hA) \ quoted into form in database files
{     For incoming text T of S, containing rows with quoted prices
      like 4962 for 496 and 2-eights--one price per row--compute
      decimal prices A.

      The values returned in A match the scaling of values contained
      in ascii database files like jul-sep.88.

      Example usage (live cattle):
         5402 "%0.0f" format (hT) "lc" qdecimal (54.025)

      Also see qdecimal-web below, that has special scaling for markets
      that add an extra digit.

}     [ {"
           W -Oct  C -Oct  S -Oct  SM -Dec  BO -Cen
           LC -2score  LH -2score  PB -2score
           SB -Cen  KC -Score  JO -Score  CC -Unit
           HG -Score  SI -Dec  PL -Dec  GC -Dec
           CT -Cen  HO -Cen  CL -Cen  HU -Cen  NG -Dec
           SF -Cen  BP -4bits  DM -Cen  JY -Cen  MP -Cen  EU -Cen
           ED -Mil TN -64m TB -Cen FF -Mil US -32m
           SP -Dec YX -Score DJ -Unit NK -Cen NQ -Dec
        "} words vol2mat bend these rows two slash matrix
        yes sort "functions" book
      ]
      uppercase functions that str2num bsearch
      IF lop functions swap two fetch
         num2str "func" book words push
         list: peek rows 1st
            DO peek I quote func main run LOOP
         end pull drop
      ELSE drop sp dot
         " not found"
         dot drop purged
      THEN
   end

   inline: qdecimal-web (hT qS --- hA) \ quoted to decimal
{     For incoming text T of S, containing rows with quoted prices
      like 4962 for 496 and 2-eights--one price per row--compute 
      decimal prices A.  

      The values returned in A match the scaling of values contained
      in ascii database files like jul-sep.88.

      This version of qdecimal has special scaling for certain data
      that carry an extra digit.  Functions used are -Dec1, and -Cen1.

}     [ {"
           W -Oct  C -Oct  S -Oct  SM -Dec  BO -Cen
           LC -2score  LH -2score  PB -2score
           SB -Cen  KC -Score  JO -Score  CC -Unit
           HG -Score  SI -Dec  PL -Dec  GC -Dec
           CT -Cen  HO -Cen  CL -Cen  HU -Cen  NG -Dec
           SF -Cen  BP -4bits  DM -Cen  JY -Cen  MP -Cen1  EU -Cen
           ED -Mil TN -64m TB -Cen1 FF -Mil US -32m
           SP -Dec YX -Score DJ -Unit NK -Cen NQ -Dec
        "} words vol2mat bend these rows two slash matrix 
        yes sort "functions" book
      ] 
      uppercase functions that str2num bsearch
      IF lop functions swap two fetch 
         num2str "func" book words push
         list: peek rows 1st 
            DO peek I quote func main run LOOP 
         end pull drop
      ELSE drop sp dot 
         " not found" 
         dot drop purged
      THEN
   end

   inline: scaled_quoted (hP --- hP1) \ perpetual into scaled-quoted
{     Incoming P must be perpetual, that is, it must have valid step-
      to-step changes (valid changes means changes matching actual 
      data, assuming the change on rollover from the database is for 
      the old contract on the day rollover is performed).

      If incoming P contains the perpetual closes, P1 will match the 
      quoted data after it has been scaled, as contained in
          DATA[*,data.Close]

      Changes between rows of P1 will usually be invalid because of 
      rollover.

      This word requires the entire vector P.  For just one row, use
      word Csq.
}
      dup rows "C" main rows < 
      IF " scaled_quoted: incoming P must be a vector of all prices" 
         . nl return
      THEN
      dup push rows 1st DO peek I pry I Csq @ LOOP
      pull rows listn
   end

   private halt

\-----------------------------------------------------------------------

;  Appendix

   Note: word tracklist is in uboot.v

   Version of tracklist before deletion of tb and addition of ff: 
   _define: tracklist ( --- hT) \ list of items being tracked
\     This list is used by words tracking and webfetch.
      [ {" \ removed dm, 12-26-01
         w c s sm bo
         lc lh pb
         cc kc sb jo
         hg gc pl si
         ct cl ho hu ng
         sf eu jy mp bp
         us tn tb ed
         dj sp nq yx nk
        "} uppercase words makes List

        list:
           1 1 1 1 1 0 \ grain
           1 1 1 0     \ meat
           1 1 1 1 0   \ food
           1 1 1 1 0   \ metal
           1 1 1 1 1 0 \ industry
           1 1 1 1 1 0 \ currency
           1 1 1 1 0   \ bond
           1 1 1 1 1 0 \ stock
        end makes sep \ separations between groups of lines
      ] List ;

  Version before dm removed, 12-26-01:
  _define: tracklist ( --- hT) \ list of items being tracked
\     This list is used by words tracking and webfetch.
      [ {" 
         dj sp nq yx nk
         us tn tb ed
         sf dm eu jy mp bp
         ct cl ho hu ng
         hg gc pl si
         cc kc sb jo
         lc lh pb
         w c s sm bo
        "} uppercase words makes List

        list: 1 1 1 1 1 0    \ stock
              1 1 1 1 0      \ bond
              1 1 1 1 1 1 0  \ currency
              1 1 1 1 1 0    \ industry
              1 1 1 1 0      \ metal
              1 1 1 1 0      \ food
              1 1 1 0        \ meat
              1 1 1 1 1 0    \ grain
        end makes sep \ separations between groups of lines

      ] List ;
