/* File mobius.n  July 2009 

   Copyright (c) 2009-2013   D. R. Williamson

   Market real time model processing and display.

   "I had observed certain facts but had not learned to co-ordinate
   them."  Reference 1, page 91.

   "The purpose of computing is insight, not numbers."  R. W. Hamming.

------------------------------------------------------------------------

   Based upon files (from 2008-2009) mrtim.n, mov.n and movs.n.

   Notes about sessions and 24 hour time are in the Appendix.  They
   were made when thinking about tracking markets for 24 hours was 
   just beginning.  Search for Appendix followed by two spaces.

   Use word psource to source this file: "mobius.n" psource, followed
   by the name of a market:
      [dale@plunger] /home/dale > tops
               Tops 3.2.0
      Thu Oct 21 16:34:11 PDT 2010
      [tops@plunger] ready > "mobius.n" psource eu

------------------------------------------------------------------------

   Contents.

      References
      Appendix
         Definition of a session; time of day
 
------------------------------------------------------------------------

   References

   1. Lefevre, Edwin, "Reminiscences of a Stock Operator," copyright
      1923 by George H. Doran Company, ISBN 0-934380-11-2, published
      by Traders Press, Inc., July 1965 (a novel based upon a series
      of Saturday Evening Post articles published in 1922; see Ref-
      erence 2).

   2. Lefevre, Edwin, "Reminiscences of a Stock Operator," copyright
      2005 by John Wiley & Sons, Inc., ISBN 0-471-67876-7, published
      by John Wiley & Sons, Inc., 2005 (publication of the Saturday 
      Evening Post articles of 1922, with illustrations, upon which 
      Reference 1 was based).

   3. Douglas, Mark, "The Disciplined Trader," copyright 1990 by Mark
      Douglas, ISBN 0-13-215757-8, published by Penguin Putnam, Inc.,
      2005.

   4. Surowiecki, James, "The Wisdom of Crowds," copyright 2004, 2005
      by James Surowiecki, ISBN 0-385-72170-6, published by First
      Anchor Books, 2005.

   5. Taleb, Nassim Nicholas, "Fooled by Randomness," second edition,
      copyright 2004 by Nassim Nicholas Taleb, ISBN 0-8129-7521-9,
      published by Random House, Inc., 2005.

   6. Taleb, Nassim Nicholas, "The Black Swan," copyright 2007 by
      Nassim Nicholas Taleb, ISBN 978-1-4000-6351-2, published by
      Random House, Inc., 2007.

   7. Luenberger, David G., "Introduction to Dynamic Systems," copy-
      right 1979 by John Wiley & Sons, Inc., ISBN 0-471-02594-1, pub-
      lished by John Wiley & Sons.

   8. Braitenberg, Valentino, "Vehicles--Experiments in Synthetic
      Psychology," copyright 1984 by Massachusetts Institute of
      Technology," ISBN 0-262-02208-7, published by Bradford Books.

   9. Williams, Larry R., "How I Made One Million Dollars in the Com-
      modity Market Last Year," copyright 1973 by Conceptual Manage-
      ment, ISBN 73-93795, published by Conceptual Management, Carmel
      Valley, California.

  10. Manzi, Jim, "Uncontrolled," copyright 2012 by Jim Manzi, ISBN
      978-0-465-02324-0, published by Basic Books, Perseus Books Group.

   References 1, 2, 3 and 9 demonstrate that markets have not changed
   even in the new era of electronic trading.  They present ideas that
   have not grown old.

----------------------------------------------------------------------*/

   psource(usrpath+"mobius.n");

/*----------------------------------------------------------------------

   Appendix  
      Definition of a session; time of day
 
   Definition of a session; time of day

   January 2008.

   Times of day mentioned are Chicago (Central) time unless otherwise
   noted.

   What is a session?

   A session is a period in this program with a specific start time and
   a span of 24 hours (actually 23.75 hours to allow fifteen minutes to
   get ready for the next one).

   Periods when markets are open and trading are also called sessions; 
   but to avoid confusion with the program session, that designation 
   is avoided here.  

   Session start in the program was chosen to match the earliest time 
   that any electronic market opens, which is 5:00 PM in Chicago. 

      [Wed Sep 26 09:01:28 PDT 2012.  The "official" opening of stock 
      index markets is before the program's session start on four of
      five days per week.

      On five days a week, Sunday through Thursday, markets for stock
      indices open at 5 PM CT and close at 3:15 PM CT.  Then they open
      for one hour from 3:30 to 4:30 PM CT on four of five days, Monday
      through Thursday.  

      When the program was designed, the quirky one hour period was be-
      lieved to be a period when stock indices were "evened-up" to re-
      flect the stock prices of the index in the trading just closed and
      to ready things for the trading about to start.

      But it was later learned, from CME E-quotes, that the one hour 
      period from 3:30 to 4:30 PM on just four of five days is actually
      called the open for the period that follows at 5 PM.

      Because the earlier opening (it falls before the program's 5 PM CT
      assumption) was overlooked when the program was designed, it just 
      appears as an appendix to the previous program session that ends
      at 4:45 PM.

      A workaround for volume is discussed in function V_make (file 
      mobius.n; look for note Sun Feb 19 10:24:30 PST 2012).

      There is no compelling reason to change the program for this, and
      it is such an oddity that the exchange will probably change it, 
      eliminate it or call it something else.  For example, if it is an
      opening, why doesn't trading on Sunday also open at 3:30 PM, then
      close at 4:30 and open again at 5:00 like it does on the other 
      four days?

      The program's session start remains at 5:00 PM CT.]

   All electronic and pit open and close times (their periods of active
   trading) are defined within the program session timeline that begins 
   at 5:00 PM and lasts for 23.75 hours; see TIMELINES in file mget.v.

   It may be a coincidence that the periods of all electronic markets 
   being followed happen to fit within some 24 hour period that can be 
   called a session.  But with all of 34 markets falling inside a 24 
   hour band that includes their electronic and pit trading hours, this
   looks more like a matter of design.  None of these markets starts
   before 5:00 PM and none ends after 4:15 PM the next day.

   It is important not to confuse the program session start time with 
   the time a market opens for trading.  Many markets, perhaps a third 
   of the ones followed, open at times other than the session start 
   time.  For instance, coffee and sugar electronic trading open 8.5 
   hours after session start (at 01:30 AM the next day), but their trad-
   ing periods from open to close still fit within the period of one 
   program session.  

   In summary, there are many market trading periods, each with an open
   and a close, but there is only one session in this program, and all 
   the market trading periods fall within it.

   How dates of trading periods are defined.

   Dates are used in file names of collected quote data.  By definition,
   quotes coming from electronic and pit markets that are trading simul-
   taneously will have the same date in their file names.

   With this definition, electronic quotes dated on, say, Thursday, 
   January 24, 2008, were running while pit quotes were being received 
   on that same date, and both electronic and pit data file names will 
   have the date January 24, 2008.

   But note that a file with a date name of January 24, 2008 will also 
   contain electronic quotes that are earlier than simultaneous pit 
   quotes since the pit period begins while the electronic one is under-
   way.  These earlier quotes, of course, go back to the time the elec-
   tronic market opened, and that may have been on the previous day, 
   January 23, 2008 (this depends on the market, but is generally true).

   So this needs to be very clear: the program session start, which is 
   at the earliest open of the electronic market periods, was generally
   on the day previous to the date in the file name.  This follows from
   the way file dates are defined above (i.e., dated when electronic and
   pit markets are trading simultaneously) and the fact that the program
   session start is at 5:00 PM, the earliest time any electronic market
   opens.  For electronic markets that open around 5:00 PM, simultaneous
   trading with their pit markets will not occur until the pits open the
   next day.

   This is why on the evening of January 23, 2008 (in the US) one is 
   viewing real time electronic data from a history file of quotes that
   the program has dated tomorrow, January 24, 2008.

   Why grasping the idea of 24 hour market sessions has been difficult.

   Times I am used to revolve around my local time, and everything I 
   (or any of us) do in a single stretch takes less than 24 hours, 
   since there is a big block of sleep time somewhere in there.

   Each day ends when I go to bed, and each begins when I get up.  No 
   task during the day can possibly take 24 hours.

   But now there is, for example, the electronic market for gold fu-
   tures.  To sit through it would be a monumental 23 hour and 15
   minute task, beginning here (in LA) at 3:00 in the afternoon and 
   ending tomorrow afternoon at 2:15.  And at 3:00 tomorrow afternoon, 
   just 45 minutes after it ended, the market would start up again.

   Never have I contemplated such a one-day task.  It obviously would 
   take a super-human, one who can handle all human needs outside of 
   the gold market in just 45 minutes every day (well, there is the 
   "weekend" too, from 2:15 Friday afternoon (LA) until 3:00 on Sunday 
   afternoon).

   The definition of time becomes complicated.  

   With markets opening on one day and closing on the next, and web 
   sites reporting quotes in different time zones, keeping track of 
   when things happen is tricky.  Standard time and daylight saving
   time also must be taken into account.

   Converting different time zones to my time zone does not help be-
   cause of the need to still say if the hour is for today, tomorrow 
   or yesterday.  The day, and not just the hour, becomes important.

   An absolute time scale is very useful here, and fortunately the 
   machine supplies one.  The machine's time uses as a zero reference 
   the number of seconds that have elapsed since January 1, 1970 in 
   Greenwich, England.  

   Greenwich mean time (GMT, also called UTC (coordinated universal 
   time)) is the time at the zero meridian of the earth's longitudes, 
   which falls at Greenwich, England.  

   Any given time is a relative time, but for purposes here the ma-
   chine's time looks absolute.  The machine's current time is simply
   the time at 0:00 (midnight) in Greenwich, England on January 1, 1970
   (whatever time that was relative to the big bang) subtracted from the
   time right now in Greenwich, England, converted to seconds.  Since 
   we all live on the same earth, this same number of elapsed seconds 
   since January 1, 1970 applies to us all--making it absolute for the
   purpose here.

   By converting all quote times (usually given as local Chicago or New
   York, but sometimes local Greenwich or UTC) into machine time, it is
   easy to keep track of the sequence of various market events.  The
   quote collection functions in mget.v make this conversion, and write
   the machine time of each quote to the history files.  (Program time 
   variables with GMT in their names actually are machine times and 
   should not be confused with local GMT or UTC times.)

   A diversion to look into machine time.

   As this is being written, shown below is the machine time along with 
   the date and time we are used to seeing.  It shows that there have 
   been 1,201,381,317 seconds, about 1.2 billion, since January 1, 1970
   to this moment on January 26, 2008 (and not just here in my time zone
   at 13:01:57, but everywhere in the world no matter what the local 
   time is):  

      [tops@plunger] ready > time dup .i nl ctime .
       1201381317
      Sat Jan 26 13:01:57 PST 2008

   A machine time, like 1201381317 seconds, is unique, meaning it will 
   not occur again, so any event that is tagged with it has its time of 
   occurrence uniquely defined (to the nearest second, anyway).

   This shows that when the zero reference time for the machine was
   being defined at midnight in Greenwich, England, here in LA it was 
   only 4:00 PM on December 31, 1969--we were still getting ready to 
   celebrate the New Year:

      [tops@plunger] ready > 0 ctime .
      Wed Dec 31 16:00:00 PST 1969

   Negative machine times are valid too, so we aren't stuck with dates
   after January 1, 1970.  The negative of 1201381317 seconds shows a 
   date in 1931, which must precede the date January 1, 1970 by as much
   as the time to now (when I am writing this) follows it:

      [tops@plunger] ready > -1201381317 ctime .
      Sun Dec  6 18:58:03 PST 1931

   But trouble is brewing.  Machine time is defined in Unix as a 4-byte
   signed integer that will stretch to only so many seconds.  A 4-byte 
   integer has 32 bits, but the sign uses up one bit leaving 31 bits to
   define the number.  This gives numbers between 0 and 2147483647 com-
   puted below as two to the 31st power minus 1 (tops was changed to 
   its infix prompt (>>) to run the infix math expression):

      >> (2^31)-1 .i
       2147483647
      >> 

   With the sign bit set negative, the earliest machine date is in
   December 1901:

      >> -2147483647 ctime .
      Fri Dec 13 12:45:53 PST 1901
      >> 

   With the sign bit set positive, the biggest future date is January 
   18, 2038 at 19:14:07 (in my time zone):

      >> 2147483647 ctime .
      Mon Jan 18 19:14:07 PST 2038

   One second later the machine time and date will turn to garbage and 
   show the following:

      >> 2147483647+1 ctime .
      Fri Dec 13 12:45:52 PST 1901

   The date has wrapped back to the earliest date shown above (minus
   one second) due to the way signed integers work in the machine (a
   method called twos-complement).

   We can safely bet that something will be done about this problem
   before 2038.  

   Simply keeping the 4-byte integer but interpreting it as unsigned 
   instead of signed would add one more bit and allow about 68 more 
   years past 2038 at the expense of not being able to do dates before
   January 1, 1970 (like the negative one shown above that goes back 
   to December 1901).  

----------------------------------------------------------------------*/
