{ File mday.v  March 2000

   Copyright (c) 2000   D. R. Williamson
 
   Run each day
}
\-----------------------------------------------------------------------

   private 1based

   "years" missing IF "mrc.v" source THEN
   year 2 * is 2years

   "updated" missing IF no is updated THEN 

   inline: func (qMKT --- )
      " func: no function for " swap + . nl
   end

   inline: newday ( --- ) \ update this year's binary file with new day
{     Only update this year's binary file if latest quarterly file time
      has changed, meaning it gained another day.

      File newday.lock is used to control updating, so different runs
      are not continually rewriting the binary file for no reason.
}
      [ no "silent" book
        mpath "newday.lock" + "LOCKFILE" book
      ]
      LOCKFILE file?
      IF LOCKFILE asciiload dup 1st quote strchop (hFile) swap
         2nd quote number drop (nTime)
      ELSE "" 0
      THEN (hFile nTime) "QTIME" book "QFILE" book

      date sysdate drop qfilename dup (qFILE) QFILE =
      IF (qFILE) drop
         mpath QFILE + file?
         IF mpath QFILE + filetime (nTIME) QTIME <>
            IF true    \ File time changed, need to update
            ELSE false \ File time unchanged, no update
            THEN
         ELSE 
          \ On the first trading day of the quarter, QFILE will not
          \ be found until the session ends and the end of day update 
          \ has been run.  Do not issue a message.
          \ " newday: file " QFILE + " not found" + . nl 
            false \ no update
         THEN
      ELSE
       \ File name changed (new quarter), need to update
         (qFILE) "QFILE" book true
      THEN (f)

      IF QFILE mpath over + filetime (nTIME) intstr pile LOCKFILE save

       \ Update yearly binary file
         "ycreate" "silent" yank (nf)
         silent "ycreate" "silent" bank

         "years" main one endmost ontop (nYYY)
         (nYYY) ycreate
         yes "'updated' book" main

         (nf) "ycreate" "silent" bank
      THEN
   end
{
   OBSOLETE
   inline: newday ( --- ) \ update this year's file with new day
      [ no "silent" book ]
      "ycreate" "silent" yank (nf)
      silent "ycreate" "silent" bank

      "years" main one endmost ontop (nYYY)
      (nYYY) ycreate 
      yes "'updated' book" main

      (nf) "ycreate" "silent" bank
   end
}
   updated not 
   IF "newday" "silent" yank (nf)
      yes "newday" "silent" bank
      newday 
      (nf) "newday" "silent" bank
   THEN

   define: bo "bo" func ;
   define: bp "bp" func ;
   define: c "c" func ;
   define: cc "cc" func ;
   define: cl "cl" func ;
   define: ct "ct" func ;
   define: dj "dj" func ;
   define: dm " No model for this market" . nl ; \ "dm" func ;
   define: ed " No model for this market" . nl ; \ "ed" func ;
   define: eu "eu" func ;
   define: ff " No model for this market" . nl ; \ "ff" func ;
   define: gc "gc" func ;
   define: hg "hg" func ;
   define: ho "ho" func ;
   define: hu "hu" func ;
   define: jo "jo" func ;
   define: jy "jy" func ;
   define: kc "kc" func ;
   define: lc "lc" func ;
   define: lh "lh" func ;
   define: mp "mp" func ;
   define: ng "ng" func ;
   define: nk "nk" func ;
   define: nq "nq" func ;
   define: pb "pb" func ;
   define: pl "pl" func ;
   define: s "s" func ;
   define: sb "sb" func ;
   define: sf "sf" func ;
   define: si "si" func ;
   define: sm "sm" func ;
   define: spx "sp" func ;
   define: tb " No model for this market" . nl ; \ "tb" func ;
   define: tn "tn" func ;
   define: us "us" func ;
   define: w "w" func ;
   define: yx " No model for this market" . nl ; \ "yx" func ;
{
   inline: func1 (qMKT --- ) func end

   define: bo1 "bo" func1 ;
   define: bp1 "bp" func1 ;
   define: c1 "c" func1 ;
   define: cc1 "cc" func1 ;
   define: cl1 "cl" func1 ;
   define: ct1 "ct" func1 ;
   define: dj1 "dj" func1 ;
   define: dm1 " No model for this market" . nl ; \ "dm" func ;
   define: ed1 " No model for this market" . nl ; \ "ed" func ;
   define: eu1 "eu" func1 ;
   define: ff1 " No model for this market" . nl ; \ "ff" func ;
   define: gc1 "gc" func1 ;
   define: hg1 "hg" func1 ;
   define: ho1 "ho" func1 ;
   define: hu1 "hu" func1 ;
   define: jo1 "jo" func1 ;
   define: jy1 "jy" func1 ;
   define: kc1 "kc" func1 ;
   define: lc1 "lc" func1 ;
   define: lh1 "lh" func1 ;
   define: mp1 "mp" func1 ;
   define: ng1 "ng" func1 ;
   define: nk1 "nk" func1 ;
   define: nq1 "nq" func1 ;
   define: pb1 "pb" func1 ;
   define: pl1 "pl" func1 ;
   define: s1 "s" func1 ;
   define: sb1 "sb" func1 ;
   define: sf1 "sf" func1 ;
   define: si1 "si" func1 ;
   define: sm1 "sm" func1 ;
   define: spx1 "sp" func1 ;
   define: tb1 " No model for this market" . nl ; \ "tb" func ;
   define: tn1 "tn" func1 ;
   define: us1 "us" func1 ;
   define: w1 "w" func1 ;
   define: yx1 " No model for this market" . nl ; \ "yx" func ;
}
\-----------------------------------------------------------------------

   private halt

;  Appendix

\-----------------------------------------------------------------------

   inline: TW ( --- nSocket)
\     Make a text window, running as a server.
      [ 5 "SEC" book, no "TW" book 
      {" \ This deadens the TW server to tracklist words sent to all
         \ localsockets by cluster_run:
         tracklist lowercase 3 +trailing "sp " "spx" replace$
         these rows 1st DO "noop" that I quote inlinex LOOP drop
       \ Other words to deaden:
         "drop" "last" inlinex
         "2drop" "msource" inlinex
         "drop" "source" inlinex
         "noop" "z" inlinex
         "noop" "z0" inlinex
         "noop" "zs" inlinex
         "drop" "zspan" inlinex
         "noop" "zw" inlinex
      "} "DEAD" book
      ]
      TW no =
      IF usrpath "tserv -port " catpath
         def_port nextport dup "PORT" book int$ " &" cat cat
         X11
         IF "-geometry 32x17+543+0" "nodewin" "GEO" bank nodewin
         ELSE nullshell
         THEN

         SEC " Idle " that int$ " seconds while text window starts..."
         cat cat dot idle
         " done" dot nl

         IPloop PORT CLIENT "TW" book

         "no catmsg" DEAD pile
         "'key.v' source" pile 
         TW remoterun one idle

       THEN TW
   end

   inline: TWclose ( --- )
\     Close the text window and server started by word TW.
      "TW" "TW" yank any?
      IF "1 'exit' ALARM" swap remoterun no "TW" "TW" bank THEN
   end

   inline: TWshow ( --- ) \ text window show
      "TW" "TW" yank 0= IF TW drop THEN
      "C" main rows skinny TW remoteput
      "nl clear ." TW remoterun
   end

\-----------------------------------------------------------------------
