{  File cme1.v  November 2011

   Copyright (c) 2011-2013   D. R. Williamson

   Words for fetching data from CME real time E-quotes table.

------------------------------------------------------------------------

   CME E-quotes data is displayed and continuously updated in a window
   on a Windows machine.  File cme.v processed text snapshots of that 
   window to extract delayed prices.

   These E-quotes quotes differ from the ones processed by cme.v be-
   cause they come from an Excel spreadsheet that receives data from 
   the E-quotes window, rather than from a snapshot of text from the 
   E-quotes window itself.

   Taking snapshots of the E-quotes window for cme.v used a Windows
   program called AutoHotkey.  To take a snapshot, the AutoHotkey pro-
   gram had to put the E-quotes window on top of all viewed windows.
   This took focus away from any window that was being viewed or typed
   upon, causing work on the machine to be continually interrupted at
   one minute intervals as focus was lost for another snapshot.

   Purchasing an upgraded monthly subscription to enable Excel spread-
   sheets with CME E-quotes made it possible to develop an Excel macro 
   to periodically write the spreadsheet to a file with no interrup-
   tions of other work being done.

   The only difference with the Excel quotes is that they are all in
   decimal form.  For example, bond quotes have already been formatted
   from 32nds to decimal in the Excel table.

   The Windows machine connects as a client to an NFS (Network File
   System) server on a Linux machine.  A macro in Excel (written in
   VBA (Visual Basic for Applications) for Excel) periodically places
   into the shared NFS directory a text table of the data currently in
   the Excel spreadsheet (and reflecting the current CME E-quotes win-
   dow that is continually updating the Excel spreadsheet).

   NFS allows user programs like the Excel macro on the Windows machine,
   and this one here on a Linux machine, to write and read the shared 
   file as if it resides on either local machine.  In reality, the 
   shared file resides on the Linux machine from the moment it is writ-
   ten, because the Linux machine is acting as the NFS server.

   No file transfer between machines ever takes place in NFS.

   Word nfs_load in word cme_process places the data file on the stack,
   where it is formatted into the standard form for collection output, 
   matching the tables produced by other collector programs like cme.v,
   mfg.v, tch1.v, ino.v and bch.v.

   This file is based upon mfg.v and not cme.v because words in mfg.v 
   have operational improvements made after cme.v was written.  In par-
   ticular, COLLECT runs as a TASK, checking every 2 seconds to see if
   a new file is present.  In cme.v, COLLECT runs on a 60 second ALARM
   with complications to make it run temporarily on a 5 second ALARM 
   when a file is missed.

   The file placed on the Linux NFS server by the Windows NFS client,
   called /nfs/solano/xlequotes.txt, holds a comma delimited text file
   of price data from an Excel spreadsheet that is updated in real time.

------------------------------------------------------------------------

   Changes and notes:

      Fri Mar 21 05:19:17 PDT 2014.  On Thursday it was noticed that
      the collected .bin files, like those for DJ and GC, were about
      double their usual size.  This trend started earlier in the week,
      some time between March 18th and 19th:

         [dale@plunger] /mdat/edat0 > llr 1140318_DJ.bin 1140318_GC.bin
         -rw-rw-rw-  1 dale   comm    45776 Mar 18 14:40 1140318_DJ.bin
         -rw-rw-rw-  1 dale   comm    49196 Mar 18 14:40 1140318_GC.bin

         [dale@plunger] /mdat/edat0 > llr 1140319_DJ.bin 1140319_GC.bin
         -rw-rw-rw-  1 dale   comm    78572 Mar 19 14:40 1140319_DJ.bin
         -rw-rw-rw-  1 dale   comm    94376 Mar 19 14:40 1140319_GC.bin
         [dale@plunger] /mdat/edat0 > 

      To see the numbers in a .bin file, run word binview() as follows:

         ready > "mrc.v" source "mfil.v" source
         ready > "/mdat/edat0/1140319_GC.bin" binview (hT)
         ready > (hT) iview

      Looking at the larger files, it was found that the step between 
      samples was about 35 seconds instead of 60. 

      No code changes in the collector could account for this.  

      On Windows machine solano where CME E-quotes is running, an Excel
      spreadsheet is writing snapshots every 60 seconds.

      To test a theory that two Excel spreasheets were at work, at 22:41
      PDT on 3-20-2014, Excel on solano was shut down, and then restart-
      ed.  Since that time, the sample rate on the .bin files has re-
      turned to about 60 seconds, confirming that two Excel spreadsheets
      had inadvertently been running and rewriting the same file read
      by words in this file.  

      This resulted in more points with different time stamps being 
      picked up by tops_cme running this file.  These are sent to col-
      lection processor topse where the added points reach the .bin
      files it produces.

      The additional points are of little consequence, since the results
      analyzed and displayed are always the nearest data to 180 second
      intervals that fall at exactly 0, 3, 6, 9, ... minutes after the 
      hour.

      Mon Sep  2 05:19:57 PDT 2013.  In cme_process(), test the time 
      of the file from CME E-quotes and do not read one left over from
      the previous session when the Windows machine fails to deliver a
      new one over NFS.

      Fri Jun 14 15:30:17 PDT 2013.  New statements in cme_process() 
      look for the right contract month instead of just taking the 
      first when a market has more than one.  This allows the machine
      to be unattended between sessions on days when the contract rolls
      from one month to another, as long as the new one is also in the
      CME E-quotes display.

      File con.dat lets the program know which month symbol to collect
      (read by word MOdo()); con.dat is set on the previous day during
      end of day processing.

      Tue May 21 11:48:55 PDT 2013.  An unexpected opening range for 
      GCM13 has been handled correctly by the change made Feb 21 (see
      the item directly below).  A snapshot of data for this case is
      shown in the Appendix.

      Thu Feb 21 07:13:38 PST 2013.  No longer can commas be assumed to
      separate single numbers in the data from Excel.  CME E-quotes has
      started putting ranges into the Excel spreadsheet as they always
      have in the graphics window, and word cme_process() has been up-
      dated.

      Wed Jun 27 20:41:24 PDT 2012.  The name of the host receiving
      files from the machine running this file must be built into 
      word HOST().

------------------------------------------------------------------------

   Words

   usrpath "cme1.v" + asciiload this " inline:" grepr reach dot

   Processing data
   inline: BEEP ( --- ) \ error alarm
   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
   inline: cme_process ( --- ) \ process market data from CME E-quotes
   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
   inline: FILE_IN ( --- qFile) \ name of input file
   inline: FILE_LOG ( --- qFile) \ name of log file
   inline: FILE_OUT (qSYM --- qFile) \ name of output file
   inline: FILE_SEND (qFile --- ) \ send file to remote
   inline: HOST ( --- qHost) \ this machine's name
   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
   inline: mrc_close ( --- ) \ close market data resources
   inline: mrc_open ( --- f) \ open market data resources on HOST
   inline: PREVIOUS (qFile --- hPrev) \ all previous collected data
   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name

   Collecting data
   inline: COLLECT ( --- ) \ collect data from NFS client on Windows
   inline: COLLECT_END ( --- ) \ end multitasker word COLLECT
   inline: COLLECT_START ( --- ) \ start multitasker word COLLECT
   inline: START ( --- ) \ depending on time of day, set the start task

   Also see word ALARMcme1 in uboot.v at mytops/usr.

------------------------------------------------------------------------
}
   CATMSG push no catmsg

   "MOdo" missing IF "mrc.v" source fence THEN \ will source mfil.v too

\-----------------------------------------------------------------------

\  Processing data

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
    \ Fri Nov 25 13:11:17 PST 2011

    \ Format bond and note prices and write collection file.

      [ list: 0 0 0 0 0 0 1 1 ; "R" book ]

      "SYM" book "CON" book "TIME" book 
      (hA) numbers (hA)

      (hA) R rake (hP hV) "VOI" book

      (hP) SYM "US" =
      IF (hP) 32nds 
      ELSE (hP) 32nds+
      THEN (hT) "T" book 

      T dup chars 2 + blpad "T" book   \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Sun Jun 17 10:41:14 PDT 2012.  Send all lines of previous file:
      SYM FILE_OUT (qFile) dup file?
      IF (qHEAD qFile) PREVIOUS (qHEAD qPREV) pile ELSE drop THEN
      (hHEAD)

      SYM CON +
      T
      VOI itext \ volume and open interest
      TIME (qTIME)
      4 pilen vol2str neat (qS)

      (hHEAD qS) pile (hT) SYM FILE_OUT save

    \ " BOND: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: cme_process ( --- ) \ process market data from CME E-quotes
{     Wed Sep  7 12:17:38 PDT 2011

      Process data from CME E-quotes Excel spreadsheet, and write files
      in /tmp that match files from the regular collectors, so they will
      be picked up when hist_add() runs to append latest data to each 
      market's history file.

      This word parallels word cache_process() in file tch1.v used as
      a template.  Many other words in this file come from tch1.v with
      few changes.
}
      [ list: \ Market symbols (this program's symbols shown on right):
           6E EU \ Euros
           6S SF \ Swiss Francs
           6J JY \ Japanese Yen
           CL CL \ Crude Oil
           HG HG \ High Grade Copper
           GC GC \ Gold Comex
           YM DJ \ Dow Jones Industrial Average
           ES SP \ Standard and Poors Stock Index
           NQ NQ \ Nasdaq Stock Index
           ZB US \ 30-year Treasury Bonds
           ZN TN \ 10-year Treasury Notes
        end "L" book
{     
      \ Put desired symbols and uncomment this segment for debugging:
        list: \ Market symbols (this program's symbols shown on right):
           6E EU \ Euros
        end "L" book
}
        L words dice (hA1 hA2) "SYM1_TABLE" book (hA1) "SYM_TABLE" book

{       Settle is for the previous session, which is the way it should
        be.  Collections from other sources do not handle Settle cor-
        rectly (probably due to my collectors as opposed to the sites)
        and Settle is usually the same as Last.  This collection will 
        have it right. 

        Fetch the price rows from U (see "rows of U" below) in the 
        order:
           Open, High, Low, Settle, Last, Change, Volume, Open Interest:
}          6     2     3    9       4     5       7       8
        8 listn (hA) ndx "Urake" book

        VOL tpurged "Tsave" book

      \ Lookup table to make AM and PM for Timestamp:
      \  1                          13                      24
      \  AM                         PM
        "12 1 2 3 4 5 6 7 8 9 10 11 12 1 2 3 4 5 6 7 8 9 10 11" words
        "HOURS" book

        "" "TIME" book
      ]
    \ This word runs when newer FILE_IN is detected in COLLECT.
      " cme_process: begin " date + . nl

      FILE_IN any?
      IF 
       \ Mon Sep  2 05:19:57 PDT 2013.  Do not use an old file.  This
       \ prevents reading a previous session file before CME E-quotes
       \ writes one for the current session.
         (qFile) time1 over filetime - (dt) 
         (dt) 2400 > \ older than 40 minutes?
         IF (qFile) -path (qFile)
            " cme_process: " swap + " is too old " + date + . nl
            mrc_close return \ FILE_LOG will not be written
         THEN (qFile)

         (qFile) nfs_load textget (hT) "T" book
         T noblanklines rows 0> not
         IF " cme_process: no data found " date + . nl
            mrc_close return \ FILE_LOG will not be written
         THEN

       \ Tue Dec  6 13:13:21 PST 2011.  Check that the data has changed:
         T Tsave strmatch 0= \ strmatch = 0 if unchanged
         IF " cme_process: file has not changed " date + . nl

          \ Mon Sep  2 12:04:25 PDT 2013.  Markets close early on US 
          \ holidays, and that could be the reason that data stops 
          \ changing.  

          \ Use of an old file is avoided by update Mon Sep  2 05:19:57
          \ PDT 2013 above, so that is not the reason data is not chang-
          \ ing.  Assume markets have closed early, and save the current
          \ time on FILE_LOG so ALARMcme1 will not go off: 

          \ Write the time of processing to the log at FILE_IN.PATH:
            time intstr (nt) FILE_LOG (qFile) save \ time log

            mrc_close return 
         THEN
         T "Tsave" book

      ELSE \ input file not found
         " cme_process: file not found " date + . nl
         mrc_close return \ FILE_LOG will not be written
      THEN

    \ Wed May 15 21:46:08 PDT 2013.  Use an error flag for improved
    \ alarm:
      0 "EFLAG" book \ error flag, 0 if no errors

    \ Within T, here is a typical time string: 1:29:57 PM EST.  Fill 
    \ blanks with underscores, and convert characters to lower case to
    \ avoid conflicts with uppercase market symbols (like ES for S&P
    \ and EST); the time string shown above becomes 1:29:57_pm_est:
      T    " PM " "_pm_" strp
      (hT) " AM " "_am_" strp
      (hT) "CST" "cst" strp
      (hT) "CDT" "cdt" strp
      (hT) "EST" "est" strp
      (hT) "EDT" "edt" strp (hT) 

    \ Replace blank+comma with zero:
      (hT) ", ," ",0," strp (hT)
      (hT) "T" book

    \ Loop over T for each symbol and extract its data:
      SYM_TABLE rows 1st
      DO SYM_TABLE I quote strchop "SYM" book   \ E-quotes symbol
         SYM1_TABLE I quote strchop "SYM1" book \ this program symbol

         T dup 1st 2 items catch SYM grepr any? 
         IF (hT hR) reach dup SYM1 MOdo dup "CON" book grepr any?
            IF (hT hR) @ quote strchop \ one row

{              Thu Feb 21 07:13:38 PST 2013.  When price ranges occur, 
               CME E-quotes is now putting them into the Excel spread-
               sheet, causing this word to fail and skip the collection
               of data in such cases.

               Here is recent HG with a range shown for Open:

                  HGH13
                  3.608
                  3.5415
                  3.5435
                  -0.0645
                  3.5990 - 3.5550
                  55390
                  39065
                  3.608
                  10:05:54_am_est

               The change was noticed at about 7:05 PST after HG data
               had been skipped for about two hours (since 7:06 CST)
               due to improper handling of the new format by this word:

                  HGH13 35625 07:06 CST Thu Feb 21, 2013 \ first failed

               The fix to handle a range was made below and tested on 
               the side while the program continued.  Then the running
               program was updated to replace this word, cme_process.
               After 7:30 PST, collection of HG data was good again:

                  HGH13 35450 09:31 CST Thu Feb 21, 2013 \ good again

               so about 2.5 hours of HG data has been lost.  No data for
               other markets was affected.
}
               (qS) "," NLch strp (qS) \ replace commas in S with NL 

             \ Use textget to fetch rows defined by new lines, then take
             \ just the first word from each row:
               (qS) textget (hT) 1st word drop (hT) "U" book
{
               When SYM = ZN, here are the ten rows of U (with notes 
               added after the backslash).  Note that prices are deci-
               mal, not as-quoted 32nds (they are converted back in 
               word BOND()):

                  ZNZ11          \ Symbol ZN, contract Z11
                  130.6562       \ High
                  130.125        \ Low
                  130.2031       \ Last
                  -0.5156        \ Change
                  130.5937       \ Open
                  597850         \ Volume
                  630363         \ Open Interest
                  130.7187       \ Previous Settle
                  9:01:51_am_cst \ Timestamp
}
{              Mon Jan  2 15:45:03 PST 2012.  The last item, Timestamp, 
               is missing from the Excel spreadsheet if the market is
               not open, and its row will have 9 items instead of 10.  

               Since the program is now running, other markets must be
               open, so for the market with only 9 items add a fake 
               Timestamp that has the current time in Chicago and leave
               the other values alone (thus Volume will remain the same
               as at the end of last session, so dV will be zero as it
               should be for the closed session):
}              U rows 9 =
               IF " cme_process: appending closed session for " SYM + 
                  . nl
                  U (hU)

                \ Make a fake Timestamp to append to U:
                  time dup CHdiff1 + gmtime 4th word drop "OCLOCK" book
                  OCLOCK 1st 2 items catch number drop (nHour)
                  xbase push 1based
                  HOURS over (nHour) 1+ (ndx) quote strchop (qHour)
                  pull indexbase
                  (nHour qHour) OCLOCK ":" tug + strchop (qOCLOCK)
                  swap (nHour) 1+ (ndx) 13 <
                  IF "_am_cst" ELSE "_pm_cst" THEN (qOCLOCK qAM) park

                  (hU qTimeStamp) pile (hU) \ U now has 10 rows
                  (hU) "U" book
               THEN

               U rows 10 < 
               IF " cme_process: insufficient data for " SYM + . nl 
                  false
               ELSE true
               THEN (f)

            ELSE (hT) drop
               " cme_process: no contract for " SYM + CON + . nl false
            THEN (f)

            IF \ Test for Volume>0:
               U 7 ndx quote number (0 or nV -1) \ fetch Volume
               IF (n) 0> 
               ELSE " cme_process: volume is zero for " SYM + . nl false
               THEN (f)
            ELSE false
            THEN (f)

            IF \ Test for valid time string:
               U 10 ndx reach -trailing '""' =
               IF " cme_process: time string is empty for " SYM + 
                  . nl false
               ELSE 
                \ Fri Mar 30 13:53:10 PDT 2012.  Using updated TIME>LA
                \ that returns empty string on error:
                \ Get the time.  Times in the output data are quoted 
                \ as LA:
                  U 10 ndx reach "_" " " strp \ remove underscores
                  TIME>LA (qHH:MM:SS) any? 
                  IF "TIME" book true \ store valid time string
                  ELSE " cme_process: time string is invalid " SYM + 
                     . nl false
                  THEN (f)
               THEN (f)
            ELSE false
            THEN (f)

            IF \ Volume>0 and time string is valid
             \ Fetch the price rows from U in the order 

             \   Open, High, Low, Settle, Last, Change, Volume, Open Int

             \ and take just the first word in any row (this ignores
             \ ranges like HG Open range (see example in cme.v)):
               U Urake reach "DPS" chblank (hT) 
               (hT) 1st word (hT f) drop (hT) 
{
            After fetching price rows in the order of Urake, here is T
            on the stack for the example of ZN above: 

               130.5937 \ Open
               130.6562 \ High
               130.125  \ Low
               130.7187 \ Settle
               130.2031 \ Last
               -0.5156  \ Change
               597850   \ Volume
               630363   \ Open Interest
}
             \ Process this market and write its file:
               (hT) TIME CON SYM SYM1 PROCESS

            ELSE " cme_process: no data in U for " SYM + . nl
               1 "EFLAG" book
            THEN
         ELSE (hT) drop
            " cme_process: no data in T for " SYM + . nl
            2 "EFLAG" book
         THEN
      LOOP

    \ Write the time of processing to the log at FILE_IN.PATH:
      time intstr (nt) FILE_LOG (qFile) save \ time log for ALARMcme1

      mrc_close \ close resources
   end

   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
    \ Fri Nov 25 14:56:17 PST 2011

    \ Apply factor, FAC, to decimal data and write collection file.

      [ list: 0 0 0 0 0 0 1 1 ; "R" book ]

      "SYM" book "FAC" book "CON" book "TIME" book
      (hA) numbers (hA)

      (hA) R rake (hP hV) "VOI" book

      (hP) FAC * "%12.0f" format chop (hT)

      (hT) dup chars 2 + blpad "T" book \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said  \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Sun Jun 17 10:41:14 PDT 2012.  Send all lines of previous file:
      SYM FILE_OUT (qFile) dup file?
      IF (qHEAD qFile) PREVIOUS (qHEAD qPREV) pile ELSE drop THEN
      (hHEAD)

      SYM CON +
      T
      VOI itext \ volume and open interest
      TIME (qTIME)
      4 pilen vol2str neat (qS) 

      (hHEAD qS) pile (hT) SYM FILE_OUT save

    \ " DECIMAL: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: FILE_IN ( --- qFile) \ name of input file
    \ Mon Sep 19 08:17:46 PDT 2011
      [ "/nfs/solano/" "PATH" book 
        "xlequotes.txt" "FILE" book
      \ "xlequotes1.txt" "FILE" book \ when debugging

        PATH FILE + file? not
        IF " FILE_IN: file " FILE + " not found, halting" + . nl
           HALT
        THEN
      ]
      PATH FILE + dup (qFile) file? not
      IF " FILE_IN: file " swap + " not found " + date + . nl
         "" (qFile) \ file not found, return empty string
      THEN (qFile)
   end

   inline: FILE_LOG ( --- qFile) \ name of log file
    \ Mon Sep 19 08:25:05 PDT 2011

    \ This log is read by ALARMcme1 that is running to verify that 
    \ data is continually written.

      [ "FILE_IN" "PATH" yank "cme1_process.log" + "LOG" book ]
      LOG
   end

   inline: FILE_OUT (qSYM --- qFile) \ name of output file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Make PATH_OUT equal to "/tmp1/" during testing; see "testing and 
    \ debugging" below.

      [ "/tmp/" "PATH_OUT" book ]
        PATH_OUT "MKT_CME1.eDAT" + "MKT" rot uppercase strp
   end

   inline: FILE_SEND (qFile --- ) \ send file to remote
    \ Wed Sep  7 15:13:14 PDT 2011

      (qFile) dup -filename "/tmp1/" = 
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN
      
      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book 
      "mrc_open" "S1" yank "S1" book 

    \ Tue Oct 11 06:12:43 PDT 2011.  Word COLLECT runs remoterun1; do
    \ not allow COLLECT to run while remoterun1 is run below:
      "COLLECT" SLEEP \ don't want this to run during remoterun1()

      S -1 >
      IF host HOST <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            FILE FILE S fremoteput (f) 

            (f) dup false =
            IF " FILE_SEND: error sending " FILE + 
               "; see ERRLOG below:" + . nl
               ERRLOG asciiload (hT) 3 indent . nl
            THEN (f)

            ERRLOG deleteif
            SYSOUTsav set_sysout \ back to regular output
            (f)
         ELSE true
         THEN (f)

         IF " FILE_SEND: OK " FILE + " to " + REMOTE + date + . nl
            S1 -1 >
            IF
{              Make a string to run on REMOTE that will add a job to 
               the collector queue that will update the history file 
               with the data just sent.  A typical string to do this 
               is: "eGC-COLLECT" "hist" localref ptr queue_add1 for 
               market symbol GC.

               Word queue_add1 on the remote will add a market's job 
               to the queue if there isn't another one already there.  
               Another job for a market would be one the collector 
               fetched.  When that queued job is run, the file just 
               written will be processed along with the ones made by 
               the collector.

               The collector job on REMOTE is presently on socket S1 
               connected to REMOTE.
}
               "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
               "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

               (hT) depth 1- push \ depth without T

               "remoterun1" "SEC" yank "SECsav" book

               SEC "remoterun1" "SEC" bank [ 10 "SEC" book ]
               (hT) S1 remoterun1 
               SECsav "remoterun1" "SEC" bank

               depth pull > \ has depth increased?
               IF (f)
                  IF " FILE_SEND: " FILE SYM_OUT + 
                     " update queued on " + REMOTE + date + . nl

                  ELSE " FILE_SEND: " FILE SYM_OUT + 
                     " update queue error on " + REMOTE + date + . nl
                     BEEP
                  THEN
               ELSE " FILE_SEND: " FILE SYM_OUT + 
                  " remoterun1 time out " + REMOTE + date + . nl
                  BEEP
               THEN
            THEN

         ELSE " FILE_SEND: error sending " FILE + " to " + 
            REMOTE + date + . nl BEEP
         THEN
      ELSE " FILE_SEND: not connected to " REMOTE + date + 
         . nl BEEP
      THEN 

      "COLLECT" WAKE
   end

   inline: HOST ( --- qHost) \ this machine's name
{     Wed Jun 27 20:37:17 PDT 2012.  The host's name must be built in
      here, and must be for a LAN machine defined in usr/uboot.v,
      like one of these:

        _inline: solano  "192.168.1.100" [ 10000 "p0" book ] ;
        _inline: rugger  "192.168.1.101" [ 10100 "p0" book ] ;
        _inline: riggo   "192.168.1.102" [ 10200 "p0" book ] ;
        _inline: diego   "192.168.1.103" [ 10300 "p0" book ] ;
        _inline: plunger "192.168.1.104" [ 10400 "p0" book ] ;

      Thu Jun 28 22:33:57 PDT 2012.  When this program starts, it clears
      all the old files on HOST.  If HOST is another machine already
      collecting, its collected data will be wiped out.  While rethink-
      ing how to handle this, HOST=host will be enforced.

      Presently, plunger and diego are collectors.  In testing this file
      at 10 PM on plunger, files on diego--collected since 3 PM--were
      wiped out when on plunger this word set HOST=diego (by mistake).

      Part of the rethinking: a machine probably should never write its
      files to another machine that is also collecting.
}
      host collector (f)
      IF host (HOST=host)
      ELSE " HOST: error; current setup requires HOST=host" . nl
         " HOST: halting" . nl HALT
      THEN 
   end

   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
      "mrc_open" "REMOTE" yank "mrc_open" "PORT" yank
      (qIP nPORT) logLAN (f)
      IF mrc_open (f)
      ELSE false
      THEN (f)
   end

   inline: mrc_close ( --- ) \ close market data resources
      "mrc_open" "S" yank sclose
      -1 "mrc_open" "S" bank

      "mrc_open" "S1" yank sclose
      -1 "mrc_open" "S1" bank

      " mrc_close: sockets closed " date + . nl
   end

   inline: mrc_open ( --- f) \ open market data resources on HOST
    \ Mon Sep 19 11:37:05 PDT 2011

      [ host HOST =
        IF IPloop ELSE HOST main (qIP) THEN spaced "REMOTE" book 
        HOST "p0" yank 80 + "PORT" book \ http on HOST

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector topse

        0 "E_PORT" book

        {" topse_port( -- f) \ fetch topse port on the collector machine

           REMOTE PORT CLIENT "S" book \ socket to HTTP server
           "TOPSE_SERVER" S msgPeekSocket (qPort) any?
           IF number (no || nPort yes)
              IF "E_PORT" book true
              ELSE " mrc_open: bad port number from " 
                 REMOTE + date + . nl false 
              THEN
           ELSE " mrc_open: error fetching port from " 
              REMOTE + date + . nl false
           THEN (f)
        "} "topse_port" macro

      \ Collector topse must already be running on the collector ma-
      \ chine when this file is sourced.  Fetch its port now, during
      \ start up, using macro topse_port just created:
        topse_port (f) 
        IF S sclose -1 "S" book
        ELSE " cme1.v: failed to fetch topse port; HALTING" . nl HALT
        THEN
      ]
      sockets sclose \ close any connections (there should be none)

      REMOTE PORT CLIENT "S" book

      S -1 >
      IF host HOST <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            "/mdat/latest.dat" mpath "latest.dat" + S fremoteget (f1)
            "/mdat/con.dat"    mpath "con.dat" + S fremoteget (f2)

            SYSOUTsav set_sysout \ back to regular output
         ELSE true true (f1 f2)
         THEN

         (f1 f2) and
         IF " mrc_open: OK files from " REMOTE + date + . nl

          \ Connect to the collector on REMOTE:
            -1 "S1" book
            E_PORT any?
            IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
               IF true (f)
               ELSE " mrc_open: cannot connect to collector on " 
                  REMOTE + date + . nl 

                \ Maybe topse was restarted and it is on a different
                \ port now.  Force topse_port to run next time:
                  0 "E_PORT" book 

                  false (f)
               THEN
            ELSE " mrc_open: fetching E_port" . nl
               topse_port (f) 
               IF mrc_open (f)
               ELSE BEEP false (f)
               THEN
            THEN
         ELSE " mrc_open: error fetching files from " REMOTE + 
            date + . nl 
            ERRLOG asciiload 2 indent . nl 
            BEEP false (f) 
         THEN
      ELSE " mrc_open: cannot connect to " REMOTE + date + . nl
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

   inline: PREVIOUS (qFile --- hPrev) \ all previous collected data
    \ Sun Jun 17 10:01:20 PDT 2012.  Read previous collected data from
    \ File.
      (qFile) asciiload (qPREV)               \ previous data
      (qPREV) "SESS" "" qreplace noblanklines \ remove old SESS header
      (hPrev)
   end

   inline: PROCESS (hA qTIME qCON qSYM qSYM1 --- ) \ market SYM to file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Incoming SYM is the cme symbol; file created will use the pro-
    \ gram's symbol in SYM1.

      "SYM1" book "SYM" book

      SYM "6E" = IF (hA qTIME qCON) 10000 SYM1 DECIMAL return THEN
      SYM "6S" = IF (hA qTIME qCON) 10000 SYM1 DECIMAL return THEN
      SYM "6J" = IF (hA qTIME qCON) 10000 SYM1 DECIMAL return THEN

      SYM "YM" = IF (hA qTIME qCON) 1  SYM1 DECIMAL return THEN
      SYM "ES" = IF (hA qTIME qCON) 10 SYM1 DECIMAL return THEN
      SYM "NQ" = IF (hA qTIME qCON) 10 SYM1 DECIMAL return THEN

      SYM "ZB" = IF (hA qTIME qCON) SYM1 BOND return THEN
      SYM "ZN" = IF (hA qTIME qCON) SYM1 BOND return THEN

      SYM "CL" = IF (hA qTIME qCON) 100   SYM1 DECIMAL return THEN
      SYM "HG" = IF (hA qTIME qCON) 10000 SYM1 DECIMAL return THEN
      SYM "GC" = IF (hA qTIME qCON) 10    SYM1 DECIMAL return THEN
   end

   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
      (qFile) "FILE_OUT" "PATH_OUT" yank "" strp (qSYM)
      (qSYM) "_CME1.eDAT" "" strp (qSYM)
   end

\-----------------------------------------------------------------------

\  Collecting data

   inline: COLLECT ( --- ) \ collect data from NFS client on Windows
    \ Mon Sep 19 08:19:33 PDT 2011

    \ Perform another collection if FILE is new.

      [ FILE_IN "FILE" book, -1 "FTIME" book ]

      soonest_task (f) \ true if in a collection period
      IF FILE filetime (nt) dup FTIME <>
	 IF (nt) "FTIME" book \ file time has changed

	    logLAN1 (f)       \ open the link to head machine
	    IF cme_process    \ process data and send to head machine

	    ELSE \ connect to LAN failed; try again next time
	       " COLLECT: LAN connection failed " date + . nl
               mrc_close
	    THEN
	 ELSE (nt) drop
	 THEN
      THEN
   end
   
   inline: COLLECT_END ( --- ) \ end multitasker word COLLECT
      [ 60 "LATER" book ]

      "COLLECT" SLEEP

    \ Set an alarm to run COLLECT_START:
      time soonest_start LATER + (sec)
      " COLLECT_END: " date + ", collection begins in " +
      over 60 / 0.5 + integer intstr + " minutes" + . nl
      (sec) "COLLECT_START" ALARM
   end

   inline: COLLECT_START ( --- ) \ start multitasker word COLLECT
    \ Fri Sep 16 14:47:26 PDT 2011
      [ 0 "SOONER" book 
        1 2 / "HZ" book ]

    \ Set an alarm to run COLLECT_END:
      time soonest_end SOONER - (sec)
      " COLLECT_START: collection ends in about "
      over 3600 / 0.5 + integer intstr + " hours" + . nl
      (sec) "COLLECT_END" ALARM

    \ Remove old files:
      " COLLECT_START: removing old *CME1.eDAT files from /tmp" . nl
      "/bin/rm /tmp/*CME1.eDAT" shell

    \ Start word COLLECT running at frequency HZ:
      " COLLECT_START: starting multitasker word COLLECT at " 
      HZ "%3.1f" format + " Hz" + . nl 
      "COLLECT" WAKE
   end
   "COLLECT_START" "HZ" yank "COLLECT" TASK

   inline: START ( --- ) \ depending on time of day, set the start task
      soonest_task (f) IF COLLECT_START ELSE COLLECT_END THEN
{
   Sun Jun 10 14:09:22 PDT 2012.  Don't do this, but keep to show the
   footwork done to sync to 14:50.  Just run NIST_DELTA and bypass the
   need to connect to NIST, since the start-up server is doing that.

      " START: running NIST_SYNC ... " date + . nl
      NIST_SYNC \ sync the program time with NIST

    \ Next time, and every time thereafter, run NIST_SYNC in the lull
    \ between 14:45 and 15:00 (LA) time:
      "14:50:00" "todayat" >stk (n qT) chars 0>
      IF (n) drop "38:50:00" todayat THEN (n) "NIST_SYNC" ALARM
}
      14400 "NIST_DELTA" "SEC" bank
      NIST_DELTA
   end

   pull catmsg

\  For testing and debugging, uncomment the following line:
\  "/tmp1/" "FILE_OUT" "PATH_OUT" bank " WORKING IN TEST MODE" . nl halt

\  Then set SYM_TABLE in cme_process to the market to test, and run
\     "cme1.v" source cme_process halt
\  with HALT placed at various locations to test and find bugs.

\-----------------------------------------------------------------------

   START nl tasks

   private halt

\-----------------------------------------------------------------------

   Appendix

   Tue May 21 11:48:55 PDT 2013.  Below is a case of an opening range
   in GCM13 for which the fix made to cme_process appears to be working
   (see Thu Feb 21 07:13:38 PST 2013).

      Snapshot of /nfs/solano/xlequotes.txt on May 21 11:45 AM PDT:

      Contract,High,Low,Last,Net Change,Open,Volume,Open Interest,Prev. Settlement,Timestamp
      6EM13,1.2936,1.2843,1.2901,0.0002,1.2887,248117,261690,1.2899,1:45:25 PM CDT
      6SM13,1.036,1.0258,1.031,-0.0043,1.035,51535,63924,1.0353,1:44:59 PM CDT
      6JM13,0.9797,0.972,0.9752,-0.0029,0.9778,134517,225828,0.9781,1:45:27 PM CDT
      "","","","","","","","","",""
      CLN13,97.22,95.72,96.11,-0.82,96.89,238904,349787,96.93,2:45:33 PM EDT
      HGN13,3.3815,3.3225,3.3365,-0.0235,3.3575,52862,98165,3.36,2:45:24 PM EDT
      GCM13,1399.9,1358,1372.8,-11.3,1392.4 - 1371.0,204918,186952,1384.1,2:45:33 PM EDT
      "","","","","","","","","",""
      YMM13,15414,15298,15383,64,15315,103822,114646,15319,1:45:34 PM CDT
      ESM13,1673.25,1660,1669.5,5,1663.5,1439000,3146083,1664.5,1:45:34 PM CDT
      NQM13,3036.75,3010,3028.75,7.75,3019.5,157226,411464,3021,1:45:33 PM CDT
      "","","","","","","","","",""
      ZBM13,144.46875,143.25,144.0625,0.3125,143.71875,490552,628586,143.75,1:45:29 PM CDT
      ZNM13,132.09375,131.515625,131.90625,0.09375,131.8125,1511805,2180914,131.8125,1:45:26 PM CDT
      "","","","","","","","","",""
