// for use with gmsh, http://www.geuz.org/gmsh/
//    gmsh  xxx.pos  animate.geo
//
View[0].ShowElement = 1;
View[0].VectorType  = 5;   // displacement

General.Trackball = 1; // Use trackball rotation mode
General.TrackballQuaternion0 =  0.2739769518375397;
General.TrackballQuaternion1 =  0.0172973331063985;
General.TrackballQuaternion2 = -0.5378634929656982;
General.TrackballQuaternion3 =  0.7970815300941467;

nFrames = 12;
nIter   = 1  ;
For iter In {1:nIter}
    For frame In {1:nFrames}
        View.DisplacementFactor = 0.1*Sin(2*Pi*frame/nFrames);
        Draw;
        Print Sprintf("f-%02g.gif", frame + (iter-1)*nFrames);
        Sleep 0.01;
    EndFor
EndFor

// whirlgif -loop 0 -o mode01.gif m1*.gif
