#!../../../src/tops -i
#
#   ./sol101.n -f x2y2.db

model_db   = argv("-f");

(Mgg, Kgg) = fea_assemble(model_db, 0, 0);
Fg         = force_vector(model_db, 0, 0);
Ind_x_set  = apply_spc(model_db, 0, 0);
Kxx        = spflip_sym(submat(Kgg, Ind_x_set, Ind_x_set));
Fx         = submat(Fg, Ind_x_set, 0);  # pull out the first, ie [0]th, column
X          = spfbs(splu(Kxx), Fx);

print_results(model_db, 0, 0, 1, X);
(max_err,col,row) = maxfetch(abs(Kxx*X - Fx));
dot("EPSILON             = ")
max_err . nl
dot("EXTERNAL WORK       = ")
pry(Fx'*X , 0)/2 . nl
