# File xhost_start1.n  December 2005
# Version for topsdog and fortycoupe.

# Copyright (c) 2005   D. R. Williamson

# The tops Xserver runs this file when starting an Xhost node.

# This file requires editing to reflect the machines involved.

# This file should be found on the Xserver machine at usrpath for 
# tops and should be called xhost_start.n, using a symbolic link
# if necessary: 
#    tops/usr/xhost_start.n

#-----------------------------------------------------------------------

# Paths and file names on Xhost node machine:

 TOPS_EXE = "/usr/local/bin/tops"; # tops executable file 
 SYS_PATH = "/usr/local/tops/sys"; # tops syspath
 USR_PATH = "/opt/mytops/usr/";    # tops usrpath
 LOG_PATH = "/tmp/";               # where to put log file
 PATH     = "/tmp/";               # where to put start up script

#-----------------------------------------------------------------------

# The templates below define the following tasks run by Xserver: 
#   - copy a file from Xserver to an Xhost node machine
#   - execute a program file on an Xhost node machine
# A couple of examples are given, but may not represent what is 
# required.

# Command to copy FILE from Xserver to Xhost node machine at PATH:

 COPY = "cp $FILE $PATH";                        # local copy
#COPY = "rcp $FILE localhost.localdomain:$PATH"; # remote copy

# Command for Xserver to execute FILE on Xhost node machine:

 EXEC = "$FILE";                  # local execution 
#EXEC = "rsh 127.0.0.1 -n $FILE"; # remote execution

#-----------------------------------------------------------------------

# Functions XcopyFile() and XexecFile() defined below are used by 
# Xserver with the COPY and EXEC templates.  They enable Xserver to
# copy files to, and run scripts on, the machine of an Xhost node.

# Standalone tests are shown for verifying these functions.

# This region does not require editing.  

<< inline: XcopyFile (qFile qPath --- ) \ Xserver copy File to Xhost 
      "COPY" main "$PATH" rot strrpl "$FILE" rot strrpl shell ; >>

<< inline: XexecFile (qFile --- ) \ Xserver run File on Xhost node 
      "EXEC" main "$FILE" rot (File) strrpl shell ; >>
/*
  Standalone tests for running this file before Xserver does:
    % tops -i
    >> psource(usrpath+"xhost_start.n");          // source this file
    >> XexecFile("/bin/ls");                      // test exec ls
    ... ls output here ...
    >> XcopyFile(usrpath+"tserv","/tmp");         // test copy function
    >> XexecFile("/bin/chmod a+x "+"/tmp/tserv"); // test exec chmod 
    >> ll /tmp/tserv
    -rwxr-xr-x    1 dale         2802 Nov  3 06:45 /tmp/tserv*
    >> XexecFile("/bin/rm /tmp/tserv");           // test exec rm
    >> ll /tmp/tserv                   
    /bin/ls: /tmp/tserv: No such file or directory
    >> exit
    %
#-----------------------------------------------------------------------

Appendix

The infix functions below are equivalent to the postfix versions above,
except that, being infix functions, they clear the stack when they run.
The reason is to enforce C-like behavior, with semicolon being used to 
clear the stack (see discussion in doc/parse.doc).

Postfix operations in low level words use the stack for items that flow 
from word to word.  By blindly clearing the stack, an infix function is
unsuitable in this environment.

In the case of XexecFile(), it is used to run a function that is placing
items from a socket onto the stack as a connection is being established.
Clearing the stack here is bad behavior.

function XcopyFile(FILE, PATH) // Xserver copy FILE to Xhost node
{ shell(strrpl(strrpl(main("COPY"), "$FILE", FILE), "$PATH", PATH)); }

function XexecFile(FILE, PATH) // Xserver run FILE on Xhost node
{ shell(strrpl(strrpl(main("EXEC"), "$FILE", FILE))); }
*/
