{ File fem.v  March 2001

   Copyright (c) 2001   D. R. Williamson

   Concurrent distributed processing

   Distributed iteration-to-convergence

   Computing is distributed within a population of many locally aware 
   words running concurrently under a multitasker.  The multitasker  
   runs each word at a periodic interval, allowing it to calculate, 
   to extract information it needs from local libraries of other words 
   similarly running, and to remove itself from multitasker control 
   when its goals are met.

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   An example of distributed iteration-to-convergence: resolving inter-
   connected data definitions.

   Lines--data cards--in a file of finite element model data that de-
   fines the vectors to joints, and the three dimensional reference 
   frames they are defined within, are interrelated.  Vectors that lo-
   cate joints must refer to reference frames, and some frames can be 
   defined by the vectors to joints, as long as circular dependency is 
   avoided.

   With joint and frame data defined on different cards, it is likely
   during sequential processing that some cards contain references to 
   data on other cards not yet seen.  And because reference frames can 
   be defined within other reference frames, all eventually chaining
   back to the primal frame, defining the transformation matrices for 
   some must wait until those lower in the chain have been defined.

   The words in this file show a very different way to process such in-
   terrelated data using no trees or maps beyond the relationships im-
   plied by the symbols on the original data cards, and without writing
   an overseeing function that controls the gathering of all joint and 
   frame data. 

   Here, each reference frame and joint card is defined as an autono-
   mous word within the structure of the program that runs this file, 
   and all words are played over and over in the controlled environ-
   ment of the program's multitasker.  The program's multitasker is a 
   mechanism that can be set to run any word at a defined interval of
   time.  Words for the multitasker include TASK, WAKE, PLAY, ALARM, 
   RATE, and SLEEP.  

   A multitasker introduces timers--heartbeats and rhythms--and is an
   important element for making a machine that responds to events it 
   detects while running unattended.  These same timers are useful for
   such things as graphics animation, buttons and sliders in a graphi-
   cal user interface, sensing a key pressed rapidly in succession (to 
   denote, for example, one of several characters for the same key in 
   a telephone keypad), and as shown here, an alternate solution to a
   common data processing problem.

   Rather than writing functions or subroutines to compute a solution 
   using an algorithm or procedure, the data cards themselves are made 
   into vehicles in the form of words--effectively, each data card be-
   comes a function or subroutine.  

   All words are set in motion within a dynamic environment where each 
   interacts with others, and each has the goal to complete the link-
   ages defined by the symbols on the card it represents.  For this 
   example of interconnected joint and reference frame definitions, 
   these are the goals:

      - each reference frame word must thread its origin vector and 
        direction cosine matrix back to the primal frame 0

      - each joint word must resolve its location vector to frame 0 

   The effort to implement shifts from writing an algorithm that loops 
   over all frames and joints and eliminates their interdependencies, 
   to writing text that allows these data-words (potentially thousands 
   of them) to be created automatically as each data card is read--using
   one set of standard phrases for each card type--and then writing the
   phrase itself that each word will perform when turned loose.  The 
   simple text run by each word must be robust under the circumstances 
   it might see--for example, gracefully continuing in the event of an 
   error, and always leaving the stack unchanged as promised in the 
   stack diagram--so the entire mechanism continues to run smoothly.

   In general terms, each card becomes a unit or cell operating with 
   specific local goals and surrounded by the activity of others in a 
   changing environment.  Each is launched to run its own set of words 
   from end-to-end, a number of times every second, until it has com-
   pleted the goal of building its internal data structure--items con-
   tained in its local library--and has turned itself off.

   With the data-words set in motion, there is no overseeing function or
   subroutine that is specific to the task at hand; there simply is the
   multitasker that runs the words in its list at their specified fre-
   quencies, oblivious of what any word does.  Each word runs on its own
   (as it would on an unattended machine), side by side with the others
   until its goals are met.  Those that do not reach their goals, due 
   to missing or erroneous information, continue to run smoothly (but 
   with no hope of success) in the background under multitasker control.

   Successful completion of tasks by a word hinges upon other words 
   completing their tasks, so the word can extract the information it
   requires from their local libraries.  Each word runs periodically in
   an orderly manner, reaching out for information and computing every
   time it runs, until its tasks are complete and it turns itself off.

   Specifically in the text below, word GEOM starts the playing of data-
   words for reference frames and joints that will define the geometry 
   in a finite element model.  With no data errors, all data-words stop
   playing after a short time, and having no reference frame or joint 
   words in the multitasker's list of tasks is an indication of success-
   ful completion.

   For a reference frame word, success means the three vectors defining
   its orientation have been resolved back to the primal reference 
   frame--frame 0--and the 3-by-3 rotational transformation matrix for
   its orientation in frame 0 has been computed and is stored in its
   local library.

   For a joint word, success means the vector to its location has been 
   transformed into frame 0 and the vector is stored in its local li-
   brary.  Clearly, a reference frame word must be complete before a
   joint word can fetch from its library the needed rotational trans-
   formation matrix.

   Data-words are run at a rate (about 10 Hz) given to word PLAY when 
   it starts all the words running under the multitasker.  The majority 
   finish after one or two cycles, so processing is complete in a num-
   ber of seconds.

   When all reference frame and joint words have succeeded--all data-
   words are quiet--the next matter is to extract data from their local
   libraries and build a geometry database file of joints and reference
   frames for the finite element model.
}
   "fem.v" is this_file

   "dircos9" missing IF "mmath.v" source THEN
   "JOINT" missing IF this_file "\text" msource THEN

\-----------------------------------------------------------------------

\  High level words.

   inline: GEOM (hText --- ) \ processing reference frames and joints
{     Dependence of type 1 reference frame cards upon joint cards means
      gathered data depends upon the order of cards in Text.  For this
      reason, words REFSYS and JOINT are run twice to fill items missed
      on the first pass.  Then the playing of words for reference frames
      and joints begins.
  
      While playing, the words have the following goals:
         Each reference frame word must thread itself to primal system 
         0, and each joint word must resolve its location vector into 
         rectangular components in the primal axis system.
}
      [ 10 makes 10Hz ]

    \ Creating words:
      (hText) again
      (hText) again REFSYS JOINT 
      (hText) again REFSYS JOINT 

    \ Playing the words listed in Rlist (frames) and Jlist (joints):
      10Hz Rlist Jlist pile PLAY
   end 
   
   private halt

   Some phrases for testing reference frame and joint processing:

      this_file "Case1" msource GEOM \ loads case from Appendix below

      "test.bdf" asciiload GEOM \ loads a file

      "J1" Jdata .
      "R1" Rdata .

\-----------------------------------------------------------------------

   \text

\  General words.

{  These words from mmath.v are used here; they are sourced when this 
   file runs:

      dircos9 (hABC --- hC) create a direction cosine matrix for each
        column of 9-row ABC holding three stacked vectors A, B, C

      xformvec (hOp hRpb hXb type -- hXp) vector Xb components ex-
        pressed in frame b are transformed into components expressed 
        in frame p; component type of incoming 3-by-1 vector Xb is:
           1=rectangular, 2=cylindrical, 3=spherical
}
\  Words use this word to see if something (X) is defined.  X is not
\  defined if it is a number equal to UDEF:

   inline: defined? (X --- 0 | X -1) \ (X -1) if X <> UDEF; else (0)
\     X remains on the stack with a true flag on top if X type <> NUM
\     or if X <> UDEF
      this type NUM = 
      IF its UDEF <> its false = IF lop THEN 
      ELSE true 
      THEN 
   end

\-----------------------------------------------------------------------

\  Words for joints.

\  Word text_joint provides the standard text that every joint word 
\  runs:

   inline: text_joint ( --- hT) \ text each joint word runs
{     The library in each word for a joint contains the following:
         ID - the name of the word

         CP - reference frame for vector X

         X - vector to joint ID in reference frame CP

         X0 - vector to joint ID in reference frame 0

         CD - reference frame for displacements of joint ID
}     [
      {"
      [ defname "ID" book 
      \ Initializing variables to undefined:
        UDEF is CP, UDEF is X, UDEF is X0, UDEF is CD
      ]
      ( --- ) \ This is the text that a joint word runs each cycle:

      X0 defined? IF drop ID (turning self off) -ALARM return THEN

    \ Resolving X to frame 0:
      CP defined? 
      IF (CP) "Op" extract defined?
         IF (hOp)                   \ origin vector in p
            CP "Rpc" extract (hRpc) \ transformation c-to-p
            X (hXc)                 \ location vector in c
            CP "type" extract       \ vector X component type
            (hOpc hRpc hXc type) xformvec (hXp) "X0" book 
         THEN
      THEN
      "} chop noblanklines makes text

      ] text
   end

   inline: Jdata (qID --- hT) \ gather data collected for joint named ID
\     This is a utility to display data after everything has run.
\     Elements of joint data are: CP, X, X0, CD.
      [ "%8.4g" is FORM ]
      Jname this exists?
      IF its "jLIB" book, -Jname (hT)

         jLIB "CP" extract -Rname Rdata 3 indent pile

         jLIB "X" extract defined?
         IF this type MAT =
            IF FORM format vol2str left justify THEN
         ELSE "No X vector defined"
         THEN pile (hT)

         jLIB "X0" extract defined?
         IF this type MAT =
            IF FORM format vol2str left justify THEN
         ELSE "No X0 vector defined"
         THEN pile (hT)

         jLIB "CD" extract -Rname Rdata 3 indent pile

      ELSE -Jname " joint not found" cat hand
      THEN
   end

   inline: Jlist ( --- hT) \ list of joint IDs
      "word_joint" "IDlist" extract ;

   inline: Jname (qIDj --- qLIBj) \ lib name for joint IDj
\     Incoming IDj is the name seen on joint cards.
      [ "J," makes Jword ]
      defined? IF strchop Jword swap cat ELSE "Undefined" THEN ;

   inline: -Jname (qLIBj --- qIDj) \ extract IDj from LIBj
      [ "Jname" "Jword" extract chars negate makes dent ]
      defined? IF dent indent ELSE "Undefined" THEN ;

   inline: joint (qS --- ) \ process words on joint card S
\     The card for a joint called J1 with location vector defined in
\     frame R5 and motions defined in frame R6 might look as follows:
\        joint J1 R5 18.5 -64.0 51.9 R6
      words (hW)
      (hW) this 2nd quote (qID) word_joint (qLIB) push

      (hW) this 3rd quote (CP) word_frame (qCP)
      peek (qLIB) "CP" implant

      (hW) these 4 ndx 3 items reach numerate (hX)
      (hX) peek (qLIB) "X" implant

      (hT) 7 ndx quote (CD) word_frame (qCP)
      (qS) pull (qLIB) "CD" implant
   end

   inline: JOINT (hT --- ) \ all the joint cards into words
      these 1st eight items catch one indent uppercase 
      " JOINT" grepr any?
      IF over swap (hT hRake) reach (hT1) these rows 1st
         DO this I quote (qS) joint LOOP (hT1) drop 
      THEN (hT) drop
   end

   inline: word_joint (qID --- qJname) \ making word for joint ID
\     This word creates a word for the joint named ID.  A list of 
\     words for all joints is kept here in IDlist, and can be 
\     accessed with word Jlist.
      [
        purged mat2vol "IDlist" book 
      ]
      Jname this exists? IF (qJname) return THEN
      text_joint that inlinex
      IDlist that pile onto IDlist (qJname)
   end

\-----------------------------------------------------------------------

\  Words for reference frames.

\  Word text_frame provides the standard text that every reference 
\  frame word runs:

   inline: text_frame ( --- hT) \ text each reference frame word runs
{     The library in each word for a reference frame contains
      the following:
         The name of the word, ID

         Vectors A, B, and C, where: 
            A is a vector to origin, 
            B is a vector to a point on the +Z axis, and 
            C is a vector to a point in the +X+Z plane

         Reference frames Arid, Brid, and Crid in which
            vectors A, B, and C, respectively, are defined

         Reference frame type (1=rectangular, 2=cylindrical,
            3=spherical)

         Transformation matrix Rpc, from frame c to primal

         Vector in primal, Op, from primal origin to c origin
}     [
      {"
      [
        defname "ID" book

      \ Initializing variables to undefined:
        UDEF is A, UDEF is B, UDEF is C
        UDEF is Arid, UDEF is Brid, UDEF is Crid
        UDEF is type 
        UDEF is Rpc
        UDEF is Op 

        "Arid Brid Crid" words "SYS" book
        "A    B    C   " words "VEC" book
        "0    0    0" numbers "DONE" book \ done when all equal 1
      ]

      ( --- ) \ This is the text that a frame word runs each cycle:

      Rpc defined? IF drop ID (turning self off) -ALARM return THEN

    \ Resolving vectors A, B, and C to frame 0:
      three 1st
      DO DONE I pry not
         IF SYS I quote local (frame) defined?
            IF (frame) this -Rname "0" alike
               IF (frame) drop one DONE I poke
               ELSE (frame) this "frame" book
                  (frame) "Op" extract defined?

                  IF (hOp) frame "Rpc" extract (hRpc) 
                     VEC I quote local (hVc)
                     frame "type" extract (type)

                     (hOp hRpc hVc type) xformvec (hVp)

                     (hVp) VEC I quote book

                     "0" Rname SYS I quote book
                  THEN
               THEN
            THEN
         THEN
      LOOP DONE totals ontop three =
      IF A B C pile pile dircos9 "Rpc" book 
         A "Op" book 
      THEN

      "} chop noblanklines makes text

      ] text
   end

   inline: cyl1 (qS --- ) \ process a cylindrical ref1 style frame card
\     The card for a cylindrical frame called R4 defined by primal 
\     vectors to joints J1, J2, and j3 would look as follows:
\        Cyl1 R4 J1 J2 j3
      ref1, "word_frame" "CYL" extract, swap "type" implant ;

   inline: cyl2 (qS --- ) \ process a cylindrical ref2 style frame card
\     The card for a cylindrical frame called R9 with given vectors 
\     defined in rectangular frame C1 might look as follows:
\        CYL2 R9 C1 10 0 0, 0 10 1.2, 100 0 1-3
      ref2, "word_frame" "CYL" extract, swap "type" implant ;

   inline: Rdata (qID --- hT) \ gather data collected for ref frame ID
\     This is a utility to display data after everything has run.
\     Elements of ref frame data are: type, Arid, A, Brid, B, Crid, C.
      [ 
        "Arid Brid Crid" words "SYS" book
        "A    B    C   " words "VEC" book
        "%8.4g" is FORM
      ]
      Rname this exists?
      IF its "rLIB" book, -Rname (hT)

         rLIB "type" extract defined?
         IF " type " swap int$ cat cat THEN

         three 1st 
         DO rLIB SYS I quote extract defined?
            VEC I quote is vec
            IF -Rname (hTA)
               rLIB vec extract defined?
               IF this type MAT = 
                  IF FORM format vol2str THEN
               ELSE vec " vector not defined" cat
               THEN pile (hT1)
            ELSE vec " ref frame not defined" cat (hT1)
            THEN (hT hT1) three indent pile (hT)
         LOOP

         rLIB "Rpc" extract defined?
         IF "Rpc" swap 10-6 filter
            3 fold FORM three cats format pile
            "Origin" rLIB "Op" extract bend FORM three cats format pile
            pile
         ELSE "Rpc not defined" 
         THEN (hT hTC) three indent pile (hT)

      ELSE -Rname " ref frame not found" cat hand
      THEN
   end

   inline: rec1 (qS --- ) \ process a rectangular ref1 style frame card
\     The card for a rectangular frame called R4 defined by primal 
\     vectors to joints J1, J2, and j3 would look as follows:
\        Rec1 R4 J1 J2 j3
      ref1, "word_frame" "REC" extract, swap "type" implant ;

   inline: rec2 (qS --- ) \ process a rectangular ref2 style frame card
\     The card for a rectangular frame called R9 with given vectors 
\     defined in cylindrical frame R1 might look as follows:
\        REC2 R9 R1 0 45 0, 100 22.5 0, 100 67.5 20
      ref2, "word_frame" "REC" extract, swap "type" implant ;

   inline: ref1 (qS --- qLIB) \ make a word for a ref1 style frame card
\     Returned qLIB is the word created for this reference frame. 
      [ 
        "Arid Brid Crid" words "SYS" book
        "A    B    C   " words "VEC" book
        "two plus" "+offset" inlinex
      ]
      words (hW) this 2nd quote (ID) word_frame (qLIB) push
      three 1st 
      DO (hW) this I +offset quote (JA) word_joint (qLIBJ) 
         this (qLIBJ) "CP" extract peek (qLIB) SYS I quote implant
         (qLIBJ) "X" extract peek (qLIB) VEC I quote implant
      LOOP (hW) drop pull (qLIB)
   end

   inline: ref2 (qS --- qLIB) \ make a word for a ref2 style frame card
\     Returned qLIB is the word created for this reference frame. 
      [ 
        "Arid Brid Crid" words "SYS" book
        "A    B    C   " words "VEC" book
        "4    7    10" numbers "FIELD" book
      ]
      words 
      (hW) this 2nd quote (ID) word_frame (qLIB) push
      (hW) this 3rd quote (RID) word_frame (qRLIB) swap

      (qRLIB hW) three 1st
      DO (qRLIB hW) over (qRLIB) peek (qLIB) SYS I quote implant
         (hW) this FIELD I pry ndx 3 items reach numerate (hV) 
         peek VEC I quote implant
      LOOP (qRLIB hW) 2drop pull (qLIB)
   end

   inline: REFSYS (hT --- ) \ all the ref frame cards into words
      [ "REC2 REC1 CYL2 CYL1" words one indent "TYPE" book
        "rec2 rec1 cyl2 cyl1" words "PROC" book
      ] 
      TYPE rows 1st
      DO these 1st eight items catch uppercase one indent
         TYPE I quote notrailing grepr any?

         IF over swap (hT hRake) reach (hT1) these rows 1st
            DO (hT1) this I quote (qS)
               PROC J quote (qS qWord) main 
            LOOP (hT1) drop
         THEN
      LOOP (hT) drop
   end

   inline: Rlist ( --- hT) \ list of ref frame IDs
      "word_frame" "IDlist" extract ;

   inline: Rname (qIDj --- qLIBj) \ lib name for ref frame IDj
\     Incoming IDj is the name seen on ref frame cards.
      [ "R," makes Rword ] 
      defined? IF strchop Rword swap cat ELSE "Undefined" THEN ;

   inline: -Rname (qLIBj --- qIDj) \ extract IDj from LIBj
      [ "Rname" "Rword" extract chars negate makes dent ]
      defined? IF dent indent ELSE "Undefined" THEN ;

   inline: word_frame (qID --- qRname) \ making word for ref frame ID
\     This word creates a word for the reference frame named ID.  A 
\     list of words for all ref frames is kept here in IDlist, and
\     can be accessed with word Rlist.
      [ 
        1 is REC, 2 is CYL, 3 is SPH \ types 
        purged mat2vol "IDlist" book
      ] 
      Rname this exists? IF (qRname) return THEN 
      text_frame that inlinex 
      IDlist that pile onto IDlist (qRname)
   end

\-----------------------------------------------------------------------

   private halt

;  Appendix

   Case1
   {" 
      Each line is a card starting with its name.
      Names of cards are not case sensitive, but names of data items 
      within are.

      REC2 0  0   0 0 0, 0 0 1, 1 0 0

      Rec2 R1 0  10 0 0, 10 0 1, 11 0 0
      rEc2 R2 R1 0 10 0, 0 10 1, 1 10 0
      reC2 R3 R2 0 0 10, 0 0 11, 1 0 10
      rec1 R4 J1 J2 j3

      joInt J1 R1 0 0 0 R4
      joiNt J2 R2 0 0 0 R4
      joinT j3 R3 0 0 0 R4

      $joInt J1 R1 18.5 -64.0 51.9 R4
      $joiNt J2 R2 28.5 -59.0 61.9 R4
      $joinT j3 R3 48.5 -79.0 81.9 R4

   "} left justify notrailing noblanklines 
   halt Case1

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Early version of text in text_frame
      {"
      [ { The library in each word for a reference frame contains
          the following:
             The name of the word, ID
             Vectors A, B, C where A is a vector to origin, B is
                a vector to a point on the +Z axis, and C is a
                vector to a point in the +X+Z plane
             Reference frames Arid, Brid, and Crid in which
                vectors A, B, and C, respectively, are defined
             Reference frame type (rectangular, cylindrical, or
                spherical)
             Transformation matrix Rpc, from c to primal

        } defname "ID" book
      \ Initializing variables to undefined:
        UDEF is A, UDEF is B, UDEF is C
        UDEF is Arid, UDEF is Brid, UDEF is Crid
        UDEF is type, UDEF is Rpc

        "Arid Brid Crid" words "SYS" book
        "A    B    C   " words "VEC" book
        "0    0    0"  numbers "REC" book \ rectangular true
        "0    0    0" numbers "DONE" book
      ]
      ( --- ) \ This is the text that each frame word runs:
      Rpc defined? IF drop ID -ALARM return THEN

    \ Resolving vectors A, B, and C to frame 0:
      three 1st
      DO DONE I pry not
         IF SYS I quote local defined?
            IF (refsys) this -Rname "0" alike
               IF drop one DONE I poke
               ELSE this "refsys" book
                  (refsys) "Rpc" extract defined?
                  IF (hRpc) VEC I quote local (hVc)

                     REC I pry 
                     IF "word_frame" "REC"
                     ELSE true REC I poke, refsys "type"
                     THEN extract (type)

                     (hRpc hVc type) xformvec (hVp)

                     (hVp) VEC I quote book
                     refsys SYS I quote extract
                     SYS I quote book

                  THEN
               THEN
            THEN
         THEN
      LOOP DONE totals ontop three =
      IF A B C pile pile dircos9 "Rpc" book THEN
      "} makes text
      ] text
   end

