\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File vmo.v  January 2001

   Copyright (c) 2001   D. R. Williamson

   Controlling a voice modem.
   Words that use Mgetty and Vgetty for voice modem.

   Using this file requires the Mgetty distribution (which includes 
   vgetty) to have been installed, and this program compiled to use it.

   Sample scripts in usr/voice can be edited to create the 'include' 
   and 'library' files required.  Be sure and read the scripts for any
   changes that need to be made to Mgetty functions beforehand.

   Also see src/vmo.c and tops/Makefile.linux, parameter -DVMO.

   Source for Mgetty download:
      vgetty-maintainer@alphanet.ch

   The November 2002 distribution of Mgetty:
      mgetty1.1.29-Nov25.tar.gz 983945 (bytes)

   Documentation:
      mgetty and vgetty man pages
      http://alpha.greenie.net/mgetty/index.html
      http://www.leo.org/~doering/mgetty/index.html

   Modem type:
      The Mgetty distribution supports a number of modems.  A few 
      places in this file and in file vmo.c contain code specific to 
      the author's modem, ZyXEL U-1496E. 

      The serial device being used for the modem must be declared in
      word REGISTER some time before the word is used.  Here is an
      example of banking /dev/ttyS0 into REGISTER's ttySX variable:

         "ttyS0" "REGISTER" "ttySX" bank

      Word VBITS below needs to have the properties for the raw modem 
      data files that will be played: compression method, sample speed
      (samples/second), and sample size (bits per sample).  (But note 
      that word VBITS may not be required.) 

   Low-level words.  The following low-level words in vmo.c support 
   this file:

      vfprops (hFile --- ) properties of raw modem data (rmd) 
         file
      vmcommand (qC qE --- f) sending command C with expected 
         answer E directly to the voice modem
      vmcompression (comp speed bits --- f) set voice modem 
         compression
      vmdiagnostics ( --- ) run voice modem diagnostic tests
      vmdial (qS --- f) dial the number in string S
      vmevent(int event, event_data data) send the event to 
         the high level event handler, VMEVENT, and expect
         to get a flag back
      vmflow (flow --- f) set modem data flow control
      vmlog (qS --- ) log a message into the voice modem log
         Note: logging level in voice.conf must be 4 or higher
      vmopen(char *device) open a voice modem device
      vmplay (hFile secs --- f) play a raw modem data (rmd) 
         formatted File
      vmrecord (hFile secs comp speed bits --- f) record a raw 
         modem data (rmd) formatted File
      vmregister (qDev --- f) set up logging, read configuration 
         file and open the voice modem device; the file is 
         probably /usr/local/etc/mgetty+sendfax/voice.conf 
      vmstate ( --- n) returns modem state or -1 if no voice 
         device is registered
      vmstop ( --- ) stop the current voice modem action
      vmstruct ( --- ) display elements of voice_modem struct 
         (see mgetty hardware.h)
      vmunregister ( --- ) unregister and close the voice modem 
         device
      vmwatch (n --- ) setting mgetty watchdog timer to n seconds 
         in the future

   Permissions.
      Mgetty registers a voice modem in /var/lock, and writes two log 
      files in /var/log.  These places are off-limits for ordinary
      users.

      One approach to allow non-superusers to run the voice modem is 
      to create a group, say comm, and place users who run the voice
      modem into that group.

      Shown below are the groups and permissions for directories and 
      files accessed by group comm.  These must be set up by a super-
      user.

         [gutter@clacker] / > ll
         drwxr-xr-x   22 root   comm   1024 Mar 10 00:37 var/

         Groups and permissions for lock/ and log/:
         [gutter@clacker] /var > ll
         total 36
         drwxrwxr-x    4 root   comm   1024 Mar 11 18:34 lock/
         drwxr-xr-x   13 root   comm   1024 Mar 11 20:39 log/
         
         Groups and permissions of some of the files in /var/log:
         [gutter@clacker] /var/log > ll
         total 1520
         drwxr-xr-x   13 root   comm   1024 Mar 11 20:39 ./
         drwxr-xr-x   22 root   comm   1024 Mar 10 00:37 ../
         -rw-rw-r--    1 root   comm    660 Mar 11 06:45 mgetty.unknown
         -rw-rw-r--    1 root   comm 489908 Mar 11 18:34 vm.log

         File web.v contains words for connecting a data modem to the
         internet, collecting information from the web, and sending 
         email (words pppconnect, wget, and pppsend).

         Group comm also handles these tasks, and below is an example
         of a similar treatment for files, also in /var/log, that are 
         related:
         -rw-r-----    1 root   comm  24699 Mar 11 15:12 ppp
         -rw-r-----    1 root   comm 239396 Mar 11 20:40 messages
         -rw-rw----    1 root   comm      1 Mar 11 15:13 sendmail

         This shows that group comm is allowed to read the ppp and mes-
         sages files for tasks associated with a data modem, and to 
         write a file when sending mail over the data modem.

         None of these files should be deleted or the permissions will
         be lost, and errors will occur.  The sendmail file shown above
         is simply crushed to a 1-byte file by running the Unix phrase
         'echo>/var/log/sendmail' after the file is sent.
}
\-----------------------------------------------------------------------

   1based private

   "vmregister" missing 
   IF " vmo.v: require compiled words for voice modem" . nl halt THEN

\  Voice and sound for the modem:
   "saying" missing IF "say.v" source THEN
   "record" missing IF "snd.v" source THEN

   "saying" missing "record" missing or IF halt THEN

   %Gutter "saying" "Voice" bank
   GutterHZ "frecord" "HZ" bank

\-----------------------------------------------------------------------

\  General utilities:

   inline: hex (n --- q0xn) \ text pattern of n as a hex number
      int "%x" format ;

   inline: Time ( --- qTime) \ text pattern for the current time
      time ctime 4th word drop ;

\-----------------------------------------------------------------------
{
   Execution states and events.

   Below are the execution states that may be given to event handler,
   VMEVENT.  They match the ones that queries to vmstate will return:
} {"
     -1 UNREGISTERED
      0 DIALING
      1 IDLE
      2 INITIALIZING
      3 OFF_LINE
      4 ON_LINE
      5 PLAYING
      6 RECORDING
      7 WAITING
   "} words noblanklines dice (Nums Names)

\  This hash works both ways--it has Nums as keys and Names as keys:
   (hKeyNum hValName) 2dup these rows "%states" hash_make
   swap (hKeyName hValNum) %states hash_add

{
   Events that may occur within the execution states are shown below 
   (see event.h from mgetty in the Appendix).  These may be given to 
   event handler VMEVENT:
}  {"
       VOICE_MODEM_EVENT        2000
       BONG_TONE                2000
       BUSY_TONE                2001
       CALL_WAITING             2002
       DIAL_TONE                2003
       DATA_CALLING_TONE        2004
       DATA_OR_FAX_DETECTED     2005
       FAX_CALLING_TONE         2006
       HANDSET_ON_HOOK          2007
       HANDSET_OFF_HOOK         2008
       LOOP_BREAK               2009
       LOOP_POLARITY_CHANGE     200a
       NO_ANSWER                200b
       NO_CARRIER               200c
       NO_DIAL_TONE             200d
       NO_VOICE_ENERGY          200e
       RING_DETECTED            200f
       RINGBACK_DETECTED        2010
       RECEIVED_DTMF            2011
       SILENCE_DETECTED         2012
       SIT_TONE                 2013
       TDD_DETECTED             2014
       VOICE_DETECTED           2015

       STOP_PLAYING             3000

       RESET_WATCHDOG           4000
       SIGNAL_SIGCHLD           4001
       SIGNAL_SIGHUP            4002
       SIGNAL_SIGINT            4003
       SIGNAL_SIGPIPE           4004
       SIGNAL_SIGQUIT           4005
       SIGNAL_SIGTERM           4006
       SIGNAL_SIGUSR1           4007
       SIGNAL_SIGUSR2           4008
   "} words noblanklines dice swap
   (hKeyNum hValName) these rows "%events" hash_make
{
   Hashes %states and %events have now been made, along with word hex
   needed to access the hash patterns of %events.  Word VMEVENT uses 
   these hashes.

   Using hash %events.  Given an event number on the stack, here is a 
   phrase that converts it to a hex number pattern (using word hex de-
   fined here), and accesses hash %events to get the name of the event.
  
      Example for event 2001h (8193 decimal):

         8193 (event 2001h) hex %events swap hash_lookup drop dot

      displays the pattern: BUSY_TONE

   The name, if it exists, is the name of the event handler word that 
   will be run by word VMEVENT.  In the example above, word BUSY_TONE
   is the event handler that will be run.

   Using hash %states; it works both ways:  

      What is the name of state number 4?
         %states "4" hash_lookup drop 1st quote (says ON_LINE)

      What is the number for state name IDLE?
         %states "IDLE" hash_lookup drop numerate ontop (gives 1)
}
\-----------------------------------------------------------------------

\  Words that run the voice modem.

   inline: ATTENTION ( --- f) 
      "AT" "OK" vmcommand ;

   inline: VBITS ( --- comp speed bits) \ return modem props
    \ Compression method, speed, and bits/sample for ZyXEL 
    \ U-1494 voice modem:
         [ "02 9600 2" into props ] 
      props local 
   end

   inline: VCONNECT (Num --- f) \ connect to phone number Num
      [ no "VCON" book ]
      no "VCON" book
      vmstate -1 =      IF REGISTER ELSE yes THEN
      IF VOICE      not IF " VOICE error" . nl no return THEN
         255 GAIN   not IF " GAIN error"  . nl no return THEN
         TELCO      not IF " TELCO error" . nl no return THEN
         (Num) DIAL not IF " DIAL error"  . nl no return THEN
      ELSE " VCONNECT: error registering voice device" . nl no return
      THEN yes this "VCON" book
   end

   inline: CONNECTED ( --- f) \ true if phone is connected
      "VCONNECT" "VCON" yank ;

   inline: DATA ( --- f) \ switch modem to data mode
      "AT+FCLASS=0" "OK" vmcommand ;

   inline: DEVOFF ( --- f) \ active device off
      no "VCONNECT" "VCON" bank     \ not connected
      "AT+VLS=0" "OK" vmcommand (f) \ deactivate the device
      DATA (f) and ;                \ return to data mode

   inline: DIAL (n --- f) \ dial number n
      vmdial (f) ;

   inline: ECHO (qRMD --- ) \ echo back file RMD
      [ "_bin" "tmppath" yank runid cat ".you_said" cat makes S1
        "laugh_ ... you said ... " he_say record wavFile S1 fcopy
      ]
      S1 wav>rmd VMPLAY (f) drop
      (qRMD) VMPLAY (f) drop
   end

   inline: FLOW (n --- f) \ flow command
      vmflow ; \ n: 0,1=software, 2=hardware

   inline: GAIN (n --- f) \ gain in play mode (0-255, 192 default)
      "AT+VGT=" swap 0 max 255 min suffix "OK" vmcommand 
   end

   inline: HANGUP ( --- ) \ active device off
      DEVOFF drop 
   end

   inline: INIT_VOICE ( --- ) \ initialize flags
      "LISTEN" "INIT" localrun
   end

   inline: LISTEN ( --- ) \ listen to and respond to live voice on phone
      [ 
        "_bin" "tmppath" yank runid cat ".hello_listen" cat makes Greet
        "Hello this is Gutter ..." he_say record wavFile Greet fcopy

        "_bin" "tmppath" yank runid cat ".you_there1" cat makes F1
        "_bin" "tmppath" yank runid cat ".you_there2" cat makes F2
        "Hello. ... Are you there" he_say record wavFile F1 fcopy
        "Hello. ... Hello, where are you" he_say record wavFile F2 fcopy
        "F1 F2" words "You" book

        "_bin" "tmppath" yank runid cat ".sorry_listen" cat makes Sorry
        "Sorry you are having trouble ... ... ... good bye ..."
        he_say record wavFile Sorry fcopy

        "_bin" "tmppath" yank runid cat ".heard_listen" cat makes HEARD
        HEARD deleteif

        %states "IDLE" hash_lookup drop 
        numerate ontop "IDLE" book

        %states "UNREGISTERED" hash_lookup drop 
        numerate ontop "UNREG" book

        {"
           no "NO_ENERGY" book
           no "SAY"       book
           no "SOUND"     book
           no "TARGET"    book
        "} "INIT" inlinex

        INIT

        2 "SAY_MAX" book
        3 "NO_ENERGY_MAX" book

        10 (sec) "delay" book

        "ECHO" ptr "ANSWER" book
      ]
      CONNECTED not
      IF vmstate UNREG = IF return THEN
         vmstate IDLE <> IF vmunregister THEN return 
      THEN

      SOUND
      IF HEARD file?

         IF HEARD ANSWER exe? drop THEN
         HEARD deleteif

         no "SAY" book
         no "SOUND" book
         time delay plus "TARGET" book
      ELSE
         TARGET no =
         IF Greet wav>rmd VMPLAY (f) drop
            time delay plus "TARGET" book

         ELSE
            time TARGET >
            IF NO_ENERGY NO_ENERGY_MAX < SAY SAY_MAX < or

               IF You 1 those rows 1 1 ranint ontop ndx quote local
                  (qWav) wav>rmd VMPLAY (f) drop

                  time delay plus "TARGET" book
                  SAY tic "SAY" book

               ELSE Sorry wav>rmd VMPLAY (f) drop HANGUP return

               THEN

            THEN

         THEN
      THEN

\     Listen and record:
      HEARD deleteif 
      HEARD RECORD not 
      IF HEARD deleteif HANGUP THEN

   end
   1 2 / "LISTEN" PLAY

   inline: MIC ( --- f) \ activate device: external microphone
      "AT+VLS=8" "VCON" vmcommand ;

   inline: PHONE_PLAY (qFile Num --- ) \ call Num and play rmd File
      (Num) VCONNECT (f) 

      IF Time sp dot " PHONE_PLAY begin" . nl

         (qFile) VMPLAY (f)

         IF HANGUP 
         ELSE " PHONE_PLAY: error playing file" ersys
         THEN
         Time sp dot " PHONE_PLAY end" . nl
      ELSE " PHONE_PLAY: error connecting" ersys 
      THEN
   end

   inline: playtime (hFile --- secs) \ time to play rmd File
      file.size pry VBITS (comp speed bits) * 8 / lop / tic integer ;

   inline: RECORD (qFile --- f) \ record file from party on phone
      [ 12 is n ]
\     Mgetty RESET_WATCHDOG runs every n/2 seconds while recording.
\     Mgetty seems to ignore values of n/2 greater than 6, and uses 6.

      [ no "rmd" book ]
      rmd filetrue IF rmd fclose THEN

      (qFile) forn binary "rmd" file
      rmd n VBITS vmrecord (f)
      rmd fclose
      (f)
   end

   inline: REGISTER ( --- f) \ the voice modem serial device
\     Registering a voice modem requires superuser or special group
\     permissions in /var/lock to delete this file:
      "/bin/rm -f /var/lock/LCK*" shell

      [ "" "ttySX" book ]
      ttySX vmregister (f)
      DEVOFF (f) and
   end

\  Serial device name ttySX must be banked into word REGISTER.  Here 
\  is a case of machines with different serial ports using this file.
\  Machine clacker gets ttyS1, everyone else gets ttyS0.
      "clacker" host alike IF "ttyS1" ELSE "ttyS0" THEN
      "REGISTER" "ttySX" bank

   inline: SPCONN ( --- f) \ connect to voice modem internal speaker
\     This is for the speaker built into the modem, not an external 
\     speaker connected to a sound card.
      vmstate -1 =    IF REGISTER ELSE yes THEN
      IF VOICE    not IF " VOICE error" . nl no return THEN
         255 GAIN not IF " GAIN error"  . nl no return THEN
         SPEAKER  not IF " SPEAKER error" . nl no return THEN
      ELSE " SPCONN: error registering voice device" . nl no return
      THEN yes
   end

   inline: SPEAKER ( --- f) \ activate device: vm internal speaker
      "AT+VLS=16" "VCON" vmcommand ;

   inline: SPEAKER_PLAY (qFile --- ) \ play rmd File over speaker
      SPCONN (f)

      IF Time sp dot " SPEAKER_PLAY begin" . nl

         (qFile) VMPLAY (f) not 

         IF " SPEAKER_PLAY: error playing file" ersys THEN
         Time sp dot " SPEAKER_PLAY end" . nl

      ELSE " SPEAKER_PLAY: error connecting voice device" ersys 
      THEN
   end

   inline: TELCO ( --- f) \ activate device: telephone line
      "AT+VLS=2" "VCON" vmcommand ;

   inline: TELL (qMessage --- ) \ tell listener what is happening
      [ "no energy" "NO_ENERGY" book
        "silence"   "SILENCE"   book
        "dial tone" "DIAL_TONE" book
        "busy tone" "BUSY_TONE" book
      ]
      this NO_ENERGY alike \ recording ended with never any talking
      IF "LISTEN" "NO_ENERGY" yank (n)
         (n) tic "LISTEN" "NO_ENERGY" bank
         no "LISTEN" "SOUND" bank (qMessage) drop return
      THEN

      this SILENCE alike \ recording ended when talking stopped
      IF no "LISTEN" "NO_ENERGY" bank \ zero-out the no-energy count
         yes "LISTEN" "SOUND" bank (qMessage) drop return
      THEN

      this BUSY_TONE alike that DIAL_TONE alike or
      IF HANGUP (qMessage) drop return
      THEN

      (qMessage) drop
   end

   inline: VERBOSE ( --- f) \ output flag
      [ no is V ] V ;

   inline: VERBOSE_SET (f ---  ) \ set verbose event output flag
      (f) "VERBOSE" "V" bank ;

   inline: VMEVENT (hData state event -- f) \ find and run an event word
{     This word is run by low level function vmevent() in vmo.c.  Its
      job is to find an event word in this file and run it, or return 
      a 'no' flag to vmevent() and let Mgetty handle the event.

      Word handler provides the name of a handler for the event, or an 
      empty quote if there is none.

      Event words, such as BUSY_TONE, have the following stack diagram:
         BUSY_TONE (hData state --- f) \ event handler

      The structure of Data, which is mgetty struct event_data, is 
      shown in the Appendix (from mgetty event.h).  Its contents vary
      with event.

      Examples of Mgetty handlers are in these Mgetty files:
         mgetty/mgetty-1.1.29/voice/vgetty/event.c
         mgetty/mgetty-1.1.29/voice/vm/event.c
} 
      (event) its handler (handler_name) any?
      IF (event) lop (handler_name) this exists?
         IF (hData state handler_name) main (f)
         ELSE (hData state handler_name)
            Time . sp "VMEVENT passed on: " . (qS) .
            ", modem state: " . (state) handler_state .
            (hData) drop
            nl fPASS (f)
         THEN (f)
      ELSE (hData state event)
         Time . sp "VMEVENT not in hash: " . (event) .
         ", modem state: " . (state) handler_state .
         (hData) drop
         nl fPASS (f)
      THEN (f)
   end

   inline: VMPLAY (qFile --- f) \ play file
      [ 12 is n ]
{     Mgetty RESET_WATCHDOG runs every n/2 seconds while playing.
      Values of n/2 greater than 6 seem to be ignored by Mgetty, and
      6 is used.

      Function vmplay(), called by this word, determines the bits/samp
      and samp/sec from the header of qFile.
}
      [ no "rmd" book ]
      rmd filetrue IF rmd fclose THEN

      (qFile) dup file? not
      IF " VMPLAY: file not found: " . ersys return THEN

      (qFile) old binary "rmd" file
      rmd n vmplay (f)
      rmd fclose
      (f)
   end

   inline: VOICE ( --- f) \ switch modem to voice mode
      INIT_VOICE
      "AT+FCLASS=8" "OK" vmcommand ;

   inline: WATCH (secs --- ) \ set watch dog timer for secs
      [ no is secs ]
      again 'secs' book, vmwatch ;

   inline: WATCH_OFF ( --- ) \ turn watch dog timer off
      86400 WATCH ;

\-----------------------------------------------------------------------

\  Event handlers.

\  Flags returned by event handlers:
     "yes" "fDONE" inlinex       \ event has been handled
     "no"  "fPASS" inlinex       \ pass on to the Mgetty event handler
     "one" "fSTOP" inlinex       \ stop current action
     "two" "fSTOP_PLAY" inlinex  \ stop playing
     "three" "fSTOP_REC" inlinex \ stop recording

   inline: handler (n --- qName) \ handler name for event n
      (n) hex %events swap hash_lookup drop any? 
      IF 1st quote ELSE "" THEN ;

   inline: handler_state (n --- qName) \ name of state n
      (n) %states swap int$ hash_lookup drop any?
      IF 1st quote ELSE "" THEN ;

   inline: BUSY_TONE (hData state --- f) \ event handler
      [ "Event handler: " defname cat is Msg ]
      VERBOSE 
      IF Time . sp Msg . ", state: " . (s) handler_state . nl 
      THEN  
      (hData) drop

      "busy tone" TELL
      fDONE               \ tell Mgetty this was handled
   end

   inline: DATA_OR_FAX_DETECTED (hData state --- f) \ event handler
      [ "Event handler: " defname cat is Msg
        5 "PLAYING" book
      ]
      "state" book
      VERBOSE
      IF Time . sp Msg . ", state: " . state handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      state PLAYING = 
      IF fSTOP_PLAY 
      ELSE fPASS
      THEN
   end

   inline: DIAL_TONE (hData n --- f) \ event handler
      [ "Event handler: " defname cat is Msg ]
      "n" book
      VERBOSE
      IF Time . sp Msg . ", state: " . n handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      "dial tone" TELL
      HANGUP
      fPASS
   end

   inline: NO_VOICE_ENERGY (hData n --- f) \ event handler
      [ "Event handler: " defname cat is Msg
        6 "RECORDING" book
      ]
      "n" book
      VERBOSE
      IF Time . sp Msg . ", state: " . n handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      n RECORDING = 
      IF "no energy" TELL
         fSTOP_REC 
      ELSE
         fPASS
      THEN (f)
   end

   inline: RECEIVED_DTMF (hData state --- f) \ event handler
      [ "Event handler: " defname cat is Msg ]
      VERBOSE
      IF Time . sp Msg . ", state: " . handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      fPASS
   end

   inline: RESET_WATCHDOG (hData state --- f) \ event handler
      [ "Event handler: " defname cat is Msg
        5 "PLAYING" book, no is reset
      ]
      "state" book
      VERBOSE
         IF Time . sp Msg . ", state: " . state handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
{
      state PLAYING = reset not and
      IF yes is reset 1 WATCH THEN
}
      fPASS
   end

   inline: SIGNAL_SIGCHLD (hData n --- f) \ event handler
      [ "Event handler: " defname cat is Msg ]
      "n" book
      VERBOSE
      IF Time . sp Msg . ", state: " . n handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      fPASS
   end

   inline: SILENCE_DETECTED (hData n --- f) \ event handler
      [ "Event handler: " defname cat is Msg
        6 "RECORDING" book
      ]
      "n" book
      VERBOSE
      IF Time . sp Msg . ", state: " . n handler_state . nl
         (hData) .hex nl
      ELSE (hData) drop
      THEN
      n RECORDING = 
      IF "silence" TELL
         fSTOP_REC 
      ELSE
         fPASS
      THEN (f)
   end

   private halt

\-----------------------------------------------------------------------

;  Appendix

These are the events defined in mgetty event.h.  Events from the voice 
modem and signal events (0x2XXX and 0x4XXX), may be seen by the event 
handler word, VMEVENT.

/*
 * voice_event.h
 *
 * Defines the event_data structure for information exchange between
 * the hardware specific parts and the generic code.
 *
 */

/*
 * Dummy empty event.
 */

#define NO_EVENT                 (0x0000)

/*
 * Possible event messages for the voice modem
 */

#define VOICE_CODE_EVENT         (0x1000)
#define VOICE_ANSWER_PHONE       (0x1000)
#define VOICE_BEEP               (0x1001)
#define VOICE_DIAL               (0x1002)
#define VOICE_HANDLE_DLE         (0x1003)
#define VOICE_INIT               (0x1004)
#define VOICE_MESSAGE_LIGHT_ON   (0x1005)
#define VOICE_MESSAGE_LIGHT_OFF  (0x1006)
#define VOICE_MODE_OFF           (0x1007)
#define VOICE_MODE_ON            (0x1008)
#define VOICE_PLAY_FILE          (0x1009)
#define VOICE_RECORD_FILE        (0x100a)
#define VOICE_SET_COMPRESSION    (0x100b)
#define VOICE_SET_DEVICE         (0x100c)
#define VOICE_STOP_DIALING       (0x100d)
#define VOICE_STOP_PLAYING       (0x100e)
#define VOICE_STOP_RECORDING     (0x100f)
#define VOICE_STOP_WAITING       (0x1010)
#define VOICE_SWITCH_TO_DATA_FAX (0x1011)
#define VOICE_WAIT               (0x1012)

/*
 * Possible event messages from the voice modem
 */

#define VOICE_MODEM_EVENT        (0x2000)
#define BONG_TONE                (0x2000)
#define BUSY_TONE                (0x2001)
#define CALL_WAITING             (0x2002)
#define DIAL_TONE                (0x2003)
#define DATA_CALLING_TONE        (0x2004)
#define DATA_OR_FAX_DETECTED     (0x2005)
#define FAX_CALLING_TONE         (0x2006)
#define HANDSET_ON_HOOK          (0x2007)
#define HANDSET_OFF_HOOK         (0x2008)
#define LOOP_BREAK               (0x2009)
#define LOOP_POLARITY_CHANGE     (0x200a)
#define NO_ANSWER                (0x200b)
#define NO_CARRIER               (0x200c)
#define NO_DIAL_TONE             (0x200d)
#define NO_VOICE_ENERGY          (0x200e)
#define RING_DETECTED            (0x200f)
#define RINGBACK_DETECTED        (0x2010)
#define RECEIVED_DTMF            (0x2011)
#define SILENCE_DETECTED         (0x2012)
#define SIT_TONE                 (0x2013)
#define TDD_DETECTED             (0x2014)
#define VOICE_DETECTED           (0x2015)

/*
 * Possible signal events
 */

#define SIGNAL_EVENT             (0x4000)
#define RESET_WATCHDOG           (0x4000)
#define SIGNAL_SIGCHLD           (0x4001)
#define SIGNAL_SIGHUP            (0x4002)
#define SIGNAL_SIGINT            (0x4003)
#define SIGNAL_SIGPIPE           (0x4004)
#define SIGNAL_SIGQUIT           (0x4005)
#define SIGNAL_SIGTERM           (0x4006)
#define SIGNAL_SIGUSR1           (0x4007)
#define SIGNAL_SIGUSR2           (0x4008)

/*
 * Event data structures
 */

typedef union
     {
     char c;
     int i;
     void *p;

     struct
          {
          int frequency;
          int length;
          } beep;

     } event_data;

typedef struct
     {
     int event;
     event_data data;
     } event_type;

/*
 * Event handling functions
 */

extern event_type* create_event(int event);
extern void clear_event(event_type* event);
extern int queue_event(event_type* event);
extern event_type* unqueue_event(void);
extern int voice_install_signal_handler(void);
extern int voice_restore_signal_handler(void);

\-----------------------------------------------------------------------

Here is what goes on when there is a SIGTERM.  Shows shutting down
the modem:
01/28 13:00:42    vm: Got terminate signal
01/28 13:00:42    vm: queued event SIGNAL_SIGTERM at position 0010
01/28 13:00:42    vm: unqueued event SIGNAL_SIGTERM at position 0010
01/28 13:00:42    vm: voice_handle_event got event SIGNAL_SIGTERM with data <(>
01/28 13:00:42  vmevent: got RECORDING event 4006
01/28 13:00:42  vm: Received signal to terminate
01/28 13:00:42    vm: <STOP RECORDING>
01/28 13:00:42    vm: AT+VLS=0
01/28 13:00:42   voice command: '' -> 'AT+VLS=0|OK'
01/28 13:00:42    ZyXEL 1496: 
01/28 13:00:53  vm: timeout while reading character from voice modem
01/28 13:00:53   voice command: 'AT+VNH=0' -> 'OK'
01/28 13:00:53    vm: AT+VNH=0
01/28 13:00:53    ZyXEL 1496: 
01/28 13:01:04  vm: timeout while reading character from voice modem
01/28 13:01:04   vm: leaving voice mode
01/28 13:01:04   voice command: 'AT+FCLASS=0' -> 'OK'
01/28 13:01:04    vm: AT+FCLASS=0
01/28 13:01:04    ZyXEL 1496: OK
01/28 13:01:04   voice command: 'AT' -> 'OK'
01/28 13:01:04    vm: AT
01/28 13:01:04    ZyXEL 1496: OK
01/28 13:01:04   vm: Restoring signal handlers
01/28 13:01:04  closing voice modem device
01/28 13:01:04   removing lock file

\-----------------------------------------------------------------------
 
   Obsolete

  _inline: VMEVENTx (hData state event --- f)
\     This word is run by low level function vmevent() in vmo.c.
\     It works just like the initial low level event handler in vmo.c,
\     a first step in pulling the event handler up here.

      [ "(n --- ) ints '%x' format ." ".h" inlinex ]

      "event" book, "state" book "D" book
      " Event handler: event " . event .h 
      ", modem state: " . state .u nl no
   end

  _define: timing ( --- )
       " timing .............." . nl ;

  _define: ts "timing" SLEEP ;

   1 20 / "timing" TASK

  _define: vmalarm ( --- ) \ start alarm
      alarmoff, 
      "vmalarm: restarting modem" vmlog, \ vmunregister REGISTER
      "vmalarm: restarting modem" . nl  \ vmunregister REGISTER
   end


