/* {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
*/

/* File sys/uboot.n  July 2006

   Infix words to parse and source at start up.  

   This file is sourced by sys/uboot.v. 

   Parsing takes time.  A file taking 5 or 10 seconds to parse before 
   it can be loaded will load instantly if it is parsed and saved as 
   postfix ahead of time.

   Word parse_save will save an infix file as postfix.  This might be
   advantageous for files that rarely change and are sourced often.  

   Running word parse_save on this file produces file uboot.nv (a "v" 
   is attached to the name), and uboot.nv can then be sourced in place 
   of uboot.n.  

----------------------------------------------------------------------*/

   function (B) = L2scale(A) {
   /* Special log2 scaling function for fractions.
      Examples:

         L2scale([1/64 ; 1/32 ; 16/32 ; 31/32 ; 63/64])' mtext .
                  -5     -4      0      4       5

         L2scale(1/32+uniform(1/32, 31))' dot(neat(mtext))
   */
      DO(cols(A), 1)
         R = A[*,I] > 0.5;
         (B1, B2) = rake(A[*,I], R);
         B[*,I] = tier(1 + log2(B1), abs(log2(1 - B2)) - 1, R);
      LOOP;
   }

   function (T) = pplot(Yd, Xd) {
   /* Create printer plot T of data Yd(Xd).

      To revise NX, NY or CHARS, bank new values into this local 
      library before running pplot(), as in:
         pplot.NX = 80;
         pplot.NY = 42;
         pplot.CHARS = "+-*";
   */
      { /* Number of intervals: */
              NX = 72; /* horizontal */
              NY = 28; /* vertical */

         /* Characters for symbols: */
            CHARS = "*+-=oxvu#@.$%&";
      }
      DO(chars(CHARS), ndx(1))
         SYM[I] = byte(CHARS,I);
      LOOP;

      curves = min(rows(SYM), cols(Yd));
      if(cols(Yd) > curves)
         nl(dot(" pplot: last " + intstr(cols(Yd)-curves) +
            " curve(s) cannot be plotted"));

   /* Range of data: */
      (Xdmax, i, j) = maxfetch(Xd);
      (Xdmin, i, j) = minfetch(Xd);
      (Ydmax, i, j) = maxfetch(Yd);
      (Ydmin, i, j) = minfetch(Yd);

   /* Lerp() is used first to scale and then to interpolate. */

   /* Scale the columns of Yd to the vertical intervals (using NY;0
      instead of 0;NY because Yd points up and Yw points down: */
      Ys = lerp([[Ydmin ; Ydmax], clone([NY ; 0], cols(Yd))], Yd);

   /* Scale the Xd column to the horizontal intervals: */
      Xs = lerp([[Xdmin ; Xdmax], [0 ; NX]], Xd);

   /* Interpolate Ys to discrete Xw points, and round to integer: */
      Xw = [0 : NX];
      Yw = rounded(lerp([Xs, Ys], clone(Xw, cols(Ys))));

   /* Put the plot symbols into array T: */
      T = blockofblanks(NY+1, NX+1);
      DO(rows(Xw), ndx(1))
      /* This loop runs in reverse so column 1 is done last: */
         DO(ndx(1), ndx(curves)) 
            r = min(@Yw[J,I]+xbase, rows(T));
            said(strput(T[r], @SYM[I], J), T, r);
         LOOP;
      LOOP;
   /* X and Y arrays are not purged so they are present for use by
      other words displaying T. */
   }
