/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* mem.h  April 1999

Copyright (c) 1999  D. R. Williamson
*/

#if !defined(HAVE_MEM)

/*
   Pattern tables.  

   A table of patterns contains rows of bytes all the same width.  

   Functions patadd(), patget(), patloc(), patnew(), patprops() work 
   with these tables, using the following patitem struct shown below.

   NOTE: The full width (wid) of pattern bytes from an incoming pat-
   tern is copied by patadd(), so all wid bytes need to have been set 
   beforehand to avoid random garbage in the copied row. */

typedef struct {
   void *pat; /* starting address of pattern table */
   int gro; /* rows to add each time table grows */
   int siz; /* total rows in table (.ge. use) */
   int use; /* rows in use (.le. siz) */
   int wid; /* width (bytes) of each row */
} patitem;

int BITS(); /* BITS ( --- n) */
int blockofblanks(); /* blockofblanks (rows chars --- hT) */
int cop(); /* cop (hA --- hB) */
int fill(); /* fill (x r c --- hA) */
int getbrk(); /* getbrk ( --- addr) */
void mallfree(void **ptr);
int mallinfo1(); /* mallinfo ( --- ) */
int matstk(int rows, int cols, char *name); /* ( --- hA) */
int matstk_idx(int rows, int cols, char *name); /* ( --- hA) */
int memarena(); /* memarena ( --- N) */
int memfree(); /* memfree (memptr --- ) */
int memfreed(); /* memfreed ( --- N) */
double *memget(int rows, int cols);
double *memget0(int rows, int cols);
char *memgetc(int rows, int chars);
char *memgetn(char *name, int len);
char *memgetn1(char *name, int len, int len1);
char *memgetnNL(char *name, int rows, int chars, int *len);
int meminuse(); /* meminuse ( --- N) */
int mempeek(); /* mempeek (memptr --- hA) */
int memprobe(); /* memprobe ( --- ) */
int memprobe1(); /* memprobe1 ( --- delta_mem) */
int memptrshow(); /* memptrshow (memptr --- memptr) */
int mempull(); /* mempull (memptr --- hA) */
int memput(); /* memput (hA --- memptr) */
int null(); /* null (r c --- hA) */
int patadd(void *pat, patitem *p, int *loc);
int patadd1(void *pat, patitem *p, int *loc);
void *patget(int n, patitem *p);
int patloc(void *pat, patitem *p, int *loc);
patitem *patnew(int siz, int gro, int wid);
void patprops(patitem *p);
int scalar(); /* scalar ( --- hS) */
int setbrk(); /* setbrk (addr --- ) */
int strstk(int chars, char *name); /* ( --- qS) */
int tpurged(); /* tpurged (nType --- hPurged) */
int volstk(int rows, int chars, char *name); /* ( --- hT) */
int add_idx(); /* ( hA hR hC --- hAI ) */
int get_idx(); /* ( hAI --- hR hC ) */

#define HAVE_MEM 1
#endif
/* end mem.h headers */

