/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* ctrl.h  April 1999

Copyright (c) 1999  D. R. Williamson

*/

#include <setjmp.h>

/* Messages for controls and creation (other messages are in stk.h): */
#define BADEND "unexpected end"
#define BADLOOP "incorrect loop structure"
#define BADBRANCH "incorrect branch structure"
#define BADNAME "cannot distinguish name from number"
#define BADUNWIND "incorrect structure while unwinding run levels"
#define BOOKCANT "data to book conflicts with a definition name"
#define BOOKICANT "data to book conflicts with an inline name"
#define BOOKDCANT "word to book conflicts with a data name"
#define BRAKNOT "unexpected closing bracket, ]"
#define CATNOT "undefined word in source"
#define CATNOTX "undefined variable or function"
#define CATNOTW "word not found in catalog"
#define CONSCANT "a native constant cannot be redefined"
#define DEFNOT " not completed due to error"
#define DEFCANT "definition name conflicts with a booked item"
#define DEFNEST "end missing or define: nested within define:"
#define DEFCHMAX "total characters in definition exceeds buffer size"
#define ERRSBOOT "An error occurred while loading"
#define FILERR "file error"
#define FILERR1 "error opening file"
#define FILERR2 "error closing file"
#define FILNOSO "file cannot be sourced"
#define FILNOT "file not found"
#define FILNOTO "file cannot be opened"
#define FILOLD "file exists--cannot create new"
#define FILHNDNOT "invalid file handle"
#define FILNAMNOT "name not found on file"
#define FILREADERR "error reading file"
#define FILRECNOT "file record size not set"
#define FILWROTERR "error writing to file"
#define FILSEEKNOT "file seek failed"
#define INDEXNOT "not an index in a running loop"
#define INLBADLP "incomplete loop or missing end"
#define INLBADSTK "loop, branch, or string incomplete"
#define INLINENOT "not a valid word for inline function"
#define INLINERR "function not completed due to error"
#define INLONLY "valid only during creation of inline function"
#define JUMPNOT "return jump not found"
#define KEYERRW "cannot initialize keyboard"
#define LIBNOT "a library item cannot be changed to another type"
#define LOCKON "machine is already locked"
#define MAXDOLEV "maximum loop level exceeded"
#define MAXRUNLEV "maximum run level exceeded"
#define NAMCLASH "inline name will clash with definition in main"
#define NAMFENCE "a name conflicts with protected word in catalog"
#define NAMNOT "stack items belonging to catalog items can't be renamed"
#define NATICANT "a native word cannot be redefined"
#define NATNOT "not valid for native words"
#define NEEDEND "expect ending defined by word end or ;"
#define NEEDENDB "expect ending bracket, ]"
#define NEEDLIM "expect limit and start index on stack, like 10 2 DO"
#define NOTUP "must jump to higher run level"
#define PENDING "incomplete loop or branch structure"
#define PTRCNOT "invalid catalog pointer"
#define RUNNOT "runtime function not in catalog"
#define STRNOTC "string not in catalog"
#define STRNULL "text contains numerical zero"
#define TOKNOT "source token array not free"
#define TYPNOT "unknown type of stack item"
#define WORDFREE "reference to a word no longer in the catalog"
#define WORDNOTC "word not in catalog"
#define WORDEMPT "cannot put word with no characters into catalog"

int onbuf; /* current run level and source text buffer (0 to NBUF-1) 
             Search for "From ctrl.h" in doc/design.doc for one of
             the discussions about run levels. */

jmp_buf abortbuf; /* environment for jmp to bufabort() */

/* Run level pointer to the function for searching the catalog: */
unsigned long (*catsearch[NBUF])(char *word);

/* Run level tag for fetching from and storing into specific libraries
   in the catalog (called the context): */
char *cattag[NBUF];

/* Number of the catalog library region being used: */
int catlib[NBUF];

char *pBUF[NBUF]; /* array of start (mallocked) pointers for buffers */

/* Run level variables: */
jmp_buf jmpenv[NBUF];
char jmpready[NBUF];
char jmptype[NBUF]; enum jmptypes {CTRL=1,EXEC};
char endbuf[NBUF];  /* 1 when end, set by end1() or end1d() */
char bufdes[NBUF]; /* lower buffer to return to in bufdescend() */

/* Pointer arrays for text being interpreted, set by bufjump, used by
   bufup. */
unsigned char *iP[NBUF];     /* array of ip (see inpo.h) */
unsigned char *iPEND[NBUF];  /* array of ipend */
unsigned char *iPRECL[NBUF]; /* array of iprecl */
unsigned char *iPRECT[NBUF]; /* array of iprect */

/* Pointers to text being interpreted: */
unsigned char *ip;     /* pointer to text immediately after token */
unsigned char *ipend;  /* pointer to end of current buffer */
unsigned char *iprecl; /* pointer to \n preceding current text line */
unsigned char *iprect; /* iprecl for text line of current token */

/* Control activity when interpreting; this defines control mode: */
char ctrlactive[NBUF]; /* ctrlactive=1 when skipping text, like during
                          ELSE ... THEN when flag for IF was true or
                          during IF ... ELSE when flag was false */

char ctrlelse[NBUF]; /* count of mid words like ..ELSE.., ..WHILE.. */

enum ctrlret {ENDSOU=1,ENDPTR,ENDDEF,ENDWAIT,ENDLOCK,ENDBRAK,
              ENDLIST,DEFINE,KEY,ERRC,EXIT,LOOP,ELSE,THEN,UNTIL,
              WHILE,VOICE,BLASX,PROMPTER,ABORT,ENDEXP,
              REPEAT=UNTIL}; /* NOTE: this one must be last */
/* For notes on ctrlret (jmpready), see doc/jmptable.doc). */

int begin(); /* BEGIN ( --- ) */
void begindn();
int beginup();
int brak(); /* [ ( --- ) */
int brakend(); /* ] ( --- ) */
void bufabort(int onbufto);
int bufascend(); 
void bufdescend(); 
void bufdn();
void bufdn1();
void bufinit();
int bufjump(char *pbuf, unsigned int size);
void bufreturn();
int bufunwind(int jmpid1, int jmpid2, int silent);
int bufup();
int bufup1();
int byeflag();
int doexit(); /* EXIT ( --- ) */
int doindex0(); /* ( --- I) */
int doindex1(); /* ( --- J) */
int doindex(int offset); 
int dojmp(); /* LOOP ( --- ) */
int dojmp1(); /* +LOOP (n --- ) */
int doloop(); /* DO (n2 n1 --- ) */
int doloop1(); /* ?DO (n2 n1 --- ) */
int done(); /* done ( --- ) */
int doneoff(); /* done_off ( --- ) */
int dorun(int eq);
int end1(); /* ( --- ) */
int erp(); /* erp ( --- ) */
int ersys(); /* ersys (qS --- ) */
int HALT(); /* HALT ( --- ) */
int halt(); /* halt ( --- ) */
int ifbranch(); /* IF (f --- ) */
int ifelse(); /* ELSE ( --- ) */
int ifthen(); /* THEN ( --- ) */
int jmptable(); /* jmptable ( --- ) */
int list(); /* list: ( --- hA) */
void loopdn();
int loopup();
void performc();
int repeat(); /* REPEAT ( --- ) */
void reperr();
int repmon(int reset);
void report(char *token);
int return1(); /* return ( --- ) */
int return2(); /* return2 ( --- ) */
int rlconsole();
int rlhalt();
int runlevel(); /* runlevel ( --- n) */
int until(); /* UNTIL (f --- ) */
int wait1(int f);
int WAIT_BEGIN(); /* WAIT_BEGIN ( --- ) */
int WAIT_END(); /* WAIT_END ( --- ) */
int while1(); /* WHILE (f --- ) */

/* end ctrl.h headers */

