\ File usr/snd.v  November 2008

\  Copyright (c) 2008-2011   D. R. Williamson

\  Added usr words for sound (file sys/snd.v).

\-----------------------------------------------------------------------

   "piano" missing
   IF syspath "snd.v" + source THEN \ sourcing the system file sys/snd.v

\  Modifications for user machines:
   host "plunger" =
   host "helton" = or
   IF "/tmp1/" runid1 + "_" + "wavFile1" "FIL" bank THEN

\-----------------------------------------------------------------------

\  Market voices.

 \ Macro signal.ALERT in mobius.n runs phrase "vSig wavque_add" on the 
 \ sound file server to implement the voices that this region creates.

 \ no  "USE8" book \ make word vSig for 16-bit voice files
   yes "USE8" book \ make word vSig for 8-bit voice files

   inline: players_say ( --- ) \ hear voices for all the players
      [ "/mdat/voices/" "VDIR" book
        {"
           goalkeeper1 goalkeeper2
           fullback1 fullback2
           stopper1 stopper2
           midfielder1 midfielder2
           forward1 forward2
        "} words "PLAYERS" book
      ]
      SNDSERVER_ON not
      IF " players_say: sound file server is not running" . nl
         return
      THEN

    \ This word uses the running sound file server.

    \ There is a long delay after the first voice plays, then all the
    \ voices play in succession.  It is not known why there is a delay.

      PLAYERS rows 1st
      DO VDIR "mike_" +
         PLAYERS I quote strchop + ".wav" +
         "/tmp/" runid + ftemp dup "F" book fcopy
         F (qFile) remote_wavPlayq

         VDIR "crystal_" +
         PLAYERS I quote strchop + ".wav" +
         "/tmp/" runid + ftemp dup "F" book fcopy
         F (qFile) remote_wavPlayq
      LOOP
   end

   inline: vMkt (qN--- qV) \ return voice name V for mkt N
\     Return voice string V specified for market string N.

\     Note: this word serves as a template for any function that does
\     a table lookup for string N.  Require chars(N) < 9.

      [ 
      \ Voice names (no limit on chars):
        "crystal" \ number 1 name
        "mike"    \ number 2 name
        pile "Vnames" book

        1 "Vals" book \ number of values for with each string N
        {" Each N string is followed by one value, a name number 1 or 2:

          eu 1 sf 1 jy 1 bp 2
          dj 2 sp 1 nq 2 us 2 tn 1
          cl 2 ng 2
          hg 2 gc 1
          w 1 c 2 s 2 sm 1 bo 2 ct 2

        "} (hT) words vol2mat (hA) \ text patterns into numbers
        (hA) Vals 1+ fold (hM) dup

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search,
      \ matrix S is sorted so the rows in column 1 are in ascending
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having Vals rows of data with each column
      \ corresponding to a row in S:

        (hM) 2nd Vals items reach mat2vol numerate Vals foldr "G" book
      {
        To see table S names, run this phrase at the ready prompt:
           "vMkt" "S" yank 1st catch mat2vol .

        To see the column map for list G contained in S[*, 2], run:
           "vMkt" "S" yank 2nd catch .m

        To see the columns of list G run:
           "vMkt" "G" yank .m
      }
      ]
      (qN) "N" book

      S N lowercase 8 blpad str2num (n)   \ turn N string into a NUM
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG nC) catch (nR)               \ fetch row number from list G
         (nR) Vnames swap (hNames nR)
         (hNames nR) reach 1st quote strchop \ fetch voice name

      ELSE (r) drop " vMkt: no data for " N + . nl ""
      THEN (qV)
   end

   inline: vNum (u qV --- qWav)
\     Create a 16-bit wave file with voice V for unsigned integer u.
\     Incoming V includes file path, perhaps as prepped in word vSig.

\     Raises amplitude of each number to vmax16.

      (qV) strchop "V" book
      (u) dup type NUM = IF intstr THEN push
      list: peek chars 1st DO peek I catch LOOP ; words "N" book
      pull drop

      V N 1st quote + ".wav" + wavData (hT hH) "H" book
      (hT) vmax16 N rows 1 >
      IF N rows 2nd
         DO V N I quote dup "0" = IF flip IF drop "oh" THEN THEN
            + ".wav" + wavData (hTi hHi) drop vmax16
            (hT hTi) + (hT)
         LOOP
      THEN (hT) H wavFile1
   end

USE8 IF \ make word vSig for 8-bit voice files:

   inline: vSig (qMkt qSig nP nChg nRep --- qWav)
{     Read 8-bit wave voice files and make a 16-bit wave file for 
      Mkt+Sig+P+Chg, repeated Rep times.  

      Voice files, 16-bit, were created at:
         http://www.research.att.com/~ttsweb/tts/demo.php

      Also see the notes in vSig for 16-bit files.

      Eight-bit voice files were created from the 16-bit ones (see
      the Appendix of file sys/snd.v), and are stored in directory 
      VPATH defined below.

      Eight-bit voice files are used because they are about four times 
      smaller, making distribution to a number of machines easier.  

      But playing 8-bit files was found to give occasional annoying 
      clicks at start or end which are not noticed when playing 
      16-bit files.  

      Word wavExpand8() was written to expand an 8-bit wave file into
      a file of 16-bit data.  Using wavExpand8() and then playing 16-
      bit files eliminates the clicking problem.

      When this word finishes assembling the 8-bit voice files, it
      uses wavExpand8() to convert the outgoing file from 8 to 16 
      bits before it is played.

      Some phrases for testing 8-bit sound:
       \ Crystal sounds cute:
         "eu" "baker2" "" "" 2 vSig wavPlayf
         "gc" "foxtrot2" "" "" 2 vSig wavPlayf

       \ Mike exhales after saying one (must turn the volume way up):
         "dj" "able1" "" "" 2 vSig wavPlayf
         "cl" "pricecrossed+belowtrmain" "" "" 2 vSig wavPlayf
}
      [
      \ Path to 8-bit signal files (WARNING: no voices for numbers are
      \ stored here, so if vNum is used it will fail):
        mpath "voices/signal8/" + "VPATH" book \ 8-bit voices

        1.5 "PAUSE" book   \ seconds to pause between repeats
        2.0 "TRAILER" book \ seconds ending

      \ Note: to force the use of ATTN, functions can bank 0 for LAST:
        0 "LAST" book \ machine time of last exit for use in ATTN

        no "REMIND" book

      \ Note that nRep repeats do not apply to saying ATTN.  ATTN is
      \ only said once.

      \ Note: making MAXQ equal to zero means play only once, no matter
      \ what is the value of incoming nRep.
        1 "MAXQ" book \ ignore nRep and play once if queue len >= MAXQ

      \ NOTE March 2010: limiting nRep using MAXQ has the problem of
      \ unduly counting items in the queue that were not placed there
      \ by vSig.  This is a new approach that uses time to limit nRep
      \ if less than TMIN seconds has passed since the last vSig:
        30 "TMIN" book \ ignore nRep and play once if t-TEXIT < TMIN
        0 "TEXIT" book \ machine time of last exit for use with TMIN

        {" ATTN ( --- f) \ say attention if f is true
           time LAST -                  \ seconds since last Sig
           4 6 1 1 ranreal @ 60 * > (f) \ more than 4 to 6 minutes ago?
        "} "ATTN" macro
      ]
      "wavSilence" "bSilence" yank "DEFsilence" book 
      128 "wavSilence" "bSilence" bank \ override default

      (nRep) once max (nrep)
    \ "wavque_play" "queue" yank rows (qlen) MAXQ >=
      time TEXIT - TMIN < \ one rep if time passed is less than TMIN
      IF (nRep) drop once THEN (nRep) "R" book

      (hChg) "C" book

      (nP) dup type NUM = IF intstr THEN (qP) "P" book

    \ Sig may have different file names separated by + (see some of the
    \ examples above); the files will be concatenated:
      (qSig) "+" chblank (hT) words "S" book

      (qMkt) "M" book

      VPATH (qVPATH)
      M vMkt any? \ get voice for Mkt M
      IF (qVPATH qV) + "_" + "WHO" book

         REMIND
         IF no "REMIND" book flip 
            IF WHO "againnote.wav" ELSE WHO "reminder.wav" THEN + (qF)
            (qF) wavData 1 wavSilence + vmax8s (hT0) 
         ELSE
            ATTN
            IF WHO "attention_please.wav" + wavData 
               1 wavSilence + vmax8s
            ELSE ""
            THEN (hT0) 
         THEN (hT0)

         WHO M lowercase + "_mkt.wav" + (qWav1)     \ Mkt name file 
         (qWav1) wavData (hT1 hH) push 
       \ Thu Oct 13 06:02:09 PDT 2011.  Add slight pause after Mkt:
         peek 0.35 wavSilence + vmax8s (hT1) \ voice of Mkt

         "" (hT2) S rows 1st \ concatenate signal files
         DO WHO S I quote strchop lowercase + ".wav" +   \ wav file name
            (qWavI) wavData (TI hHI) drop vmax8s + (hT2) \ voice of Sig
         LOOP (hT2)

         P chars 0> \ add price voice if P has any chars
         drop no \ ignore vNum; it uses 16-bit files
         IF P WHO vNum (qWav) dup wavData (hT hH) drop vmax16 (hT3)
            swap (qWav) delete \ delete temp file from vNum
         ELSE ""
         THEN (hT3)

         C type NUM = \ add direction voice if type is NUM
         IF WHO (qWHO) C 0> 
            IF "rising" 
            ELSE C 0< 
               IF "dropping" ELSE "flat" THEN
            THEN (qDir)
            (qWHO qDir) + ".wav" + (qWav) wavData (hT hH) drop 
            (hT) vmax8s (hT) 
         ELSE ""
         THEN (hT4)

         (hT1 hT2 hT3 hT4) + + + (hT)

         R 1 > \ repeat the message with PAUSE between
         IF (hT) peek PAUSE wavSilence over + R 1- cats + (hT) THEN

         (hT) peek (hH) TRAILER wavSilence + (hT) \ ending silence
         (hT0 hT) + pull (hT hH)                  \ append to T0

      ELSE 
       \ (qVPATH) flip \ sometimes crystal and sometimes mike 
       \ IF "crystal_error.wav" ELSE "mike_error.wav" THEN (qFile)
          
         (qVPATH qFile) drop "cq.wav" + wavData (hT hH)

         " vSig: no data for " M + . nl

      THEN 
      (hT hH) wavFile1 (qWav8) 

    \ Expand Wav8 into Wav16 and delete Wav8:
      (qWav8) dup wavExpand8 (qWav16)
      (qWav8 qWav16) swap (qWav8) deleteif 

      (qWav16)

      time dup "LAST" book "TEXIT" book
      DEFsilence "wavSilence" "bSilence" bank \ reinstate default
   end

ELSE \ make word vSig for 16-bit voice files:

   inline: vSig (qMkt qSig nP nChg nRep --- qWav)

\ WARNING March 2010: unverified changes have been made to this 16-bit
\ version to keep it current with the previous 8-bit version.

{     Create a 16-bit wave voice file for Mkt+Sig+P+Chg, repeated Rep 
      times.

      Voice files (16-bit) were created at:
         http://www.research.att.com/~ttsweb/tts/demo.php
      and are stored in directory VPATH defined below.

      Mkt is the market symbol, like gc for gold or cl for crude oil.

      Market file names are generated here from incoming Mkt and the 
      voice returned by word vMkt, such as crystal_eu_mkt.wav for Euro
      currency when incoming Mkt is symbol "eu" and Crystal is the 
      designated voice for Euros.  Market name files all have the end-
      ing "_mkt.wav."

      Sig is an abbreviated signal file name, excluding voice and ex-
      tension.  For example, incoming "sierra103" is the abbreviated
      file name for mike_sierra103.wav and crystal_sierra103.wav.  One
      or the other will be used depending upon the voice from vMkt(Mkt).

      Sig may contain a series of abbreviated file names separated by 
      +, and the files will be concatenated.  For example, incoming
      "bravo102+from_b101" when voice is Mike will contenate voice
      files mike_bravo102.wav and mike_from_b101.wav.

      Note: concatenated voice file names are lower case, so all signal
      file names ***must*** be in lower case.

      If P is an empty STR instead of a STR or NUM, it is skipped.

      If Chg is an empty STR instead of a NUM, it is skipped.

      Examples: 

         "vSig" missing IF "snd.v" source THEN

       \ qMkt qSig                  nP      nChg nRep
         "dj" "bravo102+from_b101"  ""      ""    2   vSig wavPlayf
         "cl" "sierra104"           ""       0    2   vSig wavPlayf
         "sp" "bravo102"            ""      ""    2   vSig wavPlayf
         "dj" "b2s+newhigh"         ""      ""    2   vSig wavPlayf
         "gc" "sierra101"           ""      -1    1   vSig wavPlayf
         "sf" "s2b+newlow"          ""      ""    2   vSig wavPlayf
         "hg" "bravo102"            "18463"  1    1   vSig wavPlayf

         "gc" "belowsellstop"       ""      ""    1   vSig wavPlayf

         "eu" "warning" ""   ""    1   vSig wavPlayf

         "sf" " bravo102+warning+trace1crossed+belowtrace5" "" "" 1 \
            vSig wavPlayf

         "eu" "bravo102+warning+pricecrossed+belowtrace2" "" "" 1 \
            vSig wavPlayf

         "cl" "bravo101+warning+pricecrossed+belowtrace2" "" "" 1 \
            vSig wavPlayf

         "gc" "bravo102+warning+pricecrossed+abovetrace3" "" "" 1 \
            vSig wavPlayf

         "jy" "sierra102+newstate+limaspot" "" "" 2   vSig wavPlayf

       \ Is Mike funny, or what?
         "hg" "bravo101+newstate+echospot" "" ""  2   vSig wavPlayf

       \ Crystal sounds cute:
         "eu" "baker2" "" ""  2   vSig wavPlayf

       \ Mike exhales after saying one (must turn the volume way up):
         "dj" "warning+able1" "" ""  2   vSig wavPlayf

       \ Crystal takes a breath before saying two:
         "eu" "foxtrot2" "" ""  2   vSig wavPlayf

       \ Some files for these have been moved to voices/archive, and
       \ some of these phrases will not immediately work:
       \ "sf" "sierrarally+takenote+strongres" "" "" 2 vSig wavPlayf
       \ "dj" "bravoreaction+takenote+strongsup" "" "" 2 vSig wavPlayf
         "eu" "bravo102+belowtrlow" ""      -1    2   vSig wavPlayf
         "eu" "expect+bravo_branchdn" ""    ""    1   vSig wavPlayf
         "gc" "expect+sierra_branchup" ""   ""    1   vSig wavPlayf
         "cl" "expect+bravo_branchdn" ""    ""    1   vSig wavPlayf
         "nq" "expect+sierra_branchup" ""   ""    1   vSig wavPlayf
         "nq" "newlow+died_out+"       ""   ""    1   vSig wavPlayf
         "eu" "newlow+died_out+"       ""   ""    1   vSig wavPlayf
         "nq" "newhigh+died_out+"      ""   ""    1   vSig wavPlayf
         "eu" "newhigh+died_out+"      ""   ""    1   vSig wavPlayf
         "eu" "branch_sierra+dropping" ""   ""    1   vSig wavPlayf

         This set uses the wave file queuing system; copy and paste
         all the lines at the same time:
            wavque_start
            "DJ" "newhigh" "" "" 1 vSig wavque_add 
            "EU" "newlow"  "" "" 1 vSig wavque_add 
            "CL" "newlow"  "" "" 1 vSig wavque_add 
            "SF" "newhigh" "" "" 1 vSig wavque_add 
            wavque_play

      How to force "reminder:"
         "cl" "newhigh"  "" "" 2 yes "vSig" "REMIND" bank vSig wavPlayf
         "eu" "newhigh"  "" "" 2 yes "vSig" "REMIND" bank vSig wavPlayf

      How to force "attention please:"
         0 "vSig" "LAST" bank "sp" "newlow"  "" "" 2 vSig wavPlayf
}
      [ 
      \ Use this path of signal files (WARNING: no voices for numbers
      \ are stored here, so if vNum is used it will fail):
        mpath "voices/signal/" + "VPATH" book \ 16-bit voices

        1.5 "PAUSE" book   \ seconds to pause between repeats
        2.0 "TRAILER" book \ seconds ending

      \ Note: to force the use of ATTN, functions can bank 0 for LAST:
        0 "LAST" book \ machine time of last exit for use in ATTN

        no "REMIND" book

      \ Note that nRep repeats do not apply to saying ATTN.  ATTN is
      \ only said once.

      \ Note: making MAXQ equal to zero means play only once, no matter 
      \ what is the value of incoming nRep.
        1 "MAXQ" book \ ignore nRep and play once if queue len >= MAXQ

      \ NOTE March 2010: limiting nRep using MAXQ has the problem of
      \ unduly counting items in the queue that were not placed there
      \ by vSig.  This is a new approach that uses time to limit nRep
      \ if less than TMIN seconds has passed since the last vSig:
        30 "TMIN" book \ ignore nRep and play once if t-TEXIT < TMIN
        0 "TEXIT" book \ machine time of last exit for use with TMIN

        {" ATTN ( --- f) \ say attention if f is true
           time LAST -                  \ seconds since last Sig
           4 6 1 1 ranreal @ 60 * > (f) \ more than 4 to 6 minutes ago?
        "} "ATTN" macro
      ]
      "wavSilence" "bSilence" yank "DEFsilence" book 
      0 "wavSilence" "bSilence" bank \ override default

      (nRep) once max (nrep)
    \ "wavque_play" "queue" yank rows (qlen) MAXQ >=
      time TEXIT - TMIN < \ one rep if time passed is less than TMIN
      IF (nRep) drop once THEN (nRep) "R" book

      (hChg) "C" book

      (nP) dup type NUM = IF intstr THEN (qP) "P" book

    \ Sig may have different file names separated by + (see some of the
    \ examples above); the files will be concatenated:
      (qSig) "+" chblank (hT) words "S" book

      (qMkt) "M" book

      VPATH (qVPATH)
      M vMkt any? \ get voice for Mkt M
      IF (qVPATH qV) + "_" + "WHO" book

         REMIND
         IF no "REMIND" book flip 
            IF WHO "againnote.wav" ELSE WHO "reminder.wav" THEN + (qF)
            (qF) wavData 1 wavSilence + vmax16 (hT0) 
         ELSE
            ATTN
            IF WHO "attention_please.wav" + wavData 
               1 wavSilence + vmax16 
            ELSE ""
            THEN (hT0) 
         THEN (hT0)

         WHO M lowercase + "_mkt.wav" + (qWav1)     \ Mkt name file 
         (qWav1) wavData (hT1 hH) push 
       \ Thu Oct 13 06:02:09 PDT 2011.  Add slight pause after Mkt:
         peek 0.35 wavSilence + vmax16 (hT1) \ voice of Mkt

         "" (hT2) S rows 1st \ concatenate signal files
         DO WHO S I quote strchop lowercase + ".wav" +   \ wav file name
            (qWavI) wavData (TI hHI) drop vmax16 + (hT2) \ voice of Sig
         LOOP (hT2)

         P chars 0> \ add price voice if P has any chars
         IF P WHO vNum (qWav) dup wavData (hT hH) drop vmax16 (hT3)
            swap (qWav) delete \ delete temp file from vNum
         ELSE ""
         THEN (hT3)

         C type NUM = \ add direction voice if type is NUM
         IF WHO (qWHO) C 0> 
            IF "rising" 
            ELSE C 0< 
               IF "dropping" ELSE "flat" THEN
            THEN (qDir)
            (qWHO qDir) + ".wav" + (qWav) wavData (hT hH) drop 
            (hT) vmax16 (hT) 
         ELSE ""
         THEN (hT4)

         (hT1 hT2 hT3 hT4) + + + (hT)

         R 1 > \ repeat the message with PAUSE between
         IF (hT) peek PAUSE wavSilence over + R 1- cats + (hT) THEN

         (hT) peek TRAILER wavSilence + (hT) \ end with some silence

         (hT0 hT) + pull (hT hH) \ append message to T0

      ELSE 
       \ (qVPATH) flip \ sometimes crystal and sometimes mike 
       \ IF "crystal_error.wav" ELSE "mike_error.wav" THEN (qFile)
          
         (qVPATH qFile) drop "cq.wav" + wavData (hT hH)

         " vSig: no data for " M + . nl

      THEN 
      (hT hH) wavFile1 (qWav)

      time dup "LAST" book "TEXIT" book
      DEFsilence "wavSilence" "bSilence" bank \ reinstate default
   end

THEN \ end USE8 branches

   private halt

\-----------------------------------------------------------------------

; Appendix.

   Selected voice files to 8 bits, Thu Feb 25 10:34:57 PST 2010.

   Also see the appendix of sys/snd.v for phrases that convert an en-
   tire directory of files, like all the ones in SIG16 (see below) into
   8-bit versions in SIG8.  The phrases here are meant to use when ad-
   ditional files, perhaps new or forgotten ones, need to be converted
   and placed in SIG8.

   Remove the old names from the list of FILES below and add the new 
   ones.  Entries for the new files should also be added to script
   /mdat/voices/cpsig.

   Run this phrase to source this region and resample files listed 
   below:

      "snd.v" "CONVERT16" msource

   Warning: remove any same-named files from /mdat/voices/signal8/
   and from /mdat/voices/signal/ before running this, or it will
   fail on permissions problems.  Also see note below "Warning: due 
   to read-only permission ... ."

   Here is an example showing new 8-bit files written to directory SIG8:
      
      [tops@plunger] ready > "snd.v" "CONVERT16" msource
      /mdat/voices/signal8/mike_excessive_messages.wav done
      /mdat/voices/signal8/crystal_pit_soon_close.wav  done
      /mdat/voices/signal8/crystal_pit_has_closed.wav  done
      /mdat/voices/signal8/mike_pit_has_closed.wav     done
      /mdat/voices/signal8/mike_pit_soon_close.wav     done
      /mdat/voices/signal8/mike_echo1.wav              done
      /mdat/voices/signal8/mike_echo2.wav              done

   CONVERT16

      no catmsg

      "wavResample16" missing IF "snd.v" source THEN

      mpath "voices/" + "SIG" book
      mpath "voices/signal/" + "SIG16" book
      mpath "voices/signal8/" + "SIG8" book

      {" List of files to be converted to 8 bits:

         mike_dot0.wav

      "} chop noblanklines "FILES" book
{

Setting permissions in /mdat/voices/signal:
[dale@plunger] /mdat/voices/signal > ll mike_echo4.wav
-rw-------    1 dale     comm        32684 Oct 17 17:03 mike_echo4.wav

[dale@plunger] /mdat/voices/signal > chmod 444 mike_echo4.wav
[dale@plunger] /mdat/voices/signal > ll mike_echo4.wav
-r--r--r--    1 dale     comm        32684 Oct 17 17:03 mike_echo4.wav

         FILES done recently:

         crystal_dot0.wav
         mike_bravo101.wav
         mike_bravo102.wav
         mike_sierra101.wav
         mike_sierra102.wav
         crystal_bravo101.wav
         crystal_bravo102.wav
         crystal_sierra101.wav
         crystal_sierra102.wav

         mike_delta103.wav
         crystal_delta103.wav

         mike_car_bravo1.wav
         mike_car_bravo2.wav
         mike_car_bravo3.wav
         mike_car_sierra1.wav
         mike_car_sierra2.wav
         mike_car_sierra3.wav

         crystal_car_bravo1.wav
         crystal_car_bravo2.wav
         crystal_car_bravo3.wav
         crystal_car_sierra1.wav
         crystal_car_sierra2.wav
         crystal_car_sierra3.wav
}
{
      The next loop copies FILES from basic repository SIG (where files
      go when they are created at the ATT website) into SIG16.  Script 
      cpsig in /mdat/voices is supposed to contain all files that are
      copied into SIG16, so entries for FILES should also be made in 
      script /mdat/voices/cpsig.

      The purpose of SIG16 is to group just the files that are needed,
      and keep out extraneous or obsolete ones that are in SIG.

      Warning: due to read-only permission, if a FILE already exists
      in SIG8 or SIG16, the copy from SIG will fail as in
         cp: cannot create regular file 
            `/mdat/voices/signal/mike_jammer.wav': Permission denied
}
      FILES rows 1st \ use shell script, not fcopy, to preserve date:
      DO "cp -p " SIG + FILES I quote + spaced SIG16 FILES I quote + +
         (qS) shell
      LOOP

\     Resample to 8-bit sound and write to SIG8:
      FILES rows 1st
      DO SIG16 FILES I quote + (qWav16)
         (qWav16) wavResample16 (qWav8)
         (qWav8) dup SIG8 FILES I quote + (qWav8 qFile8) fcopy
         (qWav8) deleteif
         SIG8 FILES I quote + " done" + . nl
      LOOP

   halt

\  Making an 8-bit wave file using vSig.
\  Wed Feb 24 16:16:45 PST 2010
    \ Be sure to comment out wavExpand8 in vSig and set USE8 = yes.

    \ This job leaves files in /tmp1 that need to be deleted.

      MAKE8 \ "snd.v" "MAKE8" msource
         'snd.v' source
         128 "wavSilence" "bSilence" bank
         "eu" "baker2" "" "" 1 vSig wavData push
         "dj" "able1" "" "" 1 vSig wavData drop +
         "gc" "foxtrot2" "" "" 1 vSig wavData drop + pull wavFile1
         (qWav) "/opt/tops/tops/usr/voice/mstate.wav" fcopy
         " done" . nl
      halt

------------------------------------------------------------------------

   Making sound files used in file mobius.n:

\  Making file /mdat/voices/cq75.wav (Wed May 26 12:00:13 PDT 2010):
\     CQ (dah dit dah dit, dah dah dit dah)
      "snd.v" source LOAD_MORSE_CODE MC1 (MC2 is shrill)
      "CQ" 1 SIG (qWav) 75 wavAmp "/mdat/voices/cq75.wav" fcopy
      "/mdat/voices/cq75.wav" wavPlayf
      halt

\  Making file /mdat/voices/cq.wav:
\     CQ (dah dit dah dit, dah dah dit dah)
      "snd.v" source LOAD_MORSE_CODE MC1 (MC2 is shrill)
      "CQ" 1 SIG (qWav) "/mdat/voices/cq.wav" fcopy
      "/mdat/voices/cq.wav" wavPlayf
      halt

\  Making file /mdat/voices/tink2.wav, an alternate to tink1.wav.
    \ Wed Oct 14 07:18:31 PDT 2009

    \ Run these lines over and over to get a good tone:

      "wavData" missing IF "snd.v" source THEN
      1 BONG (qFile) wavData (hT hH) swap
      (hT) LITTLE_ENDIAN import2 (hA)

      32767
    \ Choose a scale factor to get the volume:
      .2 * "AMP" book

    \ Choose some bytes from the 66240 bytes of A to make a short
    \ tone:
    \ (hA) 40000 3000 items reach
      (hA) 9000 2000 items reach
    \ (hA) 1st 2000 items reach

      (hA) dup abs maxfetch 2drop /
      (hA) AMP * (hA) LITTLE_ENDIAN export2 (hT)
      (hH hT) over 1 wavSilence +
      (hH hT) swap (hT hH) wavFile1 (qWAV)

    \ Saving the file:
      (qWAV) "/mdat/voices/tink2.wav" fcopy

    \ Listening to the file:
      "/mdat/voices/tink2.wav" remote_wavPlayq

    \ In /mdat/voices, tink.wav has been set to tink2.wav.

      halt

      What is the frequency of tink2.wav?
      Using word wavPSD, snd.v.

      See the example in word wavPSD (snd.v) for these lines:
         "/mdat/voices/tink2.wav" wavPSD
         (hFreq) 2nd over rows 1- items reach (hFreq) swap
         (hPSD)  2nd over rows 1- items reach log10 (hPSDlog) swap
         (hPSDlog hFreq) plot

      Zooming in and clicking on the main peak shows a frequency of
      about 1020 Hz:
         x, y: 1020.4717   6.0169

      In word piano (snd.v) the closest key is C6:
         64      C6      c'''    1046,50.

      Frequency C6 is two octaves above C4 which is middle C.  Hitting
      that key on the piano verifies it is so.

      Here are some lower peaks on either side of the main one:
               Freq (Hz)   PSD Amplitude
         x, y:  19.8003    3.0492
         x, y:  24.2592    3.1875
         x, y: 1020.4717   6.0169 (main peak, close to C6)
         x, y: 2051.1356   4.5982
         x, y: 3070.3703   1.9294
         x, y: 3120.0544   2.1745
         x, y: 4136.7958   1.0164
         x, y: 4337.5889   0.8637

------------------------------------------------------------------------

\ Fri Jan 20 11:49:50 PST 2012.  Adding a little tail of silence 
\ to bravo101, bravo102, sierra101 and sierra102.

\ Source usr/snd.v with USE8 set to no, so these are 16-bit files in 
\ /mdat/voices/signal (and remember to set USE8 back to yes when done).

"eu" "sierra102+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/crystal_sierra102.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/crystal_sierra102a.wav" fcopy
"eu" "sierra102a+dot1" "" "" 1 vSig wavPlayf
halt

"eu" "sierra101+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/crystal_sierra101.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/crystal_sierra101a.wav" fcopy
"eu" "sierra101a+dot1" "" "" 1 vSig wavPlayf
halt

"eu" "bravo102+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/crystal_bravo102.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/crystal_bravo102a.wav" fcopy
"eu" "bravo102a+dot1" "" "" 1 vSig wavPlayf
halt

"eu" "bravo101+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/crystal_bravo101.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/crystal_bravo101a.wav" fcopy
"eu" "bravo101a+dot1" "" "" 1 vSig wavPlayf
halt

"cl" "bravo101+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/mike_bravo101.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/mike_bravo101a.wav" fcopy
"cl" "bravo101a+dot1" "" "" 1 vSig wavPlayf
halt

"cl" "bravo102+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/mike_bravo102.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/mike_bravo102a.wav" fcopy
"cl" "bravo102a+dot1" "" "" 1 vSig wavPlayf
halt
 
"cl" "sierra101+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/mike_sierra101.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/mike_sierra101a.wav" fcopy
"cl" "sierra101a+dot1" "" "" 1 vSig wavPlayf
halt
 
"cl" "sierra102+dot1" "" "" 1 vSig wavPlayf
"/mdat/voices/signal/mike_sierra102.wav" wavData (hT hH) 
(hT hH) dup push .7 wavSilence + pull (hT hH) wavFile1
"/mdat/voices/signal/mike_sierra102a.wav" fcopy
"cl" "sierra102a+dot1" "" "" 1 vSig wavPlayf
halt


------------------------------------------------------------------------

\ Sounds.

   inline: A54 (nS --- hT)
      "S" book
      "C5" piano 0.001  4 S pToned (hA)
      "A4" piano 0.0004 5 S pToned (hB)
      S .3 pMix
      dup dup push S 1 pMix
      pull S 2 pMix
      AMP *
      (hA) LITTLE_ENDIAN export2 (hT)
   end

   inline: A45 (nS --- hT)
      "S" book
      "A4" piano 0.001  4 S pToned (hB) 
      "C5" piano 0.0004 5 S pToned (hA)
      S .3 pMix
      dup dup push S 1 pMix
      pull S 2 pMix
      AMP *
      (hA) LITTLE_ENDIAN export2 (hT)
   end

   halt

\-----------------------------------------------------------------------

\  Obsolete.

\  ATTN has been replaced by ATTENTION in sys/snd.v.
   inline: ATTN ( --- ) \ broadcast site emergency alarm
\     Runs for about 8 seconds.
      [ syspath "../usr/voice/" + "ALARM1.WAV" + wavData swap
        dup chars 1 * nulls + \ multiples of chars work for silence
        hand LITTLE_ENDIAN import2 2.5 * LITTLE_ENDIAN export2 \ 2.5*amp
        5 clone swap (hT hH) wavFile1 "FILE" book
      ]
      " to turn off: -ATTN" . nl
      FILE wavPlay0
   end

   inline: +ATTN ( --- ) ATTN 1 10 / "ATTN" PLAY ; \ turn on ATTN alarm

   inline: -ATTN ( --- ) "ATTN" -ALARM ;           \ turn off ATTN alarm

\  It does not help to have separate /dev/dsp0; sox still complains if
\  you try to run two files at once.
   inline: wavPlay0 (qWav --- ) \ play a wave file using Linux play()
{     Plays in the background.  This also works for files other
      than wave.

      This word runs a version of play called play0.  Play0 is just a
      copy of play with /dev/dsp changed to /dev/dsp0.
      To make a device dsp0 like dsp used by play:
         /dev # mknod dsp0 c 14 3
         /dev # chmod a+rw dsp0
}
      [ "/usr/bin/play0" "FILE" book ]
      FILE filefound
      IF spaced swap + " &" + shell \ using Linux sound file program
      ELSE " wavPlay0: file not found: " FILE + . nl
      THEN
   end
