{  File qcon.v  April 2008

   Copyright (c) 2008   D. R. Williamson

   Control of queues 

   File qcon has been set up to source this file and run an interactive
   prompt for a queue server.  When new market data arrives, this server
   runs the update function on connected market window clients that have
   new data.

   When qcon sources this file, it runs word QSTART to start the program
   running as a queue server for real time updates to market windows.  

   Word QSTART also starts the sound server (tops_snd) to which updated
   market windows can connect for broadcasting their alerts; since 
   tops_snd is a separate program, once it is started by this program
   any program can connect to run sound files. [Update May 2010: Word
   QSTART no longer starts the sound server; it is started earlier by
   word STARTUP in file usr/uboot.v, which is run right after the ma-
   chine has been booted.] 

   When qcon exits, all connected market window clients exit as well, 
   and the sound server is closed (tops_sndcls).  [Update May 2010: the
   sound server is not closed].  To close all the clients without exit-
   ing, word clients_close is handy.

   This file can also be sourced at the ready prompt for somewhat easier
   debugging compared to working at the qcon (tinyc) prompt when script
   qcon is run instead.

------------------------------------------------------------------------

   Contents

   "qcon.v" asciiload this " inline:" grepr reach dot

   inline: ... ; ( --- ) \ do nothing for habitual ... from console
   inline: ALL_MKT ( --- hT) \ table of all client symbols
   inline: CLIENT_CLS (nS --- ) \ tasks when a client disconnects
   inline: CLIENT_DATA (qMkt --- purged or Pt) \ fetch P(t) for Mkt
   inline: CLIENT_DATA1 (qMkt --- hNames) \ fetch MKT fbooked file names
   inline: CLIENT_OPN (qMKT nS --- ) \ tasks when a new client connects
   inline: CLIENT_SKT ( --- hT) \ list of sockets and client names
   inline: clients_close ( --- ) \ close all clients who connected
   inline: client_offline (qMkt --- ) \ client for Mkt is going off line
   inline: client_online (qMkt --- ) \ client for Mkt is back on line
   inline: E_off ( --- ) \ key E off for all clients
   inline: E_on ( --- ) \ key E on for all clients
   inline: mdoy ( --- ) \ run DOY msource on file mobius.n
   inline: MKT_ALARM (qMKT --- ) \ offline warning for MKT
   inline: mob ( --- ) \ run msource on file mobius.n
   inline: offline_check ( --- ) \ test elapsed time of clients off line
   inline: qconset ( --- ) \ source a file of settings for clients
   inline: QSTART ( --- ) \ runs at start up
   inline: R_off ( --- ) \ key R off for all clients
   inline: R_on ( --- ) \ key R on for all clients
   inline: setclients (qSet hMKT --- ) \ make setting for MKT clients
   inline: setclients_all (qSet --- ) \ make setting on all clients
   inline: setkeys ( --- ) \ source tgraph() with new changes to keys
   inline: scancel ( --- ) \ cancel ALERTS file stops on all clients
   inline: scqoff ( --- ) \ turn off scq alert on all clients
   inline: scqon ( --- ) \ only scq alerts on all clients
   inline: SOCKETS_OFF ( --- ) \ leave sockets connected but unread
   inline: SOCKETS_ON ( --- ) \ allow sockets to be read
   inline: soundoff ( --- ) \ turn off sound signals on all clients
   inline: soundon ( --- ) \ turn on sound signals for all clients
   inline: soundon_alarm (nHrs --- ) \ set soundon alarm for nHrs hours
   inline: tog (n --- ) \ set view n for all clients
   inline: trackoff (hMKT --- ) \ turn off tracking for MKT clients
   inline: trackoff_all ( --- ) \ turn off tracking on all clients
   inline: trackon (hMKT --- ) \ turn on tracking for MKT clients
   inline: trackon_all ( --- ) \ turn on tracking for all clients
   inline: uclean_tiny ( --- ) \ uclean will run this on exit
   inline: UPDATED ( --- ) \ queue updated market windows
   inline: VCUTOFF ( --- ) \ cut voice messages if there are too many
   inline: view_all (n --- ) \ set view n for all clients

   Voice reminders:
   inline: BELL ( --- qWav) \ the bell
   inline: CRACK+ (qS --- qS1) \ add crystal wise crack
   inline: RBELL ( --- ) \ clang the bell
   inline: REM1 ( --- ) \ play reminder 1
   inline: REM2 ( --- ) \ play reminder 2
   inline: REM3 ( --- ) \ play reminder 3
   inline: REM4 ( --- ) \ play reminder 4
   inline: RPATH ( --- qPath) \ path to reminder voices
   inline: SET_REMINDERS ( --- ) \ set today's reminders

------------------------------------------------------------------------

   Notes
   
   Tue Apr 12 08:52:00 PDT 2011.  Review of how this file uses the 
   remote queuing system (see file task.v).

      These are the connected clients:
      % clients
       Server local is listening on port 9879
       Clients:
        socket 6, port 37099, conn S<C, 127.0.0.1 EU market console
        socket 7, port 37093, conn S<C, 127.0.0.1 SF market console
        socket 8, port 35544, conn S<C, 127.0.0.1 JY market console
        socket 9, port 35547, conn S<C, 127.0.0.1 CL market console
        socket 10, port 35551, conn S<C, 127.0.0.1 HG market console
        socket 11, port 35586, conn S<C, 127.0.0.1 GC market console
        socket 12, port 35555, conn S<C, 127.0.0.1 DJ market console
        socket 13, port 35557, conn S<C, 127.0.0.1 SP market console
        socket 14, port 35561, conn S<C, 127.0.0.1 NQ market console
        socket 15, port 35565, conn S<C, 127.0.0.1 US market console
        socket 16, port 35569, conn S<C, 127.0.0.1 TN market console
      %

      When a client connects, word CLIENT_OPN runs rmtrun_make to make
      one of the following words that will queue the client when new
      data is available:  
      % whos
       Stack items and words added to the main library:
        Name           Rows Cols Bytes Type  Description
        __10run        13   1    52    PTR   inline
        __11run        13   1    52    PTR   inline
        __12run        13   1    52    PTR   inline
        __13run        13   1    52    PTR   inline
        __14run        13   1    52    PTR   inline
        __15run        13   1    52    PTR   inline
        __16run        13   1    52    PTR   inline
        __6run         13   1    52    PTR   inline
        __7run         13   1    52    PTR   inline
        __8run         13   1    52    PTR   inline
        __9run         13   1    52    PTR   inline
        ...
      %

      The ptr to each of these words, like __13run, is in table 
      CLIENT_OPN.CLIENTS.

------------------------------------------------------------------------

   Tasks running and clients connected, midsession in about 43 minutes 
   (September 2011):

      % date . nl tasks
      Wed Sep 28 02:17:04 PDT 2011
       Multitasker tasks:
        NIST_DELTA,0:CODE__ alarm period 14400 seconds; remaining 7
        REM1,0:CODE__ alarm period 8700 seconds; remaining 776
        REM2,0:CODE__ alarm period 12300 seconds; remaining 4376
        REM3,0:CODE__ alarm period 15900 seconds; remaining 7976
        REM4,0:CODE__ alarm period 19500 seconds; remaining 11576
        SET_REMINDERS,0:CODE__ alarm period 86400 seconds; 
           remaining 78476
        UPDATED,0:CODE__ task running at 0.0625 Hz; tics remaining 28
        midsession_off,0:SET_REMINDERS alarm period 10470 seconds; 
           remaining 2546
        midsession_on,0:SET_REMINDERS alarm period 12360 seconds; 
           remaining 4436
        offline_check,0:CODE__ task running at 0.0111111 Hz; tics                  remaining 264
        queue_run,0:CODE__ task running at 0.125 Hz; tics remaining 42
        soundon,0:CODE__ alarm period 22978.8 seconds; remaining 765
      % 
      % clients
       Server local is listening on port 10402
       Clients:
        socket 6, port 50833, conn S<C, 127.0.0.1 EU market console 
        socket 7, port 50837, conn S<C, 127.0.0.1 SF market console 
        socket 8, port 50842, conn S<C, 127.0.0.1 JY market console 
        socket 9, port 50847, conn S<C, 127.0.0.1 US market console 
        socket 10, port 52156, conn S<C, 127.0.0.1 CL market console 
        socket 11, port 52158, conn S<C, 127.0.0.1 HG market console 
        socket 12, port 52160, conn S<C, 127.0.0.1 GC market console 
        socket 13, port 52162, conn S<C, 127.0.0.1 DJ market console 
        socket 14, port 50866, conn S<C, 127.0.0.1 SP market console 
        socket 15, port 50870, conn S<C, 127.0.0.1 NQ market console 
        socket 16, port 52164, conn S<C, 127.0.0.1 TN market console 
      %

------------------------------------------------------------------------

   Tasks running and clients connected (April 2010):

      % tasks
       Multitasker tasks:
        NIST_SYNC,0:CODE__ alarm period 14400 seconds; remaining 2376
        RBELL,0:CODE__ alarm period 1800 seconds; remaining 1667
        REM2,0:CODE__ alarm period 23100 seconds; remaining 3466
        REM3,0:CODE__ alarm period 26700 seconds; remaining 7066
        REM4,0:CODE__ alarm period 30300 seconds; remaining 10666
        SET_REMINDERS,0:CODE__ alarm period 86400 seconds; remaining 667
        UPDATED,0:CODE__ task running at 0.05 Hz; tics remaining 78
        offline_check,0:CODE__ task running at 0.0111111 Hz; tics remain
        queue_run,0:CODE__ task running at 0.1 Hz; tics remaining 1
      %

      % clients
       Server local is listening on port 9878
       Clients:
        socket 6, port 39041, conn S<C, 127.0.0.1 EU market console
        socket 7, port 37103, conn S<C, 127.0.0.1 SF market console
        socket 8, port 37108, conn S<C, 127.0.0.1 JY market console
        socket 9, port 37110, conn S<C, 127.0.0.1 DJ market console
        socket 10, port 37117, conn S<C, 127.0.0.1 SP market console
        socket 11, port 37122, conn S<C, 127.0.0.1 NQ market console
        socket 12, port 37126, conn S<C, 127.0.0.1 US market console
        socket 13, port 37138, conn S<C, 127.0.0.1 TN market console
        socket 14, port 37141, conn S<C, 127.0.0.1 CL market console
        socket 15, port 39032, conn S<C, 127.0.0.1 HG market console
        socket 16, port 37148, conn S<C, 127.0.0.1 GC market console
      %

------------------------------------------------------------------------

   Tasks running and clients connected (September 2009):

      % tasks
       Multitasker tasks:
       NIST_SYNC,0:CODE__ alarm period 86400 seconds; remaining 459
       SET_REMINDERS,0:CODE__ alarm period 64839 seconds; remaining
          56036
       UPDATED,0:CODE__ task running at 0.05 Hz; tics remaining 18
       offline_check,0:CODE__ task running at 0.0111111 Hz; tics 
          remaining 703
       queue_run,0:CODE__ task running at 0.1 Hz; tics remaining 15
      %

      % clients
       Server local is listening on port 9878
       Clients:
        socket 6, port 41454, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 7, port 41450, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 8, port 41452, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 9, port 41456, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 10, port 41462, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 11, port 41466, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 12, port 41468, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 13, port 41473, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 14, port 41482, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 15, port 41491, conn S<C, 127.0.0.1 LOGIN dale plunger
        socket 16, port 41493, conn S<C, 127.0.0.1 LOGIN dale plunger
      %

------------------------------------------------------------------------

      Fri Aug  7 10:15:22 PDT 2009
         Voices can go silent.  Could use word SNDSERVER_ON to periodi-
         cally verify that sound queue file server is running.  If not, 
         use macros KILL_SNDSERVER and START_SNDSERVER in QSTART to kill
         and restart it, and then run phrase
            '"auto" "CONN_SND" localrun' setclients_all
         to have the clients reconnect to it.

         But: There may be little need to check SNDSERVER_ON if I stop 
         messing with it and making it crash.  Left alone, SNDSERVER 
         has never crashed.
}
\-----------------------------------------------------------------------

\  Load resource files

   "HOME" env chdir

   CATMSG push no catmsg

   "queue_run" missing IF "task.v" source no QHALT THEN
   "hupdated" missing IF "mrc.v" source THEN \ eventually sources mfil.v

   fence
   pull catmsg 1based private

\-----------------------------------------------------------------------

\  Words

   CATMSG push no catmsg

   inline: ... ; ( --- ) \ do nothing for habitual ... from console

   inline: ALL_MKT ( --- hT) \ table of all client symbols
    \ Fri Mar 18 07:21:16 PDT 2011
      [ "eu sf jy cl hg gc dj sp nq us tn" words chop "T" book ] T 
   end

   inline: CLIENT_CLS (nS --- ) \ tasks when a client disconnects
\     When this word runs, the client on S has just now closed.

      "S" book
      S sclose \ make sure socket is dead

      " CLIENT_CLS: client on socket " S intstr + " has closed " + 
      date + . nl

      "CLIENT_OPN" "CLIENTS" yank "A" book

    \ Remove row for S from CLIENT_OPEN.CLIENTS list, now in A.
    \ Table lookup in A[*,3] to find which row in A contains S, then 
    \ removing that row from A:
      A 3rd catch 1st over rows items park yes sort (hXY) \ lookup table
      (hXY) yes sort (hXY)           \ first column sorted
      (hXY) dup S bsearch (s f)      \ find S in XY[*,1] at row s
      IF (hXY s) 2nd fetch (r)       \ fetch row r from XY[s,2] 
         (r) A swap A rows teeth     \ make a rake for row r of A
         (hA hRake) rake lop (hA1)   \ rake out row r
         "CLIENT_OPN" "CLIENTS" bank \ bank new table
      ELSE (hXY r) 2drop " CLIENT_CLS: socket " S intstr + 
         " not found in CLIENTS list" + . nl
      THEN 
   end

   inline: CLIENT_DATA (qMkt --- purged or Pt) \ fetch P(t) for Mkt
{     Fetch data from the client that runs MKT.

      Columns in returned MAT Pt = [ P , tg , tm] contain the following:
         P = model defined by the struct of daysget.P (see mobius.n)
         tg = graph time steps (sec), when P(t) is displayed
         tm = machine time (sec), used for actual date and time
}
      strchop "MKT" book
      CLIENT_SKT (hT) dup 2nd word 
      IF (hT hT1) MKT uppercase grepe any?
         IF (hT hRow) @ reach numerate @ (nSocket) "S" book

          \ Run these phrases on the client to make the data array:
            "P G-UNSCALE t dup tm 3 parkn "  \ data array [P, tg, tm]
          \ "1st t time rnow items reach " + \ remove future rows

          \ Add this phrase to make the client return the array, as 
          \ required by word remoterun1:
            "remotefd remoteput" + (qT)

            (qT) S remoterun1 (hPt)

         ELSE (hT) drop " CLIENT_DATA: " MKT + " not found" + . nl
            purged
         THEN
      ELSE (hT) drop " CLIENT_DATA: data error from CLIENT_SKT" . nl
         purged
      THEN
   end

   inline: CLIENT_DATA1 (qMkt --- hNames) \ fetch MKT fbooked file names
\     Fetch the file names (fbook.Fnames) from the client that runs MKT.

      "MKT" book
      CLIENT_SKT (hT) dup 2nd word
      IF (hT hT1) MKT uppercase grepr any?
         IF (hT hRow) @ reach numerate @ (nSocket) "S" book
          \ Run this phrase on the client:
            "'fbook' 'Fnames' yank remotefd remoteput" S remoterun1 
         ELSE (hT) drop " CLIENT_DATA1: " MKT + " not found" + . nl
            VOL tpurged
         THEN
      ELSE (hT) drop " CLIENT_DATA1: data error from CLIENT_SKT" . nl
         VOL tpurged
      THEN
   end

   inline: CLIENT_OPN (qMKT nS --- ) \ tasks when a new client connects
{     This word is run by the connecting client that wants graphics
      updates.  For example, see word auto in mobius.n.
 
      Word UPDATED uses binary search on MKT names in column 1 of this
      word's array CLIENTS.  This means there should be no duplicate 
      MKT names, i.e., a second instance of the same market should not
      be allowed to connect--but this is not checked.
}
      [
       \ CLIENTS table is a MAT of 4 columns: 
       \    1 is MKT symbol, 2 is ptr, 3 is S, 4 is time
         0 4 null "CLIENTS" book 
      ]
      remotesockets rows 1 = 
      IF queue_clr no QHALT THEN \ clr if first client

      (nS) "S" book
      " CLIENT_OPN: new client on socket " S intstr + . nl

      (qMKT) strchop "MKT" book

    \ Make a new word that runs word TGRAPH_SET on the client:
      "TGRAPH_SET" S rmtrun_make (ptr) 

    \ Bank string MKT into the new word, which is handy later to see
    \ what market the word is connected to:
      (ptr) MKT over (ptr) ptrtok notag (qWORD) "MKT" bank

    \ Make the row for the CLIENTS table:
      (ptr) MKT str2num swap
      (nMKT ptr) S 0 4 listn bend (hR) \ a row for the CLIENTS table

    \ Run CLIENT_CLS when S closes:
      "CLIENT_CLS" ptr "svrqueue_rm" "PTR" bank

      (hR) CLIENTS pile yes sort "CLIENTS" book

      -1 "S" book
   end

   inline: CLIENT_SKT ( --- hT) \ list of sockets and client names
      "CLIENT_OPN" "CLIENTS" yank 3rd catch 
      "CLIENT_OPN" "CLIENTS" yank 1st catch park yes sort any?
      IF dup 1st catch itext spaced swap 2nd catch mat2vol words + neat
      ELSE VOL tpurged
      THEN
   end

   inline: clients_close ( --- ) \ close all clients who connected
      [ no "EXITING" book ]

      remotesockets (hS) any? \ clients who connected to this server
      IF (hS) EXITING not
         IF " clients_close: are you sure?  Say yes. > " query nl
            "yes" <> IF (hS) drop return THEN
         THEN
         (hS)

         0 "svrqueue_rm" "PTR" bank \ disable CLIENT_CLS
         "UPDATED" SLEEP   \ no updating 
         "queue_run" SLEEP \ no queuing

         soundoff \ sound will be off when client starts up
         scqoff   \ SCQ will be off when client starts up     
         "soundon" -ALARM

         (hS) these rows 1st
         DO "remotefd sclose two 'exit' ALARM"
            that I pry (S)
            remoterun \ the program running on S(I) will exit
         LOOP (hS) drop

         BEGIN remotesockets rows 0<> 
            WHILE remotesockets 1st pry sclose
         REPEAT

         "CLIENT_OPN" "CLIENTS" 2dup yank cols 0 swap null rev bank

       \ Trim the signal log file used by all the clients:
         -SIG-LOG

         "UPDATED" WAKE
         "queue_run" WAKE
      THEN
   end

   inline: client_offline (qMkt --- ) \ client for Mkt is going off line
      uppercase strchop "MKT" book
      "CLIENT_OPN" "CLIENTS" yank (hA) dup MKT str2num bsearch (r f)
      IF (hA i) time rev 4 ndx (time hA i j) store
      ELSE " client_offline: client for " MKT + " not found" + . nl
         (hA i) 2drop
      THEN
   end

   inline: client_online (qMkt --- ) \ client for Mkt is back on line
      uppercase strchop "MKT" book
      "CLIENT_OPN" "CLIENTS" yank (hA) dup MKT str2num bsearch (r f)
      IF (hA i) 0 rev 4 ndx (0 hA i j) store
      ELSE " client_online: client for " MKT + " not found" + . nl
         (hA i) 2drop
      THEN
   end

   inline: E_off ( --- ) \ key E off for all clients
   \ Thu Sep  9 17:05:21 PDT 2010. 
      "no 'pExpose1' 'GRIDtop' bank" setclients_all
   end

   inline: E_on ( --- ) \ key E on for all clients
   \ Thu Sep  9 17:05:21 PDT 2010. 
   \ Key E toggles the flag that puts spaced grid lines on top.  
   \ Initially, spaced grid lines are not on top.
      "yes 'pExpose1' 'GRIDtop' bank" setclients_all
   end

   inline: mdoy ( --- ) \ run DOY msource on file mobius.n
    \ Sun Sep  5 11:20:53 PDT 2010
    \ Must have "DOY ... halt" present in mobius.n
      "'mobius.n' 'DOY' msource" setclients_all
   end

   inline: MKT_ALARM (qMKT --- ) \ offline warning for MKT
      SNDSERVER 0< IF drop return THEN

      strchop "MKT" book
      " MKT_ALARM: warning, " MKT + " is off line" + . nl
      IPloop SNDSERVER CLIENT dup -1 >
      IF "S" book
         '"RING" "MAKEFILE" yank wavque_add' (hT1)

         MKT lowercase quoted (qS1)
         ' "warning+offline" "" "" 1 vSig wavque_add' (qS2)
         (qS1 qS2) + (hT2) 

         (hT1 hT2) pile (hT) dup pile (hT) \ say it a second time
         (hT) S remoterun
         S sclose
      ELSE drop " MKT_ALARM: cannot connect to SNDSERVER for " MKT +
         . nl
      THEN
   end

   inline: mob ( --- ) \ run msource on file mobius.n
    \ Sun Sep  5 11:20:53 PDT 2010
    \ Keyword and halt for msource must already be set in file mobius.n;
    \ see word mob in file mobius.n.

      " mob: turning sound off for all clients" . nl
      30 (sec) 3600 / soundon_alarm 5 idle
      "mob" setclients_all
   end

   inline: offline_check ( --- ) \ test elapsed time of clients off line
    \ If a client has been off line for more than TMAX seconds, sound
    \ an alarm.

      [ 180 "TMAX" book ]

      "CLIENT_OPN" "CLIENTS" yank dup rows 0= IF drop return THEN
      "T" book

      T rows 1st
      DO T I 4 ndx fetch (toff f) any? \ test the time against TMAX
         IF (toff) time swap - (dt) TMAX >
            IF T I 1 fetch num2str (qMKT) \ name of market
               (qMKT) MKT_ALARM           \ sound a warning alarm
            THEN
         THEN
      LOOP

      purged "T" book
   end

   inline: qconset ( --- ) \ source a file of settings for clients
      usrpath "qconset.v" + source 
   end

   inline: QSTART ( --- ) \ runs at start up
      [ -1 "QPORT" book \ port for window update queue

        30 "VSEC" book \ check for excessive voice messages

      \ 30 "QSEC" book \ queue period
      \ 20 "QSEC" book \ queue period (10-06-2008, see if less stress)
      \ 10 "QSEC" book \ queue period (6-21-2009; try with new memory)

      \ Sun Aug 29 16:13:49 PDT 2010.  Sigmodel() needs a lot of memory 
      \ when updating:
      \ 30 "QSEC" book \ queue period (8-29-2010: due to large mem req)

      \ Fri Sep 10 04:07:18 PDT 2010.  Back to small model, so use quick
      \ update:
      \ 10 "QSEC" book \ queue period (6-21-2009; try with new memory)
      \ 20 "USEC" book \ check for updates
      \ 60 "USEC" book \ check for updates

      \ Tue Sep 13 08:24:12 PDT 2011
        8 "QSEC" book \ queue period 
        16 "USEC" book \ check for updates
      ]
    \ Start locally a queue server for real time updates:
      QPORT -1 = 
      IF "" def_port nextport dup "QPORT" book SERVER
         "RTSERVER" msgGet drop         \ remove old port
         QPORT intstr "RTSERVER" msgPut \ put new port
         queue_clr no QHALT

       \ Start the queue server:
         1 QSEC / "queue_run" PLAY
         " QSTART: window update queue server started" . nl

       \ Start the function that periodically checks for updated MKTs
       \ and queues clients that have updated history files:
         1 USEC / "UPDATED" PLAY

       \ Start the function that periodically checks clients that have
       \ gone off line:
         1 "offline_check" "TMAX" yank 2 / / "offline_check" PLAY
      ELSE
         " QSTART: window update queue server is running" . nl
      THEN

      14400 "NIST_DELTA" "SEC" bank \ sync time every 4 hours
      NIST_DELTA                    \ sync time now

      -SIG-LOG \ trim the signal log file used by all the clients
      1 VSEC / "VCUTOFF" PLAY \ start voice queue monitor

    \ Tue Sep 20 04:50:22 PDT 2011.  Up and at 'em.  No dark screens:
      no psave
   end

   inline: R_off ( --- ) \ key R off for all clients
   \ Thu Sep  9 17:05:21 PDT 2010.  
      "no 'pExpose1' 'CROSStop' bank" setclients_all
   end

   inline: R_on ( --- ) \ key R on for all clients
   \ Thu Sep  9 17:05:21 PDT 2010.  
   \ Key R toggles the flag that puts moving crosshair grid lines on 
   \ top.  Initially, these grid lines are not on top.
      "yes 'pExpose1' 'CROSStop' bank" setclients_all
   end

   inline: setclients (qSet hMKT --- ) \ make setting for MKT clients
\     Incoming Set is a quote string to be run on clients listed in MKT.
      words "MKT" book
      "SET" book

      "CLIENT_OPN" "CLIENTS" yank (hT)
      (hT) dup 1st catch bend mat2vol "N" book \ names
      (hT) 3rd catch "S" book \ sockets

      MKT rows 1st
      DO N MKT I quote uppercase grepr any? (0 or hR -1)
         IF SET (qS)
            S rot (hR) reach (hS) remoterun
         ELSE " setclients: market " MKT I quote strchop +
            " is not a client" + . nl
         THEN
      LOOP
      purged "N" book
      purged "S" book
      purged "MKT" book
   end

   inline: setclients_all (qSet --- ) \ make setting on all clients
      CLIENT_SKT 1st word 
      IF (hT) numerate (hS) any?
         IF (qSet hS) remoterun
         ELSE (qSet) drop
         THEN
      ELSE (qSet) drop
      THEN
   end

   inline: setkeys ( --- ) \ source tgraph() with new changes to keys
    \ Aug 18 07:58:41 PDT 2011

    \ Changes tgraph() on all clients.

    \ Includes changes made to colors, since they are defined in the
    \ library of word tgraph().

      " setkeys: turning sound off for all clients" . nl
      30 (sec) 3600 / soundon_alarm 5 idle
      "setkeys" setclients_all
   end

   inline: scancel ( --- ) \ cancel ALERTS file stops on all clients
      "scancel" setclients_all ;

   inline: scqoff ( --- ) \ turn off scq alert on all clients
      "no scq" setclients_all
   end

   inline: scqon ( --- ) \ only scq alerts on all clients
      soundoff
      "yes scq" setclients_all
   end

   inline: SOCKETS_OFF ( --- ) \ leave sockets connected but unread
    \ Fri Jan 27 04:25:08 PST 2012.  See if setting "no SELECT" stops
    \ hangups of clients trying to run client_offline:

      "CLIENT_OPN" "CLIENTS" yank 3rd catch (hS) any?
      IF (hS) dup rows 1st DO dup I pry no SELECT LOOP (hS) drop
      THEN
   end

   inline: SOCKETS_ON ( --- ) \ allow sockets to be read
    \ Fri Jan 27 04:25:08 PST 2012.  

      "CLIENT_OPN" "CLIENTS" yank 3rd catch (hS) any?
      IF (hS) dup rows 1st DO dup I pry yes SELECT LOOP (hS) drop
      THEN
   end

   inline: soundoff ( --- ) \ turn off sound signals on all clients
      SNDSERVER 0>
      IF remote_wavque_clr \ empty the queue to stop upcoming talkers
      THEN
      "no sig, wcqreset, no rngset, yes scq" setclients_all
   end

   inline: soundon ( --- ) \ turn on sound signals for all clients
      qconset
      "yes sig" setclients_all
      "yes scq" setclients_all

    \ Wed May  4 04:20:53 PDT 2011.  Make connection to sound server:
      '"auto" "CONN_SND" yank' setclients_all 

    \ Tue Sep 20 04:50:22 PDT 2011.  Up and at 'em.  No dark screens:
      no psave
   end

   inline: soundon_alarm (nHrs --- ) \ set soundon alarm for nHrs hours
\     Turn off voices and set alarm to turn back on in nHrs hours.
      no NUM stkok not IF "soundon_alarm" stknot return THEN
      soundoff (nHrs) 3600 * (nSec) dup "soundon" ALARM
      " soundon_alarm: sound will be back on at " .  (nSec) time + 
      ctime . nl
   end

   inline: tog (n --- ) \ set view n for all clients
    \ Mon Apr 25 18:30:37 PDT 2011
    \ Synonym for view_all.
      (n) view_all
   end

   inline: trackoff (hMKT --- ) \ turn off tracking for MKT clients
\     Example:
\        trackon_all, "eu gc us nq" trackoff
      "no track" (qS) swap (qS hMKT) setclients
   end

   inline: trackoff_all ( --- ) \ turn off tracking on all clients
      "no track" setclients_all
   end

   inline: trackon (hMKT --- ) \ turn on tracking for MKT clients
\     Example:
\        trackoff_all, "eu gc us nq" trackon
      "yes track" (qS) swap (qS hMKT) setclients
   end

   inline: trackon_all ( --- ) \ turn on tracking for all clients
      "yes track" setclients_all
   end

   "uclean_tiny" missing
   IF
\  This should match a version in file qcon, and not be needed here
\  unless this file has not been sourced by qcon.
   inline: uclean_tiny ( --- ) \ uclean will run this on exit
      [ mpath "qcon.lock" + "LOCKFILE" book ]
   \  Delete this job's lock file:
      LOCKFILE deleteif

   \  Cleanup to do if qcon.v has been sourced and QSTART has been run:
      "msgGet" exists?
      IF "RTSERVER" msgGet drop \ remove RTSERVER port from msgcomm
         "QSTART" exists? \ qcon.v has been sourced
         IF yes "clients_close" "EXITING" bank
            clients_close \ close all client windows
         THEN
      THEN
   end
   THEN

   inline: VCUTOFF ( --- ) \ cut voice messages if there are too many
    \ Fri Oct  7 07:00:50 PDT 2011
      [ 18 "VMAX" book, 5 "SEC" book ]

      remotesockets rows any not IF return THEN 
      SNDSERVER 0< IF return THEN
      LOCKED IF return THEN

    \ Sat Feb 25 14:05:24 PST 2012.  Turn sound off and return if not
    \ collecting:
      soonest_task not IF soundoff return THEN

      remote_wavque_len (n) dup VMAX > 
      IF (n)
       \ Fri Jan 27 04:25:08 PST 2012.  See if setting SELECT stops
       \ the hangups of clients trying to run client_offline:
         SOCKETS_OFF

         (n) remote_wavque_clr SEC idle \ idle is bad; is it necessary?

         (n) " VCUTOFF: " swap intstr + 
         " previous messages not played " + date + (qM)

         (qM) SYSOUT SIG-LOG set_sysout \ vector output to SIG-LOG
         (qM qSYSOUT) swap . nl         \ print message in SIG-LOG
         (qSYSOUT) set_sysout           \ vector output back to SYSOUT

       \ Give notice that messages were not played (they are still in
       \ log SIG-LOG):
         RPATH "mike_excessive_messages.wav" + remote_wavPlayq

         SOCKETS_ON
      ELSE (n) drop
      THEN
   end

   inline: UPDATED ( --- ) \ queue updated market windows
\     Uses bsearch on market names in CLIENT_OPN.CLIENTS, which implies
\     that each socket is for a differently named market.  Word set-
\     clients uses grepr to get around this problem.

      "CLIENT_OPN" "CLIENTS" yank rows 0= 
      LOCKED or
      IF return THEN

      hupdated (hMKT) any?
      IF "CLIENT_OPN" "CLIENTS" yank "T" book
         T rows 0= IF (hMKT) drop return THEN

       \ Fri Jan 27 04:25:08 PST 2012.  See if setting SELECT stops
       \ hangups of clients trying to run client_offline:
         SOCKETS_OFF

         (hMKT) vol2mat bend dup rows 1st
         DO (hMKT) T over I pry (hT n) bsearch (r f) 
            IF (r) T swap 2nd (T r 2nd) fetch (ptr) queue_add1
{
   The following does what queue_add1 (above) now does, to add ptr
   to queue only if there already isn't one waiting:
               queue_len 0>
               IF (ptr) "queue_run" "queue" yank yes sort (hQ)
                  (ptr hQ) over bsearch lop not \ not in queue?
               ELSE true
               THEN (f)
               IF (ptr) queue_add \ add ptr(r) to queue
               ELSE (ptr) drop
               THEN
}
            ELSE (r) drop
            THEN
         LOOP

         (hMKT) drop
         queue_len 0>
         IF " UPDATED queue: " (qS)
            "queue_run" "queue" yank dup push rows 1st
            DO peek I pry ptrtok notag "MKT" yank spaced + LOOP 
            pull drop
         ELSE " UPDATED queue: empty "
         THEN
         (qS) date + (qS) COLS sp .out nl

       \ Fri Jan 27 04:27:44 PST 2012.  Allow sockets to be read again:
         SOCKETS_ON

      THEN
   end

   inline: view_all (n --- ) \ set view n for all clients
    \ n corresponds to a word in tgraph, like tgraph.3ON for n = 3.
      no NUM stkok not IF "view_all" stknot return THEN
      (n) intstr " tgraph_view" + setclients_all
   end
   
\-----------------------------------------------------------------------

\  Voice and bell reminders.  These words assume the sound file server
\  is running (SNDSERVER 0> is true).

   seedt \ reset random seed

   inline: BELL ( --- qWav) \ the bell
      RPATH "bong1.wav" + 
   end

   inline: CRACK+ (qS --- qS1) \ add crystal wise crack
      urn 0.5 < \ 50% chance of wise crack
      IF urn 0.7 <
         IF RPATH "crystal_hitthat.wav" +  \ 0.5*70% this one
         ELSE RPATH "crystal_period.wav" + \ 0.5*30% this one
         THEN pile
      THEN
   end

   inline: RBELL ( --- ) \ clang the bell
      BELL remote_wavPlayq
   end

   inline: REM1 ( --- ) \ play reminder 1
      RPATH "crystal_1reminderH.wav" + 
      BELL pile 
      remote_wavPlayq
      1800 "RBELL" ALARM \ bell in 30 minutes
   end

   inline: REM2 ( --- ) \ play reminder 2
      RPATH "crystal_2reminderH.wav" +
      CRACK+
      BELL pile 
      remote_wavPlayq
      1800 "RBELL" ALARM \ bell in 30 minutes
   end

   inline: REM3 ( --- ) \ play reminder 3
      RPATH "crystal_3reminderH.wav" +
      CRACK+
      BELL pile 
      remote_wavPlayq
      1800 "RBELL" ALARM \ bell in 30 minutes
   end

   inline: REM4 ( --- ) \ play reminder 4
      RPATH "crystal_4reminderH.wav" +
      CRACK+
      BELL pile 
      remote_wavPlayq
      1800 "RBELL" ALARM \ bell in 30 minutes
   end
   
   inline: RPATH ( --- qPath) \ path to reminder voices
      [ mpath "voices/signal8/" + "PATH" book ] PATH
   end

   inline: SET_REMINDERS ( --- ) \ set today's reminders
    \ Set voice reminders that announce on days Monday through Friday.  

    \ Times are local for a machine running in the Pacific coast time 
    \ zone.

      [ 
        "soundoff" "midsession_off" macro
        "soundon"  "midsession_on"  macro
      ]

      date sysdate drop weekday 1 > \ Sat=0, Sun=1, Mon-Fri=2-6
      IF 
       \ Reminders around midsession, which is at 3 AM Pacific time:
         "02:30:00" todayat "REM1" ALARM
         "03:30:00" todayat "REM2" ALARM
         "04:30:00" todayat "REM3" ALARM
         "05:30:00" todayat "REM4" ALARM
 
       \ Mon Apr 11 03:41:56 PDT 2011.  Control chatter from electronic
       \ consoles when high and low reset at midsession: 
         "02:59:30" todayat \ voices off 
         "SET_REMINDERS" "midsession_off" localref ALARM
         "03:31:00" todayat \ voices back on
         "SET_REMINDERS" "midsession_on" localref ALARM
 
      THEN
    \ Run again after midnight:
      "24:05:00" todayat "SET_REMINDERS" ALARM
   end

 \ Set the upcoming day's reminders at a little past midnight:
   "24:05:00" todayat "SET_REMINDERS" ALARM
{
 \ Saving and testing bong1.wav for RBELL:
      "snd.v" source
      1 BONG (qFile) "/mdat/voices/bong1.wav" fcopy

    \ Testing:
      "/mdat/voices/bong1.wav" remote_wavPlayq

 \ Wed Feb 10 07:50:31 PST 2010
 \ Increasing the volume of reminder voice files:
      "wavData" missing IF "snd.v" source THEN

      "/mdat/voices/crystal_1reminder.wav" wavData (hT hH)
      swap vmax16 swap wavFile1 (qWav)
      (qWav) "/mdat/voices/crystal_1reminderH.wav" fcopy

      "/mdat/voices/crystal_2reminder.wav" wavData (hT hH)
      swap vmax16 swap wavFile1 (qWav)
      (qWav) "/mdat/voices/crystal_2reminderH.wav" fcopy

      "/mdat/voices/crystal_3reminder.wav" wavData (hT hH)
      swap vmax16 swap wavFile1 (qWav)
      (qWav) "/mdat/voices/crystal_3reminderH.wav" fcopy

      "/mdat/voices/crystal_4reminder.wav" wavData (hT hH)
      swap vmax16 swap wavFile1 (qWav)
      (qWav) "/mdat/voices/crystal_4reminderH.wav" fcopy
} 
   pull catmsg

   private halt

\-----------------------------------------------------------------------

Appendix

\  Below is an example of fetching information from each client.

\  This shows the expose state of each graph.  When no graph has focus,
\  all states should be zero.  This was used to find a couple of win-
\  dows that always had focus, so every update also updated the graph
\  which drove the workload much higher.  Mrtim.n was changed to fix
\  the problem.
   list:                                            \
      '"pExpose1" "expose" yank remotefd remoteput' \
      remotesockets remoterun1                      \
   end                                              \
   remotesockets swap                               \
   park

\  Operation question: How did UDEF accumulate?
Wed May  7 11:33:35 PDT 2008 SERVER: 127.0.0.1 connect
 128 bytes delta: memprobe socket 6 connect
 CLIENT_OPN: new client on socket 6
CLIENT_SKT .
6  EU
6  UDEF
6  UDEF
6  UDEF
6  UDEF
6  UDEF
7  SF
8  JY
9  DJ
10 SP
11 NQ
12 US
13 TN
14 CL
15 NG
16 SB
17 HG
18 GC
19 SI
20 PL
21 C
22 W
23 S
24 CT
