/* File mrtsig.n  August 2008

   Copyright (c) 2008-2011   D. R. Williamson

   Market real time data analysis and signals, using graphed data from 
   currently running clients of the real time queue controller (qcon.v).

   Clients of the real time queue controller use file mobius.n, and this
   file sources portions of mobius.n for words to use.

   Use psource to load this file: "mrtsig.n" psource.  After this file
   is sourced, any market console that is connected to the real time
   queue controller can be studied here by running one of the words 
   mktdata(), mktget() or mktlib().

------------------------------------------------------------------------

   Words

   usrpath "mrtsig.n" + asciiload this " inline:" grepr reach dot
   usrpath "mrtsig.n" + asciiload this " function " grepr reach dot

   inline: Button1 (hXY --- ) \ display values for location in graph
   inline: mktdata (qMKT --- hP htg tm) \ local data P(t) for MKT
   inline: mktget (qMKT --- hPurged | hP htg htm) \ get P(t) for MKT
   inline: mktlib (qMKT --- ) \ fbook P(t) for MKT
   inline: qconCLOSE ( --- ) \ close the connection to the qcon server
   inline: qconCONNECT ( --- ) \ connect to the qcon server
   inline: qconS ( --- nS) \ socket of the qcon server connection
   inline: QMKTS ( --- ) \ queue all markets to be updated
   inline: QSTART ( --- ) \ run at start up only
   inline: tgraph (hP ht --- ) \ make graph of P(t)
   inline: x11 X11 ; \ on non-X11 machines, this word must return no

----------------------------------------------------------------------*/

<<
   "HOME" env chdir
   CATMSG push no catmsg

 \ The following line sources the POSTFIX region of this file only
 \ once:
   "mktdata" missing 
   IF usrpath "mrtsig.n" + "#def POSTFIX" "#end POSTFIX" msource1 THEN
>>

//----------------------------------------------------------------------

// Infix words.

/* Example:
   function (f) = crossover(X, Y) { // +1, 0, or -1 when X crosses Y
   /* Flag f is +1 when X crosses above Y, -1 when X crosses below Y,
      and 0 otherwise. */
   // Also see word separate().
      { eps = 1E-6; }
      f1 = X>(Y1=Y+eps);
      f2 = X<Y1;
      f = abs((f1 && lag(f2, 1))) + (f2 && lag(f1, 1));
      f1 = f2 = Y1 = 0;
   }
*/

   << pull catmsg 1based private >> // finished sourcing

/*----------------------------------------------------------------------

// Postfix words.

#def POSTFIX

   CATMSG push no catmsg

   "queue_run" missing IF "task.v" source no QHALT THEN

   inline: x11 X11 ; \ on non-X11 machines, this word must return no

x11
IF
\  Plotting.

   "plotWCB" missing
   IF "plot.v" source
      pgrid_off graphpair \ initial settings
   THEN

   1 (nLineWidth) LineSolid plotGCattrib \ line width

\  Window size and placement:
{
\  Tall and skinny:
   390 plotWCB wcb.w poke \ window width
   500 plotWCB wcb.h poke \ window height
   1 plotWCB wcb.typ poke \ only doing traces, so use speedy linet
   400 plotWCB wcb.x poke \ upper left corner at x on screen
   0 plotWCB wcb.y poke \ upper left corner at y on screen
}
\  Short and wide:
   786 plotWCB wcb.w poke \ window width
   440 plotWCB wcb.h poke \ window height
   1 plotWCB wcb.typ poke \ only doing traces, so use speedy linet
   0 plotWCB wcb.x poke \ upper left corner at x on screen
   0 plotWCB wcb.y poke \ upper left corner at y on screen

\  Left button function:
   inline: Button1 (hXY --- ) \ display values for location in graph
\     Display the XY values corresponding to cursor location in graph.

\     If X is a time from vector t, convert X to Chicago date from UTC 
\     time in vector tm, so it matches the times displayed by mobius.n.

      dup CB_PUSH \ push XY to clipboard for possible use by xyzoom

      "'tm' exists? 't' exists? and" main (f)
      IF (hXY)
         "tm" main "t" main other 1st pry (htm ht x) bsearch (r f) drop
         (htm r) pry (hXY nt)

       \ Time into CT to match market graphs (taken from csr_str.xdate, 
       \ file mobius.n):
         (nt) "tX" book
         tX dup CHdiff1 + gmtime (nsec) \ date and time in Chicago
         (nsec) sysdate clocko >SEC (nYYYMMDD nsec)
         (nsec) time_breakdown 1st 5 items catch \ HH:MM like 21:43
         tX CHdiff1 -3600 / 6 =
         IF " CST " ELSE " CDT " THEN + (qHH:MM) swap
         (nYYYMMDD) date4$ (qDate) +

         swap (hXY) 2nd pry " %8.4f " format + (qXY)

      ELSE (hXY) bend " x, y: %8.4f, %8.4f " format (qXY)

      THEN (qXY) nl . sp cprompt . \ show console prompt
   end
\  Set pButton.Button1 = ptr("Button1"):
   "Button1" ptr "pButton" "Button1" bank \ left button function

   "z" -ALARM \ no plot animation
THEN

   fence

\  Load the struct for model matrix P, the matrix returned by words
\  mktget (fetches from qcon server) and mktdata (fetches locally):
   usrpath "mobius.n" + "#def P struct" "#end P struct" msource1

\  Load rdech() for converting hours to steps:
   usrpath "mfil.v" + "#def rdech" "#end rdech" msource1

   inline: mktdata (qMKT --- hP htg tm) \ local data P(t) for MKT
\     Fetch data fbooked earlier by word mktlib.
      strchop uppercase (qMKT)
      (qMKT) dup exists? (f)
      IF (qMKT) dup 
         (qMKT) "_P.bin" + main (hP) swap dup 
         (qMKT) "_tg.bin" + main (htg) swap
         (qMKT) "_tm.bin" + main (htm) 
      ELSE " mktdata: library for " swap + " not found" + . nl
         purged 
      THEN
   end

   inline: mktget (qMKT --- hPurged | hP htg htm) \ get P(t) for MKT
{     Fetch data from the client of the qcon server that runs MKT.

      Returned matrices contain the following:
         P = model defined by the struct of daysget.P (see mobius.n)
         tg = graph time steps (sec), when P(t) is displayed
         tm = machine time (sec), used for actual date and time
}
      [ list: 0 1 ; "tsep" book ]
      qconS -1 >
      IF (qMKT) quoted " CLIENT_DATA remotefd remoteput" + (hT)
         qconS remoterun1 (hPt) any?
         IF (hPt)
          \ Separate the time columns from Pt = [P , tg , tm] (see 
          \ word CLIENT_DATA in qcon.v):
            (hPt) 1st over cols 2 - items over cols teeth 
            (hPt hRake) claw (hP ht) tsep claw (hP htg htm) 
         ELSE " mktget: market not found" . nl purged
         THEN
      ELSE (qMKT) qconCONNECT qconS -1 > \ connect to server
         IF (qMKT) mktget (hP htg htm)   \ and then re-enter
            qconCLOSE
         ELSE (qMKT) drop purged
         THEN
      THEN
   end

   inline: mktlib (qMKT --- ) \ fbook P(t) for MKT
\     Make MKT word and load its library.  
      [ "/tmp1/" "fbook" "path" bank ]
      strchop uppercase "MKT" book

      MKT mktget any?
      IF (hP htg htm) 
         MKT exists? not (f)
         IF MKT library THEN
         (hP htg htm) 

       \ fbook MAT tm, then bank the fbook inline PTR into MKT.tm;
       \ later, running MKT.tm will put MAT tm on the stack:
         (htm) MKT "_tm.bin" + dup (qName) rev fbook
         (qName) libpry MKT "tm" bank

         (htg) MKT "_tg.bin" + dup (qName) rev fbook
         (qName) libpry MKT "tg" bank

         (hP) MKT "_P.bin" + dup (qName) rev fbook
         (qName) libpry MKT "P" bank

         noclip \ nullify any plot clipping
      ELSE " mktlib: no data for market " MKT + . nl
      THEN
   end

   inline: qconCLOSE ( --- ) \ close the connection to the qcon server
      qconS dup -1 >
      IF (nS) sclose -1 "qconCONNECT" "S" bank
      ELSE drop
      THEN
   end

   inline: qconCONNECT ( --- ) \ connect to the qcon server
      [ -1 "S" book ]
      S -1 =
      IF "RTSERVER" msgPeek any? \ qcon server PORT is on msgcomm
         IF (qPORT) IPloop swap number drop (qIP nPORT)
            (qIP nPORT) CLIENT "S" book
            S -1 >
            IF S socket_ack IF return THEN
               " qconCONNECT: ack failed on socket " S intstr + 
            ELSE " qconCONNECT: connection to real time server failed" 
            THEN 
         ELSE " qconCONNECT: real time server not found" 
         THEN 
      ELSE " qconCONNECT: real time server is already connected"
      THEN . nl
   end

   inline: qconS ( --- nS) \ socket of the qcon server connection
\     S = -1 if qcon server is not connected
      "qconCONNECT" "S" yank
   end

   inline: QMKTS ( --- ) \ queue all markets to be updated
    \ Wed Aug 25 19:19:11 PDT 2010

    \ Fri Mar 18 07:51:12 PDT 2011.  Get list MKTS from RTSERVER list 
    \ called ALL_MKT.

      [ 900 "SEC" book "" "MKTS" book ]
      MKTS any?
      IF lowercase words right justify "_run" tail (hW) \ words to queue
         (hW) dup rows 1st
         DO (hW) dup I quote (qW) dup exists? \ word in main lib?
            IF MKTS I quote uppercase (qMKT) exists? \ MKTlib in main 
               IF (qW) ptr queue_add1 \ queue update of existing MKTlib
               ELSE (qW) drop         \ no such MKTlib
               THEN
            ELSE (qW) drop
            THEN
         LOOP (hW) drop
      ELSE \ get list of markets from RTSERVER (qcon): 
       \ Connect to RTSERVER:
         qconS -1 = IF qconCONNECT yes ELSE no THEN "SCLOSE" book
         qconS -1 = 
         IF " QMKTS: cannot connect to RTSERVER" . nl 
         ELSE \ fetch ALL_MKT list:
            "ALL_MKT remotefd remoteput" qconS remoterun1 (hT)
            (hT) any? IF (hT) "MKTS" book THEN 
            SCLOSE IF qconCLOSE THEN
            QMKTS \ reenter and use the new MKTS list
         THEN
      THEN

      SEC "QMKTS" ALARM \ run again in SEC
   end

   inline: QSTART ( --- ) \ run at start up only
    \ Wed Aug 25 19:06:09 PDT 2010

      [ 30 "SEC" book ] \ run next task in queue

      1 SEC / "queue_run" PLAY \ start the queue
   end

x11
IF
   inline: tgraph (hP ht --- ) \ make graph of P(t)

   \ Vector plotset is a list of columns in P to be plotted, and
   \ must be defined before this word will work.  Example:

   \    tgraph.plotset = [.C ; .H ; .L];

      [ usrpath "mobius.n" + "#def tcolors" "#end tcolors" msource1
        (hLines hColors) "colors" book "lines" book 

        0.1 is MARG \ top and bottom margin 10%

        purged "plotset" book
      ]
      plotset rows 0>
      IF lines plotset reach
         colors plotset reach graphset 
         swap (hP) plotset catch swap 1st over rows items reach
         (hP ht) _plot
      ELSE " tgraph: plotset not defined" . nl
      THEN
   end
THEN

   QMKTS  \ queue all markets for updating

{  Wed Aug 25 18:27:24 PDT 2010.  Make macros to periodically update 
   market data by running mktlib().

   Macros have names like sf_run, gc_run and are run periodically to 
   load the latest data for the following list of markets, but only if
   the market has an existing library (see word QMKTS()):
}  QMKTS \ fetch market names
   "QMKTS" "MKTS" yank lowercase words right justify (hM) 
   (hM) any? 
   IF dup rows 1st
      DO (hM) dup I quote strchop (qS) 
         (qS) dup quoted " mktlib" + (hT)    \ phrase, like "eu" mktlib
         (qW qS hT) swap (qS) "_run" + macro \ macro name like eu_run
      LOOP (hM) drop
   THEN

   QSTART \ start the queuing system

   pull catmsg

#end POSTFIX

------------------------------------------------------------------------

   Appendix

   Previous work.

   cT = 24;
   n = rdech(cT); // daily positions
   k = 7; // periods of n

   MKT = "EU";
   mktlib(MKT); // MKT wholib will show the library for MKT
   t = MKT.tg;
   P = MKT.P[*, [.P1:.P7]];

   cT = 24;       // daily tracking period
   N = rdech(cT); // stride

   MKT = "TN";
   mktlib(MKT); // MKT wholib will show the library for MKT
   t = MKT.tg;
   P = MKT.P;

   S = P[*, .C];

/* Each row of A contains data for each period; each column of A con-
   tains data to be treated as a series for linear prediction: */
   A = foldr(S, N)'; // each column is a data series
   tA = foldr(t, N)';

   k = 9;
   n = uniform(cols(A)/(k-1), k);

   D = null(rows(S), k);
   DO(rows(n), 1)
      i = max(1, @n[I]);
      cram(lerp([catch(tA, i) , catch(A, i)], t), I, D);
   LOOP;

   << "HALTING" . nl HALT >>

/*
   eview([[1:cols(A)]' ; A]);

/* How to put S back together: */
   S1 = chain(matrix(A, N));
   if(null?(S - S1)) (<< "S is perfectly back together" . nl >>);
*/
   Cm = 1; 

/* The minimum previous rows to use is Cm: */
   R = Cm+1; // previous rows to use

   B = null(rows(A)+1, cols(A)); // matrix of linear predictions
   ram(A[1:R], [1:R], B);        // first R rows match A

   DO(rows(A)+1, R+1) // serially predict the Ith row of A:
      Ai = A[I-R:I-1];             // using subset Ai
      (C, M) = lpcoef(Ai, Cm);     // compute coefficients
      ram(lpeval(Ai, C, 1), I, B); // evaluate and store prediction
   LOOP;

   S1 = chain(matrix(B, N));     // predictions into time domain
   plot([S , S1[1:rows(S)]], t); // overlay data and predictions

/*
   tgraph.plotset = [.C ; .H ; .L];
   tgraph(P, t);
*/

------------------------------------------------------------------------

   MKT = "TN";
   mktlib(MKT); // MKT wholib will show the library for MKT
   t = MKT.tg;
   
   P = MKT.P;

   tD = tDUMP(MKT);
   tP = tPUMP(MKT);

   C = P[*, .C];
   P1 = [P[*, .S1], P[*, .S2], P[*, .S3]];

   plot([C, P1], t);

<< "HALTING" . nl HALT >>

   MKT = "GC"; 
   mktlib(MKT); // MKT wholib will show the library for MKT
   t = 1:rows(MKT.tg);
   C = MKT.P[*, .C];
   P = [MKT.P[*, .B1], MKT.P[*, .B2], MKT.P[*, .B3]];

   plot([C, P], t);

------------------------------------------------------------------------

\ Obsolete words.

  _inline: tDUMP (qMKT --- htE) \ machine times for MKT dump envelope
    \ Wed Aug 25 09:16:31 PDT 2010

    \ Returned tE has zeroes at times not on the envelope.

      [ list: .S1 ; "R" book ]
      no STR stkok not IF "tDUMP" stknot return THEN
      strchop uppercase "MKT" book

      MKT mktdata (hP htg htm) any?
      IF (hP htg htm) push drop (hP)
         (hP) dup R catch (hE) swap .C catch (hE hC) pull (htm)
         (hE hC htm) tE (htE)
      ELSE purged
      THEN
      "_tDUMP_" MKT + naming
   end

  _inline: tPUMP (qMKT --- htE) \ machine times for MKT pump envelope
    \ Wed Aug 25 09:24:53 PDT 2010

    \ Returned tE has zeroes at times not on the envelope.

      [ list: .B1 ; "R" book ]
      no STR stkok not IF "tPUMP" stknot return THEN
      dup strchop uppercase "MKT" book

      "tDUMP" "R" yank push
      R "tDUMP" "R" bank   

      (qMKT) tDUMP (htE)
      "_tPUMP_" MKT + naming

      pull "tDUMP" "R" bank
   end

----------------------------------------------------------------------*/
