{ File mplot1.v  June 2004

   Copyright (c) 2004   D. R. Williamson

   Longs SERVER
   or SERVER 1

   July 2006
   Operating as SERVER 1, managing display of data on client window 1.
}
\-----------------------------------------------------------------------

   X11 not IF halt THEN

   "exit" -ALARM \ turn off the tserv ALARM

   "_plot" missing IF "plot.v" source THEN

   yes is updated \ files are assumed to have been updated by CLIENT

\  2 LineSolid plotGCattrib \ line width 
\  0 LineSolid plotGCattrib \ line width 
   1 LineSolid plotGCattrib \ line width 

\  Window size and placement 
\  Coordinate this window with the window in mplot2.v:
   432 plotWCB wcb.w poke \ window width

\  When have mplot2.v plot window:
\  270 plotWCB wcb.h poke \ window height

\  When have no mplot2.v plot window:
   570 plotWCB wcb.h poke \ window height

   0 plotWCB wcb.x poke \ upper left corner at x on screen
   -1 plotWCB wcb.y poke \ upper left corner at y on screen
{
   600 plotWCB wcb.w poke \ window width
   450 plotWCB wcb.h poke \ window height
   186 plotWCB wcb.x poke \ upper left corner at x on screen
   0 plotWCB wcb.y poke \ upper left corner at y on screen

\  Tall and skinny:
   390 plotWCB wcb.w poke \ window width
   500 plotWCB wcb.h poke \ window height
   400 plotWCB wcb.x poke \ upper left corner at x on screen
   0 plotWCB wcb.y poke \ upper left corner at y on screen

\  Short and wide:
   786 plotWCB wcb.w poke \ window width
   440 plotWCB wcb.h poke \ window height
   0 plotWCB wcb.x poke \ upper left corner at x on screen
   0 plotWCB wcb.y poke \ upper left corner at y on screen
}
   "mplot1.v" "\  Common functions for mplotX.v." msource

   private halt

\-----------------------------------------------------------------------

\  Common functions for mplotX.v.

   pgrid_off graphpair \ initial setting

   260 is year \ days per year, for phrase like: year last
   inline: mo "year" main * 12 / rounded ;

   public
   inline: 2yl (hC --- hC) year again plus last ;
   inline: 3yl (hC --- hC) year three star last ;
   inline: 4yl (hC --- hC) year four star last ;
   inline: ql (hC --- hC) three mo last ; \ last quarter
   inline: 2ql (hC --- hC) six mo last ; \ last two quarters
   inline: 3ql (hC --- hC) nine mo last ; \ last three quarters
   inline: 4ql (hC --- hC) year last ; \ last four quarters
   91 is show
   inline: sl (hC --- hC) show last ;
   inline: yl (hC --- hC) year last ;
   private

\-----------------------------------------------------------------------

{  Plot animation.

   Assumes sockets[1] is the socket of the client displaying plot.

   A more general way would be to use word remotesockets, which defines
   all clients connected "to" this server (S<C).  Other connections 
   "from" this server (C>S) are known with word localsockets, and would
   not apply.
}
\  When z hits "end of data" and runs zs, it means put z on client
\  to sleep:
   define: zs '"z" SLEEP' sockets 1st pry remoterun ;

\-----------------------------------------------------------------------

\  Buttons.
\  Assumes sockets[1] is the socket of the client displaying plot.

\  Button 1.
   inline: dCursor1 (hA hXY --- ) \ on client, show loc in graph
\     Run client's dCursor1.
\     Displays Y from Data nearest to the given X,Y coordinates.

\     Sends data A and XY to client's stack and runs client's dCursor1,
\     then drops A from client's stack.

      sockets 1st pry "S" book
      over (hA) S remoteput
      (hXY) S remoteput
      "dCursor1 drop" S remoterun
   end

\  Installing ptr to word dCursor1 as the Button1 (left) function in
\  word pButton of file plot.v:
   "dCursor1" ptr "pButton" "Button1" bank \ left button function

\  Button 2.
   inline: dCursor2 (hA hXY --- ) \ on client, show loc in graph
\     Run client's dCursor2.
\     Display the raw XY values corresponding to cursor location in
\     graph.

\     Sends data A and XY to client's stack and runs client's dCursor2,
\     then drops A from client's stack.

      sockets 1st pry "S" book
      over (hA) S remoteput
      (hXY) S remoteput
      "dCursor2 drop" S remoterun
   end

\  Installing ptr to word dCursor2 as the Button2 (middle) function in
\  word pButton of file plot.v:
   "dCursor2" ptr "pButton" "Button2" bank \ mid button function

\  Button 3.
   inline: dCursor3 (hA hXY --- ) \ on client, show loc in graph
\     Run client's dCursor3.

\     Sends data A and XY to client's stack and runs client's dCursor3,
\     then drops A from client's stack.

      sockets 1st pry "S" book
      over (hA) S remoteput
      (hXY) S remoteput
      "dCursor3 drop" S remoterun
   end

\  Installing ptr to word dCursor3 as the Button3 (middle) function in
\  word pButton of file plot.v:
   "dCursor3" ptr "pButton" "Button3" bank \ mid button function

\-----------------------------------------------------------------------

   inline: Nudge_g1 (hY --- hY1) \ nudge COLS in graph g1
\     Nudge the curves in COLS around themselves but not around any
\     other curves in Y:
      [ list: 1 ; "COLS" book list: -1 ; "PIX" book ]

      COLS rows 0= IF return THEN

      dup push COLS catch (hYcols)
      COLS rows 1st
      DO (hYcols) I PIX I pry nudge (hYcols) LOOP
      (hYcols) COLS peek (hB hCols hA) cram pull (hY1)
   end

{
   inline: Nudge_g1 (hY --- hY1) \ nudge COLS in graph g1
      [ list: 1 ; "COLS" book list: -1 ; "PIX" book ]
      COLS rows 0= IF return THEN

      COLS rows 1st DO (hY) COLS I pry PIX I pry nudge (hY1) LOOP
   end

   inline: Nudge_g1 (hY --- hY1) \ nudge columns in graph g1
    \ Nudge the curves in COLS around MASTER curve.
      [ list: 1 ; "COLS" book list: -1 ; "PIX" book
        list: 1 ; "MASTER" book ]

      COLS rows 0= IF return THEN

      dup push 
      MASTER cols 1st \ do each row of master separately
      DO MASTER I pry "master" book
         COLS master pile catch (hY)
         COLS rows 1st DO (hY) I PIX I pry nudge (hY1) LOOP
         COLS master pile peek (hY1 hCOLS hY1) cram
      LOOP
      pull (hY1)
   end

   inline: Nudge_g1 (hY --- hY1) \ nudge columns in graph g1
    \ Nudge the curves in COLS around MASTER curve.
      [ list: 1 ; "COLS" book list: -1 ; "PIX" book 
        list: 1 ; "MASTER" book ]

      COLS rows 0= IF return THEN

      dup push COLS MASTER pile catch (hY)
      COLS rows 1st DO (hY) I PIX I pry nudge (hY1) LOOP
      COLS MASTER pile peek (hY1 hCOLS hY1) cram 
      pull (hY1)
   end
}

   private halt
