/* File mobius.n  July 2009 

   Copyright (c) 2009-2012   D. R. Williamson

   Market real time model processing and display.

   Model ID: 2012Mar15
   From archive: mobius.n.2012Mar12

   Notes about sessions and 24 hour time are in the Appendix.  They
   were made when thinking about tracking markets for 24 hours was 
   just beginning.  Search for Appendix followed by two spaces.

   A revision record in file mob.txt discusses changes and discoveries 
   along the way as this file was developed. 

   Use word psource to source this file: "mobius.n" psource, followed
   by the name of a market:
      [dale@plunger] /home/dale > tops
               Tops 3.2.0
      Thu Oct 21 16:34:11 PDT 2010
      [tops@plunger] ready > "mobius.n" psource eu

   Based upon files mrtim.n, mov.n and movs.n.

   Functions no longer used are in the Appendix; search for obsolete.

   Many color codes from http://www.december.com/html/spec/color0.html
   are in the Appendix; search for december.

------------------------------------------------------------------------

   Contents.

      References

      Notes

      Words
         Postfix functions
         Infix functions

      Appendix
         Definition of a session; time of day
         Volume calibrations
         A note about open interest
         Making sound files
         Functions no longer used
         Miscellaneous colors
 
------------------------------------------------------------------------

   References

   1. Lefevre, Edwin, "Reminiscences of a Stock Operator," copyright
      1923 by George H. Doran Company, ISBN 0-934380-11-2, published
      by Traders Press, Inc., July 1965 (a novel based upon a series
      of Saturday Evening Post articles published in 1922; see Ref-
      erence 2).

   2. Lefevre, Edwin, "Reminiscences of a Stock Operator," copyright
      2005 by John Wiley & Sons, Inc., ISBN 0-471-67876-7, published
      by John Wiley & Sons, Inc., 2005 (publication of the Saturday 
      Evening Post articles of 1922, with illustrations, upon which 
      Reference 1 was based).

   3. Douglas, Mark, "The Disciplined Trader," copyright 1990 by Mark
      Douglas, ISBN 0-13-215757-8, published by Penguin Putnam, Inc.,
      2005.

   4. Surowiecki, James, "The Wisdom of Crowds," copyright 2004, 2005
      by James Surowiecki, ISBN 0-385-72170-6, published by First
      Anchor Books, 2005.

   5. Taleb, Nassim Nicholas, "Fooled by Randomness," second edition,
      copyright 2004 by Nassim Nicholas Taleb, ISBN 0-8129-7521-9,
      published by Random House, Inc., 2005.

   6. Taleb, Nassim Nicholas, "The Black Swan," copyright 2007 by
      Nassim Nicholas Taleb, ISBN 978-1-4000-6351-2, published by
      Random House, Inc., 2007.

   7. Luenberger, David G., "Introduction to Dynamic Systems," copy-
      right 1979 by John Wiley & Sons, Inc., ISBN 0-471-02594-1, pub-
      lished by John Wiley & Sons.

   8. Braitenberg, Valentino, "Vehicles--Experiments in Synthetic
      Psychology," copyright 1984 by Massachusetts Institute of
      Technology," ISBN 0-262-02208-7, published by Bradford Books.

   9. Williams, Larry R., "How I Made One Million Dollars in the Com-
      modity Market Last Year," copyright 1973 by Conceptual Manage-
      ment, ISBN 73-93795, published by Conceptual Management, Carmel
      Valley, California.

   References 1, 2, 3 and 9 demonstrate that markets have not changed
   even in the new era of electronic trading.  Like principles in phys-
   ics, the ideas they present never grow old.

------------------------------------------------------------------------

   Notes 

   More notes are in the Appendix.

   Taken from mfil.v where this work is done, the following shows the 
   hierarchy of words in file mfil.v that fetch incoming data and pro-
   duce real time matrix P(t).  

   The first word, daysget(), is called from this file:

      daysget (hFiles --- hP ht) \ P(t) from all the day Files

         dayget (qFile --- hPurged or hA ht) \ fetch day's market File

            rtget (qFile --- hPurged or hA ht) \ A(t) from File

               HGET (nSStart qMKT qFile --- hD) \ MKT data from hist Fil

                  hget1 (qFILE --- hD) \ matrix D from history FILE

                  hget_fix (hD qMKT --- hD1) \ apply fixes to O H L C Ch

               rtscrub (hD --- hA ht) \ clean up real time data in D

            (end rtget)
         
            dayget.extend (hA1 ht1 --- hA ht) \ A(t) for an entire sessi

               rdecimate (hP ht --- hY hx) \ decimate real time data

               dayadd (hP ht --- hP1) \ add columns of data to P

                  function (T) = daymodel(Pt, t) // daily model from rea

         (end dayget)

         daysget.add_model ( --- hP1) \ add future rows and model column

            function (Pt) = daysfill(Pt1, t) // fill cols that use all d

            function () = sigmodel(t) // model signals for signal()

         (hP1) t

      (end daysget)

   Note: functions daymodel(), daysfill() and sigmodel() are in file
   mobius.n.

   The name mobius was inspired by blue and green traces running paral-
   lel.  They looked like a mobius strip when price reversed direction. 
   Going up, green was on the left of the price curve, and going down 
   green was on the right, a 180 degree twist like a mobius strip.  

   [dale@plunger] /home/dale > tops
            Tops 3.1.0
   Tue Jul 21 07:35:24 PDT 2009
   [tops@plunger] ready > 'mobius' define
   mobiusstrip
    noun a surface with one continuous side formed by joining the ends
     of a rectangle after twisting one end through 180 deg.  ORIGIN
     named after the German mathematician August F.

   Mobius references (note Moebius):
      http://mathworld.wolfram.com/MoebiusStrip.html
      http://mathchaostheory.suite101.com/
             article.cfm/making_the_mathematical_wonder_kno

   September 2009 note: References below are to traces tM and tN which 
   no longer exist, but the idea still holds.

   Traces tM and tN (see sigmodel()) can move great distances in 
   decay mode (so they arch into the future), and into the region 
   where prices will go in a few hours.  It is like a premonition of 
   things to come.  

   Should these (jokingly) be called "premonitory" curves?  (See defi-
   nition below; this behavior is just the nature of the traces (see 
   function sigmodel()), but its usefulness was not envisioned before-
   hand.)

   In signal(), first motion voice signals for these "premonitory"
   traces are:
      Trace   Voice
       tM     echo1
       tN     lima1

   premonition
    /premmnish'n/ noun a strong feeling that something is about to
      happen.  DERIVATIVES premonitory adjective.  ORIGIN Latin, from
      praemonere 'forewarn.'

   precognition
    /preekognish'n/ noun foreknowledge of an event, especially through
      supposed paranormal means.  DERIVATIVES precognitive adjective.

   pre-emphasis
    a made up word for a spacecraft control system that torques the
     vehicle ahead of time to counteract disturbance torques antici-
     pated from an upcoming maneuver.

------------------------------------------------------------------------

   Words

   "mobius.n" asciiload this " inline:" grepr reach dot
   "mobius.n" asciiload this " function " grepr reach dot

   Postfix functions
   inline: ? ( --- ) \ display help using Unix more
   inline: ... ( --- ) \ as you were; resume auto
   inline: +b (nB --- ) \ set buy stop B above the market, and its time
   inline: -b (nB --- ) \ set buy stop B below the market, and its time
   inline: +s (nS --- ) \ set sell stop S above the market, and its time
   inline: +stop (hC hH nP --- f) \ true if above-market stop P was hit
   inline: -s (nS --- ) \ set sell stop S below the market, and its time
   inline: -stop (hC hL nP --- f) \ true if below-market stop P was hit
   inline: auto (n --- ) \ control keyboard for an n day window for Mkt
   inline: auto_key (nc --- ) \ process key nc within the auto key loop
   inline: BEEP ( --- ) \ error alarm
   inline: func (qMKT --- ) \ initialize program for MKT
   inline: funcN (n --- ) \ set range N and SHOW in func
   inline: G-INIT (qMKT --- ) \ scaling to reduce staircase effects
   inline: getcht1 ( --- t n) \ get first key and ignore others
   inline: getcht2 ( --- t n) \ if more than one key, ignore all keys
   inline: last \ (n --- ) or (hP ht n --- hP ht)
   inline: sl ( --- ) 5 last ; \ now 5 days instead of 3 months
   inline: a ( --- ) .a ; \ alias for .a
   inline: .a ( --- ) \ display the alerts price levels
   inline: .a1 ( --- ) \ display the alerts table
   inline: alertdata (qS --- 0 or n -1) \ find data for S in ALERTFILE
   inline: alertdata_put (n qS --- ) \ put data n for S on ALERTFILE
   inline: alertdata_rem (qS --- ) \ remove data for S from ALERTFILE
   inline: aedit ( --- ) \ alerts table in window for editing with nedit
   inline: ALERTFILE (qMKT --- qFile) \ name of alert.dat file for MKT
   inline: avi ( --- ) \ put alerts table in window for editing with vi
   inline: gap (n --- ) \ set gap in alerts file
   inline: ringme ( --- ) \ ring phone
   inline: rngset (f --- ) \ set ringme flag on or off in ALERTFILE
   inline: scancel ( --- ) \ cancel stops in ALERTFILE
   inline: scq (f --- ) \ set signal CQ flag on or off in ALERTFILE
   inline: scqoff ( --- ) \ set flag off for scq alert
   inline: sig (f --- ) \ set signal flag in alerts file
   inline: soundoff ( --- ) \ set flag off for sound
   inline: soundon ( --- ) \ set flags on for sound and scq
   inline: soundon? ( --- f) \ true if ALERTFILE sig is true
   inline: toggles_put ( --- ) \ put active toggle key list on ALERTFILE
   inline: toggles_set ( --- ) \ set active toggle keys from ALERTFILE
   inline: uclean_tiny ( --- ) \ uclean will run this word on exit
   inline: VIEW-UPDATE (f --- ) \ update and display graph
   inline: wcq (f qNSIG --- ) \ set signal.WCQ[NSIG] to f
   inline: wcqreset ( --- ) \ zero all the WCQ flags

   inline: Button1 (hXY --- ) \ display values at location in graph
   inline: Button2 (hXY --- ) \ display values at location in graph
   inline: Button3 (hXY --- ) \ graph zoom in and out
   inline: crossed (hA hB --- f) \ flag when curve A crosses B
   inline: csr_str (hXY nBTN --- qS) \ string of cursor XY in graph
   inline: dV_make (hV --- hdV) \ make volume rate dV, contracts/minute
   inline: dV_MAP (hdV hC b n p s rnow --- hP) \ driver for dV_map
   inline: dV_map (hdV hC b n s --- hP) \ traffic mapped to price
   inline: havefocus ( --- f) \ true if windows have focus
   inline: hits (qA --- ) \ display list of alert hits A on Mkt
   inline: _hits (qMKT --- hT) \ list of alert hits on MKT from SIG-LOG
   inline: KB_LOCKED ( --- f) \ true if the keyboard is locked
   inline: KR1 (hEV hW --- ) \ handler for key-released event
   inline: LIB ( --- qLIB) \ word for active Mkt
   inline: MEV1 (hEV hW --- ) \ handler for mouse motion event
   inline: MCsym (qMkt --- qS) \ Morse code symbol for Mkt
   inline: Mkt ( --- qMKT) \ active market
   inline: mktinit (n --- ) \ initialize market model
   inline: mob ( --- ) \ msource this file with keyword 
   inline: NSESS ( --- ns) \ number of sessions being displayed
   inline: pExpose1 (hE hW --- ) \ handler for graph expose event
   inline: pGRID2 (hWCB sX sY --- ) \ draw grid lines on current plot
   inline: pGRID3 (hWCB sX sY --- ) \ draw special grid lines from t now
   inline: pGRID4 (hWCB sX sY --- ) \ draw special grid lines from X
   inline: pGRID5 (hWCB sX sY --- ) \ draw special grid lines from X
   inline: prices (hC qName --- hC1) \ remove scaling
   inline: process_key (nt nK --- ) \ send key to controlling word
   inline: rchop (hA1 r --- hA) \ A is the first r rows of A1
   inline: rnext ( --- nrow) \ row in P(t) where next session starts
   inline: rnow (htg ntime --- nrow) \ row for ntime, but not in future
   inline: rstart ( --- nrow) \ row in P(t) where current session starts
   inline: rtime (htg ntime --- nrow) \ row corresponding to time ntime
   inline: RToffline ( --- ) \ program is ignoring the RT socket
   inline: RTonline ( --- ) \ program is paying attention to RT socket
   inline: setkeys ( --- ) \ source tgraph() with new changes to keys
   inline: setreset (nS hR --- ) \ zero a subset of signal times
   inline: SIG-LOG ( --- qFile) \ name of signal log file
   inline: sigCQ ( --- qWAV) \ .wav file for CQ signal
   inline: signal (hP ht --- ) \ signal when price hits alerts
   inline: sigreset ( --- ) \ zero all the previous signal times
   inline: t_after (hP htg t --- hP1) \ data P after machine time t
   inline: t_before (hP htg t --- hP1) \ data P before machine time t
   inline: t_between (hP htg t1 t2 --- hP1) \ data P between t1 and t2
   inline: tg (hTm --- hTg) \ machine time into graph time
   inline: TGRAPH ( --- ) \ driver for automatic updates
   inline: TGRAPH_RUN ( --- ) \ run TGRAPH if flag is set
   inline: TGRAPH_SET ( --- ) \ flag update to real time data
   inline: tgraph (hP ht --- ) \ graph data from P(t)
   inline: tgraph_lookup (hDATES --- hXY) \ time lookup table
   inline: tgraph_lookup1 (hDATES qMKT --- hXY) \ time lookup table
   inline: tgraph_view (n --- ) \ set default view in word tgraph
   inline: tm (hTg --- hTm) \ graph time into machine time
   inline: tplot ( --- ) \ plot the graph made by tgraph
   inline: trake (ht tA tB --- hR) \ rake for times between A and B
   inline: tref ( --- tm) \ reference time 
   inline: tri (hSig n --- hTr) \ integer trace for integer Sig
   inline: Vdisp ( --- ) \ display volume traffic
   inline: vgap (qN --- hG) \ return volatility gaps for market N
   inline: Vtraffic ( --- ) \ for Mkt, create data for vtraffic
   inline: vtraffic (qM --- hG) \ return traffic constants for M
   inline: wide_lines (f --- ) \ wide or narrow width for all lines
   inline: x11 X11 ; \ on non-X11 machines, make this word return no

   Infix functions
   function (T) = daymodel(Pt, t) { // daily model from real time
   function (Pt) = daysfill(Pt1, t) { // fill cols that use all days
   function () = libload(LIB) { // load library LIB
   function (LIB) = mdata(MKT) { // load MKT data into LIB
   function () = sigmodel(t) { // model signals for signal()
   function (V) = V_make(VO, t) { // volume growth series
   function (W) = vwp(P, dV, n, ns) { // volume-weighted positions

----------------------------------------------------------------------*/

   "HOME" env chdir

   CATMSG push no catmsg
<<
   inline: x11 X11 ; \ on non-X11 machines, make this word return no
>>
   if(missing("rsi")) source("mmath.v");
   if(missing("nearest")) source("math.v");
   if(missing("looking2")) source("mat.v");

   if(missing("newday")) source("mday.v"); // includes file mrc.v
   if(missing("dCursor1")) source("mplot.v"); // mplot1.v, mplot2.v too

   daysget.tnow = UDEF; // reset this in mfil.v when sourcing again

   << "z" -ALARM >>

   pull catmsg

/*--------------------------------------------------------------------*/

   CATMSG push no catmsg

<< \ Postfix functions

   x11
   IF 
{     X11 graphics general notes: 

      At this point, file plot.v has been sourced (probably by uboot.v
      at start up or one of the files it sources, like mplot1.v), and
      its default handlers are being used.  

      See words KP() and KR() in plot.v for handlers used for key-
      pressed and key-released events.  This file uses KP to see if 
      the Ctrl, Alt or Shift keys are pressed while the graphics window
      has focus and the mouse buttons are being used.  Currently, text
      keys are only recoginzed when the text window has focus, and non-
      X11 key function getcht2() defined in this file is used.

      Update March 2010: Text keys are now recognized in the graphics
      window using new key-released handler KR1() in this file, allow-
      ing a key for controlling graphics curves to be pressed in either 
      the text window or the graphics window.  Mouse motion events are 
      handled by new mouse-motion handler MEV1() in this file.

      Where necessary, new handlers are defined below to replace the
      default ones from plot.v, like the button handlers and the expose
      event handler.  Specifically, words in this file that override
      default handlers in plot.v are Button1(), Button2(), Button3(), 
      pGRID2(), and pExpose1().

      The following defines the graphics window, the one containing 
      the graph made by tgraph() and plotted by tplot().  It uses de-
      fault plotWCB defined by file plot.v when it was sourced.

      This window size must be coordinated with the text window size,
      defined in /home/dale/bin/xterm_mrtim, and the FvwmButtons geom-
      etry defined in /home/dale/.fvwm2rc:
}     786 plotWCB wcb.w poke   \ window width
      380 plotWCB wcb.h poke   \ window height

      1 plotWCB wcb.typ poke   \ only doing traces, so use speedy linet
      1 LineSolid plotGCattrib \ line width (overrides mplot1.v setting)
                               \ see word wide_lines below
   THEN

#def P struct
{
   Structure of the columns in matrix P of word daysget(), file mfil.v.

   Word daysget(), in a loop over word dayget() for each day, gets the 
   initial columns in the order of the struct below.  Word daysfill() 
   adds the last (rightmost) columns.
 
   The size of the following "no-name" struct is given by .sizeof.
}
   "" (no name) 
   list: \ columns of daysget.P

    \ Real time prices:
      "H" "L" \ electronic high and low
      "C"     \ electronic latest
      "dC"    \ electronic change

    \ Mon Jan 16 18:48:53 PST 2012.  Total volume is back in its old
    \ place, and volume rate, dV, has replaced open interest, IT:
    \\"VO" "dV" "SE" 

    \ Tue Jan 10 15:37:11 PST 2012.  Total volume has been replaced by 
    \ volume rate, dV, giving "traffic" in contracts/minute.  Rate dV 
    \ is computed from collected volume in word HGET(), file mfil.v.
    \\"dV" "IT" "SE" 

    \ Wed Feb 29 04:54:15 PST 2012.
    \ Tue Nov 29 06:32:50 PST 2011.  Collecting volume and open interest
    \ for electronic market (current contract) and settle from real time
    \ CME data (SE should match pit settle S below):
      "VO" "IT" "SE" 

    \ Positions of the three previous sessions, and daily pit settle; 
    \ these are added by macro dayget.extend in mfil.v:
      "P1" "P2" "P3" "S"

    \ Sun Oct  9 19:58:26 PDT 2011.  Open interest has been deactivated.
    \ Various places in this file (key, curve color, equations in days-
    \ fill) two places in mfil.v (dayget.add_model and dayget.extend)
    \ need to have commented lines reactivated.
    \\"OI" \ pit open interest

    \ Added columns from daymodel() called by dayadd() of file mfil.v; 
    \ WARNING: Hn is expected to be first in this list; see macro
    \ add_model in daysget(), file mfil.v:
      "Hn" "Ln" "Hm" "Lm" "V" "dV"

    \ Added columns from daysfill() called by daysget.add_model() of 
    \ file mfil.v: 
      "R1" "R2" "S1" "S2" "T1" "T2" "U1" "U2"

   end struct
{
   Note: The line "#def P struct" above, paired with the line 
      "#end P struct" below, allows just this struct to be sourced 
      by any file using the phrase:
         usrpath "mobius.n" + "#def P struct" "#end P struct" msource1
}
#end P struct

\-----------------------------------------------------------------------

\  Words for the interactive interface, including ones that replace the
\  functionality of earlier ones just sourced (like func() and sl()).

\  The default daily database to load has been set to 5 years (mrc.v).
\  August 2009.  Change daily data to one year:
   list: this_year 1 less 88 max, this_year thru end makes years

   inline: ? ( --- ) \ display help using Unix more
      RToffline \ this console is going off line
      "mobhelp.txt" .more
      RTonline \ this console is back on line

      pXY pfig @ pry 0<> IF pfig @ redraw THEN
   end

   inline: ... ( --- ) \ as you were: resume auto
      [ -1 "n" book 
        no "REPLAY" book \ flag reset by replay_init and replay_end
      ]
      n -1 > 
      IF REPLAY IF replay_end, no "REPLAY" book THEN

         no "sigmodel" "replay" bank \ REPLAY is over, resuming auto

         yes "TGRAPH" "REMOTE_DATA" bank \ force daysget() update

         n auto \ running real time console

      ELSE " auto update cannot resume; use a word to start, like "
         "eu, 3l, 5l, 10l, 20l or a phrase like 8 auto" + . nl
      THEN
   end

   inline: +b (nB --- ) \ set buy stop B above the market, and its time 
\     Give alert in signal when price is above the +b stop.

\     When fetched, nonpositive value is ignored.

\     WARNING: old fetched B may not be properly used in signal() if
\     rollover has taken place.  Word scancel cancels all stops.

      no NUM stkok not
      IF " +b: stop loss price, 0 or -1 is needed on stack" . nl
      ELSE (nB) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "+b " "" qreplace noblanklines
         pull (nB) dup 0>
         IF "+b " swap intstr +
         ELSE drop "+b -1"
         THEN spaced time intstr + pile (hT) \ append time
         swap (hT qFile) save
      THEN
   end

   inline: -b (nB --- ) \ set buy stop B below the market, and its time
\     Give alert in signal when price is below the -b stop. 

\     When fetched, nonpositive value is ignored.

\     WARNING: old fetched B may not be properly used in signal() if 
\     rollover has taken place.  Word scancel cancels all stops.

      no NUM stkok not
      IF " -b: stop loss price, 0 or -1 is needed on stack" . nl
      ELSE (nB) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "-b " "" qreplace noblanklines
         pull (nB) dup 0> 
         IF "-b " swap intstr + 
         ELSE drop "-b -1" 
         THEN spaced time intstr + pile (hT) \ append time
         swap (hT qFile) save
      THEN
   end

   inline: +s (nS --- ) \ set sell stop S above the market, and its time
\     Give alert in signal when price is above the +s stop.

\     When fetched, nonpositive value is ignored.

\     WARNING: old fetched S may not be properly used in signal() if
\     rollover has taken place.  Word scancel cancels all stops.

      no NUM stkok not
      IF " +s: stop loss price, 0 or -1 is needed on stack" . nl
      ELSE (nS) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "+s " "" qreplace noblanklines
         pull (nS) dup 0>
         IF "+s " swap intstr +
         ELSE drop "+s -1"
         THEN spaced time intstr + pile (hT) \ append time
         swap (hT qFile) save
      THEN
   end

   inline: +stop (hC hH nP --- f) \ true if above-market stop P was hit
{     Incoming C contains a set of latest prices, H contains a set of
      recent highest-highs and P is a stop price that had been set
      above the market.

      Test highs H and latest C to see if values are not below P.  If 
      either test is true, returned f is true.

      Highs H are only tested if there has been a change.  Otherwise,
      it is assumed testing against H is not valid.
}
      "P" book (hC hH) push
      peek (hH) delta 1 endmost @ 0> \ latest H is a new high
      IF peek maxfetch 2drop P < not
      ELSE no
      THEN (f1) pull drop
      swap (hC) 1 endmost @ P < not (f2) or \ price C is not below P
   end

   inline: -s (nS --- ) \ set sell stop S below the market, and its time
\     Give alert in signal when price is below the -s stop.

\     When fetched, nonpositive value is ignored.

\     WARNING: old fetched S may not be properly used in signal() if 
\     rollover has taken place.  Word scancel cancels all stops.

      no NUM stkok not
      IF " -s: stop loss price, 0 or -1 is needed on stack" . nl
      ELSE (nS) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "-s " "" qreplace noblanklines
         pull (nS) dup 0> 
         IF "-s " swap intstr + 
         ELSE drop "-s -1"  
         THEN spaced time intstr + pile (hT) \ append time
         swap (hT qFile) save
      THEN
   end

   inline: -stop (hC hL nP --- f) \ true if below-market stop P was hit
{     Incoming C contains a set of latest prices, L contains a set of
      recent lowest-lows and P is a stop price that had been set below
      the market.

      Test lows L and latest C to see if values are not above P.  If 
      either test is true, returned f is true.

      Lows L are only tested if there has been a change.  Otherwise,
      it is assumed testing against L is not valid.
}
      "P" book (hC hL) push
      peek (hL) delta 1 endmost @ 0< \ latest L is a new low
      IF peek minfetch 2drop P > not
      ELSE no
      THEN (f1) pull drop
      swap (hC) 1 endmost @ P > not (f2) or \ price C is not above P
   end

   inline: auto (n --- ) \ control keyboard for an n day window for Mkt
    \ Control the keyboard for an n latest day window of automatic 
    \ updates to Mkt. 

      [ "" "MKTSAV" book
        no "KB_LOCKED" book
        UDEF "tnow" book \ latest non-future row from daysget()

        -1 "S" book
        -1 "S_SND" book

      \ Just 0.1 second delay is enough to slow ill timed consecutive
      \ hits, and to stop reading key if it is held down.  
      \ Mon Feb 13 10:54:43 PST 2012.  But this is not true if a key 
      \ is rapidly hit and released.  Go back to a larger delay:
        2 (sec) "DT" book \ governor on consecutive key hits
        INF "hit" book

        no "NIST" book
      ]
      (n) dup "..." "n" bank 
      (n) mktinit 

      no "KB_LOCKED" book
      0 "signal" "NT" bank

    \ Initialize graphics.
      Mkt MKTSAV <>
      IF plotclose
         Mkt dup MOdo + " real time" + "plotWCB" "title" bank
         Mkt "MKTSAV" book
      THEN
      "..." "n" yank -1 = IF xyzoom_init THEN

      [  
      {"
      S -1 =
      IF "RTSERVER" msgPeek any? \ real time server PORT is on msgcomm
         IF (qPORT) IPloop swap number drop (qIP nPORT) CLIENT "S" book 
            S -1 =
            IF " auto: connection to real time server failed" . nl 
             \ Make a graph and return
               yes "KB_LOCKED" book
               yes VIEW-UPDATE
               return
            ELSE 
             \ Run word CLIENT_OPN on the server; set stack on server
             \ for CLIENT_OPN with Mkt (quoted) and the socket to here:
               Mkt quoted " remotefd CLIENT_OPN ACK" + S remoterun1 (f)
               (f) drop

             \ Run NIST_DELTA every 4 hours:
               NIST not 
               IF 14400 "NIST_DELTA" "SEC" bank 
                  NIST_DELTA yes "NIST" book
               THEN

             \ Set names for clients display:
               "RTSERVER real time data server" S clientLOGIN_set
               Mkt " market console " + quoted
               " remotefd clientLOGIN_set" + S remoterun

            THEN
         ELSE " auto: real time server not found" . nl return
         THEN
      THEN
      "} "CONN_RT" macro
      ]
      CONN_RT

      [  
      {"
      S_SND -1 =
      IF "SNDSERVER" msgPeek any? \ sound server PORT is on msgcomm
         IF (qPORT) IPloop swap number drop (qIP nPORT) CLIENT (nS)
            (nS) "S_SND" book S_SND -1 =
            IF " auto: connection to sound server failed, " 
               "omitting alerts" + . nl 
            ELSE
             \ Set names for clients display:
               "SNDSERVER sound file server" S_SND clientLOGIN_set
               Mkt " market console " + quoted
               " remotefd clientLOGIN_set" + S_SND remoterun

             \ Check the sound server for a voice for this Mkt by run-
             \ ning word vMkt on the sound server, and set signal.MC:
               Mkt quoted " (qMkt) vMkt (hName) remotefd remoteput" + 
               (hT) S_SND (hT nS) remoterun1 (hN) chars 0>
               IF no ELSE yes THEN (f) \ yes Morse code, no for voice
               (f) "signal" "MC" bank  \ set signal.MC to f
            THEN
         ELSE " auto: sound server not found, omitting alerts" . nl 
         THEN
      THEN
      "} "CONN_SND" macro
      ]
      CONN_SND

    \ Start automatic update:
      yes "KB_LOCKED" book
      "Automatic update is on; "
      "press Esc to disconnect and return to the % prompt" + . nl

    \ Make the first graph:
      -1 "daysfill" "rprev" bank \ makes daysfill recalculate
      yes VIEW-UPDATE \ yes forces daysget by TGRAPH.UPDATE

      "TGRAPH_RUN" WAKE S yes SELECT

    \ Control keys input in this BEGIN ... UNTIL loop while RTSERVER 
    \ runs; press Esc to exit the loop:
      time DT 1+ - "sit" book
      BEGIN 
         getcht2 (ntime nC) \ sit here waiting for a key
      [
       \ This macro will be run from outside by word process_key() in 
       \ file mobius.n when a key is processed in the graphics window 
       \ and we want to process the key as if it were pressed in the
       \ text window:
        {" process_key (ntime nC --- ) \ process key C 

         (ntime nC) "nc" book
         nc 0= IF (ntime) drop return THEN (ntime) "hit" book

       \ Sun Feb  6 20:46:43 PST 2011.  Programmers need to use their 
       \ own software.  After many, many months, this return was fig-
       \ ured out; no more hitting Esc over and over while waiting for
       \ a needless update to finish:
         nc ESC? IF return THEN \ don't waste time updating if ESC

         "TGRAPH_RUN" SLEEP S no SELECT

         nc NL =  
         IF hit sit - DT > IF "TGRAPH" "LAST" yank . nl THEN
         ELSE 
            hit sit - DT > IF 0 "auto_key" "ncprev" bank THEN
            nc auto_key 
         THEN 

         time "sit" book
         "TGRAPH_RUN" WAKE S yes SELECT

        "} "process_key" macro \ may be called by word process_key()
       ]
         (ntime nC) process_key \ run the macro made above
         nc ESC? (f)
      UNTIL

      S sclose -1 "S" book         \ disconnect from RTSERVER
      S_SND sclose -1 "S_SND" book \ disconnect from SNDSERVER

      no "KB_LOCKED" book 
      "daysget" "tnow" yank "tnow" book

      "Automatic update is off; enter ..." 
      " to reconnect and resume real time updates" + . nl
   end

#def auto_key

   inline: auto_key (nc --- ) \ process key nc within the auto key loop
      [ 
      \ These are the toggle keys that word tgraph uses to draw and
      \ remove curves:
        "D F G S b d e f g m n o p s u w"
        " z" + strings yes sort "Toggles" book

        0 "ncprev" book

        {" TOG (qTOG --- ) \ toggle and update view if key nc is TOG
         \ Fetch tgraph.showTOG and toggle it, then run VIEW-UPDATE:
           dup 1st byte nc = (qTOG f)
           IF "tgraph" "show" rot (qTOG) + 2dup yank yes xor rev bank
              no VIEW-UPDATE
              yes "TOGSAVE" book
           ELSE (qTOG) drop
           THEN 
        "} "TOG" macro
      ]
      "nc" book \ nc is the 8-bit value of key character, like 65 for A

    \ Mon Feb 13 15:39:43 PST 2012.  Move this block to here, the top,
    \ to toggle keys for individual curves first:
      no "TOGSAVE" book Toggles rows 1st 
      DO Toggles I quote TOG TOGSAVE IF toggles_put EXIT THEN LOOP
      TOGSAVE IF return THEN

{     Nervous Nellie hitting keys needlessly:
      Through time delay DT, the word that called this one, auto(),
      banks ncprev=0 if keys are not being abused.  Otherwise, if 
      nc=ncprev the key is ignored and this word returns right here:
}     nc ncprev = (f)
      nc "ncprev" book (f) IF return THEN

{     This is kept as an example for entering data while the keyboard
      is locked.  Otherwise, its idea was wrong for setting the default
      view, since that should be done outside of all the consoles, not
      within one of them.  

      Default view can now be set from RTSERVER using word view_all
      in qcon.v.

      nc 4 = \ Ctrl+D; this must appear before nc tests "1" "2" "3"
      IF " enter default view (1, 2 or 3): " query nl strchop any?
         IF number (0 or n -1)
            IF (n) dup 1 3 within
               IF (n) dup tgraph_view
                  (n) intstr 1st byte "nc" book
               ELSE (n) drop " expect number 1, 2 or 3" . nl
                  no VIEW-UPDATE
               THEN
            ELSE " expect number 1, 2 or 3" . nl
               no VIEW-UPDATE
            THEN
         ELSE no VIEW-UPDATE
         THEN
      THEN
}
      nc "K" 1st byte = \ show toggle keys
      IF "  Toggle keys: " 
         "" (qKeys)
         "tgraph" "Toggles" yank (hT) dup push rows 1st
         DO "tgraph" "show" peek (hT) I quote + localrun (f) 
            IF (qKeys) peek (hT) I quote + spaced THEN
         LOOP pull (hT) drop
         (qKeys) any? not IF "none in use" THEN + . nl
      THEN

    \ Numbered views:
      -1 "nview" book

      nc "1" 1st byte = 
      IF "tgraph" "1tog" yank chars any
         IF 1 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "1ON" localrun
            no VIEW-UPDATE 
         THEN
      THEN
 
      nc "2" 1st byte =
      IF "tgraph" "2tog" yank chars any
         IF 2 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "2ON" localrun
            no VIEW-UPDATE
         THEN
      THEN

      nc "3" 1st byte =
      IF "tgraph" "3tog" yank chars any
         IF 3 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "3ON" localrun
            no VIEW-UPDATE
         THEN
      THEN

      nc "4" 1st byte =
      IF "tgraph" "4tog" yank chars any
         IF 4 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "4ON" localrun
            no VIEW-UPDATE
         THEN
      THEN

      nc "5" 1st byte =
      IF "tgraph" "5tog" yank chars any
         IF 5 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "5ON" localrun
            no VIEW-UPDATE 
         THEN
      THEN

      nc "6" 1st byte =
      IF "tgraph" "6tog" yank chars any
         IF 6 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "6ON" localrun
            no VIEW-UPDATE
         THEN
      THEN
 
      nc "7" 1st byte =
      IF "tgraph" "7tog" yank chars any
         IF 7 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "7ON" localrun
            no VIEW-UPDATE
         THEN
      THEN

      nc "8" 1st byte =
      IF "tgraph" "8tog" yank chars any
         IF 8 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "8ON" localrun
            no VIEW-UPDATE
         THEN
      THEN
 
      nc "9" 1st byte =
      IF "tgraph" "9tog" yank chars any
         IF 9 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "9ON" localrun
            no VIEW-UPDATE
         THEN
      THEN
 
      nc "0" 1st byte =
      IF "tgraph" "0tog" yank chars any
         IF 0 dup "nview" book "tgraph" "NVIEW" bank
            "tgraph" "ZROTOG" localrun "tgraph" "0ON" localrun
            no VIEW-UPDATE
         THEN
      THEN
 
      nview -1 > IF nview viewdef THEN \ save new NVIEW to file

      nc "a" 1st byte =
      IF .a \ show alert prices
         "TGRAPH" "LAST" yank . nl
      THEN

      nc "C" 1st byte =
      IF "TGRAPH" "LAST" yank . nl clients \ show socket connections
      THEN

      nc "E" 1st byte = \ toggle flag for grid lines on top
      IF "pExpose1" "GRIDtop" 2dup yank yes xor rev bank
         no VIEW-UPDATE 
      THEN

      nc "h" 1st byte = IF ? THEN

      nc "I" 1st byte = \ toggle sound on and off
      IF soundon? (f)
         "TGRAPH" "LAST" yank . nl
         IF " turning sound off" no no
         ELSE " turning sound on" yes yes
         THEN (f f) sig scq . nl 
      THEN
{ ---
      nc "M" 1st byte = \ toggle flag daysfill.Mflag
      IF "..." "REPLAY" yank 
         IF " auto_key: cannot toggle Mflag during replay" . nl
         ELSE "daysfill" "Mflag" yank yes xor
            IF " model 1" yes (qS f)
            ELSE " model 2" no (qS f)
            THEN (qS f) "daysfill" "Mflag" bank 
            (qS) . nl
            -1 "daysfill" "rprev" bank   \ daysfill recalculate latest
            true "daysfill" "never" bank \ needed for full recalculation
            yes VIEW-UPDATE 
         THEN 
      THEN
--- }
      nc "P" 1st byte = \ toggle flag for midsession grid lines
      IF "pGRID2" "MIDSESSION" 2dup yank yes xor rev bank
         no VIEW-UPDATE 
      THEN

      nc "Q" 1st byte = \ kill vi window made by Vdisp
      IF pidtable (hT) dup "Vdisp" "pid_name" yank grepr (hR) any?
         IF (hT hR) reach "-title vi -R" "" qreplace 
            noblanklines (qS) any?
            IF (qS) 2nd word drop number drop negate killmy THEN
         ELSE (hT) drop
         THEN
      THEN

      nc "q" 1st byte = \ show price alert hits
      IF "Voice alerts, stand by ..." . 

         "Voice alerts.  "
         "Press q to quit, j or d for down and k or u for up." +
         "Shown latest on top; "
         "time of alert is later than the actual " +
         "event by the real time data lag." + pile

         "TGRAPH" "LAST" yank
         '"P" hits' >stk " P " " " strp neat

       \ Add some lines to fill the display because Unix .more will
       \ just print a few to the screen and exit instead of running:
         " " LINES 2 * pileof 
         4 pilen scratch save

         RToffline \ this console is going off line
         scratch .more 
         cr 28 spaces . cr \ erase message "Voice alerts, stand by ..."
         scratch deleteif
         RTonline \ this console is back on line
      THEN

      nc "R" 1st byte = \ toggle flag for crosshairs on top
      IF "pExpose1" "CROSStop" 2dup yank yes xor rev bank
         no VIEW-UPDATE 
      THEN

      nc "T" 1st byte =
      IF "TGRAPH" "LAST" yank . nl tasks \ show multitasker tasks
      THEN

      nc "t" 1st byte = \ toggle flag for extra grid lines 
      IF "pGRID3" "A" yank yes xor "pGRID3" "A" bank
         no VIEW-UPDATE 
      THEN
  
      nc "U" 1st byte = \ force recalc in current view
      IF 
       \ Tue Oct 11 03:13:30 PDT 2011
         -1 "daysfill" "rprev" bank \ makes daysfill recalculate

       \ Wed Feb 15 03:24:48 PST 2012
         yes "daysfill" "never" bank \ makes daysfill use all rows

       \ Update view, with latest data if any:
         yes VIEW-UPDATE 
      THEN

      nc "V" 1st byte = \ 22 = \ Ctrl+V latest show volume details
      IF Vdisp THEN

      nc "W" 1st byte = \ toggle flag pGRID4.HALF
      IF "pGRID4" "HALF" yank yes xor
         IF " spacing is 12 hours" yes (qS f)
         ELSE " spacing is 24 hours" no (qS f)
         THEN (qS f) "pGRID4" "HALF" bank
         no VIEW-UPDATE (qS) . nl 
      THEN

      nc "x" 1st byte = \ zero all the toggles
      IF "tgraph" "ZROTOG" localrun 
         no VIEW-UPDATE
      THEN

      nc "Y" 1st byte = \ force recalc of all sessions
      IF " recalculating all sessions ... " .

       \ Phrases from mktinit():
         yes "daysget" "NEW" bank \ forces initialization
         LIB "FILES" yank daysget (hP ht) 2drop
         no "daysget" "NEW" bank

       \ Tue Oct 11 03:13:30 PDT 2011
         -1 "daysfill" "rprev" bank \ makes daysfill recalculate latest
       \ Mon Nov  7 06:19:02 PST 2011
         true "daysfill" "never" bank \ needed for full recalculation

         yes VIEW-UPDATE 
      THEN

      nc "\" 1st byte = 
      IF "tog\" alertdata not IF 0 THEN yes xor (n) 
         (n) dup "tog\" alertdata_put
         (n) "tgraph" "tog\" bank 
         no VIEW-UPDATE
      THEN

      nc "ncprev" book
   end

#end auto_key

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

\  Redefine word func:
   inline: func (qMKT --- ) \ initialize program for MKT 
      [ 40 "N" book 
         0 "D" book
        N D - "SHOW" book
      ]
      uppercase "Mkt" "MKT" bank 

    \ This does not catch unwanted market strings:
    \ tracklist1 MKT grepr rows 0=
    \ IF " func: " MKT + " is not a valid market" + . nl return THEN

      Mkt G-INIT 

\     Initialize data to initial N days:
      N SHOW = 
      IF Mkt " real time" + . nl
         "Analyzing the last " N intstr + " days ..." + . nl
      ELSE "Analyzing the last " N intstr + " days, " +
         "displaying the last " + SHOW intstr + " days ..." + . nl
      THEN

      -1 "..." "n" bank

    \ When daysget.NEW is true, time table XY is remade in mktinit and 
    \ then the once-only initialization branch in daysget is run: 
      true "daysget" "NEW" bank 

      N mktinit x11 IF SHOW last THEN
   end

   inline: funcN (n --- ) \ set range N and SHOW in func
      "n" book
      n "func" "N" bank 
      n "func" "SHOW" bank 

    \ Sun Sep  5 10:50:53 PDT 2010.  Skip the following, and just use
    \ this word to set N in func(), then select the market to use.
    \ 0 "mktinit" "N" bank
    \ Mkt func
   end

   inline: G-INIT (qMKT --- ) \ scaling to reduce staircase effects
{     For scaling MKT, this word produces two macros, G-SCALE and 
      G-UNSCALE, that override the dummy ones from mfil.v now in 
      place.  

      Word daysget in mfil.v uses G-SCALE to tweak prices and improve 
      graphs drawn, and modified word prices in this file (taken from
      file mrc.v) uses G-UNSCALE when converting scaled values into 
      price text to print.
}
      "MKT" book
      no "make_macros" book

{ ----------- Not used when not doing out of core.  And curves look
              great because they aren't truncated to integer to do
              out of core.  So much for this kludge.
 
      MKT "US" = 
      IF "10 *" "G-SCALE"  
         "10 /" "G-UNSCALE" 
         (qT1 qS1 qT2 qS2) yes "make_macros" book
      THEN

      MKT "TN" = 
      IF "10 *" "G-SCALE"  
         "10 /" "G-UNSCALE" 
         (qT1 qS1 qT2 qS2) yes "make_macros" book
      THEN

  ----------- Not used when not doing out of core. }

      make_macros
      IF CATMSG push no catmsg
         (qT1 qS1 qT2 qS2) \ make two macros:
         (qT2 qS2) macro \ macro to unscale
         (qT1 qS1) macro \ macro to scale
         pull catmsg
      THEN
   end

   inline: getcht1 ( --- t n) \ get first key and ignore others
    \ Inadvertent pasting at the keyboard prompt is buffered by taking
    \ just the first key and tossing the rest.
      getkeys any? IF 1st byte ELSE 0 THEN (n) time swap 
   end

   inline: getcht2 ( --- t n) \ if more than one key, ignore all keys
    \ Inadvertent pasting at the keyboard prompt is ignored.
      getkeys dup chars 1 = IF 1st byte ELSE drop 0 THEN (n) time swap
   end

   inline: itext1 (hA --- hT) \ matrix A terms rounded to integer text
    \ Jan 27 11:56:49 PST 2012.  For speed, a version of itext that 
    \ does not use formal rounding (function rounded()).

    \ Warning: 
    \    Not for general use.  For example, the phrase "0.5 + integer" 
    \    will cause -1 to become 0.

      mformat push       \ save format
      this named swap 0.5 + integer "%8.0f" mformatset
      mtext (qName hT) swap naming
      pull mformatset    \ restore format
   end

\  Redefine word last:
   inline: last \ (n --- )
\     This is a front end for auto (n --- )
      no NUM stkok not
      IF " last: need days, like 5 last" . nl return THEN

      Mkt chars 0=
      IF (n) drop " last: no market is defined" . nl return THEN

      x11 not IF drop return THEN
      xyzoom_init 
      -1 "..." "n" bank 
      (n) auto 
   end

\  Redefine word sl:
\  This is now a front end for auto.
   inline: sl ( --- ) 5 last ; \ now 5 days instead of 3 months

\  Here is a set of words for interactive managing of alerts.  Words
\  aedit and avi put the alerts file into an editor for direct editing.

   inline: a ( --- ) .a ; \ alias for .a

   inline: .a ( --- ) \ display the alerts price levels
\     Shows the prices table from highest price to lowest.
      Mkt any? 
      IF (qMkt) ALERTFILE asciiload (hT)
         dup Mkt grepr any?
         IF reach dup 3rd word drop numerate 
            1st over rows items park no sort
            2nd catch reach 1 indent . nl
            "gap" alertdata IF " gap: " swap intstr + . nl THEN

         ELSE (hT) drop
         THEN

         depth push

         "+s" alertdata  
         IF 1st pry any? 
            IF "  " swap intstr + " +s..." + 
            ELSE " | +s..." 
            THEN
         THEN

         "+b" alertdata 
         IF 1st pry any? 
            IF "  " swap intstr + " +b..." +
            ELSE " | +b..." 
            THEN
         THEN

         "-s" alertdata
         IF 1st pry any? 
            IF "  " swap intstr + " -s..." +
            ELSE " | -s..."
            THEN
         THEN

         "-b" alertdata 
         IF 1st pry any? 
            IF "  " swap intstr + " -b..." +
            ELSE " | -b..."
            THEN
         THEN

         " | scancel..."

         depth pull - pilen neat 
         "|" " " strp 
         "..." " ..." strp 
         2 indent . nl

      THEN
   end

   inline: .a1 ( --- ) \ display the alerts table
      Mkt any? IF (qMkt) ALERTFILE asciiload no sort 1 indent . THEN
   end

   inline: alertdata (qS --- 0 or n -1) \ find data for S in ALERTFILE
{     Return number n and true flag for string S data type if found 
      in ALERTFILE, otherwise just return a false flag.  

      Returned n will be a column vector if there are two or more items,
      as with stops (+b, -b, +s, -s) that have price and time.

      Only the first four characters of S are used in matching, and 
      string S in the ALERTFILE for Mkt must start at the leftmost
      column.

      Examples: 

         Macro signal.ALERT uses this word to know whether or not to 
         sound an alert.  When ALERTFILE contains "sig 0" the following
         says a "sig" data type was found (-1) and that n is 0 (do not 
         sound an alert):
            % "sig" alertdata .s
             stack elements:
                   0 number: -1
                   1 number: 0

         When ALERTFILE contains no "sig" data, this says no "sig" data
         type was found (and signal.ALERT will sound a signal):
            % "sig" alertdata .s
             stack elements:
                   0 number: 0  0

         Run an IF branch if scq data is present:
            "scq" alertdata (0 or f -1)
            IF (running this branch)
               (f) 0= \ is flag for CQ sound off?
               IF no "ATTNCQ" book THEN
          \ ELSE no scq data, so do nothing
            THEN
}
      (qS) 4 blpad 1st 4 items catch strchop "S" book

       Mkt ALERTFILE (qFile) dup file?
       IF asciiload (hT) 4 blpad dup 1st 4 items catch S grepr any?
          IF (hT) reach (qS) words numerate any?
             IF dup rows 2 < IF @ THEN true
             ELSE false
             THEN
          ELSE (qFile) drop false
          THEN
       ELSE (qFile) drop false
       THEN
   end

   inline: alertdata_put (n qS --- ) \ put data n for S on ALERTFILE
    \ Wed Aug 17 09:24:23 PDT 2011

    \ If S is already on ALERTFILE, it will be replaced by n.

      Mkt any?
      IF ALERTFILE "FILE" book
         (n qS) "S" book intstr "n" book

         FILE asciiload asciify S "" qreplace noblanklines (hT)
         S " " + n + (qData)

         (hT qData) pile (hT) FILE save

      ELSE 2drop
      THEN
   end

   inline: alertdata_rem (qS --- ) \ remove data for S from ALERTFILE
    \ Wed Aug 17 10:16:41 PDT 2011

      Mkt any?
      IF ALERTFILE "FILE" book
         (qS) "S" book 

         FILE asciiload asciify S "" qreplace noblanklines (hT)
         (hT) FILE save

      ELSE 2drop
      THEN
   end

   inline: aedit ( --- ) \ alerts table in window for editing with nedit
      Mkt any? IF ALERTFILE edit THEN
   end

   inline: ALERTFILE (qMKT --- qFile) \ name of alert.dat file for MKT
      [ mpath "XX_alert.dat" + "TEMP" book ] 
      any? not
      IF " ALERTFILE: no market is defined" . nl "" return THEN 
      TEMP "XX" rot uppercase strp
      dup file? not IF "touch " over + shell THEN
   end

   inline: avi ( --- ) \ put alerts table in window for editing with vi
      [ mpath "XX_alert.dat" + "FILE" book ]
      Mkt any? IF ALERTFILE _vim THEN
   end

   inline: gap (n --- ) \ set gap in alerts file
      no NUM stkok not 
      IF " gap: need gap number on stack" . nl 
      ELSE (f) push Mkt ALERTFILE dup (qFile) asciiload 
         asciify "gap" "" qreplace noblanklines
         "gap " pull intstr + pile (hT)
         swap (hT qFile) save
      THEN
   end

   inline: ringme ( --- ) \ ring phone
{     Word ringme is run by macro psignal.

      For ringme to work, the following are required in advance of
      having a wcq flag become true:
         yes rngset \ ringme flag, rng, is on
         yes scq    \ CQ flag, scq, is on
         no sig     \ sound flag, sig, is off

      Run .a1 to see ALERTFILE settings like sig, scq, wcq, rng.

      See file qconset.v for setups using ringme.
}
      10 (minutes) "phoneALARM" "DT" bank \ between calls
      'ATD-1-310-650-9883' phoneALARM
   end

   inline: rngset (f --- ) \ set rng flag on or off in ALERTFILE
    \ Flag rng is used to run ringme in macro psignal.
    \ For ringme to work, the following are required in advance of
    \ having a wcq flag become true:
    \    yes rngset \ ringme flag, rng, is on
    \    yes scq    \ CQ flag, scq, is on
    \    no sig     \ sound flag, sig, is off
    \ Run .a1 to see ALERTFILE settings like sig, scq, wcq, rng.
      no NUM stkok not
      IF " rngset: need yes or no flag on stack" . nl
      ELSE (f) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "rng" "" qreplace noblanklines
         pull (f) IF "rng 1" ELSE "rng 0" THEN pile (hT)
         swap (hT qFile) save
      THEN
   end

   inline: scancel ( --- ) \ cancel stops in ALERTFILE
      -1 +b -1 -b -1 +s -1 -s
   end

   inline: scq (f --- ) \ set signal CQ flag on or off in ALERTFILE 
{     CQ alerts beep the CQ Morse code "attention" signal and then
      the voice signal is given.  They are intended to run even if
      voice alerts have been turned off, such as when a stop has been
      hit.

      Even if voice signals have been turned off, by setting "sig" to 
      0 (as in "no sig"), CQ alerts are still run as important alerts 
      not to be missed.

      Run .a1 to see ALERTFILE settings like scq, rng.

      Turn CQ alerts off at the market console using:
         % no scq
      or from qcon (for all clients) using word scqoff.

      To fetch the scq alert data:
         "scq" alertdata (0 or f -1) 

      Example: run an IF branch if scq data is present:
         "scq" alertdata (0 or f -1)
         IF (running this branch) 
            (f) 0= \ is flag for CQ sound off?
            IF no "ATTNCQ" book THEN
       \ ELSE no scq data, so do nothing
         THEN
}
      no NUM stkok not
      IF " scq: need yes or no flag on stack" . nl
      ELSE (f) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "scq" "" qreplace noblanklines
         pull (f) IF "scq 1" ELSE "scq 0" THEN pile (hT)
         swap (hT qFile) save
      THEN
   end

   inline: scqoff ( --- ) \ set flag off for scq alert
      no scq
   end

   inline: sig (f --- ) \ set signal flag in alerts file
\     Turn this flag off at the market console using:
\        % no sig

      no NUM stkok not 
      IF " sig: need yes or no flag on stack" . nl 
      ELSE (f) push Mkt ALERTFILE dup (qFile) asciiload 
         asciify "sig" "" qreplace noblanklines
         pull (f) IF "sig 1" ELSE "sig 0" THEN pile (hT)
         swap (hT qFile) save
      THEN
   end

   inline: soundoff ( --- ) \ set flag off for sound
      no sig
   end

   inline: soundon ( --- ) \ set flags on for sound and scq
      yes sig
      yes scq
   end

   inline: soundon? ( --- f) \ true if ALERTFILE sig is true
\     True if file ALERTFILE has sig set to true.  Actual hardware
\     sound can still be on even if this word returns false.
      "sig" alertdata (0 or n -1)
      IF (n) 0= IF false ELSE true THEN
      ELSE false
      THEN
   end 

   inline: toggles_put ( --- ) \ put active toggle key list on ALERTFILE
    \ Tue Jul 19 12:43:54 PDT 2011

      [ no "RET" book ] \ set to yes only by toggles_set
      RET IF no "RET" book return THEN

      Mkt any?
      IF ALERTFILE "FILE" book

         FILE asciiload asciify "toggles" "" qreplace noblanklines (hT)

         "toggles " (qName)

         "tgraph" "Toggles" yank push
         list:
            peek rows 1st
            DO "tgraph" "show" peek I quote + localrun (f)
               IF peek I quote import1 @ intstr THEN
            LOOP
         end any? not IF "112" THEN \ if none, letter p to show C
         neat (qData) pull drop

         (hT qName qData) park pile (hT) FILE save
      THEN
   end

   inline: toggles_set ( --- ) \ set active toggle keys from ALERTFILE
    \ Tue Jul 19 19:10:16 PDT 2011

    \ Wed Aug 17 09:02:49 PDT 2011.  Fetch times for grids in pGRID4
    \ and pGRID5.

    \ Local flag f = toggles_set.set is checked in tgraph() at start up.

      "toggles" alertdata (f) 
      (f) dup "set" book \ set is checked in tgraph() at start up

      (f)
      IF (hA) "N" book \ vector of char numbers (like a=97)

       \ Avoid needless ALERTFILE save when tgraph.N-ON run next calls 
       \ toggles_put() with the same chars that alertdata() just read:
         yes "toggles_put" "RET" bank \ avoid needless rewrite

         list: N export1 dup (qS) push chars 1st DO peek I catch LOOP
         end (qT) words (hT) "tgraph" "N-ON" localrun

         (qS) pull drop 
      THEN 

      "tog\" alertdata (0 or n -1) not IF 0 THEN (n) 
      (n) "tgraph" "tog\" bank 

    \ Definitions of special grid lines:
      "PG4" alertdata (f) IF (tm) tg "pGRID4" "X1" bank THEN
      "PG5" alertdata (f) IF (tm) tg "pGRID5" "X1" bank THEN
   end
 
   "uclean_tiny" missing
   IF
   inline: uclean_tiny ( --- ) \ uclean will run this word on exit
    \ Turn off signals, so they are required to be turned back on the
    \ next time this console starts.
      Mkt any? 
      IF (qMkt) drop no sig no scq
      THEN
   end
   THEN

   inline: VIEW-UPDATE (f --- ) \ update and display graph
    \ This word is run when a graph is changed (as by toggle keys), and
    \ by pExpose1 when focus is regained.

    \ Incoming f is true to force recalculation of curves in daysget() 
    \ if the real time console (word auto()) is running.

      "auto" "KB_LOCKED" yank (f)
      IF (f) dup "TGRAPH" "UPDATE" bank 
         (f) IF 0 "daysget" "tUPDATE" bank THEN 
         TGRAPH \ real time is running
      ELSE (f) drop 
       \ Get matrices P and t, booked in main by daysget on the last 
       \ update:
         "P" main (hP) "t" main (hP ht) tgraph tplot
      THEN
   end

   inline: viewdef (n --- ) \ set default view flag in alerts file
    \ Wed Jun  2 16:36:45 PDT 2010

    \ Phrase "view" alertdata gives (n -1) where n is value set by 
    \ this word.
    \ If no view is set, then phrase "view" alertdata gives 0. 

      no NUM stkok not
      IF " viewdef: need number on stack" . nl
      ELSE (n) push Mkt ALERTFILE dup (qFile) asciiload
         asciify "view" "" qreplace noblanklines
         "view " pull (n) intstr + pile (hT)
         swap (hT qFile) save
      THEN
   end
 
   inline: wcq (f qNSIG --- ) \ set signal.WCQ[NSIG] to f
    \ Examples: yes "tango2" wcq, no "baker1" wcq

    \ Run "yes scq" to make these work even with sound turned off.
    \ Run .a1 to see ALERTFILE settings like scq, rng.
      "signal" swap yank (i) (f i) "signal" "SET-WCQ" localrun
   end

   inline: wcqreset ( --- ) \ zero all the WCQ flags
\     Set signal.WCQ to zero.
      "signal" "WCQ" yank dims null "signal" "WCQ" bank
   end

\-----------------------------------------------------------------------

x11 IF

{  A general note about keys and the mouse cursor:

      Some graph controls require one of the control keys, ALT, CTRL, 
      or SHIFT, to be already pressed when a mouse button is pressed.

      Having two adjacent windows means that a control key can be in-
      advertantly pressed while focus is in the wrong window when 
      quickly moving the mouse cursor from one window to the next.
 
      Make sure the mouse cursor is in the correct window before press-
      ing one of these control keys.

      What seems like a program bug when no response or the wrong re-
      sponse is obtained may simply be the result of a sloppy key press,
      done at a moment when the wrong window had focus.
}
   inline: Button1 (hXY --- ) \ display values at location in graph
{     Wed Mar 17 12:29:42 PDT 2010.  Add Alt key.

      Tue Apr 13 06:46:56 PDT 2010.  Window event processor in term.c
         misses multiple occurrences of the same event, so using two
         keys, ALT+SHFT, for pGRID5 is a bad idea and key release of 
         SHFT is sometimes missed leaving SHFT turned on.  Revise to
         use just SHFT for pGRID5.
}
\     Display the values corresponding to cursor location in graph.

      dup CB_PUSH \ always push to clipboard for possible use by xyzoom

      "KP" "CTRL" yank \ Ctrl key pressed?
      "KP" "ALT" yank not and 
      "KP" "SHFT" yank not and
      IF 
{        If the Ctrl key is used here, it should be released while the 
         graph window still has focus, perhaps soon after this button 
         is pressed.  By not releasing the Ctrl key while the graph 
         window has focus, the program will later act as if it is still
         pressed.  Simply pressing and releasing the Ctrl key when the 
         window again has focus will clear up the problem.

         Update Mar 2010: Low level control of keys using KP() and 
         MEV() of file plot.v (low level means this file doesn't need 
         to worry about it) senses when the graph window has lost 
         focus, and releases the Ctrl key even if it is still held
         down.  This eliminates the problem discussed above.
}
       \ This branch fetches the actual price of the PG curve that is
       \ nearest to the cursor.

       \ Require PG from main (as booked by tgraph).

         "'PG' exists?" main
         IF (hXY) 3 csr_str (qS)
         ELSE (hXY) drop " Button1: matrix PG not found" . nl 
            KB_LOCKED IF 0 0 process_key ELSE cprompt . THEN
            return
         THEN (qS)
      ELSE 
         "KP" "ALT" yank \ Alt key pressed?
         "KP" "CTRL" yank not and 
         "KP" "SHFT" yank not and 
         IF \ draw grid lines relative to current csr location
            KB_LOCKED (f)
            IF (hXY) 1 csr_str (qS) 
               "csr_str" "X" yank (tg) "pGRID4" "X1" bank
               no VIEW-UPDATE

             \ Wed Aug 17 09:44:27 PDT 2011.  Save tm on ALERTFILE:
               "pGRID4" "X1" yank dup UDEF <> 
               IF (tg) tm "PG4" alertdata_put ELSE "PG4" alertdata_rem
               THEN

               (qS)
            ELSE (hXY) drop return 
            THEN (qS)
         ELSE
            "KP" "SHFT" yank \ Shift key pressed?
            "KP" "CTRL" yank not and 
            "KP" "ALT" yank not and 
            IF \ draw grid lines relative to current csr location
               KB_LOCKED (f)
               IF (hXY) 1 csr_str (qS) 
                  "csr_str" "X" yank (tg) "pGRID5" "X1" bank
                  no VIEW-UPDATE

                \ Wed Aug 17 09:44:27 PDT 2011.  Save tm on ALERTFILE:
                  "pGRID5" "X1" yank dup UDEF <> 
                  IF (tg) tm "PG5" alertdata_put 
                  ELSE "PG5" alertdata_rem
                  THEN

                  (qS)
               ELSE (hXY) drop return 
               THEN
            ELSE (hXY) 1 csr_str (qS)
            THEN (qS)
         THEN
      THEN (qS)
      out cr0 (qS) . nl 
      KB_LOCKED IF 0 0 process_key ELSE cprompt . THEN
   end
\  Set pButton.Button1 = ptr("Button1"):
   "Button1" ptr "pButton" "Button1" bank \ left button function

   inline: Button2 (hXY --- ) \ display values at location in graph
{     Display the XY values corresponding to cursor location in graph 
      to use when setting alerts.  The displayed line is formatted for
      pasting at the prompt of an alert function.

      As with Button 1, if a Ctrl key is pressed while clicking But-
      ton 2, the actual value from the nearest line is used.

      This button works only at the % prompt, and not while connected
      to the real time server.
}
      "auto" "KB_LOCKED" yank IF drop return THEN

      (hXY) dup 1st pry "X" book \ graph time t
      "t" main X nearest @ "X" book 

      "KP" "CTRL" yank \ Ctrl key pressed?
      "KP" "ALT" yank not and 
      "KP" "SHFT" yank not and
      IF (hXY) "'PG' exists?" main
         IF (hXY) 2nd pry (y) push \ this matches the branch in csr_str:
            "PG" main (hP) \ getting Y value from nearest PG curve
            "t" main X bsearch (r f) drop \ r is the row to use
            (hP r) reach bend yes sort (hY) pull (y) nearest @ (nY)
         ELSE (hXY) 2nd pry (nY)
         THEN
      ELSE (hXY) 2nd pry (nY)
      THEN (nY) "Y" book \ perpetual price

{     Price Y at the cursor is a perpetual price.

      Offset rolldelta needs to be removed because it can be different 
      on future days when saved Y is used again to make alerts.  Scal-
      ing is taken out too, because Y will be visible on the screen and
      numbers for some markets look funny.
  
      So what you end up seeing for Y is the quoted price on the day in
      the graph, just like the real time price on that day, but it is 
      missing rolldelta.

      In contrast, the price on the screen from Button 1 includes roll-
      delta so price differences between days are valid, for calcula-
      tion of rises or drops.
 
      From graph time X, get the corresponding index for the day in the 
      database and get rolldelta that needs to be taken out of perpet-
      ual price Y:
}     X tm @ dup "X" book \ machine time
      dup soonest_end +   \ to end of session and correct pit day
      (nt) dup CHdiff1 + mdate @ (nYYYMMDD) "Date" book \ Chicago

      LIB "DATE" yank Date bsearch not (r f)
      IF (r) drop LIB "DATE" yank rows (r) THEN
      (r) "r" book \ index of data 

    \ Note: Rolldelta delta is graph scaled to be like Y.
      Y LIB "ROLLDELTA" yank r pry G-SCALE - (nY) \ remove rolldelta
      (nY) Mkt prices (nY)                        \ remove scaling
      (nY) Mkt n>q (qY) "Y" book                  \ quoted (string)

      out cr0 \ clears ... that may be present if TGRAPH is busy
      Mkt spaced Y spaced + X intstr spaced + X ctime + . nl
      KB_LOCKED IF 0 0 process_key ELSE cprompt . THEN
   end
\  Set pButton.Button2 = ptr("Button2"):
   "Button2" ptr "pButton" "Button2" bank \ middle button function

   inline: Button3 (hXY --- ) \ graph zoom in and out 
{     Wed Mar 17 12:29:42 PDT 2010.  Add Alt key.

      Tue Apr 13 06:46:56 PDT 2010.  Window event processor in term.c
         misses multiple occurrences of the same event, so using two
         keys, ALT+SHFT, for pGRID5 is a bad idea and key release of 
         SHFT is sometimes missed leaving SHFT turned on.  Revise to
         use just SHFT for pGRID5.

      To zoom, require XY preceded on the stack by two matrices for 
      word plot:

         (hPG ht hXY)

      This word fetches matrices PG and t that were created by word 
      tgraph.
 
      If there are points in the CLPBD (see Button1), this word will 
      zoom in; otherwise it will zoom out to the previous view.

      The CLPBD is used by Button1 for two purposes: to show the time 
      and value at the mouse arrow, and to define corner points for a 
      zoom-in region.  

      The program has no way of knowing the purpose of Button1 presses,
      and two or more points in the CLPBD will be interpreted here as 
      points for zoom in, even if they simply are queries of time and 
      value.

      To clear such unwanted points from the CLPBD and force zoom-out 
      to occur, press the Ctrl key just before this button is pressed.

      Here is a restatement of the previous paragraphs:

      When backing out from a zoomed plot using this word, the CLPBD 
      may contain points from the first usage, time and value.  They
      will be used for further zooming, producing inadvertent zoom-in 
      instead of zoom-out.  By also pressing a Ctrl key just before
      this button is pressed, these extraneous points will be cleared
      from the CLPBD and zoom-out will begin at the first unambiguous
      zoom-in region.  

      Once this button has been pressed while the Ctrl key was pressed,
      the Ctrl key can be released and additional presses of only this 
      button will continue zoom out until the graph is again full.

      There is no reason to continue pressing the Ctrl key, and in fact
      that may lead to a problem discussed in the next paragraph.

      The Ctrl key must be released while the graph window still has
      focus, perhaps soon after this button is pressed.  By not releas-
      ing the Ctrl key while the graph window has focus, the program 
      will later act as if it is still pressed and zoom in may fail.  

      Simply pressing and releasing the Ctrl key while the window again
      has focus will clear up the problem.
 
      This problem of zooming sometimes locking up took about a year to
      understand: it was due to my sloppy releasing of the Ctrl key 
      after the mouse arrow had been moved from the graph window to the
      market console window below it.

      Update Mar 2010: Sloppy releasing of the Ctrl key when the mouse 
      arrow moves out of the graph window is ok.  See update note in
      word Button1.
}
      "KP" "CTRL" yank \ Ctrl key pressed?
      "KP" "ALT" yank not and 
      "KP" "SHFT" yank not and
      IF CB_CLR \ clear points from CLPBD if a Ctrl key is pressed
{
         If the Ctrl key is released when the graph window does not 
         have focus, then the handler for the key released event will
         not be called and the key KP.NKEY will remain set, making it 
         appear the key is still pressed when it may not be.

         Then the program will always come here and run CB_CLR, and
         zoom in will cease to work.

         Set the key released flag now, since the key is no longer
         needed for this purpose.

         Since the Ctrl key has a dual purpose with Button1, setting
         it to released here may make Button1 behave unexpectedly.
}
         -1 "KP" "NKEY" bank \ make KP.NKEY invalid
      ELSE
         "KP" "ALT" yank \ Alt key pressed?
         "KP" "CTRL" yank not and 
         "KP" "SHFT" yank not and 
         IF \ delete grid lines made by pGRID4
            (hXY) drop
            KB_LOCKED (f)
            IF "pGRID4" "X1" yank UDEF <> (f)
               UDEF "pGRID4" "X1" bank 
               "PG4" alertdata_rem
               (f) IF no VIEW-UPDATE THEN
            THEN
            KB_LOCKED IF 0 0 process_key ELSE out cr0 cprompt . THEN
            return
         ELSE
            "KP" "SHFT" yank \ Shift key pressed?
            "KP" "CTRL" yank not and 
            "KP" "ALT" yank not and 
            IF \ delete grid lines made by pGRID5
               (hXY) drop
               KB_LOCKED (f)
               IF "pGRID5" "X1" yank UDEF <> (f)
                  UDEF "pGRID5" "X1" bank 
                  "PG5" alertdata_rem
                  (f) IF no VIEW-UPDATE THEN
               THEN 
               KB_LOCKED IF 0 0 process_key ELSE out cr0 cprompt . THEN
               return
            THEN
         THEN
      THEN
      (hXY)
      "KP" "ALT" yank not
      "KP" "SHFT" yank not and
      IF "..." .
         (hXY) "PG t" main (hPG ht) over rows rchop rot xyzoom 2drop
      ELSE (hXY) drop 
      THEN
      out cr0 \ clears ... that may be present if TGRAPH is busy
      KB_LOCKED IF 0 0 process_key ELSE cprompt . THEN
   end
\  Set pButton.Button3 = ptr("Button3"):
   "Button3" ptr "pButton" "Button3" bank \ right button function

   inline: crossed (hA hB --- f) \ flag when curve A crosses B
    \ f is 1 if A has recently crossed above B
    \ f is -1 if A has recently crossed below B
    \ otherwise, f is zero

    \ Also see word crossover1().

      "B" book "A" book
      A 1 endmost B 1 endmost >
      IF A B > dup "t" book totals abs A rows =
         IF 0 ELSE 1 THEN (f)
      ELSE
         A 1 endmost B 1 endmost <
         IF A B < dup "t" book totals abs A rows =
            IF 0 ELSE -1 THEN (f)
         ELSE 0 (f) \ endmost are equal
         THEN
      THEN
      purged "A" book
      purged "B" book

    \ Save in t the first row of A and B where f is true; if f is 
    \ false, then t=-1:
      dup (f) 0<>
      IF 1 t rows items t rake lop 1st pry ELSE -1 THEN "t" book
      (f)
   end

   inline: csr_str (hXY nBTN --- qS) \ string of cursor XY in graph
{     Make a string to display the incoming cursor XY values.
      X is a graph time (seconds) and Y is a price.

      If incoming BTN is 1, the price is based upon cursor Y; if BTN 
      is 3, the price is from the nearest curve to Y at ordinate X 
      (BTN need not be an actual button number; here it is just a flag 
      used for branching).

      Sat Jun 11 15:35:34 PDT 2011.  When CTRL key is pressed for case 
      of nearest price C[r], also show state sigmodel.ST[r].
}
      [ UDEF "X" book

    \ Macros for cursor date:
      {" xdate (nX --- qS) \ cursor graph X (sec) into date string S

       \ Get the day and GMT for cursor graph X using lookup table XY  
       \ made in tgraph:
         (nX) LIB "XY" yank swap (nX) lerp @ (nt) "tX" book

       \ Fake out word gmtime to give date and time in Chicago:
         tX dup CHdiff1 + gmtime (nsec) \ date and time in Chicago
         (nsec) sysdate clocko >SEC (nYYYMMDD nsec) 

         (nsec) time_breakdown 1st 5 items catch \ HH:MM like 21:43
         tX CHdiff1 -3600 / 6 =
         IF " CST " ELSE " CDT " THEN + (qHH:MM) swap

         (nYYYMMDD) date4$ (qDate) +
      "} "xdate" macro

      {" xdate1 (nX --- qS) \ cursor graph X (sec) into date string S
       \ Wed Jun  8 13:02:02 PDT 2011.  This version of macro xdate()
       \ preserves the number of seconds in the time, and is used in
       \ signal() macros for SIGNAL.LOG file entries.

       \ Get the day and GMT for cursor graph X using lookup table XY  
       \ made in tgraph:
         (nX) LIB "XY" yank swap (nX) lerp @ (nt) "tX" book

       \ Fake out word gmtime to give date and time in Chicago:
         tX dup CHdiff1 + gmtime (nsec) \ date and time in Chicago
         (nsec) sysdate clocko >SEC (nYYYMMDD nsec) 

         (nsec) time_breakdown \ HH:MM:SS
         tX CHdiff1 -3600 / 6 =
         IF " CST " ELSE " CDT " THEN + (qHH:MM) swap

         (nYYYMMDD) date4$ (qDate) +
      "} "xdate1" macro

    \ Macro for cursor price:
      {" (nY qMKT --- qP) \ string P for perpetual price number Y of MKT
       \ Incoming price Y is perpetual: scaled plus rolldelta
         (qMKT) dup push
         (nY qMKT) prices (nY1)   \ scaling removed, making 905.25 for W
         pull (nY1 qMKT) n>q (qY) \ format for display, like 9052 for W
      "} "yprice" macro
      ]
      "BTN" book
      Mkt "MKT" book

    \ Keep time X within bounds of max and min of matrix daysget.t:
      (hXY) dup 1st pry (X)
      (X) "t" main dup push 1st pry (X tmin) max (X)
      (X) pull dup rows pry (X tmax) min (X) "X" book

      BTN 3 = IF "t" main X nearest @ "X" book THEN

    \ Calculate the date corresponding to the X cursor position:
      X xdate "t" book

    \ Get the price corresponding to the Y cursor position:
      BTN 1 =
      IF (hXY) 2nd pry (nY) \ Y price is perpetual: scaled plus rolldlta
         (nY) MKT yprice (qY) "Y" book \ Y(MKT) scaling removed
      ELSE BTN 3 =
         IF \ button 3 gives price of nearest line to Y at time X
            (hXY) 2nd pry (y) push
            "PG" main (hP) \ getting Y value from nearest PG curve
            "t" main X bsearch (r f) drop \ r is the row to use
            (r) dup "r" book

            (hP r) reach bend yes sort (hY) pull (y) nearest @ (nY)
          \ This price from PG(r,*) is perpetual; remove scaling:
            (nY) MKT yprice (qY) \ Y(MKT) scaling removed
          \ (qY) "Y" book \ YY
{ 
          \ Discontinued Mon Mar  5 20:15:09 PST 2012
          \ Sat Feb 25 10:50:24 PST 2012.  Show volume:
            (qY) spaced (qY) 
            "P" main (hP) .V catch r pry intstr (V)
            (qY V) + (qY) "Y" book \ YY
}  
          \ Thu Dec 15 04:34:41 PST 2011.  Show traffic (the number of
          \ contracts traded per minute):
            (qY) spaced (qY) 
            "P" main (hP) .dV catch r pry intstr (dV)
            (qY dV) + (qY) "Y" book \ YY
  
{           Discontinued Fri Aug 12 03:21:51 PDT 2011.
          \ Sat Jun 11 15:35:34 PDT 2011.  Next to Y, also show the 
          \ state, an integer from 1 to 6:
            (qY) spaced (qY) 
            "sigmodel" "ST" yank r pry \ sigmodel.ST[r]
            dup 0>
            IF (Y(MKT) ST) intstr + 
            ELSE (Y(MKT) ST) drop strchop \ don't show if it is zero
            THEN (qY)
            (qY) "Y" book \ YY
}
         ELSE \ illegal button
            (hXY) drop "000" "Y" book 
         THEN
      THEN

    \ Put MKT, price and time in the string returned:
      MKT dup MOdo + spaced Y spaced + t + (qS) \ MKT YYY HH:MM
   end

THEN \ end of x11 IF branch

   inline: dV_make (hV --- hdV) \ make volume rate dV, contracts/minute
{     Sat Mar  3 09:04:00 PST 2012

      Create volume rate from decimated volume V with former phrases
      (now used below) from dayget.extend, file mfil.v.

      See note Thu Feb  9 11:23:00 PST 2012 in mfil.v for verification
      that integrated dV produces volume V.
}
      "dV_make" ERRset

      (hV) delta 0 max (hdV)
{
      Jan 18 10:22:14 PST 2012.  Create divisor D for dV/D to account
      for data outages when V remains constant for a number of steps
      and dV is zero.  This gives dV that is the average over the
      period of the outage, rather than a big spike on the step when
      the outage ends:
}     (hdV) 1st over rows items over 0> looking delta 1 max (hD)
      (hdV hD) /by (hdV) \ get average rate when divide by D>1

    \ Tue Jan 31 09:37:06 PST 2012.  Normalize rate dV to contracts
    \ per minute and truncate to integer:
      (hdV) "rdecimate" "SEC" yank 60 / (hdV n) / (hdV)
      (hdV) 0.5 + integer (hdV)
{
      Tue Feb  7 20:30:26 PST 2012.  Ensure no duplicates in dV to 
      avoid a sorting discrepancy when values are equal.  In a real
      time system, the discrepancy arises if a later term matches an
      earlier one, and while sorting the later term is picked instead
      of the earlier one.

      Using the matching later term and its accompanying data means
      that past results, perhaps in a graph or already used to make a
      decision, can be different.  They have been changed by data that
      arrived in the future.

      The choice of which equal value to take can flip-flop depending 
      upon the outcome of the sort--which rows are swapped--when new 
      data is added all the time and there can be duplicates. 
 
      See the discussion in file mfil.v, word hget1(), "July 2008" 
      (search for "As the length of the time vector grows").

      In the phrase below, nonesame() adds a tiny ascending number to
      successive values in dV:
}     (hdV) nonesame (hdV) \ adds small number so none is the same

      ERR \ end "dV_make" ERRset
   end

   inline: dV_MAP (hdV hC b n p s rnow --- hP) \ driver for dV_map
    \ Sat Mar 10 12:14:50 PST 2012.  Driver for dV_map().

    \ Done in postfix; it's hard to imagine writing this, and func-
    \ tion dV_map(), in infix.

      "rnow" book \ row in C and dV at the current time
      "s" book    \ number of histogram levels returned in P
      "p" book    \ number of rows of dV and C data into each histogram
      "n" book    \ number of rows per session in dV, C and P
      "b" book    \ histogram bin size (in points of C)
      "C" book    \ price 
      "dV" book   \ volume traffic counts

      C rows "r" book  
      1 "nw" book

      depth push

      C 1st p items reach s clone (hN1)

      BEGIN
         nw p items (hR) push

         dV peek (hR) reach C pull (hR) reach (hdV hC)
         (hdV hC) b n s dV_map (hNw)

         n nw incr
         nw p + rnow >
      UNTIL

      depth pull - (hN1 hNw ... n) pilen (hN2)

      (hN2) C r other rows - (n)
      (hN2 hC n) endmost s clone (hN3)

      (hN2 hN3) pile (hN)

      0 "C" book 0 "dV" book
   end

   inline: dV_map (hdV hC b n s --- hP) \ traffic mapped to price
{     Thu Mar  8 13:54:08 PST 2012.  Returned P contains s columns of 
      price levels for the s highest traffic levels in previous ses-
      sions, mapping a price histogram of traffic counts dV and price C
      to price levels represented by the columns of P.  

      Incoming dV and C contain traffic and price data for a number of 
      previous sessions; n gives the number of rows per session, and 
      n is less than the number of rows of dV and C.

      Returned P has n rows (the number of rows per session) and applies
      for the entire current session.  Because dV and C are for previous
      sessions, P is known when the current session begins.

      P has s columns: the first column of P is for the bin of highest 
      traffic (highest of the highest), and the last column (column s) 
      is for the bin of lowest (lowest of the highest).

      Again: The s columns of returned P are ordered from highest to 
      lower traffic (lowest traffic may be beyond s, and left behind).
      They are not ordered on price.

      Incoming b is the histogram bin size in points of price C.

      Note that s is the number of histogram levels, or bins, repre-
      sented in the columns of returned P; s is not the number of his-
      togram bins, which is (roughly) 1+(Cmax-Cmin)/b (see function 
      histogram() in src/math.c).
}
      "s" book \ number of traffic levels in P
      "n" book \ number of rows per session in dV, C and P

    \ Make a histogram:
      (hdV hC b) histogram (hH)

      (hH) dup 2nd catch rake (hH0 hH1) lop (hH) \ remove null bins

    \ Sort the histogram on bin counts, highest count first:
      (hH) no 2nd sorton (hH)

    \ Fetch the histogram prices in the first column:
      (hH) 1st catch (hV) \ vector of prices of the most dense bins

    \ If fewer than s bins in V, repeat the row of the least dense one,
    \ the endmost, until there are s:
      (hV) dup rows s <
      IF BEGIN (hV) dup 1 endmost pile dup rows s >= UNTIL (hV) THEN

    \ After sorting, prices in V are now associated with the s most 
    \ dense bins, with most dense in the first row.  Fetch the s most 
    \ dense:
      (hV) 1st s items reach (hV) bend (hR) \ into a row vector
      (hR) n repeat (hP) \ repeated for all rows of session
   end

   inline: havefocus ( --- f) \ true if windows have focus
{     This word has a great impact on performance when there are many
      open windows (typically 10 or more) each displaying the latest
      collected real time data as it arrives asynchronously.

      The real time server (file qcon.v) queues up a window when new
      data for it has arrived, and when it reaches the front of the 
      queue the real time server sends a command to the window to run 
      its word TGRAPH.

      TGRAPH updates the graphics data, draws the plot, and runs signal
      to produce sound alerts.

      If the display does not have focus, there is no need to update
      the graphics data and make a plot.

      Graphics involves large matrices, and 10 or more windows updating
      all the time adds a large work load, which is wasteful (and noisy
      as the hard disk spins fetching and storing out-of-core files) be-
      cause only one display at a time can ever be viewed.

      When this word returns false, meaning the display does not have
      focus, TGRAPH will run signal to sound any alerts, but will not 
      run graphics.  

      When the display comes into focus, the local handler assigned to
      XWindows expose events, word pExpose1 (this file), will automati-
      cally run.  It redraws the plot and also runs TGRAPH to make and 
      show a new plot with all the updates that came along while the 
      window was not exposed. 

      Then as the display remains exposed and the real time server sends
      more TGRAPH commands, this word will return a true flag and TGRAPH
      will again update the graphics data and draw a new plot as it is 
      being viewed, and signal will continue to produce sound alerts.
}  
      [ -1 "tfirst" book 20 (sec) "tdelay" book ]

    \ Several calls to this word when the window is being created appear
    \ to cause the graph to not be drawn.  Always return focus true if
    \ a call is within the delay time:
      tfirst -1 = IF time "tfirst" book true return THEN
      time tfirst - tdelay < IF true return THEN

    \ Two windows, the keyboard window (for interactive input) and the
    \ plot window with the graph, make up this display.  If one of them
    \ has focus, the display has focus:
      winfocus winkey = (f1)              \ keyboard window
      winfocus plotWCB wcb.win pry = (f2) \ plot window (see plot.v)
      (f1 f2) or (f1)

    \ Or, the display has focus if pExpose1 is currently running, as 
    \ indicated by its flag pExpose1.expose:
      (f1) "pExpose1" "expose" yank (f1 f2) or
   end

   inline: hits (qA --- ) \ display list of alert hits A on Mkt
{     Examples:
         "A1" hits \ show A1 price alert hits
         "A" hits \ show all A* price alert hits
         "P" hits \ show all P* price alert hits

      Assumes pattern A occurs in the first 16 characters of an alert
      string.
}
      [ 200 "SIGS" book ]
      " " swap + "A" book
      Mkt strchop _hits dup rows SIGS min endmost (hT) any?
      IF (hT) dup 1st 16 items catch A grepr any?
         IF (hT hR) reach (hT) reversed . nl
         ELSE (hT) drop
            " hits: no hits for " Mkt + . nl
         THEN
      ELSE " hits: no hits for " Mkt + . nl
      THEN
   end

   inline: _hits (qMKT --- hT) \ list of alert hits on MKT from SIG-LOG
{     A hit is an instance when price has hit an alert level in word 
      signal, causing an entry in SIG-LOG.

      Incoming string MKT contains market symbol plus alert name,
      such as:
          SP A1 \ alerts A1 for SP
          HO A2 \ alerts A2 for HO
          W A   \ all alerts for W
      Alert names contain A followed by a number.  Note one space 
      between symbol and alert name.
}
      [ no "BIN" book ]
      BIN filetrue IF BIN fclose THEN
      SIG-LOG old binary "BIN" file     

      BIN purged (hFile hPurged)
      rot uppercase strchop spaced (qMKT) 
      (hFile hPurged qS) fmapleft (hMap) any?
      IF dup 1st catch "POS" book
         2nd catch "LEN" book
         depth push
         POS rows 1st
         DO BIN POS I pry fseek
            BIN LEN I pry fget
         LOOP
         depth pull - pilen

         purged "POS" book
         purged "LEN" book
         BIN fclose
      ELSE
         VOL tpurged
      THEN
   end

   inline: KB_LOCKED ( --- f) \ true if the keyboard is locked
{     Sat Jul 17 08:15:40 PDT 2010

      The keyboard is locked when a word has control of the keyboard,
      such as auto() or REPLAY().  Otherwise, the interactive program 
      has control to run typed phrases followed by the Enter key.

      A word that controls the keyboard needs the following in its
      local library:
         yes "KB_LOCKED" book \ when controlling keys
         no "KB_LOCKED" book  \ when not controlling keys
}
      "auto" "KB_LOCKED" localref exists? 
      IF "auto" "KB_LOCKED" yank IF yes return THEN THEN

      "REPLAY" "KB_LOCKED" localref exists? 
      IF "REPLAY" "KB_LOCKED" yank IF yes return THEN THEN

      no
   end

   inline: KEY_SPECIAL (qK f --- ) \ special action for key K and flag f
{     Fri May  7 10:19:26 PDT 2010

      Nudge the curve defined by key K to the left or right.

      This word increments the lag for curve K in array tgraph.P1_lags,
      and runs macro KEY_SPECIAL.NEW-CURVE on an alarm that will redraw
      the graph (by calling tgraph() and using the new lag) when key 
      action has stopped for SEC seconds.

      Key X in auto_key() zeroes all the lags.
}
      [ {" \ lines from tgraph.TOGGLES that can be nudged:

        "} chop noblanklines (hT)
        any?
        IF (hT) dup 1st word drop backward 1st catch vol2mat bend (nKey)
           (hT nKey) swap 3rd word drop vol2mat bend
           (nKey nCurve) park yes sort 
        ELSE purged
        THEN
        "XY" book

        24 (hr) rdech "rstep" book \ increment

        0.5 "SEC" book

      \ This macro is on an alarm that is continually reset to SEC
      \ seconds in the future as key pressing continues; it finally 
      \ runs after pressing has ceased for SEC seconds:
        {" ( --- )
           "auto" "KB_LOCKED" yank (f) \ only if auto keyboard is locked
           IF yes VIEW-UPDATE THEN
        "} "NEW-CURVE" macro
      ]
      (f) dup 0= 
      XY rows 0= or
      IF (qK f) 2drop return THEN

      (f) "dir" book (qK) str2num "nkey" book

      XY nkey bsearch (r f) 
      IF (r) XY swap 2nd fetch num2str main "nr" book
         "tgraph" "P1_lags" yank (hLags)

         (hLags) dup nr pry rstep dir * + (lag) over
         (hLags lag hLags) nr poke (hLags) 

         (hLags) "tgraph" "P1_lags" bank

         SEC "KEY_SPECIAL" "NEW-CURVE" localref ALARM \ run in SEC
      ELSE (r) drop
      THEN
   end

{ ----

   For KEY_SPECIAL, this is the code that was in tgraph:
      [
        .sizeof 1 null "P1_lags" book
      ]
    \ This block nudges curves left or right according to lags set by
    \ word KEY_SPECIAL; key X zeroes all the lags.

    \ NOTE: the model in sigmodel() is never calculated with these
    \ lags, so calculated curves that use curves that become lagged
    \ will not show the effect of the lag.

      (hPG) push
      P1_lags g_index reach (hLags)
      (hLags) dup rows 1st
      DO dup (hLags) I pry dup 0<>
         IF (n) peek (hPG) I catch (hB) swap (hB n) lag (hB)
            (hB) I peek (hB I hA) cram
         ELSE (n) drop
         THEN
      LOOP (hLags) drop
      pull (hPG) "PG" fbookX

---- }

   inline: KR1 (hEV hW --- ) \ handler for key-released event
{     Fri May  7 14:13:22 PDT 2010 add call to KEY_SPECIAL
      Wed Mar 31 21:50:54 PDT 2010

      This key-released event handler sends a key to the text window
      when a key is pressed and released while the graphics window
      has focus.  The key is sent to word process_key() to give the 
      appearance that it came from key input word getcht2() that
      handles keys for the text window.

      Key processing unrelated to graphics should usually not be done 
      while the graphics window has focus.  For example, keys q and h 
      run .more, and focus must be moved to the text window anyway for
      keys to work in .more.  

      A test showed it was possible to mess up the connection with RT-
      SERVER if q or h were initially run from the graphics window, so 
      capability for q and h is blocked here.

      Keys that are not to be sent to the text window are listed below
      in table T.
}
      [ \ List of keys that should not be recognized:
          "a q h S" words strchop vol2mat bend yes sort "T" book

        \ Macro to flag valid keys:
        {" VALID (qS --- f) 
           T swap str2num bsearch lop not (f) 
           'KP' 'ALT' yank not and   \ no Alt key
           'KP' 'CTRL' yank not and  \ no Ctrl key
        "} "VALID" macro
      ]
      (hEV hW) KR \ run the default key-released handler

      "KR" "NKEY" yank (nkey) \ get the number of the released key
      (nkey) dup "KR" "LKEY" localrun (qK) any? \ key letter
      IF (nkey qK) lop (qK) "KP" "SHFT" yank (f)
         IF uppercase THEN (qK) -1
      ELSE (nkey) dup "KR" "SKEY" localrun (qK) any? \ key symbol
         IF (nkey qK) lop -1
         ELSE (nkey) 0
         THEN
      THEN 

      (nkey 0 or qK -1)
      IF (qK) dup VALID (f)
         IF (qK) 1st byte (nK) time swap (nt nK) process_key
         ELSE 
          \ Run word KEY_SPECIAL to nudge the curve for key K:
            (qK) "KP" "ALT" yank 
            IF 1 \ nudge to the right
            ELSE "KP" "CTRL" yank 
               IF -1 \ nudge to the left
               ELSE 0 
               THEN
            THEN (qK f) KEY_SPECIAL
         THEN
      ELSE (nkey) drop
      THEN
   end
   "KR1" ptr plotECB ecb.kr poke \ KeyReleasedEvent handler

{ --- This version of KR1 works, but uses the network to bounce the 
      key back to getch2().  

      It can't be as robust as the later version above where a macro 
      in auto is run to process the key.  But is kept as an example 
      of something that may be useful in some other context.

   inline: KR1 (hEV hW --- ) \ handler for key-released event
{     Wed Mar 31 14:28:55 PDT 2010

      This key-released event handler sends keys to the text window
      when they are pressed and released while the graphics window 
      has focus.  Keys are obtained in word auto() and sent to word
      auto_key().  

      Only keys that update graphics should be forwarded from here.

      Certain key processing should not be done while the graphics 
      window has focus.  For example, keys q and h run .more, and 
      the program gets on another run level that causes RTSERVER to 
      disconnect.  It reconnects ok, but the display is interrupted 
      with error messages.  

      Keys that are not to be sent to the text window are listed below
      in table T.

      Use SNDSERVER as a backboard to bounce the key back here so it
      comes from a remote and into word key_in().  From there, the key 
      will end up in auto(), coming through word getcht2().

      SNDSERVER is used instead of RTSERVER because SNDSERVER does not
      normally send data to this console.  It is believed that there 
      can be problems trying to send a key command to RTSERVER while 
      RTSERVER is sending real time data update flags here.  

      In the future, perhaps a dedicated KEYSERVER would be useful, but
      acting as a key server may be a good second job for SNDSERVER.
}
      [ \ List of keys that should not be used: 
        "q h" words strchop vol2mat bend yes sort "T" book

        \ Macro to flag valid keys:
          " (qS --- f) T swap str2num bsearch lop not" "VALID" macro
      ]
      (hEV hW) KR \ run the default key-released handler

      "KR" "NKEY" yank "KR" "LKEY" localrun (qK) any?
      IF (qK) dup VALID (f)
         IF (qK) quoted " remotefd remotekeys" + (qS)
            (qS) "auto" "S_SND" yank (nS) any?
            IF (qS nS) remoterun
            ELSE (qS) drop
            THEN
         ELSE (qK) drop
         THEN
      THEN
   end
 --- }

   inline: LIB ( --- qLIB) \ word for active Mkt
      Mkt "lib" + 
   end

   inline: MEV1 (hEV hW --- ) \ handler for mouse motion event
{     Tue Mar 23 18:09:02 PDT 2010

      This mouse motion event handler replaces the default handler
      MEV() in plot.v currently being used.

      In addition to running default handler MEV() in plot.v, this han-
      dler turns off multitasker task TGRAPH_RUN for SEC seconds while
      there is mouse motion, to reduce interference from the real time
      server causing the program to fetch new data while the user is 
      altering the graphics view.

      When mouse motion has ceased for SEC seconds, task TGRAPH_RUN is
      turned back on by alarm MEV1-TASKS.

      It is becoming clear that the idea of having an event handler set
      an alarm isn't just for running the machine.  Setting alarms to
      go off hours or even days in the future can be done when events
      happen in the model, such as things that the voices talk about.
}
      [ 10 "SEC" book

      \ This macro is on an alarm that is continually reset to SEC
      \ seconds in the future as motion continues; it finally runs
      \ after motion has ceased for SEC seconds:
        {" MEV1-TASKS ( --- )
           "auto" "KB_LOCKED" yank (f) \ only if auto keyboard is locked
           IF "TGRAPH_RUN" WAKE 
              TGRAPH_RUN \ run immediately, don't wait for first cycle
           THEN
        "} "MEV1-TASKS" macro
      ]
      "TGRAPH_RUN" SLEEP
      MEV 
      SEC "MEV1" "MEV1-TASKS" localref ALARM \ run in SEC
   end
   "MEV1" ptr plotECB ecb.me poke \ MotionEvent handler

   inline: MCsym (qMkt --- qS) \ Morse code symbol for Mkt
\     Word tracklist in uboot.v contains Morse code symbols for used
\     for Mkt symbols.
      [ tracklist vol2mat bend (hM) 
        "tracklist" "MC" yank vol2mat bend (hMC)
        park yes sort "T" book
      ]
      dup 
      uppercase strchop str2num
      T dup rot bsearch (hT r f)
      IF (hT r) 2nd fetch num2str strchop lop
      ELSE (hT r) 2drop 
         " MCsym: symbol not found: " over + . nl              
      THEN
   end
   
   inline: Mkt ( --- qMKT) \ active market 
      [ "" "MKT" book ] MKT ;

   inline: mktinit (n --- ) \ initialize market model
{     Must be run after func has run word Mkt.

      N in this library is the maximum number of days that can be 
      graphed.

      The first time this function is run, it is for the greatest num-
      of days this analysis will see (for real time during trading, it
      is about 30 days), and the table for converting graph time to 
      machine time is created and saved in LIB.XY for Mkt.

      After the first time, this function runs mdata again for newer
      data and makes a new list of FILES for n days.

      Below is the LIB created by word mdata run by this word, for a 
      case where LIB equals EUlib: 

         % date . nl LIB .m
         Tue May 24 06:00:57 PDT 2011
         EUlib
         % 
         % LIB wholib
          Stack items and words in the library of word EUlib:
           Name      Rows Cols Bytes Type  Description
           NAME      1    5    5     STR   string
           SYM       1    2    2     STR   string
           FILES     40   14   560   VOL   volume
           STEPS     0    0    8     NUM   360
           C         360  1    2880  MAT   dense
           DATE      360  1    2880  MAT   dense
           H         360  1    2880  MAT   dense
           L         360  1    2880  MAT   dense
           OI        360  1    2880  MAT   dense
           ROLLDELTA 360  1    2880  MAT   dense
           V         360  1    2880  MAT   dense
           XY        84   2    1344  MAT   dense
                               22079 total
         % 

      Update March 2012.  Delivery month, DELMO, added to LIB:

         [tops@plunger] ready > date . nl LIB .m 
         Wed Mar 14 15:58:59 PDT 2012
         DJlib
         [tops@plunger] ready > LIB wholib
          Stack items in the library of word DJlib:
           Name      Rows Cols Bytes Type  Description
           NAME      1    5    5     STR   string
           SYM       1    2    2     STR   string
           FILES     40   14   560   VOL   volume
           STEPS     0    0    8     NUM   311
           C         311  1    2488  MAT   dense
           DATE      311  1    2488  MAT   dense
           DELMO     311  1    2488  MAT   dense
           H         311  1    2488  MAT   dense
           L         311  1    2488  MAT   dense
           OI        311  1    2488  MAT   dense
           ROLLDELTA 311  1    2488  MAT   dense
           V         311  1    2488  MAT   dense
           XY        370  2    5920  MAT   dense
                               26399 total

         [tops@plunger] ready > 
}
      [ 0 "N" book ]

      no NUM stkok not
      IF " mktinit: need days, like 5 mktinit" . nl no return THEN

      Mkt chars 0=
      IF (n) drop " mktinit: no market is defined" . nl no return THEN

      "mktinit" ERRset

      (n) 1 max N 0= 
      IF (n) dup "N" book ELSE (n) N min THEN "n" book

    \ Read yearly model data and make MKTlib:
      Mkt "MKT" book
      CATMSG push no catmsg
      MKT mdata drop
      pull catmsg

      LIB "FILES" localref exists?
      IF LIB "FILES" yank dup rows any?
         IF (hT r) quote (qSESS) ELSE (hT) drop "" THEN 
      ELSE ""
      THEN "FSESSION" book

    \ Get FILES to use and store names in LIB:
      MKT 0 n rtsetup (hFILES) 

    \ Check for a new session file since program was started: 
      FSESSION chars any 
      IF (hFiles) dup dup rows quote (qSESS) FSESSION <> 
         IF 
          \ Re-enter (as if func() had called to do setup) to set up 
          \ using new file, then resume (also with new file) this
          \ entry to mktinit:

            (hFiles) \ hold file names on stack 
            n push   \ save n on temp stack

            yes "daysget" "NEW" bank     \ forces initialization
            VOL tpurged LIB "FILES" bank \ wipes out old list
            0 "N" book                   \ re-entry will reset N

          \ Re-enter to initialize func.N files:
            " mktinit: initializing for new session ..." . nl
            "func" "N" yank (N) mktinit 

          \ Resuming:
            (hFiles)      \ resume with held file names
            pull "n" book \ resume with saved n
         THEN
      THEN (hFiles)

      (hFiles) dup LIB "FILES" bank
      (hFiles) "daysget" "NEW" yank 
      IF 
       \ Table XY computed below and stored in word MKTlib is used to 
       \ convert graph time into machine time.  To make the table, get 
       \ a list of dates from the files that will be involved in the 
       \ graph:
         (hFiles) rtdates (hYYYMMDD)

       \ In daysget() (file mfil.v) future sessions will be added.
       \ Add their rows so lookup table XY includes them.  Use count 
       \ daysget.NADD for the number of future days to add.  
   "daysget" "NADD" yank 1 
   DO
         (hYYYMMDD) dup 1 endmost @ dup greg (nYYYMMDD nGreg) swap
         (nYYYMMDD) weekday 6 = \ if Friday, add 3 days, else add 1:
         IF 3 ELSE 1 THEN (n nGreg) + gdate (nYYMMDD+1) pile (hYYYMMDD)
   LOOP
       \ Make the lookup table; words tm and tg show its use:
         (hYYYMMDD) MKT tgraph_lookup1 (hXY) LIB "XY" bank \ lookup tble

       \ Call daysget() for the first time to set things up:
         LIB "FILES" yank daysget (hP ht) 2drop

         no "daysget" "NEW" bank
         -1 "daysget" "tUPDATE" bank \ initialize tUPDATE

         no "signal" "OLDreset" bank
      ELSE (hFiles) drop
      THEN

      ERR \ end "mktinit"
   end
 
   inline: mob ( --- ) \ msource this file with keyword 
      [ "M O B" chpack "KW" book ]
      "mobius.n" KW msource

    \ Note: the following was added as a test that verified a missed
    \ expose event can be corrected (see notes in word pExpose1()).  
    \ It causes significant work load when all consoles are updated 
    \ using this word, so it has been commented out.

    \ Run an expose event in case window missed an expose event while
    \ it was running msource:
    \ "pExpose" "hEV" yank (hE) "pExpose" "hWCB" yank (hWCB) pExpose1
   end

   inline: NSESS ( --- ns) \ number of sessions being displayed
    \ Fri Jan 27 07:36:12 PST 2012
      "..." "REPLAY" yank (f)
      IF "P" main rows 24 (hours) rdech / (ns)
      ELSE "daysget" "FILES" yank rows, "daysget" "NADD" yank + (ns)
      THEN
   end

   inline: ordered (hA hB hC --- hF) \ true if A(k) is min, C(k) is max
{     Sat Jun 11 14:20:44 PDT 2011

      Tests (not exhaustive):
          list: 10 20 30 ; "A" book
          list: 11 21 31 ; "B" book
          list: 12 22 32 ; "C" book

          A B C ordered .m
          C B A ordered .m
          A B reversed C ordered .m
          A reversed B C reversed ordered .m
}
      (hA hB hC) 2 pick 2 pick (hA hB) <=        \ A <= B
      (hA hB hC hF) 3 roll 2 pick (hA hC) <= and \ A <= C and
      (hB hC hF) rev (hF hB hC) <= and           \ B <= C and
   end
      
   inline: pExpose1 (hE hW --- ) \ handler for graph expose event
{     If flag NEW-DATA is true, run VIEW-UPDATE to make a new graph;
      otherwise, just run pExpose (plot.v) to redraw the exposed graph.

      That sounds like a good idea, but it has a problem.  By not run-
      ning pExpose to redraw the exposed graph immediately, one sees a
      a blank window during a noticeable delay while the machine recom-
      putes the updated graph.

      It is better to redraw the exposed graph no matter what, so word
      pExpose is now always run.  But even that requires some finesse 
      using a brief idle, as explained below following "IF NEW-DATA."

      Wed Sep 22 10:37:02 PDT 2010.  Instances occur where switching to
         a market display from the window manager grid icon does not re-
         fresh the graphics display as it should be when it is exposed.  
         When the text window is given focus, the following typed in the
         text window show:
            winfocus winkey = gives true because this is the text window
            winfocus plotWCB wcb.win pry = gives false, as expected be-
               cause I am typing in the text window

         Why didn't plotWCB react to an expose event?  Initially, when
         the display comes up neither window's frame is lit because the
         mouse cursor is in the task manager icon, but most of the time
         the graph is redrawn anyway as it becomes exposed.  At other 
         times, the window remains blank, and is drawn only when the 
         mouse cursor is moved into it.

         Could the times it properly updates be when already there has 
         been an update flag set by TGRAPH_RUN, and so NEW_DATA equals 
         yes?  This is doubtful, because CROSStop or GRIDtop would 
         probably have been set and grid lines would have been drawn 
         when this word ran.

      Thu Sep 23 08:33:16 PDT 2010.  This is probably the reason there 
         is no graph redrawn: the program was busy recomputing the model
         at the time of exposure, and the expose event was missed.  It
         was noticed that the graph is not redrawn when switching to a
         market while the program is busy updating the source with word
         msource, and even after the source update is complete, the 
         graph still remains undrawn.

      Sun Sep 26 15:57:36 PDT 2010.  A fix for this would be to have 
         the console run a phony expose event every time it finishes 
         being busy.  An expose event, without recomputing the model, 
         should not burden the system very much; can this be done with-
         out missing updates to the curves that should be drawn?.  For 
         now, leave things as they are.

         As a test, the following was added to word mob which runs word
         msource and can make the program miss an expose event (this is
         the point made above in Thu Sep 23 08:33:16 PDT 2010):

          \ Run an expose event in case window missed an expose event
          \ while it was running msource:
            "pExpose" "hEV" yank (hE) 
            "pExpose" "hWCB" yank (hWCB) pExpose1

         After the source update was complete, the graph was redrawn,
         unlike the result noted above where the graph remained blank.
}
      [ no "expose" book no "NEW-DATA" book

      \ CROSStop can be toggled; see key "R" in auto_key() and words
      \ R_on, R_off in file qcon.v.  This is the initial setting:
        no "CROSStop" book \ yes to draw crosshair lines on top

      \ GRIDtop can be toggled; see key "E" in auto_key() and words
      \ E_on, E_off in file qcon.v.  This is the initial setting:
        yes "GRIDtop" book \ yes to draw spaced grid lines on top
      ]
      yes "expose" book \ others can check and see that we're here
      (hE hW) pExpose \ redraw exposed graph

      CROSStop (f)
      IF
       \ Redraw crosshair last, so it is on top:
         'pExpose' 'hWCB' yank 'pExpose' 'sX' yank 'pExpose' 'sY' yank
          pGRID3
      THEN

      GRIDtop (f)
      IF
       \ Redraw spaced lines last, so they are on top:
         'pExpose' 'hWCB' yank 'pExpose' 'sX' yank 'pExpose' 'sY' yank
          pGRID4 
         'pExpose' 'hWCB' yank 'pExpose' 'sX' yank 'pExpose' 'sY' yank
          pGRID5 
      THEN

      "auto" "KB_LOCKED" yank (f) \ only if keyboard is locked by auto
      IF NEW-DATA (f)
         IF 
          \ Idle briefly to let pExpose finish the exposed graph before
          \ recalculating the graph; otherwise, a partially exposed 
          \ graph can linger for a number of seconds until the updated
          \ one is finally computed and drawn:
          \ " pExpose1: idling" . nl 
            0.5 idle \ slowing down speeds up the look and feel

            yes VIEW-UPDATE \ calculate and draw updated graph
            no "NEW-DATA" book
         THEN
      THEN

      no "expose" book 
   end
 \ Make word pExpose1() the handler for XWindows ExposeEvent:
   "pExpose1" ptr plotECB ecb.ee poke \ handler for ExposeEvent

   inline: pGRID2 (hWCB sX sY --- ) \ draw grid lines on current plot
{     Fri Feb 11 07:23:47 PST 2011.  Midsession grid lines added, 
         controlled by toggle key P in auto_key().

      Wed Mar  3 11:52:18 PST 2010.  Made DT positive, and changed 
         phrases accordingly, so a rightmost line could be added.

      Tue Mar  2 13:21:53 PST 2010.  Split the phrases for special 
         grid lines from here and into new word pGRID3 to make a GCB 
         with different color.

      This word makes a vertical grid line at each session start.

      Input on the stack is from pExpose that just scaled the plot (see
      plot.v); pExpose is run by pExpose1 in this file.

      The first column of incoming X and Y holds the window range, and 
      the second column holds the graph, or data, range.  

      Times in the X data that range from 0 up to 86400 are for the 
      latest (rightmost) session, i.e., the latest session starts at 
      X = 0.  This means that times are negative for earlier sessions.
      [This became untrue when future days were added; now the last 
       day, a future one, ranges from 0 up to 86400.]

}     [  yes "MIDSESSION" book \ initial setting 

         list: 2 1 ; "Xget" book
         86400 "DT" book \ session time step (sec)

       \ Making graphics context:
         GCBcreate makes GCB \ graphics context block for grid lines
         GAVcreate makes GAV \ graphics attrib vec for grid lines

       \ Setting desired GC attributes in graphics attributes vector:
         0 (initial mask on stack) \ making mask:

          \ Vertical grid line color:

          \ Sun Aug 29 16:43:53 PDT 2010.  Grey20 is not visible in
          \ brighter afternoon light.
          \ "Grey25" colorpix GAV gav.foreground poke GCForeground or

          \ Wed Dec  8 15:48:50 PST 2010.  Grey25 is too bright in new
          \ LED monitor.  
          \ "Grey10" colorpix GAV gav.foreground poke GCForeground or

            "Grey20" colorpix GAV gav.foreground poke GCForeground or

            0            GAV gav.linewidth poke GCLineWidth or
            LineSolid    GAV gav.linestyle poke GCLineStyle or
            1 (Bool yes) GAV gav.expose    poke GCGraphicsExposures or
            GXcopy       GAV gav.function  poke GCFunction or
         (mask) GCB gcb.gam poke \ putting mask bits number into GCB.gam
         "GAV" ptr GCB gcb.gav poke \ gav ptr into GCB.gav

       \ Making graphics context for midsession lines:
         GCBcreate makes GCB1 \ graphics context block for grid lines
         GAVcreate makes GAV1 \ graphics attrib vec for grid lines

       \ Setting desired GC attributes in graphics attributes vector:
         0 (initial mask on stack) \ making mask:
          \ Vertical grid line color:
            "Grey10" colorpix GAV1 gav.foreground poke GCForeground or

            0            GAV1 gav.linewidth poke GCLineWidth or
            LineSolid    GAV1 gav.linestyle poke GCLineStyle or
            1 (Bool yes) GAV1 gav.expose    poke GCGraphicsExposures or
            GXcopy       GAV1 gav.function  poke GCFunction or
         (mask) GCB1 gcb.gam poke \ put mask bits number into GCB1.gam
         "GAV1" ptr GCB1 gcb.gav poke \ gav ptr into GCB1.gav
      ]
      "sY" book 
      "sX" book 
      "WCB" book

    \ A vertical grid line at each session start, and also at the far 
    \ left and the far right:
      sX Xget ndx catch (hXY) DT  
      (hXY DT) over 1st pry DT / abs integer 
      (n) 2 + "n" book \ add 2 for leftmost and rightmost lines
      (hXY DT) n uniform (hx) negate DT + \ +DT shifts all to the right
      (hXY hx) lerp "X0" book
      X0 bend dup pile "X1" book \ session start grid lines

      MIDSESSION 
      IF \ making midsession grid lines:
         X0 2nd pry X0 1st pry - 2 / X0 + (hX)
         (hX) 1st X0 rows items reach 
         (hX) bend dup pile "X2" book
      THEN

    \ This line puts grid lines at midnight, and was used to debug date:
    \ (hXY DT n) uniform 17 3600 * - lerp bend dup pile "X" book

      sY 1st catch "Y" book

    \ Thu Sep  2 21:12:10 PDT 2010
    \ Draw other grid lines first (they will be underneath the ones
    \ drawn here; see pExpose1() to have them appear on top):
      WCB sX sY pGRID5 \ spaced green lines
      WCB sX sY pGRID4 \ spaced blue lines
      WCB sX sY pGRID3 \ crosshairs

    \ Set graphics context for this window:
      WCB GCB 2dup GCcreate

    \ Draw session start grid lines:
      (hWCB hGCB) X1 cols 1st DO 2dup Y X1 I catch line LOOP
      (hWCB hGCB) 2drop

      MIDSESSION 
      IF \ drawing midsession grid lines:
       \ Set graphics context for this window:
         WCB GCB1 2dup GCcreate

       \ Draw midsession grid lines:
         (hWCB hGCB) X2 cols 1st DO 2dup Y X2 I catch line LOOP
         (hWCB hGCB) 2drop
      THEN
   end
 \ Set pGRID.ptrGRID = ptr(pGRID2) and pGRID.GRID = yes:
   "pGRID2" ptr "pGRID" "ptrGRID" bank
   yes "pGRID" "GRID" bank

   inline: pGRID3 (hWCB sX sY --- ) \ draw special grid lines from t now
{     Tue Mar  2 13:21:53 PST 2010.  Make this word using expressions
      from pGRID2.

      This word makes special grid lines that include crosshairs at the
      current time.  These grid lines move with time.

      Input on the stack is from pExpose that just scaled the plot (see
      plot.v); pExpose is run by pExpose1 in this file.

      Set CROSStop in pExpose1 to control whether or not grid lines are
      on top of the curves.

      The first column of incoming X and Y holds the window range, and 
      the second column holds the graph, or data, range.  

      Times in the X data that range from 0 up to 86400 are for the 
      latest (rightmost) session, i.e., the latest session starts at 
      X = 0.  This means that times are negative for earlier sessions.
      [This is no longer true with added future days; now the very last
      day, a future one, ranges from 0 up to 86400.]
}
      [ 
       \ Sun Feb 13 20:07:49 PST 2011.  No lines if A is false; A is
       \ toggled by key t in auto_key():
         yes "A" book 

       \ See pExpose1: set yes "CROSStop" book to draw crosshair lines 
       \ on top; this is toggled by key R.

       \ Making graphics context:
         GCBcreate makes GCB \ graphics context block for grid lines
         GAVcreate makes GAV \ graphics attrib vec for grid lines

      \  Setting desired GC attributes in graphics attributes vector:
         0 (initial mask on stack) \ making mask:

          \ Vertical grid line color:
            "#734A12" \ raw umber
          \ "#603311" \ sign brown
          \ "#691F01" \ maroon5 
          \ "#615E3F" \ tank
          \ "#525C65" \ blue dog 
            (qC) colorpix (nColor) 

            (nColor) GAV gav.foreground poke GCForeground or
            0            GAV gav.linewidth poke GCLineWidth or
            LineSolid    GAV gav.linestyle poke GCLineStyle or
            1 (Bool yes) GAV gav.expose    poke GCGraphicsExposures or
            GXcopy       GAV gav.function  poke GCFunction or
         (mask) GCB gcb.gam poke \ putting mask bits number into GCB.gam

         "GAV" ptr GCB gcb.gav poke \ gav ptr into GCB.gav

         list: 2 1 ; "Xget" book

         86400 "H" book
         H 2 / "W" book
      ]
      "sY" book 
      "sX" book 
      "WCB" book

      sX Xget ndx catch (hXY)

      "..." "REPLAY" yank (f)
      IF -INF ELSE time tg @ integer THEN (t) \ real time bar

      (hXY t) A (f)
      IF (hXY t)  
       \ This uses the fact that matrix t is booked in main (word
       \ TGRAPH makes the same assumption to get time lag):
         (t) "t" main dup time rnow pry (tnow) \ latest real time data
{
         Mon Sep 19 18:20:21 PDT 2011.  With nearly real time data, 
         tnow may be a bit in the future (by a few minutes or so).  
         This is because real time data is sampled more often than the
         decimation interval: real time sampled every minute, decimated
         to every three minutees.  Just let it ride and don't try to fix
         anything:
}        (t tnow) integer dup "TNOW" book (t tnow)

       \ The list of times can be in any order, and lines are drawn
       \ in that order.  Uncomment one of the following sets or add
       \ a new one; also see below for setting lines in the past:

       # Line at t, tnow and +t24:
       \ (t tnow) dup H + (+t24) 3 listn (ht) 

       # Line at t, tnow and +t24 and +t48:
         (t tnow) dup H + (+t24) dup H + (+t48) 4 listn (ht)

       # Wed Oct 27 19:37:18 PDT 2010
       # Line at t, tnow, +t24, +t48, +t72:
       \ (t tnow) dup H + (+t24) dup H + (+t48) dup H + (+t72) 
       \ 5 listn (ht)

       # Sat Oct  2 20:51:55 PDT 2010
       # Line at t, tnow, +t12, +t24, +t36 and +t48:
       \ (t tnow) dup W + (+t12) dup W + (+t24)
       \ dup W + (+t36) dup W + (+t48) 6 listn (ht)

       # Wed Oct  6 09:41:13 PDT 2010 
       # Line at t, tnow, +t12, +t24, +t36:
       \ (t tnow) dup W + (+t12) dup W + (+t24) dup W + (+t36) 
       \ 5 listn (ht)

       # Sun Sep  5 15:51:30 PDT 2010
       # Line at t, tnow, +t12, +t24 and +t48:
       \ (t tnow) dup H 2 / + (+t12) dup H 2 / + (+t24) 
       \ dup H + (+t48) 5 listn (ht)

       # Sat Sep  4 07:05:34 PDT 2010
       # Line at t, tnow, +t12 and +t24:
       \ (t tnow) dup H 2 / + (+t12) dup H 2 / + (+t24) 4 listn (ht)

       # Fri Sep  3 08:13:42 PDT 2010
       # Line at t, tnow, +t6 and +t12:
       \ (t tnow) dup H 4 / + (+t6) dup H 4 / + (+t12) 4 listn (ht)

       # Tue Aug 31 20:05:28 PDT 2010
       # Line at t, tnow, +t6 and +t12 and +t18 and +t24:
       \ (t tnow) dup H 4 / + (+t6) dup H 4 / + (+t12)
       \ dup H 4 / + (+t18) dup H 4 / + (+t24) 6 listn (ht)

       # Wed Aug 18 06:24:56 PDT 2010
       # Line at t, tnow and +t24 and +t48 and +t72:
       \ (t tnow) dup H + (+t24) dup H + (+t48) 
       \ dup H + (+t72) 5 listn (ht)

       # Wed Aug 18 06:24:56 PDT 2010
       # Line at t, tnow and +t24, +t48, +t72 and +96:
       \ (t tnow) dup H + (+t24) dup H + (+t48) 
       \ dup H + (+t72) dup H + (+t96) 6 listn (ht)

         (ht) yes \ A not
         IF \ add lines in the past:
          # Extra lines at times in the past:
            list:
               TNOW H -     (-1 day)
               TNOW H 2 * - (-2 days)
               TNOW H 3 * - (-3 days)
               TNOW H 4 * - (-4 days)
               TNOW H 5 * - (-5 days)
             \ TNOW H 2 / - (-12 hours)
             \ TNOW H 4 / - (-6 hours)
            end (ht htprev) pile
         THEN

         (ht) dup rows "n" book

         (hXY ht) lerp bend dup pile "X" book 

         sY 1st catch "Y" book

       \ Set graphics context for this window:
         WCB GCB 2dup GCcreate

       \ Draw the grid lines:
         (hWCB hGCB) n 1st DO 2dup Y X I catch line LOOP

         (hWCB hGCB) 2drop

      ELSE (hXY t) 2drop

      THEN
   end

   inline: pGRID4 (hWCB sX sY --- ) \ draw special grid lines from X
{     Wed Mar 17 12:29:42 PDT 2010.  Make this word using expressions
      from pGRID2.

      This word makes special grid lines spaced from csr_str.X.
      These lines are blue, while the ones in pGRID5 are green.

      Word Button1 banks csr_str.X into local variable X1.

      Input on the stack is from pExpose that just scaled the plot (see
      plot.v); pExpose is run by pExpose1 in this file.

      Set GRIDtop in pExpose to control whether or not these grid lines
      are on top of the curves.

      The first column of incoming X and Y holds the window range, and 
      the second column holds the graph, or data, range.  

      Times in the X data that range from 0 up to 86400 are for the 
      latest (rightmost) session, i.e., the latest session starts at 
      X = 0.  This means that times are negative for earlier sessions.
      [This is no longer true with added future days; now the last day,
      a future one, ranges from 0 up to 86400.]

}     [ \ Making graphics context:
         GCBcreate makes GCB \ graphics context block for grid lines
         GAVcreate makes GAV \ graphics attrib vec for grid lines

      \  Setting desired GC attributes in graphics attributes vector:
         0 (initial mask on stack) \ making mask:

          \ Vertical grid line color:
            "#003F87" colorpix (nColor) \ sign blue

            (nColor) GAV gav.foreground poke GCForeground or
            0            GAV gav.linewidth poke GCLineWidth or
            LineSolid    GAV gav.linestyle poke GCLineStyle or
            1 (Bool yes) GAV gav.expose    poke GCGraphicsExposures or
            GXcopy       GAV gav.function  poke GCFunction or
         (mask) GCB gcb.gam poke \ putting mask bits number into GCB.gam

         "GAV" ptr GCB gcb.gav poke \ gav ptr into GCB.gav

         list: 2 1 ; "Xget" book

         UDEF "X1" book \ word Button1 banks valid X1 here
                        \ word Button3 banks UDEF X1 here
{
       \ Two to the right and six to the left of the point clicked 
       \ (after scaling, last list item 3 is tossed):
         list: -6 -5 -4 -3 -2 -1 0 1 2 3 ; "DT0" book
} 
       \ Four to the right and four to the left of the point clicked 
       \ (after scaling, last list item 5 is tossed):
         list: -4 -3 -2 -1 0 1 2 3 4 5 ; "DT0" book
 
         no "HALF" book \ toggled by key W in auto_key()
      ]
      "sY" book 
      "sX" book 
      "WCB" book

      X1 UDEF = IF return THEN

      HALF
      IF "pGRID3" "H" yank 2 /
      ELSE "pGRID3" "H" yank
      THEN "H" book DT0 H * "DT" book

      "t" main X1 nearest @ "t" book
      "t" main 1st pry "tmin" book
      "t" main dup rows pry "tmax" book

      sX Xget ndx catch (hXY)

    \ Making extra lines relative to t:
      t DT + tmax tmin limited (ht)
      (ht) \ dup rows "n" book

      (hXY ht) lerp nodupes (hX) 
    \ Highest might be off the right end, so toss it:
      (hX) 1st over rows 1- items reach \ toss highest 
      (hX) bend dup pile "X" book
      
      sY 1st catch "Y" book

    \ Set graphics context for this window:
      WCB GCB 2dup GCcreate

    \ Draw the grid lines:
      (hWCB hGCB) X cols 1st DO 2dup Y X I catch line LOOP

      (hWCB hGCB) 2drop
   end

   inline: pGRID5 (hWCB sX sY --- ) \ draw special grid lines from X
{     Sat Mar 20 10:01:07 PDT 2010

      Works just like pGRID4, but responds to different keys pressed.
      These lines are green, while the ones in pGRID4 are blue.

      This word makes special grid lines spaced from csr_str.X.
      Word Button1 banks csr_str.X into local variable X1.

      Input on the stack is from pExpose that just scaled the plot (see
      plot.v); pExpose is run by pExpose1 in this file.

      The first column of incoming X and Y holds the window range, and 
      the second column holds the graph, or data, range.  

      Times in the X data that range from 0 up to 86400 are for the 
      latest (rightmost) session, i.e., the latest session starts at 
      X = 0.  This means that times are negative for earlier sessions.
      [This is no longer true with added future days; now the last day,
      a future one, ranges from 0 up to 86400.]

}     [ \ Making graphics context:
         GCBcreate makes GCB \ graphics context block for grid lines
         GAVcreate makes GAV \ graphics attrib vec for grid lines

      \  Setting desired GC attributes in graphics attributes vector:
         0 (initial mask on stack) \ making mask:

          \ Vertical grid line color:
          \ "#215E21" \ huntergreen
            "#004F00" \ dumpster 
            colorpix (nColor) 

            (nColor) GAV gav.foreground poke GCForeground or
            0            GAV gav.linewidth poke GCLineWidth or
            LineSolid    GAV gav.linestyle poke GCLineStyle or
            1 (Bool yes) GAV gav.expose    poke GCGraphicsExposures or
            GXcopy       GAV gav.function  poke GCFunction or
         (mask) GCB gcb.gam poke \ putting mask bits number into GCB.gam

         "GAV" ptr GCB gcb.gav poke \ gav ptr into GCB.gav

         list: 2 1 ; "Xget" book

         UDEF "X1" book \ word Button1 banks valid X1 here
                        \ word Button3 banks UDEF X1 here

         "pGRID4" "DT0" yank "DT0" book
      ]
      "sY" book 
      "sX" book 
      "WCB" book

      X1 UDEF = IF return THEN

      "pGRID4" "HALF" yank
      IF "pGRID3" "H" yank 2 /
      ELSE "pGRID3" "H" yank
      THEN "H" book DT0 H * "DT" book

      "t" main X1 nearest @ "t" book
      "t" main 1st pry "tmin" book
      "t" main dup rows pry "tmax" book

      sX Xget ndx catch (hXY)

    \ Making extra lines relative to t:
      t DT + tmax tmin limited (ht)
      (ht) \ dup rows "n" book

      (hXY ht) lerp nodupes (hX)
    \ Highest might be off the right end, so toss it:
      (hX) 1st over rows 1- items reach \ toss highest
      (hX) bend dup pile "X" book

      sY 1st catch "Y" book

    \ Set graphics context for this window:
      WCB GCB 2dup GCcreate

    \ Draw the grid lines:
      (hWCB hGCB) X cols 1st DO 2dup Y X I catch line LOOP

      (hWCB hGCB) 2drop
   end

   inline: prices (hC qName --- hC1) \ remove scaling
{     Redefinition of prices to account for graph scaling done here
      (see word G-INIT).  This word replaces word prices just sourced
      from mrc.v.

      The next line is the text from word prices, file mrc.v:
}     dprices

\     Unscale dC1 returned by dprices:
      (hdC1) G-UNSCALE (hdC1)
   end

   inline: process_key (nt nK --- ) \ send key to controlling word
{     Sat Jul 17 08:34:36 PDT 2010

      Incoming (nt nK) appear just like getcht2() when it returns key K
      and its time.

      When the keyboard is locked by a controlling word, run its local
      macro called process_key.  Each controlling word has an entry
      below, such as "REPLAY" for word REPLAY in file mfil.v.

      If a controlling word listed below does not process keys from 
      this word, it must contain the following default macro (also see 
      word KB_LOCKED()):
         "(nt nK) 2drop" "process_key" macro
}
      "auto" "KB_LOCKED" localref exists? (f)
      IF "auto" "KB_LOCKED" yank (f)
         IF (nt nK) "auto" "process_key" localrun return THEN
      THEN

      "REPLAY" "KB_LOCKED" localref exists? (f)
      IF "REPLAY" "KB_LOCKED" yank (f)
         IF (nt nK) "REPLAY" "process_key" localrun return THEN
      THEN

      (nt nK) 2drop
   end

   inline: rchop (hA1 r --- hA) \ A is the first r rows of A1
    \ Fri Jul 16 10:35:20 PDT 2010

    \ Example: Making rows of t equal to rows of PG for xyzoom
    \    (hPG ht) over rows rchop (hPG ht) ... xyzoom

      (hA1 r) over rows over (rows r) >
      IF 1st swap items reach ELSE drop THEN
   end

   inline: rnext ( --- nrow) \ row in P(t) where next session starts
      t (hTg) time dup soonest_start + tg @ (hTg ntg) bsearch drop
   end

   inline: rnow (htg ntime --- nrow) \ row for ntime, but not in future
{     Times in graph time tg extend into the future, so the present 
      time will not be the last row in the matrix.  This word returns
      the closest row corresponding to ntime, and if ntime comes from
      word time, rnow will correspond to the time nearest the present.

      If ntime is after the market has closed, nrow will correspond to
      the last time the market was open.

      Mon Sep 19 10:30:31 PDT 2011.  With near real time data now avail-
      able, the 180 second spacing means a real time data point can be
      placed 3 minutes into the future.  Time row daysget.tnow gives the
      latest time row even it is in the future.  Simply use it for rnow:
}
      2drop "daysget" "tnow" yank
    \ rtime "daysget" "tnow" yank min \ don't allow time in the future
   end

   inline: rstart ( --- nrow) \ row in P(t) where current session starts
\     Returns 0 if not currently in a session.

    \ THIS WORD DOES NOT WORK CORRECTLY; JUST RETURN 0:
    \ See replay_init (mfil.v) for finding when sessions start.

      0 return

      time soonest_end time soonest_start > \ not in a session>
      IF zero
      ELSE t (hTg) date sysdate drop session_start rnow
      THEN
   end

   inline: rtime (htg ntime --- nrow) \ row corresponding to time ntime
{     Times in graph time tg extend into the future, so the present
      time will not be the last row in the matrix.  This word returns
      the closest row corresponding to ntime, and if ntime comes from
      word time, rnow will correspond to the time nearest the present.
}
      swap (htg) tm swap (hTm ntime) bsearch drop
   end

   "soonest_task" missing
   IF
    \ RToffline will need word soonest_task provided by mget.v:
      usrpath "mget.v" + "#def timeline" "#end timeline" msource1
   THEN

   inline: RToffline ( --- ) \ program is ignoring the RT socket
{     The purpose of this word is to set an alarm on RTSERVER that
      will sound if this console is too long off line.  Without the
      alarm, it is possible for a user to cause the console to cease
      tracking its market for long periods, by inadvertently leaving
      in focus the text window of a signal listing (key q) or a help 
      screen display (key h).

      Going offline does not mean the socket connection is closed.

      Running this word does not affect the socket connection in any
      way, and RTSERVER will continue sending bytes to this console
      even if it has declared itself off line.

      Tell RTSERVER that this console is going off line.  Going off 
      line probably means this console is running a shell script to 
      display signals or the help file, and may miss data sent from 
      RTSERVER.

      This word causes RTSERVER to set a flag to check periodically if 
      this console has told it that it is back on line (by the console
      running RTonline to make RTSERVER unset the flag) and if it has 
      not, to sound an alarm after too much time.
}
    \ Return if time is not during market hours:
      soonest_task (f) not IF return THEN

      "auto" "S" yank (nS) any?
      IF "S" book
         S client_open (f)
         IF depth push 
         \ RTSERVER can be busy; don't wait around, and clean up the
         \ stack if remoterun did not finish correctly for some reason:
           Mkt quoted " client_offline" + S (hT nSocket) remoterun
           depth pull - dump
         ELSE " RToffline: RT server is not connected" . nl
         THEN
      THEN
   end

   inline: RTonline ( --- ) \ program is paying attention to RT socket
    \ Tell RTSERVER that this console is on line.
      no "RECONN" book

      "auto" "S" yank (nS) any?
      IF "S" book
         S client_open (f)
         IF S yes SELECT 

            Mkt quoted " client_online ACK" + S remoterun1 (f)
            IF \ " RTonline: back on line" . nl
            ELSE " RTonline: ACK from RTSERVER not received" . nl
               yes "RECONN" book
            THEN

         ELSE " RTonline: RT server has disconnected" . nl 
            yes "RECONN" book
         THEN

         RECONN (f)
         IF " RTonline: reconnecting to RT server" . nl
            S sclose -1 "S" book
            1 idle \ give RT server a second to close at its end

          \ Reconnect to RT server:
            -1 "auto" "S" bank
            "auto" "CONN_RT" localrun

            "auto" "S" yank (nS) dup -1 =
            IF " RTonline: connection to RT server failed" . nl
               (nS) drop
            ELSE (nS) "S" book
               " RTonline: reconnected to RT server on socket "
               S intstr + ", " + date + . nl
            THEN
         THEN 
      THEN
   end

   inline: setkeys ( --- ) \ source tgraph() with new changes to keys
    \ Aug 18 07:58:41 PDT 2011

    \ Includes changes made to colors, since they are defined in the
    \ library of word tgraph().

      "mobius.n" "#def auto_key" "#end auto_key" msource1
      "mobius.n" "#def tgraph" "#end tgraph" msource1
      "mobius.n" "#def vgap"    "#end vgap" msource1
   end

   inline: setreset (nS hR --- ) \ zero a subset of signal times
{     Zero TIME for all the signals in group R except for S, which is 
      left unchanged.  S is intended to be the signal currently in ef-
      fect.

      This word is important because it allows a signal's wait time to
      be zeroed so it can come back on any time its conditions are met
      again, without first waiting for its wait time to expire to zero.

      Warning: This word can cause bizarre behavior when used incor-
      rectly.  The elements of the subset of R that are reset should
      be downstream of S; a reset signal upstream of S can play over
      and over, and things get even worse if the upstream element re-
      sets the guilty downstream element S.

      Fetch signal.TIME, change its values and put it back.  Array 
      signal.TIME is zero-based (for reason now lost).

      Note: since this word was written, word SET-TIME0 has been written
      to zero TIME for a signal.  It could have been used below to loop
      over the signals in R (but everyone knows that a ram, and then a
      poke, is better--and faster--than a loop).
}
    \ Mon Jul 26 16:56:05 PDT 2010.  If R is empty (purged MAT or empty
    \    STR), forget it and return:
      (nS hR) any? not IF (nS) drop return THEN (nS hR)

      xbase push 0based

      (hR) nodupes push \ row numbers
      "S" book
      "signal" "TIME" yank "TIME" book
      TIME S pry "sig" book
      peek (hR) rows 1 null (hB) pull (hR) TIME (hB hR hA) ram
      sig TIME S poke
      TIME "signal" "TIME" bank
      purged "TIME" book

      pull indexbase
   end
{
   Word SIG-LOG has been moved to uboot.v, so other programs can see
   it too. 
   Word -SIG-LOG in uboot.v is used to trim file SIG-LOG.

   inline: SIG-LOG ( --- qFile) \ name of signal log file
      [ "HOME" env "SIGNAL.LOG" catpath "log" book ] log
   end
}
   inline: sigCQ ( --- qWAV) \ .wav file for CQ signal
    \ Thu May 20 19:53:22 PDT 2010
      [ yes "CQ" book ]
      CQ IF "cq75.wav" ELSE "pulse.wav" THEN
   end

   inline: signal (hP ht --- ) \ signal when price hits alerts
\     Incoming prices in P are perpetual.
      [
      \ September 2009: trying 30 minutes between the same signal
        1800 "DT" book \ minimum seconds between the same signal
      \ 900 "DT" book \ minimum seconds between the same signal

        0 "NT" book \ number of steps seen
        -1 "S" book \ socket to sound server

      \ These are based on data rate:
        .75 rdech "NPOS" book \ 45 minute period for POS signal changes
        9 60 / rdech "DTVCHG" book \ 9 minute step for computing VCHG 

      \ Note: VCHG is the change over the assumed step DTVCHG, not the
      \ change from the last session (which is column .dC in P struct):
        0 "VCHG" book \ price change from previous signal, for voice

      \ MC value is set here by word auto:
        no "MC" book   \ yes doing Morse code, no doing voice
        3 "NPLAY" book \ times to play Morse code signal

        no "CHECKED" book \ true after checking for old format

      \ Use these columns from P struct for high and low:
        .Hm ".HIGH" book \ high of current session half
        .Lm ".LOW" book  \ low of current session half
        INF "OLDlo" book
        -INF "OLDhi" book

        no "OLDreset" book
      ]
      SYSOUT "SYSOUTsav" book

    \ Return if there is no socket to the sound server:
      "auto" "S_SND" yank "S" book S -1 = (f)
      IF (hP ht) 2drop return THEN

\" Top of signal" . timeprobe nl

      (hP ht) soundon? 

    { Tue Jun  7 09:24:04 PDT 2011
      The sound server socket test below (socket_ack1) means that sud-
      den updates to all the market consoles can innundate the sound
      server with socket_ack1 requests.  
      Is that why it hangs up sometimes?  Skip this test for now.

      Thu Oct 13 07:28:37 PDT 2011
      Reinstate the following test.  Instead of socket_ack1, use word
      client_open to see if S still has a valid client.  It works very 
      well when the sound server becomes disconnected.
    } 
      IF 
       \ Test the socket to the sound server:

       \ S socket_ack1 not
       \ IF " signal: socket_ack1 has timed out;"

         S client_open not
         IF " signal: sound server client is invalid;"
            " reconnecting to sound server" + . nl

            S sclose -1 "S" book

          \ Reconnect to the sound server:
            -1 "auto" "S_SND" bank
            "auto" "CONN_SND" localrun

            "auto" "S_SND" yank (nS) dup -1 =
            IF " signal: connection to sound server failed" . nl 
               (nS) drop (hP ht) 2drop 

               BEEP BEEP BEEP \ does not use sound server

               return
            ELSE "S" book (hP ht)
               " signal: reconnected to sound server on socket " 
               S intstr + ", " + date + . nl 
            THEN
         THEN (hP ht)
      THEN (hP ht)

\" signal: after test socket to sound server" . timeprobe nl

      "signal" ERRset

      no "sigPLAYED" book \ yes if psignal calls ALERT to play

      (hP ht) over "_P" book dup "_t" book

    \ Due to future data in P, the last row is later than now, and
    \ is the wrong one to use when voicing alerts for now; use the 
    \ row for time now from word rnow:
      (hP ht) dup time rnow (nrow) "RNOW" book \ row for time now

    \ Mon Feb  7 05:32:35 PST 2011.  Adjust certain variables if mid-
    \ session has been crossed:
      (hP ht) dup RNOW pry (tnow) dup push
      (tnow) 86400 + tSESS pull (tnow) - "dt_NOW" book \ dt remaining
      dt_NOW 43200 < \ crossed midsession?
      IF OLDreset not
         IF yes "OLDreset" book
            INF "OLDlo" book  \ begin tracking low of last half session
            -INF "OLDhi" book \ begin tracking high of last half session
         THEN
      THEN

    \ Locally booked t and P0 contain no future rows:
      (hP ht)
      1st RNOW items push
      (ht) peek reach "t" book  \ no future t rows
      (hP) pull reach "P0" book \ no future P rows

    \ Custom P signals depend upon data generated in sigmodel().

    \ This is a P signal entry from SIGNAL.LOG; it has a P in it:
    \   GC P bravo101+belowtrlow 8210 -340 16:42 CST Mon Jan 12, 2009

    \ This section is set up to run Morse code or voice.  Run Morse
    \ code if MC is true, otherwise run voice. 

      [ 
\ : signal
\ { ----------- 

        80 1 null "TIME" book \ uses zero-based indexing
        TIME "TIME-PREV" book \ rows correspond to TIME rows
        TIME "WCQ" book       \ rows correspond to TIME rows

      \ Signal numbers are rows in array TIME.  
          0 (n)

        \ Names and indices for signal numbers (current base is 1,
        \ so these will work for 0- or 1-based if ndx is used):
          1+ dup "newlow"  book
          1+ dup "newhigh" book

          1+ dup "+bstop" book
          1+ dup "-bstop" book

          1+ dup "+sstop" book
          1+ dup "-sstop" book

          1+ dup "pit_soon" book
          1+ dup "pit_trading" book

          1+ dup "pit_soon_close" book
          1+ dup "pit_has_closed" book

          1+ dup "flat" book

          1+ dup "echo1" book
          1+ dup "echo2" book
          1+ dup "echo3" book
          1+ dup "echo4" book
          1+ dup "echo5" book
          1+ dup "echo6" book
          1+ dup "echo7" book
          1+ dup "echo8" book

          1+ dup "lima1" book
          1+ dup "lima2" book
          1+ dup "lima3" book
          1+ dup "lima4" book
          1+ dup "lima5" book
          1+ dup "lima6" book
          1+ dup "lima7" book
          1+ dup "lima8" book

          1+ dup "tango1" book
          1+ dup "tango2" book

          1+ dup "dot0" book
          1+ dup "dot1" book
          1+ dup "dot2" book
          1+ dup "dot3" book

          1+ dup "foxtrot1" book
          1+ dup "foxtrot2" book

          1+ dup "able1" book
          1+ dup "able2" book
          1+ dup "baker1" book
          1+ dup "baker2" book

          1+ dup "bravo101" book
          1+ dup "bravo102" book
          1+ dup "bravo103" book

          1+ dup "sierra101" book
          1+ dup "sierra102" book
          1+ dup "sierra103" book

          1+ dup "delta101" book
          1+ dup "delta102" book
          1+ dup "delta103" book

          1+ dup "keeper1" book
          1+ dup "keeper2" book

          1+ dup "keystone1" book
          1+ dup "keystone2" book

          (n) TIME rows > 
          IF " signal: array TIME exceeded, h" "alting" + 10 repeat
             . nl "h" "alt" + main
          THEN

      \ Sets of signals that get their TIMEs reset by word setreset:
        list: 
           able1 baker1
           able2 baker2
           lima1 lima2 lima3 lima4 lima5 lima6 lima7 lima8
           echo1 echo2 echo3 echo4 echo5 echo6 echo7 echo8 flat
           tango1 tango2
           dot0 dot1 dot2 dot3
           foxtrot1 foxtrot2
           keeper1 keeper2
           keystone1 keystone2
           bravo101 bravo103 thru
           sierra101 sierra103 thru
        end "SET_ABWARN" book

      \ New low resets these downstream sets:
        list: newlow -sstop -bstop pit_soon pit_trading
              pit_soon_close pit_has_closed
        end SET_ABWARN pile 
        "SETnewlow"  book 

      \ New high resets these downstream sets:
        list: newhigh +sstop +bstop pit_soon pit_trading
              pit_soon_close pit_has_closed
        end SET_ABWARN pile 
        "SETnewhigh" book

      \ New high and new low phrases use STset and RTset.  Below are
      \ initial purged arrays that may be redefined below:
        0 1 null "STset" book
        0 1 null "RTset" book
            
\ : signal
\ ----------- } 

      \ ATTN is for first-time attention, ATTNR is for a reminder
      \ of a signal already voiced.  ATTNCQ is first-time attention
      \ plus CQ to get full attention, even if sound sig flag is 
      \ turned off (see word soundon?).
        no "ATTN" book   \ set to yes to play ATTNsig in psignal
        no "ATTNR" book  \ set to yes to play ATTNRsig in psignal
        no "ATTNCQ" book \ set to yes to play ATTNCQsig in psignal

      \ When PRIORITY=true, it doesn't matter what sig or scq equals:
        no "PRIORITY" book \ set yes to force any signal in psignal

        2 "NEWhilo_max" book

        INF "NEWlo" book
        NEWhilo_max "NEWlo_count" book

        -INF "NEWhi" book
        NEWhilo_max "NEWhi_count" book

        no "sigPLAYED" book \ set to yes when signal has just played

        300 "NPIT" book \ seconds alert that pits will open soon
        300 "NPITC" book \ seconds alert that pits will close soon

{       Note: There is a flaw in the way attention (ATTN) signals, 
        like tink and CQ (dah dit dah dit, dah dah dit dah), are 
        handled in conjunction with signal voices.

        ATTN signals and signal voices are input to the sound queue 
        separately, one right after the other.  But it is possible 
        for an ATTNsig (or ATTNCQsig or ATTNRsig) to sound and not 
        be followed by the intended voice, because a different market 
        inserted its entry into the sound queue a split second after
        the ATTNsig and before the accompanying signal voice was sent.

        ATTN signal files and voice files can be different in format 
        (such as sample rate), so fixing this problem by adding the
        voice to the signal file is not as straight forward as append-
        ing a couple of sound files into one.

        And adding files may not be appropriate.  Voice files always
        get amplified to max level before they are played, but sound 
        files, like cq50.wav, have levels that have been set to desired 
        values and should be left alone.

        This same problem may occur for an INTRO file played in macro
        ALERT, but the attention command and voice are sent back-to-
        back so there is less chance for them to become separated (in 
        fact, it may be impossible, since a single VOL is sent with
        both wavque_add commands to be run).
}
      \ ATTNCQsig is used in place of ATTNsig at times when a more
      \ jarring attention signal is needed.

      \ ATTNsig ( --- ) \ tink + "Attention please"
      \ Tink + "Attention please"
      \ Note: phrase 0 'vSig' 'LAST' bank causes "Attention please"
        "'vSig' 'VPATH' yank 'tink.wav' + wavData wavFile1 "
        "wavque_add " + "0 'vSig' 'LAST' bank" + quoted
        " S remoterun" + "ATTNsig" macro

      \ ATTNCQsig ( --- ) CQ + "Attention please"
      \    dah dit dah dit, dah dah dit dah + Attention please
      \ Note: phrase 0 'vSig' 'LAST' bank causes "Attention please"
      \ Plays whether or not sound sig flag is on.
        "'CQ' 1 SIG wavque_add 0 'vSig' 'LAST' bank" quoted
        " S remoterun" + "ATTNCQsig" macro

      \ ATTNRsig ( --- ) \ tink + reminder
      \ Tink + "Reminder" or "Again note"
        "'vSig' 'VPATH' yank 'tink.wav' + wavData wavFile1 "
        "wavque_add " + "yes 'vSig' 'REMIND' bank" + quoted
        " S remoterun" + "ATTNRsig" macro
      ]

\   { Begin the P signals --------------------
{
      Looks for signals in the last NPOS steps (example: NPOS=10 is
      30 minutes for a 3 minute step size (step size is set in word 
      rdecimate, file mfil.v)).

      New data arrives in batches for recent times, not just for the 
      latest.  Just taking the last value risks getting no signal by 
      missing a nearby signal that is in the latest batch of updates 
      but is not the very last one.
}        
      P0 NPOS RNOW rstart - min 1 max endmost "P" book

      no "ATTN" book     \ set to yes to play ATTNsig in psignal
      no "ATTNR" book    \ set to yes to play ATTNRsig in psignal
      no "PRIORITY" book \ set to yes to override flags in ALERT
      "" "VCHG" book     \ default, no price change in macro ALERT

      "" "INTRO" book \ intro file to play before voice (for example,
                      \ see macro ABCROSS)
      "" "ABINTRO" book 

      twice "NPLAYV" book \ times to play voice signal

\-----------------------------------------------------------------------

    \ Look for new session low:
    \ P .LOW catch delta totals @ 0<> \ any change?

    \ Tue Apr 12 20:27:00 PDT 2011.  Lm as .LOW is a 4-hour moving min,
    \ and therefore can move up.  Restrict to looking at last delta 0<. 
      P .LOW catch delta 1 endmost @ 0< \ last change negative?
      IF P .LOW catch 1 endmost @ "NEWlo" book

         NEWlo OLDlo < 
         IF NEWlo "OLDlo" book
            newlow SET-TIME0 \ new is lower, so force now

            newlow GET-WCQ (f)
            IF soundon?
               IF sigCQ                  \ plays cq or substitute
               ELSE yes "ATTNCQ" book "" \ plays macro ATTNCQsig
               THEN
               (qFile) "INTRO" book
            ELSE
               yes "ATTN" book \ attention
            THEN
            
            1 "NEWlo_count" book
            true (f)
         ELSE 
            1 NEWlo_count bump NEWlo_count NEWhilo_max >
            IF false
            ELSE 
               yes "ATTNR" book \ reminder
               true
            THEN (f)
         THEN (f)
         IF newlow GET-TIME-PREV (tPREV) push

            "newlow" (qsig) newlow psignal

            sigPLAYED
            IF time peek (tPREV) - DT >
               IF newlow SETnewlow STATEsets pile setreset \ after DT
               ELSE \ always reset these
                  newlow STATEsets setreset 
               THEN
            THEN
            pull (tPREV) drop

            yes

         ELSE no 
         THEN (f)

         "" "INTRO" book

      ELSE no (f)
         P .LOW catch 1 endmost @ "OLDlo" book
      THEN (f) "fNEWLOW" book

    \ Look for new session high:
    \ P .HIGH catch delta totals @ 0<> \ any change?

    \ Tue Apr 12 20:27:00 PDT 2011.  Hm as .HIGH is a moving max,
    \ and therefore can move down.  Restrict to last delta 0>. 
      P .HIGH catch delta 1 endmost @ 0> \ last change positive?

      IF P .HIGH catch 1 endmost @ "NEWhi" book

         NEWhi OLDhi > 
         IF NEWhi "OLDhi" book
            newhigh SET-TIME0 \ new is higher, so force now

            newhigh GET-WCQ (f)
            IF soundon?
               IF sigCQ                  \ plays cq or substitute
               ELSE yes "ATTNCQ" book "" \ plays macro ATTNCQsig
               THEN
               (qFile) "INTRO" book
            ELSE
               yes "ATTN" book \ attention
            THEN

            1 "NEWhi_count" book
            true (f)
         ELSE 
            1 NEWhi_count bump NEWhi_count NEWhilo_max >
            IF false
            ELSE
               yes "ATTNR" book \ reminder
               true
            THEN (f)
         THEN (f)
         IF newhigh GET-TIME-PREV (tPREV) push

            "newhigh" (qsig) newhigh psignal

            sigPLAYED
            IF time peek (tPREV) - DT >
               IF newhigh SETnewhigh STATEsets pile setreset \ after DT
               ELSE \ always reset these
                  newhigh STATEsets setreset 
               THEN
            THEN
            pull (tPREV) drop

            yes

         ELSE no 
         THEN (f)

         "" "INTRO" book

      ELSE no (f)
         P .HIGH catch 1 endmost @ "OLDhi" book
      THEN (f) "fNEWHIGH" book
  
\" signal: check high and low done" . timeprobe nl

\-----------------------------------------------------------------------
{
      If a stop was hit in the prior session and it is still in place, 
      messages of it being crossed will continue to be heard even though
      current session highs and lows make this impossible.  To fix this,
      manually redefine the stop in the current session so its set-time
      is updated to the present time.

      Word scancel run from the real time server is handy for clearing 
      stops for all markets.
}      
    \ Look for price above the buy stop (or buy stop below price):
      "+b" alertdata (0 or hA -1)
      IF (hA) 

         dup type MAT <>
         IF " signal: stops data is old format; run scancel" . nl
            "HALTING" . nl sockets sclose HALT 
         THEN

         dup 1st pry 0>
         IF (hA) P0 t other 2nd pry time t_between (hP1) any?
            IF (hP1) push (hA) 1st pry
               (nB) peek .C catch (nC) Mkt prices Mkt n>q numerate (hC)
               (nB) pull .H catch (nC) Mkt prices Mkt n>q numerate (hH)
               rot (hC hH nB) +stop (f)
               IF yes "PRIORITY" book
                  yes soundon? IF "ATTN" ELSE "ATTNCQ" THEN book
                  "abovebuystop" (qsig) +bstop psignal
               THEN
            ELSE (hA) drop
            THEN
         ELSE (hA) drop
         THEN
      THEN

    \ Look for price below the buy stop (or buy stop above price):
      "-b" alertdata (0 or hA -1)
      IF (hA) dup 1st pry 0>
         IF (hA) P0 t other 2nd pry time t_between (hP1) any?
            IF (hP1) push (hA) 1st pry
               (nB) peek .C catch (nC) Mkt prices Mkt n>q numerate (hC)
               (nB) pull .L catch (nC) Mkt prices Mkt n>q numerate (hL)
               rot (hC hL nB) -stop (f)
               IF yes "PRIORITY" book
                  yes soundon? IF "ATTN" ELSE "ATTNCQ" THEN book
                  "belowbuystop" (qsig) -bstop psignal
               THEN
            ELSE (hA) drop
            THEN
         ELSE (hA) drop
         THEN
      THEN

    \ Look for price above the sell stop (or sell stop below price):
      "+s" alertdata (0 or hA -1)
      IF (hA) dup 1st pry 0>
         IF (hA) P0 t other 2nd pry time t_between (hP1) any?
            IF (hP1) push (hA) 1st pry
               (nS) peek .C catch (nC) Mkt prices Mkt n>q numerate (hC)
               (nS) pull .H catch (nC) Mkt prices Mkt n>q numerate (hH)
               rot (hC hH nS) +stop (f)
               IF yes "PRIORITY" book
                  yes soundon? IF "ATTN" ELSE "ATTNCQ" THEN book
                  "abovesellstop" (qsig) +sstop psignal
               THEN
            ELSE (hA) drop
            THEN
         ELSE (hA) drop
         THEN
      THEN

    \ Look for price below the sell stop (or sell stop above price):
      "-s" alertdata (0 or hA -1)
      IF (hA) dup 1st pry 0>
         IF (hA) P0 t other 2nd pry time t_between (hP1) any?
            IF (hP1) push (hA) 1st pry
               (nS) peek .C catch (nC) Mkt prices Mkt n>q numerate (hC)
               (nS) pull .L catch (nC) Mkt prices Mkt n>q numerate (hL)
               rot (hC hL nS) -stop (f)
               IF yes "PRIORITY" book
                  yes soundon? IF "ATTN" ELSE "ATTNCQ" THEN book
                  "belowsellstop" (qsig) -sstop psignal
               THEN
            ELSE (hA) drop
            THEN
         ELSE (hA) drop
         THEN
      THEN

\" signal: check stops done" . timeprobe nl

\-----------------------------------------------------------------------

    \ Curve crossings.
      yes "DO_CROSS" book

{ ---
      DO_CROSS (f)
      IF
       \ Curve A crossing curve B in the recent past:

         "" "ABINTRO" book
         P0 PAST endmost (hP) push 

       \ When price crosses midline:
         peek (hP) .C .A 
         "midfielder1 midfielder2 " STset$ RTset$ 3 pilen "" ABCROSS
         pull (hP) drop


This is kept as an example of using future data.

       \ Curve A crossing curve B in the near future:

       \ When curves have waves that result in too many estimates of 
       \ upcoming crossings, set this flag to no:
         yes "UPCOMING" book

no "UPCOMING" book

         NSIGF -1 = UPCOMING and
         IF _P RNOW 1+ FUTURE items reach (hP) push
          \ TANGO
            peek (hP) .A catch peek .M catch crossover1 (hF)
            dup rake lop any? 
            IF 
             \ Take 1st nonzero, since results are in the future:
               1st pry 
            ELSE 0 
            THEN (f) dup 0<>
            IF (f) 0>
               IF P 1 endmost dup .tP pry swap .M pry < \ now tango1?
                  IF "upcoming+tango2" ELSE "" THEN
               ELSE P 1 endmost dup .tP pry swap .M pry > \ now tango2?
                  IF "upcoming+tango1" ELSE "" THEN
               THEN (qS) any? IF (qS) "" 2 purged WSIG THEN
            ELSE (f) drop 
            THEN
            pull (hP) drop
         THEN

      THEN
--- }

\" signal: check crossings done" . timeprobe nl

\-----------------------------------------------------------------------

\ More Warnings
\ : signal Crossings and Warnings

      [
      \ Signal states (see ST, RT and UT in sigmodel()):
          "keystone1 keystone2" (qS)
          (qS) words "STset$" book list: STset$ local ; "STset" book
 
          "bravo101 bravo102 bravo103 sierra101 sierra102 sierra103"
          (qS) words "UTset$" book list: UTset$ local ; "UTset" book

          "lima1 lima2 lima3 lima4 lima5 lima6 lima7 lima8 " 
          "echo1 echo2 echo3 echo4 echo5 echo6 echo7 echo8 flat" +
          (qS) words "RTset$" book list: RTset$ local ; "RTset" book

          UTset STset RTset 3 pilen "STATEsets" book
      ]
 
    \ This style signals when an event has happened in the PAST period 
    \ of time (PAST = 45 minutes):
      "sigmodel" "ST" localref exists?
      IF "sigmodel" "ST" yank (hST) 
         1st RNOW items reach PAST endmost dup 0<> rake lop (hST) any?
         IF (hST) 1 endmost @ (n) STset$ swap quote strchop (qSIG)
            (qSIG) "" once STset UTset RTset 3 pilen (hReset) WSIG
         THEN 
      THEN

    \ This style signals when an event has happened in the PAST period 
    \ of time (PAST = 45 minutes):
      "sigmodel" "UT" localref exists?
      IF "sigmodel" "UT" yank (hUT) 
         1st RNOW items reach PAST endmost dup 0<> rake lop (hUT) any?
         IF (hUT) 1 endmost @ (n) UTset$ swap quote strchop (qSIG)
            (qSIG) "" once UTset RTset pile (hReset) WSIG
         THEN 
      THEN

    \ This style signals once only when an event happens:
      "sigmodel" "RT" localref exists?
      IF "sigmodel" "RT" yank (hRT) RNOW pry any?
         IF (n) RTset$ swap quote strchop (qSIG)
            (qSIG) "" once RTset (nReset) WSIG
         THEN
      THEN
{ ---

    \ This style signals once only when an event happens:
      "sigmodel" "ST" localref exists?
      IF "sigmodel" "ST" yank (hST) RNOW pry any?
         IF (n) STset$ swap quote strchop (qSIG)
            (qSIG) "" once STset UTset RTset 3 pilen WSIG
         THEN
      THEN

    \ This style signals when an event has happened in the PAST period 
    \ of time (PAST = 45 minutes):
      "sigmodel" "ST" localref exists?
      IF "sigmodel" "ST" yank (hST) 
         1st RNOW items reach PAST endmost dup 0<> rake lop (hST) any?
         IF (hST) 1 endmost @ (n) STset$ swap quote strchop (qSIG)
            (qSIG) "" once STset WSIG
         THEN 
      THEN

--- }

{ ---

This is kept as an example of using future data.

      -1 "NSIGF" book 
      STname P 1 endmost (hP) .ST pry quote strchop (qSIG) any?
      IF (qSIG) dup local "NSIGF" book "" 2 STset WSIG THEN

      _P RNOW 1+ FUTURE items reach (hP) push
      peek .C catch peek .B1 catch > totals @ 0<>
      IF NSIGF sierra102 <> IF "upcoming+sierra102" ELSE "" THEN
      ELSE
         peek .C catch peek .S1 catch < totals @ 0<>
         IF NSIGF bravo101 <> IF "upcoming+bravo101" ELSE "" THEN
         ELSE
            NSIGF delta102 <> IF "upcoming+delta102" ELSE "" THEN
         THEN
      THEN (qSIG) any? IF (qSIG) "" 2 purged WSIG THEN
      pull drop

      [
        list: lima1 lima2 dot1 dot2 echo1 echo2 ; "SMset" book
      ]
      P 1 endmost (hP) push
      -1 "NSIGF" book
      peek .C pry peek .tP pry > "SDIR" book
      peek .SM pry 1 =
      IF SDIR IF "lima2" ELSE "lima1" THEN
      ELSE peek .SM pry -1 =
         IF SDIR IF "echo2" ELSE "echo1" THEN
         ELSE SDIR IF "dot2" ELSE "dot1" THEN
         THEN
      THEN (qSIG) dup local "NSIGF" book "" 2 SMset WSIG
      pull drop
 
      _P RNOW 1+ FUTURE items reach 1 endmost (hP) push
      peek .C pry peek .tP pry > "SDIR" book
      peek .SM pry 1 = 
      IF SDIR
         IF NSIGF lima2 <> IF "upcoming+lima2" ELSE "" THEN
         ELSE NSIGF lima1 <> IF "upcoming+lima1" ELSE "" THEN
         THEN
      ELSE peek .SM pry -1 = 
         IF SDIR
            IF NSIGF echo2 <> IF "upcoming+echo2" ELSE "" THEN
            ELSE NSIGF echo1 <> IF "upcoming+echo1" ELSE "" THEN
            THEN
         ELSE \ peek .SM pry 0=
            no \ skip upcoming+dot because tango is very close.
            IF SDIR
               IF NSIGF dot2 <> IF "upcoming+dot2" ELSE "" THEN
               ELSE NSIGF dot1 <> IF "upcoming+dot1" ELSE "" THEN
               THEN
            ELSE ""
            THEN
         THEN
      THEN (qSIG) any? IF (qSIG) "" 2 purged WSIG THEN
      pull drop

--- }

\" signal: check warnings done" . timeprobe nl

\-----------------------------------------------------------------------

      [ 0 "Blag" book

        yes "ABreset" book
      \ Signal number set by ABCROSS and WSIG:
        -1 "NSIG" book \ -1 means no signal 

        DT \ minimum seconds between the same signal
      \ Points for times in the past:
        (nDT) 1.5 * 3600 / (hr) rdech "PAST" book 

        2 (hr) rdech "FUTURE" book \ points for times in the future

        \ These are reset when ABCROSS fires certain signals:
          "" "ABset" book
          twice "ABplay" book

        {" ABCROSS (hP nA nB qSIG qADD --- ) \ curve P(A) crossing P(B)

{          The first two elements of incoming string SIG are the local
           names for two rows in local vector TIME and are also the
           voice names for two signal files.  The first element of SIG
           applies to P(A) crossing below P(B) and the second to P(A) 
           crossing above P(B).  The remaining elements of SIG, if any,
           are other rows in local vector TIME that will be reset (by 
           setreset()) if a signal is given; an example is ABset.

           String ADD is a voice file that will be added in front of 
           the signal voice.  ADD is an empty string to add nothing.

           Blag in the local library can be set just before running 
           this word to the number of steps to lag curve B.  When this 
           word finishes, Blag is again set to zero.

           File ABINTRO will be played if signal is for crossing above
           and previous signal was for crossing below, or vice-versa.
           But playing ABINTRO will be superceded by playing cq.wav if 
           flag WCQ is on.  Examples:

              To turn on WCQ for tango1 (word wcq does this):
                 yes (f)
                 "signal" "tango1" yank (i)
                 (f i) "signal" "SET-WCQ" localrun

              To check WCQ flag for foxtrot2:
                 "signal" "foxtrot2" yank (i) 
                 (i) "signal" "GET-WCQ" localrun
}
           no "ABflag" book \ true if crossed, even if no sigPLAYED

         \ Voice addon:
           (qADD) strchop dup chars any IF "+" + THEN "ADD" book 

           depth push (qSIG) dup local 
           depth pull - listn "R" book \ voice row set in TIME

           (qSIG) words "SIG" book     \ voice file names

           (nB) "B" book (nA) "A" book \ curve cols in P

           (hP) push                   \ P to local stack

           peek A catch 
           peek B catch Blag lag (hA hB)
           (hA hB) crossed (f) dup 0<>

           IF (f) 0< IF 1st ELSE 2nd THEN (n) push \ first or second
              yes "ABflag" book
              no "ABnew" book

              ADD SIG peek (n) quote strchop + 
              "VSIG" book \ voice to use

              R pull (n) pry (nSIG) "NSIG" book \ voice row to use

              R 1st pry GET-TIME-PREV
              R 2nd pry GET-TIME-PREV min (oldest)
            \ When previous NSIG is oldest, play intro because this
            \ is a new instance of NSIG (it hasn't been seen for a
            \ while):
              NSIG GET-TIME-PREV (oldest tnsig) =
              IF yes "ABnew" book \ allow setreset
                 ABINTRO (qFile)
              ELSE no "ABnew" book \ do not force setreset
                 "" (qFile)
              THEN 
              (qFile) "INTRO" book 

              NSIG GET-WCQ (f)
              IF soundon? 
                 IF sigCQ                \ plays cq or substitute
                 ELSE 
                  \ Note that "scq" alertdata (f) must be true also
                  \ because sound is off and this is a big interruption;
                  \ see file qconset.v for setups.
                    yes "ATTNCQ" book "" \ plays macro ATTNCQsig
                 THEN
                 (qFile) "INTRO" book
              THEN

              NPLAYV push ABplay once max "NPLAYV" book 
              VSIG NSIG psignal \ play the signal
              pull (n) "NPLAYV" book

              sigPLAYED (f) 
              IF ABreset (f1) ABnew (f2) and
                 IF NSIG R \ R is a column matrix
                    (nS hR) setreset \ reset other set R rows
                 THEN
              ELSE -1 "NSIG" book
              THEN

              "" "INTRO" book \ reset to empty

           ELSE (f) drop
              -1 "NSIG" book
           THEN
           pull (hP) drop
           0 "Blag" book
           yes "ABreset" book
           NPLAYV "ABplay" book \ always set back to default

        "} "ABCROSS" macro
      ]

      [ 
      \ Downstream warnings that may be reset by macro WSIG: 
        0 1 null "SET_WSIG" book

        {" WSIG (qSIG qADD nPlay hR --- ) \ play a general signal
         \ Note: ADD is said before SIG, not after SIG.

         \ R is a NUM>0 or a MAT:
           dup type NUM = 
           IF dup 0> IF hand ELSE drop purged THEN (hR) 
           ELSE (hR) dup type MAT <> IF drop purged THEN (hR)
           THEN (hR) "R" book

           (nPlay) "ABplay" book

           (qADD) strchop dup chars any IF "+" + THEN "ADD" book 
           (qSIG) "VSIG" book
        
           VSIG local "NSIG" book

           NSIG GET-WCQ (f)
           IF soundon? 
              IF sigCQ                \ plays cq or substitute
              ELSE 
               \ Note that "scq" alertdata (f) must be true also
               \ because sound is off and this is a big interruption;
               \ see file qconset.v for setups.
                 yes "ATTNCQ" book "" \ plays macro ATTNCQsig
              THEN
           ELSE ""
           THEN
           (qFile) "INTRO" book

           NPLAYV push ABplay once max "NPLAYV" book 
           ADD VSIG + NSIG psignal \ play the signal
           pull (n) "NPLAYV" book

           sigPLAYED (f) 
           IF R cols any \ R is a column matrix
              IF NSIG R (nS hR) setreset THEN
           ELSE -1 "NSIG" book
           THEN

           "" "INTRO" book
           NPLAYV "ABplay" book \ always set back to default

        "} "WSIG" macro
      ]

\-----------------------------------------------------------------------

      time GMT>LA ctime sysdate drop weekday 2 6 within \ Mon - Fri
      IF NPLAYV push once "NPLAYV" book \ play only once

       \ Alert that the pit will open soon, or that it is now open:
         date sysdate drop session_start Mkt pit_open + (tPIT)
         time - (nDT) dup 0> 
         IF (nDT) NPIT < 
            IF "pit_soon" pit_soon (qST nST) psignal THEN
         ELSE (nDT) abs NPIT <
            IF "pit_trading" pit_trading (qST nST) psignal THEN
         THEN

       \ Thu Oct  6 14:51:53 PDT 2011
       \ Alert that the pit will close soon, or that it has closed:
         date sysdate drop session_start Mkt pit_close + (tPIT)
         time - (nDT) dup 0>
         IF (nDT) NPITC <
            IF "pit_soon_close" pit_soon_close (qST nST) psignal THEN
         ELSE (nDT) abs NPITC <
            IF "pit_has_closed" pit_has_closed (qST nST) psignal THEN
         THEN

         pull "NPLAYV" book
      THEN

\-----------------------------------------------------------------------

\     End the P signals --------------------- }

      purged "_P" book
      purged "_t" book

      purged "P0" book
      purged "t" book

      ERR \ end "signal" 

      SYSOUTsav set_sysout

      [ \ Macros in the library of word signal:

        {" ALERT (SIG qS qP qChg --- ) ALERT signal S at price P for Mkt
{         This word is set up to run Morse code or voice.  Run Morse
          code if MC is true, otherwise run voice.

          Incoming SIG can be a number to play (only if MC) or a signal
          string to play.

          Incoming price string P is as-quoted for display in the log. 

          Time shown in the log is the time right now, when this signal
          is played, and is later than the quote time when it occurred. 

          Delays between quote time and signal time are due to:

             Quote delay by exchanges, perhaps by 30 minutes 

             Collection delay due to sample interval (about 3 to 5 
                minutes)

             Distribution delay from collection machine to this machine
                (estimated at 1 to 4 minutes)

             Local real time queue delay (estimated at 1 to 10 minutes 
                depending on the number of markets being followed and 
                how many are already queued up)
}
\    " Top of signal.ALERT" . timeprobe nl

          SIG-LOG set_sysout \ vector output to SIG-LOG

        \ Write an entry in SIG-LOG that looks like this (if voice):
        \    DJ P bravo101 8170 31 23:34 CST Mon Dec 1, 2008
        \ Note that the time given is the Chicago time that this alert
        \ was broadcast, not the time when the price shown occurred.

          (SIG qS qP qChg) push
          (SIG qS qP) 
          MC 
          IF Mkt " (" + Mkt MCsym + ") " + 
          ELSE Mkt spaced
          THEN
          rot (qS) spaced + swap (qP)
          spaced + pull (qChg) spaced +
          time tg "csr_str" "xdate1" localrun + (qS) \ Chicago date
          (qS) . nl

          (SIG) dup type NUM =
          IF (SIG) intstr \ alert number, like the 2 from A2
          THEN (qSIG) 

          PRIORITY not
drop yes \ ignore PRIORITY; it is kind of redundant with ATTNCQ

          IF ATTNCQ not
             IF soundon? not
                IF " signal.ALERT: sound for " 
                   Mkt + " is turned off" + . nl
                   (qSIG) drop
                   SYSOUTsav set_sysout
                   return 
                THEN
             THEN
          THEN
          
          MC
          IF
           \ Phrase for Morse code.
           \ Make a phrase to run words SIG and wavque_add on the sound 
           \ server, like: "W 2" 5 SIG wavque_add (words SIG and 
           \ wavque_add are in snd.v):
             (qSIG) Mkt MCsym spaced (qMKT) \ symbol, like D for DJ
             swap (qSIG) + quoted spaced (qMKT+SIG)
             NPLAY (n) intstr + \ number of times to play
             " (qMKT+SIG n) SIG (qWav) wavque_add" + (qT) 

          ELSE 
           \ Phrase for voice.
           \ Make a phrase to run words vSig and wavque_add on the sound
           \ server: 
             (qSIG) Mkt quoted spaced swap 
             (qSIG) quoted + spaced (qMKT+SIG) 

             " '' " + \ empty nP (place holder for future price string)

             VCHG type NUM = \ change since last quote:
             IF VCHG intstr spaced ELSE " '' " THEN + 

             NPLAYV (n) intstr + \ number of times to repeat

{          \ Debugging:
                SYSOUTsav set_sysout 
                "snd.v" source  main vSig wavPlayf
                "ALERT HAL" "TING" + . nl HALT
}
             " (qMKT qSIG nP nChg n) vSig (qWav) wavque_add" + (qT) 

             INTRO chars any \ intro file to play before the voice 
             IF "'vSig' 'VPATH' yank 'X' + wavData wavFile1 wavque_add"
                "X" INTRO strp
                swap pile
             THEN

          THEN (qT)

        \ Play the phrase (qT) on the sound server:
          (qT) S 0>
          IF (qT) S remoterun
          ELSE " signal.ALERT: " swap + . nl \ for testing
          THEN

          SYSOUTsav set_sysout

\    " signal.ALERT: exit" . timeprobe nl

        "} "ALERT" macro

        {" GET-TIME (i --- sec) \ get TIME[i] 
           xbase push 0based (i) TIME swap pry (sec) pull indexbase
        "} "GET-TIME" macro

        {" SET-TIME (i --- ) \ set TIME[i] 
           xbase push 0based (i) push time DT + 
           (t) TIME pull (i) poke pull indexbase
        "} "SET-TIME" macro

        {" SET-TIME0 (i --- ) \ zero TIME[i] 
         \ Making TIME[i] equal to zero will play signal i without delay
           xbase push 0based 
           (i) 0 TIME rot poke pull indexbase
        "} "SET-TIME0" macro

        {" SET-TIMEt (t i --- ) \ set TIME[i] to t
           xbase push 0based
           (t i) TIME swap (i) poke pull indexbase
        "} "SET-TIMEt" macro

        {" GET-TIME-PREV (i --- sec) \ get TIME-PREV[i]
         \ This is the actual time when signal i was previously given
           xbase push 0based 
           (i) TIME-PREV swap pry (sec) pull indexbase
        "} "GET-TIME-PREV" macro

        {" SET-TIME-PREV (t i --- ) \ set TIME-PREV[i] to t
         \ This is the actual time when signal i is given
           xbase push 0based
           (t i) TIME-PREV swap (i) poke pull indexbase
        "} "SET-TIME-PREV" macro

        {" GET-WCQ (i --- f) \ get WCQ[i]
           xbase push 0based (i) WCQ swap pry (sec) pull indexbase
        "} "GET-WCQ" macro

        {" SET-WCQ (f i --- ) \ set WCQ[i] to f
           xbase push 0based (i)
           (f) WCQ swap (i) poke pull indexbase
        "} "SET-WCQ" macro

        {" psignal (qsig i --- ) \ set up and run macro ALERT
         \ Incoming qsig can be a NUM or a STR.  Incoming i is the
         \ signal number which is its row in array TIME.

\    " Top of signal.psignal" . timeprobe nl

         \ Beeps ATTNsig if ATTN is set, then sets ATTN to no.

           no "sigPLAYED" book

           "psignal.signal" ERRset

           (qsig i) push (qsig) 

           time peek (i) GET-TIME > 
           IF 
            \ If there is a "sig" flag, and it is off, turn off ATTN or
            \ ATTNR flag, but not ATTNCQ flag:
              soundon? not IF no "ATTN" book, no "ATTNR" book THEN 

            \ ATTNCQ is controlled by separate flag "scq," so alerts 
            \ can be given even if sound flag "sig" is off:
              "scq" alertdata (0 or f -1) \ is flag for CQ sound off?
              IF (f) 0= 
                 IF no "ATTNCQ" book THEN 
              THEN
          
              ATTN ATTNR or ATTNCQ or
              IF Mkt " attention " + 
                 time tg "csr_str" "xdate1" localrun + \ Chicago date
                 SIG-LOG set_sysout \ vector output to SIG-LOG
                 . nl
                 SYSOUTsav set_sysout

                 ATTNCQ 
                 IF ATTNCQsig \ major first time attention

                    "rng" alertdata (0 or f -1)
                    IF (f) 0<> \ is flag for ringme on?
                       IF ringme \ run phoneALARM
                          Mkt " P phone_alarm - - " +
                          time tg "csr_str" "xdate1" localrun + \ Ch 
                          SIG-LOG set_sysout \ vector output to SIG-LOG
                          . nl
                          SYSOUTsav set_sysout
                       THEN
                    THEN

                 ELSE ATTNR
                    IF ATTNRsig  \ reminder of previous
                    ELSE ATTNsig \ first time attention
                    THEN
                 THEN
              THEN

              "P " over (qsig) dup type NUM =
              IF intstr THEN + (SIG qS)
              P 1 endmost dup .C catch Mkt prices Mkt n>q (qP)
              swap .dC catch Mkt prices Mkt n>q (qChg)

              (SIG qS qP qChg) ALERT
              yes "sigPLAYED" book \ even if sound is turned off

              time (t) peek (t i) SET-TIME-PREV \ time now for signal(i)
              peek (i) SET-TIME \ earliest future time to run signal(i)
              
           ELSE (qsig) drop
           THEN pull (i) drop

           no "ATTN" book 
           no "ATTNR" book 
           no "ATTNCQ" book 
           no "PRIORITY" book 

           ERR \ "psignal.signal" ERRset

\    " signal.psignal: exit" . timeprobe nl

        "} "psignal" macro
      ] 

\" Exit signal" . timeprobe nl

   end \ : signal
\  halt

   inline: sigreset ( --- ) \ zero all the previous signal times
\     Set signal.TIME to zero, so very recent signals will replay.
      "signal" "TIME" yank dims null "signal" "TIME" bank
   end

   inline: t_after (hP htg t --- hP1) \ data P after machine time t
{     Return rows of P(tg) that are later than machine time t. 
      Incoming machine t is converted to graph time to match tg.

      Always returns P1 with at least one row because bsearch finds 
      nearest below.  Thus a returned one-row P1 may be before t, but 
      this is preferable to returning nothing if t is beyond the last
      time in tg.
}
      (hP htg t) tg @ bsearch drop (r)
      (hP r) over rows thrulist reach (hP1)
   end

   inline: t_before (hP htg t --- hP1) \ data P before machine time t
    \ Return rows of P(tg) that are earlier than machine time t.
    \ Incoming machine t is converted to graph time to match tg.
      (hP htg t) tg @ bsearch drop (r) \ nearest below
      (hP r) 1 max 1st swap items reach (hP1)
   end

   inline: t_between (hP htg t1 t2 --- hP1) \ data P between t1 and t2
    \ Return rows of P(tg) that are between machine times t1 and t2.
    \ Incoming times in tg are graph times, not machine times.
      (t2) "t2" book (t1) "t1" book (htg) dup push
      (hP htg) t2 t_before (hP2) pull dup (htg) t2 t_before (ht2)
      (hP2 ht2) t1 t_after (hP1)
   end

   inline: tg (hTm --- hTg) \ machine time into graph time
      [ "list: 2 1 ; ndx catch" "COLSWAP" macro ]

    \ Word tm is the inverse of this word, to convert graph time 
    \ into machine time.

      (hTm) LIB "XY" yank COLSWAP swap (hXY hTm) lerp (hTg) 
      dup rows 1 = IF @ THEN
   end
 
   inline: TGRAPH ( --- ) \ driver for automatic updates
{     This word is run by multitasker word TGRAPH_RUN when new data 
      has been collected.  It is also run by VIEW-UPDATE to update
      and display graph.
}
      [ no "BUSY" book   \ prevents another run if already running
        no "UPDATE" book \ yes forces daysget() to run if ET > SEC
        600 "SEC" book   \ max ET since last daysget()

        yes "REMOTE_DATA" book 

    \ Macro to display last prices and delay time:
      {" LAST ( --- qLAST)
         Mkt dup MOdo + spaced
         P .H pry Mkt "csr_str" "yprice" localrun + spaced (H)
         P .L pry Mkt "csr_str" "yprice" localrun + spaced (L)
         P .C pry Mkt "csr_str" "yprice" localrun + spaced (C)
         P .dC pry Mkt "csr_str" "yprice" localrun + spaced (dC)

       \ Latest t is t(rnow):
         "t" main dup time rnow pry \ row for time now
         "csr_str" "xdate1" localrun + (shows HH:MM:SS)
       \ "csr_str" "xdate" localrun +  (shows HH:MM)

       \ Show time delay in minutes:
         time push " (" peek ctime 12 12 items ndx catch ", " + +
         pull "csr_str" "tX" yank 
         - 60 / .5 + integer (dt) intstr + " min ago)" + +
      "} "LAST" macro
      ]
      BUSY IF return THEN \ in case there is an extraneous call
      yes "BUSY" book

\ " Top of TGRAPH" . timeprobe nl
      "TGRAPH" ERRset

      "auto" "KB_LOCKED" yank (f) \ only if keyboard is locked by auto
      IF "..." .
         "TGRAPH_RUN" SLEEP

         UPDATE (fa) \ flag set by VIEW-UPDATE
       \ Set f1 true if it has been SEC or more since tUPDATE:
         time "daysget" "tUPDATE" yank - SEC > (fa fb) and (f1)

         REMOTE_DATA (f2) \ flag set by TGRAPH_RUN

         (f1 f2) or
         IF " receiving " . 

            LIB "FILES" yank daysget (hP ht) \ have new updates
\ " TGRAPH: have new updates" nl . timeprobe nl

            out dup 0> IF cr0 ELSE drop cr THEN "..." .

         ELSE 
          \ Get matrices P and t, booked in main by daysget on the 
          \ last update:
            "P" main (hP) "daysget" "BYTE" yank fix_dC (hP) "t" main
\ " TGRAPH: using booked matrices" . timeprobe nl
         THEN (hP ht)

       \ Latest data (non-future) row into row-vector P:
         (hP ht) 2dup (hP ht) time rnow (hP nrow) reach "P" book

         (hP ht) havefocus (f) \ if this display has focus
         IF (hP ht) 2dup 
\ " TGRAPH: have focus, calling tgraph" nl . timeprobe nl
            tgraph (hP ht) \ update 
\ " TGRAPH: tgraph updating done, calling tplot" . timeprobe nl
            tplot (hP ht) \ redraw graph P(t)
\ " TGRAPH: tplot redraw done" . timeprobe nl
         THEN (hP ht)

         out dup 0> IF cr0 ELSE drop cr THEN

       \ Show newest numbers from daysget.P and daysget.t:
         LAST . nl

       \ Generate signal (doing this after tplot to hide any delay):
         (hP ht) UPDATE (f1) REMOTE_DATA (f2) or
         IF 
\ " TGRAPH: calling signal" . timeprobe nl
            (hP ht) signal 
\ " TGRAPH: signal done" . timeprobe nl
         ELSE (hP ht) 2drop
         THEN

         no "UPDATE" book
         no "REMOTE_DATA" book
         "TGRAPH_RUN" WAKE
      THEN

      ERR
      no "BUSY" book
\ " TGRAPH: exit" . timeprobe nl
   end

   inline: TGRAPH_RUN ( --- ) \ run TGRAPH if flag is set
{     The collector (qcon.v) runs word TGRAPH_SET and leaves a true
      flag whenever new data is available.

      This word runs in the multitasker, and periodically checks the
      flag in TGRAPH_SET and runs word TGRAPH to update the graphics 
      display if the flag is true. 

      Previously, the collector ran TGRAPH remotely whenever there was 
      new data.  This proved to be very disruptive when using the mouse
      and keyboard at the same time, causing erratic mouse clicks and 
      missed keys while the program was busy running TGRAPH.  

      By simply running TGRAPH_SET to set a flag, the remote now has 
      negligible impact on local operations.  

      The multitasker, mouse and keyboard are made to work together in 
      terminal() (file term.c), the function that controls these events,
      so the program works more smoothly.

      There is still the problem of TGRAPH, now run by the multitasker,
      being busy when making a keyboard or mouse entry, causing it to be
      missed.  To help here, an indicator "..." appears when the system
      is busy, a text equivalent of the hour glass or clock icon in a 
      graphical environment.

      When ... appears, the system is busy and it is best to wait a 
      moment for it to disappear before using the keyboard or mouse.

      To further reduce interference, the mouse motion event handler 
      was augmented by word MEV1 in this file to make TGRAPH_RUN sleep
      while there is mouse motion in the graphics window.
}
      LOCKED IF return THEN \ in case signal.ABCROSS is idling

      "TGRAPH_SET" "FLAG" yank (f1)
      "auto" "KB_LOCKED" yank (f1 f2) and \ only if auto keyboard locked
      IF no "TGRAPH_SET" "FLAG" bank 

         yes "TGRAPH" "REMOTE_DATA" bank 

         "auto" "S" yank (nS) any? 
         IF (nS) dup no SELECT ELSE 0 THEN (nS or 0) push
         TGRAPH 
         pull (nS or 0) any? IF (nS) yes SELECT THEN

       \ Remind pExpose1 to run VIEW-UPDATE when focus comes back:
         havefocus not IF yes "pExpose1" "NEW-DATA" bank THEN
      THEN
   end
{
   The rate of TGRAPH_RUN should exceed the rate of release of new data
   flags from qcon, which is once every 10 seconds, so a flag will be
   acted upon without delay.  Then there is less chance that sequential
   voices (more than one file played) for one market will become inter-
   laced with sequential voices for another, which happens when TGRAPH_
   RUN is also played once every 10 seconds as shown below for markets
   NQ and SP:

      GC P echo1 15422 -18 20:26 CDT Tue Jun 7, 2011
      NQ attention 20:27 CDT Tue Jun 7, 2011
      SP attention 20:27 CDT Tue Jun 7, 2011
      NQ P newlow 22695 -43 20:27 CDT Tue Jun 7, 2011
      SP P newlow 12830 -18 20:27 CDT Tue Jun 7, 2011
      NQ P foxtrot1 22695 -43 20:27 CDT Tue Jun 7, 2011
      SP P foxtrot1 12830 -18 20:27 CDT Tue Jun 7, 2011
      NQ P echo1 22695 -43 20:27 CDT Tue Jun 7, 2011
      SP P echo2 12830 -18 20:27 CDT Tue Jun 7, 2011
      DJ attention 20:27 CDT Tue Jun 7, 2011

   On future logs, time will be given to the nearest second.

   After the care taken above, how did this happen?  How did JY and 
   GC collide when they are released by qcon server on 10 second 
   intervals and sensed by the consoles on 1 second intervals?:

      JY attention 20:36:42 CDT Wed Jun 15, 2011
      GC attention 20:36:42 CDT Wed Jun 15, 2011
      JY P newlow 12356 -005 20:36:43 CDT Wed Jun 15, 2011
      GC P newlow 15266 04 20:36:43 CDT Wed Jun 15, 2011
      JY P bravo101 12356 -005 20:36:43 CDT Wed Jun 15, 2011
      JY P echo1 12356 -005 20:36:44 CDT Wed Jun 15, 2011
      GC P sierra102 15266 04 20:36:44 CDT Wed Jun 15, 2011
      GC P lima1 15266 04 20:36:44 CDT Wed Jun 15, 2011
}
   1 "TGRAPH_RUN" PLAY \ TGRAPH_RUN running every second

   inline: TGRAPH_SET ( --- ) \ flag update to real time data
\     This word is run by the remote real time server (qcon.v) when it
\     sees that new data has been collected for Mkt.
      [ no "FLAG" book ] yes "FLAG" book
   end

#def tgraph

   inline: tgraph (hP ht --- ) \ graph data from P(t)
{     From P(t) make PG(t) that is ready with lines and colors for 
      word plot (which is run by word tplot).

      Example: to make a plot after running this word, run a phrase
      like this one (also see word tplot):
         "tgraph" "PG" yank "t" main (hPG ht) plot

      How the time (X) axis is defined:
         Each real time data collection session starts at 5:00 PM 
         Chicago time.

         Zero in X is the start of the latest (rightmost) session.
         (Note: this was written before future days were added; but
         zero is still at the start of the latest session and future
         days simply have times greater than 86400 seconds.)

         Negative X values (shown left of zero) are sessions of the
         previous days that also started at 5:00 PM.

      Examples of machine time, tm, and X axis graph time, tg for n = 5
      days (see word tgraph_lookup) (note: the stack setup shown below
      to run tgraph no longer applies):

         [tops@plunger] ready > 'eu' 0 5 tgraph
         [tops@plunger] ready > tm ctime spaced tm itext spaced + \
                                tg itext + .

         Table for electronic markets like EU that were open on Presi-
         dent's Day holiday, Monday, February 18, 2008, even though
         the pits were closed:

            Date and time from tm        tm (sec)     tg (sec)
            Wed Feb 13 15:00:00 PST 2008 1202943600   -345600
            Thu Feb 14 14:59:59 PST 2008 1203029999   -259201
            Thu Feb 14 15:00:00 PST 2008 1203030000   -259200
            Fri Feb 15 14:59:59 PST 2008 1203116399   -172801
            Sun Feb 17 15:00:00 PST 2008 1203289200   -172800
            Mon Feb 18 14:59:59 PST 2008 1203375599    -86401
            Mon Feb 18 15:00:00 PST 2008 1203375600    -86400
            Tue Feb 19 14:59:59 PST 2008 1203461999        -1
            Tue Feb 19 15:00:00 PST 2008 1203462000         0
            Wed Feb 20 14:59:59 PST 2008 1203548399     86399

         Table for market W, where normal electronic trading did not 
         open on Sunday due to President's Day holiday on Monday, 
         February 18 (when the pits were closed too), and there was 
         no file of collected data.  The market opened on Monday after-
         noon for the Monday to Tuesday session:
            [tops@plunger] ready > 'w' 0 5 tgraph
            [tops@plunger] ready > tm ctime spaced tm itext spaced + \
                                   tg itext + .

            Date and time from tm        tm (sec)     tg (sec)
            Tue Feb 12 15:00:00 PST 2008 1202857200   -345600
            Wed Feb 13 14:59:59 PST 2008 1202943599   -259201
            Wed Feb 13 15:00:00 PST 2008 1202943600   -259200
            Thu Feb 14 14:59:59 PST 2008 1203029999   -172801
            Thu Feb 14 15:00:00 PST 2008 1203030000   -172800
            Fri Feb 15 14:59:59 PST 2008 1203116399    -86401
            Mon Feb 18 15:00:00 PST 2008 1203375600    -86400
            Tue Feb 19 14:59:59 PST 2008 1203461999        -1
            Tue Feb 19 15:00:00 PST 2008 1203462000         0
            Wed Feb 20 14:59:59 PST 2008 1203548399     86399
}
      [ "'PG' main" "PG" macro 
        purged "g_index" book

        false "xyzoom" "dynamicP" bank \ see note in this file:
                                       \ Thu Aug  4 14:26:10 PDT 201

      \ Key x runs macro ZROTOG that sets all toggle keys off; see word
      \ auto_key().

      \ List of toggle keys is in auto_key(); copy it here:
        "auto_key" "Toggles" yank "Toggles" book

      \ Set flipC to the following default each time ZROTOG runs; flipC
      \ is toggled by showz to put curve .C (or some other designated
      \ curve or curves (see macro TOGGLES)) on top:
        no "flipC0" book \ yes = .C initially on top

      \ Macro to zero all the toggles; toggle key names are "show" plus 
      \ the key, like "showf" for toggle key f:
        "Toggles rows 1st DO no 'show' Toggles I quote + book LOOP "
        "flipC0 'flipC' book" + \ always reset flipC to default
        "ZROTOG" macro
{
        The ntog keys are number keys 0-9.  Ntog might imply that these
        keys toggle, but they do not; they simply draw a list of curves
        for keys that do toggle.  Sometimes less is more, and ntog keys
        allow different numbers and groupings of curves.
}
      \ Initialize 0tog, ..., 9tog to empty VOLs:
        9 0 DO VOL tpurged I intstr "tog" + book LOOP
{
        Presentation of curves.  Each curve in concert with other ones 
        can tell a story.  Selection of curves is important so the story
        stands out and is not obliterated by families of irrelevant 
        curves that add too much information.  The trick is to remove 
        distractions without losing the story.

        The ntog keys allow groupings of keys to show just selected 
        curves.

        Set the ntog keys.  Letters in a list of keys for an ntog key
        are chosen from list Toggles in word auto_key().  For a graph 
        being viewed, keys in use can be listed by pressing Shift+K and
        then the list can be copied and pasted here to define the keys
        of an ntog key:
}
        "b m n p s S" strings "1tog" book
        1tog "D S d f g" strings pile "2tog" book
        2tog "F G" strings pile "3tog" book
        "b m n p" strings "4tog" book

      \ How to use chblank to remove keys from a list, like removing
      \ keys d, f and s from a 5tog to make a 6tog:
      \    5tog "dfs" chblank "6tog" book \ simplify 5tog

      \ Controlled by key E, initialize spaced grid lines to be on top:
        yes "pExpose1" "GRIDtop" bank \ spaced grid lines not on top

        {" N-ON (qS --- ) \ set toggle key names in S to yes
           any? \ for key k in S, set name showk to yes (see TOGGLES)
           IF dup push rows 1st
              DO yes "show" peek I quote (show k) + book LOOP pull drop
              toggles_put
           THEN  
        "} "N-ON" macro

      \ Make macros to turn N-toggles on (for example, if VOL 5tog made
      \ above is not empty (chars 0> is true), then macro 5ON is made 
      \ to turn on the keys listed in VOL 5tog): 
        9 0
        DO I intstr "tog" + local (qS) chars 0>
           IF I intstr "tog" + (ntog)
              (ntog) " N-ON" + I intstr "ON" + macro
           THEN
        LOOP

      \ Special handling for key \ that sets which region is on top.
      \ Flag tog\ is toggled in word auto_key and its value is saved 
      \ here and on the ALERTFILE, where it is read when normal toggle 
      \ keys (called toggles in ALERTFILE) are read at start up:
        no "tog\" book

      \ Set NVIEW for start up; for example, if NVIEW=3 start up will 
      \ show the 3tog keys (but on first entry, this will be over-
      \ written by the last ntog key used, as read from ALERTFILE; see
      \ "view" below):
        1 "NVIEW" book ZROTOG NVIEW intstr "ON" + local

        yes "NOVIEW" book
      ]

      (hP ht) true one MAT stkok and, two MAT stkok and not 
      IF "tgraph" stknot HALT THEN

      "tgraph" ERRset

      (hP ht) "t" book "P1" book

    \ Do this only on first entry to this word, to set NVIEW tog key
    \ to the default read from ALERTFILE:
      NOVIEW 
      IF ZROTOG toggles_set \ Wed Jul 20 09:23:43 PDT 2011

         "view" alertdata (0 or n -1) \ last ntog key from file
         IF (n) dup -1 >
            IF (n) dup "NVIEW" book 
               "toggles_set" "set" yank \ skip if ran toggles_set
               IF (n) drop
               ELSE ZROTOG (n) intstr "ON" + (nON) dup local? (f)
                  IF (nON) local      \ run word nON
                  ELSE (nON) drop 1ON \ run default 1ON
                  THEN
               THEN
            ELSE (n) drop
            THEN
         THEN

         "tog\" alertdata (0 or n -1)
         IF (n) ELSE no THEN "tog\" book 

         NOVIEW not "NOVIEW" book
      THEN
{
      Define the columns from daysget.P that go into PG to plot.

      The following list defines the columns to take from matrix P for
      plotting, with column names like .C and .S matching the struct
      names for columns of matrix daysget.P given in mobius.n.  
}
      [ {" TOGGLES ( --- ...) \ toggle key columns (order matters):

         \ showi IF .OI THEN \ open interest scaled to the price graph

           depth push
              showe IF .SE THEN \ settle price

              showo IF .Ln .Hn THEN
              showw IF .Lm .Hm THEN

              showS IF .R2 THEN 
              showG IF .U2 THEN
              showF IF .T2 THEN
              showD IF .S2 THEN

              shows IF .R1 THEN 
              showg IF .U1 THEN
              showf IF .T1 THEN
              showd IF .S1 THEN

	      showp IF .C THEN 
           depth pull - (n) flipC IF (n) revn ELSE (n) drop THEN

           showb IF .P1 THEN 
           shown IF .P2 THEN 
           showm IF .P3 THEN 

        \ Example usage of tog\ to toggle which region is on top:
        \    tog\ IF .R2 .R1 ELSE .R1 .R2 THEN THEN

        \ How to do the comma key in "show," since names with commas 
        \ cannot be referenced directly:
        \    (show,) "tgraph" "show," localrun IF .D2 THEN

        "} "TOGGLES" macro 
      ]

    \ Lines are drawn in the order last to first, so first in the list
    \ made below is drawn on top of all the others:

      list: 

         showz "flipC" book \ flipC toggles directly with showz
 
\        Moved into TOGGLES:
\        showe IF .SE THEN \ settle price

         showu IF .H .L THEN \ current high and low

         TOGGLES

      end (hL) 

      (hL) nodupes any? not IF .C THEN (hL)
      (hL) "g_index" book \ list of columns to graph

      P1 g_index catch (hPG) 

      (hPG) "PG" fbookX

      [
       \ Lists Phigh and Plow define the columns of P used for clip-
       \ ping.  P names like .H and .L match the struct names given
       \ in mobius.n.

       \ Put cols from P to use for Y max clip into array Phigh:
         list: .H .C end "Phigh" book 

       \ Put cols from P to use for Y min clip into array Plow:
         list: .L .C end "Plow"  book 
 
       \ Margin MARG adds space above and below the curves when their
       \ full-size CLIP array is made here in macro makeCLIP; the CLIP
       \ is further scaled by pExpose.MARG when the curves are drawn:  
         0.10 is MARG \ top and bottom margin (%/100)

         {" makeCLIP (hP1 ht --- hC) \ CLIP values in the full graph
          \ Thu Aug  4 08:11:09 PDT 2011.  Create this macro from lines
          \ already here.

          \ Incoming P1 must contain all the columns defined by the
          \ struct for daysget.P in mobius.n, not just the subset con-
          \ tained in graphed array PG.

          \ Make a clip for word plot to use, based on columns Plow and 
          \ Phigh:
            (ht) dup 1st pry                                    \ x1
            (hP1 ht x1) swap other (hP1) rows ndx (ht nrow) pry \ x2

            (hP1 x1 x2) rot (x1 x2 hP1)

            (hP1) dup Plow catch minfetch 2drop        \ y1
            (hP1 Ymin) swap Phigh catch maxfetch 2drop \ y2

            (y1 y2)

          \ Apply a top and bottom margin to y1 and y2:
            (y1 y2) 2dup - abs MARG * 
            (y1 y2 delta)  
            rot over (y2 delta y1 delta) - (y2 delta y1')
            rev (y1' y2 delta) + (y1' y2')
 
            (x1 x2 y1' y2') 4 listn (hC) 

         "} (hT) "makeCLIP" macro
      ]

      P1 t makeCLIP (hC) dup (hC) setCLIP

    \ Thu Aug  4 08:56:09 PDT 2011.  In case the current plot is zoomed,
    \ save a new FULL clip in xyzoom since latest data may have expanded
    \ the range:
      (hC) 
      "xyzoom" "FULL" yank  
      IF (hC) drop
      ELSE (hC) "xyzoom" "savCLIP" bank \ new xyzoom.savCLIP array
      THEN
      
      purged "P1" book 
      purged "t" book 

    \ Line widths and colors to use for plot:
      lines g_index reach colors g_index reach graphset

    \ PG and t can now be plotted; see example above and word tplot.

      ERR 
{
  Scaling problem:

  Why doesn't the full graph rescale when prices go outside the range
  of the window when it was first opened?  Just looking at the following
  debug doesn't help understand this; need to do a simulation that
  causes the problem and then fix it.

     " tgraph setCLIP: " getCLIP bend itext + . nl

  It may be that exiting auto and running the name again, like
     % nq
  or even just
     % ...
  causes rescaling; if so what does that do to cause rescaling and why 
  isn't it just automatic?

  October 2009: when all steps were displayed, rescaling of the full
  curve was observed when a new high was obtained.

  Also, forcing an update when all days are displayed (key U while in 
  auto mode) will rescale.

  November 2009: By chance, when full scale was displayed and a highest 
  new price came in, the graph was observed to rescale on its own.  

  This event is so rare, since graphs are almost always zoomed, that it
  has taken a long time to observe it.

  Conclusion: 

     When graphs are zoomed, automatic rescaling does not occur.  Only 
     while not zoomed and a new hightest or lowest comes in will the 
     graph automatically rescale.  Since this case is very rare, I 
     thought there was a bug.

     There is no bug.  Rescaling can be made smarter, to be done even 
     when zoomed.  But this will take new work not worth doing at this
     time (November 2009).

  More on rescaling:

     To manually rescale, zoom all the way out to full size and press
     key U, or one of the number toggle keys or wait for the next price
     update from RTSERVER.  This needs to be done from time to time
     when rallies or reactions send prices to the top or bottom borders
     of the graphs.
    
     Thu Aug  4 08:56:09 PDT 2011.  When the full range of a graph is
     determined above, a new FULL clip is banked into xyzoom since new 
     data may have expanded the range.  Thus when a zoomed graph is 
     backed out to full size, it will already be rescaled to any new 
     highest-high or lowest-low and there is no need to wait for an 
     update or to press key U.

     Thu Aug  4 14:26:10 PDT 2011.  Phrases to account for full graph
     rescaling were added to word xyzoom() in plot.v, and are run when
     flag xyzoom.dynamicP is true.  These do not operate as expected
     and so xyzoom.dynamicP is set to false by this word.
}
      [ 
{       This bracket region is run only at start up. 
 
        Making colors and line types at start up.  

        Colors take some time, so they are made now and simply looked 
        up later.  See the Appendix for more colors (search for string 
        december).

        The list of colors and line types below must have as many en-
        tries as there are columns of P, and they must be ordered ac-
        cording to the struct for daysget.P given at the top of file
        mobius.n.

        Even if a column of P will never be drawn, it still must have 
        an entry here as a place holder for the correct sequence.
}
#def tcolors

        "LineSolid" "LS" book     \ line type solid
        "LineOnOffDash" "LD" book \ line type dashed
        "LineRectangle" "LR" book \ line type rectangle

        list: \ a color and a line for each column of P

      \ Columns from dayget():
      \    "H" "L" "C" "dC" "VO" "IT" "SE" "P1" "P2" "P3" "S"

      \                      Curve  Key   Color
           "#215E21" LS     \ H      u   Hunter Green 
           "DodgerBlue4" LS \ L      u   Dark Dodger Blue

           "#FCB514" LS     \ C      p   Packer Gold

           "#000000" LS     \ dC (place holder; cannot plot)
           "#000000" LS     \ VO (place holder; cannot plot)
           "#000000" LS     \ IT (place holder; cannot plot)

           "#9E0508" LS     \ SE     e   Burgundy

           "Grey30"  LS     \ P1     b   Charcoal
           "Grey20"  LS     \ P2     n   Dark Charcoal
           "Grey10"  LS     \ P3     m   Black Charcoal

           "#000000" LS     \ S (place holder; same as SE)

          \"#E6E8FA" LS     \ OI         Silver (discontinued)

      \ Columns from daymodel(): 
      \    "Hn" "Ln" "Hm" "Lm" "V" "dV"

      \                      Curve  Key   Color
           "#215E21" LS     \ Hn     o   Hunter Green 
           "DodgerBlue4" LS \ Ln     o   Dark Dodger Blue

           "#213D30" LS     \ Hm     w   Packer Green
           "#22316C" LS     \ Lm     w   Delft Blue

           "#000000" LS     \ V (place holder; cannot plot)
           "#000000" LS     \ dV (place holder; cannot plot)

      \ xxxxxx Curves and colors below always being changed.

      \ Columns from dayfill():
      \    "R1" "R2" "S1" "S2" "T1" "T2" "U1" "U2"

      \                      Curve  Key   Color
           "#FF0000" LS     \ R1     s   Red
           "#8C1717" LS     \ R2     S   Scarlet

           "#32CD32" LS     \ S1     d   Lime Green
           "#228B22" LS     \ S2     D   Forest Green

           "#05E9FF" LS     \ T1     f   Indiglo Blue
           "#1464F4" LS     \ T2     F   Butterfly Blue

           "#FF6103" LS     \ U1     g   Cadmium Orange
           "#964514" LS     \ U2     G   Mars Orange

{
           "#603311" LS     \ K1     g   Sign Brown
           "#8C1717" LS     \ S2     D   Scarlet


           "#964514" LS     \ T1     f   Mars Orange
           "#8C1717" LS     \ T2     F   Scarlet

           "#964514" LS     \ U1     g   Mars Orange
           "#8C1717" LS     \ U2     G   Scarlet

           "#FF6103" LS     \ F1     s   Cadmium Orange
           "#228B22" LR     \ F2     s   Forest Green

           "#964514" LS     \ G1     d   Mars Orange
           "#1464F4" LR     \ G2     d   Butterfly Blue

           "#5C4033" LS     \ H1     f   Dust
           "#003F87" LR     \ H2     f   Sign Blue

           "#603311" LS     \ K1     g   Sign Brown
           "#22316C" LR     \ K2     g   Delft Blue
}

        end (hList)

        (hList) colorset (hLines hColors) 

#end tcolors

        (hLines hColors) "colors" book "lines" book
      ]
   end

#end tgraph

   inline: tgraph_lookup (hDATES --- hXY) \ time lookup table
{     Create a lookup table for conversion of graph time to machine 
      time.  Incoming DATES is the matrix of sequential, session-end
      days needed for access to price data, in the form YYYMMDD for 
      each day.

      Word mktinit() uses this word to create lookup table XY and bank
      it into the LIB word for its market (see MAT XY in example LIB 
      listing in word mktinit()).  Later, words tm() and tg() use table
      LIB.XY to convert times to the proper scale.

      Valid session-end days in incoming DATES are Monday through Fri-
      day, for sessions that started on the previous Sunday through
      Thursday.

      Returned table XY is for converting any graph time into machine 
      time (as UTC from native word time) by interpolation (lookup):

         Tm = lerp(XY, Tg);

      as is done in word tm() which uses XY.

      This XY table is also used in word alerts() (obsolete) to trans-
      form discrete alert points into curves that span a graph.

      It is also used in csr_str() to convert a graph X coordinate into
      the date and clock time (some examples are shown in tgraph).

      By swapping the columns of table XY, a table for converting any
      machine time to graph time is obtained:

         Tg = lerp(XY[*,[2;1]], Tm);

      This is the form used in word tg().
}
      [ 0 86399 pile "SS" book ] \ session relative start and end sec
      hand "DATES" book \ ascending order YYMMDD (oldest first)

    \ Build graph time for displaying curves:
      depth push
      DATES rows 1st DO SS DATES rows ndx I - 86400 * - LOOP
      depth pull - pilen (htg) 
   
    \ Build machine time for date and clock time:
      depth push
      DATES rows 1st DO SS DATES I pry session_start + LOOP
      depth pull - pilen (htm)

      (htg htm) park "_XY" naming \ lookup table; X is tg, Y is tm
      purged "DATES" book
   end

   inline: tgraph_lookup1 (hDATES qMKT --- hXY) \ time lookup table
{     Create a lookup table for conversion of machine time to graph
      time.  Incoming DATES is the matrix of sequential, session-end 
      days needed for the display of price data, in the form YYYMMDD 
      for each day.    

      The lookup table has to be large enough to encompass the graphed
      days plus any earlier days in alert definitions that are used to 
      generate alert curves even if they are outside the graph.

      This word will add earlier days if necessary to make a lookup 
      table that encompasses graphed days and the days that define 
      alerts for MKT.
}
      "MKT" book
      hand "DATES" book \ ascending order YYMMDD (oldest first)

      MKT ALERTFILE dup file?
      IF "tgraph_lookup1 load alerts file" ERRset
         (qFile) asciiload (hT) 4th word (0 or hT -1) \ machine times
         IF (hT) numerate dup any IF (hA) true ELSE false THEN
         ELSE false
         THEN (0 or hA -1)

         IF "tgraph_lookup1 process alerts times" ERRset

            (hA) minfetch 2drop (sec) \ earliest alert machine time
            dup CHdiff1 + mdate (nD1) dup \ alert converted to YYYMMDD

            (nD1) DATES 1st pry (nD1 nDATES[1]) < \ is alert day oldest?
            IF "tgraph_lookup1 process earlier alert date" ERRset

             \ Alert date is older than oldest of incoming DATES.

               (nD1) "D1" book

             \ Get list of all file dates for MKT by running macro 
             \ rtfiles.rtf:
               MKT "rtfiles" "rtf" localrun rtdates (hFILEDATES)

               (hFILEDATES) DATES 1st pry INF <>
               IF
                \ Also use incoming DATES since it may have future 
                \ dates not in file dates:
                  DATES pile yes sort nodupes (hDATES) 
               THEN
               (hDATES)
{
               Find D1 in list of file name dates.  D1 may have come 
               from clicking on Sunday for the session that ends on 
               Monday, so it will not be found since file dates are 
               session end days, which are Monday through Friday.  In 
               this case, bsearch will return the previous day, which 
               is ok.
}              dup D1 (hDATES nD1) bsearch (hDATES r f) drop

             \ Take dates D1 and later:
               (hDATES r) over rows over - 1+ items reach (hDATES)

               (hDATES) "DATES" book \ new list longer than incoming

               ERR \ end "tgraph_lookup1 process earlier time"
            ELSE (nD1) drop
            THEN
            ERR \ end "tgraph_lookup1 process alerts times" 
         THEN
         ERR \ end "tgraph_lookup1 load alerts file" 
      ELSE (qFile) drop
      THEN

      DATES 1st pry INF <> 
      IF DATES tgraph_lookup (hXY)
      ELSE purged \ returning to word alerts
      THEN (hXY)
   end

   inline: tgraph_view (n --- ) \ set default view in word tgraph
    \ Thu Mar 25 06:02:08 PDT 2010

      "tgraph" "ZROTOG" localrun

    \ For number n, like 3, run local word tgraph.3ON:
      (n) "tgraph" over (n) intstr "ON" + localrun

    \ Tue Jun 29 19:40:04 PDT 2010 Remember new view on ALERTFILE
      (n) dup viewdef (n) "tgraph" "NVIEW" bank 
   end

   inline: tm (hTg --- hTm) \ graph time into machine time
{     Converts graph time Tg into machine time Tm.  Word ctime will
      display Tm as local time, and word gmtime will display Tm as
      GMT.

      Usage: local dates and times, with row indices on the left:
         t (hTg) tm (hTm) ctime (hT)
         (hT) dup rows columnofints spaced swap + eview

      Word tg is the inverse of this word, to convert machine time 
      into graph time.

}     (hTg) LIB "XY" yank swap (hXY hTg) lerp (hTm) 
      dup rows 1 = IF @ THEN
   end

   inline: tplot ( --- ) \ plot the graph made by tgraph
      Mkt chars any
      IF "PG t" main \ PG was booked by tgraph, t by daysget
         "xyzoom" "FULL" localrun (f)
         IF (hPG ht) _plot                      \ plot full
         ELSE (hPG ht) over rows rchop (hPG ht)
            "xyzoom" "replot" localrun          \ plot zoomed
         THEN
      ELSE " tplot: no market found" . nl
      THEN
   end

   inline: trake (ht tA tB --- hR) \ rake for times between A and B
{     Wed Nov 25 11:47:20 PST 2009

      WARNING: gives incorrect R when tB, not tA, is the earliest time
      in t, as when tA = "16:00:00" and tB = "17:00:00" but 17:00:00 is
      the earliest time in t.

      Incoming vector t is a list of graph times (see words tg and tm).
      Incoming strings tA and tB are Chicago times, like "07:30:00."

      Returned vector R is the size of t, with true values at rows of t
      that correspond to times A through B.
}
      "tB" book "tA" book "t" book
      t tm dup CHdiff1 + gmtime \ date and time in Chicago
      4th word drop dup (hT)    \ extract just the time in Chicago
      (hT) tA grepr "A" book
      (hT) tB grepr "B" book
      list: A rows B rows min 1st 
         DO A I pry B I pry thru LOOP 
      end
      t rows teeth 0= (hR) \ true at rows of times A through B

      purged "t" book purged "A" book purged "B" book
   end

   inline: tref ( --- tm) \ reference time for model
{     Wed Feb  2 09:33:32 PST 2011.  Setting a reference time to use so
      a series always falls on the same dates and times no matter what
      dates are graphed.

      Used for triplets (/archive/opt_mytops_usr/mobius.n.2011Jan23) 
      and two-session pairs (model 2011Feb11).

      The chosen reference date is Sunday, January 6, 2008.

      For the session that starts on Sunday, January 6, 2008 at 17:00
      CST, the machine time to use is 1199660400 sec as obtained and
      tested below.

      Using fortycoupe because its local time is UTC so there is no
      hassle converting local time to UTC.

         [dale@fortycoupe] /home/dale > tops
                  Tops 3.2.0
         Wed Feb  2 17:45:34 UTC 2011
         [tops@fortycoupe] ready > 1080106 230000 ltime .i
          1199660400

         [tops@fortycoupe] ready > 1199660400 ctime .
         Sun Jan  6 23:00:00 UTC 2008 << Greenwich session start

         [tops@fortycoupe] ready > 1199660400 dup CHdiff1 + ctime .
         Sun Jan  6 17:00:00 UTC 2008 << Chicago session start
                                         (ignore the UTC label)

      Checking on plunger, which uses PST:
         [dale@plunger] /home/dale > tops
                  Tops 3.2.0
         Wed Feb  2 09:51:34 PST 2011
         [tops@plunger] ready > 1199660400 ctime .
         Sun Jan  6 15:00:00 PST 2008 << Los Angeles session start

      Times for Greenwich, Chicago and Los Angeles all agree.
}
      [ 1199660400 "tref" book ] \ Sun Jan  6 15:00:00 PST 2008
      tref     
   end

   inline: tri (hSig n --- hTr) \ integer trace for integer Sig
{     General note about traces (functions tr() and tri()):

      When a trace is designed to decay exactly into its (reference)
      signal, as when using integer quantization and trace function
      tri(), simple greater-than and less-than tests are sufficient
      to learn its direction at any time.  For signal A and its trace,
      we know the following:

         the trace is going up when A>tri(A)
         the trace is going down when A<tri(A)
         the trace and signal are flat when A==tri(A)

      Taking the difference between successive values is not a reli-
      able approach because the trace may remain at the same value for 
      a number of steps.
}
      tr 0.5 + integer
   end

#def vgap

   inline: Vdisp ( --- ) \ display volume traffic
    \ Thu Mar 15 18:34:51 PDT 2012
      Vtraffic 
      " Using these values for curves:" .
      " R1:" . Mkt vtraffic 1st pry .i 
      ", R2:" . Mkt vtraffic 2nd pry .i nl
   end

   inline: vgap (qN --- hG) \ return gaps for market N
\     Return column G with Vals rows of data specified for string N.

\     Note: this word serves as a template for any function that does a
\     binary search table lookup on string N.  Require chars(N) < 9.

      [ 9 "Vals" book \ values for each string N

        {" Table of each N string followed by Vals values:

         \ Table of gaps:
         \    g1: C to C1 or C2 in sigmodel() (Sep 22 03:17:46 PDT 2011)
         \    g1: C to Cr in sigmodel() (Apr 19, 2011)
         \    g2-g8: lima and echo levels in sigmodel() (Apr 23, 2011)
         \    g9: extreme positions gap in daysfill() (March 7, 2012)
         \    g9: histogram bin size in daysfill() (March 9, 2012)

         \ N  g1  g2  g3  g4  g5  g6   g7   g8   g9
           eu 20  20  40  60  80  100  120  140  5
           sf 15  20  40  60  80  100  120  140  5 
           jy 10  20  40  60  80  100  120  140  5 

           cl 50  50  75  100 125 150  200  250  10
           hg 100 100 300 600 900 1200 1500 1800 20
           gc 50  50  75  100 125 150  200  250  10

           dj 20  20  40  60  80  100  120  140  10
           sp 20  20  50  100 120 140  180  200  10
           nq 50  50  100 150 200 250  300  350  20

           us 5   5   8   12  16  25   27   31   2
           tn 25  25  40  60  80  125  135  155  10

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) Vals 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having Vals rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd Vals items reach mat2vol numerate Vals foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vgap" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vgap" "S" yank 2nd catch .m
      }
      ]
      (qN) "N" book

      S N lowercase 8 blpad str2num (n)   \ turn N string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G

    \ ELSE (r) drop 10 G rows 1 fill (hG)

    \ Alternate ELSE to cause HALT when there is no data for N:
      ELSE (r) drop " vgap hal" "ting: no data for " + N + . nl HALT

      THEN (hG) 

    \ Convert gaps into perpetual numbers (since gaps are relative,
    \ rollover need not be considered):
      (hG) "%0.0f" format (hT) N q>n \ into scaled numbers
      "scale" main main (hG)         \ into perpetual numbers
      G-SCALE (hG)                   \ and apply local plot scaling
   end
 
   inline: Vtraffic ( --- ) \ for Mkt, create data for vtraffic
\     Thu Mar 15 06:34:49 PDT 2012

      [ "'P' main" "Pt" macro ]

    \ " Vtraffic: not set up for this model" . nl return

      " Vtraffic: traffic statistics for " . Mkt . 
      ", contracts per minute:" . nl

      depth push

      Pt .dV catch dup 1 > rake lop bend stats1 bend "S" book
      "            Max: " S 3 pry intstr +
      "           Mean: " S 2 pry intstr +
      "    Mean+3sigma: " S 2 pry S 4 pry sqrt 3 * + intstr +
      "    Mean+6sigma: " S 2 pry S 4 pry sqrt 6 * + intstr +
      "   Mean+10sigma: " S 2 pry S 4 pry sqrt 10 * + intstr +

      depth pull - pilen . nl
   end

   inline: vtraffic (qM --- hG) \ return traffic constants for M
\     Thu Mar 15 06:36:33 PDT 2012 

\     Return column G with r rows of data specified for string M.
\     Require chars(M) < 9.

      [ 2 "r" book \ number of values (rows) in returned G

      {" Table of G values (see above) for string M:

       \ g1: rate dV for curve R1 in daysfill() (March 15, 2012)
       \ g2: rate dV for curve R2 in daysfill() (March 15, 2012)

       \ M  g1   g2
         eu 1000 2000
         sf 150  300
         jy 300  600

         cl 1200 2400
         hg 200  400
         gc 1200 1500

         dj 400  800
         sp 8000 14000
         nq 1000 2000

         us 1500 3000
         tn 5000 9000

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) r 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having r rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd r items reach mat2vol numerate r foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vtraffic" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vtraffic" "S" yank 2nd catch .m
      }
      ]
      (qM) "M" book

      S M lowercase 8 blpad str2num (n)   \ turn M string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G
      ELSE (r) drop " vtraffic hal" "ting: no data for " + M + . nl HALT
      THEN (hG) 
   end

#end vgap

   inline: wide_lines (f --- ) \ wide or narrow width for all lines
    \ Mon Dec  5 05:27:16 PST 2011

    \ An interesting experiment, but wide lines look blurry.  
    \ Stick to "no wide_lines."

      IF 2 ELSE 1 THEN LineSolid plotGCattrib
   end

\-----------------------------------------------------------------------
>>
// Infix functions

//MOB {"

   msource1("mobius.n", "#def P struct", "#end P struct");
   msource1("mobius.n", "#def auto_key", "#end auto_key");
   msource1("mobius.n", "#def tgraph",   "#end tgraph");
   msource1("mobius.n", "#def vgap",     "#end vgap");

   function (T) = daymodel(Pt, t) { // daily model from real time
   /* This function is called by dayadd() in mfil.v as each session is 
      read for the first time, and then over and over for just the last
      session as new data is added.  

      Incoming Pt contains rows only for a single session of 24 hours.
      The start time for the session is: 

         "rtget" "SStart" yank ctime (hDate)

      and the file being processed is given by hget1.FILE, such as
      1111018_GC.bin.

      Returned T(t) contains curves to be added to Pt that can be used 
      in a model to guide taking speculative positions.

      For a single session, incoming matrix Pt contains real time price
      C, session highs and lows H and L, and other columns of data de-
      rived from pit daily prices, using functions in file mfil.v.  This
      data is used below to produce returned matrix T.

      Because incoming data and outgoing results are for a single ses-
      sion, this is might be called a "bottom up" function (Reference
      8, where Braitenberg calls it downhill analysis).  It creates 
      "local" data for minute-by-minute trading in the current session.

      Word daysfill() (also in this file) might then be called a "top 
      down" function since it serves to connect more than one session 
      (as would be done for a multi-session moving average, for example)
      to give a less local and more "global" view.

      The struct for the columns of Pt is given at the top of this file 
      (where it is called "P struct"), and after this function returns 
      to its calling function dayadd(), rows of T will be added to the 
      columns of Pt for this session.

      These are the names and order of the columns of T made here that
      will go into P struct:
      "Hn" "Ln" "Hm" "Lm" "V" "dV"
 
      When nothing is computed by this function, it must return T with 
      number of rows equal to the rows of t and number of columns equal
      to zero, as in this expression:
         return((T = null(rows(t), 0))); */
   { 
     /* The rows of Pt and t equal n except for future times (before
        fixup in daysget(), mfil.v), when there is only one row: */
        n = rdech(24); // data points in 24 hours

     /* Thu Feb 23 04:39:37 PST 2012.  Power of two growth table: */
        T2 = [(<< 2 2 24 ^ 23 2space >>) , 1:24];

     /* Columns returned on future sessions, when a row vector of last
        price C is returned: */
        c_ret = 0; // must have been set before it is used when r=1
   } 
//<< "HGET" "DATE" yank 1120131 = IF "HALTING" . nl HALT THEN >>
//<< "HGET" "DATE" yank .i nl >>

      ERRset("daymodel market state");

      r = rows(Pt);
      if(r==1) return(fill(@Pt[1, .C], 1, c_ret)); // on future session

   /* Market. */
      C = Pt[*, .C];             // price
      V = V_make(Pt[*, .VO], t); // volume
      dV = dV_make(V);           // traffic

      ERR; // end "daymodel market state"

      ERRset("daymodel curves");

   /* High and low of session. */ 
      Hn = mmax(C, 1+n);
      Ln = mmin(C, 1+n);

   /* High and low of half sessions.  These reset at midsession and
      are used for new highs and new lows announced by voices. */
      (C0, C1) = rake(C, [null(r/2, 1) ; ones(r/2)]);
      Hm = [mmax(C0, 1+n/2) ; mmax(C1, 1+n/2)];
      Lm = [mmin(C0, 1+n/2) ; mmin(C1, 1+n/2)];

   /* Remove memory used by temporary arrays: */
      C = C0 = C1 = 0;

   /* Columns returned in T: */
   << depth push 

       Hn, Ln, Hm, Lm, V, dV

      depth pull - parkn (hT) "T" book
   >>
      c_ret = cols(T);
 
   /* Remove memory used by temporary arrays: */
      dV = Hm = Hn = Lm = Ln = V = 0;

      ERR; // end "daymodel curves"
   }

   function (Pt) = daysfill(Pt1, t) { // fill cols that use all days
   /* This function is called by daysget() in mfil.v.  It is called 
      whenever new data arrives, and can do calculations that use all
      the days.  Returned Pt is incoming Pt1 with additional columns 
      appended (first time through only) and updated (after the first
      time through).

      The purpose of this function is to produce curves Pt(t) from
      curves Pt1(t) that allow a story for speculation to be told.

      Everyone loves good stories.  Our mistake usually is believing
      them, because it is usually impossible to fact-check even the 
      simplest story.

      This story is a logical narrative about why the price is acting 
      the way that it is, and these curves are supposed to help in that
      effort.

      But it is still just a story, to be believed with caution and to
      be discarded when facts unfold that make it untrue.

      Incoming Pt1 contains real time data for all sessions.  The struct
      for the columns of Pt is given at the top of this file (where it
      is called "P struct").

      Valid columns in incoming Pt1 are just the ones filled by function
      daymodel().  There are columns still to be appended and filled by
      this word so when it returns all columns of Pt will be complete
      and ready to use.

      These are the names and order of the columns of Pt1 that will be
      appended and filled to make returned Pt; they match the last ones
      in P struct:
      "F1" "F2" "G1" "G2" "H1" "H2" "K1" "K2"
      "R1" "R2" "S1" "S2" "T1" "T2" "U1" "U2"

      When not using this function, just return incoming Pt1 as in: 
         return(Pt1). */

    { n =daymodel.n; // number of rows in one 24 hour session

      rprev = Vprev = -1; 
      never = true; // set to false after initial entry
      replay = false; // true when running replay
      Vnow = -1;

      nsess = 1;   // previous sessions for histogram
      p = nsess*n; // previous rows of data for histograms
      nF = 7;      // returned cols for histogram

   /* Sat Nov  5 22:44:08 PDT 2011.  On entry after this function has
      created full-size arrays, just the rows for the latest and future
      sessions are calculated and stored.  But rows for sessions before
      the latest may be needed for latest calculations. 

      For example, if an expression lags data for two sessions, as in 
      A = lag(C, 2*n), then three sessions are required for updating: 
      the current session to receive the new data (and to provide data
      to use in calculations) plus two previous ones with data for 
      calculations involving lag().

      Warning: Expressions that use looking() over previous sessions 
      should use all rows since the number of previous points needed 
      for looking's logical expression to ring true usually cannot be
      determined ahead of time.  In expressions below where the logical
      expression in looking() is indeterminate, reduced rows are not 
      used.

      Define the number of recent sessions to use for updating: */
      nuse = 1               // use current session 
             + nsess         // plus previous sessions for histograms
             + daysget.NADD; // plus NADD future sessions

   /* The variable called "use" defines the equivalent number of rows 
      needed when updating.  Function rdech() returns the number of 
      rows equivalent to a given number of hours for nuse sessions: */  
      use = rdech(24*nuse); // use rows for updating

   /* Tue Jan 17 12:48:55 PST 2012.  Want to use SE instead of S, but 
      the tclose adjustment below goofs up SE.  So just do the tclose
      adjustment for these early closers and leave the others alone: */
      macro("( --- f) 'CL' Mkt = 'HG' Mkt = or 'GC' Mkt = or", 
         "doMkt");
   }
//<< " Top of daysfill" . timeprobe nl >>

      ERRset("daysfill init"); // do not return before next ERR() below

      sigmodel.new_data = no;
      Pt = Pt1;

      r = rows(Pt);                // rows in data (with future ones)
      rnow = @daysget.tnow;        // row of latest real time data
      tnow = @t[rnow];             // current graph time

      dt = tSESS(tnow+86400)-tnow; // time step to end of session
      dn = rdech(dt/3600);         // points to last point of session
      k = 1+(rnow+dn);             // next session start point (future)

      m = r-rnow;                  // number of future rows to set
      IF(m<=0) 
         << " daysfill halting: incoming Pt is missing future rows"
            . nl HALT >>
      THEN

   /* These are examples of fix up done here, usually to curves made
      in daymodel() that need future values properly set when the
      curves are not of prices: 
      place(fill(@Pt[rnow,  .V], m, 1), Pt, rnow+1, .V); 
      place(                null(m, 1), Pt, rnow+1, .dV);
      place(                null(m, 1), Pt, rnow+1, .R); */

   /* Fix up certain curves. */
      place(fill(@Pt[rnow,  .V], m, 1), Pt, rnow+1, .V); 
      place(                null(m, 1), Pt, rnow+1, .dV);

   /* Fri Oct  7 12:15:51 PDT 2011.  Use price near pit close this ses-
      sion for pit settle that is shown in the future session, if cur-
      rent time is later than today's pit close during this session,
      or if not currently collecting (as during weekend studies): */
      tclose = (<< tnow tSESS tm Mkt pit_close + >>);
      IF((doMkt && tm(tnow)>tclose) || not(soonest_task))
         m1 = r-(rnow+dn); // number of future rows to set
         X = fill(@Pt[rtime(t, tclose), .C], m1+1, 1);
         place(X, Pt, k-1, .S); // k-1 is last point of current session
         place(X, Pt, k-1, .SE); 
      THEN;

      ERR // end "daysfill init"

   /* Wed Oct  5 12:03:47 PDT 2011.  Return if data previously computed
      below has not changed. */
      IF(never) // on first time, append null cols to Pt and continue
                // below to fill all their rows
         Pt = [Pt , null(rows(Pt), (.sizeof - cols(Pt)))];
      ELSE 
         if(replay) Vnow = -1; // force recalculation
         else Vnow = @Pt[rnow, .C]*(1+@Pt[rnow, .VO]); // key on C, 1+VO
         X = 0;
         Pt = [Pt , catch(main("P"), cols(Pt)+1:.sizeof)];
         if(rprev==rnow && Vprev==Vnow) return(Pt, book(0, "Pt"));
      THEN

      ERRset("daysfill model"); // do not return before next ERR() below

   /* Row rnow is the row for the latest time, but row rnow is not the
      last row because there are rows for future times that follow it.
      The two blocks below set the variables used for reduced rows. */

   /* The number of latest rows for updating is given by lenuse, and 
      vector of row numbers useR contains the row numbers: */  
      if(never) lenuse = r;                        // use all rows
      else lenuse = n*(1+integer((r-rnow+use)/n)); // latest sessions
      rstart = r - lenuse + 1;
   /* When you make it, use useR rows: */
      useR = rstart:r; // rows to use for update calculations
      rnowR = rnow - rstart + 1; // rnow within set useR

   /* Row kstart and vector of row numbers putR tells where to put up-
      dated useR rows into a full matrix, starting at row kstart: */
      if(never) kstart = 1; // start at beginning
      else kstart = k - n;  // recent start point
   /* When you place it, put putR rows: */
      putR = (kstart-rstart+1):rows(useR); // rows of new data to place

   /* Rake for reduced rows based upon time: */
    //hf = t<=tnow; // true present and past, false in future
    //hu = hf[useR]; 

   // yyyyyy For weeks and weeks, always working in this neighborhood.

   /* Tue Mar  6 05:00:11 PST 2012 */
      C = Pt[*, .C];   // prices
      dV = Pt[*, .dV]; // traffic

   /* Thu Mar 15 06:04:49 PDT 2012.  Curves of high rate dV: */
      g1 = @vtraffic(Mkt)[1];
      g2 = @vtraffic(Mkt)[2];
      X = looking(C, (r1=dV>g1 && dV<g2))[useR]; 
      V = [X , looking(C, (r2=dV>g2))[useR]]; 
      place(    V      [putR], Pt, kstart, .R1);
      place(lag(V,   n)[putR], Pt, kstart, .S1);
      place(lag(V, 2*n)[putR], Pt, kstart, .T1);
      place(lag(V, 3*n)[putR], Pt, kstart, .U1);

   /* Thu Dec  8 16:42:36 PST 2011.  Voices.  Hearing things: */
      IF(!never)
         V = null(lenuse, 1);

         r1 = r1[useR];
         r2 = r2[useR];

      /* Thu Mar 15 16:52:21 PDT 2012.  High dV rate: */
         V -= (<< V rows 1 null \ states V for ST (see sigmodel())
            (dV) 0= r1 and 1 *   \ keystone1
            dup  0= r2 and 2 * + \ keystone2
         >>);

      /* Thu Mar 15 17:34:51 PDT 2012.  Previous high dV rates: */
         V -= (<< V rows 1 null \ states V for UT (see sigmodel())
            (dV) 0= r1 n     lag and 10000 *   \ bravo101
            dup  0= r1 n 2 * lag and 20000 * + \ bravo102
            dup  0= r1 n 3 * lag and 30000 * + \ bravo103
            dup  0= r2 n     lag and 40000 * + \ sierra101
            dup  0= r2 n 2 * lag and 50000 * + \ sierra102
            dup  0= r2 n 3 * lag and 60000 * + \ sierra103
         >>);

      /* Sun Nov  6 08:04:00 PST 2011.  Data for voices in sigmodel().
         All arrays used by sigmodel() are made below.  These arrays 
         are for the current and future sessions, so voices are re-
         stricted to present and possible future events and none from 
         past sessions (but lag can be used to bring a past event up 
         to the present for a voice to use): */
         sigmodel.V = V[putR];             // voice states
         sigmodel.C = Pt[useR[putR], .C];  // current price
         sigmodel.S = Pt[useR[putR], .SE]; // settle price
         sigmodel.new_data = yes;
         sigmodel.kstart = kstart; // row in Pt where sigmodel puts data
      THEN

   /* Remove temporary arrays: */
      C = dV = putR = r1 = r2 = useR = V = X = 0; 

   /* Set values that are used on the next entry: */
      never = false;
      rprev = rnow;
      Vprev = @Pt[rprev, .C]*(1+@Pt[rprev, .VO]); // key on C and VO
      replay = yank("...", "REPLAY");
      forVdisp = false;

      ERR(); // end "daysfill model"

      return(Pt, book(0, "Pt"));

//<< " daysfill: exit" . timeprobe nl >>
   }

   function () = libload(LIB) { // load library LIB
   /* Thu May 26 09:33:04 PDT 2011

      Copied from mday.n, which is being phased out.

      Incoming string LIB equals regular SYMBOL plus "lib," like
      SFlib. */

/* A goal here is to get all the data that dataget() has previously
   stored in main arrays moved into LIB, so there is no data floating
   around in main meaning that each market can be read only once
   and held in its own local library.  I think this goal has been
   reached (on March 19, 2008), and probably main arrays _DATA, C,
   H, L and whatever else, can begin to be eliminated.

   The main arrays C, H, L, V, OI ROLLDELTA and DATE are stored below;
   array DELMO was added March 2012.

   The use of main name "Name" is being diminished and should be
   eliminated. */

   /* Load data from yearly files: */
      <<

\" Top of libload " date + . nl 

      LIB "lib" "" strp (qSYM) \ take the lib off of LIB
{
      Thu Mar 15 05:34:49 PDT 2012.  Word dataget() (mrc.v) reads daily
      (pit) data, but also reads the latest electronic data (using word
      latest_rt()) and sets up ROLLDELTA even though the pit has not yet
      opened.  

      This is important for proper operation of word rtget() (mfil.v) 
      in the session when data for a new contract is first being col-
      lected because roll information on a daily basis will not be known
      to the system until after the upcoming pit session is closed.
}
      (qSYM) dataget (f)

      (f) not
      IF " libload: no data found for " LIB + . nl HALT THEN

      >>
      LIB.SYM = uppercase(<< "Name" main >>);

   /* Store some main arrays into LIB; from dataget(), prices have
      been updated from web if any, and rollover recomputed: */
      LIB.C = main("C");
      LIB.H = main("H");
      LIB.L = main("L");

   /* Sat May 21 18:57:34 PDT 2011.  Pit volume and open interest; 
      these come from the exchange lagged by one session (true in the
      past, but should be verified), so they should be viewed with the 
      24-hour positions curve: */
      LIB.V = main("_DATA data.vol catch");
      LIB.OI = main("_DATA data.int catch");

      LIB.ROLLDELTA = main("_DATA data.roll catch");
      LIB.DATE = main("_DATA data.date catch");
      LIB.DELMO = main("_DATA data.delmo catch"); // added March 2012

      LIB.STEPS = rows(LIB.C);
   }

   function (LIB) = mdata(MKT) { // load MKT data into LIB
   /* Thu May 26 09:33:04 PDT 2011

      Copied from mday.n, which is being phased out.

      Make a library word called MKTlib, and load data into it.

      Returned handle LIB is used to access data, as in these
      examples of fetching and storing:
         c = LIB.C      // c is equal to C fetched from library LIB
         LIB.A = myMAT; // myMAT is stored in library LIB as A

         LIB = mdata.LIB; // set local LIB to last loaded
   */
      { LIB = ""; }

//<< " Top of mdata " date + . nl >>

      LIB = uppercase(MKT) + "lib"; /* LIB has the form MKTlib */
      if(missing(LIB)) library(LIB);

   /* Load data: */
      libload(LIB);

      return(LIB);
   }

   function () = sigmodel(t) { // model signals for signal()
   // This function is called by macro daysget.add_model() in mfil.v.

    { n =daymodel.n; // 24 hours

      new_data = no; // flag set by daysfill()

   /* Place holders for expected arrays from daysfill(): */
      C = S = V = 0;

      replay = no; // word ...() resets replay to zero when resume auto
      nl1 = no;

      vs = words("KEYSTONE1 KEYSTONE2");

      vr = words("LIMA1 LIMA2 LIMA3 LIMA4 " + 
                 "LIMA5 LIMA6 LIMA7 LIMA8 " + 
                 "ECHO1 ECHO2 ECHO3 ECHO4 " +
                 "ECHO5 ECHO6 ECHO7 ECHO8 FLAT"); 

      vu = words(<< \ from signal():
          "bravo101 bravo102 bravo103 sierra101 sierra102 sierra103"
          >>);

      macro("VT   100 over dims fill /mod drop", "ST");
      macro("VT 10000 over dims fill /mod drop" +
            "     100 over dims fill /mod lop",  "RT");
      macro("VT 10000 over dims fill /mod lop",  "UT");

      macro("'HALTING' . nl HALT", "HH"); // debug halting
    }
   /* Return if no new data: */
      if(new_data==no) return();

      ERRset("sigmodel"); 
      new_data = no;

      nt = rows(t);         // rows in full size t
      rnow = @daysget.tnow; // latest real time row
      nl1 = no;             // set to yes if replay prints anything
      VT = null(nt, 1);     // full t-sized null vector

   /* Data arrays banked here from daysfill() are: C, S, V.  When placed
      into a full sized vector, results computed from these arrays go at
      the row number given by kstart, as in placing V from daysfill()
      into VT: */
      place(V, VT, kstart, 1); // initial nonzero VT comes from V

      ERR // end "sigmodel"

   /* Voice states for macro ST are in V, stored here by daysfill(): */
      ERRset("sigmodel ST"); 
      (<< replay (f) \ display the voice state
         IF ST rnow pry abs any? \ macro ST extracts ST from VT
            IF (n) vs rows 1
               DO dup (n) I =
                  IF vs I quote strchop . sp EXIT THEN
               LOOP (n) drop yes "nl1" book
            THEN 
         THEN
      >>);
      ERR // end "sigmodel ST"

   /* Voice states for macro RT: */
      ERRset("sigmodel RT"); 
      u = vgap(Mkt)[2:8];
      u1 = @u[1]; u2 = @u[2]; u3 = @u[3]; u4 = @u[4];
      u5 = @u[5]; u6 = @u[6]; u7 = @u[7]; 

      V -= (<< V rows 1 null \ states for macro RT
         (dV) 0= C S u7 + > and 800 *   \ lima8
         dup  0= C S u6 + > and 700 * + \ lima7
         dup  0= C S u5 + > and 600 * + \ lima6
         dup  0= C S u4 + > and 500 * + \ lima5
         dup  0= C S u3 + > and 400 * + \ lima4
         dup  0= C S u2 + > and 300 * + \ lima3
         dup  0= C S u1 + > and 200 * + \ lima2
         dup  0= C S      > and 100 * + \ lima1

         dup  0= C S u7 - < and 1600 * + \ echo8
         dup  0= C S u6 - < and 1500 * + \ echo7
         dup  0= C S u5 - < and 1400 * + \ echo6
         dup  0= C S u4 - < and 1300 * + \ echo5
         dup  0= C S u3 - < and 1200 * + \ echo4
         dup  0= C S u2 - < and 1100 * + \ echo3
         dup  0= C S u1 - < and 1000 * + \ echo2
         dup  0= C S      < and  900 * + \ echo1
         dup  0=                1700 * + \ flat
      >>);
      place(V, VT, kstart, 1); // now VT also holds RT
      (<< replay (f) \ display the voice state
         IF RT rnow pry abs any? \ macro RT extracts RT from VT
            IF (n) vr rows 1
               DO dup (n) I =
                  IF vr I quote strchop . sp EXIT THEN
               LOOP (n) drop yes "nl1" book
            THEN 
         THEN
      >>);
      ERR // end "sigmodel RT"

   /* Voice states for macro UT are in V, stored here by daysfill(): */
      ERRset("sigmodel UT");
      (<< replay (f) \ display the voice state
         IF UT rnow pry abs any? \ macro UT extracts UT from VT
            IF (n) vu rows 1
               DO dup (n) I =
                  IF vu I quote strchop . sp EXIT THEN
               LOOP (n) drop yes "nl1" book
            THEN
         THEN
      >>);
      ERR // end "sigmodel UT"

      C = S = V = u = 0;

   /* The value below yanked from word ...() will equal yes if in 
      replay mode: */
      replay = yank("...", "REPLAY"); // set after 1st entry

      if(nl1) nl; // show new line if replay printed a voice state
   }

   function (V) = V_make(VO, t) { // volume growth series
   /* Sun Feb 19 21:24:31 PST 2012.  Volume has become very important.
      Do the extra work to fix up volume to be a valid growth series. 

      Volume from this function can be input to dV_make() to create
      volume traffic, contracts per minute.

      Incoming volume VO contains collected volume for a single session,
      so this function must be called from daymodel(), not daysfill().
 
      The expressions for this function were originally in daymodel()
      in earlier versions of file mobius.n. */

      V = VO;
      r = rows(V);

   /* Sun Feb 19 10:24:30 PST 2012. */
      IF(Mkt=="DJ" || Mkt=="SP" || Mkt=="NQ")
      /* These markets are odd balls.  Remove the funny "opening" ses-
         sion from 15:30 to 16:30 Central, four of five days a week.

         This is necessary because the program does not recognize such
         a split (sessions must start at or after 17:00 Central), and
         volume V is probably not increasing due to the reset at 15:30,
         so it has invalid negative growth.

         Remove the short opening session volumes and replace them with
         the ending value at about 15:15.  In effect, volume of this
         period is being ignored as a small tail at the end of the cur-
         rent session and a negligible up start at the beginning of the
         next session (its prices, however, are not ignored): */
         V = looking2(null(r, 1), V, t>81000); // zero V after 15:30
         V = looking(V, V>0); // replace zero with last nonzero V
      THEN;

   /* Mon Feb 20 16:24:34 PST 2012.  If the minimum value in V is not
      the first, zero all terms that precede it, under the assumption
      that they are left over from the previous and the current ses-
      sion is starting later (as in the new year on January 3, 2012): */
      (vmin, i, j) = minfetch(V);
      (vmin, i1, j) = minfetch(looking(V, delta(V)>=0));
      IF(i>1 && i1==(i+1))
         R = [ones(i-1) ; null(r-i+1, 1)];
         (V1, V2) = rake(V, R);
         V = tier(V1, null(i-1, 1), R);
         R = V1 = V2 = 0;
      ELSE
      /* Mon Feb 20 17:54:34 PST 2012.  After a holiday session where
         the pits are closed but electronic trading is open, trading in
         the next electronic session begins with the volume from the
         holiday session.  Reset volume to be zero at the beginning of
         any session.  The growth analysis that V is subjected to is
         best started at zero, and a models can exaggerate things to
         make them stand out.  Caricature may not be an accurate re-
         flection of data values, but it can help to see things: */
       //if((v=@(Pt[1, .VO]))>0) (V = V - v);
         if((v=@(VO[1]))>0) (V = V - v);
      THEN;

   /* Sun Feb 19 11:54:30 PST 2012.  Volume can be bad, causing the
      series to not be an increasing function.  Here is a case for CL
      on January 9, 2012 at 08:09:00, when volume dropped to 6704 for
      one step, making the series invalid:

         08:06:00 CST    43307
         08:09:00 CST     6704
         08:12:00 CST    45316

      The long path from CME E-quotes to Excel spread sheet to NFS file
      from Windows to Linux to tops_cme to topse to binary data file
      1120109_CL.bin means no one will ever bother to trace what caused
      this.  Just force V to be an increasing function to pave over
      glitches like this: */
      V = nonneg(V);
   }

   function (W) = vwp(P, dV, n, ns) { // volume-weighted positions
   /* Sun Jan  8 12:07:05 PST 2012. */

      IF(ns>1) // sum weighted P for ns sessions to make W:
         X = P.*dV;
         k = qdx(ns - 1);
         N = (<< X  k 1 DO X  I n * lag + LOOP >>); // numerator
         D = (<< dV k 1 DO dV I n * lag + LOOP >>); // denominator
         X = N./max(D, 1); // set min D to 1 to avoid 0/0 when dV=N=D=0

         X[1] = P[1]; // nonzero first X for looking()
         W = integer(0.5 + looking(X, X>0));

         X = N = D = 0;
      ELSE
         W = P;
      THEN;
   }

// end MOB 
//"} eval halt 

   pull catmsg
   private halt

/*----------------------------------------------------------------------

   Appendix  
      Definition of a session; time of day
      A note about open interest
      Making sound files
      Functions no longer used
      Miscellaneous colors
 
   Definition of a session; time of day

   January 2008.

   Times of day mentioned are Chicago (Central) time unless noted
   otherwise.

   What is a session?

   A session is a period in this program with a specific start time and
   a span of 24 hours (actually 23.75 hours to allow fifteen minutes to
   get ready for the next one).

   Periods when markets are open and trading are also called sessions; 
   but to avoid confusion with the program session, that designation 
   is avoided here.  

   Session start in the program was chosen to match the earliest time 
   that any electronic market opens, which is 5:00 PM in Chicago. 

   All electronic and pit open and close times (their periods of active
   trading) are defined within the program session timeline that begins 
   at 5:00 PM and lasts for 23.75 hours; see TIMELINES in file mget.v.

   It may be a coincidence that the periods of all electronic markets 
   being followed happen to fit within some 24 hour period that can be 
   called a session.  But with all of 34 markets falling inside a 24 
   hour band that includes their electronic and pit trading hours, this
   looks more like a matter of design.  None of these markets starts
   before 5:00 PM and none ends after 4:15 PM the next day.

   It is important not to confuse the program session start time with 
   the time a market opens for trading.  Many markets, perhaps a third 
   of the ones followed, open at times other than the session start 
   time.  For instance, coffee and sugar electronic trading open 8.5 
   hours after session start (at 01:30 AM the next day), but their trad-
   ing periods from open to close still fit within the period of one 
   program session.  

   In summary, there are many market trading periods, each with an open
   and a close, but there is only one session in this program, and all 
   the market trading periods fall within it.

   How dates of trading periods are defined.

   Dates are used in file names of collected quote data.  By definition,
   quotes coming from electronic and pit markets that are trading simul-
   taneously will have the same date in their file names.

   With this definition, electronic quotes dated on, say, Thursday, 
   January 24, 2008, were running while pit quotes were being received 
   on that same date, and both electronic and pit data file names will 
   have the date January 24, 2008.

   But note that a file with a date name of January 24, 2008 will also 
   contain electronic quotes that are earlier than simultaneous pit 
   quotes since the pit period begins while the electronic one is under-
   way.  These earlier quotes, of course, go back to the time the elec-
   tronic market opened, and that may have been on the previous day, 
   January 23, 2008 (this depends on the market, but is generally true).

   So this needs to be very clear: the program session start, which is 
   at the earliest open of the electronic market periods, was generally
   on the day previous to the date in the file name.  This follows from
   the way file dates are defined above (i.e., dated when electronic and
   pit markets are trading simultaneously) and the fact that the program
   session start is at 5:00 PM, the earliest time any electronic market
   opens.  For electronic markets that open around 5:00 PM, simultaneous
   trading with their pit markets will not occur until the pits open the
   next day.

   This is why on the evening of January 23, 2008 (in the US) one is 
   viewing real time electronic data from a history file of quotes that
   the program has dated tomorrow, January 24, 2008.

   Why grasping the idea of 24 hour market sessions has been difficult.

   Times I am used to revolve around my local time, and everything I 
   (or any of us) do in a single stretch takes less than 24 hours, 
   since there is a big block of sleep time somewhere in there.

   Each day ends when I go to bed, and each begins when I get up.  No 
   task during the day can possibly take 24 hours.

   But now there is, for example, the electronic market for gold fu-
   tures.  To sit through it would be a monumental 23 hour and 15
   minute task, beginning here (in LA) at 3:00 in the afternoon and 
   ending tomorrow afternoon at 2:15.  And at 3:00 tomorrow afternoon, 
   just 45 minutes after it ended, the market would start up again.

   Never have I contemplated such a one-day task.  It obviously would 
   take a super-human, one who can handle all human needs outside of 
   the gold market in just 45 minutes every day (well, there is the 
   "weekend" too, from 2:15 Friday afternoon (LA) until 3:00 on Sunday 
   afternoon).

   The definition of time becomes complicated.  

   With markets opening on one day and closing on the next, and web 
   sites reporting quotes in different time zones, keeping track of 
   when things happen is tricky.  Standard time and daylight saving
   time also must be taken into account.

   Converting different time zones to my time zone does not help be-
   cause of the need to still say if the hour is for today, tomorrow 
   or yesterday.  The day, and not just the hour, becomes important.

   An absolute time scale is very useful here, and fortunately the 
   machine supplies one.  The machine's time uses as a zero reference 
   the number of seconds that have elapsed since January 1, 1970 in 
   Greenwich, England.  

   Greenwich mean time (GMT, also called UTC (coordinated universal 
   time)) is the time at the zero meridian of the earth's longitudes, 
   which falls at Greenwich, England.  

   Any given time is a relative time, but for purposes here the ma-
   chine's time looks absolute.  The machine's current time is simply
   the time at 0:00 (midnight) in Greenwich, England on January 1, 1970
   (whatever time that was relative to the big bang) subtracted from the
   time right now in Greenwich, England, converted to seconds.  Since 
   we all live on the same earth, this same number of elapsed seconds 
   since January 1, 1970 applies to us all--making it absolute for the
   purpose here.

   By converting all quote times (usually given as local Chicago or New
   York, but sometimes local Greenwich or UTC) into machine time, it is
   easy to keep track of the sequence of various market events.  The
   quote collection functions in mget.v make this conversion, and write
   the machine time of each quote to the history files.  (Program time 
   variables with GMT in their names actually are machine times and 
   should not be confused with local GMT or UTC times.)

   A diversion to look into machine time.

   As this is being written, shown below is the machine time along with 
   the date and time we are used to seeing.  It shows that there have 
   been 1,201,381,317 seconds, about 1.2 billion, since January 1, 1970
   to this moment on January 26, 2008 (and not just here in my time zone
   at 13:01:57, but everywhere in the world no matter what the local 
   time is):  

      [tops@plunger] ready > time dup .i nl ctime .
       1201381317
      Sat Jan 26 13:01:57 PST 2008

   A machine time, like 1201381317 seconds, is unique, meaning it will 
   not occur again, so any event that is tagged with it has its time of 
   occurrence uniquely defined (to the nearest second, anyway).

   This shows that when the zero reference time for the machine was
   being defined at midnight in Greenwich, England, here in LA it was 
   only 4:00 PM on December 31, 1969--we were still getting ready to 
   celebrate the New Year:

      [tops@plunger] ready > 0 ctime .
      Wed Dec 31 16:00:00 PST 1969

   Negative machine times are valid too, so we aren't stuck with dates
   after January 1, 1970.  The negative of 1201381317 seconds shows a 
   date in 1931, which must precede the date January 1, 1970 by as much
   as the time to now (when I am writing this) follows it:

      [tops@plunger] ready > -1201381317 ctime .
      Sun Dec  6 18:58:03 PST 1931

   But trouble is brewing.  Machine time is defined in Unix as a 4-byte
   signed integer that will stretch to only so many seconds.  A 4-byte 
   integer has 32 bits, but the sign uses up one bit leaving 31 bits to
   define the number.  This gives numbers between 0 and 2147483647 com-
   puted below as two to the 31st power minus 1 (tops was changed to 
   its infix prompt (>>) to run the infix math expression):

      >> (2^31)-1 .i
       2147483647
      >> 

   With the sign bit set negative, the earliest machine date is in
   December 1901:

      >> -2147483647 ctime .
      Fri Dec 13 12:45:53 PST 1901
      >> 

   With the sign bit set positive, the biggest future date is January 
   18, 2038 at 19:14:07 (in my time zone):

      >> 2147483647 ctime .
      Mon Jan 18 19:14:07 PST 2038

   One second later the machine time and date will turn to garbage and 
   show the following:

      >> 2147483647+1 ctime .
      Fri Dec 13 12:45:52 PST 1901

   The date has wrapped back to the earliest date shown above (minus
   one second) due to the way signed integers work in the machine (a
   method called twos-complement).

   We can safely bet that something will be done about this problem
   before 2038.  

   Simply keeping the 4-byte integer but interpreting it as unsigned 
   instead of signed would add one more bit and allow about 68 more 
   years past 2038 at the expense of not being able to do dates before
   January 1, 1970 (like the negative one shown above that goes back 
   to December 1901).  

------------------------------------------------------------------------

   February 2008.

   Notes made while studying how to get the day for cursor position X.

   The final solution was very simple, using a lookup in a table made 
   in tgraph_lookup.  These notes do point out some things about dates 
   and sessions, but they do not point the simple way for getting 
   cursor position.  Things were still muddy when they were written.

      Getting the day for cursor position X.

      Having a session straddle two days makes this difficult.  Here 
      are some facts used to figure this out:

      This program defines five 24 hour sessions each week.  Sessions 
      begin on Sunday through Thursday (and thus end on Monday through 
      Friday).

      Each 24 hour session begins at 17:00 PM in Chicago, and each ses-
      sion contains a trading period for every market.  Some trading 
      periods begin after the session begins (later by as much as eight 
      hours) and end before the session ends, but no trading period 
      straddles two sessions--every trading period is contained entirely
      within a session.

      The four days Monday through Thursday are full 24 hour days--they
      contribute all their hours between the two sessions that are with-
      in them.  Friday from 0:00 to 17:00 and Sunday from 17:00 to 24:00
      contribute 17 and 7 hours, respectively, to make 24 hours and ac-
      count for the fifth full "day."

      Session end date, YYYMMDD, and number of sessions, n, are inputs 
      to tgraph.

      When n sessions are requested in tgraph, you get n minus one 
      full (24 hour) sessions plus the current partial session that is 
      going on now and is due to end on YYYMMDD.  (Actually, the left-
      most session shown by tgraph begins at the trading period, and 
      so is not quite a full 24 hour session if the trading period be-
      gins later than the session begins.)  Array tgraph.DATES holds 
      all the ending dates for the n sessions, and YYYMMDD must be the
      last one.

      Times along the horizontal axis are defined in seconds, and are
      contained in time matrix tgraph.t.  The zero time in tgraph.t is
      at the start of the last, or nth, session.

      Array tgraph.t holds times for the dates in tgraph.DATES, stacked
      so zero is at the start of the session ending on YYYMMDD and with
      negative times corresponding to earlier dates.  All of the times
      in tgraph.t are based upon collected quoted times converted to 
      machine times (seconds relative to 00:00 GMT on January 1, 1970).
      Incoming cursor position X is referenced to this system of times.

      Day YYYMMDD is the nth session end date, so the start date for 
      that session is one day earlier at 17:00.  This start date is 
      therefore the next-to-last date in tgraph.DATES, and it corre-
      sponds to the day containing zero in the times of tgraph.t.
 
      Dates in tgraph.DATES are just the session ending dates.  All the
      dates of session starting and ending are needed below to obtain
      the day for cursor position X.  For example, Sunday is never an 
      ending day, and is not in tgraph.DATES, but it is a starting day;
      and Friday is never a starting day but it is an ending day.

      Calendar functions greg, gdate and weekday from cal.v are useful 
      here.  [Later: No, they are not needed in a simple solution.]

   It took days to get through the complications described above, and 
   see through all the flack that made the problem seem harder than it 
   turned out to be.  

   Here is a solution from the XY table in word tgraph_lookup that very
   simply gets through a Friday end and a Sunday start with all the com-
   plications described above.  Note that tg has a one second difference
   between Friday end and Sunday start, but tm has a 172801 second dif-
   ference as it must in real time (48 hours):

      Date and time from tm        tm (sec)     tg (sec)

      Wed Feb 13 15:00:00 PST 2008 1202943600   -345600
      Thu Feb 14 14:59:59 PST 2008 1203029999   -259201
      Thu Feb 14 15:00:00 PST 2008 1203030000   -259200
      Fri Feb 15 14:59:59 PST 2008 1203116399   -172801

      Sun Feb 17 15:00:00 PST 2008 1203289200   -172800
      Mon Feb 18 14:59:59 PST 2008 1203375599    -86401
      Mon Feb 18 15:00:00 PST 2008 1203375600    -86400
      Tue Feb 19 14:59:59 PST 2008 1203461999        -1
      Tue Feb 19 15:00:00 PST 2008 1203462000         0
      Wed Feb 20 14:59:59 PST 2008 1203548399     86399

      Differences, Friday to Sunday:
         dtg = -172800 - -172801 = 1 (graph time)
         dtm = 1203289200 - 1203116399 = 172801 (48 hours real time)

------------------------------------------------------------------------

   Volume calibrations

      Tables below were created by running word Vtraffic() at the
      console prompt.

      Eight power-of-two levels are then selected as shown by *, and 
      entered into the table of word vtraffic().  

      To make interpretation of graphs easier, all eight levels should
      be consecutive so the basic interpretation of each successive 
      line is that volume has doubled.  With eight levels, this should
      be possible, and this calibration is simply used to see where
      in the spectrum the eight should fall.

      NOTE: THESE ARE HISTOGRAMS FROM A NUMBER OF SESSIONS AVERAGED.
      THE BINS DO NOT NECESSARILY REFLECT THE MINIMUM OR MAXIMUM OF
      ANY SINGLE SESSION.

      Vtraffic: EU Thu Feb 23 12:09:03 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       7
          4        2       0
          8        3       0
          16       4       1
          32       5       1
          64       6       2
          128      7       4
          256      8       6
          512      9       10
          1024     10 *    16
          2048     11 *    41
          4096     12 *    68
          8192     13 *    39
          16384    14 *    42
          32768    15 *    79
          65536    16 *    102
          131072   17 *    62
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: SF Thu Feb 23 12:18:34 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       9
          4        2       1
          8        3       2
          16       4       4
          32       5       5
          64       6       9
          128      7  *    19
          256      8  *    50
          512      9  *    67
          1024     10 *    37
          2048     11 *    48
          4096     12 *    79
          8192     13 *    133
          16384    14 *    17
          32768    15      0
          65536    16      0
          131072   17      0
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: JY Thu Feb 23 12:28:09 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       7
          4        2       0
          8        3       1
          16       4       1
          32       5       2
          64       6       5
          128      7       6
          256      8  *    6
          512      9  *    11
          1024     10 *    28
          2048     11 *    75
          4096     12 *    65
          8192     13 *    89
          16384    14 *    124
          32768    15 *    59
          65536    16      0
          131072   17      0
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: CL Thu Feb 23 11:27:25 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       1
          4        2       0
          8        3       0
          16       4       1
          32       5       1
          64       6       5
          128      7       11
          256      8       15
          512      9       27
          1024     10 *    49
          2048     11 *    74
          4096     12 *    51
          8192     13 *    55
          16384    14 *    34
          32768    15 *    39
          65536    16 *    85
          131072   17 *    31
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: HG Thu Feb 23 11:59:22 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       2
          4        2       1
          8        3       1
          16       4       3
          32       5       5
          64       6       8
          128      7       12
          256      8  *    11
          512      9  *    20
          1024     10 *    47
          2048     11 *    74
          4096     12 *    97
          8192     13 *    76
          16384    14 *    120
          32768    15 *    3
          65536    16      0
          131072   17      0
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: GC Thu Feb 23 10:41:53 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       2
          4        2       1
          8        3       1
          16       4       1
          32       5       2
          64       6       4
          128      7       9
          256      8       13
          512      9  *    16
          1024     10 *    22
          2048     11 *    43
          4096     12 *    74
          8192     13 *    73
          16384    14 *    76
          32768    15 *    95
          65536    16 *    47
          131072   17      0
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: DJ Thu Feb 23 12:34:56 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       8
          4        2       1
          8        3       1
          16       4       3
          32       5       4
          64       6       7
          128      7       10
          256      8       23
          512      9  *    42
          1024     10 *    69
          2048     11 *    59
          4096     12 *    75
          8192     13 *    30
          16384    14 *    61
          32768    15 *    83
          65536    16 *    2
          131072   17      0
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: SP Thu Feb 23 12:39:04 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       7
          4        2       0
          8        3       0
          16       4       0
          32       5       0
          64       6       0
          128      7       1
          256      8       2
          512      9       3
          1024     10      8
          2048     11      14
          4096     12      29
          8192     13 *    66
          16384    14 *    62
          32768    15 *    55
          65536    16 *    66
          131072   17 *    23
          262144   18 *    50
          524288   19 *    92
          1048576  20 *    2
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: NQ Thu Feb 23 12:49:00 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       8
          4        2       0
          8        3       1
          16       4       1
          32       5       4
          64       6       6
          128      7       13
          256      8       28
          512      9       54
          1024     10 *    62
          2048     11 *    58
          4096     12 *    64
          8192     13 *    23
          16384    14 *    18
          32768    15 *    61
          65536    16 *    74
          131072   17 *    5
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: US Thu Feb 23 12:55:55 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       7
          4        2       0
          8        3       0
          16       4       1
          32       5       2
          64       6       3
          128      7       5
          256      8       12
          512      9       23
          1024     10 *    58
          2048     11 *    66
          4096     12 *    47
          8192     13 *    53
          16384    14 *    33
          32768    15 *    35
          65536    16 *    76
          131072   17 *    59
          262144   18      0
          524288   19      0
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

      Vtraffic: TN Thu Feb 23 12:58:11 PST 2012
      Vtraffic: average histogram for 39 sessions
          Volume   2-power Number
          2        1       7
          4        2       0
          8        3       0
          16       4       0
          32       5       0
          64       6       1
          128      7       1
          256      8       3
          512      9       6
          1024     10      11
          2048     11      24
          4096     12 *    44
          8192     13 *    66
          16384    14 *    48
          32768    15 *    54
          65536    16 *    46
          131072   17 *    45
          262144   18 *    107
          524288   19 *    16
          1048576  20      0
          2097152  21      0
          4194304  22      0
          8388608  23      0
          16777216 24      0

------------------------------------------------------------------------

   A note about open interest

      Fri Jun  3 11:33:55 PDT 2011.  A note about open interest, re-
      cently added.

      After Memorial Day, Monday May 30, 2011, it was noticed that 
      open interest was flat for the Sunday-Monday session, consistent
      with the pits being closed for the Monday holiday and with open 
      interest not being given one day late.  It is possible that vol-
      ume and open interest are now given for the pit session just 
      ended, unlike 10 or 20 years ago when there was a one-day delay.

      Trader committments and how data is published must be reviewed to
      understand this.  

      From the open interest curves viewed in the week or two they have
      now been available, there is no compelling reason to use them and
      this section to scale them for viewing is being skipped.  

      The main reason is that they may simply be another item that helps
      explain things after the fact when a move is obvious.  That might
      be nice for guys who write books on trading, but not for me.  

      Also, more study and data gathering of trader committments is 
      needed to understand just who the large hedgers are.  Are they 
      always the shorts, as Reference 9 claims?  Maybe not for newer, 
      non-agricultural contracts.

   /* Sun May 22 09:33:01 PDT 2011.  Scale open interest to the price
      graph.  

      Open interest is given one day late.  For example, open interest 
      published on Wednesday's close is for Tuesday.  

      This means that changes in the open interest curve should be 
      viewed with the changes in the 24-hour position curve, not the 
      price curve. */

      OI = Pt[1:r, .OI];
      (OImax, X, X) = maxfetch(OI);

   /* To judge percentage change, remember that the zero base for the 
      open interest curve is a horizontal line at lowest price of posi-
      tion curve P1 when the graph is zoomed out all the way; thus 0 to
      OImax is the range of P1: */
      (Pmin, Pmax) = pminmax(Pt[1:r, .P1]); 

      X = lerp([[0 ; OImax] , [Pmin ; Pmax]], OI);

   /* Rake true to end of previous session (to verify hf from the ex-
      pression below, run: t tm ctime hf itext park eview): */
      hf = t[1:r]<tSESS(tnow); // true for t < current session 

      cram(looking(X, hf), .OI, Pt); 

------------------------------------------------------------------------

   Making sound files.
   Moved to file usr/snd.v.

------------------------------------------------------------------------

   Useful phrases.

/* Begin useful phrases

      This weights the 3 max dV rate positions per session, and then
      weights the current and previous 3 sessions.  It is probably
      too fancy, and was not good enough to replace the current 
      approach that uses just the 1 max dV rate per session:
   /* Sun Feb 12 13:31:11 PST 2012.  Volume-weighted positions at the
      highest dV rate, current session included: */
      D = dVmax3(C, X, hn);
      Y = dVmax3(X, X, hn);
      W = (D[*, 1].*Y[*, 1] + D[*, 2].*Y[*, 2] + D[*, 3].*Y[*, 3])
         ./((V=Y[*, 1] + Y[*, 2] + Y[*, 3]));
      W[1] = C[1];
      R = vwp(W, V, n, 4); // current + previous 3 sessions
      place(looking(R, hn)[putR], Pt, kstart, .W1); // key s

   // Tracking highest dV rate:
   /* Sun Jan 15 16:34:17 PST 2012.  Track times of highest dV rate.
      SV is a series of true flags at new dV highs: */
      SV = delta(mmax(Pt[*, .dV], 1+n))>0;

   // Using colsort():
   /* Thu Jan 19 17:19:47 PST 2012.  Max and min range of positions: */
      X = colsort(VQSORT(yes), Pt[useR, .V1:.V4]')'; 
      place(X[putR, 4], Pt, kstart, .VH);
      place(X[putR, 1], Pt, kstart, .VL);

   /* Sun Jan 15 15:08:28 PST 2012.  This shows some work using word 
      histogram (prevously in daymodel()): */
      g = 1;
      nr = 3;
      H = histogram(max(dV, 1), C, g);
      (X, H) = rake(H, H[*, 2]>0 && H[*, 3]>0);
      nh = min(rows(H), nr);
      IF(nh)
         R = sort(sorton(H, no, 2)[1:nh,3], yes);
         H1 = looking(C, teeth(R, r)==0);
      ELSE H1 = C;
      THEN

   /* Thu Oct 27 13:26:53 PDT 2011.  Set future values of selected 
      arrays from daymodel(): */
      k1 = k - dn - 1; // step back from k to current step
      m1 = m + dn + 1; // add more points to m due to stepping back
      X = fill(@Pt[rnow, .C], m1, 1);
      place(X, Pt, k1, .M1); // no future points
      place(X, Pt, k1, .M2); // no future points
      place(X, Pt, k1, .M3); // no future points
      place(X, Pt, k1, .M4); // no future points

      Fri Nov  4 10:28:59 PDT 2011.  These are half session highs and
      lows daymodel():
      IF(r>1);
      /* Half session highs and lows: */
         (C0, C1) = rake(C, [null(r/2, 1) ; ones(r/2)]);
         Hm = [mmax(C0, 1+m) ; mmax(C1, 1+m)];
         Lm = [mmin(C0, 1+m) ; mmin(C1, 1+m)];
         C0 = C1 = 0;
      ELSE Hm = Lm = C;
      THEN;

      This version tries to make the horizontal (time) direction into
      a price like the vertical, and integrate along a vector.  The
      simpler original version in word bcoast().  
   /* Thu Nov  3 08:28:56 PDT 2011.  Coast of Brittany:
      See who travels the longer distance: a bug crawling along Hn(t)
      or a bug crawling along Ln(t).  To convert time to a price for 
      making a 2-d vector with the price and time axes, use vgap(1) 
      as an equivalent price per time step (a time component makes 
      little difference, but what the heck, it's tough to have any 
      fun around here). */
      dx = fill(@vgap(Mkt)[1], r, 1);      // x direction steps for t
   /* Alternate dx could be based on constant settle price.  The 
      following is way too big with just divisor n; need a much bigger
      divisor (n is the steps in 24 hours).
      dx = fill(@S[1]/n, r, 1);      // x direction steps for t
   */
      dy = abs(delta(Ln));                 // y direction steps for L
      L = partials(cmag(complex(dx, dy))); // vector sum along L
      dy = abs(delta(Hn));                 // y direction steps for H
      H = partials(cmag(complex(dx, dy))); // vector sum along H
      Bn = looking2(Ln, Hn, L>H);
      dx = dy = L = H = 0;
 
   Thu Oct 27 08:19:20 PDT 2011.  Regions of covert buying and selling 
      (future reflected on present; not used):
      hf = t[1:r]>tSESS(tnow+86400); /* future sessions */
      hn = lag(daysget.rSESS[1:r], -1); /* session final times */
      cram(lag(looking(
         rbuy(Pt[*, .F1], looking(Pt[*, .Ln], hn)), hf), -n), .G3, Pt);
      cram(lag(looking(
         rsel(Pt[*, .F2], looking(Pt[*, .Hn], hn)), hf), -n), .G4, Pt);

   Mon Oct 24 08:36:12 PDT 2011.  Recent rakes for sessions:

      These definitions are used in expressions below:
      rnow = @daysget.tnow; // latest real time row to fetch price from 
      tnow = @t[rnow];      // current graph time

      tst = @tSESS(tnow); // current session start
      hf = t[1:r]>tst;    // only current and future times 

      hf = daysget.rSESS[1:r]; /* session initial times */
      hf = hf + lag(hf, n/4) + lag(hf, n/2) + lag(hf, 3*n/4) + 
              lag(hf, -1);
      X = looking(Pt[*, .Lm], hf); // lowest positions

   /* Rake true for present and past, false for future: */
      hf = t[1:r]<=tnow; // no future times
      hf1 = lag(hf, n);

   /* Rake true to the end of next session: */
      dt = tSESS(tnow+86400) - tnow; // to end of session 
      dn = rdech(dt/3600)-1; // to last point of session
      hn = lag(hf, dn); // true for times to session end
   /* Tue Sep 20 03:35:23 PDT 2011.  Add n to apply to end of next
      session when making Gr: */
      hn1 = lag(hf, n+dn); // true for times to next session end

   Tue May 10 06:20:17 PDT 2011.  More rakes for sessions:

   /* Rake true to end of previous session (to verify hf from the ex-
      pression below, run: t tm ctime hf itext park eview): */
      hf = t[1:rows(Pt)]<tSESS(tnow); // true for t < current session 

   /* Rake true for present and past, false for future: */
      tnow = @t[daysget.tnow]; // current time
      hf = t[1:rows(Pt)]<=@t[daysget.tnow]; // no future times

      NOTE: in the following three examples, hf is the rake for no 
      future times as given above:

   /* Rake true to the end of this session: */
      dt = tSESS(tnow+86400) - tnow; // to next session
      dn = rdech(dt/3600) - 1; // to last point this session
      hn = lag(hf, dn); // true for times to end of this session

   /* Rake true to the start of next session: */
      dt = tSESS(tnow+86400) - tnow; // to next session
      dn = rdech(dt/3600); // to first point next session
      hn = lag(hf, dn); // true for times to next session

   /* Rake true to the end of next session: */
      dt = tSESS(tnow+2*86400) - tnow; // to session after next
      dn = rdech(dt/3600)-1; // to last point of next session
      hn = lag(hf, dn); // true for times to next session end

   /* Rake true to the start of session after next: */
      dt = tSESS(tnow+2*86400) - tnow; // to session after next
      dn = rdech(dt/3600); // to first point session after next
      hn = lag(hf, dn); // true for times to session after next

   Tue Apr  5 16:35:06 PDT 2011.  More rakes for sessions:

   /* Rake to the start of session after next: */
      dt = tSESS(tnow+2*86400) - tnow; // to session after next
      dn = rdech(dt/3600); // to first point session after next
      hn = lag(hf, dn); // true for times to session after next
      hn1 = lag(hf, n+dn); // true for one session beyond hn

   Tue Feb 15 13:07:53 PST 2011.  Building returned matrix T (in 
      sigmodel()).  Replaced by direct storage for speed.
   /* Columns returned in T. */
   << depth push \ using postfix for speed

      P G1 G2

    \ The following phrases build the columns of T from each
    \ array listed above, then releases its memory:
      (hA1 hA2 ... hAn) depth pull less "ns" book
      0 "nc" book ns 1- 0 DO I pick cols nc bump LOOP 
      nr nc null "T" book
      (hA1 hA2 ... hAn) ns revn 1st "nc" book ns 1st
      DO (hAI) dup nc over cols dup nc bump items T cram 
         (hAI) 0 swap named book 
      LOOP 
   >>

   Tue Feb 15 04:22:52 PST 2011.  Symmetries revisited and tossed 
      again:
      hn = endmost(repeat([0*ones(m) ; ones(m)],
              rows(t)/n), nr); // 0 first half, 1 second half
      (h0, h1) = (hn==0, hn==1);
      S = looking2(Cr, lag(Cr, n), h1); // stops
   /* Symmetries. */
      Y = null(nr, 4);
      X = P[, 1]; // 24-hour position
      cram(looking2(C, S, h1), 1, Y);
      cram(looking2(S, X, h1), 2, Y);
      cram(looking2(C, S, h0), 3, Y);
      cram(looking2(S, X, h0), 4, Y);

   Tue Feb 15 03:53:02 PST 2011.  Extra stop positions in R:
   /* Positions. */
      P = null(nr, 2);
      cram(lag(C, n),    1, P); // 24-hour sequential
      cram(lag(C, 2*n),  2, P); // 48-hour sequential

      S = looking2(lag(Cr, n), Cr, hn==0); // stops
      R = null(nr, 5);
      cram(S,             1, R); 
      cram(lag(S, n/4),   2, R); 
      cram(lag(S, n/2),   3, R);
      cram(lag(S, 3*n/4), 4, R);
      cram(lag(S, n),     5, R);

   Sun Feb 13 08:52:51 PST 2011.  Using cram:
      LAG = rdech(h + [0 ; 6 ; 12 ; 18 ; 24]);
      R = null(nr, rows(LAG));
      DO(rows(LAG), 1) lag(Cr, @LAG[I]) I R cram LOOP; 

   Sat Feb 12 15:30:21 PST 2011.  Symmetries that span 48 hours:
   /* Rake for session pairs: */
      h is 24 hours, n is the number of points in 24 hours
      d = 2*n; // data points in session pairs
      st = 2*(h*3600); // session pair seconds duration
      ts = daysget.tSESS; // choose from set of session starts
      rt = mod(tm(ts)-tref, repeat(st, rows(ts)))==0;
      t1 = @(rake(ts, rt), lop); // earliest time
      r1 = (bsearch(t, t1), drop); // first row in t
      nt = 1+integer(rows(t)/d); // number of pair sets to make
      hs = endmost([ones(r1-1) ; repeat(
              [0*ones(n) ; ones(n)], nt)][1:rows(t)], r);
      Cr contains reversed time session prices, P1 holds 24-hour 
      positions:
      Y1 = looking2(Cr, P1, hs);
      Y2 = looking2(Cr, P1, lag(hs, n));

   Thu Feb 10 08:08:45 PST 2011.  Looking at symmetries with respect 
      to session start and wrt midsession, using price C, 24-hour
      position P1 and stop S.  

      There are other symmetries too, wrt session quarter and three-
      quarter points and involving S and P 12-hour position.  Conclude
      that pursuing symmetries is not productive; but they sure look 
      neat.

      Fri Feb 11 09:53:48 PST 2011.  Boy is the conclusion above wrong.
      These 12-hour symmetries were a little bit off.  Longer term sym-
      metries, 48-hour ones that overlap each other by 24 hours, are
      significant; see model 2011Feb11.

   /* Symmetries. */
   /* Rake for session halves: */
      hn = endmost(repeat([0*ones(m) ; ones(m)],
              rows(t)/n), r); // 0 first half, 1 second half
      S = looking2(lag(Cr, n), Cr, hn==0); // stops
      Y1 = looking2(C, S, hn==0);  // wrt midsession
      Y2 = looking2(S, P1, hn==0); // wrt midsession
      Y3 = looking2(S, P1, hn==1); // wrt session start
      P = lag(C, m); // positions 

   Tue Feb  8 09:03:41 PST 2011.  More rakes for 24 hour models:
      n is the number of points in 24 hours
      m = n/2
      r = rows(Pt); // data rows

   /* Rake true for present and past times, false for future: */
      tnow = @t[daysget.tnow]; // current time
      hf = endmost(t<=@t[daysget.tnow], r); // no future times
   /* Rake for end of session half: */
      dt = tSESS(tnow+86400) - tnow; // from now to session end
      dn = rdech((dt+43200*(dt>43200))/3600)-1; // to half end
      hm = lag(hf, dn); // rake for times to session half end
   /* Rake for session halves: */
      hn = endmost(repeat([0*ones(m) ; ones(m)],
              rows(t)/n), r); // 0 first half, 1 second half
   /* Rake for session one- and three-quarter points: */
      hs = endmost((lag(daysget.rSESS, m/2) + lag(dup, m)), r);
   /* Rake for final time point of session halves: */
      hd = endmost(lag((daysget.rSESS + lag(dup, m)), m-1), r);
   /* Rake to next session start (Tue Mar  1 09:35:07 PST 2011): */
      dt = tSESS(tnow+86400) - tnow; // to next session start
      dn = rdech(dt/3600); // to first point next session
      hn = lag(hf, dn); // true for times up to next session

   Sat Feb  5 19:07:37 PST 2011. 
   /* Sat Feb  5 19:07:37 PST 2011.  Verify stops calculation.

      The equation for reversed time stops is:
         S1(t) = C(t - 2*(t - t0));
      where t0 is the nearest half session start time below t.

      The procedure in sigmodel() does not use this equation
      but uses these expressions based upon reversed session
      prices Cr from daymodel() to compute S1:
      Cr = Pt[, .Cr]; // session reversed time data
      S1 = looking2(Cr, lag(Cr, n), hn==1); // last half
      S2 = lag(S1, m); // half session before last half

      The following expressions implement the equation above,
      and show that the procedure using Cr is equivalent:
      t1 = [1:rows(t)];
      t0 = looking(t1, (daysget.rSESS + lag(dup(), m)));
      R = max(t1 - 2*(t1 - t0), 1);
      S1 = C[R]; // last half
      S2 = lag(S1, m); // half session before last half

      The expressions above require past values of C and will
      fail when given just a latest subset of C from coladd()
      (done for speed), while the procedure using Cr will not.
   */

   Sat Feb  5 14:52:40 PST 2011.  Ramming session start values into
      S1 in sigmodel().  Note hs is a list of rows for C at session 
      start based on reduced size r and rows per session n:
         ram(C[(hs=1+uniform(n, r/n))], hs, S1); 

   Thu Feb  3 16:48:32 PST 2011.  Expressions for triplets that a lot
      of work went into and that might hold useful ideas (from file
      /archive/opt_mytops_usr/mobius.n.2011Jan23).
   /* Triplets. */
      h = 24;
      n = rdech(h); // data points in h hours
      m = n/2; // data points in a session half (c)
      d = 3*m; // data points in a triplet (c-s-p)
   // Word tref sets a reference time.

   /* Pattern rakes for triplets (use tm(ts)-tref so triplet
      series 1 applies for the same dates and times no matter
      what group of sessions is graphed; the following seven
      expressions took about seven hours to get right): */
      ts = daysget.tSESS; // choose from set of session starts
      rt = mod(tm(ts)-tref, repeat(st, rows(ts)))==0;
      t1 = @(rake(ts, rt), lop); // series 1 earliest time
      r1 = (bsearch(t, t1), drop); // series 1 first row in t
      nt = 1+integer(rows(t)/d); // number of sets to make
      hc = endmost([null(r1-1, 1) ; repeat(
              [ones(m) ; null(n, 1)], nt)][1:rows(t)], r);
      (hs, hp) = (lag(hc, m), lag(dup, m));

      nt = d*(1+integer(r/d)); // number of triplet sets
      (c, s, p) = (hc, hs, hp);
      X = null(nt, 1);
      place((C.*c + S.*s + P1.*p)[r1:r], X, 1, 1);
      T = foldr(X, d); // triplet series 1
   /* What daymodel() does to each session of C over period n
      to get Hn and Ln, the following expression does to each
      column of T over period d: */
      T1 = lag(parkn(X, chain(mmax(T, 1+d)),
              chain(mmin(T, 1+d)), 3), r1-1)[1:r];
      (c, s, p) = (lag(c, m), lag(s, m), lag(p, m));
      X = null(nt, 1);
      place((C.*c + S.*s + P1.*p)[m+r1:r], X, 1, 1);
      T = foldr(X, d); // triplet series 2
      T2 = lag(parkn(X, chain(mmax(T, 1+d)),
              chain(mmin(T, 1+d)), 3), m+r1-1)[1:r];
      (c, s, p) = (lag(c, m), lag(s, m), lag(p, m));
      X = null(nt, 1);
      place((C.*c + S.*s + P1.*p)[m+m+r1:r], X, 1, 1);
      T = foldr(X, d); // triplet series 3
      T3 = lag(parkn(X, chain(mmax(T, 1+d)),
              chain(mmin(T, 1+d)), 3), m+m+r1-1)[1:r];
      c = s = p = 0;

   Mon Jan 31 11:48:27 PST 2011.  From previous version of daymodel():
   <<
    \ Make a line that spans from the first value in c to midsession
    \ value to last value:
      c rows dup ndx "r" book 2 / 1 max ndx "r/2" book
      list: 0 r/2 r ; (hX)
      list: c 1st pry c r/2 pry c r pry ; (hY) park (hXY)
      (hXY) 0 c rows items lerp "Nn" book \ position line
   >>

   Sat Jan 29 16:33:09 PST 2011.  Rakes for session halves: hs and h1
      split into first and second halves, or, hs and h1 get just the 
      first half and h2 gets just the second half:
   /* Pattern rakes for session halves: */
      hs = endmost(repeat([null(n/2, 1) ; ones(n/2)], 
              rows(t)/n), r);
      (h1, h2) = (hs==0, hs==1);

   Sat Jan 29 08:48:18 PST 2011.  This had me going.  Perhaps it is
      not so useful.  Tracks the closest that price C comes to posi-
      tions P1, but does it in "batch" mode, so past values can change 
      (this subtlety shows up when stepping with replay).  

      Note that m can be any fraction of n, the number of steps in 24 
      hours.  If m = 1, the batch problem is gone and the limits of G3 
      reduce to just the moving max and moving min of positions P1.

      m = n/2;
      k = min1(matrix(abs(C-P1), r/m))[*, 2] + uniform(m, r/m);
      ram(ones(rows(k)), k, (X=null(r, 1)));
      X = looking(P1, X);
      G3 = weave1(mmin(X, n+1), mmax(X, n+1));

   Thu Jan 27 16:25:50 PST 2011.  Alternate formulation for R1 and R2
      in sigmodel(), model 2011Jan23, where they are hidden behind
      P1 during periods they do not apply:

      (r0, r1) = rake(P1, Rs);
      (p0, x) = rake(lag(Cr, n-1), Rs);
      (x, p1) = rake(lag(Cr, 1), Rs);
      R1 = tier(p0, r1, Rs);
      R2 = tier(r0, p1, Rs);

   Mon Jan 24 10:21:05 PST 2011

      Macros for voices based on elapsed times, from Model 2011Jan12:

   /* Table of hours (X) and indices 1-8 (Y): */
      XY = [[0,0] ; [rdech.SEC/3600,1] ; [4,2] ; [8,3] ;
            [16,4] ; [24,5] ; [32,6] ; [40,7] ; [48,8] ;
            [INF,8]];

      vs = words("DELTA101 " +
                 "ECHO1 ECHO2 ECHO3 ECHO4 " +
                 "ECHO5 ECHO6 ECHO7 ECHO8 " +
                 "LIMA1 LIMA2 LIMA3 LIMA4 " +
                 "LIMA5 LIMA6 LIMA7 LIMA8 ");
   /* Table of hours (X) and ECHO indices in words vs (Y): */
      XY_ECHO = [XY[*, 1] , XY[*, 2] +
                   [0 ; fill(1 , rows(XY)-1, 1)]];
   /* Table of hours (X) and LIMA indices in words vs (Y): */
      XY_LIMA = [XY[*, 1] , XY[*, 2] +
                   [0 ; fill(9 , rows(XY)-1, 1)]];

   /* Elapsed time macros for voice states: */
      macro("(dV0) tx1 tx2 > tx1 tx3 > and and abs " +
            "(dV) dup tx1 *by tx XT 1 <> looking " +
            "(dV tx1 tx1n) rot *by - (sec) 3600 / (hr) " +
            "XY_ECHO swap lerp integer 0 max (dV1) ", "ECHO");
      macro("(dV0) tx3 tx2 > tx3 tx1 > and and abs " +
            "(dV) dup tx3 *by tx XT 3 <> looking " +
            "(dV tx3 tx3n) rot *by - (sec) 3600 / (hr) " +
            "XY_LIMA swap lerp integer 0 max (dV1) ", "LIMA");

      Using the macros:

      tx = endmost(t, r);
      tx1 = looking(tx, XT==1);
      tx2 = looking(tx, XT==2);
      tx3 = looking(tx, XT==3);
      VT -= (<< VT rows 1 null 0= \ states for macro ST
         (dV)   XT 2 = (1 *)      \ delta101
         dup 0= (dV0) ECHO (dV) - \ echo1-echo8
         dup 0= (dV0) LIMA (dV) - \ lima1-lima8

         (dV) replay (f) \ display the voice state
         IF (dV) dup rnow pry abs any?
            IF (n) vs rows 1
               DO dup (n) I =
                  IF vs I quote strchop . sp THEN
               LOOP (n) drop yes "nl1" book
            THEN (dV)
         THEN
         (dV)
      >>);

   Sat Jan 22 23:05:19 PST 2011

      Macros from daymodel():

        macro("(C p --- Xmax) (C p) 1+ mmax (X) " +
              "(X) dup delta 0< looking " +
              "(X1) dup delta 0> looking (Xmax)",
              "SMAX");

        macro("(C p --- Xmin) (C p) 1+ mmin (X) " +
              "(X) dup delta 0> looking " +
              "(X1) dup delta 0< looking (Xmin)",
              "SMIN");
        /*
        Macro SMAX is equivalent to the following:
           X = mmax(c, 1+p);
           X = looking(X, delta(X)<0);
           X = looking(X, delta(X)>0);

        Macro SMIN is equivalent to the following:
           Y = mmin(c, 1+p);
           Y = looking(Y, delta(Y)>0);
           Y = looking(Y, delta(Y)<0);
        */

   Thu Jan 20 13:52:41 PST 2011.

      Examples of vectors for times (note that for using looking()
      over a number of sessions, dn, rnow and rstart are too specific
      because they only apply to the current session):
      tnow = @t[daysget.tnow]; // current time
   /* Steps from now until session end: */
      dn = rdech((tSESS(tnow+86400) - tnow)/3600)-1;
   /* Steps from now until session half end: */
      dt = tSESS(tnow+86400) - tnow;
      dn = rdech((dt+43200*(dt>43200))/3600)-1;
   /* Rake true for present and past times, false for future: */
      hf = endmost(t<=tnow, (r=rows(Pt)));
      hf1 = lag(hf, n+dn);

      rdif = rows(t) - r;          // t and Pt row difference
      rnow = @daysget.tnow - rdif; // latest real time 
      rstart = rtime(t, tm(tSESS(tnow))) - rdif; // start

   Thu Jan  6 16:41:28 PST 2011.

      Example from sigmodel() using all three voice states, ST, RT and
      UT (also see April 2010 below, "Testing macros ST and RT"):

   /* Voice States. */
      (VT, nl1) = (null(r, 1), no);
      vr = words("FOXTROT1 FOXTROT2 TANGO1 TANGO2");
      vs = words("BRAVO101 DELTA101 SIERRA101"); 
      vt = words("ABLE1 BAKER1");

      VT -= (<< VT rows 1 null 0= \ states for macro ST
         (dV)   C E2 < and (1 *)  \ bravo101
         dup 0= C F1 > and  3 * + \ sierra101
         dup 0=             2 * + \ delta101

         (dV) replay (f) \ display the voice state
         IF (dV) dup rnow pry abs any?
            IF (n) vs rows 1
               DO dup (n) I =
                  IF vs I quote strchop . sp THEN
               LOOP (n) drop yes "nl1" book
            THEN (dV)
         THEN
         (dV)
      >>);

      VT -= (<< VT rows 1 null 0= \ states for macro RT
         (dV)   E1 L1 < E2 L1 > and and 100 *   \ foxtrot1
         dup 0= F1 H1 < F2 H1 > and and 400 * + \ tango2

         (dV) replay (f) \ display the voice state
         IF (dV) dup rnow pry abs any?
            IF (n) vr rows 1
               DO dup (n) I 100 * =
                  IF vr I quote strchop . sp THEN
               LOOP (n) drop yes "nl1" book
            THEN (dV)
         THEN (dV)
         (dV)
      >>);

      T1 = looking(L1, L1>=F1);
      T2 = looking(H1, H1<=E2);

      f1 = crossabove(C, T1) || crossbelow(C, T1);
      f2 = crossabove(C, T2) || crossbelow(C, T2);
      VT -= (<< VT rows 1 null 0= \ states for macro UT
         (dV)   f1 and 10000 *   \ able1
         dup 0= f2 and 20000 * + \ baker1

         (dV) replay (f) \ display the voice state
         IF (dV) dup rnow pry abs any?
            IF (n) vt rows 1
               DO dup (n) I 10000 * =
                  IF vt I quote strchop . sp THEN
               LOOP (n) drop yes "nl1" book
            THEN (dV)
         THEN (dV)
         (dV)
      >>);
      f1 = f2 = 0;

   Tue Dec 28 08:04:04 PST 2010.  
      Experiment in daysfill().
      Setting L1 to mmin(C, 1+n) and H1 to mmax(C, 1+n):
      n =sigmodel.n;
      C = Pt[*, .C];

      place(mmin(C, 1+n), Pt, 1, .L1);
      place(mmax(C, 1+n), Pt, 1, .H1);

      C = 0;
      Pt1 = Pt;

   Tue Nov 16 13:58:04 PST 2010
      Crossings:
         X = P[, 1];
         B = looking(X, (hf && (crossabove(C, X) || crossbelow(C, X))));
         X = P[, 3];
         S = looking(X, (hf && (crossabove(C, X) || crossbelow(C, X))));

   Tue Nov 16 05:11:45 PST 2010
      Hiding a curve behind the nearest:
         (X, Y) = nrcrv(P3, [B1, S1]);
         R1 = looking2(P3, X, (P3>B1 && P3<S1));
         X = Y = 0;

   Sun Oct 17 15:59:51 PDT 2010
      Making three-hour groups of positions.

      These are their hours:
        Col   CST    PST   key
         1   17:00  15:00   w
         2   20:00  18:00   w
         3   23:00  21:00   e
         4   02:00  00:00   e
         5   05:00  03:00   s
         6   08:00  06:00   s
         7   11:00  09:00   d
         8   14:00  12:00   d

   /* Positions. */
      cT = 24;       // daily tracking period
      p = 8;         // periods within cT
      dL = rdech(cT/p);
      hf1 = lag(hf, n);
      R1 = lag(C, n);
      f = trake(endmost(t, r), "17:00:00", "19:57:00");
      P = null(r, p);
      DO(p, 1); (cram(looking(R1, f), I, P) f=lag(f, dL)) LOOP;
      P = looking(P, hf1);
      R2 = lag(C, m);
   // M = across(P)/p; // average position
   // A = lag(M, -n);  // average price


   Wed Oct 13 12:23:06 PDT 2010
      Debug phrases for testing voices:
ECHO1 = LIMA1 = 0;
DT = 86400;
hf = endmost(t<=@t[daysget.tnow]+DT, rows(Pt));
hf1 = endmost(t<=@t[daysget.tnow], rows(Pt));
      VT -= (<< VT rows 1 null \ states for macro ST
             0= C B1 = and (1 *)      \ bravo101

         dup 0= C S1 = and  2 * +     \ sierra101

         dup 0= R1 S1 =    (f1) \ prices equal
dup hf rake lop 1 endmost @ "F1" book
            dR1 0<>        (f2) \ slope not zero
dup hf rake lop 1 endmost @ "F2" book
            dR1 S1 delta = (f3) \ slopes equal
dup hf rake lop 1 endmost @ "F3" book
            B1 B1 d lag =  (f4) \ other slope flat for d steps
dup hf rake lop 1 endmost @ "F4" book
            (f1 f2 f3 f4) and and and
            -n lag and 3 * +          \ echo1
dup hf1 rake lop 1 endmost @ "ECHO1" book
ECHO1 -3 =
IF "F1 F2 F3 F4 ECHO1:" . F1 .i F2 .i F3 .i F4 .i ECHO1 .i nl THEN

         dup 0= R1 B1 =    (f1) \ prices equal
dup hf rake lop 1 endmost @ "G1" book
            dR1 0<>        (f2) \ slope not zero
dup hf rake lop 1 endmost @ "G2" book
            dR1 B1 delta = (f3) \ slopes equal
dup hf rake lop 1 endmost @ "G3" book
            S1 S1 d lag =  (f4) \ other slope flat for d steps
dup hf rake lop 1 endmost @ "G4" book
            (f1 f2 f3 f4) and and and
            -n lag and 4 * +          \ lima1
dup hf1 rake lop 1 endmost @ "LIMA1" book
LIMA1 -4 =
IF "G1 G2 G3 G4 LIMA1:" . G1 .i G2 .i G3 .i G4 .i LIMA1 .i nl THEN
         >>);

   Tue Sep 14 08:30:03 PDT 2010.  Added voices for RT and UT:

    { gmax = 8; }
      g = @vgap(Mkt); // price band
      X = min((1 + max(integer(0.5 + (C - C1)/g), 0)), gmax);
      VT += (<< \ states for macro RT
             X 100 * \ echo1-echo8 bands
         >>);
      X = min((1 + max(integer(0.5 + (C2 - C)/g), 0)), gmax);
      VT += (<< \ states for macro UT
             X 10000 * \ lima1-lima8 bands
         >>);

   Sat Sep  4 14:51:38 PDT 2010.  Miscellaneous from sigmodel:

      hf = endmost(t<=@t[daysget.tnow], rows(Pt)); // no future
      hf = endmost(t<=@(t[daysget.tnow]+21600), rows(Pt));
      hf = endmost(t<=@(t[daysget.tnow]+rdech.SEC), rows(Pt));

      P = colsort(pilen(DO(k, 1) lag(C, @L[I])' LOOP, k));

      R = looking(reach(P, E)', hf);
      M = looking(totals(P)/k, hf);

      B = reversed(colsort(
          pilen(DO(k, 1) mmin(C, @L[I]+1)' LOOP, k)))';
      S = colsort(
          pilen(DO(k, 1) mmax(C, @L[I]+1)' LOOP, k))';

      VT -= (<< VT rows 1 null \ states for macro RT
             0= C U < and C m lag U >= and 100 *   \ keyhole1
         dup 0= C V > and C m lag V <= and 200 * + \ keyhole2
         >>);

      macro("B 1 catch B 2 catch weave 1 B cram 2 B cram " +
         "B n 1- catch B n catch weave n 1- B cram n B cram " +
         "n 1+ 2 / push " +
         "B peek 1- catch B peek 1+ catch weave " +
         "peek 1+ B cram pull 1- B cram", "WEAVE");

   Sat Jul 24 13:41:29 PDT 2010  (also see below, June 2010).
      Ways of limiting future data; new word tSESS may be useful:
   /* No future: */
      hf = endmost(t<=@t[daysget.tnow], rows(Pt)); // no future

   /* No session after next: */
      hf = endmost(t<tSESS(t[daysget.tnow]+2*86400), rows(Pt)); 

   /* No day after tomorrow: */
      hf = endmost(t<=@t[daysget.tnow]+86400, rows(Pt));

   Sat Jul 10 18:15:47 PDT 2010
   /* The following curves are valid next session, but make
      vector hf to restrict looking at them beyond the next
      session: */
      t1 = @(<< time dup soonest_start + 86400 + >>);
      hf = t<=@t[rtime(t, t1)];
 
   Thu Jul  8 11:29:39 PDT 2010
      B = parkn(DO(rows(d), 1) looking(C, ST==I) LOOP rows(d));
      S = parkn(DO(rows(d)+7, 8) looking(C, ST==I) LOOP rows(d));

   Tue Jul  6 09:24:04 PDT 2010
      hf = t<=@t[rnow(t, time)]; // no future hours
      X = B[*, 4];
      Y = B[*, 5];
      f1 = ((C==X && X!=Y) && hf);

      X = S[*, 4];
      Y = S[*, 5];
      f2 = ((C==X && X!=Y) && hf);

      VT -= (<< C rows 1 null \ states for macro RT
             0= f1 and 100 *   \
         dup 0= f2 and 200 * + \
         >>);

   June 2010.
      hf = t<=@t[rnow(t, time)]; // no future hours

   /* Restrict curves beyond day after tomorrow: */
      hf = t<=@t[rtime(t, time+86400)]; // no day after next
      C1 = looking2(lag(R1, -m), C, hf);
      C2 = looking2(lag(R2, -m), C, hf);

   /* Lowest and highest positions in k sessions: */
      X = stats1(parkn(DO(k, 1) lag(C, I*m) LOOP, k));
      R1 = X[*, 1];
      R2 = X[*, 3];

      VT -= (<< C rows 1 null \ states for macro RT
             ST dup 1 lag <> 100 * \ RT1: ST has changed
         >>);

       VT = -(<< C rows 1 null
              P1 C <= (1 *)      \ ST1
              C P1 <   2 * +     \ ST2
              P2 C <=  100 * +   \ RT1
              C P2 <   200 * +   \ RT2
              P3 C <=  10000 * + \ UT1
              C P3 <   20000 * + \ UT2
          >>);

   June 2010.
      Working in sigmodel(), model 2010Jun02.  

      It isn't always clear what is what when using lags.  In the fol-
      lowing, expressions were proved to be equivalent by subtacting
      them and obtaining a null matrix. 

      For these definitions:
         D = looking(C, ST==1); // selling
         S = looking(C, ST==2); // buying

      these pairs of expressions are equivalent:
         E = looking(P, lag(ST==1, m)); // bought
         E = looking(lag(D, m), h); // bought

         U = looking(P, lag(ST==2, m)); // sold
         U = looking(lag(S, m), h); // sold

       These were also found to be equivalent with full and with re-
       strictive h, but better verify further just how h behaves.  It
       may be that h has no effect since it is included in the defini-
       tion of ST.
         E = lag(D, m); // bought 
         U = lag(S, m); // sold

   April 2010.
      Testing macros ST and RT:

         In this test, states ST and RT are assumed to have values 0, 1 
         or 2.  They are both stored in vector V as ST + 10*RT.

         "(hV) 10 over dims fill /mod drop" "ST" macro
         "(hV) 10 over dims fill /mod lop " "RT" macro

         (Factor 10 is used because no value of ST or RT is over 10)

       \ Test vector V holds all combinations of ST + 10*RT:
         list: 00 01 02, 10 11 12, 20 21 22 ; "V" book

         [tops@plunger] ready > V, V ST, V RT, 3 parkn .m
                        V       ST       RT
          Row 1:        0        0        0
          Row 2:        1        1        0
          Row 3:        2        2        0
          Row 4:       10        0        1
          Row 5:       11        1        1
          Row 6:       12        2        1
          Row 7:       20        0        2
          Row 8:       21        1        2
          Row 9:       22        2        2
         [tops@plunger] ready >

   March 2010.  Computing averages over r and s sessions:
      R1 = (<< P1 m lag r 2 DO P1 I m * lag + LOOP r / >>);
      R2 = (<< P2 m lag r 2 DO P2 I m * lag + LOOP r / >>);
      S1 = (<< P1 m lag s 2 DO P1 I m * lag + LOOP s / >>);
      S2 = (<< P2 m lag s 2 DO P2 I m * lag + LOOP s / >>);

   February 2010.  Constraining variables in sigmodel() to core hours:
      tA =daymodel.tA; // "07:30:00";
      tB =daymodel.tB; // "11:30:00";
      R = trake(t, tA, tB);
      C = looking(C, R);
      A = looking(A, R);
      M = looking(M, R);
      Q1 = looking(Q1, R);
      Q3 = looking(Q3, R);
      R = 0;

   December 2008.  How to remove future values from curves:
      f = t < @t[rnow(t, time)];
      P1 = looking(ma(C, h), f);

      Debugging:
      f = t < @t[rnow(t, time)];
      (toss, ST) = rake(ST, f);
      (toss, t1) = rake(t, f);
      << "HALTING" . nl t1 tm ctime ST itext HALT >>

   September 2009 Mapping example.  From earlier sigmodel(), this shows
   a check of mapping for four levels:

   /* For voices in signal(), vector v keeps track of four price map-
      pings.  Assign four values for the mappings in v: */
      S101 = signal.S101 = 4; // sierra101
      D102 = signal.D102 = 3; // delta102
      D101 = signal.D101 = 2; // delta101
      B101 = signal.B101 = 1; // bravo101

   /* Notes on building vector v.
      Note: This check was run when there were six mappings.

      Six-row vector N holds sums of each of the six mappings:

         N = -totals(parkn(v==S102, v==S101, v==B102, v==B101,
                           v==D101, v==D102, 6));

      This table shows the six rows of N (displayed horizontally) from
      each of the six steps below where mappings are stored into v for
      market NQ on September 23, 2009 (using the last 60 sessions):

         Step       S102   S101   B102   B101   D101   D102   Row Sum
         After S1   0      10076  0      0      0      0      10076
         After S2   6187   3889   0      0      0      0      10076
         After B2   6187   3889   5374   0      0      0      15450
         After B1   6187   3889   2984   2390   0      0      15450
         Before D2  6187   3889   2984   2390   13827  0      29277
         Before D1  6187   3889   2984   2390   6615   7212   29277

      The summation of numbers in the last row equals the row size of
      the model, verifying that each time step is accounted for in one,
      and only one, row of v:
          stack elements:
                0 matrix: P1  29277 by 8

   */
   /* Checking v: the total number of all six types in v must equal
      rows(v) if each time step is mapped to one, and only one, type: */
      N = -totals(totals(parkn(v==S101, v==B101, v==D101, v==D102, 4)));
      if(@N!=rows(v))
         HALT(
         << RToffline " sigmodel: mapping error, h" "alting" + . nl >>);
   End of mapping example.

 // Relative strength R from former sigmodel().  Calculations using
    lerp() are equivalent to the calculations in word rsi():

    { n = rdech(96); }
      P = Pt[*, .C];
      R100 = mmax(P, n);
      R0 = mmin(P, n);

      XY = [[0 ; 100], [R0, R100]'];
      x = ones(rows(P))';

      R10 = lerp(XY, 10*x)';
      R30 = lerp(XY, 30*x)';
      R50 = lerp(XY, 50*x)';
      R70 = lerp(XY, 70*x)';
      R90 = lerp(XY, 90*x)';

      XY = x = 0;
      R = parkn(R0, R10, R30, R50, R70, R90, R100, 7);
      R0 = R10 = R30 = R50 = R70 = R90 = R100 = 0;
/*
   From sigmodel(), using all prices when Rk is true:
      U = parkn(looking(P, R1==yes), looking(P, R2==yes),
                looking(P, R3==yes), looking(P, R4==yes),
                looking(P, R5==yes), looking(P, R6==yes),
                looking(P, R7==yes), looking(P, R8==yes),
                looking(P, R9==yes), 9);
*/

End useful phrases */

   Functions no longer used.

/* Begin obsolete

   Computing traffic outliers.  This was removed when it was felt
   that traffic moving max was better since it contains all high
   traffic. 
   These traffic outliers are "vertical," going along the memories of
   traders at their working hours for sessions past, using word lag().
   This is different from moving max, which is derived from a time 
   series and is a "horizontal" quantity.
   /* Market data: */
      v = vtraffic(Mkt);     // constants for Mkt traffic
      ns = @v[1];
      V = Pt[*, .dV];        // traffic
      W = null(ns, rows(V)); // traffic (memory)
      DO(ns, 1) ram(lag(V, n*I)', I, W); LOOP; 
   /* Sat Jan 28 18:13:44 PST 2012.  Traffic outliers: */
      M = 0.5 + integer(mean(W));
      W = 0;

   function (G1, G2) = bcoast(Ln, Hn) { // the coast of Brittany
   /* Wed Nov  2 20:58:54 PDT 2011.  The coast of Brittany.

      Together, curves Hn and Ln form a closed curve because they join
      at each session start.  During each session they can be imagined
      to form the outline of an island, and we might ask which is the
      longer trek to get from session start to session end--going north
      along Hn, or south along Ln?  This is similar to a problem raised
      in Gleick's "Chaos" where the distance along every nook and cranny
      of the coast of Brittany is considered.  Although Brittany is not
      an island, we do need an island for our two routes to be meaning-
      fully compared--they must meet again at the end as Hn and Ln do.

      At each time step from session start, see who has traveled the
      longer distance: an ant walking the northern coast of Hn(t) or
      an ant walking the southern coast of Ln(t).  Ignore the distance
      they travel along the time axis, and just add up the parts along
      the price axis.

      Assemble all the longer pieces of Ln and Hn to make composite
      curve Bn.  For example, Ln is becomes part of Bn when its pieces
      sum to greater length than the pieces of Hn: */
      Bn = looking2(Ln, Hn,
              partials(abs(delta(Ln))) > partials(delta(Hn)));

   /* Thu Nov  3 06:41:09 PDT 2011.  Region G1 between Bn and Hn and
      region G2 between Bn and Ln: */
      G1 = weave1(Bn, Hn); // when Ln is the longer path
      G2 = weave1(Bn, Ln); // when Hn is the longer path

      Bn = 0;
   }

   function (f) = crossabove(X, Y) { // true when X crosses above Y
   /* Mon Oct 25 08:27:53 PDT 2010
      Flag f is true when X crosses above Y and false otherwise. 
      Also see word crossover1(). */
      { eps = 1E-6; }
      f1 = X>(Y1=Y+eps);
      f2 = X<Y1;
      f = (abs((f1 && lag(f2, 1))) + (f2 && lag(f1, 1)))>0;
      f1 = f2 = Y1 = 0;
   }

   function (f) = crossbelow(X, Y) { // true when X crosses below Y
   /* Mon Oct 25 08:27:53 PDT 2010
      Flag f is true when X crosses below Y and false otherwise.
      Also see word crossover1(). */
      { eps = 1E-6; }
      f1 = X>(Y1=Y-eps);
      f2 = X<Y1;
      f = (abs((f1 && lag(f2, 1))) + (f2 && lag(f1, 1)))<0;
      f1 = f2 = Y1 = 0;
   }

/* Native word crossover() has been written (see file wapp.c), and 
   probably does a better job than this one, formerly crossover() and
   renamed crossover1(): */
   function (f) = crossover1(X, Y) { // +1, 0, or -1 when X crosses Y
   /* Flag f is +1 when X crosses above Y, -1 when X crosses below Y,
      and 0 otherwise. */
   // Also see word separate().
      { eps = 1E-6; }
      f1 = X>(Y1=Y+eps);
      f2 = X<Y1;
      f = abs((f1 && lag(f2, 1))) + (f2 && lag(f1, 1));
      f1 = f2 = Y1 = 0;
   }

   inline: delta_ave (hA --- hAve) \ average spacing across cols
{     Each row of incoming A corresponds to a point in time.

      What is the magnitude of spacing between all the elements in each
      row of A?  Assumes more than one column in A.

      Work with the transpose of A, so words colsort, delta and mag
      that operate on rows are applicable:
}     bend (hA') dup rows (nR) push

{     Think of each column of A' as a vector.  Sort each column to get
      closest spacing between each vector component, then compute delta
      between successive components, then their magnitude, and then the
      average magnitude of the R-1 nonzero delta values (R-1 because
      the very first delta is always zero and it is ignored):
}     (hA') colsort delta mag pull (nR) 1- /
   end

   inline: delta_min (hA --- hAve) \ mininum spacing across cols
{     Each row of incoming A corresponds to a point in time.

      What is the minimum spacing between any of the elements in each
      row of A?

      Work with the transpose of A, so words colsort and delta that
      operate on rows are applicable:
}     bend (hA')
{
      For each column of A', sort rows to get closest spacing between
      each row, then compute delta between each row, and return the
      minimum abs delta from all the columns:
}     (hA') colsort delta (hD)
      (hD) 2nd over rows 1- items reach \ row 1 is all zeroes; ignore it
      abs minfetch 2drop

   function (P) = dmodel(L, H, n) { // low and high positions model
   /* Mon Oct 24 15:51:43 PDT 2011 */

      P = null(8, rows(L)); 
      ram(    L',       1, P);
      ram(lag(L, n)',   2, P);
      ram(lag(L, 2*n)', 3, P);
      ram(lag(L, 3*n)', 4, P);
      ram(    H',       5, P);
      ram(lag(H, n)',   6, P);
      ram(lag(H, 2*n)', 7, P);
      ram(lag(H, 3*n)', 8, P);
/*
      ram(lag(L, n)',   1, P);
      ram(lag(L, 2*n)', 2, P);
      ram(lag(L, 3*n)', 3, P);
      ram(lag(L, 4*n)', 4, P);
      ram(lag(H, n)',   5, P);
      ram(lag(H, 2*n)', 6, P);
      ram(lag(H, 3*n)', 7, P);
      ram(lag(H, 4*n)', 8, P);
*/

   /* The 8 rows of each column of P must be sorted for voices in 
      sigmodel(); then P' is returned: */
      P = colsort(VQSORT(yes), integer(P))'; // sorted
   }

   function (T) = dmodel1(F, n) { // model for price function F
   /* Mon Oct 24 03:11:42 PDT 2011 */

      T = null(rows(F), 4); // T = [C1 C2 R1 R2]

      X = lag(F, n);   // position session last
      Y = lag(F, 2*n); // position session before last

   /* Note price F when it is above or below both of the last two 
      session positions: */
      cram((C1=looking(F, (F<X && F<Y))),   1, T); // C1
      cram((C2=looking(F, (F>=X && F>=Y))), 2, T); // C2
      X = Y = 0;

   /* Sorted order, not session order, of positions is important.  Use 
      C1 and C2 to determine the last session positions that are at 
      lowest and highest prices: */
      cram(lag(C1, n), 3, T); // R1, lowest one session ago
      cram(lag(C2, n), 4, T); // R2, highest one session ago
      C1 = C2 = 0;
   }

   end

   function (F) = ds1(X) { // flags in F are true when X is falling
   // August 2009: added integer function
   // Assumes typical |X| > 1.
      d = delta(integer(X));
      d1 = lag(d, 1);
      F = (d<0 || (d<0 && d1<=0) || (d<=0 && d1<0));
      d = d1 = purged;
   }

   function (F) = ds2(X) { // flags in F are true when X is rising
   // August 2009: added integer function
   // Assumes typical |X| > 1.
      d = delta(integer(X));
      d1 = lag(d, 1);
      F = (d>0 || (d>0 && d1>=0) || (d>=0 && d1>0));
      d = d1 = purged;
   }

   function (U, D) = dsplit(X) { // data X into rising and falling
   // August 2009: added integer function

   // Note: Test this function to see if integer or floating point
   // works best for the data going into delta().
    //d = delta(integer(X)); // integer data
      d = delta(X); // floating point data

      d1 = lag(d, 1);

   /* Important: parentheses around expressions containing && are re-
      quired for the correct precedence; without them the phrase will
      run, but the result will be wrong (just like having parentheses
      wrong in math expressions): */
      r = (d>0 || (d>0 && d1>=0) || (d>=0 && d1>0));
      U = looking(X, r); // X rising

      r = (d<0 || (d<0 && d1<=0) || (d<=0 && d1<0));
      D = looking(X, r); // X falling

      d = d1 = r = purged;
   }

   function (Cmax, R) = dVmax(C, dV, n, nmax, hf) { // prices at max dV
   /* Thu Feb  9 14:43:53 PST 2012.  Returned Cmax contains prices for
      the nmax highest dV rates of each session. */

      ERRset("dVmax prices");

      r = rows(C);
      X = looking2(dV, fill(-INF, r, 1), hf); // -INF invalidates future

      R = Rmax((Rmax.nmax=nmax), X, n);
      X = teeth(R, rows(X))==0;
      Cmax = looking(C, X && hf);
      X = 0;

   /* Return matrix of indices for nmax dV.  Each column is a session
      and highest dV is first row, second-highest dV is second row, 
      and so on: */
      R = foldr(R, nmax); // each column is a session, row 1 is max dV

      ERR; // end "dVmax prices"
   }

   function (Cmax, R) = dVmaxX(C, dV, hf, t) { // prices at max dV rates
   /* Wed Feb  8 13:27:04 PST 2012.  Columns of returned Cmax contain 
      prices for the nmax highest dV rates of each session.  

      Returned R is a matrix of row numbers in vector dV.  R has nmax 
      columns, like Cmax, and has rows equal to the number of sessions
      (the last NADD rows are in the future).  

      Term R(k, m) contains the row number in vector dV corresponding 
      to column m of Cmax in session k.  See below, expressions like
         X = teeth(R[*, m], r)==0;
      for the way to turn column m of R into a rake of true flags that
      match the time (row number) when the mth max position occurred
      in each session. */

    { nmax = 5; // columns in returned Cmax and R
      n =daymodel.n; // number of rows for 24 hours
    } 
      ERRset("dVmax prices");

      r = rows(C);
      R = looking2(dV, fill(-INF, r, 1), hf); // -INF invalidates future

      X = Rmax((Rmax.nmax=nmax), R, n);
      R = foldr(X, nmax)';

      X = teeth(R[*, 1], r)==0;
      C1 = looking(C, X && hf);

      X = teeth(R[*, 2], r)==0;
      C2 = looking(C, X && hf);

      X = teeth(R[*, 3], r)==0;
      C3 = looking(C, X && hf);

      X = teeth(R[*, 4], r)==0;
      C4 = looking(C, X && hf);

      X = teeth(R[*, 5], r)==0;
      C5 = looking(C, X && hf);
    
      Cmax = parkn(C1, C2, C3, C4, C5, 5);

      C1 = C2 = C3 = C4 = C5 = X = 0;

      ERR; // end "dVmax prices"
   }

   function (D) = eighth_levels(H, L) { // a level every eighth
      N1 = (H + 7*L)/8;   // 1/8
      N2 = (H + 3*L)/4;   // 1-quarter price
      N3 = (3*H + 5*L)/8; // 3/8
      N4 = (H + L)/2;     // Middle price
      N5 = (5*H + 3*L)/8; // 5/8
      N6 = (3*H + L)/4;   // 3-quarter price
      N7 = (7*H + L)/8;   // 7/8

      D = pilen(L, N1, N2, N3, N4, N5, N6, N7, H, 9);
      N1 = N2 = N3 = N4 = N5 = N6 = N7 = 0;
   }

   function (D) = fifth_levels(H, L) { // a level every fifth
      D = parkn(
           L,
           (4*L +   H)/5, // 1-fifth
           (3*L + 2*H)/5, // 2-fifth
           (2*L + 3*H)/5, // 3-fifth
           (L   + 4*H)/5, // 4-fifth
           H,
         6);
   }

   inline: fbot (hB hS --- f) \ bottom pattern; utility for sigmodel
    \ Sun Aug 22 05:15:13 PDT 2010
    \ Incoming B and S are paired vectors from word weave.
      "S" book "B" book
      S B <
      S B =  1 lag and
      S B >= 2 lag and
      S B 2 lag = and (f1)
      B S <
      B S =  1 lag and
      B S >= 2 lag and
      B S 2 lag = and (f2)
      (f1 f2) or
      0 "B" book 0 "S" book
   end

   inline: ftop (hB hS --- f) \ top pattern; utility for sigmodel
    \ Sun Aug 22 05:18:18 PDT 2010
    \ Incoming B and S are paired vectors from word weave.
      "S" book "B" book
      S B >
      S B =  1 lag and
      S B <= 2 lag and
      S B 2 lag = and (f1)
      B S >
      B S =  1 lag and
      B S <= 2 lag and
      B S 2 lag = and (f2)
      (f1 f2) or
      0 "B" book 0 "S" book
   end

   inline: ftrue (hF r --- hF1) \ percentage in r steps that F is true
    \ Sat Apr 17 18:24:08 PDT 2010

    \ Each row in F is a step; assumes F has at least two rows.
    \ Incoming F(k) is true if it is not equal to zero.
    \ Returned F1 holds integer values ranging from 0 to 100 percent.

    \ Example: 
    \    list: 1 1 1 1 1 0 0 0 0 0 ; (hF) 5 ftrue .m

      over rows (Frows r) min "r" book
      (hF) 0<> abs (hF) dup push r 1- 1st 
      DO (hF1) peek (hF) I lag + LOOP (hF1)
      pull drop 100 r / * integer
   end

   function (Hg) = gH(M, tM, H, L) { // H goal to pull M above trace tM
   /* Note that M = (H + L)/2 (see daymodel()). */
      (x, y) = rake(H, (R=M<tM)); // y holds H when M<tM
      (X, Y) = rake(tM, R);       // Y holds tM when M<tM
      (X, z) = rake(L, R);        // z holds L when M<tM
      y = 2*Y - z;
      Hg = tier(x, y, R); // goal of high H to pull M up above tM
      x = y = z = R = X = Y = 0;
   }

   function (Lg) = gL(M, tM, H, L) { // L goal to pull M below trace tM
   /* Note that M = (H + L)/2 (see daymodel()). */
      (x, y) = rake(L, (R=M>tM)); // y holds L when M>tM
      (X, Y) = rake(tM, R);       // Y holds tM when M>tM
      (X, z) = rake(H, R);        // z holds H when M>tM
      y = 2*Y - z;
      Lg = tier(x, y, R); // goal of low L to pull M down below tM
      x = y = z = R = X = Y = 0;
   }

   inline: pt ( --- hA) \ session state transition probabilities 
{     Thu Jun 10 05:22:48 PDT 2010

      Create the matrix of state transition probabilities for the four
      trading states computed in word sigmodel().

      State transitions are for 24 hour steps from session to session.

      Matrix A is a Markov matrix as defined in Reference 7, 225.  Row 
      k of A contains the probabilities of transition from state k to 
      any other state, including k.  The probabilities in each row sum 
      to one.
 
      PT Examples:
   { 
         Each of these examples uses 60 24-hour trading sessions with 
         samples every 3 minutes, or about 28,800 time points per mar-
         ket.  At each time point, the change of state from the time
         point 24 hours earlier is used, so about 28,000 state transi-
         tions are counted.
         
         Note: These cases were run before sigmodel() was revised to
         swap states 1 and 2.  That change effectively swaps rows 1 and
         2 and columns 1 and 2 of these results.  For example, the fol-
         lowing shows EU after the revision (compare with EU Thu Jun 10
         10:04:48 PDT 2010 table below; values differ due to a shift of
         the window of 60 24-hour trading sessions to more recent data
         ending on Fri Jun 11 2010).

           % Mkt . sp date . nl pt .m nl
           EU Sun Jun 13 04:58:38 PDT 2010
            Row 1:   0.5926        0   0.4074        0
            Row 2:   0.6636        0   0.3364        0
            Row 3:        0   0.4857        0   0.5143
            Row 4:        0    0.721        0    0.279

         This is the state transition matrix made by averaging the 11 
         example markets shown below:

            Row 1:        0   0.5125   0.4875        0
            Row 2:        0   0.4869   0.5131        0
            Row 3:   0.4226        0        0   0.5774
            Row 4:   0.6139        0        0   0.3861

         States 1 and 2 involve short selling and appear nearly sym-
         metric (.5, .5) while states 3 and 4 involving long buying
         are much less symmetric.  Looking at individual examples be-
         low shows various symmetries, so perhaps an average matrix
         like the one above is of limited use.  The hope was that it
         would show symmetry with both terms in each row equal to 0.5, 
         because bear and bull markets would average out; and perhaps 
         that would be the case if more examples were used.

         Remember that a state transition is the change of state from 
         one session to the next, a separation of 24 hours, not the
         change from one step to the next (a step of only 3 minutes).

         When viewing curves, don't make the mistake of interpreting a 
         state transition as the color change from one step to the next,
         as from the color for state 2 to the color for state 1.  This
         is not a state transition (in fact, these matrices show zero
         probability for such a transition); a state transition is de-
         termined by the state now versus the state 24 hours ago, not
         the state 3 minutes ago.
   } {"
         To compute the average of these 11 examples, run
            "mobius.n" "PT Examples:" msource .m

         % Mkt . sp date . nl pt .m nl ...
         EU Thu Jun 10 10:04:48 PDT 2010
          Row 1:        0   0.6697   0.3303        0
          Row 2:        0   0.5908   0.4092        0
          Row 3:   0.5037        0        0   0.4963
          Row 4:   0.7565        0        0   0.2435
 
         % Mkt . sp date . nl pt .m nl ...
         SF Thu Jun 10 10:05:08 PDT 2010
          Row 1:        0   0.6749   0.3251        0
          Row 2:        0   0.5298   0.4702        0
          Row 3:    0.506        0        0    0.494
          Row 4:   0.6551        0        0   0.3449
 
         % Mkt . sp date . nl pt .m nl ...
         JY Thu Jun 10 10:05:21 PDT 2010
          Row 1:        0   0.5394   0.4606        0
          Row 2:        0    0.432    0.568        0
          Row 3:   0.4873        0        0   0.5127
          Row 4:   0.5635        0        0   0.4365
 
         % Mkt . sp date . nl pt .m nl ...
         CL Thu Jun 10 10:04:05 PDT 2010
          Row 1:        0     0.57     0.43        0
          Row 2:        0   0.5219   0.4781        0
          Row 3:    0.518        0        0    0.482
          Row 4:   0.4778        0        0   0.5222
 
         % Mkt . sp date . nl pt .m nl ...
         HG Thu Jun 10 10:05:44 PDT 2010
          Row 1:        0   0.5077   0.4923        0
          Row 2:        0   0.5462   0.4538        0
          Row 3:   0.5018        0        0   0.4982
          Row 4:   0.5707        0        0   0.4293
 
         % Mkt . sp date . nl pt .m nl ...
         GC Thu Jun 10 10:06:07 PDT 2010
          Row 1:        0   0.3528   0.6472        0
          Row 2:        0   0.5868   0.4132        0
          Row 3:   0.2442        0        0   0.7558
          Row 4:   0.4908        0        0   0.5092
 
         % Mkt . sp date . nl pt .m nl ...
         DJ Thu Jun 10 10:06:28 PDT 2010
          Row 1:        0   0.4016   0.5984        0
          Row 2:        0   0.4304   0.5696        0
          Row 3:    0.419        0        0    0.581
          Row 4:    0.651        0        0    0.349
 
         % Mkt . sp date . nl pt .m nl ...
         SP Thu Jun 10 10:06:57 PDT 2010
          Row 1:        0    0.463    0.537        0
          Row 2:        0   0.3919   0.6081        0
          Row 3:   0.3875        0        0   0.6125
          Row 4:   0.6846        0        0   0.3154
 
         % Mkt . sp date . nl pt .m nl ...
         NQ Thu Jun 10 10:07:12 PDT 2010
          Row 1:        0   0.4542   0.5458        0
          Row 2:        0   0.4739   0.5261        0
          Row 3:   0.4003        0        0   0.5997
          Row 4:   0.6608        0        0   0.3392
 
         % Mkt . sp date . nl pt .m nl ...
         US Thu Jun 10 10:07:26 PDT 2010
          Row 1:        0   0.5033   0.4967        0
          Row 2:        0   0.4767   0.5233        0
          Row 3:   0.3292        0        0   0.6708
          Row 4:   0.6031        0        0   0.3969
 
         % Mkt . sp date . nl pt .m nl ...
         TN Thu Jun 10 10:07:40 PDT 2010
          Row 1:        0   0.5009   0.4991        0
          Row 2:        0   0.3754   0.6246        0
          Row 3:   0.3514        0        0   0.6486
          Row 4:   0.6394        0        0   0.3606

   "} (hT) push
      peek dup "Row 1:" grepr reach numerate 11 matrix totals 11 / bend
      peek dup "Row 2:" grepr reach numerate 11 matrix totals 11 / bend
      peek dup "Row 3:" grepr reach numerate 11 matrix totals 11 / bend
      peek dup "Row 4:" grepr reach numerate 11 matrix totals 11 / bend
      4 pilen pull (hT) drop
      halt
}
      24 pt1
   end

   inline: pt. ( --- ) \ display session state transition probabilities
      "              State transition matrix"
      "from  to:" "echo1 echo2 echo3 echo4" words pile \ states from
      " lima1    lima2    lima3    lima4"              \ states to
      pt 100 * 0.5 + integer itext -4 indent           \ compute, format
      pile park pile . nl                              \ display
   end

   inline: pt1 (nH --- hA) \ state transition probabilities for step H 
{     Thu Jun 10 06:27:21 PDT 2010

      Create the matrix of state transition probabilities for the four
      trading states computed in word sigmodel().

      State transitions are for step H (hours).

      Matrix A is a Markov matrix as defined in Reference 7, 227.  Row 
      k of A contains the probabilities of transition from state k to 
      any other state, including k.  The probabilities in each row sum 
      to one.
}
      (nH) rdech "m" book

      xbase push 1based

    \ Due to future data, the last row is later than now.  Use the row
    \ for time now from word rnow to define the current row, RNOW:
      "t" main time rnow (nrow) "RNOW" book \ row for time now

    \ States from sigmodel():
      "sigmodel" "ST" yank 1st RNOW items reach "ST" book \ current
      ST m lag "RT" book \ previous

      4 1
      DO RT I = push
         list: 4 1
            DO ST I = peek (ST RT) and totals @ LOOP pull drop
         end
      LOOP 4 parkn abs (hA') \ each column is a previous state
      bend (hA) \ transpose A' so each row corresponds to a prev state

    \ Normalize the rows of A so they sum to 1:
      (hA) dup across 4 clone /by

      0 "ST" book
      0 "RT" book
      pull indexbase
   end

   function (D) = quarter_levels(H, L) { // a level every quarter
      N2 = (H + 3*L)/4; // 1-quarter price (two eighths)
      N4 = (H + L)/2;   // Middle price (four eighths)
      N6 = (3*H + L)/4; // 3-quarter price (six eighths)

      D = pilen(L, N2, N4, N6, H, 5);
      N2 = N4 = N6 = 0;
   }

   function (D) = quartiles(P) { 
      C = colsort(P')';
      D = parkn(C[*, 1], median(C), C[*, cols(C)], 3);
   }

   function (R) = rbuy(F1, F2) { // region of covert buying
   /* Thu Oct 27 16:09:40 PDT 2011 */

      R = (region(F1, F2, F2<F1), drop());
   }

   function (R1, R2) = rmodel(L, H, n) { // region positions
   /* Wed Oct 26 19:11:42 PDT 2011 */

      R1 = weave1(    L,           H);
      R2 = weave1(lag(L, n),   lag(H, n));
   }

   function (R) = rsel(F1, F2) { // region of covert selling
   /* Thu Oct 27 16:14:45 PDT 2011 */

      R = (region(F1, F2, F2>F1), drop());
   }
   function (f) = separate(X, Y) { // true when X and Y become separate
   // Also see word crossover1().
      f1 = X==Y;
      f2 = X!=Y;
      f = (f2 && lag(f1, 1));
      f1 = f2 = 0;
   }

   inline: tDUMP ( --- htE) \ machine times for dump envelope
    \ Tue Aug 24 20:42:37 PDT 2010
      [ list: .S1 ; "R" book ]
      "P" main dup R catch (hE) swap .C catch
      "t" main tm (hE hC htm) tE1 (htE)
   end

   inline: tPUMP ( --- htE) \ machine times for pump envelope
    \ Tue Aug 24 20:47:45 PDT 2010
      [ list: .B1 ; "R" book ]
      "tDUMP" "R" yank push
      R "tDUMP" "R" bank 

      tDUMP (htE)

      pull "tDUMP" "R" bank
   end

#def tE 

   inline: tE (hE hC htm --- htE) \ times envelopes of E pushed by C
{    Tue Aug 24 13:31:29 PDT 2010

      Find machine times when one or more of the envelope curves in 
      E is equal to price C.

      This word is complicated because the row count of E and C can
      be different from the row count of t when this word is run by 
      sigmodel() (see call to sigmodel() in coladd(), file mfil.v).

      This word is also used in file mrtsig.n.
}
      (hE hC ht) over rows (Crows) push
      (hE hC ht) dup rows (trows) push
      (hE hC ht) rev (htE hE hC)
      (hE hC) over cols clone = across 0<> (f)
      (f) pull (trows) over rows - 1 null swap pile 
      (htE f) *by pull (Crows) endmost abs (htE)
   end

#end tE 

   inline: tE1 (hE hC htm --- htE1) \ tE times filtered
    \ Tue Aug 24 20:42:37 PDT 2010
      [ 901 "SEC" book ]

      tE (htE)

    \ If using daysget(), remove future rows from tE:
      "daysget" exists?
      IF (htE) 1st "daysget" "tnow" yank items reach THEN (htE)

    \ Remove zero values:
      (htE) dup rake lop (htE)

      (htE) SEC 0>
      IF \ remove the older of two times less than SEC seconds apart:
         (htE) "tE" book
         list: tE dup rows pry (t2) \ latest time
            1st tE rows 1-          \ loop backward from latest
            DO (t2) tE I pry (t2 t1) 2dup - SEC <
               IF (t2 t1) drop THEN
            LOOP
         end reversed (htE)
         0 "tE" book
      THEN
   end

   function (P) = trend1(U, m, T, n, C) { // uptrend or downtrend
   /* Returned P skims above U in an uptrend and below U in a downtrend,
      switching sides when faster trace T crosses slower trace U.

      Incoming trace T is a fast trace of incoming C:
         T(k) = a1*T(k-1) + b1*C(k)

      Incoming trace U is a slow trace of incoming T:
         U(k) = a2*U(k-1) + b2*T(k)
              = a2*U(k-1) + b2*a1*T(k-1) + b2*b1*C(k)

      Return P(k) equal to C(k) that causes T(k) - U(k) = 0:
         P(k) = (a2*U(k-1) + (b2*a1 - a1)*T(k-1))/(b1-b2*b1)

      or more simply, since U(k) is already defined:
         P(k) = (U(k) - a1*T(k-1))/b1
   */
      { h = 1; /* lag */ }

      if(m < n) (<< " trend1: m must be greater than n" . nl HALT >>);

      b1 = 1/(n+1);
      a1 = n*b1;
/*
      b2 = 1/(m+1);
      a2 = m*b2;
      P = (a2*lag(U, h) + (b2*a1-a1)*lag(T, h))/(b1-b2*b1);
*/
      P = (U - a1*lag(T, h))/b1;

   /* P moves wildly up and down.  Constrain (clip) P to within gap s
      of U: */
      s = @vgap1(Mkt);
      P = max(min(P, (1+s)*U), (1-s)*U);
   }

   function (V) = trstate(Pt) { // voice for trace state
   /* Incoming Pt is a row vector of the model at the current time.

      Find the region that the price is in, and return the voice
      string for it. 

      Voice indices r follow the order of names in signal():
         r = 1, 2, 3: echo1, echo2, echo3
         r = 4, 5, 6: lima1, lima2, lima3
   */
      P = @Pt[1, .C]; // current price

      IF(P>@Pt[1, .TM]); // above median?

         X = @Pt[1, .TB2]; 
         IF(P>X);
            V = "+lima3";
            r = 6;
         ELSE
            X = @Pt[1, .TB1]; 
            IF(P>X);
               V = "+lima2";
               r = 5;
            ELSE
               V = "+lima1";
               r = 4;
            THEN
         THEN

      ELSE

         X = @Pt[1, .TS2];
         IF(P<X);
            V = "+echo1"; 
            r = 1;
         ELSE
            X = @Pt[1, .TS1];
            IF(P<X);
               V = "+echo2"; 
               r = 2;
            ELSE
               V = "+echo3"; 
               r = 3;
            THEN
         THEN

      THEN;
   }

   inline: ut ( --- hA) \ 24-hour prob of transition matrix elements
    \ Sun Jun 13 06:41:38 PDT 2010
    \ Displaying UT states transition matrix for 24-hour lag.
    \ See sigmodel().

      xbase push 1based

    \ Due to future data, the last row is later than now.  Use the row
    \ for time now from word rnow to define the current row, RNOW:
      "t" main time rnow (nrow) "RNOW" book \ row for time now

    \ States from sigmodel():
      "sigmodel" "UT" yank 1st RNOW items reach "UT" book \ current
      "sigmodel" "m" yank "m" book

      UT m lag "RT" book \ previous step

      8 1
      DO RT I = push
         list: 8 1
            DO UT I = peek (UT RT) and totals @ LOOP pull drop
         end abs (hC)
      LOOP 8 parkn (hA') \ each column is a previous state
      bend (hA) \ transpose A' so each row corresponds to a prev state

    \ Normalize the rows of A so they sum to 1:
      100 * 0.5 + integer
      (hA) dup across 8 clone /by
      100 * 0.5 + integer

      0 "UT" book
      0 "RT" book
      pull indexbase
   end

   inline: ut. ( --- ) \ display state transition element probabilities
{

      Example (EU):
      [tops@plunger] ready > ut.

                       Element transition matrix
      54        0        0        0       46        0        0        0
      68        0        0        0       32        0        0        0
       0       69        0        0        0       31        0        0
       0       63        0        0        0       37        0        0
       0        0       52        0        0        0       48        0
       0        0       40        0        0        0       60        0
       0        0        0       72        0        0        0       28
       0        0        0       71        0        0        0       29
}
      ut itext (hT)
      "Element transition matrix" over cols center . nl
      (hT) . nl
   end

   inline: ut1 ( --- hA) \ one-step prob of transition matrix elements
    \ Fri Jun 11 13:15:02 PDT 2010
    \ Displaying UT states transition matrix for one-step lag.
    \ See sigmodel().

    \ Diagonal terms are removed and the three largest terms in each
    \ row are displayed.

      xbase push 1based

    \ Due to future data, the last row is later than now.  Use the row
    \ for time now from word rnow to define the current row, RNOW:
      "t" main time rnow (nrow) "RNOW" book \ row for time now

    \ States from sigmodel():
      "sigmodel" "UT" yank 1st RNOW items reach "UT" book \ current
      1 "m" book
      UT m lag "RT" book \ previous

      8 1
      DO RT I = push
         list: 8 1
            DO UT I = peek (UT RT) and totals @ LOOP pull drop
         end abs (hC)
 
         (hC) 0 over I poke \ zero the Ith term (the diagonal to be)
 
       \ Keep the three largest terms and zero the rest:
         (hC) 1st over rows items park (hD) no sort
         (hD) dup 1st catch 1st 3 items reach 5 1 null pile (hD1)
         (hD hD1) swap 2nd catch (hR)
         (hR) 1st over rows items park yes sort 2nd catch (hR)
         (hD hR) reach (hC)
 
      LOOP 8 parkn (hA') \ each column is a previous state
      bend (hA) \ transpose A' so each row corresponds to a prev state

    \ Normalize the rows of A so they sum to 1:
      100 * 0.5 + integer
      (hA) dup across 8 clone /by
      100 * 0.5 + integer

      0 "UT" book
      0 "RT" book
      pull indexbase
   end

   inline: ut_check ( --- ) \ check states UT in model matrix P
{     Sun Jun 13 06:58:44 PDT 2010 Revise for reversed states 1 and 2
      Sat Jun 12 15:38:13 PDT 2010

      Testing the model created by sigmodel().

      For UT states mapped to price C, test which curves are above or 
      below P1, and which curves are above or below P2.

      Run this at the % prompt of an electronic market console tied to
      a particular market.

      The conditions displayed in the following example are the same 
      for all markets.

      Example:
          % ut_check
          UT check for EU Sun Jun 13 07:32:56 PDT 2010
          Testing C vs. P1:
           1 P11: C is always below P1
           2 P21: C is always below P1
           3 P32: C is always below P1
           4 P42: C is always below P1
           5 P13: C is always above P1
           6 P23: C is always above P1
           7 P34: C is always above P1
           8 P44: C is always above P1
          Testing P1 vs. P2:
           1 P11: P1 is always below P2
           2 P21: P1 is always below P2
           3 P32: P1 is always above P2
           4 P42: P1 is always above P2
           5 P13: P1 is always below P2
           6 P23: P1 is always below P2
           7 P34: P1 is always above P2
           8 P44: P1 is always above P2
          Testing lagged P1 vs. lagged P2:
           1 P11: P1 is always below P2
           2 P21: P1 is always above P2
           3 P32: P1 is always below P2
           4 P42: P1 is always above P2
           5 P13: P1 is always below P2
           6 P23: P1 is always above P2
           7 P34: P1 is always below P2
           8 P44: P1 is always above P2
          %

          From the data above, we can make the following table, where
          0 means always below and 1 means always above:

            UT   Term         Conditions         Decimal
           State       C vs.  P1 vs.  lagged(P1  
                        P1      P2     vs. P2)
             1   P11     0       0       0          0     
             2   P21     0       0       1          1
             3   P32     0       1       0          2
             4   P42     0       1       1          3
             5   P13     1       0       0          4
             6   P23     1       0       1          5
             7   P34     1       1       0          6
             8   P44     1       1       1          7

          The set of binary conditions for each UT state is equivalent
          to a unique decimal, showing that each state is unique.
}
      [ "'P' main" "P" macro ]

      "UT check for " Mkt + spaced date + . nl

      "sigmodel" "UT" yank "UT" book
      "sigmodel" "m" yank "m" book

      P .C catch "C" book
      P .P1 catch "P1" book
      P .P2 catch "P2" book

      "Testing C vs. P1:" . nl

      C UT 1 = rake lop P1 UT 1 = rake lop > totals @ 0=
      IF " 1 P11: C is always below P1" ELSE " 1 P11: error" THEN . nl

      C UT 2 = rake lop P1 UT 2 = rake lop > totals @ 0=
      IF " 2 P21: C is always below P1" ELSE " 2 P21: error" THEN . nl

      C UT 3 = rake lop P1 UT 3 = rake lop > totals @ 0=
      IF " 3 P32: C is always below P1" ELSE " 3 P32: error" THEN . nl

      C UT 4 = rake lop P1 UT 4 = rake lop > totals @ 0=
      IF " 4 P42: C is always below P1" ELSE " 4 P42: error" THEN . nl

      C UT 5 = rake lop P1 UT 5 = rake lop < totals @ 0=
      IF " 5 P13: C is always above P1" ELSE " 5 P13: error" THEN . nl

      C UT 6 = rake lop P1 UT 6 = rake lop < totals @ 0=
      IF " 6 P23: C is always above P1" ELSE " 6 P23: error" THEN . nl

      C UT 7 = rake lop P1 UT 7 = rake lop < totals @ 0=
      IF " 7 P34: C is always above P1" ELSE " 7 P34: error" THEN . nl

      C UT 8 = rake lop P1 UT 8 = rake lop < totals @ 0=
      IF " 8 P44: C is always above P1" ELSE " 8 P44: error" THEN . nl

      "Testing P1 vs. P2:" . nl

      P1 UT 1 = rake lop P2 UT 1 = rake lop > totals @ 0=
      IF " 1 P11: P1 is always below P2" ELSE " 1 P11: error" THEN . nl

      P1 UT 2 = rake lop P2 UT 2 = rake lop > totals @ 0=
      IF " 2 P21: P1 is always below P2" ELSE " 2 P21: error" THEN . nl

      P1 UT 3 = rake lop P2 UT 3 = rake lop < totals @ 0=
      IF " 3 P32: P1 is always above P2" ELSE " 3 P32: error" THEN . nl

      P1 UT 4 = rake lop P2 UT 4 = rake lop < totals @ 0=
      IF " 4 P42: P1 is always above P2" ELSE " 4 P42: error" THEN . nl

      P1 UT 5 = rake lop P2 UT 5 = rake lop > totals @ 0=
      IF " 5 P13: P1 is always below P2" ELSE " 5 P13: error" THEN . nl
      
      P1 UT 6 = rake lop P2 UT 6 = rake lop > totals @ 0=
      IF " 6 P23: P1 is always below P2" ELSE " 6 P23: error" THEN . nl
      
      P1 UT 7 = rake lop P2 UT 7 = rake lop < totals @ 0=
      IF " 7 P34: P1 is always above P2" ELSE " 7 P34: error" THEN . nl
      
      P1 UT 8 = rake lop P2 UT 8 = rake lop < totals @ 0=
      IF " 8 P44: P1 is always above P2" ELSE " 8 P44: error" THEN . nl

      "Testing lagged P1 vs. lagged P2:" . nl
      P1 m lag "P1" book
      P2 m lag "P2" book

      P1 UT 1 = rake lop P2 UT 1 = rake lop > totals @ 0=
      IF " 1 P11: P1 is always below P2" ELSE " 1 P11: error" THEN . nl

      P1 UT 2 = rake lop P2 UT 2 = rake lop < totals @ 0=
      IF " 2 P21: P1 is always above P2" ELSE " 2 P21: error" THEN . nl

      P1 UT 3 = rake lop P2 UT 3 = rake lop > totals @ 0=
      IF " 3 P32: P1 is always below P2" ELSE " 3 P32: error" THEN . nl

      P1 UT 4 = rake lop P2 UT 4 = rake lop < totals @ 0=
      IF " 4 P42: P1 is always above P2" ELSE " 4 P42: error" THEN . nl

      P1 UT 5 = rake lop P2 UT 5 = rake lop > totals @ 0=
      IF " 5 P13: P1 is always below P2" ELSE " 5 P13: error" THEN . nl

      P1 UT 6 = rake lop P2 UT 6 = rake lop < totals @ 0=
      IF " 6 P23: P1 is always above P2" ELSE " 6 P23: error" THEN . nl

      P1 UT 7 = rake lop P2 UT 7 = rake lop > totals @ 0=
      IF " 7 P34: P1 is always below P2" ELSE " 7 P34: error" THEN . nl

      P1 UT 8 = rake lop P2 UT 8 = rake lop < totals @ 0=
      IF " 8 P44: P1 is always above P2" ELSE " 7 P44: error" THEN . nl

      0 "UT" book 0 "C" book 0 "P1" book 0 "P2" book
   end

   function (V) = vcomp(Pt) { // voice for compression
   /* Incoming Pt is a matrix of the model for a set of the most
      recent times.

      Compression is defined as periods when price is both above tP2
      below tP1.  Curve tG defines such periods when it is within tP1
      and tP2.

      If there are any instances of compression in the period defined
      by the number of rows in Pt, return the voice string; otherwise, 
      return an empty string. */

      f = Pt[*, .C]==Pt[*, .tG];
      if(@totals(f)) V = "+compression"; else V = "";
      f = purged;
   }

   inline: Vdisp_( --- ) \ display latest volume data
    \ Mon Jan 30 05:33:04 PST 2012

    \ If the console text window or graphics window has focus, Shift+Q
    \ will dismiss this window.

      [ 
      \ When running replay, the N sessions displayed are relative to
      \ the time of replay, not the latest time (a good thing):
        10 "N" book \ number of sessions

        "| | | | | V Vchg R1 R2 R3 R4 VO ||Last" 
        "COL-TITLES" book
        "| " COL-TITLES words rows cats "BLANKLINE" book \ for neat cols

        ftempsys "FNAME" book \ file in /tmp to display the data
        FNAME deleteif \ delete the 0 byte file just made by ftempsys()
        FNAME "FILE" book

        0 "Vnow" book 0 "VOnow" book

      \ It is ok to delete FILE while it is being viewed, to reduce
      \ clutter in /tmp.  FILE will eventually be deleted on program
      \ exit anyway by tmpclean(), so this is just for the fun of it,
      \ to see if it can be done (and it can):
        "FILE deleteif" "DELETE" macro \ run below on an ALARM

        "'P' main" "Pt" macro

        "(hR nCmax dC --- hH hB) push push dup rows ones 0 pile (hV) " 
        "swap (hR) pull pile (hC) pull (dC) histogram " +
        "(hH) dup 2nd catch (hH) swap 1st catch (hB)" +
        "HIST" macro

      {" CHTIME ( --- hT) \ session start times for "n foldr" columns
        "t" main tm n foldr 1st reach bend chtime (hT)
        dup rows columnofints spaced swap park (hT)
        "_CHTIME" naming
      "} "CHTIME" macro

      {" CHHOURS ( --- hT) \ session times for "n foldr" columns
        "t" main tm n foldr 1st catch chtime (hT)
        dup rows columnofints spaced swap park (hT)
        "_CHHOURS" naming
      "} "CHHOURS" macro

      ]
      " Vdisp: not set up for this model" . nl return

" Top of Vdisp" . nl

      "daymodel" "n" yank "n" book
      "daysget" "NADD" yank "NADD" book

"HALTING" . nl HALT


      Pt .VO catch 
      Pt .V catch
      Pt .dV catch 3 parkn
CHTIME CHHOURS "HALTING" . nl HALT

      Pt .VO catch (hR) n foldr 
      Pt .V catch (hR) n foldr 

\     (hI) 1st over cols items bend swap pile itext 
\     0 over rows items itext swap park

      "daymodel" "n" yank "n" book
      "daymodel" "T2" yank "T2" book
      T2 2nd catch maxfetch 2drop "rows_h" book
      "daysget" "NADD" yank "NADD" book

      Pt .R catch (hR) n foldr 1st over cols NADD 1+ - items catch (hT)
      (hT) "T" book \ matrix of powers of two; each col is a session

      T 1st catch rows_h HIST "B" book (hH) T cols 2nd

      DO T I catch rows_h HIST drop LOOP
      T cols parkn across "T" book


      n N * \ rows for the last N sessions
      "daysget" "tnow" yank dup "tnow" book
      over - 1+ swap items reversed "R" book

      Pt .G4 catch (hG) 
      (hG) R over (hG) 0<> R (f hR) reach (hR f) rake lop (hG hR)
      (hG hR) dup "R" book 
      (hG hR) reach (hG) long (hG) push

      Pt .V catch dup tnow pry "Vnow" book R reach (hV)
      (dV) dup reversed delta reversed 0 max (hVchg)

      peek (hG) 1 long and 0<> abs (hR1)
      peek (hG) 2 long and 0<> abs (hR2)
      peek (hG) 4 long and 0<> abs (hR3)
      pull (hG) 8 long and 0<> abs (hR4)
  
      Pt .VO catch dup tnow pry "VOnow" book R reach (hVO)

      (hV hVchg hR1 hR2 hR3 hR4 hVO) 
      7 parkn itext (hT2)

    \ ----------------------- Boiler Plate -----------------------------

      (hT2)

    \ Add last price to rightmost T2:
      (hT2) Pt .C catch R reach Mkt prices Mkt n>q "||" nose (hC)
      (hT2 hC) park (hT2)

    \ Assumes machine local gives Pacific time; chtime gives Central:
      "t" main (tg) R reach tm chtime \ time string
      (hT1) 1 24 crop (hT1)           \ crop to size
      (ht) ":00 " " " strp (hT1)      \ remove seconds

      (hT1) chop "|| " tail (hT1)

      (hT2 hT1) swap park (hT)

      BLANKLINE COL-TITLES BLANKLINE 3 pilen (hH)
      (hH) swap (hH hT) pile (hT)

      (hT) neat "|" " " strp (hT)

      "Vdisp snapshot " time chtime + (qS1)
      "Volume " Mkt + (qS2)
      Vnow " V: %0.0f " format + VOnow " VO: %0.0f " format + (qS2)
      (qS1 qS2) pile (hHeader)

      (hT hHeader) swap pile 

    \ Save FILE and view it in vi:
      FNAME "_" + Mkt + "FILE" book \ augment FNAME with Mkt
      (hT) FILE save
      " -R " FILE + (qS) \ vi read-only mode

    \ Save string for Shift+Q to kill the vi window (see "Q" in auto()):
      (qS) dup "vi" nose "pid_name" book \ string in pidtable to kill

      (qS) _vi \ run vi in read-only mode

    \ FILE being viewed will be deleted in 20 seconds, but that's ok:
      20 (sec) "Vdisp" "DELETE" localref (d qW) ALARM

      0 "R" book 
   end

   inline: Vdisp1 ( --- ) \ display latest volume data
    \ Mon Jan 16 16:18:52 PST 2012

    \ Results are displayed latest first.

      [
      \ When running replay, the N sessions displayed are relative to
      \ the time of replay, not the latest time (a good thing):
        30 "N" book \ number of sessions

        "| | | | | Vol dV dV1 dV2 dV3 dV4 ||Last" "COL-TITLES" book
        "| " COL-TITLES words rows cats "BLANKLINE" book \ for neat cols

        ftempsys "FNAME" book \ file in /tmp to display the data
        FNAME deleteif \ delete the 0 byte file just made by ftempsys()
        FNAME "FILE" book

      \ It is ok to delete FILE while it is being viewed, to reduce
      \ clutter in /tmp.  FILE will eventually be deleted on program
      \ exit anyway by tmpclean(), so this is just for the fun of it,
      \ to see if it can be done (and it can):
        "FILE deleteif" "DELETE" macro \ run below on an ALARM

        "'P' main" "Pt" macro
      ]
      "daymodel" "n" yank "n" book \ rows per session

      n N * \ rows for the last N sessions
      "daysget" "tnow" yank dup "rn" book
      n + \ rn plus n future rows
      over - 1+ swap items "R" book

      R Pt .SV catch (hSV)                        \ high volume rows

 \ The following is wrong during replay; could generate vector with
 \ info from NSESS, but just take it out for now:
 \    (hSV) "daysget" "rSESS" yank -1 lag +       \ plus sess end rows

      (hSV) true over rn (-1 hSV rn) poke (hSV)   \ plus latest row
      (hSV) 1st rn items reach dup n endmost pile \ plus 1 future sess
      dup "SV" book (hR hSV)                  
      (hR hSV) over reach rake lop (hR) "R" book 

      "Max traffic volume data for " Mkt + (hHeader)

    \ Assumes tm is Pacific time; add 2 hours for Central:
      "t" main tm 7200 + (ht) ctime (hT1) R reach (hT1)
      (hT1) 1 24 crop (hT1)      \ crop to size
      (hT1) "P" "C" strp         \ Pacific to Central
      (ht) ":00 " " " strp (hT1) \ remove seconds

      Pt .VO catch (hVol) 
      (hVol) 1st rn items reach n 1 null pile (hVol) \ one future sess
      Pt .dV catch (hdV) 
      (hdV) 1st rn items reach n 1 null pile (hdV) \ one future session
      (hdV) dup 0> (f) SV and (f) 
      (hdV f) "daysfill" "hs" localrun (hs)
      (hs) 1st rn items reach n 1 null pile (hs) \ one future session
      (hdV f hs) and (hdV f) looking (hdV)
      (hdV) 1st rn items reach n 1 null pile \ one future session
      (hVol hdV) dup push

      peek n lag peek n 2 * lag peek n 3 * lag pull n 4 * lag

      (hVol hdV hdV1 hdV2 hdV3 hdV4) 6 parkn R reach itext1 (hT2)

    \ This is dV as percentage of V, and is no longer computed:
    \ dup 10000 * 2 pick (hdV*10000 hVol) /by 0.5 + integer (hdV%)
    \ (hVol hdV hdV%) 3 parkn R reach itext1 (hT2)

    \ Add last price to rightmost T2:
      (hT2) Pt .C catch R reach Mkt prices Mkt n>q "||" nose (hC)
      (hT2 hC) park (hT2)

      (hT1 hT2) park reversed (hT)

      BLANKLINE COL-TITLES BLANKLINE 3 pilen (hH)
      (hH) swap (hH hT) pile (hT)

      (hT) neat "|" " " strp (hHeader hT) pile

    \ Save FILE and view it in vi:
      FNAME "_" + Mkt + "FILE" book \ augment FNAME with Mkt
      (hT) FILE save
      " -R " FILE + _vi \ run vi in read-only mode

    \ FILE being viewed will be deleted in 20 seconds, but that's ok:
      20 (sec) "Vdisp" "DELETE" localref (d qW) ALARM

      0 "SV" book 0 "R" book
   end

   inline: Vdisp2 ( --- ) \ display latest volume data
    \ Wed Dec 14 20:49:40 PST 2011

    \ Results are displayed latest first.

    \ Warning: Macro STATS in this word clears the stack.  It has none
    \ of the safeguards that function() gives infix functions to make
    \ them stack friendly.  It would be a better idea to write STATS
    \ as a function that takes Pt as input and returns all the vari-
    \ ables, and by the same token, it is a bad idea to write macros
    \ in infix because they clear the stack.

      [ 
      \ When running replay, the N sessions displayed are relative to 
      \ the time of replay, not the latest time:
        10 "N" book \ number of sessions

      \ Warning: if N is too large, RMAX rows can be distorted toward
      \ high volumes that occurred in the too-distant past:
        20 "RMAX" book \ number of max rows to display

        ftempsys "FNAME" book \ file in /tmp to display the data
        FNAME deleteif \ delete the 0 byte file just made by ftempsys()
        FNAME "FILE" book

        "| " 15 cats "BLANKLINE" book \ for neat with 15 items in table

      \ It is ok to delete FILE while it is being viewed, to reduce 
      \ clutter in /tmp.  FILE will eventually be deleted on program
      \ exit anyway by tmpclean(), so this was just for the fun of it,
      \ to see if it could be done:
        "FILE deleteif" "DELETE" macro \ run below on an ALARM

        "'P' main" "Pt" macro

    \ Compute and display the data computed in daysfill() by these
    \ expressions (modified slightly for this word):
      {"

      dV = Pt[*, .dV]; // traffic
      v = vstats(Mkt); // constants for Mkt statistics
      X = mstats(dV, @rdech(v[4])); // no lag
      M = X[*, 2];       // mean
      S = sqrt(X[*, 4]); // standard deviation
      f3 = dV > (V3 = M + @v[3]*S);
      f2 = dV > (V2 = M + @v[2]*S) && (X=f3==0);
      f1 = dV > (V1 = M + @v[1]*S) && X && f2==0;

      dM = ma(dV, @rdech(v[5])) - M;

      V = X = S = 0;

      "} parse "STATS" macro 
      ]
      FNAME "_" + Mkt + "FILE" book \ augment FNAME with Mkt

      STATS \ compute variables to display

      "Volume data for " Mkt + ", vstats = " + 
      Mkt vstats "%0.1f" format vol2str + (hHeader)

      depth push
      dV M dM V1 V2 V3 f1 f2 f3
      depth pull - parkn (hA)
      f1 f2 + f3 + "F" book \ high volume rows

    \ Eliminate large memory:
      0 "dV" book 0 "v" book 0 "M" book 
      0 "V1" book 0 "V2" book 0 "V3" book
      0 "f1" book 0 "f2" book 0 "f3" book 
      0 "dM" book 

      "daymodel" "n" yank N * \ rows for the last N sessions
      "daysget" "tnow" yank over - 1+ swap items "R" book

      R F R reach rake lop "R" book \ limit to high volume rows
      0 "F" book

    \ Assumes tm is Pacific time; add 2 hours for Central:
      "t" main tm 7200 + (ht) ctime (hT1) R reach (hT1)
      (hT1) 1 24 crop (hT1)      \ crop to size
      (hT1) "P" "C" strp         \ Pacific to Central
      (ht) ":00 " " " strp (hT1) \ remove seconds

      (hA hT1) swap (hA) R reach (hA) itext1 (hT2)

    \ Sun Dec 18 19:26:52 PST 2011.  Add last price to rightmost T2:
      (hT2) Pt .C catch R reach Mkt prices Mkt n>q (hC) park (hT2)

      (hT1 hT2) park reversed (hT)

    \ Wed Jan  4 19:00:53 PST 2012.  Add a list of RMAX rows that have
    \ the highest dV:
      (hT) dup 6 ndx word drop numerate (hdV) 
      (hdV) 1st over rows items park false sort 2nd catch

      (hRows) 1st over rows RMAX min items reach yes sort (hR)

      (hT hR) over swap reach (hT hTmax) \ max rows are in time order
      (hTmax) BLANKLINE dup 3 pilen swap
      (hTmax hT) pile (hT)

      BLANKLINE
      "| | | | | dV M dM M+s1 M+s2 M+s3 f1 f2 f3 Last" 
      BLANKLINE 3 pilen (hH)
      (hH) swap (hH hT) pile (hT)

      (hT) neat "|" " " strp (hHeader hT) pile (hT) push

      "Highest " RMAX intstr + " dV (in time order):" + (qS)
      (qS) peek 4 ndx said 
      "All f1, f2, f3:" peek 4 RMAX + 2 + ndx said
      pull

    \ Save FILE and view it in vi:
      (hT) FILE save 
      " -R " FILE + _vi \ run vi in read-only mode

    \ FILE being viewed will be deleted in 20 seconds, but that's ok:
      20 (sec) "Vdisp" "DELETE" localref (d qW) ALARM

      0 "R" book 
   end

   function (V) = vfifth(Pt) { // voice for price fifth
   /* Incoming Pt is a row vector of the model at the current time.

      Find which fifth the price is in and return the voice name. */

      P = @Pt[1, .C]; // current price

      if(P>=@Pt[1, .F4]) return("+dot5");
      if(P>=@Pt[1, .F3]) return("+dot4");
      if(P>=@Pt[1, .F2]) return("+dot3");
      if(P>=@Pt[1, .F1]) return("+dot2");
                         return("+dot1");
   }

   inline: vgap1 (qN --- hG) \ return volatility gaps for market N
\     Return column G containing data specified for string N.

\     Note: this word serves as a template for any function that does a
\     binary search table lookup on string N.  Require chars(N) < 9.

      [ 1 "Vals" book \ values for each string N

        {" Table of each N string followed by Vals values:

         \ Table of gaps:
         \    g1: fraction for sigmodel(), model 2010Nov03

         \ N    g1 
           eu   .005 
           sf   .005 
           jy   .005

           dj   .005
           sp   .005
           nq   .005

           us   .002 
           tn   .002

           cl   .005
           gc   .005
           hg   .005

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) Vals 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having Vals rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd Vals items reach mat2vol numerate Vals foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vgap1" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vgap1" "S" yank 2nd catch .m
      }
      ]
      (qN) "N" book

      S N lowercase 8 blpad str2num (n)   \ turn N string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G

      ELSE (r) drop " vgap1 hal" "ting: no data for " + N + . nl HALT

    \ Alternate ELSE to return default when no data for N:
    \ ELSE (r) drop 10 G rows 1 fill (hG)

      THEN (hG) 
   end

   inline: vnum (qM --- n) \ return number for market M
    \ Tue Nov 29 20:00:16 PST 2011
      [
        {" Table of numbers for MKTs, used in daysfill():
          w  1E-3 c  1E-3 s  1E-3 sm 1E-3 bo 1E-3
          lc 1E-3 lh 1E-3
          cc 1E-3 kc 1E-3 sb 1E-3 jo 1E-3
          hg 2E-3 gc 2E-3 pl 1E-3 si 1E-3
          ct 1E-3 cl 2E-3 ho 1E-3 hu 1E-3 ng 1E-3
          sf 1E-3 eu 1E-3 jy .5E-3 mp 1E-3 bp 1E-3
          us 1E-3 tn .5E-3
          dj 2E-3 sp 2E-3 nq 2E-3 nk 1E-3
        "} words vol2mat bend dice park yes sort "G" book
      ]
      "MKT" book
      G dup MKT lowercase 8 blpad str2num bsearch (r f)
      IF reach 2nd pry num2str strchop number drop
      ELSE (hG r) 2drop
         " vnum: symbol not in table: " . MKT . nl HALT
      THEN
   end

   inline: VP ( --- f) \ view positions option
    \ Wed Sep  1 17:38:25 PDT 2010.  Position option in sigmodel().
    \ Uncomment one of these options:
    \    one \ unsorted: positions by time
         two \ sorted: positions by value
   end
     
   function (V) = vquarter(Pt) { // voice for price quarter
   /* Incoming Pt is a row vector of the model at the current time.

      Find which quarter the price is in and return the voice name. */

      P = @Pt[1, .C]; // current price

      if(P>=@Pt[1, .K6]) return("+dot4");
      if(P>=@Pt[1, .M ]) return("+dot3");
      if(P>=@Pt[1, .K2]) return("+dot2");
                         return("+dot1");
   }

   function (V) = vseg(Pt) { // voice for price segment
   /* Incoming Pt is a row vector of the model at the current time.

      Find which segment the price is in and return the voice name. */

      P = @Pt[1, .C]; // current price

      if(P==@Pt[1, .B]) return("+dot3");
      if(P==@Pt[1, .S]) return("+dot1");
                        return("+dot2");
   }

   function (V) = vstate(Pt) { // voice for state
   /* Incoming Pt is a row vector of the model at the current time.

      Find the region that the price is in, and return the voice
      string for it. 

      Voice indices r follow the order of names in signal():
         r = 1, 2: bravo101, bravo102
         r = 3, 4: delta101 delta102
         r = 5, 6: sierra101, sierra102
   */
      P = @Pt[1, .C]; // current price
      IF(P>=@Pt[1, .R50]);
         IF(P>@Pt[1, .R90]);
            V = "sierra102";
            r = 6;
         ELSE 
            IF(P>=@Pt[1, .R70]);
               V = "sierra101";
               r = 5;
            ELSE
               V = "delta102";
               r = 4;
            THEN
         THEN
      ELSE
         IF(P>=@Pt[1, .R30]);
            V = "delta101";
            r = 3;
         ELSE
            IF(P>=@Pt[1, .R10]);
               V = "bravo102";
               r = 2;
            ELSE
               V = "bravo101";
               r = 1;
            THEN
         THEN
      THEN;
   }

   function (V) =  vstate(Pt) { // voice for state
   /* Incoming Pt is a row vector of the model at the current time.

      Find the region that the price is in, and return the voice
      string for it. 

      Voice indices r follow the order of names in signal():
         r = 1, 2, 3: bravo103, bravo102, bravo101 
            r = 4, 5: delta101, delta102
         r = 6, 7, 8: sierra101, sierra102, sierra103
   */
      P = @Pt[1, .C]; // current price

      B = @Pt[1, .B];
      B2 = @Pt[1, .B2];
      S = @Pt[1, .S];
      S2 = @Pt[1, .S2];

   /* The order of these IF branches determines precedence. */

      IF(P==B && P==B2); // bravo103
         V = "bravo103";
         r = 1;
         return(V);
      THEN

      IF(P==S && P==S2); // sierra103
         V = "sierra103";
         r = 8;
         return(V);
      THEN

      IF(P==B); // bravo101
         V = "bravo101";
         r = 3;
         return(V);
      THEN

      IF(P==S); // sierra101
         V = "sierra101";
         r = 6;
         return(V);
      THEN

      IF(P==B2); // bravo102
         V = "bravo102";
         r = 2;
         return(V);
      THEN
 
      IF(P==S2); // sierra102
         V = "sierra102";
         r = 7;
         return(V);
      THEN

      IF(P>@Pt[1, .tREF]); // delta102, B<P<S and P<tREF
         V = "delta102";
         r = 5;
         return(V);
      THEN

      V = "delta101"; //delta101, B<P<S and P>=tREF
      r = 4;
      return(V);
   }

   function (V) =  vstate(Pt) { // voice for state
   /* Incoming Pt is a row vector of the model at the current time.

      Find the region that the price is in, and return the voice
      string for it. */

      P = @Pt[1, .C]; // current price 

      IF(P==@Pt[1, .Bs]);
         v = "bravo101";
         r = 1;
      ELSE 
         IF(P==@Pt[1, .Gs]);
            v = "sierra101";
            r = 4;
         ELSE 
            IF(P>@Pt[1, .M]);
               v = "delta102";
               r = 3;
            ELSE
               v = "delta101";
               r = 2;
            THEN
         THEN
      THEN;

      V = v;
   }

   function (V) =  vstate(Pt) { // voice for state
   /* Incoming Pt is a row vector of the model at the current time.

      Find which trace is nearest below the current price and return 
      the voice name that defines that price region. */
      {
      /* 7 columns from Pt for table: */
         Tcols = [.L, .tq1, .tq2, .tq4, .tq6, .tq7, .H]'; 

      /* 6 voices: */
         v = [bravo101 ; bravo102 ; 
              delta101 ; delta102 ; 
              sierra101 ; sierra102];

      /* Function time_vec() (mfil.v) is not just for times.  Using 
         time_vec() below ensures an ascending list in T for binary 
         search when T can have adjacent terms that are identical.

         Example: This shows table T for symbol US near session start, 
         when there is not very much range between H and L (labels L, 
         N1, ... H have been added; values are scaled perpetual, and
         so do not look like bond prices):

         [This example was run when Tcols contained L, N1-N7, H.]

            % "%12.3f" mformatset
            % 'vstate' 'T' yank .m
             Row 1:    39210.000 L
             Row 2:    39210.010 N1
             Row 3:    39220.000 N2
             Row 4:    39220.010 N3
             Row 5:    39230.000 N4
             Row 6:    39230.010 N5
             Row 7:    39230.020 N6
             Row 8:    39240.000 N7
             Row 9:    39240.010 H 

         This shows how identical integers N4, N5 and N6 have been
         nudged to make them unequal (and ascending). */
      }
      P = @Pt[1, .C]; // current price (never greater than H)

   /* Make lookup table T, using time_vec() to ensure no equal values
      (see example above).  For binary search to work correctly, traces
      must be sorted since inactive tq4 can stay behind and be out of 
      order (when this happens, tq4 is not a curve near P and so would
      not be the closest one found by the search): */
      T = time_vec(sort(Pt[1, Tcols]', yes));

   /* Find curve T(r) that is nearest below current price P: */
      (r, f) = bsearch(T, P);

   /* Price P is never greater than high H, but r is capped to rows(v)
      (one less than rows(Tcols)) just in case: */
      r = min(r, rows(v)); // this r is used by TGRAPH.LAST

      V = strchop(vol2str(v[r]));
   }

   function (V) =  vstate(Pt) { // voice for state
   /* Incoming Pt is a row vector of the model at the current time.

      Find which curve is nearest below the current price and return
      the voice name that defines that price region. */
      {
      /* 5 columns from Pt for table: */
         Tcols = [.L ; .K2 ; .M ; .K6 ; .H];

      /* 4 voices: */
         v = [bravo101 ;  // bottom quarter
              delta101 ;  
              delta102 ;
              sierra101]; // top quarter

      /* Function time_vec() (mfil.v) is not just for times.  Using
         time_vec() below ensures an ascending list in T for binary
         search when T can have adjacent terms that are identical.

         Example: This shows table T for symbol US near session start,
         when there is not very much range between H and L (labels L,
         N1, ... H have been added; values are scaled perpetual, and
         so do not look like bond prices):

         [This example was run when Tcols contained L, N1-N7, H.]

            % "%12.3f" mformatset
            % 'vstate' 'T' yank .m
             Row 1:    39210.000 L
             Row 2:    39210.010 N1
             Row 3:    39220.000 N2
             Row 4:    39220.010 N3
             Row 5:    39230.000 N4
             Row 6:    39230.010 N5
             Row 7:    39230.020 N6
             Row 8:    39240.000 N7
             Row 9:    39240.010 H

         This shows how identical integers N4, N5 and N6 have been
         nudged to make them unequal (and ascending). */
      }
      P = @Pt[1, .C]; // current price (never greater than H)

   /* Make lookup table T, using time_vec() to ensure no equal values
      (see example above): */
      T = time_vec(integer(0.5 + Pt[1, Tcols])');

   /* Find curve T(r) that is nearest below current price P: */
      (r, f) = bsearch(T, P);

   /* Price P is never greater than high H, but r is capped to rows(v)
      (one less than rows(Tcols)) just in case: */
      r = min(r, rows(v)); // this r is used by TGRAPH.LAST

      V = strchop(vol2str(v[r]));
   }

   inline: vstats (qM --- hG) \ return statistics constants for M
\     Wed Dec 14 08:51:25 PST 2011

\     Return column G with r rows of data specified for string M.
\     Require chars(M) < 9.

      [ 9 "r" book \ number of values (rows) in returned G

        {" Table of values for each string M:
         \      1    2    3    4     5     6    7    8     9

         \      -------- Volume -------    ------- Equity -------
         \ Mkt  sigma factors  hr spans    sigma factors  hr span
         \ M    s1   s2   s3   stats dM    s1   s2   s3    stats

           eu   3    4.5  6    24    0.5   1    2    3     24
           sf   3    4.5  6    24    0.5   1    2    3     24
           jy   3    4.5  6    24    0.5   1    2    3     24

           cl   3    4.5  6    24    0.5   1    2    3     24
           gc   3    4.5  6    24    0.5   1    2    3     24
           hg   3    4.5  6    24    0.5   1    2    3     24

           dj   3    4.5  6    24    0.5   1    2    3     24
           sp   3    4.5  6    24    0.5   1    2    3     24
           nq   3    4.5  6    24    0.5   1    2    3     24

           us   3    4.5  6    24    0.5   1    2    3     24
           tn   6    4.5  6    24    0.5   1    2    3     24

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) r 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having r rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd r items reach mat2vol numerate r foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vstats" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vstats" "S" yank 2nd catch .m
      }
      ]
      (qM) "M" book

      S M lowercase 8 blpad str2num (n)   \ turn M string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G
      ELSE (r) drop " vstats hal" "ting: no data for " + M + . nl HALT
      THEN (hG) 
   end
 
   inline: Vtraffic_( --- ) \ for Mkt, create data for vtraffic
{     Thu Feb 23 09:55:32 PST 2012

      Look at volume in powers of two.  For something starting at 1 
      (there must be two traders to make a trade, one buyer and one
      seller; volume counts the two contracts, one long and one short,
      as one, so technically volume starts at one) and growing, powers
      of two seem like a reasonable measure of growth.  For a market,
      we can watch volume growing from 1 at session start to its high-
      est level at session end.

      Doing this over and over, it is likely that the range of growth
      to highest potential will become obvious and predictable since
      the same traders, more or less, are there session after session.

      This word makes histograms of growth for each of the sessions in 
      the electronic console for Mkt, and then computes an average 
      histogram over all sessions.

      For parameters in the model this looks like cheating, because past
      sessions are used to get data that is then used to compute the
      very measures of those past sessions.  The only honest one is the
      current session, since it is excluded from the histograms.

      It is hoped that this calibration is seldom run, so eventually 
      most or all sessions will be using past values established long
      ago. 

      It is likely that the values will rarely change, since they are
      power-of-two levels with lots of space between.  The highest 
      volume seen each session would have to become consistently higher
      by a factor of two before warranting a change.

      The results for calibrations of various markets is shown in the 
      Appendix.  Search for: Volume calibrations.
}
      [ "'P' main" "Pt" macro

      {" HIST (hR nCmax --- hH hB) \ macro to run word histogram()
         push (hR) dup rows ones 0 pile (hV)
         swap (hR) pull pile (hC) 1 (dC) histogram
         (hH) dup 2nd catch (hH) swap 1st catch (hB)
      "} "HIST" macro

      ]
      " Vtraffic: not set up for this model" . nl return

      "daymodel" "n" yank "n" book
      "daysget" "NADD" yank "NADD" book

      "daymodel" "T2" yank "T2" book \ XY table: [V, 2-power]
      T2 2nd catch maxfetch 2drop "rows_h" book

    \ For all sessions, fetch column .R that holds the power of 2 that 
    \ is closest to the volume (computed in daymodel: R = look(T2, V)):
      Pt .R catch (hR)

    \ Discard the NADD future sessions and the current session (which
    \ is probably still trading):
      (hR) n foldr 1st over cols NADD 1+ - items catch (hT)
      (hT) "T" book \ matrix of powers of two; each col is a session

    \ Make a header for T:
      " Vtraffic: " Mkt + spaced date + 
      " Vtraffic: Average histogram for " T cols intstr + 
      " sessions" + pile 5 indent (hHeader)

    \ Make a histogram for each session: 
      T cols 1st DO T I catch rows_h HIST (hH hB) drop (hH) LOOP
      (hH1 hH2 hH3 ...) T cols parkn (hT) \ each col is a histogram

    \ Average each bin across all histograms (all columns of T):
      (hT) across T cols / "T" book

      (hHeader)

      "Volume 2-power Number" (qS)
      (qS) T2 T park itext pile neat 10 indent (hT)

      (hHeader hT) pile nl . \ display the results

      0 "T" book 0 "T2" book
   end

   inline: vtraffic_(qM --- hG) \ return traffic constants for M
\     Thu Feb 23 04:09:43 PST 2012

\     Return column G with r rows of data specified for string M.
\     Require chars(M) < 9.

      [ 8 "r" book \ number of values (rows) in returned G
        {
         Updated eu, sf Thu Feb 23 16:09:42 PST 2012 

         Run word Vtraffic() to determine which 8 levels of G to use
         for market M.  Here are all possible levels:

            G   Volume          G   Volume

            1        2         13     8192
            2        4         14    16384
            3        8         15    32768
            4       16         16    65536
            5       32         17   131072
            6       64         18   262144
            7      128         19   524288
            8      256         20  1048576
            9      512         21  2097152
           10     1024         22  4194304
           11     2048         23  8388608
           12     4096         24 16777216
        }
        {" Table of G values (see above) for string M:
         \ M    1    2    3    4    5    6    7    8

           eu   10   11   12   13   14   15   16   17
           sf   7    8    9    10   11   12   13   14
           jy   8    9    10   11   12   13   14   15

           cl   10   11   12   13   14   15   16   17
           gc   9    10   11   12   13   14   15   16
           hg   8    9    10   11   12   13   14   15

           dj   9    10   11   12   13   14   15   16
           sp   13   14   15   16   17   18   19   20
           nq   10   11   12   13   14   15   16   17

           us   10   11   12   13   14   15   16   17
           tn   12   13   14   15   16   17   18   19

         \ See "Volume calibrations" in the Appendix for the derivation
         \ of the values in this table.

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) r 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having r rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd r items reach mat2vol numerate r foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vtraffic" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vtraffic" "S" yank 2nd catch .m
      }
      ]
      (qM) "M" book

      S M lowercase 8 blpad str2num (n)   \ turn M string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G
      ELSE (r) drop " vtraffic hal" "ting: no data for " + M + . nl HALT
      THEN (hG) 
   end

   inline: vtraffic_(qM --- hG) \ return traffic constants for M
\     Sun Jan 29 14:35:29 PST 2012

\     Return column G with r rows of data specified for string M.
\     Require chars(M) < 9.

      [ 3 "r" book \ number of values (rows) in returned G

        {" Table of values for each string M:
         \      1    2    3    4     5     6    7    8     9
         \      
         \ Mkt  sess rows hrs  
         \ M    ns   nV   hC 

           eu   2    5    1.0
           sf   2    5    1.0
           jy   2    5    1.0

           cl   2    5    1.0
           gc   2    5    1.0
           hg   2    5    1.0

           dj   2    5    1.0
           sp   2    5    1.0
           nq   2    5    1.0

           us   2    5    1.0
           tn   2    5    1.0

        "} (hT) "\" "" qreplace (hT) \ remove comment lines
        (hT) words vol2mat (hA)      \ text patterns into numbers
        (hA) r 1+ fold (hM) dup (hM)

      \ Make lookup table S having names in column 1 and column num-
      \ bers of G (to be made next) in column 2; for binary search, 
      \ matrix S is sorted so the rows in column 1 are in ascending 
      \ order:
        (hM) 1st reach bend 1st over rows items park yes sort "S" book

      \ Make data table G having r rows of data with each column
      \ corresponding to a row in S:
        (hM) 2nd r items reach mat2vol numerate r foldr "G" book
      {
        Examples of internal arrays.

        To see sorted names table S, run this phrase at the ready 
        prompt:
           "vtraffic" "S" yank 1st catch mat2vol .

        To see the column map for G contained in S[*, 2], run:
           "vtraffic" "S" yank 2nd catch .m
      }
      ]
      (qM) "M" book

      S M lowercase 8 blpad str2num (n)   \ turn M string into a NUM 
      (S n) bsearch (r f)                 \ find n in S at row r
      IF (r) G S rot (hS r) reach 2nd pry \ look up G col in 2nd S col
         (hG hCol) catch (hG)             \ fetch col from G
      ELSE (r) drop " vtraffic hal" "ting: no data for " + M + . nl HALT
      THEN (hG) 
   end

   inline: ym (nyg --- qym) \ market price STR from scaled price NUM
\     Remove market price scaling and format into as-quoted string.
      (nyg) dup UDEF <>
      IF (nyg) Mkt "csr_str" "yprice" yank (qym)
      ELSE (nUDEF) intstr
      THEN (qym)
   end

End obsolete */

------------------------------------------------------------------------

    Miscellaneous colors.

    Colors, many from http://www.december.com/html/spec/color0.html:

    Some colors in groups of two or three are ones that work well 
    together (they contrast well or different colors have similar
    shades).

           "#FF3300" LS     \ S1     B   Nectarine
           "#FF6103" LS     \ S2     N   Cadmium Orange
           "#B13E0F" LS     \ S3     M   Kidney Bean
           "#5E2612" LS     \ S4     <   Sepia 
           "#691F01" LS     \ S5     >   Maroon

           "#83F52C" LS     \ F1     s   Neon Green
           "#808000" LS     \ F2     d   Olive Green
           "#3F9E4D" LS     \ F3     f   Green Taxi
           "#004F00" LS     \ F4     F   Dumpster
           "#1464F4" LS     \ F5     c   Butterfly Blue
           "#003F87" LS     \ F6     v   Sign Blue
           "#22316C" LS     \ F7     g   Delft Blue

           "#1464F4" LS     \ V1     s   Butterfly Blue
           "#05E9FF" LS     \ V2     s   Indiglo Blue

           "#32CD32" LS     \ V3     d   Lime Green
           "#228B22" LS     \ V4     d   Forest Green

           "#ED9121" LS     \ V5     f   Carrot
           "#FF6600" LS     \ V6     f   Orange

           "#FF3300" LS     \ V7     g   Nectarine
           "#FF0000" LS     \ V8     g   Red

           "#FF3300" LS     \ V2     c   Nectarine
           "#F3E88E" LS     \ V3     v   Grapefruit 
           "#A2B5CD" LS     \ V4     g   Silver 

           "#32CD32" LS     \ F2     F   Lime Green
           "DeepSkyBlue2" LS \U2     v   Sky Blue

           "#93DB70" LS     \ V4     g   Greenyellow
           "PeachPuff4" LS  \ V3     v   Peach
           "#FF0000" LS     \ V2     y   Red
           "#FF6103" LS     \ V4     D   Cadmium Orange
           "#A2B5CD" LS     \ W1     s   Silver 
           "#FF3300" LS     \ D1     d   Nectarine


           "#93DB70" LS     \ V4     g   Greenyellow
           "PeachPuff4" LS  \ V3     v   Peach
           "#FF0000" LS     \ V2     y   Red
           "#FF6103" LS     \ V4     D   Cadmium Orange
           "#A2B5CD" LS     \ W1     s   Silver 
           "#F3E88E" LS     \ W2     c   Grapefruit 
           "#FF6103" LS     \ U0     s   Cadmium Orange
           "#93DB70" LS     \ U1     c   Greenyellow 

           "#0FDDAF" LS     \ V2     V   Turquoise Green
           "#586949" LS     \ W4     c   Broccoli

           "DeepSkyBlue2" LS \V1     d   Sky Blue
           "#32CD32" LS     \ V2     f   Lime Green
           "#1464F4" LS     \ V3     g   Butterfly Blue
           "#397D02" LS     \ V4     y   Green Pepper 

           "#AA5303" LS     \ V0     g   Coffee
           "#FF6103" LS     \ V1     g   Cadmium Orange

           "#9E0508" LS     \ V2     y   Burgundy
           "#FF0000" LS     \ V3     y   Red

           "#05E9FF" LS     \ R1     d   Indiglo Blue 
           "#93DB70" LS     \ R2     d   Greenyellow 

           "#1464F4" LS     \ S1     s   Butterfly Blue
           "#397D02" LS     \ B1     s   Green Pepper 

           "#003F87" LS     \ S2     c   Sign Blue
           "#004F00" LS     \ B2     c   Dumpster Green
           "#42647F" LR     \ G1     i   Blue Whale
           "#586949" LR     \ G2     i   Broccoli

           "#213D30" LS     \ B3     s   Packer Green
           "#22316C" LS     \ S1     c   Delft Blue
           "#FF6103" LS     \ E1     g   Cadmium Orange
           "#0198E1" LS     \ E2     g   Topaz Blue
           "#228B22" LS     \ E3     g   Forest Green

           "#05E9FF" LS     \ W1     c   Indiglo Blue 
           "#32CD32" LS     \ W2     v   Lime Green
           "#FF3300" LS     \ W3     b   Nectarine

           "#0198E1" LS     \ W2     v   Topaz Blue
           "#3063A5" LS     \ R1     s   Mailbox Blue
           "#1464F4" LS     \ C      p   Butterfly Blue
           "#236B8E" LS \ steel blue (medium dark)
           "SteelBlue4" LS
           "SteelBlue1" LS
           "DeepSkyBlue4" LS

           "#3063A5" LS     \ R1     s   Mailbox Blue
            "#22316C" LS     \ R2     d   Delft Blue
           "DeepSkyBlue3" LS \T2     V   Sky Blue
           "#739AC5" LS \ seurat blue (grey blue light)

           "#004F00" LS     \ U1     s   Dumpster Green
           "#003F87" LS     \ U2     s   Sign Blue
           "#213D30" LS     \ T1     d   Packer Green
           "#22316C" LS     \ T2     d   Delft Blue
           "#0198E1" LS     \ W2     v   Topaz Blue

           "#2F1800" LS     \ W3     b   Mud 
           "#003F87" LS     \ U1     f   Sign Blue
           "#004F00" LS     \ U2     f   Dumpster Green

           "#964514" LR     \ G4     G   Mars Orange
           "#DD7500" LS     \ W1     c   Sign Orange 
           "#5C4033" LS     \ W2     v   Dust
           "#603311" LS     \ W3     b   Sign Brown

           "#0198E1" LR     \ M1     d   Topaz Blue
           "#236B8E" LR     \ M2     f   Steel Blue
           "#22316C" LR     \ M3     g   Delft Blue

           "#213D30" LR     \ M4     c   Packer Green
           "#004F00" LR     \ M5     v   Dumpster
           "#32CD32" LR     \ M6     b   Lime Green

           "#236B8E" LR     \ G1     g   Steel Blue

           "#0198E1" LR     \ M1     b   Topaz Blue
           "#964514" LR     \ M2     b   Mars Orange
           "#3E7A5E" LR     \ M3     b   Ooze Green

           "DodgerBlue4" LR \ M4     b   Dark Dodger Blue
           "#FF6103" LR     \ M5     b   Cadmium Orange 
           "#228B22" LR     \ M6     b   Forest Green

           "#586949" LR     \ R3     v   Broccoli
           "#46523C" LR     \ R4     b   Od green

           "#2F1800" LR     \ G3     G   Mud
           "#964514" LR     \ G4     G   Mars Orange

           "#00AF33" LS     \ P1     b   True Green
           "#1464F4" LS     \ P2     n   Butterfly Blue

           "#83F52C" LS     \ T1     v   Neon Green
           "DeepSkyBlue3" LS \T2     V   Sky Blue

           "#603311" LR     \ Gp     m   Sign Brown

           "#A9ACB6" LS     \ N1     d   Aluminum 
           "#FCB514" LS     \ N2     D   Packer Gold 

           "#05E9FF" LS     \ CL     B   Indiglo Blue 
           "#FCB514" LS     \ CM     N   Packer Gold 
           "#83F52C" LS     \ CH     M   Neon Green

           "#42647F" LR     \ GL     g   Blue Whale
           "#586949" LR     \ GH     g   Broccoli

           "#22316C" LR     \ GM     V   Delft Blue
           "#213D30" LR     \ GN     V   Packer Green

           "#8C1717" LS     \ CM     B   Scarlet
           "#DD7500" LR     \ Gp     g   Sign Orange 

           "#FF6103" LR     \ CD     B   Cadmium Orange 
           "#42647F" LR     \ G1     g   Blue Whale
           "#586949" LR     \ G2     g   Broccoli

           "#517693" LR     \ G1     B   Malta Blue
           "#596C56" LR     \ G2     N   Snake
           "#236B8E" LR     \ G3     B   Steel Blue
           "#46523C" LR     \ G4     N   Od green

           "Grey23"  LS     \ P2     n   Charcoal
           "#292421" LS     \ P3     m   Ivory Black 

           "#0198E1" LS     \ C1     f   Topaz Blue
           "#A6D785" LS     \ C2     d   Guacamole

           "#1DA237" LS     \ R2     g   Bottle Green
           "#3063A5" LS     \ pL     y   Mailbox Blue

           "#5C3317" LS     \ P1     b   Bakers Chocolate
           "#AA5303" LS     \ C1     d   Coffee

           "#525C65" LS     \ C2     f   Blue Dog

           "#0198E1" LS     \ N1     n   Topaz Blue
           "#A6D785" LS     \ N2     n   Guacamole
           "#5C4033" LR     \ N3     n   Dust Brown 

           "#517693" LR     \ G1     e   Malta Blue
           "#636F57" LR     \ G2     e   Cactus

           "#4D4DFF" LS     \ N1     n   Neon Slate Blue
           "#00FF66" LS     \ N2     n   Neon Avocado

           "#1464F4" LS     \ U1     b   Butterfly Blue
           "#1DA237" LS     \ U2     e   Bottle Green

           "#691F01" LS     \ P2     n   Maroon
           "#3F1800" LS     \ C2     f   Mahogany

           "#586949" LR \ G1     n   Broccoli
           "#636F57" LR \ G2     n   Cactus
           "#42647F" LR \ G3     m   Blue Whale
           "#517693" LR \ G4     m   Malta Blue

           "#67C8FF" LS     \ R1     w   Neon Blue
           "#83F52C" LS     \ R2     w   Neon Green

           "#86C67C" LS     \ U2     e   Euro Green

           "DodgerBlue4" LS \ V1     v   Dark Dodger Blue
           "#215E21" LS     \ V2     v   Hunter Green
           
           "#22316C" LS     \ W1     V   Delft Blue
           "#213D30" LS     \ W2     V   Packer Green

           "#FF5333" LS \ Cm     s   Safety Cone Orange

           "#694489" LS \ P3     g   Purple Rain 

           "#FF6103" LS \ E1     v   Cadmium Orange
           "#FF0000" LS \ E2     b   Red

           "#586949" LS \ P1 Broccoli
           "#525C65" LS \ P2 Blue Dog

           "#228B22" LS \ Y1     v   Forest Green
           "#1464F4" LS \ Y2     b   Butterfly Blue

           "#004F00" LS \ Lm     [   Dumpster Green
           "#003F87" LS \ Hm     ]   Sign Blue

           "#05E9FF" LS \ P11 Indiglo Blue
           "#83F52C" LS \ P44 Neon Green

           "#FF6103" LS \ G1     f   Cadmium Orange
           "#3F1800" LS \ G3     v   Mahogany

           "#228B22" LS \ B1     s   Forest Green
           "#668014" LS \ B2     d   Oxide Green
           "#2F4F2F" LS \ B3     f   Dark Green

           "#1464F4" LS \ S1     l   Butterfly Blue
           "#236B8E" LS \ S2     k   Steel Blue
           "#3A5894" LS \ S3     j   Blue Train

           "#86C67C" LS \ B      n   Euro Green
           "#0198E1" LS \ S      m   Topaz Blue

           "#003400" LS \ T1     s   Dark Green
           "#22316C" LS \ T3     f   Delft Blue

           "#003400" LS \ T1     s   Dark Green
           "#003000" LS \ G1     m   Dark Green
           "#000040" LS \ G2     m   Dark Blue

           "#55AE3A" LS \ B1     w   Leaf 
           "#006B54" LS \ B2     e   Sign Green

           "#74BBFB" LS \ S1     w   Blue Ice
           "#1E90FF" LS \ S2     e   Dodger Blue

           "#668014" LS \ F1     i   Oxide Green 
           "#517693" LS \ F2     o   Malta Blue

           "#586949" LS \ E1     i   Broccoli
           "#42647F" LS \ E2     o   Blue Whale

           "#BCED91" LS \ E1     i   Greenmist
           "#74BBFB" LS \ E2     o   Blue Ice

           "#BCED91" LS \ E1     i   Greenmist
           "#668014" LS \ P2     w   Oxide Green
           "#92CCA6" LS \ P3     s   Pastel Green
           "#3F9E4D" LS \ P4     s   Green Taxi

           "#517693" LS \ P5     d   Malta Blue
           "#3063A5" LS \ P6     d   Mailbox Blue
           "#739AC5" LS \ P7     f   Seurat Blue
           "#1E90FF" LS \ P8     f   Dodger Blue

           "#004F00" LS      \ R5     f   Dumpster Green
           "#003F87" LS      \ R6     f   Sign Blue
 
           "#228B22" LR 2dup     \ U1,U2  s   Forest Green
           "#004F00" LR 2dup     \ U3,U4  d   Dumpster Green
           "#213D30" LR 2dup     \ U5,U6  f   Packer Green

           "#0276FD" LR 2dup     \ V1,V2  j   Picasso Blue
           "#003F87" LR 2dup     \ V3,V4  k   Sign Blue
           "#22316C" LR 2dup     \ V5,V6  l   Delft Blue

           "#8E6B23" LS      \  P1     v   Sienna
           "#993300" LS      \  P2     b   Chocolate
           "#FF6103" LS      \  P3     n   Cadmium Orange
           "#7B3F00" LS      \  P4     m   Cinnamon

           "#688571" LS \ P1     n   Pound Green
           "#484D46" LS \ P2     n   Ranger Green
           "#517693" LS \ P3     m   Malta Blue 
           "#525C65" LS \ P4     m   Blue Dog

           "#586949" LS \ P1     f   Broccoli
           "#668014" LS \ P2     v   Oxide Green
           "#603311" LS \ P3     b   Sign Brown
           "#236B8E" LS \ P4     n   Steel Blue 
           "#525C65" LS \ P5     m   Blue Dog

           "#228B22" LS \ B1     s   Forest Green
           "#668014" LS \ B2     d   Oxide Green
           "#2F4F2F" LS \ B3     f   Dark Green 

           "#228B22" LS \ B1     s   Forest Green
           "#1464F4" LS \ S1     l   Butterfly Blue 
           "#236B8E" LS \ S2     k   Steel Blue 
           "#3A5894" LS \ S3     j   Blue Train

           "#228B22" LS \ B3     f   Forest Green
           "#9E0508" LS \ S1     l   Cadmium Orange
           "#7B3F00" LS      \  P4     m   Cinnamon

           "#688571" LS \ P1     n   Pound Green
           "#484D46" LS \ P2     n   Ranger Green
           "#517693" LS \ P3     m   Malta Blue 
           "#525C65" LS \ P4     m   Blue Dog

           "#586949" LS \ P1     f   Broccoli
           "#668014" LS \ P2     v   Oxide Green
           "#603311" LS \ P3     b   Sign Brown
           "#236B8E" LS \ P4     n   Steel Blue 
           "#525C65" LS \ P5     m   Blue Dog

           "#228B22" LS \ B1     s   Forest Green
           "#668014" LS \ B2     d   Oxide Green
           "#2F4F2F" LS \ B3     f   Dark Green 

           "#1464F4" LS \ S1     l   Butterfly Blue 
           "#236B8E" LS \ S2     k   Steel Blue 
           "#3A5894" LS \ S3     j   Blue Train

           "#228B22" LS \ B3     f   Forest Green
           "#9E0508" LS \ S1     l   Burgundy Red
           "#0276FD" LS \ S3     j   Picasso Blue

           "#B13E0F" LS \ B1     s   Rust
           "#A2B5CD" LS \ D      m   Old Silver
           "#964514" LS \ B2     w   Mars Orange
           "#603311" LS \ B3     w   Sign Brown

           "#668014" LS \ B5     e   Oxide Green
           "#006400" LS \ B7     e   Dark Green
           "#691F01" LS \ S2     o   Dark Maroon
           "#551011" LS \ S3     o   Burnt Sienna
           "#0198E1" LS \ S5     i   Topaz Blue
           "#3A5894" LS \ S7     i   Blue Train

           "#FF6103" LS \ S3 Cadmium Orange
           "#FF0000" LS \ R4 Red

           "#1874CD" LS \ P21 Dodger Blue
           "#228B22" LS \ P34 Forest Green

           "#FF0000" LS \ R4 Red
           "#FF6103" LS \ S3 Cadmium Orange
           "#964514" LS \ R3 Mars Orange
           "#603311" LS \ U3 Sign Brown

           "#586949" LS \ P1 Broccoli
           "#525C65" LS \ P2 Blue Dog
           "Grey20"  LS \ P3 Charcoal
           "Grey25"  LS \ Charcoal (lighter)
           "Grey30"  LS \ Charcoal (lighter)

           "#603311" LS \ H1 Sign Brown
           "#551011" LS \ L1 Burnt Sienna
           "#A0522D" LS \ M1 Sienna

           "#05E9FF" LS \ P11 Indiglo Blue
           "#1874CD" LS \ P21 Dodger Blue
           "#FF6103" LS \ P32 Cadmium Orange
           "#964514" LS \ P42 Mars Orange

           "#9E0508" LS \ P13 Burgundy Red
           "#FF0000" LS \ P23 Red
           "#228B22" LS \ P34 Forest Green
           "#83F52C" LS \ P44 Neon Green

           "#B13E0F" LS \ PM Kidney Bean
           "#FF6103" LS \ H1 Cadmium Orange
           "#FF0000" LS \ L1 Red

           "#525C65" LS \ P1 Blue Dog
           "Grey20"  LS \ P2 Charcoal

           "#964514" LS \ R1 Mars Orange
           "#FF6103" LS \ R2 Cadmium Orange
           "#9E0508" LS \ R3 Burgundy Red
           "#FF0000" LS \ R4 Red

           "DodgerBlue4" LS \ S1 Dark Dodger Blue
           "#92CCA6" LS \ B3 Pastel Green 

           "#006400" LS \ E Dark Green
           "#236B8E" LS \ U Steel Blue

           "#003F00" LS \ L2 Dumpster Green
           "#551011" LS \ L3 Burnt Sienna
           "#22316C" LS \ L4 Delft Blue

           "#691F01" LS \ S Dark Maroon 
           "#9E0508" LS \ F Burgundy Red
           "#551011" LS \ M Burnt Sienna
           "#603311" LS \ B Sign Brown
           "#964514" LS \ U1 Mars Orange
           "#B13E0F" LS \ Y Rust

           "#FF6103" LS \ S Cadmium Orange
           "#964514" LS \ U1 Mars Orange

           "#691F01" LS \ S Dark Maroon 
           "#551011" LS \ M Burnt Sienna
           "#FF0000" LS \ B Red
           "#9E0508" LS \ D1 Burgundy Red

           "#526F35" LS \ X1 Fenway Grass
           "#236B8E" LS \ X2 Steel Blue

           "#228B22" LS \ M1 Forest Green
           "#0276FD" LS \ M2 Picasso Blue

           "Grey20"  LS \ B Charcoal

           "#FF0000" LS \ R1 Red
           "#FF6103" LS \ R2 Cadmium Orange

           "#83F52C" LS \ N1 Neon Green 
           "#67C8FF" LS \ N2 Light Neon Blue

           "#603311" LS \ U Sign Brown
           "#964514" LS \ V Mars Orange
 
           "#003F00" LS \ A1 Dumpster Green
           "#551011" LS \ A2 Burnt Sienna
           "#22316C" LS \ A3 Delft Blue

           "#228B22" LS \ V1 Forest Green
           "#668014" LS \ V2 Chrome Oxide Green
           20 Blue LS   \ V3 Cadet Blue
           "#0276FD" LS \ V4 Picasso Blue

           "Grey20"  LS \ P Charcoal
           "#FF0000" LS \ D1 Red
           "#FF6103" LS \ D2 Cadmium Orange
           "#9E0508" LS \ A1 Burgundy
           "#964514" LS \ A2 Mars Orange

           "#228B22" LS \ U1 Forest Green
           "#3F602B" LS \ U2 Douglas Fir
           90 Green1 LS \ U3 Dark Green
           "#808000" LS \ U4 Olive Green
           "#83F52C" LS \ U5 Neon Green

           "#05E9FF" LS \ V1 Indiglo Blue
           "#6183A6" LS \ V2 Lake Erie Blue
           10 Blue LS   \ V3 Cadet Blue
           "#3A5894" LS \ V4 Blue Train
           "#0276FD" LS \ V5 Picasso Blue

           "#9E0508" LS \ B1 Burgundy
           "#964514" LS \ S1 Mars Orange

           "#B13E0F" LS \ P Rust
           "#603311" LS \ PL Sign Brown 

           "#3F602B" LS \ S1 Douglas Fir
           "#4973AB" LS \ S2 Blue Bird

           "#83F52C" LS \ T1 Neon Green 
           "#E47833" LS \ T2 Mandarine Orange 
           "#67C8FF" LS \ T3 Light Neon Blue

           "#83F52C" LS \ P1 Neon Green 
           "#67C8FF" LS \ P2 Light Neon Blue

           "#228B22" LS \ R1 Forest Green
           "#0276FD" LS \ R2 Picasso Blue
           "#3F602B" LS \ U1 Douglas Fir
           "#3A5894" LS \ U2 Blue Train

           "#00FF00" LS \ B1 Lime Green
           "#228B22" LS \ C1 Forest Green
           "#0276FD" LS \ C3 Picasso Blue

           "#FF0000" LS \ P1 Red
           "#FF6103" LS \ P3 Orange 
           "#83F52C" LS \ R1 Neon Green 
           "#67C8FF" LS \ R3 Light Neon Blue
           "#808000" LS \ T1 Olive Green 
           "#3A5894" LS \ T2 Blue Train

           "#FF0000" LS \ P1 Red
           "#FF6103" LS \ P3 Orange 
           "#83F52C" LS \ R1 Neon Green 
           "#67C8FF" LS \ R3 Light Neon Blue
           "#808000" LS \ T1 Olive Green 
           "#3A5894" LS \ T2 Blue Train
           "#7B3F00" LS \ R1 Cinnamon
           "#67C8FF" LS \ S2 Light Neon Blue
           "#B13E0F" LS \ R2 Rust

           "#E47833" LS \ N Mandarine Orange
           "#734A12" LS \ N1 Raw Umber
           "#615E3F" LS \ N2 Tank
           "Grey20"  LS \ N3 Dark Grey

           "#9E0508" LS \ A1 Burgundy
           "#551011" LS \ A2 Burnt Sienna
 
           "#A6D785" LS \ R1 Guacamole
           "#228B22" LS \ R2 Forest Green
           "#D44942" LS \ R3 Chili
           "#3063A5" LS \ R4 Mailbox Blue
           "#99CDC9" LS \ R5 Wave Crest Blue

           "#668014" LS \ H1 Chrome Oxide Green 
           "#008080" LS \ L1 Teal Blue

           "Grey40" LS  \ D1 Medium Grey
           "#00CD66" LS \ R1 Spring Green 
           "#0276FD" LS \ S1 Picasso Blue

           "Grey30" LS  \ D2 Dark Grey
           "#228B22" LS \ R2 Forest Green
           "#3063A5" LS \ S2 Mailbox Blue

           "Grey25" LS  \ D3 Dim Grey
           "#215E21" LS \ R3 Hunter Green
           "#003F87" LS \ S3 Sign Blue
 
           "#00FF00" LS \ S Lime Green
           "#99CDC9" LS \ B Wave Crest Blue

           "#4CBB17" LS \ B2 Kelly Green
           "#0198E1" LS \ S2 Topaz Blue 

           "#228B22" LS \ B3 Forest Green 
           "#3063A5" LS \ S3 Mailbox Blue

           "Aquamarine3" LS \ N Aquamarine
           "#8C1717" LS \ V2 Scarlet 
           "#B13E0F" LS \ U2 Rust
           "#2E37FE" LS \ R1 Stained Glass Blue
           "#0198E1" LS \ R2 Topaz Blue 
           "Aquamarine3" LS \ R3 Aquamarine
           "#4CBB17" LS \ R4 Kelly Green
           "#00FF00" LS \ R5 Lime Green
 
           "#AA5303" LS \ P2 Coffee Brown
           "#3F9E4D" LS \ P3 Green Taxi

           "#67C8FF" LS \ C1 Light Neon Blue
           "#00FF00" LS \ C2 Lime Green

           "#B4D7BF" LS \ U Vanilla Mint Green
           "#88ACE0" LS \ V Blue Cow 

           "#00FF00" LS \ B Lime Green
           "#67C8FF" LS \ S Neon Blue2

           "#FF6103" LS \ A Cadmium Orange

           "#FFD700" LS \ Q Gold
           "#00FF00" LS \ U2 Lime 
           "#05E9FF" LS \ V1 Indiglo Blue

           "#734A12" LS \ P1 Raw Umber 
           "#AA5303" LS \ P2 Coffee
           "#9E0508" LS \ P3 Burgundy

           "#6183A6" LS \ A1 Lake Erie Blue
           "#8FA880" LS \ A2 Green Cheese

           "#8FA880" LS \ B1 Green Cheese 
           "#88ACE0" LS \ S1 Blue Cow 

           "#A6D785" LS \ F Guacamole Green 
           "#05E9FF" LS \ G Indiglo Blue

           "#BCD2EE" LS \ Q1 Light Steel Blue
           "#92CCA6" LS \ Q2 Pastel Green 

           "#1E90FF" LS \ S Dodger Blue
           "#4CBB17" LS \ B Kelly Green

           "#FFD700" LS \ Q Gold
           "#E6E8FA" LS \ P Silver

         \ "#92CCA6" LS \ B Pastel Green 
         \ "#739AC5" LS \ S Seurat Blue

           "#1E90FF" LS \ Q1 Dodger Blue
         \ "#4973AB" LS \ Q2 Bird Blue
         \ "#B13E0F" LS \ Q3 Rust
           "#FF6103" LS \ Q4 Cadmium Orange
         \ "#B13E0F" LS \ Q5 Rust
         \ "#8AA37B" LS \ Q6 Quartz Green
           "#4CBB17" LS \ Q7 Kelly Green

           "#C8F526" LS \ M Safety Vest Green
           "#63D1F4" LS \ N Surf Blue

           "#3F9E4D" LS \ B1 Green Taxi 
           "#1E90FF" LS \ S1 Dodger Blue

           "#A6D785" LS \ B Guacamole Green
           "#74BBFB" LS \ S Ice Blue

           "#74BBFB" LS \ S Ice Blue
           "#C8F526" LS \ B Safety Vest Green

           "#1464F4" LS \ dS Butterfly Blue
           "#5EDA9E" LS \ dB Fresh Green

           "#DC143C" LS \ M Crimson Red
           "#964514" LS \ R Mars Orange
           "#FF6103" LS \ tR Cadmium Orange
           "#FF6103" LS \ M Copper (Cadmium Orange)

           "#74BBFB" LS \ S Ice Blue
           "#AAAAFF" LS \ tS0 Periwinkle Blue
           "#1E90FF" LS \ tS1 Dodger Blue
           "#67C8FF" LS \ tS2 Neon Blue
           "#1464F4" LS \ tS3 Butterfly Blue

           "#C8F526" LS \ B Safety Vest Green
           "#9D8851" LS \ tB0 Canvas Green
           "#5EDA9E" LS \ tB1 Fresh Green
           "#BCED91" LS \ tB2 Mist Green
           "#4CBB17" LS \ tB3 Kelly Green

           "#FF0000" LS \ tS1 Red
           "#FF6103" LS \ tB1 Cadmium Orange 

           "#AAAAFF" LS \ D1 Periwinkle Blue
           "#90FEFB" LS \ tD1 Cool Mint Blue
           "#C8F526" LS \ D2 Safety Vest Green
           "#00FFCC" LS \ tD2 Light Teal 

           "#FFD700" LS \ tP0 Gold
           "#A68064" LS \ tP1 Medium Wood
           "#734A12" LS \ tP2 Raw Umber
           "#964514" LS \ tP3 Mars Orange

           "#CDD704" LS \ tP3U Fire Truck Green
           "#74BBFB" LS \ tP3D Ice Blue

\          "#3F602B" LS \ b Douglas Fir Green
           "#4CBB17" LS \ S3 Kelly Green
           "#9D8851" LS \ S2 Canvas Green
           "#C8F526" LS \ S1 Safety Vest Green

          \"#3063A5" LS \ s Mailbox Blue
           "#1E90FF" LS \ B1 Dodger Blue
           "#AAAAFF" LS \ B2 Periwinkle Blue
           "#99CDC9" LS \ B3 Wave Crest Blue

"#90FEFB" LS \ cool mint (light blue)
"#00FFCC" LS \ light teal(Safe Hex3) (light green-turquoise)

           "#DFFFA5" LS \ U3 Melonrind Green 
           "#99CDC9" LS \ B1 Wave Crest Blue

           "#86C67C" LS \ tU0 Euro Green 
           "#BCED91" LS \ tU1 Mist Green

           "#1464F4" LS \ tD0 Butterfly Blue
           "#05E9FF" LS \ tD1 Indiglo Blue

           "#D44942" LS \ tP0 Chili Brown
           "#DC143C" LS \ tP1 Crimson Red
           "#9E0508" LS \ tP2 Burgundy 
           "#8B4500" LS \ tP3 Dark Orange

           "#228B22" LS \ B2 Forest Green 

           "#FF6103" LS \ tP0 Cadmium Orange 
           "#DC143C" LS \ tP1 Crimson Red

           "#1464F4" LS \ dS Butterfly Blue
           "#5EDA9E" LS \ dB Fresh Green 

           "#93DB70" LS \ BX Yellow Green
           "#CDD704" LS \ BV Fire Truck Green 

           "CadetBlue3" LS \ SV Cadet Blue
           "#1E90FF" LS \ tS Dodger Blue
           "#99CDC9" LS \ S1 Wave Crest Blue

           "#9E0508" LS \ tP2 Burgundy 
           "#8B4500" LS \ tP3 Dark Orange

           "#1464F4" LS    \ tM Butterfly Blue
           "SteelBlue4" LS \ S1 Steel Blue
           "CadetBlue3" LS \ V1 Cadet Blue

           "#228B22" LS         \ tN Forest Green 
           "DarkOliveGreen4" LS \ B1 Olive Green
           "#CDD704" LS         \ V2 Fire Truck Green 

"#525C65" LS \ blue dog (dark grey blue)
"#525C65" LS \ C1 Grey Dog
Greys:
"#E0DFDB" LS \  stainless steel  (white)
"#D0D2C4" LS \  battleship (light grey-white)
"#D8D8BF" LS \ wheat (light grey-white)
"#C6C3B5" LS \  ash (medium grey-white)
"#CBCAB6" LS \ fog (medium grey-white)
"#6F7285" LS \ dolphin (grey-white)
"#A9ACB6" LS \ aluminum (good silver) 
"#B6C5BE" LS \ brushed aluminum
"#808069" LS \ warmgrey (medium grey green)
"#615E3F" LS \ tank (dark grey, faint olive)
"#5A6351" LS \ lizard (very grey green)
"#636F57" LS \ cactus (grey green)
"#586949" LS \ broccoli (grey green)
"#484D46" LS \ park ranger (very grey grey green)
"#46523C" LS \ od green (very dark grey green)
"#596C56" LS \ snake (dark grey green
"#CDCDC1" LS \ ivory3 medium 
"#8B8B83" LS \ ivory4 medium
"#999999" LS \ gray60(Safe Hex3) medium 
"#696969" LS \ dimgrey(SVG) (gray41)

"#525C65" LS \ blue dog (dark grey blue)
"#584E56" LS \ blue corn chips (dark grey; purplish)
"#517693" LS \ malta blue (medium, greyish)
"#4A777A" LS \ fenway monster blue (not too blue (greenish), good grey blue)
"#42647F" LS \ blue whale (dark, greyish)

"#292421" LS \ ivoryblack (charcoal, like Grey15) 
"Grey20"  LS \ P Charcoal
"Grey25"  LS \ P3 Charcoal (lighter charcoal)
"Grey30"  LS \ Charcoal (lighter)
"Grey10"  LS \ PL Dark Charcoal
"Grey57"  LS \ P Silver
"#E6E8FA" LS \ silver (kind of too white)
"#A2B5CD" LS \ Lightsteelblue3, Old Silver 
"#6E7B8B" LS \ Lightsteelblue4, Old Old Silver  (darkest)  

"#C1F0F6" LS \ pastel blue (very white)
"#B0E0E6" LS \ powderblue(SVG) (very white)
"#99CDC9" LS \ S1 Wave Crest Blue (light; more white than CadetBlue3)
"#74BBFB" LS \ blue ice (light)
"#67C8FF" LS \ neonblue2 (light (nice, not too white))
"#05E9FF" LS \ indiglo blue (light; goes well with neon green)
"#9BC4E2" LS \ cerulean blue (light whitish grey)
"#6183A6" LS \ lake erie (Grey Blue)
"#88ACE0" LS \ blue cow (light grey blue)
"#008080" LS \ teal blue
"#39B7CD" LS \ tS2 NYPD Blue (medium light, very slight hint of turq)
"#3579DC" LS \ parrot blue (medium)
"#0276FD" LS \ picasso blue (nice medium, a little brighter than ulysses butterfly)
"#1464F4" LS \ ulysses butterfly blue (nice, almost stained glass)
"#1E90FF" LS \ dodgerblue (medium) 
"#1874CD" LS \ dodgerblue3 (medium dark)
"#4D4DFF" LS \ neonblue (medium dark; slate-like)
"#1D7CF2" LS \ peafowl blue (medium dark)
"#4973AB" LS \ blue bird (medium dark grey blue)
"#7171C6" LS \ sgislate blue (slate (purplish) medium dark)
"#3063A5" LS \ mailbox blue (dark)
"#003F87" LS \ sign blue  (very dark; nice dark blue)
"DodgerBlue4" LS \ L1 Dark Dodger Blue (nice dark blue)
"#584E56" LS \ blue corn chips (dark grey; purplish)
"#525C65" LS \ blue dog (dark grey blue)
"#517693" LS \ malta blue (medium dark, greyish)
"#42647F" LS \ blue whale (dark, greyish)
"#4A777A" LS \ fenway monster blue (not too blue (greenish), good grey blue)
"#236B8E" LS \ steel blue (medium dark)
"#2F4F4F" LS \ darkslategrey (dark grey blue)
"#3A5894" LS \ blue train (dark blue)
"#22316C" LS \ delft (dark midnight blue)
{
[dale@plunger] /home/dale > tops
         Tops 3.2.0
Sat May 29 10:27:27 PDT 2010
[tops@plunger] ready > 'delft' define
delft
 /delft/ noun glazed earthenware, typically decorated in blue on a
   white background.  ORIGIN named after the town of Delft in the
   Netherlands, where it originated.
}
"#000060" LS \ Dark Blue (imix)

"#DC143C" LS \ tC1 Crimson
"#9E0508" LS \ tC2 Burgundy 
"#8B4500" LS \ tC3 Dark Orange

"#3A66A7" LS \ tS Blue Bus 
"#006400" LS \ tB Dark Green

"#4DBD33" LS \ tB1 Grass 
"#007FFF" LS \ tS1 Slate Blue

"#4DBD33" LS \ tB1 Grass 
"#2E37FE" LS \ tS1 Glass Blue

"#DC143C" LS \ tP Crimson
"#EE7600" LS \ tM0 Copper
"#D44942" LS \ tN0 Chili 

"#8AA37B" LS \ tB1 Quartz Green
"#007FFF" LS \ tS1 Slate Blue

"#9D8851" LS \ tB2 Canvas Green

"#83F52C" LS \ Neon Green 
"#2E37FE" LS \ Glass Blue

"#397D02" LS \ tB1 Pepper Green
"#397D02" LS \ B1 Pepper Green
"#668E86" LS \ dB0 Ash Green

"#EEB4B4" LS \ rosybrown2 (pinkish white)
"#551011" LS \ burntsienna (very dark, reddish)

Purples; violet is the darkest:
"#694489" LS \ purple rain
"#71637D" LS \ garden plum 
"#FF83FA" LS \ orchid1 
"#5C246E" LS \ ultramarineviolet 
"#4F2F4F" LS \ violet 

Varying red with constant green makes the difference between
maHogany and muD:
"#3A1800" LS \ mahogany (imix)
"#3F1800" LS \ mahogony2 (imix, lighter)
"#4A1800" LS \ mahogany1 (imix, even lighter)
"#2F1800" LS \ mud (imix)
"#201800" LS \ dark mud (imix)
"#691F01" LS \ maroon5 (dark red, not maroonish; lighter than burntsienna)
"#330000" LS \ darkcherryred(Safe Hex3) very dark 
"#872657" LS \ raspberry (dark red; sort of magenta)
"#8C1717" LS \ scarlet (nice dark red; darker than burgundy and crimson)
"#9E0508" LS \ burgundy (darker red)
"#E3170D" LS \ cadmiumreddeep (a lot like crimson)
"#CC1100" LS \ bloodorange(Hex3) (quite red, like crimson)
"#DC143C" LS \ crimson(SVG) 
"#FF0000" LS \ red(Safe 16 SVG Hex3) 
"#FF5333" LS \ safety cone red (red-orange; a lot like cadmiumorange)
"#D44942" LS \ chili (orange, sort of salmon)

"#CDAF95" LS \ U Peachpuff3 
"#FF6103" LS \ U Cadmium Orange 
"#5959AB" LS \ T1 Rich Blue 
"#688571" LS \ T2 Pound Green

"#2E473B" LS \ tB Lampblack Green (nice dark green)

"#FF9955" LS      \ K5 Peach 
"#E9C2A6" LS      \ K5 Light Wood 

"#FFFF00" LS \ yellow (Safe 16 SVG Hex3) 
"#C8F526" LS \ safety vest (light green yellowish; like fire truck)
"#FFE303" LS \ cadmium lemon 
"#ED9121" LS \ carrot 
"#FFA500" LS \ orange(SVG; very yellow) 
"#FF6600" LS \ orange(Safe Hex3) 
"#FFA812" LS \ naplesyellowdeep 
"#FBEC5D" LS \ corn 
"#F3E88E" LS \ grapefruit 

"#9D8851" LS \ canvas (nice olive/khaki greenish)
"#BDB76B" LS \ darkkhaki(like canvas) 
"#8FA880" LS \ green cheese (good greyish green, counter to blue cow)
"#CFD784" LS \ celery (light green yellowish)
"#D1E231" LS \ pear (light green yellowish; more green than celery)
"#CDD704" LS \ fire truck green (yellow green)
"#A6D785" LS \ guacamole (yellow green; more green than fire truck) 
"#A2BC13" LS \ kermit green (yellow green like firetruck)
"#98A148" LS \ avacado green (brass green)
"#808000" LS \ olive green 
"#4F4F2F" LS \ darkolivegreen 
"#668014" LS \ chrome oxide green (good olive)
"#00FF66" LS \ neonavocado(Safe Hex3) 

Grey greens:
"#353F3E" LS \ army uniform (grey green, not very green)
"#284942" LS \ cooler (grey green, not very green)
"#213D30" LS \ packer green (darker grey green)

"#92CCA6" LS \ pastel green (like guacamole)
"#96C8A2" LS \ eaton blue (light green)
"#006B54" LS \ sign green (medium green, kind of bluish)
"#526F35" LS \ fenway grass (nice medium green, slight olive)
"#068481" LS \ sea green (some turquoise)
"#4A766E" LS \ darkgreencopper
"#6A8455" LS \ green hornet (slight olive, greyish)
"#3B5323" LS \ romaine lettuce
"#3D5229" LS \ wet moss (close to romaine lettuce, a tad lighter)
"#324F17" LS \ limerind (like wet moss)
"#006400" LS \ darkgreen2
"#2F4F2F" LS \ darkgreen (darker than #006400, darkgreen2)
"#004F00" LS \ dumpster (darker than #2F4F2F, darkgreen)
"#003F00" LS \ Dark Dumpster Green (imix)
"#003000" LS \ Dark Green (imix)
Search for "truegreen" for medium greens below

"#FFCC11" LS \ mustard(Hex3) 
"#FF9955" LS \ peach(Hex3) 
"#E9C2A6" LS \ lightwood 
"#A68064" LS \ mediumwood 
"#855E42" LS \ darkwood 
"#8B4500" LS \ darkorange4 (similar to mars orange)
"#CD6600" LS \ darkorange3 
"#FF8C00" LS \ darkorange(SVG) 
"#8A3324" LS \ burntumber 
"#FF6103" LS \ cadmiumorange 
"#FF3300" LS \ nectarine(Safe Hex3) 
"#FF5333" LS \ safety cone red (red-orange; a lot like cadmiumorange)
"#E47833" LS \ mandarineorange (lighter than cadmiumorange)
"#DD7500" LS \ sign orange 
"#964514" LS \ mars orange (dark, similar to darkorange4)
"#EDC393" LS \ light copper
"#FCD59C" LS \ bread (similar to light copper)
"#EE7600" LS \ darkorange2 (good copper)
"#EE7600" LS \ tM Copper
"#B87333" LS \ copper 
"#D98719" LS \ cool copper (good gold or brass)
"#B5A642" LS \ brass
"#FF6666" LS \ seattle salmon(Safe Hex3) 
"#F08080" LS \ lightcoral(SVG) 
"#B13E0F" LS \ kidney bean (rust)
"#993300" LS \ chocolate(Safe Hex3) 
"#AA5303" LS \ coffee (less red version of kidney bean (rust))
"#7B3F00" LS \ cinnamon (dark; lighter version of sign brown)
"#603311" LS \ sign brown (very dark)
"#5E2612" LS \ sepia (medium-dark brown; darker than cinnamon)
"#5C3317" LS \ bakerschocolate (darker than sign brown)
"#734A12" LS \ raw umber (dark)
"#97694F" LS \ darktan (pinkish flesh)
"#8B7D7B" LR \ mistyrose4 (pinkish, flesh) 
"#A78D84" LS \ sandstone (pinkish)
"#5C4033" LS \ verydarkbrown (not really very dark; more like dust)
"#8B5A2B" LS \ tan4 
"#A0522D" LS \ sienna
"#8E6B23" LS \ sienna2 (more brown, less red than sienna)
"#8B7D6B" LS \ bisque4
"#8C7853" LS \ bronze (darker than bisque4)
"#8B7E66" LS \ wheat4

"#FFD700" LS \ tP Gold 
"#FFA022" LS \ Gold (imix) \ C Gold
"#FFA022" LS \ Goldenrod
"#CFB53B" LS \ oldgold 

"#9FB6CD" LS \ slategray3 (light grey blue)
"#BCD2EE" LS \ lightsteelblue2 (light grey blue)
"#C3E4ED" LS \ robin's egg (light, white)
"#63D1F4" LS \ surf (light, similar to indiglo blue)
"#739AC5" LS \ seurat blue (grey blue light)
"#AAAAFF" LS \ periwinkle(Hex3) blue (light grey blue, hint of purple)
"#00FFFF" LS \ aqua(Safe 16 SVG Hex3)  (light Cadet Blue like surf)
"#99CDC9" LS \ wavecrest blue (light and greyish)
"#0198E1" LS \ topaz blue (medium light)
"#8470FF" LS \ lightslateblue (purplish and kind of dark)
"#35586C" LS \ pacific blue  (dark grey blue; greenish)
"#236B8E" LS \ steel blue (medium dark)
        
"#838EDE" LS \ nikko blue (darker version of periwinkle (purplish))
"#6666FF" LS \ cobalt(Safe Hex3) (dark, purplish)
"#67E6EC" LS \ swimming pool blue (kind of turquoise)
"#B2DFEE" LS \ lightblue2 (whitish)

"#05E9FF" LS \ indiglo blue (light; goes well with neon green)
"#0EBFE9" LS \ diamond blue (light)
"#0099CC" LS \ skyblue5(Safe Hex3) 
"#007FFF" LS \ slateblue 

"#CDD704" LS \ fire truck green 
"#646F5E" LS \ seaweed  (green, greyish)
"#629632" LS \ green apple 
"#86C67C" LS \ 100 euro green (medium light)
"#00AF33" LS \ truegreen (medium)
"#3F9E4D" LS \ green taxi (medium)
"#397D02" LS \ green pepper 
"#8AA37B" LS \ green quartz (medium, greyish)
"#55AE3A" LS \ leaf 
"#BCED91" LS \ greenmist
"#00AA7F" LS \ B1 Slate Green (imix)
"#93DB70" LS \ greenyellow (like guacamole, good for light green)
"#DFFFA5" LS \ melonrindgreen (whitish yellow green)
"#40E0D0" LS \ turquoise(SVG) green
"#0FDDAF" LS \ turquoise green (light greenish)
"#B4D7BF" LS \ vanilla mint green (very white)
"#92CCA6" LS \ pastel green 

           "#6183A6" LS      \ P1 Lake Erie Blue
           "DeepSkyBlue3" LS \ P2 Sky Blue
           80 Burlywood LS   \ P3 Dark Wood
           50 Coral LS       \ P4 Copper
           "#008B00" LS      \ P5 Green4
           "#668E86" LS      \ P6 Ash Green

           "#05E9FF" LS      \ U1 Indiglo Blue
           "DeepSkyBlue3" LS \ U2 Sky Blue
           "#007FFF" LS      \ U3 Slate Blue 
           70 Blue1 LS       \ U4 Royal Blue
           "#CDD704" LS      \ U5 Green Fire Truck (1-quarter)
           "#05E9FF" LS      \ U6 Indiglo Blue
           50 Coral LS       \ U7 Copper           (median)
           "DeepSkyBlue3" LS \ U8 Sky Blue
           "#CDD704" LS      \ U9 Green Fire Truck (3-quarter)
           "#007FFF" LS      \ UA Slate Blue 
           70 Blue1 LS       \ UB Royal Blue

           "#32CD32" LS      \ V1 Lime Green
           "#8AA37B" LS      \ V2 Quartz Green 
           40 Green LS       \ V3 Green
           90 Green1 LS      \ V4 Dark Green
           "#CDD704" LS      \ V5 Green Fire Truck (1-quarter)
           "#32CD32" LS      \ V6 Lime Green
           50 Coral LS       \ V7 Copper           (median)
           "#8AA37B" LS      \ V8 Quartz Green 
           "#CDD704" LS      \ V9 Green Fire Truck (3-quarter)
           40 Green LS       \ VA Green
           90 Green1 LS      \ VB Dark Green
}
        end (hList)

           "#8B8989" LS \ U1 Snow4 
           "#8B6969" LS \ U2 Rosy Brown4 
           "#BC8F8F" LS \ U3 Rosy Brown
           "#C67171" LS \ U4 Sgi Salmon
           "#B6AFA9" LS \ U5 Titanium 
           "#964514" LS \ U6 Mars Orange 
           "#CD5555" LS \ U7 Indian Red3 
           "#8E2323" LS \ U8 Firebrick5 
           "#855E42" LS \ U9 Dark Wood 

           "#B13E0F" LS \ kidney bean (rust)
           "#AA5303" LS \ coffee 
           "#603311" LS \ sign brown (very dark)
           "#7B3F00" LS \ cinnamon 

           "#3E7A5E" LS \ Ooze (green)
           "#3A66A7" LS \ Blue Bus 

           "#CDAD00" LS \ gold3 
           "#B5A642" LS \ Brass
           "#E3A869" LS \ Melon 
           "#ED9121" LS \ Carrot 
           "#F3E88E" LS \ Grapefruit 

"#D9D919" LS \ brightgold 
"#8B7500" LS \ gold4 
"#FCB514" LS \ packer gold 
"#993300" LS \ chocolate(Safe Hex3) 
"#F4A460" LS \ sandybrown(SVG) 
"#CDAF95" LS \ peachpuff3 
"#B6AFA9" LS \ titanium 
"#A68064" LS \ medium wood 

        Useful color sets:

           "#B6AFA9" LS \ tP Titanium

           "#2E37FE" LS \ tL Glass Blue
           "Grey20" LS  \ tK2 Grey
           70 Coral LS  \ tM Copper
           "Grey20" LS  \ tK6 Grey
           "#32CD32" LS \ tH Lime Green

           "#3E7A5E" LS \ Gs Ooze Green
           "#3A66A7" LS \ Bs Bus Blue

           "FireBrick3" LS \ tM1 Red
           "Maroon3" LS    \ tM2 Maroon
           "SteelBlue3" LS      \ L1g Steel Blue
           "DarkOliveGreen4" LS \ H1g Olive Green

           "#FCD59C" LS         \ tN1 Bread
           "#E3A869" LS         \ tn2 Melon
           "#A68064" LS         \ L2g Wood
           70 Burlywood LS      \ H2g

           50 Sienna LS    \ s1 Sienna
           80 Sienna LS   \ s3 Dark Sienna
           "SteelBlue4" LS \ s2 Steel Blue
           "#215E21" LS       \ q4 Hunter Green

           "DarkSeaGreen3" LS \ h1
           "Aquamarine3" LS   \ h2
           0 Green LS         \ h3 Light Green

           "LightBlue2" LS   \ l1
           "SteelBlue2" LS   \ l2 Steel Blue
           "DodgerBlue2" LS  \ l3 Dodger Blue

           "DarkOliveGreen4" LS \ H1 Olive Green
           "Chartreuse4" LS     \ H2
           "OliveDrab3" LS      \ H3 Neon Green

           "RoyalBlue2" LS   \ L1 Dark Cadet Blue
           "DeepSkyBlue3" LS \ L2 Sky Blue
           "CadetBlue3" LS   \ L3 Cadet Blue

           90 Sienna LS    \ s1 Sienna
           "SteelBlue3" LS \ s2 Steel Blue
           110 Sienna LS   \ s3 Dark Sienna
           0 Blue1 LS      \ s4 Blue

           40 Red LS       \ s5 Red

           "#808800" LS    \ s6 Olive Green
           80 Coral LS     \ s7 Dark Copper
           0 Green LS      \ s8 Green
           65 Coral LS     \ s9 Copper

           "PeachPuff3" LS    \ VH Peach
           "PeachPuff3" LS    \ VL Peach
           "#F3E88E" LS       \ VM Grapefruit 

         \ "t1" "t2" "t3" "t4" "t5" "t6"
           "SlateBlue3" LS
           "RoyalBlue3" LS
           "DodgerBlue3" LS
           "SpringGreen4" LS
           "Chartreuse4" LS
           "DarkOliveGreen4" LS

           "DeepSkyBlue1" LS    \ p1t Sky Blue
           "SteelBlue4" LS      \ p2t Steel Blue
           80 Coral LS          \ p3t Dark Copper
           "DarkOliveGreen4" LS \ p4t Olive Green
           "OliveDrab3" LS      \ p5t Neon Green

           "DarkGoldenrod3" LS                    \ xR1 Old Gold
           "#FFA022" LS \ Gold (imix)             \ xS2 Gold
           "#AB8508" LS \ Dark Goldenrod (imix)
           "#8B6508" LS \ darkgoldenrod4 
           "#8B6914" LS \ goldenrod4 
           "#CD9B1D" LS \ goldenrod3 
           "#B8860B" LS \ darkgoldenrod(SVG) 
           "#FCD59C" LS \ bread 

           "#A2B5CD" LS \ P1 Old Silver (12 hours ago)
           "#A2B5CD" LS \ Lightsteelblue3, Silver \ xS1 Old Silver

           "#CCDBCD" LS \ Silver (good imix 2)    \ xR2 Silver
           "#E6E8FA" LS \ silver 
           "#DCDCDC" LS \ gainsboro(SVG) (silver)

           "DeepSkyBlue1" LS  \ p1 Sky Blue
           30 Blue LS         \ p2 Blue
           30 Coral LS        \ p3 Copper
           40 Green LS        \ p4 Green
           "OliveDrab3" LS    \ p5 Neon Green

         \ Repeat the 5 previous pairs (color, LS) for the matching
         \ colors and lines of the traces, p1t, p2t, ... p5t:
           10 1 DO 9 pick LOOP

           55 Burlywood LS    \ s1l Pine
           80 Burlywood LS    \ s5 Dark Pine

           "SteelBlue4" LS    \ q1 Steel Blue
           80 Tan LS          \ q2 Dark Pine
           80 Coral LS        \ q3 Dark Copper
           "#215E21" LS       \ q4 Hunter Green

           "CadetBlue2" LS    \ p1 Cadet Blue
           20 Blue LS         \ p2 Blue
           30 Coral LS        \ p3 Copper
           40 Green LS        \ p4 Green
           "OliveDrab3" LS    \ p5 Neon Green

           "CadetBlue2" LS    \ R1 Cadet Blue
           "DeepSkyBlue3" LS  \ R2 Sky Blue
           "#6183A6" LS       \ R3 Lake Blue
           0 Red LS           \ R4 Red

           "#83F52C" LS       \ S1 Neon Green
           "SeaGreen3" LS     \ S2 Sea Green
           "OliveDrab4" LS    \ S3 Olive Green
           20 Coral LS        \ S4 Copper

           "#6183A6" LS       \ s3 Lake Blue
           "OliveDrab4" LS    \ s4 Olive Green
           "SeaGreen3" LS     \ s5 Sea Green
           "#83F52C" LS       \ s6 Neon Green

           55 Burlywood LS    \ s1l Wood
           80 Burlywood LS    \ s2l Dark Wood
           70 Coral LS        \ s5l Dark Copper
           30 Coral LS        \ s6l Copper

           0 Red LS           \ M Red

           "#83F52C" LS       \ s102 Neon Green
           \"SeaGreen3" LS     \ s101 Sea Green

           "DeepSkyBlue3" LS  \ b102 Sky Blue
           "CadetBlue2" LS    \ b101 Cadet Blue

           -5 Blue LS         \ xR1 Blue
           0 Red LS           \ xR2 Red

           -20 Green1 LS      \ xS1 Green
           20 Coral LS        \ xS2 Copper

           55 Burlywood LS           \ xM1 Wood
           80 Burlywood LS           \ xM2 Dark Wood

           30 Coral LS               \ xN1 Copper
           70 Coral LS               \ xN2 Dark Copper

           20 Red LS                         \ tM Red
           80 Red LS                         \ M Dark Red

           \"SlateBlue4" LS                   \ tQ4 Steel Blue
           \"SteelBlue4" LS                   \ tQ4 Steel Blue
           "DodgerBlue3" LS                  \ tQ4 Dodger Blue

         \ Different olive greens:
           "#808000" LS \ olive 
           "OliveDrab4" LS    \ s5 Olive Green
           "#807000" LS \ Olive dark (imix)  \ tQ1 Olive Green
           "DarkOliveGreen4" LS 
           "#808800" LS \ olive green (imix) \ Olive Green

           \"SpringGreen4" LS  \ S2 Spring Green
           "#009800" LS \ Green glass (imix) \ tQ1 Glass Green
           "#2E37FE" LS \ Stained glass blue \ Q4 Glass Blue
           "SteelBlue3" LS                   \ tS1 Steel Blue
           "#FCD59C" LS \ Bread              \ tS2 Bread
           "DodgerBlue4" LS                  \ tS2 Dodger Blue
           "#007000" LS \ green4 (mix)       \ tB2 Dark Green

         \ 80 Coral LS  \ S102
         \ 90 Burlywood LS \ B102
           "DarkGoldenrod4" LS

           "#FFA022" LS \ Gold (imix) \ P2
           "LightGoldenrod3" LS \ straw \ P1

           -10 Purple LS \ H2
           80 Magenta LS \ L2

           Grey15 LS \ eH3 through eL1 (six curves)
           "#B6C5BE" (brushed aluminum) LS
           -10 Blue LS \ R2
           0 Green1 LS \ S2
           20 Blue LS   \ s1
           20 Green1 LS \ b1
          \"#00A800" LS \ stained glass green (imix)
           \"#668E86" LS \ green ash \ b2t
           "#37FE2E" LS (green1, imix) \ l4fast
           50 Green LS                 \ l4slow

           -10 Purple LS               \ s1
           80 Magenta LS               \ b1
           15 Blue LS                  \ wS
           -10 Blue LS                 \ wSV

           70 Blue1 LS                 \ s21
           70 Blue1 LS                 \ s22
           70 Blue1 LS                 \ s23

           15 Green1 LS                \ wB
           "#37FE2E" LS (green1, imix) \ wBV

           90 Green LS                 \ b21
           90 Green LS                 \ b22
           90 Green LS                 \ b23

         \ "Orchid3" LS        
         \ "VioletRed3" LS    
         \ "BlueViolet" LS    
         \ "Maroon4" LS       
           -10 Purple LS
           80 Magenta LS

           "SteelBlue3" LS              \ Pa2
           "#668E86" LS \ GreenAsh      \ Pb2

           60 Coral LS                 \ sb
           60 Burlywood LS             \ mb
           20 Coral LS                 \ rb
           -10 Blue LS                 \ ts2
           60 Burlywood LS             \ tm
           "#37FE2E" LS (green1, imix) \ tr1
           25 Blue LS                  \ ts1
           40 Green1 LS                \ tr2
           25 Blue LS                  \ s1
           40 Green1 LS                \ r2

           "DodgerBlue2" LS            \ S2
           "DarkOliveGreen4" LS        \ R2

           "SteelBlue3" LS \ tS1
           "#668E86" LS \ green ash \ tL1
           "#37FE2E" LS \ green mix
           "SteelBlue3" LS 
           "#527F76" LS \ greencopper 

           "#FFA022" LS \ Gold (imix)   \ M1
           "#28AE7B" LS \ EmeraldGreen2 \ L1
           "DodgerBlue2" LS             \ S2

"#329555" LS \ green line 
"#3E7A5E" LS \ ooze (medium dark)
"#228B22" LS \ forestgreen (SVG) (medium dark)
"#3D9140" LS \ cobaltgreen (medium dark nice green)
"#4CBB17" LS \ Kelly Green (medium)
"#1DA237" LS \ bottle green
"#008B00" LS \ green4
"#00CD00" LS \ green3 
"#006400" LS \ darkgreen(SVG) (darker than green4)
"#3F602B" LS \ douglas fir (dark green)
"#2E473B" LS \ lampblack (dark green)
"#215E21" LS \ huntergreen 
"#00CD66" LS \ springgreen3 

"Maroon3" LS \ Ctr
"#52AFA6" LS \ imix from greencopper 

\ Next three in order of brightness, least to most bright:
"#4DBD33" LS \ grass 
"#4AC948" LS \ wales (green)
"#32CD32" LS \ limegreen(SVG) 

"#5EDA9E" LS \ fresh green 
"#458B00" LS \ chartreuse4
"#28AE7B" LS \ emeraldgreen2 
"#238E68" LS \ seagreen 
"#66CDAA" LS \ mediumaquamarine(SVG) 

"#3B8471" LS \ blue green algae 
"#668E86" LS \ green ash
"#527F76" LS \ greencopper 
"#3E766D" LS \ green gables 
"#A0C510" LS \ olive green (imix)
"#808800" LS \ olive green (imix)      \ tL Olive Green
        
"#283A90" LS \ Pabst Blue (dark)
"#3A66A7" LS \ big blue bus (medium dark) 
"#8EE5EE" LS \ cadetblue2 (whitish like indiglo blue)
"#39B7CD" LS \ nypd blue 

"#3B6AA0" LS \ greek roof 
"#003F87" LS \ sign blue  (very dark)
"#75A1D0" LS \ blueberry (light)
"#007FFF" LS \ slateblue 

           "#FCD59C" LS \ Bread (good name for money curve)
           "#CCDBFF" LS \ Silver (good imix) 
           "#FFA022" LS \ Gold (good imix)

           "#00B088" LS \ Medium green (imix)
           "#0077FF" LS \ Medium blue (imix)
           "#8FBC9F" LS \ Sea Green (imix) 
           "#CCCCFF" LS \ offwhiteblue(Safe Hex3) 
           "#FFD700" (Gold) LS 
           "#CCCCCC" LS \ grey80(Safe Hex3) silver
           "#00FFCC" LS \ light teal(Safe Hex3) 
           "#00FA9A" LS \ mediumspringgreen(SVG) 
           "#00FF00" LS \ lime(Safe 16 SVG Hex3) 
           "#5DFC0A" LS \ green LED 
           "#83F52C" LS \ neon green (goes well with indiglo blue)
"#93DB70" LS \ greenyellow (like guacamole, good for light green)
           "#668E86" LS \ green ash 
           "#2E37FE" LS \ stained glass (blue)
           "#8FBC8F" LS \ darkseagreen(SVG) (medium darkness)
           "#3B8471" LS \ blue green algae 
           "#008000" LS \ green(16 SVG) 
           "#0AC92B" LS \ permanentgreen 
           "#0276FD" LS \ picasso blue 

           "#5959AB" LS \ richblue (medium grey blue (purplish))
           "#688571" LS \ england pound (grey green) 
           "#7171C6" LS \ sgislate blue 
           "#7B68EE" LS \ mediumslateblue(SVG) (purplish) 

           "#CCCCCC" (Grey80) LS 
           "#D6D6D6" (Grey84) LS
           "#CC7F32" (Gold5) LS
           "#FFAA00" (Gold7) LS
           "#E8F1D4" (Chrome) LS
           "#FFD700" (Gold SVG) LS

----------------------------------------------------------------------*/
