{  File ino.v  October 2007

   Copyright (c) 2007-2010   D. R. Williamson

   Words for fetching data from quotes.ino.com

   Updated November 2010
      A huge number of spread prices appeared, causing processing speed
      to grind to a halt.  

      Some idiot appears to have programmed every combination of month-
      to-month spreads, an N-squared explosion, something like 

         N*(N+1)/2 - N 

      spreads for N contract months.

      CL has about 67 months, so this produced about 2211 spreads and 
      took a couple of minutes to process before they were all finally
      extracted and then tossed because they aren't wanted.

      Changes in inoPROCESS were made to remove spread data at a very 
      early step, eliminating the speed problem.  

      A few days after these changes were made, the site must have
      realized the problem because the huge number of spreads dis-
      appeared.  These lines from the CL collector log file, each 
      about 7 minutes apart, show the dramatic difference due mainly
      to download time as the file became much smaller:

         [dale@plunger] /tmp > ll CL*
         -rw-rw-rw-    1 dale     comm  110893 Nov 11 10:02 CL.eLOG
         -rw-rw-rw-    1 dale     comm  222307 Nov 11 10:03 CL.hLOG
         -rw-rw-rw-    1 dale     comm    4065 Nov 11 10:02 CL_IN.eDAT
         -rw-rw-rw-    1 dale     comm     155 Nov 11 10:03 CL_TC1.eDAT
         [dale@plunger] /tmp > grep 'Elapsed msec:' CL.eLOG
         ...
         CL.eLOG: Elapsed msec: 23138
         CL.eLOG: Elapsed msec: 35613
         CL.eLOG: Elapsed msec: 21367
         CL.eLOG: Elapsed msec: 25021
         CL.eLOG: Elapsed msec: 20904
         CL.eLOG: Elapsed msec: 11774
         CL.eLOG: Elapsed msec: 21684 <<< Wed Nov 10 20:58:40 PST 2010
         CL.eLOG: Elapsed msec: 3267  <<< Wed Nov 10 21:05:28 PST 2010
         CL.eLOG: Elapsed msec: 2962
         CL.eLOG: Elapsed msec: 1995
         CL.eLOG: Elapsed msec: 2895
         CL.eLOG: Elapsed msec: 3224
         ...

   Updated March 2010 
      Site has changed HTML format, and inoPROCESS was completely
      rewritten.

   Updated January 2008 
      Collect electronic markets data.

   Use inoDATA to run the proper setups and then fetch:
      "sf" inoDATA \ runs inoDECIMAL
      "tn" inoDATA \ runs ino64ths
      "us" inoDATA \ runs ino32nds
      "w"  inoDATA \ runs ino8ths
}
\-----------------------------------------------------------------------

   "tracklist" missing IF " ino.v: require tracklist " . nl halt THEN

   inline: ino8ths (qS --- hT1) \ process numbers in text T
      [ {"
        (hT) "T" book
        T rows 0 blockofblanks "T1" book
        1st "r" book
        BEGIN
           T r word
        WHILE
           numerate 8ths spaced
           T1 swap park "T1" book
           1 r bump
        REPEAT
        T1 (hT)
        "} "inoGRAIN" macro
      ]
    \ Set inoPROCESS.SPECIAL = ptr(ino8ths.inoGRAIN) and then run
    \ word inoPROCESS.
      "ino8ths" "inoGRAIN" localref ptr "inoPROCESS" "SPECIAL" bank
      (qS) inoPROCESS (hT)
   end

   inline: ino32nds (qS --- hT1) \ process numbers in text T
      [ {"
        (hT) "T" book
        T rows 0 blockofblanks "T1" book
        1st "r" book
        BEGIN
           T r word
        WHILE
           numerate 32nds spaced
           T1 swap park "T1" book
           1 r bump
        REPEAT
        T1 (hT)
        "} "inoBOND" macro
      ]
    \ Set inoPROCESS.SPECIAL = ptr(ino32nds.inoBOND) and then run
    \ word inoPROCESS.
      "ino32nds" "inoBOND" localref ptr "inoPROCESS" "SPECIAL" bank
      (qS) inoPROCESS (hT)
   end

   inline: ino64ths (qS --- hT1) \ process numbers in text T
      [ {"
        (hT) "T" book
        T rows 0 blockofblanks "T1" book
        1st "r" book
        BEGIN
           T r word
        WHILE
           numerate 32nds+ spaced
           T1 swap park "T1" book
           1 r bump
        REPEAT
        T1 (hT)
        "} "inoBOND" macro
      ]
    \ Set inoPROCESS.SPECIAL = ptr(ino64ths.inoBOND) and then run
    \ word inoPROCESS.
      "ino64ths" "inoBOND" localref ptr "inoPROCESS" "SPECIAL" bank
      (qS) inoPROCESS (hT)
   end

   inline: ino64ths_tmp (qS --- hT1) \ process numbers in text T
      [ {"
        (hT) "T" book
        T rows 0 blockofblanks "T1" book
        1st "r" book
        BEGIN
           T r word
        WHILE
           numerate 32nds+ 
numerate 10 / 0.5 + integer "%0.0f" format spaced 
           T1 swap park "T1" book
           1 r bump
        REPEAT
        T1 (hT)
        "} "inoBOND" macro
      ]
    \ Set inoPROCESS.SPECIAL = ptr(ino64ths.inoBOND) and then run
    \ word inoPROCESS.
      "ino64ths_tmp" "inoBOND" localref ptr "inoPROCESS" "SPECIAL" bank
      (qS) inoPROCESS (hT)
   end

   inline: inoCOLLECT ( --- hT) \ data from ino
      tracklist "TRACK" book

      time push
      depth push
      "From inoCOLLECT, file ino.v"
      date neat

      "inoDATA" "PIT" yank
      IF "Pit trading" ELSE "Electronic trading" THEN
      "Showing: Open High Low Settle Close Chg Vol OpenInt"

      " "
      TRACK rows 1st
      DO no "inoDATA" "ALL_HOSTS" bank \ just do one host
         TRACK I quote inoDATA any?
         IF "0" "V" book
            "0" "OI" book

            TRACK I quote spaced
            " VOL and OI totals: " cat V cat spaced OI cat neat

            swap

         ELSE TRACK I quote spaced date cat " no data" cat
         THEN
         " "
      LOOP
      depth pull less pilen

      "ET: " time pull less 60 slash "%0.1f" format cat
      " minutes" cat pile

      "_inoCOLLECT" naming
   end

   inline: inoDATA (qS --- hT) \ data for S
      [ true "PIT" book \ default
        no "ALL_HOSTS" book \ default Mar 2010

        "'w'  inoSYM        ino8ths" "w"  macro
        "'c'  inoSYM        ino8ths" "c"  macro
        "'s'  inoSYM        ino8ths" "s"  macro
        "'sm' inoSYM 10  inoDECIMAL" "sm" macro
        "'bo' inoSYM 100 inoDECIMAL" "bo" macro

        "'lc' inoSYM 100 inoDECIMAL" "lc" macro
        "'lh' inoSYM 100 inoDECIMAL" "lh" macro
        "'pb' inoSYM 100 inoDECIMAL" "pb" macro

        "'cc' inoSYM   1 inoDECIMAL" "cc" macro
        "'kc' inoSYM 100 inoDECIMAL" "kc" macro
        "'sb' inoSYM 100 inoDECIMAL" "sb" macro
        "'jo' inoSYM 100 inoDECIMAL" "jo" macro

        "'hg' inoSYM 10000 inoDECIMAL" "hg" macro
        "'gc' inoSYM  10 inoDECIMAL" "gc" macro
        "'pl' inoSYM  10 inoDECIMAL" "pl" macro
        "'si' inoSYM 1000 inoDECIMAL" "si" macro

        "'ct' inoSYM 100 inoDECIMAL" "ct" macro
        "'cl' inoSYM 100 inoDECIMAL" "cl" macro
        "'ho' inoSYM 1E4 inoDECIMAL" "ho" macro
        "'hu' inoSYM 1E4 inoDECIMAL" "hu" macro
        "'ng' inoSYM 1E3 inoDECIMAL" "ng" macro

        "'sf' inoSYM 1E4 inoDECIMAL" "sf" macro
        "'eu' inoSYM 1E4 inoDECIMAL" "eu" macro
        "'jy' inoSYM 1E6 inoDECIMAL" "jy" macro
        "'mp' inoSYM 1E6 inoDECIMAL" "mp" macro
        "'bp' inoSYM 1E4 inoDECIMAL" "bp" macro

        "'us' inoSYM  ino64ths_tmp" "us" macro \ to 64ths 3-04-2008
       \"'us' inoSYM       ino32nds" "us" macro 
        "'tn' inoSYM       ino64ths" "tn" macro
        "'ff' inoSYM 1E3 inoDECIMAL" "ff" macro
        "'ed' inoSYM 1E3 inoDECIMAL" "ed" macro

        "'dj' inoSYM 1  inoDECIMAL" "dj" macro
        "'sp' inoSYM 10 inoDECIMAL" "sp" macro
        "'nq' inoSYM 10 inoDECIMAL" "nq" macro
      \ "'yx' inoSYM 10 inoDECIMAL" "yx" macro
        "'nk' inoSYM 1  inoDECIMAL" "nk" macro
      ]
      " inoDATA: PIT =" . PIT .i nl
      strchop uppercase "S1" book \ tops symbol
      S1 inoSYM any?
      IF "S2" book \ ino symbol

 S1 "CL" = IF yes "ALL_HOSTS" book THEN

         ALL_HOSTS not 
         IF "" "inoGET" "IPuse" bank
          \ Run local word (some form of inoPROCESS()):
            S1 lowercase (qS) local (hT)
            (hT) any?
            IF (hT) S2 S1 strp \ substitute the tops symbol
            ELSE VOL tpurged
            THEN 
         ELSE 

          \ Originally, data was obtained from both hosts because
          \ sometimes one had later data than the other.  Now, this
          \ branch is set up to EXIT if the first host returns any 
          \ data, and run the second if not.  Reviewing the logs
          \ for CL, which sometimes has trouble with the first con-
          \ nection, shows that it works.

            VOL tpurged (hT0)
            "inoGET" "HOST" yank IPhost "IPlist" book 
            IPlist rows (nHosts) any?
            IF host "topsdog" = 
               IF IPlist 1st quote "IPlist" book drop 1 THEN
               (hT0 nHosts) 1st

               DO (hT0) IPlist I quote strchop "inoGET" "IPuse" bank
                \ Run local word (some form of inoPROCESS()):
                  S1 lowercase (qS) local (hT)

                  (hT) any?
                  IF (hT) S2 S1 strp \ substitute the tops symbol
                  ELSE VOL tpurged
                  THEN 
                  (hT0 hT) pile (hT)
                  (hT) dup chars 0> IF EXIT THEN

               LOOP
            THEN (hT)
         THEN
 
      ELSE VOL tpurged (hT)
      THEN

      (hT) "_" S1 lowercase (qS) + naming

      false "ALL_HOSTS" book \ reset the default, Mar 2010
   end

   inline: inoDECIMAL (qS n --- hT) \ process S
      (n) "inoPROCESS" "FAC" bank
      (qS) inoPROCESS (hT)
   end

   inline: inoECOLLECT ( --- hT) \ electronic data from ino
      "inoDATA" "PIT" yank "pit" book
      no "inoDATA" "PIT" bank
      inoCOLLECT "_inoECOLLECT" naming
      pit "inoDATA" "PIT" bank
   end

   inline: inoEDATA (qS --- hT) \ electronic data for S
      "inoDATA" "PIT" yank "pit" book
      no "inoDATA" "PIT" bank
      inoDATA
      pit "inoDATA" "PIT" bank
   end

   inline: inoGET (qS --- hT) \ data from ino.com
      [ "http://quotes.ino.com" "HOST" book
        "" "IPuse" book
      ]
      (qS) "S" book
      time "t0" book

    \ Put the site name into HTTPget.Host_alias and it will go into
    \ the credentials, then use specified IPuse:
      HOST (qHost) "HTTPget" "Host_alias" bank

      IPuse (IP) any? not
      IF HOST THEN
      (qIP) "/exchanges/contracts.html?r=" S + HTTPget (hT)

      (hT) dup chars 0>
      IF S (qS) spaced "inoGET" + spaced
         those textput chars (bytes) time t0 less
         (qS bytes delta) msgSPEED
      THEN
   end

   inline: inoPROCESS (qS --- hT) \ get and process S
      [ \ Defaults:
          no "SPECIAL" book
          1 "FAC" book

        \ OPEN  HIGH  LOW   SETT  LAST   CHG
        " %0.0f %0.0f %0.0f %0.0f c%0.0f %0.0f" "FORM" book

        yes "PRODUCTION" book
 
        {" (qS --- qS1) \ replace month name with a number
           " Jan " " 1 " strp
           " Feb " " 2 " strp
           " Mar " " 3 " strp
           " Apr " " 4 " strp
           " May " " 5 " strp
           " Jun " " 6 " strp
           " Jul " " 7 " strp
           " Aug " " 8 " strp
           " Sep " " 9 " strp
           " Oct " " 10 " strp
           " Nov " " 11 " strp
           " Dec " " 12 " strp
        "} chop "CONMO" macro

        "F G H J K M N Q U V X Z" words "Months" book 

        list: 0 0 0 0 0 1 1 ; "RAKE" book
      ]
      (qS) dup inoSYM' inoTIME "qTIME" book       
      (qS) dup "SYM" book (qS) 

      ercnt push \ monitor the error count from HTTPget (inoGET)

\ no "PRODUCTION" book \ when debugging

      (qS) PRODUCTION
      IF (qS) inoGET (hT) 

    \ ELSE drop "QSF.html" old ascii "BIN" file \ testing
    \ ELSE drop "EU6E.html" old ascii "BIN" file \ testing
    \ ELSE drop "ZC.html" old ascii "BIN" file \ testing
    \ ELSE drop "HG.html" old ascii "BIN" file \ testing
    \ ELSE drop "NG.html" old ascii "BIN" file \ testing
      ELSE drop "CL_ino.html" old ascii "BIN" file \ testing
         BIN INF fget BIN fclose (hT)

      THEN (hT)
      depth 0= IF "" THEN

      ercnt pull - 0<>
      IF drop
         " inoPROCESS: nonzero ercnt after inoGET" . nl "" return 
      THEN

      (hT) any? not 
      IF " inoPROCESS: empty VOL from inoGET" . nl "" return THEN

      (hT) dup "TSAVE" book (hT) 
{
      Tue Nov  9 10:34:53 PST 2010. Map the file early and remove 
      spread data.  

      The spreads are all at the end, so it is easy to split the data 
      beforehand and toss the tail containing the spreads so they are
      never involved in processing.
}
      (hT) dup '<th scope="col">Market</th>' smap any?
      IF (hT hMap) @ split (hT1 hT2)

    \ Tue Nov  9 10:34:53 PST 2010 Removing spread data:
         (hT1 hT2) dup (hT2) "Spread" smap any?
         IF (hT2 hMap) @ split drop THEN \ remove spread data
         (hT1 hT2) "T2" book \ one huge string of prices, no newlines
         (hT1) textget "T1" book \ top of file with newlines

      ELSE (hT) drop
         " inoPROCESS: can't find Market string" . nl "" return 
      THEN

    \ Return empty if no "Date:" string:
      T1 (hT) dup "Date:" grepr any?
      IF (hT hRow) reach words 6 ndx quote "DTIME" book
      ELSE (hT) drop 
         " inoPROCESS: can't find Date: string" . nl "" return
      THEN

      T2 'href="http://quotes.ino.com/chart/?s=' smap "MAP" book
      MAP rows 0= 
      IF " inoPROCESS: MAP has zero rows" . nl "" return THEN

      "inoPROCESS A" ERRset

      MAP 1- 2nd over rows 1- items reach T2 chars pile 
      MAP - "LEN" book

    \ This could be made faster by not piling in the loop and instead
    \ using pilen after all rows are on the stack:
      "" MAP rows 1st DO T2 MAP I pry LEN I pry items catch pile LOOP

      "$" "" qreplace noblanklines           \ remove cash

    \ Tue Nov  9 10:34:53 PST 2010 Removing spread is now done above:
    \ "Spread" "" qreplace noblanklines (hT) \ remove spreads

      (hT) "inoDATA" "PIT" yank
      IF \ if doing pit, remove electronic:
         (hT) "(E)" " " qreplace noblanklines \ remove electronic
      ELSE \ if doing electronic, remove pit:
         (hT) dup "(E)" grepr any?
         IF (hT hR) reach       \ take just the electronic ones
            "(E)" " " strp (hT) \ and remove the E from symbol
         THEN
      THEN
      
      '"rt"></td>' '"rt">0</td>' strp \ zeroes at blank numbers
      ">" " " strp "<" " " strp       \ spaces around numbers
      "set&nbsp;" " " strp      \ remove string that may precede time
      ":" " " strp              \ remove : from time, leaving two nums
      CONMO                     \ convert months to numbers

      "T" book T rows 0> not
      IF " inoPROCESS: T has zero rows" . nl "" return THEN
      
    \ It is assumed that all INO data is decimal--that there are no 
    \ special symbols used in grain and interest rate quotations, like
    \ dashes that separate 8ths and 32nds.
      T asciify 9 matread (hT) "T" book
      T cols 9 <>
      IF " inoPROCESS: T does not have 9 columns" . nl "" return THEN
      T rows 0> not
      IF " inoPROCESS: T has zero rows" . nl "" return THEN
      
      T 8 2 items catch "%02.0f:%02.0f:00" format
      qTIME main "TIME" book
{ 
  Times in array TIME look like these: 

 stack elements:
       0 volume: TIME  6 by 8
 [1] ok!
[tops@plunger] ready > .m
23:20:00
20:35:00
17:03:00
17:03:00
17:03:00
17:12:00
[tops@plunger] ready > 
}

      T 1st 7 items catch "T" book
{
      T .m
 This is an example of T at this point:
             Month   Year   Open     High    Low       Last    Change 
 Row 1:        6     2010   0.9456   0.9495    0.941   0.9445  -0.0021
 Row 2:        9     2010   0.9443   0.9501    0.942   0.9453  -0.0021
 Row 3:       12     2010   0.9481        0    0.947   0.9461  -0.0021
 Row 4:        3     2011   0.9471   0.9471   0.9471   0.9471  -0.0021
 Row 5:        6     2011   0.9481   0.9481   0.9481   0.9481  -0.0021
 Row 6:        9     2011   0.9491   0.9491   0.9491   0.9491  -0.0021
}
    \ Repeat column Last for Settle:
      T RAKE claw (hT1 hT2) T 6 catch swap (hT1 hTLast hT2) 3 parkn

    \ Make SYM+MO+YY from columns 1 and 2 of hT:
      (hT) dup 1st catch "T" book "" T rows 1st
      DO Months T I pry quote pile LOOP noblanklines
      (hT) over 2nd catch 2000 - int$ park SYM nose "CON" book (hT)

      (hT) 3rd 6 items catch "%12.5f" mformatset mtext "DATA" book
      purged "T" book

\     Columns of DATA are: open high low settle last change
      SPECIAL 0<>
      IF DATA SPECIAL exe (hT)
       \ Put "c" on the left of last values in the fifth column:
         depth nit push
            (hT) push 6 1st
            DO peek I word drop I 5 ndx =
               IF "c" nose THEN spaced
            LOOP pull (hT) drop
         depth pull less parkn one indent (hT)
      ELSE
       \ Scale the six columns of price data by FAC, format to integer:
         DATA 6 matread FAC *
         FORM format spaced hand (hP) 
      THEN

      " ----- ----- " those rows repeat park \ undef VOL and OI
      CON swap park (hT)

      ERR
      "inoPROCESS B" ERRset

      (hT) any?
      IF (hT) TIME park (hT) neat 
      ELSE VOL tpurged (hT)
      THEN (hT)

      ERR

    \ Reset the defaults:
      no "SPECIAL" book
      one "FAC" book
   end

   inline: inoSAVE (hT --- ) \ save data to file
      mpath "ino_" cat
      date sysdate lop "%06.0f" format cat
      ".dat" cat
      save
   end

\  Make hashes inoSYM# and inoESYM# that are used by word inoSYM:

\  Hash of tops symbols and pit symbols:
\  Tops symbols:
   "w c s sm bo "
   "lc lh pb " +
   "cc kc sb jo " +
   "hg gc pl si " +
   "ct cl ho hu ng " +
   "sf eu jy mp bp " +
   "us tn ff ed " +
   "dj sp nq nk" + (note: no yx)
   words (hKeys)

\  Pit symbols used in the page name:
   "CBOT_W CBOT_C CBOT_S CBOT_SM CBOT_BO "
   "CME_LC CME_LH CME_PB " +
   "NYBOT_CC NYBOT_KC NYBOT_SB NYBOT_OJ " +
   "NYMEX_HG NYMEX_GC NYMEX_PL NYMEX_SI " +
   "NYBOT_CT NYMEX_CL NYMEX_HO NYMEX_RB NYMEX_NG " +
   "CME_SF CME_EC CME_JY CME_MP CME_BP " +
   "CBOT_US CBOT_TY CBOT_FF CME_ED " +
   "CBOT_DJ CME_SP CME_ND CME_NK " +
   words lowercase (hVals)

   (hKeys hVals) 100 "inoSYM#" hash_make

\  Hash of tops symbols and electronic page names (some electronic 
\  page names match pit page names because they are all on the 
\  same page, where electronic symbols are distinguished by an 
\  attached E):
   depth push
\  Tops Electronic
   "w   CBOT_ZW"
   "c   CBOT_ZC"
   "s   CBOT_ZS"
   "sm  CBOT_ZM"
   "bo  CBOT_ZL"

   "lh  CME_HE"

   "cc  NYBOT_CC"
   "kc  NYBOT_KC"
   "sb  NYBOT_SB"
   "jo  NYBOT_OJ"

   "hg  NYMEX_HG"
   "gc  NYMEX_GC"
   "pl  NYMEX_PL"
   "si  NYMEX_SI"
   
   "ct  NYBOT_CT"
   "cl  NYMEX_CL"
   "ho  NYMEX_HO"
   "hu  NYMEX_RB"
   "ng  NYMEX_NG"

   "sf  CME_6S"
   "eu  CME_6E"
   "jy  CME_6J"
   "bp  CME_6B"
   "mp  CME_6M"

   "us  CBOT_ZB"
   "tn  CBOT_ZN"  
   "ff  CBOT_ZQ"
   "ed  CME_GE"

   "dj  CBOT_YM"
   "sp  CME_ES"
   "nq  CME_NQ"
   "nk  CME_NKD"

   depth pull less pilen lowercase
   dup 1st word drop swap 2nd word drop (hKeys hVals)

   (hKeys hVals) 100 "inoESYM#" hash_make

\  Make hashes inoSYM#' and inoESYM#' that are used by word inoSYM'
\  (they are the inverses of hashes inoSYM# and inoESYM#):
   inoSYM# (hHASH)
   dup hash_Vals swap hash_Keys
   (hKeys hVals) 100 "inoSYM#'" hash_make

   inoESYM# (hHASH)
   dup hash_Vals swap hash_Keys
   (hKeys hVals) 100 "inoESYM#'" hash_make

   inline: inoSYM (qS --- qS1) \ ino symbol
      "inoDATA" "PIT" yank
      IF (qS) lowercase inoSYM#
      ELSE (qS) lowercase inoESYM#
      THEN 
      swap hash_lookup drop any? IF 1st quote uppercase ELSE "" THEN
   end

   inline: inoSYM' (qS1 --- qS) \ ino inverse symbol
      "inoDATA" "PIT" yank
      IF (qS1) lowercase inoSYM#'
      ELSE (qS1) lowercase inoESYM#'
      THEN
      swap hash_lookup drop any? IF 1st quote uppercase ELSE "" THEN
   end

   inline: inoTIME (qMkt --- qTIME) \ word to run to convert time string
   \ Thu May  6 16:30:21 PDT 2010 Revised to use internal string MKT
      [ {"
           NY>LA W
           NY>LA C
           NY>LA S
           NY>LA SM
           NY>LA BO

           NY>LA LC
           NY>LA LH
           NY>LA PB

           NY>LA CC
           NY>LA KC
           NY>LA SB
           NY>LA JO

           NY>LA HG
           NY>LA GC
           NY>LA SI
           NY>LA PL

           NY>LA CT
           NY>LA CL
           NY>LA HO
           NY>LA HU
           NY>LA NG

           NY>LA SF
           NY>LA EU
           NY>LA JY
           NY>LA MP
           NY>LA BP

           NY>LA US
           NY>LA TN
           NY>LA FF
           NY>LA ED

           NY>LA DJ
           NY>LA SP
           NY>LA NQ
           NY>LA YX
           NY>LA NK
        "} asciify noblanklines chop
        dup 1st word drop "qTIME" book
        2nd word drop "MKT" book
      ]
      strchop "N" book
      MKT N uppercase grepe any? not
      IF " inoTIME: market " N + " not found" + ersys return THEN
      qTIME swap reach chop
   end

   private halt

\-----------------------------------------------------------------------
