{  File fs.v  August 2004

   Copyright (c) 2004   D. R. Williamson

   Words for fetching data from futuresource.com


   Udate September 2009
      Using this file with mget.eCOLLECT to collect a subset of 11 
      electronic markets: eu sf jy dj sp nq us tn cl hg gc.
      Revised symbols for sp and nq to FS es and nq (fsSYM()).
      FS has only pit DJ, so it will not be collected (see fsSYM()).

      Single year coding causing a problem in 2010, mentioned below,
      has been fixed in word Mo_fix() for the following:
         August 2009: bch.v is putting out PB0 for PB10 and Mo_fix()
         is putting out PB00.  The error has been fixed.
      This file also uses Mo_fix(), and it works ok for PB10.

   Update January 2008 
      Make provision for electronic markets, although this site
      does not collect them yet.

   Update September 2007
      Many market symbols changed, new site name, html revised.
      Sometimes this site sends the wrong page, which fsPROCESS() 
      detects and then tries again.
      The year coding uses only one character, so expect a problem
      in 2010.

   Update February 2006
      Use fsDATA to run the proper setups and then fetch the data:
         "sf" fsDATA \ runs fsDECIMAL
         "tn" fsDATA \ runs fs64ths
         "us" fsDATA \ runs fs32nds
         "w"  fsDATA \ runs fs8ths
}
\-----------------------------------------------------------------------

   "tracklist" missing IF " fs.v: require tracklist " . nl halt THEN

   inline: fs8ths (hT --- hT1) \ process T
      [ {"
        (hT)
        "'0" "0" strrpl
        "'2" "2" strrpl
        "'4" "4" strrpl
        "'6" "6" strrpl
        (hT)
        "} "fsGRAIN" macro
      ]
      "fs8ths" "fsGRAIN" localref ptr "fsPROCESS" "SPECIAL" bank
      (qS) fsPROCESS
   end

   inline: fs32nds (hT --- hT1) \ process T
      [ "%02.0f" "FORM" book
        {"
           64 0
           DO I FORM format "'" that cat swap strrpl LOOP
        "} "fsBOND" macro
      ]
      "fs32nds" "fsBOND" localref ptr "fsPROCESS" "SPECIAL" bank
      (qS) fsPROCESS
   end

   inline: fs64ths (hT --- hT1) \ process T
{     Turns this:
         111'08.5 113'10.5 111'08.5 112'23.0 112'23.0 1'15.5 
         110'03.0 112'04.0 110'03.0 111'16.5 111'16.5 1'15.5 

      into this:
         111085 113105 111085 112230 c112230 1155 
         110030 112040 110030 111165 c111165 1155 
}
      [ " %0.0f%02.0f%0.0f" "FORM" book
        {"
           (hT) push 6 1
           DO peek I word drop
              "0    " "0.0.0" replace$
              "'" " " replace$
              "." " " replace$
              numerate peek rows matrix FORM format
           LOOP
           6 parkn pull drop
        "}
        "fsBOND" macro
      ]
      "fs64ths" "fsBOND" localref ptr "fsPROCESS" "SPECIAL" bank
      (qS) fsPROCESS
   end

   inline: fsCOLLECT ( --- hT) \ data from fs
      tracklist "TRACK" book

      time push
      depth push
      "From fsCOLLECT, file fs.v"
      date neat
      "Showing: Open High Low Settle Close Chg Vol OpenInt"
      '   Volumes with "e" are estimated'
      " "
      TRACK rows 1st
      DO
         TRACK I quote fsDATA any?
         IF \this 8 ndx word drop "e" chblank
            \numerate totals ontop int$ "V" book
            "0" "V" book
            \this 9 ndx word drop
            \numerate totals ontop int$ "OI" book
            "0" "OI" book

            TRACK I quote spaced
            " VOL and OI totals: " cat V cat spaced OI cat neat

            swap

         ELSE TRACK I quote spaced date cat " no data" cat
         THEN
         " "
      LOOP
      depth pull less pilen

      "ET: " time pull less 60 slash "%0.1f" format cat
      " minutes" cat pile

      "_fsCOLLECT" naming
   end

   inline: fsDATA (qS --- hT) \ data for S
      [ true "PIT" book

        "'w'  fsSYM        fs8ths" "w"  macro
        "'c'  fsSYM        fs8ths" "c"  macro
        "'s'  fsSYM        fs8ths" "s"  macro
        "'sm' fsSYM 10  fsDECIMAL" "sm" macro
        "'bo' fsSYM 100 fsDECIMAL" "bo" macro

        "'lc' fsSYM 100 fsDECIMAL" "lc" macro
        "'lh' fsSYM 100 fsDECIMAL" "lh" macro
        "'pb' fsSYM 100 fsDECIMAL" "pb" macro

        "'cc' fsSYM   1 fsDECIMAL" "cc" macro
        "'kc' fsSYM 100 fsDECIMAL" "kc" macro
        "'sb' fsSYM 100 fsDECIMAL" "sb" macro
        "'jo' fsSYM 100 fsDECIMAL" "jo" macro

        "'hg' fsSYM 100 fsDECIMAL" "hg" macro
        "'gc' fsSYM  10 fsDECIMAL" "gc" macro
        "'pl' fsSYM  10 fsDECIMAL" "pl" macro
        "'si' fsSYM 1000 fsDECIMAL" "si" macro

        "'ct' fsSYM 100 fsDECIMAL" "ct" macro
        "'cl' fsSYM 100 fsDECIMAL" "cl" macro
        "'ho' fsSYM 1E4 fsDECIMAL" "ho" macro
        "'hu' fsSYM 1E4 fsDECIMAL" "hu" macro
        "'ng' fsSYM 1E3 fsDECIMAL" "ng" macro

        "'sf' fsSYM 1E4 fsDECIMAL" "sf" macro
        "'eu' fsSYM 1E4 fsDECIMAL" "eu" macro
        "'jy' fsSYM 1E4 fsDECIMAL" "jy" macro
        "'mp' fsSYM 1E6 fsDECIMAL" "mp" macro
        "'bp' fsSYM 1E4 fsDECIMAL" "bp" macro

        "'us' fsSYM       fs32nds" "us" macro
        "'tn' fsSYM       fs64ths" "tn" macro
        "'ff' fsSYM 1E3 fsDECIMAL" "ff" macro
        "'ed' fsSYM 1E3 fsDECIMAL" "ed" macro

        "'dj' fsSYM 1  fsDECIMAL" "dj" macro
        "'sp' fsSYM 10 fsDECIMAL" "sp" macro
        "'nq' fsSYM 10 fsDECIMAL" "nq" macro
        "'yx' fsSYM 10 fsDECIMAL" "yx" macro
        "'nk' fsSYM 1  fsDECIMAL" "nk" macro
      ]
      strchop uppercase "S1" book \ tops symbol
      S1 fsSYM any?
      IF "S2" book \ fs symbol
         S1 lowercase (qS) local \ run local word
         (hT) S2 S1 strp \ substitute the tops symbol
      ELSE VOL tpurged
      THEN
      "_" S1 lowercase (qS) + naming
   end

   inline: fsDECIMAL (qS n --- hT) \ process S
      (n) "fsPROCESS" "FAC" bank
      (qS) fsPROCESS
   end

   inline: fsEDATA (qS --- hT) \ electronic data for S
      "fsDATA" "PIT" yank push no "fsDATA" "PIT" bank
      fsDATA
      pull "fsDATA" "PIT" bank
   end

   -stkbal
   inline: fsGET (qS --- hT) \ data from futuresource.com
      (qS) "http://futuresource.quote.com" (qHost)
{
      This site fails if IP address is in HTTPget credentials instead
      of the site name.  Put the site name into HTTPget.Host_alias and 
      it will go into the credentials, then use IPhostr to get an IP:
}     dup (qHost) "HTTPget" "Host_alias" bank

      (qHost) IPhostr (qIPaddr) \ get IP

      time push that (qS) push

      "/quotes/quotes.jsp?s=" 
      rot uppercase cat HTTPget (hT)

      any?
      IF pull (qS) spaced "fsGET" cat spaced
         those textput chars (bytes) time pull less
         (qS bytes delta) msgSPEED
      ELSE pull pull 2drop ""
      THEN
   end
   stkbal

   inline: fsPROCESS (qS --- hT) \ get and process S
{     Sometimes this site sends a page that contains no prices; it is
      a page with entry boxes for selecting market symbols, and is one 
      they send when an incorrect market symbol has been requested.

      When this happens, the volume TIMES is empty and when "2 RERR" 
      runs RERR, its read error exit branch is taken.  Rather than just
      exiting, RERR has been modified to re-enter this word to try 
      again.

      Re-entering seems to improve performance.  In an 8 hour trial, of
      approximately 1,100 collections, 18 retries were needed and only
      one failed.

      Below is the re-entry strategy in action as viewed from a log file
      (with spacing added for clarity).

      The first fetch received 188820 bytes and a read error is noted.
      On the retry, 260957 bytes were received (from a different IP
      address) and no error is reported.  The program then continued
      to the next collection site.

      The note at the end from the exit ALARM shows 15 of 25 seconds
      remaining, so this collection took about 10 seconds.  Most of the
      time was in the second data retrieval (6.03 sec (260957/43270)):

         COLLECT begin: NG Fri Sep 28 06:24:33 PDT 2007
         Multitasker tasks:
          exit,0:CODE__ alarm period 25 seconds; remaining 24
         HTTPget timeout per site (seconds): 60

         HTTPget: host futuresource.quote.com
         HTTPget: connected to 216.23.224.51
         HTTPget: /quotes/quotes.jsp?s=NG
         HTTPget: receiving bytes ...
         HTTPget: received 188820 bytes at 537134 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 429582

         fsPROCESS.RERR: read error at 2; re-entering fsPROCESS

         HTTPget: host futuresource.quote.com
         HTTPget: connected to 216.23.232.62
         HTTPget: /quotes/quotes.jsp?s=NG
         HTTPget: receiving bytes ...
         HTTPget: received 260957 bytes at 44790 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 43270

         HTTPget: host 69.211.177.50
         HTTPget: connected to 69.211.177.50
         HTTPget: /pl/fknow/quote.htx?sym=NG&mode=i
         HTTPget: receiving bytes ...
         HTTPget: received 57715 bytes at 103240 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 79253

         Multitasker tasks:
          exit,0:CODE__ alarm period 25 seconds; remaining 15

      Here is an example where the retry failed and the program went to
      its next collection site.  The msgHold idling message shows it is
      being delayed in sending a message to tmp/msgcomm--this probably
      went on too long and the exit ALARM closed it out:

         COLLECT begin: SF Fri Sep 28 05:41:50 PDT 2007
         Multitasker tasks:
          exit,0:CODE__ alarm period 25 seconds; remaining 25

         HTTPget timeout per site (seconds): 60
         HTTPget: host futuresource.quote.com
         HTTPget: connected to 216.23.224.51
         HTTPget: /quotes/quotes.jsp?s=QSF
         HTTPget: receiving bytes ...
         HTTPget: received 188955 bytes at 35431 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 34205

         fsPROCESS.RERR: read error at 2; re-entering fsPROCESS

         HTTPget: host futuresource.quote.com
         HTTPget: connected to 216.23.224.51
         HTTPget: /quotes/quotes.jsp?s=QSF
         HTTPget: receiving bytes ...
         HTTPget: received 188955 bytes at 35428 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 35044

         fsPROCESS.RERR: re-entry failed, read error at 2

         HTTPget: host 69.211.177.50
         HTTPget: connected to 69.211.177.50
         HTTPget: /pl/fknow/quote.htx?sym=SF&mode=i
         HTTPget: receiving bytes ...
         HTTPget: received 7331 bytes at 156395 bytes/sec
         HTTPget: connection closed by host
         Bytes/sec: 18917

         msgHold: idling Fri Sep 28 05:42:03 PDT 2007
}
      [ \ Defaults:
          no "SPECIAL" book
          1 "FAC" book
          no "REENTERED" book

        {" (hT n --- hT) RERR \ read error function
          (hT n) "n" book 
          (hT) any? not 
          IF REENTERED not 
             IF " fsPROCESS.RERR: read error at " n intstr + 
                "; re-entering fsPROCESS" + . nl 

              \ Uncomment the following for debug print:
              \ TSAVE mpath SYM "_debug.html" + + save \ for debugging

                yes "REENTERED" book 

                QSYM fsPROCESS \ try again
              \ On success, this is where we come out after re-entering

             ELSE 
              \ On failure, this is where we come out after re-entering
                " fsPROCESS.RERR: re-entry failed, read error at " 
                n intstr + . nl ""
             THEN
             no "REENTERED" book
             return2 \ exits fsPROCESS here
          THEN (hT)
        "} "RERR" macro

          " %0.0f %0.0f %0.0f %0.0f c%0.0f %0.0f" "FORM" book

          yes "PRODUCTION" book
      ]
      dup "QSYM" book (qS)

      (qS) dup fsSYM' fsTIME "qTIME" book       
      (qS) dup "SYM" book (qS) 

      (qS) PRODUCTION
\  REENTERED not IF drop no THEN
      IF (qS) fsGET                             \ production
      ELSE drop "QSF.html" old ascii "BIN" file \ testing
         BIN INF fget BIN fclose                  
      THEN

      (hT) any? not IF "" return THEN
      these rows 1 = IF textget THEN noblanklines "T" book

      T "TSAVE" book \ for debugging

    \ Return empty if no "Date:" string:
      T dup "Date:" grepr 1 RERR
      (T hRow) reach words 6 ndx quote "DTIME" book

      T
      T 'align="center">' grepr 
      T 'N/A' grepr pile yes sort reach

    \ String N/A shows up when the month has expired, and the time
    \ will be blank.  Put in a dummy time:
      (hT) "N/A" 'align="center">00:00:01</td><td' strp

    \ Sometimes there is no time specified; put in a dummy time:
      'align="center"></td><td'
      'align="center">00:00:02</td><td' strp

      'align="center">' '</td><td' between noblanklines
      (hT) 2nd those rows 1- items reach \ remove topmost header line
      (hT) 2 RERR "TIME" book

      T dup 'align="center">' grepr reach 
      (hT) "?s=" '"><img' between noblanklines 
      1st word abs 3 RERR drop "%20" "" strp 

      Mo_fix spaced "CON" book

      T dup "</table></b>" push
      1st peek chars items catch pull grepr (hT hR) reach (hT)
      "><" "" replace$
      "/font" "/td" replace$
      (hT) '">' "</td" between (hT)

      (hT) "&nbsp;" " 0 " replace$ spaced (hT)
      (hT) push
      peek 2nd word abs 4 RERR drop spaced (hOpen)
      peek 3rd word abs 5 RERR drop spaced (hHigh)
      peek 4th word abs 6 RERR drop spaced (hLow)
      (hOpen hHigh hLow) 3 parkn (hT1)
      pull 1st word abs 7 RERR drop spaced (hChg) push

      (hT1) T dup "<td><b>" push
      1st peek chars items catch pull grepr (hT hR) reach (hT)
      (hT) "<b>" "</td>" between 
      "&nbsp;" " 0 " qreplace (hClose) spaced dup (hSettle hClose)

      (hT1 hSettle hClose) pull (hChg) 4 parkn "DATA" book

      TIME rows DATA rows > 
      IF \ there is a time specified even with N/A, so remove 
         \ the dummy one:
         TIME "00:00:01" "" strp noblanklines "TIME" book
      THEN

      purged "T" book

\     Columns of DATA: open high low settle close change
      SPECIAL 0<>
      IF DATA SPECIAL exe (hT)
       \ Put "c" on the left of close values in the fifth column:
         depth nit push
            (hT) push eight 1st
            DO peek I word drop I five ndx =
               IF "c" nose THEN spaced
            LOOP pull (hT) drop
         depth pull less parkn one indent (hT)
      ELSE
       \ Scale the six columns of price data by FAC, format to integer:
         DATA dup numbers (hA) those rows matrix
         1st six items catch FAC * 
         FORM format spaced hand (hP) lop
      THEN

      " ----- ----- " those rows repeat park \ undef VOL and OI
      CON swap park (hT)

      (hT) any?
      IF TIME any? not
         IF DTIME those rows repeat
         ELSE qTIME main
         THEN
         (hT Time) park
         neat
      ELSE VOL tpurged
      THEN

    \ Removing the options line:
      (hT) "Y " " " qreplace noblanklines (hT)

    \ Reset the defaults:
      no "SPECIAL" book
      one "FAC" book
   end

   inline: fsSAVE (hT --- ) \ save data to file
      mpath "fs_" cat
      date sysdate lop "%06.0f" format cat
      ".dat" cat
      save
   end

   inline: fsSYM (qS --- qS1) \ fs symbol

      [ "w c s sm bo lc lh pb cc kc sb jo hg gc pl si "
        "ct cl ho hu ng sf eu jy mp bp us tn ff ed " pile
       \ September 2009: FS has only pit DJ, so is has been removed:
       \"dj sp nq yx nk" pile lowercase words (hKeys)
           "sp nq yx nk" pile lowercase words (hKeys)

        "w c s sm bo lc lh pb cc kc sb jo hg gc pl si "
        "ct cl ho xrb ng qsf qec qjy qme qbp qus qty qff qed " pile
       \ September 2009: FS has only pit DJ, so is has been removed:
       \"dj es nq yu nk" pile lowercase words (hVals)
           "es nq yu nk" pile lowercase words (hVals)

        (hKeys hVals) 100 defname "SYM" localref hash_make
      ]
      "fsDATA" "PIT" yank
      IF (qS) lowercase SYM swap hash_lookup drop any?
         IF 1st quote uppercase ELSE "" THEN
      ELSE (qS) drop "" \ fs does not do electronic
      THEN
   end

   inline: fsSYM' (qS1 --- qS) \ fs inverse symbol
      [ "fsSYM" "SYM" yank (hHASH)
        dup hash_Vals swap hash_Keys
        (hKeys hVals) 100 defname "SYM" localref hash_make
      ]
      "fsDATA" "PIT" yank
      IF (qS1) lowercase SYM swap hash_lookup drop any?
         IF 1st quote uppercase ELSE "" THEN
      ELSE (qS) drop "" \ fs does not do electronic
      THEN
   end

   inline: fsTIME (qMkt --- qTIME) \ word to run to convert time string
   \ Thu May  6 16:30:21 PDT 2010 Revised to use internal string MKT
      [ {"
           CH>LA W
           CH>LA C
           CH>LA S
           CH>LA SM
           CH>LA BO

           CH>LA LC
           CH>LA LH
           CH>LA PB

           NY>LA CC
           NY>LA KC
           NY>LA SB
           NY>LA JO

           NY>LA HG
           NY>LA GC
           NY>LA SI
           NY>LA PL

           NY>LA CT
           NY>LA CL
           NY>LA HO
           NY>LA HU
           NY>LA NG

           CH>LA SF
           CH>LA EU
           CH>LA JY
           CH>LA MP
           CH>LA BP

           CH>LA US
           CH>LA TN
           CH>LA FF
           CH>LA ED

           CH>LA DJ
           CH>LA SP
           CH>LA NQ
           NY>LA YX
           CH>LA NK

        "} asciify noblanklines chop
        dup 1st word drop "qTIME" book
        2nd word drop "MKT" book
      ]
      strchop "N" book
      MKT N uppercase grepe any? not
      IF " fsTIME: market " N + " not found" + ersys return THEN
      qTIME swap reach chop
   end

   private halt

\-----------------------------------------------------------------------

Appendix

Updated February 2006.  Information below is probably no longer valid,
or might be found on the new URL: "http://www.futuresource.com" 


http://legacy.futuresource.com/iFS/

Default Quoteboard URLs:

    Currencies - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=currencies
    Energy - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=energy
    Grains - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=grains
    Indices - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=indices
    Interest Rates - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=irates
    Livestock - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=livestock
    Metals - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=metals
    Softs - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=softs
    FX Spot Rates - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=forex
    CBOT Real-Time - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=cbotrt
    NQLX - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=nqlx
    One Chicago - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=onechicago

    To display multiple quote groups on a single page, simply list all the groups you want to display, separated by commas.

    Example: Grains, Energy, Indices - http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&qgroup=grains,energy,indices

Creating Custom/Dynamic Quoteboards:

    To construct new quoteboards dynamically, use the following syntax:

    http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&symbols=SYMBOLS&mc=FRONTMONTHS&title=TITLE

    SYMBOLS - the symbols you wish to get quotes for. To view multiple front months for a root symbol, enter the root symbol here and specify the number of contracts in the FRONTMONTHS field.

    FRONTMONTHS - optional. Used only when SYMBOLS contains one or more root symbols. Specifies the number of front contracts to display for a given root.

    TITLE - the display title for a quoteboard. If blank, defaults to "Quotes".

    Sample custom quoteboard: http://legacy.futuresource.com/iFS/quotes.asp?cID=FS7&symbols=C&mc=5&title=Corn%20Futures
