{  File cme1.v  November 2011

   Copyright (c) 2011-2012   D. R. Williamson

   Words for fetching data from CME real time E-quotes table.

------------------------------------------------------------------------

   CME E-quotes data is displayed and continuously updated in a window
   on a Windows machine.  File cme.v processed text snapshots of that 
   window to extract delayed prices.

   These E-quotes quotes differ from the ones processed by cme.v be-
   cause they come from an Excel spreadsheet that receives data from 
   the E-quotes window, rather than from a snapshot of text from the 
   E-quotes window itself.

   Taking snapshots of the E-quotes window for cme.v used a Windows
   program called AutoHotkey.  To take a snapshot, the AutoHotkey pro-
   gram had to put the E-quotes window on top of all viewed windows.
   This took focus away from any window that was being viewed or typed
   upon, causing work on the machine to be continually interrupted at
   one minute intervals as focus was lost for another snapshot.

   Purchasing an upgraded monthly subscription to enable Excel spread-
   sheets with CME E-quotes made it possible to develop an Excel macro 
   to periodically write the spreadsheet to a file with no interup-
   tions of other work being done.

   The only difference with the Excel quotes is that they are all in
   decimal form.  For example, bond quotes have already been formatted
   from 32nds to decimal in the Excel table.

   The Windows machine connects as a client to an NFS (Network File
   System) server on a Linux machine.  A macro in Excel (written in
   VBA (Visual Basic for Applications) for Excel) periodically places
   into the shared NFS directory a text table of the data currently in
   the Excel spreadsheet (and reflecting the current CME E-quotes win-
   dow that is continually updating the Excel spreadsheet).

   NFS allows user programs like the Excel macro on the Windows machine,
   and this one here on a Linux machine, to write and read the shared 
   file as if it resides on either local machine.  In reality, the 
   shared file resides on the Linux machine from the moment it is writ-
   ten, because the Linux machine is acting as the NFS server.

   No file transfer between machines ever takes place in NFS.

   Word nfs_load in word cme_process places the data file on the stack,
   where it is formatted into the standard form for collection output, 
   matching the tables produced by other collector programs like cme.v,
   tch1.v, ino.v and bch.v.

   This file is based upon mfg.v and not cme.v because words in mfg.v 
   have operational improvements made after cme.v was written.  In par-
   ticular, COLLECT runs as a TASK, checking every 2 seconds to see if
   a new file is present.  In cme.v, COLLECT runs on a 60 second ALARM
   with complications to make it run temporarily on a 5 second ALARM 
   when a file is missed.

   The file placed on the Linux NFS server by the Windows NFS client,
   called /nfs/solano/xlequotes.txt, holds a comma delimited text file
   of price data from an Excel spreadsheet that is updated in real time.

------------------------------------------------------------------------

   Words

   usrpath "cme1.v" + asciiload this " inline:" grepr reach dot

   Processing data
   inline: BEEP ( --- ) \ error alarm
   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
   inline: cme_process ( --- ) \ process market data from CME E-quotes
   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
   inline: FILE_IN ( --- qFile) \ name of input file
   inline: FILE_LOG ( --- qFile) \ name of log file
   inline: FILE_OUT (qSYM --- qFile) \ name of output file
   inline: FILE_SEND (qFile --- ) \ send file to remote
   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
   inline: mrc_close ( --- ) \ close market data resources
   inline: mrc_open ( --- f) \ open market data resources on plunger
   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name

   Collecting data
   inline: COLLECT ( --- ) \ collect data from NSF client on Windows
   inline: COLLECT_END ( --- ) \ end multitasker word COLLECT
   inline: COLLECT_START ( --- ) \ start multitasker word COLLECT
   inline: START ( --- ) \ depending on time of day, set the start task

   Also see word ALARMcme1 in uboot.v at mytops/usr.

------------------------------------------------------------------------
}
   CATMSG push no catmsg

   "MOdo" missing IF "mrc.v" source fence THEN \ will source mfil.v too

\-----------------------------------------------------------------------

\  Processing data

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
    \ Fri Nov 25 13:11:17 PST 2011

    \ Format bond and note prices and write collection file.

      [ list: 0 0 0 0 0 0 1 1 ; "R" book ]

      "SYM" book "CON" book "TIME" book 
      (hA) numbers (hA)

      SYM MOdo CON <>
      IF (hA) drop
         " BOND: wrong contract for " SYM + . nl return
      THEN

      (hA) R rake (hP hV) "VOI" book

      (hP) SYM "US" =
      IF (hP) 32nds 
      ELSE (hP) 32nds+
      THEN (hT) "T" book 

      T dup chars 2 + blpad "T" book   \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file?
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile
      ELSE drop
      THEN

      SYM CON +
      T
      VOI itext \ volume and open interest
      TIME (qTIME)
      4 pilen vol2str neat (qS)

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " BOND: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: cme_process ( --- ) \ process market data from CME E-quotes
{     Wed Sep  7 12:17:38 PDT 2011

      Process data from CME E-quotes Excel spreadsheet, and write files
      in /tmp that match files from the regular collectors, so they will
      be picked up when hist_add() runs to append latest data to each 
      market's history file.

      This word parallels word cache_process() in file tch1.v used as
      a template.  Many other words in this file come from tch1.v with
      few changes.
}
      [ list: \ Market symbols (this program's symbols shown on right):
           6E \ EU Euros
           6S \ SF Swiss Francs
           6J \ JY Japanese Yen
           CL \ CL Crude Oil
           HG \ HG High Grade Copper
           GC \ GC Gold Comex
           YM \ DJ Dow Jones Industrial Average
           ES \ SP Standard and Poors Stock Index
           NQ \ NQ Nasdaq Stock Index
           ZB \ US 30-year Treasury Bonds
           ZN \ TN 10-year Treasury Notes
        end words noq_alike "SYM_TABLE" book
{  
      \ Put desired symbols and uncomment this segment for debugging:
        list: \ Market symbols (this program's symbols shown on right):
           GC \ GC Gold Comex
        end words noq_alike "SYM_TABLE" book
}    
{       Settle is for the previous session, which is the way it should
        be.  Collections from other sources do not handle Settle cor-
        rectly (probably due to my collectors as opposed to the sites)
        and Settle is usually the same as Last.  This collection will 
        have it right. 

        Fetch the price rows from U (see "rows of U" below) in the 
        order:
           Open, High, Low, Settle, Last, Change, Volume, Open Interest:
}          6     2     3    9       4     5       7       8
        8 listn (hA) ndx "Urake" book

        VOL tpurged "Tsave" book

      \ Lookup table to make AM and PM for Timestamp:
      \  1                          13                      24
      \  AM                         PM
        "12 1 2 3 4 5 6 7 8 9 10 11 12 1 2 3 4 5 6 7 8 9 10 11" words
        "HOURS" book
      ]
    \ This word runs when newer FILE_IN is detected in COLLECT.
      " cme_process: begin " date + . nl

      FILE_IN any?
      IF (qFile) nfs_load textget (hT) "T" book
         T noblanklines rows 0> not
         IF " cme_process: no data found " date + . nl
            mrc_close return \ FILE_LOG will not be written
         THEN

       \ Tue Dec  6 13:13:21 PST 2011.  Check that the data has changed:
         T Tsave strmatch 0= \ strmatch = 0 if unchanged
         IF " cme_process: file has not changed " date + . nl
            mrc_close return \ FILE_LOG will not be written
         THEN
         T "Tsave" book

      ELSE \ input file not found
         " cme_process: file not found " date + . nl
         mrc_close return \ FILE_LOG will not be written
      THEN

    \ Here is a typical time string: 1:29:57 PM CST.  Fill blanks with 
    \ underscores, and convert characters to lower case to avoid con-
    \ flicts with uppercase market symbols; the time string shown above
    \ becomes 1:29:57_pm_cst:
      T    " PM " "_pm_" strp
      (hT) " AM " "_am_" strp
      (hT) "CST" "cst" strp
      (hT) "CDT" "cdt" strp
      (hT) "EST" "est" strp
      (hT) "EDT" "edt" strp (hT) 

    \ Replace blank comma delimited data with zero:
      (hT) ", ," ",0," strp (hT)
      (hT) "T" book

    \ Loop over T for each symbol and extract its data:
      SYM_TABLE rows 1st
      DO SYM_TABLE I quote strchop "SYM" book

         T dup SYM grepr any? 
         IF (hT hR) reach words "U" book
{
            When SYM = ZN, here are the ten rows of U (with notes added
            after the backslash).  Note that prices are decimal, not
            as-quoted 32nds (they are converted back in word BOND()):

               ZNZ11          \ Symbol ZN, contract Z11
               130.6562       \ High
               130.125        \ Low
               130.2031       \ Last
               -0.5156        \ Change
               130.5937       \ Open
               597850         \ Volume
               630363         \ Open Interest
               130.7187       \ Previous Settle
               9:01:51_am_cst \ Timestamp
}
{           Mon Jan  2 15:45:03 PST 2012.  The last item, Timestamp, 
            is missing from the Excel spreadsheet if the market is not
            open, and its row will have 9 items instead of 10.  

            Since the program is now running, other markets must be
            open, so for the market with only 9 items, add a fake 
            Timestamp that has the current time in Chicago and leave
            the other values alone (thus Volume will remain the same
            as at the end of last session, so dV will be zero as it
            should be for the closed session):
}           U rows 9 =
            IF " cme_process: appending closed session for " SYM + . nl
               U (hU)

             \ Make a fake Timestamp to append to U:
               time dup CHdiff1 + gmtime 4th word drop "OCLOCK" book
               OCLOCK 1st 2 items catch number drop (nHour)
               xbase push 1based
                  HOURS over (nHour) 1+ (ndx) quote strchop (qHour)
               pull indexbase
               (nHour qHour) OCLOCK ":" tug + strchop (qOCLOCK)
               swap (nHour) 1+ (ndx) 13 <
               IF "_am_cst" ELSE "_pm_cst" THEN (qOCLOCK qAM) park
               (hU qTimeStamp) pile \ U now has 10 items

               (hU) "U" book
            THEN

            U rows 10 < 
            IF " cme_process: insufficient data for " SYM + . nl false
            ELSE true
            THEN (f)

            IF \ Test for Volume>0:
               U 7 ndx quote number (0 or nV -1) \ fetch Volume
               IF (n) 0> 
               ELSE " cme_process: volume is zero for " SYM + . nl false
               THEN (f)
            ELSE false
            THEN (f)

            IF \ Test for valid time string:
               U 10 ndx reach -trailing '""' =
               IF " cme_process: time string is empty for " SYM + 
                  . nl false
               ELSE true
               THEN (f)
            ELSE false
            THEN (f)

            IF \ Volume>0 and time string is valid
             \ Get the time.  Times in the output data are quoted as LA:
               U 10 ndx reach "_" " " strp
               TIME>LA (qHH:MM:SS) "TIME" book

             \ Get the contract:
               U 1st quote 1st word drop SYM chars negate indent (qS)
               (qS) "CON" book

             \ Fetch the price rows from U in the order 

             \   Open, High, Low, Settle, Last, Change, Volume, Open Int

             \ and take just the first word in any row (this ignores
             \ ranges like HG Open range (see example in cme.v)):
               U Urake reach "DPS" chblank (hT) 
               (hT) 1st word (hT f) drop (hT) 
{
            After fetching price rows in the order of Urake, here is T
            on the stack for the example of ZN above: 

               130.5937 \ Open
               130.6562 \ High
               130.125  \ Low
               130.7187 \ Settle
               130.2031 \ Last
               -0.5156  \ Change
               597850   \ Volume
               630363   \ Open Interest
}
             \ Process this market and write its file:
               (hT) TIME CON SYM PROCESS

            ELSE " cme_process: no data in U for " SYM + . nl
            THEN
         ELSE (hT) drop
            " cme_process: no data in T for " SYM + . nl
         THEN
      LOOP

    \ Write the time of processing to a log at FILE_IN.PATH:
      time intstr (nt) FILE_LOG (qFile) save \ time log for ALARMcme1

      mrc_close \ close resources
   end

   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
    \ Fri Nov 25 14:56:17 PST 2011

    \ Apply factor, FAC, to decimal data and write collection file.

      [ list: 0 0 0 0 0 0 1 1 ; "R" book ]

      "SYM" book "FAC" book "CON" book "TIME" book
      (hA) numbers (hA)

      SYM MOdo CON <>
      IF (hA) drop
         " DECIMAL: wrong contract for " SYM + . nl return 
      THEN

      (hA) R rake (hP hV) "VOI" book

      (hP) FAC * "%12.0f" format chop (hT)

      (hT) dup chars 2 + blpad "T" book \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said  \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file? 
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile 
      ELSE drop
      THEN 

      SYM CON +
      T
      VOI itext \ volume and open interest
      TIME (qTIME)
      4 pilen vol2str neat (qS) 

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " DECIMAL: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: FILE_IN ( --- qFile) \ name of input file
    \ Mon Sep 19 08:17:46 PDT 2011
      [ "" dup "PATH" book "FILE" book

        host "plunger" =
        IF "/nfs/solano/" "PATH" book "xlequotes.txt" "FILE" book THEN

        host "riggo" =
        IF "/nfs/solano/" "PATH" book "xlequotes.txt" "FILE" book THEN

        PATH FILE + file? not
        IF " FILE_IN: file " FILE + " not found, halting" + . nl
           HALT
        THEN
      ]
      PATH FILE + dup (qFile) file? not
      IF " FILE_IN: file " swap + " not found " + date + . nl
         "" (qFile) \ file not found, return empty string
      THEN (qFile)
   end

   inline: FILE_LOG ( --- qFile) \ name of log file
    \ Mon Sep 19 08:25:05 PDT 2011

    \ This log is read by ALARMcme1 that is running to verify that 
    \ data is continually written.

      [ "FILE_IN" "PATH" yank "cme1_process.log" + "LOG" book ]
      LOG
   end

   inline: FILE_OUT (qSYM --- qFile) \ name of output file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Make PATH_OUT equal to "/tmp1/" during testing; see "testing and 
    \ debugging" below.

      [ "/tmp/" "PATH_OUT" book ]
        PATH_OUT "MKT_CME1.eDAT" + "MKT" rot uppercase strp
   end

   inline: FILE_SEND (qFile --- ) \ send file to remote
    \ Wed Sep  7 15:13:14 PDT 2011

      (qFile) dup -filename "/tmp1/" = 
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN
      
      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book 
      "mrc_open" "S1" yank "S1" book 

    \ Tue Oct 11 06:12:43 PDT 2011.  Word COLLECT runs remoterun1; do
    \ not allow COLLECT to run while remoterun1 is run below:
      "COLLECT" SLEEP \ don't want this to run during remoterun1()

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            FILE FILE S fremoteput (f) 

            (f) dup false =
            IF " FILE_SEND: error sending " FILE + 
               "; see ERRLOG below:" + . nl
               ERRLOG asciiload (hT) 3 indent . nl
            THEN (f)

            ERRLOG deleteif
            SYSOUTsav set_sysout \ back to regular output
            (f)
         ELSE true
         THEN (f)

         IF " FILE_SEND: OK " FILE + " to " + REMOTE + date + . nl
            S1 -1 >
            IF
{              Make a string to run on REMOTE that will add a job to 
               the collector queue that will update the history file 
               with the data just sent.  A typical string to do this 
               is: "eGC-COLLECT" "hist" localref ptr queue_add1 for 
               market symbol GC.

               Word queue_add1 on the remote will add a market's job 
               to the queue if there isn't another one already there.  
               Another job for a market would be one the collector 
               fetched.  When that queued job is run, the file just 
               written will be processed along with the ones made by 
               the collector.

               The collector job on REMOTE is presently on socket S1 
               connected to REMOTE.
}
               "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
               "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

               (hT) depth 1- push \ depth without T

               "remoterun1" "SEC" yank "SECsav" book

               SEC "remoterun1" "SEC" bank [ 10 "SEC" book ]
               (hT) S1 remoterun1 
               SECsav "remoterun1" "SEC" bank

               depth pull > \ has depth increased?
               IF (f)
                  IF " FILE_SEND: " FILE SYM_OUT + 
                     " update queued on " + REMOTE + date + . nl

                  ELSE " FILE_SEND: " FILE SYM_OUT + 
                     " update queue error on " + REMOTE + date + . nl
                     BEEP
                  THEN
               ELSE " FILE_SEND: " FILE SYM_OUT + 
                  " remoterun1 time out " + REMOTE + date + . nl
                  BEEP
               THEN
            THEN

         ELSE " FILE_SEND: error sending " FILE + " to " + 
            REMOTE + date + . nl BEEP
         THEN
      ELSE " FILE_SEND: not connected to " REMOTE + date + 
         . nl BEEP
      THEN 

      "COLLECT" WAKE
   end

   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
      "mrc_open" "REMOTE" yank "mrc_open" "PORT" yank
      (qIP nPORT) logLAN (f)
      IF mrc_open (f)
      ELSE false
      THEN (f)
   end

   inline: mrc_close ( --- ) \ close market data resources
      "mrc_open" "S" yank sclose
      -1 "mrc_open" "S" bank

      "mrc_open" "S1" yank sclose
      -1 "mrc_open" "S1" bank

      " mrc_close: sockets closed " date + . nl
   end

   inline: mrc_open ( --- f) \ open market data resources on plunger
    \ Mon Sep 19 11:37:05 PDT 2011

      [ host "plunger" =
        IF IPloop ELSE plunger THEN spaced "REMOTE" book 
        "plunger" "p0" yank 80 + "PORT" book \ http on plunger

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector topse

        0 "E_PORT" book

        {" topse_port( -- f) \ fetch topse port on the collector machine

           REMOTE PORT CLIENT "S" book \ socket to HTTP server
           "TOPSE_SERVER" S msgPeekSocket (qPort) any?
           IF number (no || nPort yes)
              IF "E_PORT" book true
              ELSE " mrc_open: bad port number from " 
                 REMOTE + date + . nl false 
              THEN
           ELSE " mrc_open: error fetching port from " 
              REMOTE + date + . nl false
           THEN (f)
        "} "topse_port" macro

      \ Collector topse must already be running on the collector ma-
      \ chine when this file is sourced.  Fetch its port now, during
      \ start up, using macro topse_port just created:
        topse_port (f) 
        IF S sclose -1 "S" book
        ELSE " cme1.v: failed to fetch topse port; HALTING" . nl HALT
        THEN
      ]
      sockets sclose \ close any connections (there should be none)

      REMOTE PORT CLIENT "S" book

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            "/mdat/latest.dat" mpath "latest.dat" + S fremoteget (f1)
            "/mdat/con.dat"    mpath "con.dat" + S fremoteget (f2)

            SYSOUTsav set_sysout \ back to regular output
         ELSE true true (f1 f2)
         THEN

         (f1 f2) and
         IF " mrc_open: OK files from " REMOTE + date + . nl

          \ Connect to the collector on REMOTE:
            -1 "S1" book
            E_PORT any?
            IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
               IF true (f)
               ELSE " mrc_open: cannot connect to collector on " 
                  REMOTE + date + . nl 

                \ Maybe topse was restarted and it is on a different
                \ port now.  Force topse_port to run next time:
                  0 "E_PORT" book 

                  false (f)
               THEN
            ELSE " mrc_open: fetching E_port" . nl
               topse_port (f) 
               IF mrc_open (f)
               ELSE BEEP false (f)
               THEN
            THEN
         ELSE " mrc_open: error fetching files from " REMOTE + 
            date + . nl 
            ERRLOG asciiload 2 indent . nl 
            BEEP false (f) 
         THEN
      ELSE " mrc_open: cannot connect to " REMOTE + date + . nl
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Incoming SYM is the cme symbol; file created will use the
    \ program's symbol.

      "SYM" book

      SYM "6E" = IF (hA qTIME qCON) 10000 "EU" DECIMAL return THEN
      SYM "6S" = IF (hA qTIME qCON) 10000 "SF" DECIMAL return THEN
      SYM "6J" = IF (hA qTIME qCON) 10000 "JY" DECIMAL return THEN

      SYM "YM" = IF (hA qTIME qCON) 1  "DJ" DECIMAL return THEN
      SYM "ES" = IF (hA qTIME qCON) 10 "SP" DECIMAL return THEN
      SYM "NQ" = IF (hA qTIME qCON) 10 "NQ" DECIMAL return THEN

      SYM "ZB" = IF (hA qTIME qCON) "US" BOND return THEN
      SYM "ZN" = IF (hA qTIME qCON) "TN" BOND return THEN

      SYM "CL" = IF (hA qTIME qCON) 100   "CL" DECIMAL return THEN
      SYM "HG" = IF (hA qTIME qCON) 10000 "HG" DECIMAL return THEN
      SYM "GC" = IF (hA qTIME qCON) 10    "GC" DECIMAL return THEN
   end

   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
      (qFile) "FILE_OUT" "PATH_OUT" yank "" strp (qSYM)
      (qSYM) "_CME1.eDAT" "" strp (qSYM)
   end

\-----------------------------------------------------------------------

\  Collecting data

   inline: COLLECT ( --- ) \ collect data from NSF client on Windows
    \ Mon Sep 19 08:19:33 PDT 2011

    \ Perform another collection if FILE is new.

      [ FILE_IN "FILE" book, -1 "FTIME" book ]

      soonest_task (f) \ true if in a collection period
      IF FILE filetime (nt) dup FTIME <>
	 IF (nt) "FTIME" book \ file time has changed

	    logLAN1 (f)       \ open the link to head machine
	    IF cme_process    \ process data and send to head machine

	    ELSE \ connect to LAN failed; try again next time
	       " COLLECT: LAN connection failed " date + . nl
               mrc_close
	    THEN
	 ELSE (nt) drop
	 THEN
      THEN
   end
   
   inline: COLLECT_END ( --- ) \ end multitasker word COLLECT
      [ 60 "LATER" book ]

      "COLLECT" SLEEP

    \ Set an alarm to run COLLECT_START:
      time soonest_start LATER + (sec)
      " COLLECT_END: " date + ", collection begins in " +
      over 60 / 0.5 + integer intstr + " minutes" + . nl
      (sec) "COLLECT_START" ALARM
   end

   inline: COLLECT_START ( --- ) \ start multitasker word COLLECT
    \ Fri Sep 16 14:47:26 PDT 2011
      [ 0 "SOONER" book 
        1 2 / "HZ" book ]

    \ Set an alarm to run COLLECT_END:
      time soonest_end SOONER - (sec)
      " COLLECT_START: collection ends in about "
      over 3600 / 0.5 + integer intstr + " hours" + . nl
      (sec) "COLLECT_END" ALARM

    \ Remove old files:
      " COLLECT_START: removing old *CME1.eDAT files from /tmp" . nl
      "/bin/rm /tmp/*CME1.eDAT" shell

    \ Start word COLLECT running at frequency HZ:
      " COLLECT_START: starting multitasker word COLLECT at " 
      HZ "%3.1f" format + " Hz" + . nl 
      "COLLECT" WAKE
   end
   "COLLECT_START" "HZ" yank "COLLECT" TASK

   inline: START ( --- ) \ depending on time of day, set the start task
      " START: running NIST_SYNC ... " date + . nl
      NIST_SYNC \ sync the program time with NIST

    \ Next time, and every time thereafter, run NIST_SYNC in the lull
    \ between 14:45 and 15:00 (LA) time:
      "14:50:00" "todayat" >stk (n qT) chars 0>
      IF (n) drop "38:50:00" todayat THEN (n) "NIST_SYNC" ALARM

      soonest_task (f) IF COLLECT_START ELSE COLLECT_END THEN
   end

   pull catmsg

\  For testing and debugging, uncomment the following line:
\  "/tmp1/" "FILE_OUT" "PATH_OUT" bank " WORKING IN TEST MODE" . nl halt

\  Then set SYM_TABLE in cme_process to the market to test, and run
\     "cme1.v" source cme_process halt
\  with HALT placed at various locations to test and find bugs.

\-----------------------------------------------------------------------

   START nl tasks

   private halt
