      subroutine elmstfMRT(e0,g0,tt0,pl0,alpha0,beta0,a ! {{{1
     .                    ,x1,x2,x3,y1,y2,y3,ek,ekb)
      implicit none
         real*8 e0, g0, tt0, ip0, a, x1, x2, x3, y1, y2, y3,
     .          znu, dt, det, p1, p2, p3, r1, r2, r3, alpha0, beta0
c
         integer  pl0, inew(9), i, j, m, ii, jj
         real*8   ek(18,18),ekb(9,9), ektemp(9,9)
         real*8   xt(3), yt(3),dmt(3,3),sm(9,9)
         real*8   alpha,beta,f,fbeta,znu0,xkap
         integer  lst(12)/1,2,4,5,7,8,3,6,9,10,11,12/

         logical    DEBUG
         parameter (DEBUG = .false.)
c
*        e0=7.5 
*        znu=0.25
cccccccccc!!!!!!!!!!!!!! change plane stress or strain !!!!!!!!
*        znu=(e0/g0/2.0)-1.0
*        coef=e0*tt0/(1-znu*znu)
*        dmt(1,1) = 1.0*coef
*        dmt(1,2) = znu*coef
*        dmt(1,3) = 0.0 
*        dmt(2,1) = znu*coef
*        dmt(2,2) = 1.0*coef
*        dmt(2,3) = 0.0      
*        dmt(3,1) = 0.0      
*        dmt(3,2) = 0.0      
*        dmt(3,3) = (1-znu)*0.5*coef
ctag
cAND
      if (DEBUG) then
         call dump_mrt_args('elmstfMRT', e0,g0,tt0,pl0,alpha0,beta0,a,
     .                      x1,x2,x3,y1,y2,y3)
         write(6,*) '-> subroutine elmstfMRT'
      end if
         znu0=(e0/g0/2.0)-1.0
c        plane stress 
         if (pl0 .gt. 0) xkap=(3.-znu0)/(1.+znu0)
c        plane strain
         if (pl0 .lt. 0) xkap=3.-4.*znu0
c
c          {s}=[C]{e}
           dmt(1,1)=g0*tt0/(xkap-1.)*(xkap+1.)
           dmt(1,2)=g0*tt0/(xkap-1.)*(3.-xkap)
           dmt(1,3)=0.
           dmt(2,1)=dmt(1,2)
           dmt(2,2)=dmt(1,1)
cAND       line below missing in JFD original code:
           dmt(2,3)=0.              
           dmt(3,2)=0.
           dmt(3,1)=0.
           dmt(3,2)=0.
           dmt(3,3)=g0*tt0
c
*        do i=1,3
*           write(*,81) (dmt(i,j), j=1,3)
*        enddo
c
c
         xt(1)=x1  
         xt(2)=x2  
         xt(3)=x3  
         yt(1)=y1  
         yt(2)=y2  
         yt(3)=y3  
         f=1.0
         alpha=alpha0
         beta =beta0
c
ctag2
         do i=1,9
            do j=1,9
               ekb(i,j)=0.0
            enddo
         enddo
         m=9
         call sm3mb(xt,yt,dmt,alpha,f,lst,ekb,m)
c
         if (beta .gt. 0.0) then
             fbeta=f*beta
             call sm3mh(xt,yt,dmt,fbeta,lst,ekb,m)
         endif
 81      format(1x,20(g11.5,1x))
 82      format(1x,20(i3,1x))
c
c        assign [ekb] to [18x18]
         inew(1)=1
         inew(2)=2
         inew(3)=6
         inew(4)=7
         inew(5)=8
         inew(6)=12
         inew(7)=13
         inew(8)=14
         inew(9)=18
         do i=1,9
            ii=inew(i)
            do j=1,9
               jj=inew(j)
               ek(ii,jj) = ekb(i,j)
            enddo
         enddo
c
c
      if (DEBUG) then
        write(6,*) '<- subroutine elmstfMRT'
      end if
      return
      end
c
c
c     from Bergan and Felippa, CMAME, 1985
      subroutine elmstfDKT (e0,g0,tt0,zip0,a,x1,x2,x3,y1,y2,y3,ek,ekb) ! {{{1
      implicit none
         real*8 e0, g0, tt0, ip0, a, x1, x2, x3, y1, y2, y3,
     .          znu, dt, det, p1, p2, p3, r1, r2, r3, zip0
         real*8 d(3,3),dd(9,9),qq(9,9),pp(3,3),pt(2,3),rs(2,3),q(3)
         real*8 gg(10,9),b(3),c(3),als(3),px(3,3),ekb(9,9),ek(18,18)
         real*8 sum
         integer ii, jj, i, j, k, k1, k2, l
         integer kod(2,9), inew(9)
         data kod/1,1,2,3,3,2,4,4,5,6,6,5,7,7,8,9,9,8/
         data pp /12.0,4.0,4.0,4.0,2.0,1.0,4.0,1.0,2.0/

         logical    DEBUG
         parameter (DEBUG = .false.)
c
cAND
      if (DEBUG) then
         write(6,*) '-> elmstfDKT'
         call dump_dkt_args('elmstfDKT', e0,g0,tt0,zip0,a,
     .                                   x1,x2,x3,y1,y2,y3)
      end if
cXXX     do i=1,9
cXXX         do j=1,9
cXXX            ekb(i,j) = 0.0
cXXX        end do
cXXX     end do
cXXX     do i=1,18
cXXX         do j=1,18
cXXX            ek(i,j) = 0.0
cXXX        end do
cXXX     end do

         znu = e0/(2.0*g0) - 1.0
         dt=(e0*tt0**3)/12.0/(1-znu*znu)
         dt=(e0*zip0   )     /(1-znu*znu)
         d(1,1) = dt
         d(1,2) =dt*znu
         d(1,3) = 0.0
           d(2,1) =dt*znu
           d(2,2) = dt
           d(2,3) = 0.0
         d(3,1) = 0.0
         d(3,2) = 0.0 
         d(3,3) = dt*(1-znu)/2.0
c
c
         b(1) = y2-y3
         b(2) = y3-y1
         b(3) = y1-y2
         c(1) = x3-x2
         c(2) = x1-x3
         c(3) = x2-x1
         det = 24.0*(b(1)*c(2)-b(2)*c(1))
c
         do 10 i=1,3
            do 10 j=1,3
               px(i,j) = pp(i,j)/det
 10      continue
c
         do 25 i=1,3
            do 25 j=1,3
               do 25 k1=1,3
                  ii=(i-1)*3+k1
                  do 25 k2=1,3
                     jj=(j-1)*3+k2
                     dd(ii,jj)=d(i,j)*px(k1,k2)
cAND
c        write(6,*) 'dd(',ii,',',jj,')=',dd(ii,jj)
 25      continue
c
         do 30 i=1,3
            als(i) = b(i)*b(i)+c(i)*c(i)
            pt(1,i) = 6.0*c(i)/als(i)
            pt(2,i) = 6.0*b(i)/als(i)
            rs(1,i) = 3.0*c(i)*c(i)/als(i)
            rs(2,i) = 3.0*b(i)*b(i)/als(i)
            q(i)    = 3.0*b(i)*c(i)/als(i)
 30      continue
c
         do 720 i=1,10
            do 720 j=1,9
               gg(i,j) = 0.0
 720      continue
c
          do 730 i=1,2
             ii=(i-1)*5
              p1=pt(i,1)
              p2=pt(i,2)
              p3=pt(i,3)
              r1=rs(i,1)
              r2=rs(i,2)
              r3=rs(i,3)
              gg(ii+1,kod(i,1)) =  p3
              gg(ii+2,kod(i,1)) = -p2
              gg(ii+3,kod(i,1)) = -p3
              gg(ii+4,kod(i,1)) =  p2-p3
              gg(ii+5,kod(i,1)) =  p2
                 gg(ii+1,kod(i,2)) = -q(3)
                 gg(ii+2,kod(i,2)) = -q(2)
                 gg(ii+3,kod(i,2)) =  q(3)
                 gg(ii+4,kod(i,2)) =  q(2)+q(3)
                 gg(ii+5,kod(i,2)) =  q(2)
              gg(ii+1,kod(i,3)) = -1.0-r3
              gg(ii+2,kod(i,3)) = -1.0-r2
              gg(ii+3,kod(i,3)) =  r3
              gg(ii+4,kod(i,3)) =  r2+r3
              gg(ii+5,kod(i,3)) =  r2
                      gg(ii+1,kod(i,4)) = -p3
                      gg(ii+3,kod(i,4)) =  p3
                      gg(ii+4,kod(i,4)) = p1+p3
                 gg(ii+1,kod(i,5)) = -q(3)
                 gg(ii+3,kod(i,5)) =  q(3)
                 gg(ii+4,kod(i,5)) =  q(3)-q(1)
              gg(ii+1,kod(i,6)) =  1.0-r3
              gg(ii+3,kod(i,6)) =  r3
              gg(ii+4,kod(i,6)) =  r3-r1
                      gg(ii+2,kod(i,7)) =  p2
                      gg(ii+4,kod(i,7)) = -p1-p2
                      gg(ii+5,kod(i,7)) = -p2  
                 gg(ii+2,kod(i,8)) = -q(2)
                 gg(ii+4,kod(i,8)) =  q(2)-q(1)
                 gg(ii+5,kod(i,8)) =  q(2)
              gg(ii+2,kod(i,9)) =  1.0-r2
              gg(ii+4,kod(i,9)) =  r2-r1
              gg(ii+5,kod(i,9)) =  r2
 730      continue
c
          do 850 i=1,9
             qq(1,i) =     b(2)*gg(1,i) +     b(3)*gg(2,i)
             qq(2,i) = 2.0*b(2)*gg(3,i) +     b(3)*gg(4,i)
             qq(3,i) =     b(2)*gg(4,i) + 2.0*b(3)*gg(5,i)
             qq(4,i) =    -c(2)*gg(6,i) -     c(3)*gg(7,i)
             qq(5,i) =-2.0*c(2)*gg(8,i) -     c(3)*gg(9,i)
             qq(6,i) =-    c(2)*gg(9,i) - 2.0*c(3)*gg(10,i)
             qq(7,i) =     c(2)*gg(1,i) +     c(3)*gg(2 ,i)
     &                    -b(2)*gg(6,i) -     b(3)*gg(7,i)
             qq(8,i) = 2.0*c(2)*gg(3,i) +     c(3)*gg(4 ,i)
     &                -2.0*b(2)*gg(8,i) -     b(3)*gg(9,i)
             qq(9,i) =     c(2)*gg(4,i) + 2.0*c(3)*gg(5 ,i)
     &                -    b(2)*gg(9,i) - 2.0*b(3)*gg(10,i)
 850      continue
c
         do 855 i=1,9
            do 855 j=1,9
               gg(i,j) = 0.0
               do 855 k=1,9
                  gg(i,j) = gg(i,j) + dd(i,k)*qq(k,j)
 855      continue
c
         do 960 L=1,9
            do 960 j=L,9
               sum = 0.0
               do 900 k=1,9
                  sum = sum  + qq(k,L)*gg(k,j)
cAND
c              write(6,*) 'qq(',k,',',l,')=',qq(k,l),
c    .                    '  gg(',k,',',j,')=',gg(k,j)
 900           continue
               ekb(L,j)=sum
               ekb(j,L)=sum
 960      continue
c
c
c        assign to full element matrix
         inew(1)=3
         inew(2)=4
         inew(3)=5
         inew(4)=9
         inew(5)=10
         inew(6)=11
         inew(7)=15
         inew(8)=16
         inew(9)=17
         do i=1,9
            ii=inew(i)
            do j=1,9
               jj=inew(j)
               ek(ii,jj) = ekb(i,j)
cAND
cXXX           write(6,*) 'ek(',ii,',',jj,')=',ek(ii,jj)
            enddo
         enddo
c
c
cAND
cXXX  call dump_matrix('elmstfDKT ekb',  9, 9, ekb)
cXXX  call dump_matrix('elmstfDKT ek',  18,18, ek)
      return
      end
c     1}}}
      subroutine sm3mb(x,y,dm,alpha,f,ls,sm,m) ! {{{1
      implicit none
      integer  m    ! not used
c        basic stiffness
         real*8 x(3), y(3),dm(3,3),sm(9,9)
         real*8 p(9,3)
         real*8 alpha,f,area2,c
         real*8 d11,d12,d13,d22,d23,d33
         real*8 x21,x32,x13,y21,y32,y13
         real*8 x12,x23,x31,y12,y23,y31
         real*8 s1,s2,s3
         integer  ls(9), i, j, k, l, n
         logical    DEBUG
         parameter (DEBUG = .false.)
      if (DEBUG) then
         write(6,*) '-> subroutine sm3mb'
      end if
c
         x21 = x(2) - x(1)
         x32 = x(3) - x(2)
         x13 = x(1) - x(3)
         x12 = -x21          
         x23 = -x32 
         x31 = -x13 
c
         y21 = y(2) - y(1)
         y32 = y(3) - y(2)
         y13 = y(1) - y(3)
         y12 = -y21          
         y23 = -y32 
         y31 = -y13 
c
         area2 = y21*x13 - x21*y13
****     write(*,*)'@@ AREA x 2: ',area2
         p(1,1) = y23
         p(2,1) = 0.0
         p(3,1) = y31
         p(4,1) = 0.0
         p(5,1) = y12
         p(6,1) = 0.0
           p(1,2) = 0.0
           p(2,2) = x32
           p(3,2) = 0.0
           p(4,2) = x13
           p(5,2) = 0.0
           p(6,2) = x21
         p(1,3) = x32
         p(2,3) = y23
         p(3,3) = x13
         p(4,3) = y31
         p(5,3) = x21
         p(6,3) = y12
         n=6
c
**        write(*,*) 'ALPHA: ',alpha
         if (alpha .ne. 0.0) then
             p(7,1) = y23 * (y13-y21)*alpha/6.0
             p(7,2) = x32 * (x31-x12)*alpha/6.0
             p(7,3) =       (x31*y13-x12*y21)*alpha/3.0
               p(8,1) = y31 * (y21-y32)*alpha/6.0
               p(8,2) = x13 * (x12-x23)*alpha/6.0
               p(8,3) =       (x12*y21-x23*y32)*alpha/3.0
             p(9,1) = y12 * (y32-y13)*alpha/6.0
             p(9,2) = x21 * (x23-x31)*alpha/6.0
             p(9,3) =       (x23*y32-x31*y13)*alpha/3.0
             n=9
         endif
c
         c= 0.5*f/area2
         d11 = c*dm(1,1)
         d22 = c*dm(2,2)
         d33 = c*dm(3,3)
         d12 = c*dm(1,2)
         d13 = c*dm(1,3)
         d23 = c*dm(2,3)
         do 3000 j=1,n
            l  = ls(j)
            s1 = d11*p(j,1) + d12*p(j,2) + d13*p(j,3)
            s2 = d12*p(j,1) + d22*p(j,2) + d23*p(j,3)
            s3 = d13*p(j,1) + d23*p(j,2) + d33*p(j,3)
            do 2500 i=1,j
               k = ls(i)
               sm(k,l) = sm(k,l) + (s1*p(i,1) + s2*p(i,2) + s3*p(i,3))
               sm(l,k) = sm(k,l)
 2500       continue
 3000    continue
c
      if (DEBUG) then
        write(6,*) '<- subroutine sm3mb'
      end if
      return
      end
c
c
      subroutine sm3mh(x,y,dm,f,ls,sm,m) ! {{{1
      implicit none
      integer  m    ! not used
c        higher stiffness
         real*8 x(3), y(3),dm(3,3),sm(9,9)
         real*8 xc(3), yc(3), xm(3),ym(3)
         real*8 bh(3,3),gt(9,9),hh(3,9)
         real*8 sqh(3,3), t(9), qx(3,3),qy(3,3)
         real*8 p(9,3)
         real*8 alpha,f,area,area2,c
         real*8 a1j, a2j, a3j, b1j, b2j,b3j
         real*8 d11,d12,d13,d22,d23,d33,jxx,jxy,jyy
         real*8 x0, y0, xi,yi
         real*8 cj, sj,dl,dx,dy
         real*8 s1,s2,s3,s4,s5,s6
         integer  ls(9), iperm(9), i, j, k, l, info
         real*8   gti(9,9),wk(9,9)
         logical    DEBUG
         parameter (DEBUG = .false.)
c
c
      if (DEBUG) then
         write(6,*) '-> subroutine sm3mh'
      end if
         area2 = (y(2) -y(1))*(x(1)-x(3)) - (x(2)-x(1))*(y(1)-y(3))
**       write(*,*)'@@ AREA x 2: ',area2
c
         x0 = (x(1)+x(2)+x(3))/3.0
         y0 = (y(1)+y(2)+y(3))/3.0
         area=0.5*area2
         c = 1.0/sqrt(area)
c
         xc(1) = c*(x(1)-x0)
         xc(2) = c*(x(2)-x0)
         xc(3) = c*(x(3)-x0)
           yc(1) = c*(y(1)-y0)
           yc(2) = c*(y(2)-y0)
           yc(3) = c*(y(3)-y0)
         xm(1) = 0.5*(xc(2)+xc(3))
         xm(2) = 0.5*(xc(3)+xc(1))
         xm(3) = 0.5*(xc(1)+xc(2))
           ym(1) = 0.5*(yc(2)+yc(3))
           ym(2) = 0.5*(yc(3)+yc(1))
           ym(3) = 0.5*(yc(1)+yc(2))
c
c        form G^T in GT and initialize HH
c
          do 1300 i=1,9
             do 1200 j=1,6
                gt(j,i) = 0
 1200        continue
             hh(1,i)=0
             hh(2,i)=0
             hh(3,i)=0
 1300     continue
c
         d11 = f*dm(1,1)
         d22 = f*dm(2,2)
         d33 = f*dm(3,3)
         d12 = f*dm(1,2)
         d13 = f*dm(1,3)
         d23 = f*dm(2,3)
         jxx = -2.0*(xc(1)*xc(2) + xc(2)*xc(3) + xc(3)*xc(1))/3.0
         jxy =      (xc(1)*yc(1) + xc(2)*yc(2) + xc(3)*yc(3))/3.0
         jyy = -2.0*(yc(1)*yc(2) + yc(2)*yc(3) + yc(3)*yc(1))/3.0
         do 2500 j=1,3
            dx = xm(j) - xc(j)
            dy = ym(j) - yc(j)
            dl = sqrt(dx*dx + dy*dy)
            cj = dx/dl
            sj = dy/dl
c
c           !!!a2j b2j different than paper
            a1j = -0.5*sj*cj**2
            a2j =  0.5*cj**3
            b2j = -0.5*sj**3
            b3j =  0.5*sj**2*cj
            a3j = -(b2j + a1j + a1j)
            b1j = -(b3j + b3j + a2j)
c
	    gt(1,2*j-1) =	1.
	    gt(2,2*j  ) =   1.
	    gt(3,2*j-1) =  -yc(j)
	    gt(3,2*j  )=  xc(j)
	    gt(3,  j+6)=   c
	    gt(4,2*j-1)=  xc(j)
	    gt(6,2*j-1)=  yc(j)
	    gt(5,2*j  )=  yc(j)
	    gt(6,2*j  )=  xc(j)
            hh(j,j+6) =     1.
	    qx(j,1)	=      a1j
	    qx(j,2)	=      b2j
	    qx(j,3)	=     -2.0*b3j
	    qy(j,1)	=      a2j
	    qy(j,2)	=      b3j
	    qy(j,3)	=     -2.0*a1j
	    s1 =	 d11*qx(j,1)	+ d12*qx(j,2)	+ d13*qx(j,3)
	    s2 =	 d12*qx(j,1)	+ d22*qx(j,2)	+ d23*qx(j,3)
	    s3 =	 d13*qx(j,1)	+ d23*qx(j,2)	+ d33*qx(j,3)
	    s4 =	 d11*qy(j,1)	+ d12*qy(j,2)	+ d13*qy(j,3)
	    s5 =	 d12*qy(j,1)	+ d22*qy(j,2)	+ d23*qy(j,3)
	    s6 =	 d13*qy(j,1)	+ d23*qy(j,2)	+ d33*qy(j,3)
	    do 2200	 i = 1,3
	      xi =	  xc(i)
	      yi =	  yc(i)
	      gt(j+6,2*i-1) =    a1j*xi*xi + 2.*a2j*xi*yi + a3j*yi*yi
	      gt(j+6,2*i)   =    b1j*xi*xi + 2.*b2j*xi*yi + b3j*yi*yi
	      gt(j+6,i+6)   =   -c*(cj*xi+sj*yi)
 2200	  continue
	do 2400  i=1,j
	  sqh(i,j) = jxx*( qx(i,1)*s1+qx(i,2)*s2+qx(i,3)*s3)
     &             + jxy*( qx(i,1)*s4+qx(i,2)*s5+qx(i,3)*s6
     &                    +qy(i,1)*s1+qy(i,2)*s2+qy(i,3)*s3)
     &	           + jyy*( qy(i,1)*s4+qy(i,2)*s5+qy(i,3)*s6)
 2400	  continue
 2500	continue
C
C	Factor G' and backsolve to obtain H
C	       Form physical stiffness and add to incoming SM
        do i=1,9
           do j=1,9
              gti(i,j)=gt(i,j)
           enddo
        enddo
cAND
cXXX    write(6,*) 'calling ainver in sm3mh'
cXXX    write(6,'(a,9(i4,x))') 'iperm', (iperm(i), i=1,9)
cXXX    call dump_matrix('sm3mh gt',  9,9, gt)
cXXX    if (.false.) then
cXXX    call ainver(gt,9,iperm,wk)
cXXX    else
        CALL DGETRF(9, 9, gt, 9, iperm, info)
        CALL DGETRI(9, gt, 9, iperm, wk, 81, info)
cXXX    end if

        do i=1,3
           do j=1,9
              hh(i,j)=gt(j,i+6)
           enddo
        enddo
        do 4000 j = 1,9
	   l = ls(j)
           s1 = sqh(1,1)*hh(1,j) + sqh(1,2)*hh(2,j) + sqh(1,3)*hh(3,j)
           s2 = sqh(1,2)*hh(1,j) + sqh(2,2)*hh(2,j) + sqh(2,3)*hh(3,j)
           s3 = sqh(1,3)*hh(1,j) + sqh(2,3)*hh(2,j) + sqh(3,3)*hh(3,j)
	   do 3500  i = 1,j
	      k = ls(i)
              sm(k,l) = sm(k,l) + (s1*hh(1,i) + s2*hh(2,i) + s3*hh(3,i))
              sm(l,k) = sm(k,l)
 3500      continue
 4000   continue
c
 81      format(1x,20(g11.5,1x))
c
      if (DEBUG) then
        write(6,*) '<- subroutine sm3mh'
      end if
      return
      end
c
c
      subroutine dump_dkt_args(title, e0,g0,tt0,zip0,a, ! {{{1
     .                         x1,x2,x3,y1,y2,y3)
      implicit none
      real*8        e0, g0, tt0, zip0, a, x1, x2, x3, y1, y2, y3
      character*(*) title
      write(6,*) 'title=',title
      write(6,*) 'e0   =',e0   
      write(6,*) 'g0   =',g0   
      write(6,*) 'tt0  =',tt0  
      write(6,*) 'zip0 =',zip0 
      write(6,*) 'a    =',a    
      write(6,*) 'x1   =',x1   
      write(6,*) 'x2   =',x2   
      write(6,*) 'x3   =',x3   
      write(6,*) 'y1   =',y1   
      write(6,*) 'y2   =',y2   
      write(6,*) 'y3   =',y3   
      return
      end
c     1}}}
      subroutine dump_mrt_args(title, e0,g0,tt0,pl0,alpha0, !  {{{1
     .                     beta0,a, x1,x2,x3,y1,y2,y3)
      implicit none
      character*(*) title
      real*8  e0, g0, tt0, alpha0, beta0, a, x1, x2, x3, y1, y2, y3
      integer pl0

      write(6,*) 'title  =',title
      write(6,*) 'e0     =',e0 
      write(6,*) 'g0     =',g0 
      write(6,*) 'tt0    =',tt0 
      write(6,*) 'pl0    =',pl0 
      write(6,*) 'alpha0 =',alpha0 
      write(6,*) 'beta0  =',beta0 
      write(6,*) 'a      =',a 
      write(6,*) 'x1     =',x1 
      write(6,*) 'x2     =',x2 
      write(6,*) 'x3     =',x3 
      write(6,*) 'y1     =',y1 
      write(6,*) 'y2     =',y2 
      write(6,*) 'y3     =',y3 
      return
      end
c     1}}}

      subroutine elmmasCST( rho, area, th, em, ilump)   ! {{{1
c
c
c     ELeMent MASs matrix for Constant Strain Triangle
c
c            include 'commons.std'
c
         implicit none
         integer inew(9), ii, jj, i, j, ilump
         real*8   em(18,18), emb(9,9), roat, rho, area, th
c
         do 10 i = 1,9
            do 12 j = 1,9
               emb(i,j) = 0.0
 12         continue
 10      continue
c
         if (ilump.eq.1) then
c           contibutions to lumped mass matrix
            roat = rho*area*th/3.0
            emb(1,1) = roat
            emb(2,2) = roat
            emb(3,3) = roat
            emb(4,4) = roat
            emb(5,5) = roat
            emb(6,6) = roat
            emb(7,7) = roat
            emb(8,8) = roat
            emb(9,9) = roat
c
         elseif (ilump.eq.2) then
c           consistent mass matrix
            roat = rho*area*th/12.0
            emb(1,1) = roat*2
            emb(1,4) = roat
            emb(1,7) = roat
               emb(4,1) = roat
               emb(4,4) = roat*2
               emb(4,7) = roat
                  emb(7,1) = roat
                  emb(7,4) = roat
                  emb(7,7) = roat*2
            emb(2,2) = roat*2
            emb(2,5) = roat
            emb(2,8) = roat
               emb(5,2) = roat
               emb(5,5) = roat*2
               emb(5,8) = roat
                  emb(8,2) = roat
                  emb(8,5) = roat
                  emb(8,8) = roat*2
            emb(3,3) = roat*2
            emb(3,6) = roat
            emb(3,9) = roat
               emb(6,3) = roat
               emb(6,6) = roat*2
               emb(6,9) = roat
                  emb(9,3) = roat
                  emb(9,6) = roat
                  emb(9,9) = roat*2
         endif
c
c        assign to full element matrix
         inew(1)=1
         inew(2)=2
         inew(3)=3
         inew(4)=7
         inew(5)=8
         inew(6)=9
         inew(7)=13
         inew(8)=14
         inew(9)=15
         do i=1,9
            ii=inew(i)
            do j=1,9
               jj=inew(j)
               em(ii,jj) = emb(i,j)
            enddo
         enddo
c
      return
      end
c 1}}}
      subroutine elmmasMRT( rho, area, th, em,   ! {{{1
     &                           x1,x2,x3,y1,y2,y3, ilump)
c
c
c     ELeMent MASs matrix for Moment Rotation Triangle
c
c            include 'commons.std'
c
         implicit none
         integer inew(9), ii, jj, i, j, ilump
         real*8  em(18,18), emb(9,9), rho, area, th, roat, rad, alpha,
     .                           x1, x2, x3, y1, y2, y3

c
         do 10 i = 1,9
            do 12 j = 1,9
               emb(i,j) = 0.0
 12         continue
 10      continue
c
c        local: u v . . . phiz ......
         if (ilump.eq.1) then
c           contibutions to lumped mass matrix
            roat = rho*area*th/3.0
            rad  = sqrt(area/3.0)
            alpha=1.0e-1
            emb(1,1) = roat
            emb(2,2) = roat
            emb(3,3) = roat*rad*rad*alpha
            emb(4,4) = roat
            emb(5,5) = roat
            emb(6,6) = roat*rad*rad*alpha
            emb(7,7) = roat
            emb(8,8) = roat
            emb(9,9) = roat*rad*rad*alpha
c
         elseif (ilump.eq.2) then
c           consistent mass matrix
            roat = rho*area*th/12.0
            rad  = sqrt(area/3.0)
            alpha=1.0e-1
            emb(1,1) = roat*2
            emb(1,4) = roat
            emb(1,7) = roat
               emb(4,1) = roat
               emb(4,4) = roat*2
               emb(4,7) = roat
                  emb(7,1) = roat
                  emb(7,4) = roat
                  emb(7,7) = roat*2
            emb(2,2) = roat*2
            emb(2,5) = roat
            emb(2,8) = roat
               emb(5,2) = roat
               emb(5,5) = roat*2
               emb(5,8) = roat
                  emb(8,2) = roat
                  emb(8,5) = roat
                  emb(8,8) = roat*2
            emb(3,3) = roat*rad*rad*alpha
            emb(3,6) = 0.0  
            emb(3,9) = 0.0  
               emb(6,3) = 0.0  
               emb(6,6) = roat*rad*rad*alpha
               emb(6,9) = 0.0  
                  emb(9,3) = 0.0  
                  emb(9,6) = 0.0  
                  emb(9,9) = roat*rad*rad*alpha
         endif
c
c        assign to full element matrix
         inew(1)=1
         inew(2)=2
         inew(3)=6
         inew(4)=7
         inew(5)=8
         inew(6)=12
         inew(7)=13
         inew(8)=14
         inew(9)=18
         do i=1,9
            ii=inew(i)
            do j=1,9
               jj=inew(j)
               em(ii,jj) = emb(i,j)
            enddo
         enddo
c
      return
      end
c 1}}}
      subroutine elmmasPLT( rho, area, th, em,   ! {{{1
     &                           x1,x2,x3,y1,y2,y3, ilump)
c
c
c     ELeMent MASs matrix for PLaTe: triangle
c
c               include 'commons.std'
c               COMMON /EQb/ DELTA 
c
         implicit none
         external hrs
         real*8   hrs
         real*8  rho, area, th, DELTA, DELTA1, DELTA2, roat, alpha,
     .           hrs002, hrs011, hrs013, hrs020, hrs022, hrs024, hrs031, 
     .           hrs033, hrs042, hrs101, hrs103, hrs110, hrs112, 
     .           hrs114, hrs121, hrs123, hrs130, hrs132, hrs141, hrs200, 
     .           hrs202, hrs204, hrs211, hrs213, hrs220, hrs222, hrs231, 
     .           hrs240, hrs301, hrs303, hrs310, hrs312, hrs321, hrs330, 
     .           hrs402, hrs411, hrs420,
     .           x1,x2,x3,y1,y2,y3
         real*8  em(18,18), emb(9,9)
         real*8  A(9,9),CC(9,9),ca(9,9),yn(9,9)
         integer indx(9), inew(9), info, K0, K1, K2, K3, K4,
     .           ia, ii, jj, i, j, ilump, A1, A2, A3, B1, B2, B3

c
c
         do 10 i = 1,9
            do 12 j = 1,9
               emb(i,j) = 0.0
 12         continue
 10      continue
c
         if (ilump.eq.1) then
c           contibutions to lumped mass matrix
            roat = rho*area*th/3.0
            alpha=1.0e-6
            emb(1,1) = roat
            emb(2,2) = roat*alpha
            emb(3,3) = roat*alpha
            emb(4,4) = roat
            emb(5,5) = roat*alpha
            emb(6,6) = roat*alpha
            emb(7,7) = roat
            emb(8,8) = roat*alpha
            emb(9,9) = roat*alpha
c
         elseif (ilump.eq.2) then
c
            DELTA1=(X2-X1)*(Y3-Y1)
            DELTA2=(Y2-Y1)*(X3-X1)
            DELTA=.5*(DELTA1-DELTA2)
            A1=X3-X2
            A2=X1-X3
            A3=X2-X1
            B1=Y2-Y3
            B2=Y3-Y1
            B3=Y1-Y2
c
C      CONSTRUCT MATRIX [A] 
            DO 22 I = 1,9 
               DO 22 J = 1,9 
                  A(I,J) = 0.0
 22         continue
            A(1,1)=2.*DELTA 
              A(2,1)=A1 
              A(2,2)=A2 
              A(2,3)=A3 
              A(2,6)=A3 
              A(2,7)=A2 
                A(3,1)=-B1
                A(3,2)=-B2
                A(3,3)=-B3
                A(3,6)=-B3
                A(3,7)=-B2
            A(4,2)=2.*DELTA 
              A(5,1)=A1 
              A(5,2)=A2 
              A(5,3)=A3 
              A(5,4)=A1 
              A(5,8)=A3 
                A(6,1)=-B1
                A(6,2)=-B2
                A(6,3)=-B3
                A(6,4)=-B1
                A(6,8)=-B3
            A(7,3)=2.*DELTA 
              A(8,1)=A1 
              A(8,2)=A2 
              A(8,3)=A3 
              A(8,5)=A2 
              A(8,9)=A1 
                A(9,1)=-B1
                A(9,2)=-B2
                A(9,3)=-B3
                A(9,5)=-B2
                A(9,9)=-B1
            DO 23 I=1,9
               DO 23 J=1,9 
                  A(I,J)=A(I,J)/(2.*DELTA)
 23         continue
c
C****************************************************************** 
C      INVERT MATRIX [A]  after  [A] CONTAINS THE INVERSION 
            ia = 9
cXXX        call ainver(a,ia,indx,yn)
            CALL DGETRF(ia, ia, a, ia, indx, info)
            CALL DGETRI(ia, a, ia, indx, yn, ia*ia, info)
C****************************************************************** 
      K0 = 0
      K1 = 1
      K2 = 2
      k3 = 3
      k4 = 4
c           lumped mass matrix
            roat = rho*th
ccccccc   much duplication
               hrs002  = hrs(k0,k0,k2,delta)
               hrs011  = hrs(k0,k1,k1,delta)
               hrs013  = hrs(k0,k1,k3,delta) 
               hrs020  = hrs(k0,k2,k0,delta)
               hrs022  = hrs(k0,k2,k2,delta) 
               hrs024  = hrs(k0,k2,k4,delta)
               hrs031  = hrs(k0,k3,k1,delta)
               hrs033  = hrs(k0,k3,k3,delta) 
               hrs042  = hrs(k0,k4,k2,delta) 
            hrs101  = hrs(k1,k0,k1,delta)
            hrs103  = hrs(k1,k0,k3,delta) 
            hrs110  = hrs(k1,k0,k1,delta)
c
            hrs110  = hrs(k1,k1,k0,delta)
            hrs112  = hrs(k1,k1,k2,delta)
            hrs114  = hrs(k1,k1,k4,delta) 
            hrs121  = hrs(k1,k2,k1,delta)
            hrs123  = hrs(k1,k2,k3,delta)
            hrs130  = hrs(k1,k3,k0,delta) 
            hrs132  = hrs(k1,k3,k2,delta) 
            hrs141  = hrs(k1,k4,k1,delta) 
               hrs200  = hrs(k2,k0,k0,delta)
               hrs202  = hrs(k2,k0,k2,delta) 
               hrs204  = hrs(k2,k0,k4,delta) 
               hrs211  = hrs(k2,k1,k1,delta)
               hrs213  = hrs(k2,k1,k3,delta)
               hrs220  = hrs(k2,k2,k0,delta)
               hrs222  = hrs(k2,k2,k2,delta)
               hrs231  = hrs(k2,k3,k1,delta)
               hrs240  = hrs(k2,k4,k0,delta)
            hrs301  = hrs(k3,k0,k1,delta)
            hrs303  = hrs(k3,k0,k3,delta) 
            hrs310  = hrs(k3,k1,k0,delta) 
            hrs312  = hrs(k3,k1,k2,delta)
            hrs321  = hrs(k3,k2,k1,delta) 
            hrs330  = hrs(k3,k3,k0,delta) 
               hrs402  = hrs(k4,k0,k2,delta) 
               hrs411  = hrs(k4,k1,k1,delta) 
               hrs420  = hrs(k4,k2,k0,delta) 
c
            cc(1,1) = hrs200       
            cc(1,2) = hrs110       
            cc(1,3) = hrs101       
            cc(1,4) = hrs220        + hrs211 /2.0
            cc(1,5) = hrs112        + hrs211 /2.0
            cc(1,6) = hrs301        + hrs211 /2.0
            cc(1,7) = hrs310        + hrs211 /2.0
            cc(1,8) = hrs121        + hrs211 /2.0
            cc(1,9) = hrs202        + hrs211 /2.0
               cc(2,2) = hrs020       
               cc(2,3) = hrs011       
               cc(2,4) = hrs130        + hrs121 /2.0
               cc(2,5) = hrs022        + hrs121 /2.0
               cc(2,6) = hrs211        + hrs121 /2.0
               cc(2,7) = hrs220        + hrs121 /2.0
               cc(2,8) = hrs031        + hrs121 /2.0
               cc(2,9) = hrs112        + hrs121 /2.0
            cc(3,3) = hrs002       
            cc(3,4) = hrs121        + hrs112 /2.0
            cc(3,5) = hrs013        + hrs112 /2.0
            cc(3,6) = hrs202        + hrs112 /2.0
            cc(3,7) = hrs211        + hrs112 /2.0
            cc(3,8) = hrs022        + hrs112 /2.0
            cc(3,9) = hrs103        + hrs112 /2.0
               cc(4,4) = hrs240 + hrs222  /4.0+   hrs231       
               cc(4,5) = hrs132 + hrs222  /4.0+  (hrs123  +hrs231)/2
               cc(4,6) = hrs321 + hrs222  /4.0+  (hrs312  +hrs231)/2
               cc(4,7) = hrs330 + hrs222  /4.0+  (hrs321  +hrs231)/2
               cc(4,8) = hrs141 + hrs222  /4.0+  (hrs132  +hrs231)/2
               cc(4,9) = hrs222 + hrs222  /4.0+  (hrs213  +hrs231)/2
            cc(5,5) = hrs024 + hrs222 /4.0+ (hrs123 +hrs123)/2
            cc(5,6) = hrs213 + hrs222 /4.0+ (hrs312 +hrs123)/2
            cc(5,7) = hrs222 + hrs222 /4.0+ (hrs321 +hrs123)/2
            cc(5,8) = hrs033 + hrs222 /4.0+ (hrs132 +hrs123)/2
            cc(5,9) = hrs114 + hrs222 /4.0+ (hrs213 +hrs123)/2
               cc(6,6) = hrs402 + hrs222 /4.0+    (hrs312 +hrs312 )/2
               cc(6,7) = hrs411 + hrs222 /4.0+    (hrs321 +hrs312 )/2
               cc(6,8) = hrs222 + hrs222 /4.0+    (hrs132 +hrs312 )/2
               cc(6,9) = hrs303 + hrs222 /4.0+    (hrs213 +hrs312 )/2
            cc(7,7) = hrs420 + hrs222 /4.0+    (hrs321 +hrs321 )/2
            cc(7,8) = hrs231 + hrs222 /4.0+    (hrs132 +hrs321 )/2
            cc(7,9) = hrs312 + hrs222 /4.0+    (hrs213 +hrs321 )/2
               cc(8,8) = hrs042 + hrs222 /4.0+    (hrs132 +hrs132 )/2
               cc(8,9) = hrs123 + hrs222 /4.0+    (hrs213 +hrs132 )/2
            cc(9,9) = hrs204 + hrs222 /4.0+       (hrs213 +hrs213 )/2
c           impose symmetry
            do i=1,9
               do j=i+1,9
                  cc(j,i) = cc(i,j)
               enddo
            enddo
            do i=1,9
               do j=1,9
                  cc(i,j) = cc(i,j)*roat
               enddo
            enddo
c
c           form product    [A]trans x ([CC] x [A])
            call DAxB (cc,9,9,a,9,9,ca)
            call DtAxB (a,9,9,ca,9,9,emb)
c
         endif
c
c        assign to full element matrix
         inew(1)=3
         inew(2)=4
         inew(3)=5
         inew(4)=9
         inew(5)=10
         inew(6)=11
         inew(7)=15
         inew(8)=16
         inew(9)=17
         do i=1,9
            ii=inew(i)
            do j=1,9
               jj=inew(j)
               em(ii,jj) = emb(i,j)
            enddo
         enddo
c
c
      return
      end
c 1}}}
      real*8 function hrs(IR,IS,IT,delta)  ! {{{1
      implicit none
c
c
c
C****************************************************************** 
C       COMPUTE THE INTEGRAL OF (L1**IR)*(L2**IS)*(L3**IT)
C        OVER THE REGION OF EACH ELEMENT
C****************************************************************** 
         real*8  facr, facs, fact, facrst, delta
         integer IRST, IR, IS, IT, i, j, k, l
         FACR=1. 
         FACS=1.0
         FACT=1.0
         FACRST=1.0
         IRST=IR+IS+IT+2.
         DO 5 I=1,IR 
   5        FACR=FACR*I 
         DO 10 J=1,IS
   10       FACS=FACS*J 
         DO 15 K=1,IT
   15       FACT=FACT*K 
         DO 20 L=1,IRST
   20       FACRST=FACRST*L 
         HRS=2.*DELTA*FACR*FACS*FACT/FACRST
c
      RETURN
      END 
c 1}}}
      subroutine DAxB (A,nra,nca,B,nrb,ncb,C)   ! {{{1
         implicit none
         integer nra, nca, nrb, ncb, i, j, k
         real*8  A(nra,nca),B(nrb,ncb),C(nra,ncb)
         real*8  sum
c
c
c     Double precision [A] times [B]
c
         do i=1,nra
            do j=1,ncb
               sum=0.0
               do k=1,nca
                  sum=sum+A(i,k)*B(k,j)
               enddo
               C(i,j)=sum
            enddo
         enddo
c
      return
      end
c 1}}}
      subroutine DtAxB (A,nra,nca,B,nrb,ncb,C)    ! {{{1
         implicit none
c
c
c     Double precision [A]trans times [B]
         integer nra, nca, nrb, ncb, i, j, k
         real*8  A(nra,nca),B(nrb,ncb),C(nca,ncb)
         real*8  sum
c
         do i=1,nca
            do j=1,ncb
               sum=0.0
               do k=1,nra
                  sum=sum+a(k,i)*B(k,j)
               enddo
               C(i,j)=sum
            enddo
         enddo
c
      return
      end
c 1}}}
