\ File usr/ukey.v (at usrpath)

\  User additional words at interactive boot time.

\  When this file is present, it will be sourced by key.v during start 
\  up.

   "ukey_done" exists?
   IF ukey_done
      IF " ukey.v: only at start up" . nl halt THEN \ only source once
   THEN

\  The words from sys/ukey.v are obtained by sourcing it first, and
\  then you can override or add to them with the ones in this version.

\  Sourcing the system sys/ukey.v if it is found:
   syspath "ukey.v" cat filefound IF source THEN

\  What follows is run at start up, after the system's sys/ukey.v runs.

\  Phrases always run at interactive start up go below here.

\-----------------------------------------------------------------------

\  Begin xterm display settings to override defaults.

\  Banking xterm display settings in word xterm:
   TERM (qS)
   "-bg PeachPuff3 -fg Black -cr Firebrick4 -fn 7x14 " cat
   "-display " "DISPLAY" env spaced cat cat
   "+sb -geometry 72x32+1+1 -title " cat (qS)
   "xterm" "XSET" bank \ into word xterm

\  Want to use settings of word xterm for vi too (into word _vi):
   "xterm" "XSET" yank (qS) \ yank the ones from xterm
   (qS) "_vi" "viXSET" bank \ bank them into word _vi

\  Banking xterm settings for vim (they go into word _vim):
   TERM (qS)
   "-bg Black -fg White -cr Salmon2 -fn 7x14 " cat
   "-display " "DISPLAY" env spaced cat cat
   "+sb -geometry 72x32+1+1 -title " cat (qS)
   "_vim" "viXSET" bank \ into word _vim

\  Banking xtermsb (xterm with scroll bar) settings:
   TERM (qS)
   "-bg PeachPuff3 -fg Black -cr Firebrick4 -fn 7x14 " cat
   "-display " "DISPLAY" env spaced cat cat
   "-sb -sl 1024 -geometry 72x32+1+1 -title " cat (qS)
   "xtermsb" "XSET" bank \ into word xtermxb

{  Editor for word eview (banked into word edit).  

   Looking for program nedit for a graphical editor to bank into word 
   edit (used by eview, rview and others).  If not found, bank settings
   to run view (vi read-only) editor:
}  
   "filesearch" "more_places" yank (hT)
   dup push (hT) \ save original

   (hT) "/usr/local/bin" pile
   (hT1) "filesearch" "more_places" bank 
   "nedit" filesearch 

   IF (qS) 
   ELSE  
      TERM
      "-bg Black -fg White -cr Salmon -fn 7x14 " cat
      "-display " "DISPLAY" env spaced cat cat
      "+sb -geometry 72x32+1+1 -e view" cat
   THEN

   (qS) "edit" "XSET" bank \ into word edit
   pull (hT) "filesearch" "more_places" bank \ replace original

\  End xterm display settings.

\-----------------------------------------------------------------------

\  Adding files in my usrpath to the list in word MakeIndex:
   "MakeIndex" exists?
   IF "MakeIndex" "Files" yank (hT)
      "bdf.v fea.v snd.v vmo.v" words pile (hT)
      "MakeIndex" "Files" bank
   THEN

\-----------------------------------------------------------------------

\  My version of word ureset to reset things after a runaway error:

   inline: ureset ( --- ) \ user default settings
{     When present, this word is run after a runaway error is stopped.

      Or ureset can be run any time an error may have messed things up,
      as can happen when new phrases are being written.  Word sane will
      run this word (if present) as it fixes up the display settings.
}
      [ 
      \ The following are my settings that ureset will invoke: 

         "1based, ok on, private, strict, stkbal, xl, -kon, yes catmsg "

      "mysettings" book 
      ] mysettings local \ executing the string 
      " settings made by ureset are:" . nl
      sp sp mysettings 68 .out nl
   end

   30 ertrip \ default level for error tripper

   "gutter" host alike IF 9 ertrip THEN \ my slow 486 machine

   os "aix" alike IF 50 ertrip THEN \ IBM RS 6000

\-----------------------------------------------------------------------

\  Words for remote login to other machines:
   
   getlogin "jdoe" alike \ is it me?
   IF 
      define: clacker "rlogin clacker" xtermsb ;
      define: sigma   "rlogin sigma"   xtermsb ;
      define: gutter  "rlogin gutter"  xtermsb ;

      "toast" host alike
      IF define: bach "rlogin bach" xtermsb ; 
      THEN

   THEN

\-----------------------------------------------------------------------

\  Word tabfill is just too slow for my old 486 machine gutter. 
\  This redefinition will disable tabfill on gutter:
   host "gutter" alike IF define: tabfill (qS f --- ) 2drop beep ; THEN

\-----------------------------------------------------------------------

\  The program exits on Ctrl-D, which is not good if you are working
\  in a nearby vi window and using Ctrl-D to scroll.

\  Do not let Ctrl-D exit the program if I am running (see ignore[] in
\  key.c):
      getlogin "dale" alike getlogin "a113566" alike or
      IF 4 keyignore THEN

\  And don't let it happen to some aix users:
      os "aix" = IF 4 keyignore THEN \ no surprise exit

\-----------------------------------------------------------------------
