\  Testing the code for sparse matrices

   syspath "sparse.v" cat source halt \ source the new file at syspath 

{

PS:  attached are my latest sparse.[ch]  A long ways from fool-proof
but these should be more stable than the ones you have.  Here are my
entries in word.p:

&& native("sparse",   (unsigned long int (*)()) sparse)
&& native("is_sparse",(unsigned long int (*)()) is_sparse)
&& native("dense",    (unsigned long int (*)()) dense)
&& native("speye",    (unsigned long int (*)()) speye)
&& native("spbend",   (unsigned long int (*)()) spbend)
&& native("sprand",   (unsigned long int (*)()) sprand)
&& native("spy",      (unsigned long int (*)()) spy)
&& native("spdiag",   (unsigned long int (*)()) spdiag)
&& native("spdump",   (unsigned long int (*)()) spdump)
&& native("sperror",  (unsigned long int (*)()) sperror)

spy is kind of fun, try something like
  15 70 .3 sprand spy
Again, the name is from the analogous matlab function.  (And no,
we should definitely not use matlab as our standard!)

/*
   sparse.c  - Words for creating and manipulating sparse matrices.
      sparse       - creates a sparse matrix from a dense  matrix
      dense        - creates a dense  matrix from a sparse matrix
      is_sparse    - puts -1 on stack if tos is a sparse matrix; 0 otherwise
      speye        - create sparse identity matrix (name from matlab)
      spbend       - transpose sparse matrix
      sprand       - create sparse random   matrix (name from matlab)
      spy          - display pattern of non-zeros  (name from matlab)
      spdump       - print contents of sparse matrix arrays
      sperror      - perform tests on sparse matrix to see if indices are OK

   Albert Danial  Oct 3-20 2001
 */
}
\ Sat Oct 20 11:40:23 PDT 2001

  '2x5.txt'  5 asciiread sparse is m25
  '9x9.txt'  9 asciiread sparse is m99
  '3x4.txt'  4 asciiread sparse is m34
  '3x3.txt'  3 asciiread sparse is m33
  'null.txt' 4 asciiread sparse is m00
  m25 dup spbend dense swap dense bend - maxfetch drop drop
  m99 dup spbend dense swap dense bend - maxfetch drop drop
  m34 dup spbend dense swap dense bend - maxfetch drop drop
  m33 dup spbend dense swap dense bend - maxfetch drop drop
  m00 dup spbend dense swap dense bend - maxfetch drop drop
{
If there are five zeros on the stack after this that means there
are no errors.  Here's how to make random sparse matrices:

  3 4 .5 sprand

(the numbers are rows, columns, density)
}

{
[user@localhost.localdomain] /home/user/tops/usr > tops
          Tops 2.4
Sat Oct 20 14:36:26 PDT 2001
[tops@localhost] ready > 'sparse.v' source

 stack elements:
       0 number: 0
       1 number: 0
       2 number: 0
       3 number: 0
       4 number: 0
 [5] ok!
[tops@localhost] ready > xx m25 its dims

 stack elements:
       0 number: 128
       1 number: 1
       2 sparse: m25  2 by 5
 [3] ok!
[tops@localhost] ready > xx m25 its spdims

 stack elements:
       0 number: 5
       1 number: 2
       2 sparse: m25  2 by 5
 [3] ok!
[tops@localhost] ready > xx m25 dup sprows, over spcols

 stack elements:
       0 number: 5
       1 number: 2
       2 sparse: m25  2 by 5
 [3] ok!
[tops@localhost] ready > 

}


