/* File eiv.n
   March 2006

   Using the effective impedance vector, EIV.
*/
//----------------------------------------------------------------------

   if(missing("DOF_SET")) source("nas.v");
   if(missing("EIVrows")) source("mmath.v");
   PATH = "/home/dale/nas/";

//----------------------------------------------------------------------

// Read the GSET map (see example below).
   PAT = "G        DISPL"; // 8 spaces for MSC 2004
   T = DOF_SET(PATH + "iso_truss.out", PAT); // read f06 file
   T = matread(strrpl(T, "-", " "), 3);

//----------------------------------------------------------------------

// Read the full model modes (must be .op4 binary).
   closeif("OP4");
   open(old, binary, PATH + "iso_truss.op4", "OP4"); // handle OP4
   toc4(OP4); // show contents

// Fetch frequencies:
   FREQ = get4c(OP4, "LAMA1", 3); // f from 3rd column of LAMX table

// Take frequencies less than 200 Hz:
   (scrap, FREQ) = rake(FREQ, (FREQ < 200));

/* Running eview(FREQ) or .m(FREQ) shows:
 Row 1:    72.06
 Row 2:    107.7
 Row 3:    123.9 */

// Fetch GSET mode shapes that go with FREQs.
   rewind(OP4);
   PHI = get4c(OP4, "UGV", 1:rows(FREQ)); // matrix UGV from SOL 3
   close(OP4);

//----------------------------------------------------------------------

// Defining rows of interest.

/* Function EIVrows ignores terms in mode shapes that are zero.  By
   making rows that are not of interest equal to zero and keeping PHI 
   GSET-size, the important rows reported will match dofs in the GSET 
   map, T. */

/* 1. Keeping only translational dofs.
   The following makes RAKE with true (-1) where column 3 of T is 
   either 4, 5, or 6 and false (0) everywhere else: */
   RAKE = (T[*,3]==4 || T[*,3]==5 || T[*,3]==6); // 0 at 1, 2, or 3

   (PHI, scrap) = rake(PHI, RAKE); // separate trans and rots
   PHI = tier(PHI, null(dims(scrap)), RAKE); // PHI with 0 at rots

/* 2. Keeping only rows that are practical to try: */
   TRY = 
   [1001, 1005, 2005, 101, 3212, 906,
    2001, 2005, 3005, 201, 4212, 806,
    983]' // note ' to transpose row vector into column

   RAKE = null(rows(T), 1);
   DO(rows(TRY),1)
      RAKE = RAKE + [T[*,2]==@TRY[I]]; // true where TRY matches T[*,2]
   LOOP ;
   RAKE = RAKE - true; // 0 where TRY matches T

   (PHI, scrap) = rake(PHI, RAKE); // separate try and no-try
   PHI = tier(PHI, null(dims(scrap)), RAKE); // PHI with 0 at no-TRY

//----------------------------------------------------------------------

/* Run function EIVrows to obtain row candidates that best characterize
   each of the columns of PHI. */

   r = 0.5;
   Arows = EIVrows(PHI, r); // most important rows are first in list
   CANDIDATES = T[Arows];

   iview(CANDIDATES);

   save( // save T candidates to file
      itext(T[Arows]), // binary matrix into integer text
      "candidates.txt" // file name
   );

/*----------------------------------------------------------------------

// Example of DOF map T:

/* Column 1 of T has GSET DOF, column 2 has GRID ID, and column 3 has
   GRID-DOF.

   For example, running iview(T) shows:

   Row 1:        1     1011        1
   Row 2:        2     1011        2
   Row 3:        3     1011        3
   Row 4:        4     1011        4
   Row 5:        5     1011        5
   Row 6:        6     1011        6
   Row 7:        7     1012        1
   Row 8:        8     1012        2
   Row 9:        9     1012        3
...
 
 Row 855:      842     3021        3
 Row 856:      843     3021        4
 Row 857:      844     3021        5
 Row 858:      845     3012        6 */

------------------------------------------------------------------------

/* Scrambling rows to test EIVrows:
   These lines randomly mix up the rows of PHI (and rows of T) to see 
   if EIVrows comes up with the same candidates: */
   MIX = random(rows(PHI), 1);
   PHI = sort([MIX, PHI], yes)[*, 2:cols(PHI)+1]; // mix up PHI rows
   T = sort([MIX, T], yes)[*, 2:cols(T)+1]; // mix up T the same way

   Conclusion: on a symmetric structure, like a flat plate, EIVrows
   may choose different points that have the same modal deformation.

----------------------------------------------------------------------*/
