#include <stdlib.h>
#include <stdio.h>
#include "stk.h"
#include "main.h"
#include "inpo.h"
#include "tag.h"

int pmat() /* ( hA --- ) {{{1 */
/* 
 * man entry:  pmat {{{2
 * (hA --- )  Print the matrix to STDOUT.  Show embedded indices if they exist.  For example:
     3 4 random is A
     A .m nl
     list: 2 1 3 4 ; is C
     list: 3 2 1   ; is R
     A R C add_idx
     pmat
 * category: printing
 * related:  .m
 * 2}}}
 */
{

    int     r, c, indexed = 0, complx, nRow, nCol,
           *row_idx, *col_idx;
    char   *name = "A_idx";
    double *A;

    if (tos->typ != MAT) {
        stkerr(" pmat: ", MATNOT);
        return 0;
    }
    if (is_indexed(tos)) {
        row_idx = MAT_ROW_IDX(tos);
        col_idx = MAT_COL_IDX(tos);
        indexed = 1;
    }
    complx = is_complex(tos);

    nRow = tos->row;
    nCol = tos->col;

    A = tos->mat;

    if (indexed) {
        gprintf("%4s", " ");
        for (c = 0; c < nCol; c++) {
            gprintf("%4s[%2d]%4s", " ", col_idx[c], " ");
        }
        nc();
    }

    for (r = 0; r < nRow; r++) {
        if (indexed) {
            gprintf("[%2d]", row_idx[r], " ");
            if (complx) gprintf("%10s", " ");
        }
        for (c = 0; c < nCol; c++) {
            gprintf("% 10.4e", A[r + c*nRow]);
            if (complx) {
                r++;
                gprintf(",% 10.4e", A[r + c*nRow]);
            }
            gprintf(" ");
        }
        nc();
    }
    drop();

    return 1;
} /* 1}}} */
