\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{  File web.v  July 2000

   Copyright (c) 2000   D. R. Williamson

   Words for accessing the web.

\-----------------------------------------------------------------------

   Permissions for communication.

      For connecting a data modem, running a voice modem, and sending 
      email, files in /var/log, /var/lock, and /etc/mail need to be 
      accessed.  

      Specific examples are:

         When connecting a data modem to the Internet, /var/log/messages
         or /var/log/ppp is read to monitor connection success and to 
         obtain the local IP address of the connection. 

         When running a voice modem, Mgetty registers it in /var/lock,
         and writes two log files in /var/log.  

         When switching between ISPs, an ISP-specific configuration file
         for sendmail is used in /etc/mail.

      These places are off-limits for ordinary users.

      One approach to allow a non-superuser to work in these regions is
      to create a group, say comm for communication, and place users who
      perform communication into that group with specific permissions on
      just the files they need.

      Shown below are the groups and permissions created by root for 
      directories and files accessed by group comm.  To write a file 
      in a specific directory, permissions must track all the way back
      to the root (slash) directory, /.  Since group comm must write
      files in /var/log and /var/lock, /var has group comm permissions.

      Group comm for var/ in /:
         [gutter@clacker] / > ll
         drwxr-xr-x   26 root   root   4096 Sep 14 05:20 ./
         drwxr-xr-x   26 root   root   4096 Sep 14 05:20 ../
         drwxr-xr-x   70 root   root   8192 Sep 14 05:22 etc/
         drwxr-xr-x   25 root   comm   4096 Mar  2  2003 var/

      Group comm for special sendmail configuration files in /etc/mail:
         [gutter@clacker] /etc/mail > ll
         drwxr-xr-x  2 root comm 4096 Sep 14 06:52 ./
         drwxr-xr-x 70 root comm 8192 Sep 14 05:22 ../
         -rw-r----- 1  root root 7498 Sep 11 07:01 sendmail.cf
         -rw-r----- 1  root comm 7491 Sep 12 12:29 sendmail.earthlink.cf
         -rw-r----- 1  root comm 7494 Sep 12 12:29 sendmail.prodigy.cf

         Files like sendmail.earthlink.cf and sendmail.prodigy.cf are 
         used (read-only) when the program switches ISPs (word send-
         mail_config).

         They are used to run sendmail with the -C switch to specify its
         .cf file; they have group comm permissions because sendmail re-
         quires non-root for its .cf files specified by switch -C.

         File sendmail.cf is left as-is, and is used by the sendmail
         daemon.  

      Group comm for lock/ and log/ in /var:
         [gutter@clacker] /var > ll
         drwxr-xr-x   25 root   comm   4096 Mar  2  2003 ./
         drwxr-xr-x   26 root   root   4096 Sep 14 05:20 ../
         drwxrwxr-x    4 root   comm   1024 Mar 11 18:34 lock/
         drwxr-xr-x   13 root   comm   1024 Mar 11 20:39 log/

         Directory lock has write permission for group comm, so the
         voice modem lock file can be written and deleted.

      Directory /var/log groups and permissions:
         [gutter@clacker] /var/log > ll
         total 1520
         drwxr-xr-x   13 root   comm   1024 Mar 11 20:39 ./
         drwxr-xr-x   22 root   comm   1024 Mar 10 00:37 ../
         -rw-r-----    1 root   comm 239396 Mar 11 20:40 messages
         -rw-rw-r--    1 root   comm    660 Mar 11 06:45 mgetty.unknown
         -rw-r-----    1 root   comm  24699 Mar 11 15:12 ppp
         -rw-rw----    1 root   comm      1 Mar 11 15:13 sendmail
         -rw-rw-r--    1 root   comm 489908 Mar 11 18:34 vm.log

      Files mgetty.unknown and vm.log are written by the voice modem
      code.  File sendmail is written by word pppsend.  Files ppp and
      messages are usual in most Linux installations.

      None of these files should be deleted or the permissions will be 
      lost and errors will occur.  Instead, to erase the sendmail log 
      file shown above, the program crushes it to a 1-byte file by run-
      ning the Unix phrase "echo>/var/log/sendmail" (or word crush) 
      after the file is sent.

      Scripts for dial-up using the point-to-point protocol daemon, 
      pppd, use command line options that can be conveniently placed 
      right on the line invoking pppd.  But when the machine is on a 
      network, one of the command line options, "noauth," may be re-
      quired for pppd authentication to succeed.

      Unfortunately, noauth in the command line requires a root user 
      to run pppd.  However, pppd allows command line options to be de-
      fined in a privileged file in /etc/ppp/peers that it will read, 
      allowing ordinary users to run pppd with noauth.  

      Such a file, called tops_dial, can be created by root in direc-
      tory /etc/ppp/peers:

         [root@clacker] /etc/ppp/peers # ll tops_dial
         -rw-r--r--  1 root  comm  34 Oct  4 21:54 tops_dial

      with these (typical) pppd options that include noauth:

         [root@clacker] /etc/ppp/peers # more tops_dial
         noauth lock crtscts defaultroute 

      Here is a typical pppd script (perhaps created by word pppscript 
      below using the template in sys/ppp.scr) that uses tops_dial by
      invoking the "call" option in the pppd command line:

         #!/bin/sh
         /usr/sbin/pppd user user@earthlink.net /dev/ttyS3 57600 \
         call tops_dial connect \
         "/usr/sbin/chat -v \
         '' '\dATQ0V1&C1&D2M0' OK \
         ATD-82-XXX-YYYY CONNECT--ECT \
         " # ends the segment that began with "/usr/sbin/chat ...

\-----------------------------------------------------------------------

   Installing PPPoE for DSL (September 2006):

      Software for PPPoE (point-to-point on ethernet) can be downloaded
      from www.roaringpenguin.com.

      This is the directory after untarring rp-pppoe-3.8.tar.gz:
         [dale@plunger] /packages/rp-pppoe-3.8 > ll
         drwxr-xr-x    8 dale   comm    4096 Nov 11 14:57 ./
         drwxr-xr-x   12 dale   comm    4096 Oct 16 05:04 ../
         drwxr-xr-x    2 dale   comm    4096 Apr  2  2006 configs/
         drwxr-xr-x    2 dale   comm    4096 Apr  2  2006 doc/
         -rwxr-xr-x    1 dale   comm     884 Apr  2  2006 go*
         -rwxr-xr-x    1 dale   comm    1984 Apr  2  2006 go-gui*
         drwxr-xr-x    3 dale   comm    4096 Sep  2 13:05 gui/
         drwxr-xr-x    2 dale   comm    4096 Apr  2  2006 man/
         -rw-r--r--    1 dale   comm    1944 Apr  2  2006 README
         -rw-r--r--    1 dale   comm    3733 Apr  2  2006 rp-pppoe.spec
         drwxr-xr-x    2 dale   comm    4096 Sep  2 13:05 scripts/
         -rw-r--r--    1 dale   comm     561 Apr  2  2006 SERVPOET
         drwxr-xr-x    4 dale   comm    4096 Sep  2 21:20 src/
         [dale@plunger] /packages/rp-pppoe-3.8 >

         Note on compiling: 

         The gcc compiler fails on src/pppoe.c due to a constant 
         declaration in the body of the code.  This diff shows
         moving it to the beginning of the function:
            diff -b pppoe.c.orig pppoe.c
               411a412
               >     char const *options;
               435a437
               >     openlog("pppoe", 0, 0);
               437d438
               <     char const *options;

         Installing:
            [dale@plunger] /packages/rp-pppoe-3.8/src > ./configure
            [dale@plunger] /packages/rp-pppoe-3.8/src > make
            [dale@plunger] /packages/rp-pppoe-3.8/src > su
            [root@plunger] /packages/rp-pppoe-3.8/src # make install
            [root@plunger] /packages/rp-pppoe-3.8/src # pppoe-setup

      When the package is compiled and installed, shell script file 
      pppoe-start is /usr/sbin and user name and password have been
      written to /etc/ppp/pap-secrets and /etc/ppp/chap-secrets:

         [root@plunger] /home/dale # which pppoe-start
         /usr/sbin/pppoe-start

      The package is ready to use by keying "pppoe-start" to bring up
      the PPPoE link and "pppoe-stop" to bring it down.

      New words below, pppoe-start and pppoe-stop, allow DSL connection
      to be automated with this program.
}
   1based private

\-----------------------------------------------------------------------

\  Words for the web.  

   "_pppconnect" exists? IF halt THEN

   CATMSG "CATMSG_SAVE" book no catmsg

\  Words in this section assume the machine is connected to the web.

   define: From: ( --- qS) \ the "from" email address used by pppsend
      "PORT_LIB" exists? 
      IF PORT_LIB ELSE "" THEN
   end

\  The following works for dialup and PPPOE, that write to the message 
\  log; an example for DSL is in usr/uboot.v:
   define: IPlocal ( --- qS) \ the local IP address when connected
{     Returns latest local IP address as transcribed in message log.

      PPPCON can be used to see if the machine is connected.

      Returns the machine's loopback IP address if none is found.
}
      "_pppconnect" exists? 
      IF "_pppconnect" "log" localrun drop
         "_pppconnect" "IPlocal" yank 
      ELSE "127.0.0.1" \ the machine's loopback address
      THEN
   end

   inline: pppcollect (qS --- f) \ collect data from the web
\     Using script S to collect data from the web.

\     To set timeout to XXX seconds, prior to calling use phrase:
\        XXX "pppcollect" "timeout" implant1

      [ 600 (seconds) is default  
        scalar "timeout" book, default timeout bang 
      ]
      no one STR stkok or, one VOL stkok or not 
      IF "pppcollect" stknot return THEN

      " Running pppcollect " systime$ cat . nl
      " Collecting..." sp sp .

      timeout ontop expectout, (qS) running (f)

      IF yes " collection complete " 
      ELSE fail " collection error "
      THEN (f qS) systime$ cat . nl (f) 
      default timeout bang \ reset timeout to default
   end

   inline: pppsend (hM --- f) \ send a message over the web
{     Assumes the machine is connected to the web.
      Allows timeout seconds, set below, for the message to be sent.

      timeout is a scalar (its address goes on the stack instead of
      its value) in this local library so it can be changed from out-
      side.  Here is a phrase that resets timeout to XXX from anywhere:
         XXX "pppsend" "timeout" implant1

      Look at file /var/log/sendmail to see the log for sending this 
      message.

      Returns true flag if no time out in word running, but this does 
      not mean the message was successfully sent.  A fancier version 
      could grep the log file for signs of success:
         Message accepted for delivery
      or failure:
         host name lookup failure

      The first line of incoming text M contains "To: " followed by 
      the recipient's web name, as in:

         To: w.gates@microsoft.com

      All other lines in M are optional.

      Note that the From: email address used below is defined in file 
      pppcon.v.
}
      [ scalar is timeout \ so it can be changed from outside

        120 (sec) timeout bang \ max time to send message
        10 (sec) is sitting \ idle after send, to delay disconnect

        runid "sendmail" cat is job \ name of script file
        runid "message" cat is message \ name of message file

        "" is script 
      ]
    \ Making the script for sendmail (build this each time because
    \ sender (From:) and .cf file (SENDMAIL.CF) may change):
      "/usr/sbin/sendmail -t -B8BITMIME \"
      "-F " From: cat " \" cat pile
      "-C " SENDMAIL.CF cat " \" cat pile 
      "-X /var/log/sendmail \" pile    \ writing debug to a log file
      "-O ConnectionCacheTimeout=15s < \" pile onto script

      (hM) "." pile chop message save \ last line contains a single dot
 
      script message pile, job save, job 448 chmod

      timeout ontop expectout, job running 
      IF sitting idle true
      ELSE " pppsend timed out" ersys fail
      THEN

      job message delete delete
   end

   inline: SENDMAIL.CF ( --- qFile) \ sendmail config file path+name
      "sendmail_config" "CF" yank ;

   define: webcollect (qGet --- f) \ collect data from the web
\     Running script Get to collect.  Assumes system is connected
\     to the web.
      [ scalar "timeout" book 60 (sec) timeout bang ]

      " Running webcollect " systime$ cat .  nl

      timeout ontop expectout, (qGet) running (f)

      IF " collection complete " systime$ cat . nl yes (f)
      ELSE " collection error " systime$ cat . nl fail (f)
      THEN (f)
   end

\  Beginning marker for example in man said:
   #WGET1 
   inline: wget (qURL --- hT) \ get file from web URL, place it on stack
\     Assumes system is connected to the web.

      [ {" \ Script for system function wget:
          #!/bin/sh
          LOG=wget.log # appending to this log file
          TRY=2        # number of tries
          TIME=30      # time seconds
          URL=
          # wget saves a file named the same as the URL file
          wget -a $LOG -t $TRY -T $TIME $URL
        "} chop "script" book

        {" ( --- qFile) \ last saved file name in wget.log
        \ If wget follows links to other sites, the file saved may not
        \ be named FILE based on the original URL.  This gets the name
        \ of the last file in log:
          logfile file?
          IF logfile 50 tailf reversed
             dup "saved" grepr any?
             IF ontop reach notrailing
                backward "'" tug, backward "`" tug
                notrailing 1st quote
                (qS) '"' 1st byte (c) 1st strput,
                (qS) '"' 1st byte that strlen ndx strput
             ELSE drop ""
             THEN
          ELSE ""
          THEN
        "} "lastfile" inlinex

      ]
      script dup "LOG=" grepr reach vol2str -4 indent 1st word drop 
      "logfile" book

      (qURL) strchop quoted \ need quoted for & symbols (or use \)
      (qURL) this -path makes FILE \ name of URL file
      "URL=" swap (qURL) cat (URL)
      
    \ Replacing line "URL=" in script:
      (URL) script those chars +trailing again dup push
      "URL=" grepe ontop said pull (hScr)
      
    \ Moving any existing file to .sav:
      FILE quoted file? 
      IF SBIN "mv " cat FILE quoted spaced FILE ".sav" cat quoted
         cat cat minshell 
      THEN

    \ Saving current timeout from word expecting and setting new one
    \ that is 25% above TIME*TRY in the wget script:
      "expecting" "timeout" extract ontop (n) push

      script dup "TIME=" grepr reach -5 indent numerate ontop (sec)
      script dup "TRY="  grepr reach -4 indent numerate ontop (k)

      (sec k) star, 1.25 star (sec) \ timeout=TIME*TRY*1.25
      (sec) expectout \ set new timeout in word expecting

    \ First line of returned T (if fail, just get this line):
      date swap (hDate hScr)

      (hDate hScr)
      (hScr) running (f)
      IF FILE file? not
         IF lastfile "FILE" book \ name of last file saved in log
         THEN FILE file? 
         IF (hDate) FILE asciiload (hT) pile "_wget" naming (hT) 
         THEN
      THEN  (hT)
      pull (n) expectout \ put back current
   end
\  Ending marker for example in man said
   #WGET2 

\-----------------------------------------------------------------------

\  Configuring for an ISP.

   "ISP_config" missing

   IF \ only source this region once, so settings remain as they are

   inline: ISP_config (qS --- ) \ set system for connection to ISP S
{     This word runs msource on pppcon.v to create the version of word
      PORT_LIB appropriate for S.  Word pppscript uses the library of
      word PORT_LIB to set up the connection script for pppd.

      As an example, if S is "earthlink", then in pppcon.v there must
      be a region of this form:

         ISP earthlink

         inline: PORT_LIB ( --- ) \ earthlink ports and phone numbers
          ... (see examples in pppcon.v)
         end

         halt

      Word msource will find the unique phrase "ISP earthlink" (one 
      space between words and no quotes) and source everything to the 
      word halt.

      This word also restarts sendmail for ISP S, and so in /etc/mail
      there must be a sendmail configuration file with S embedded in 
      its name, of the form: /etc/mail/sendmail.S.cf.  

      If there is no such file the sendmail configuration is left alone.

      To see if this word worked, run word "From:" to obtain your email 
      address for S on the stack (this is used by pppsend).
}
      no STR stkok not IF "ISP_config" stknot return THEN

      strchop "S" book

    \ Sourcing file usr/pppcon.v for the version of PORT_LIB made for S:
      usrpath "pppcon.v" catpath "ISP " S cat msource

    \ Configuring sendmail for S using /etc/mail/sendmail.S.cf:
      S sendmail_config
   end

   inline: sendmail_config (qS --- ) \ configure sendmail for S
\     String S matches a string that is embedded in a sendmail config-
\     uration file name of the form sendmail.S.cf in /etc/mail/.

\     Group permission for /etc/mail/sendmail.S.cf must not be root
\     or pppsend will not run.

      no STR stkok not IF "sendmail_config" stknot return THEN
      [
      \ Local word config_file makes the path and file name for S of
      \ the form: /etc/mail/sendmail.S.cf
        {" (qS --- qFile)

         (qS) strchop "/etc/mail/sendmail." swap cat

         (qS) ".cf" cat (qFile)

        "} (qWord) "config_file" inlinex

        "/etc/mail/sendmail.cf" "CF" book
      ]
      (qS) config_file "CF" book
      CF file? not
      IF \ " sendmail_config: file not found: " CF cat 
      THEN
   end

   THEN

\-----------------------------------------------------------------------

   "PPPCON" exists? 
   IF PPPCON
      IF " web.v: flag PPPCON shows a connection to the web," . nl
         "   sourcing halted at words for connecting" . nl
         halt
      THEN
   THEN

\-----------------------------------------------------------------------

\  Words for connecting.

   define: netscape ( --- ) \ connect and start netscape in background
      X11 not IF " X11 required" . nl return THEN

      PPPCON not 
      IF " connecting..." . pppconnect not
         IF " netscape: failed" . nl return THEN
      THEN
      "netscape &" shell
   end

   inline: PPPCON ( --- f) \ flag yes if connected
      [ no "pppcon" book ] 
      "www_open" exists? IF www_open ELSE pppcon THEN ;

\  This is the path to the ppp log file; word _pppconnect needs it
\  while it is being created below:
   inline: ppplog ( --- qFile) \ path/filename of ppp log file
{
      Note the permission for messages; comm is the group that can 
      make connections:
         [root@clacker] /var/log # ll messages
         -rw-r-----    1 root    comm      18040 Jul 16 20:41 messages
}
      "/var/log/ppp" \ the connection log from pppd with debug option
      \"/var/log/messages" \ a connecton log is here too
   end

   inline: pppclose ( --- ) \ close pppd connection
\     Program pppoff is compiled by root and allows any user to kill
\     a pppd job (pppoff is included in file sys/pppcon.v).

\     Pppoe (ppp over ethernet) is being used if the tops pppoe server 
\     is running (see usr/root_pppoe).  Macro pppoe-start.PORT_ON is 
\     run to test for the tops pppoe server.

      getuid 0>
      IF "pppoe-start" "PORT_ON" localrun (f) \ is tops pppoe server on?
         IF pppoe-stop (f) drop \ server closes pppoe; server stays on 
         ELSE "/etc/ppp/pppoff" dup file?
            IF minshell ELSE drop THEN
         THEN
         no "PPPCON" "pppcon" bank
      THEN
   end

   inline: _pppconnect (hT --- f) \ connect to web using pppd script T
{     Returns f true if connection is established.
      Tests for connection success or failure by looking at ppp log 
      file. 
}
      [ 
        {" log ( --- f)
{       This is a local function to grab the tail of the log file and 
        look for a successful, or failed connection.

        Used by word expecting to sense when to stop waiting for a
        connection to be made.

        Flag f is true when word expecting should stop waiting.  True
        flag f does not mean the connection was successful.  Variable 
        CONN is true if the connection succeeded.

        Warning: ppplog must have read permission for comm group (see
        above).
}
        [ 
        \ Look for these in the log tail:

        \ Good sign:
          "local  IP address" "LOCAL" book    \ connected

        \ Bad signs:
          "Terminating on signal" "TERM" book \ not connected
          "BUSY" "BUSY" book
          "NO CARRIER" "NOCA" book
          "alarm" "ALRM" book
          "Failed" "FAIL" book
          "Hangup" "HUP" book
          "Modem hangup" "MHUP" book
          "Connection terminated" "CTRM" book
          "Killing pppd" "KILL" book
        ]
      \ Fetch the last 10 lines of ppplog (warning: 10 lines may be
      \ too few):
         \ This is very slow for a large log file:
         \ ppplog 10 tailf (hT) 

         \ This is fast for a large log file:
           "tail -10 /var/log/ppp > " scratch + shell
           scratch asciiload scratch delete

        no "CONN" book

      \ Must check for these before checking for local IP.
      \ Returning yes means word expecting will close, and with 
      \ CONN=no the connection attempt has failed.
        (hT) this TERM grepr any? IF 2drop yes return THEN
        (hT) this ALRM grepr any? IF 2drop yes return THEN
        (hT) this BUSY grepr any? IF 2drop yes return THEN
        (hT) this NOCA grepr any? IF 2drop yes return THEN
        (hT) this FAIL grepr any? IF 2drop yes return THEN
        (hT) this HUP  grepr any? IF 2drop yes return THEN
        (hT) this MHUP grepr any? IF 2drop yes return THEN
        (hT) this CTRM grepr any? IF 2drop yes return THEN
        (hT) this KILL grepr any? IF 2drop yes return THEN

      \ Check for the local IP address that is expected:
        (hT) this LOCAL grepr any?
        IF (hT hRow) reach words these rows quote 
           strchop "IPlocal" book
           yes "CONN" book
           yes (f) return \ success; return yes with CONN=yes
        THEN

        (hT) drop no (f) \ keep expecting

        "} "log" macro

      \ LOG is just a phrase that runs word log in this word.  The text
      \ of LOG will be given to word expecting, to inspect the ppp log 
      \ file until the local IP address of the connection appears:

        "'_pppconnect' 'log' localrun" "LOG" book

        "" "IPlocal" book
        120 (sec) "waiting" book \ max time to wait for connection
      ]
      no STR stkok push
      no VOL stkok pull or not
      IF "_pppconnect" stknot return THEN
   
      these chars any not IF drop fail return THEN

      "expecting" "timeout" yank (t) push
      waiting (nsec) "expecting" "timeout" bank \ time out waiting

      (hT) running \ ppp script returns immediately

      IF ppplog fileblock drop \ block until log file starts growing

         5 idle \ let chat get started so don't read log too early

         LOG expecting drop \ sit here for conditions to be met

         CONN (f) \ true if connection succeeded

         (f) this not 
         IF (f) " failed to connect" . nl THEN
      ELSE " _pppconnect: running script failed" . nl no (f)
      THEN

      pull (t) "expecting" "timeout" bank

      (f) this fail = 
      IF 5 idle pppclose THEN (f) this "PPPCON" "pppcon" bank
      (f)
   end

   inline: pppconnect ( --- f) \ connect to the web
\     Returns f true if connection is established.

\     Once connected, word pppModem returns the modem number being 
\     used and pppNumber returns the index of the phone number called.

      [ 3 "trying" book ] 

      PPPCON
      IF " flag PPPCON indicates a connection to the web" . nl
         true return
      THEN

      no "pppscript" "reset" extract (n) 1st
      DO zero "count" book

         pppscript (hT) swap (hT f)

         BEGIN (hT f) this not count trying < and
         WHILE (hT f) drop (hT) this _pppconnect (f)
            one count bump
         REPEAT (hT f) lop

         IF yes EXIT, ELSE no THEN
      LOOP 
      (f) 
      IF "NISTdelta" exists?
         IF NISTdelta (sec) UDEF that = not
            IF " pppconnect: GMT correction set to" .  this .i 
               " seconds" . (sec) GMTdelta
               yes (f)
            ELSE drop " pppconnect: GMT correction from NIST failed" .
             \ pppclose no (f) \ assume connection failed and close
               yes \ assume connection exists
            THEN nl
         THEN (f)
      ELSE no
      THEN
   end

   inline: pppModem ( --- n) \ pppscript using modem n
      "pppscript" "Modem" extract end
   
   inline: pppNumber ( --- n) \ pppscript using phone number n
      "pppscript" "Number" extract end
  
   inline: pppoe-start ( --- f) \ start ppp over ethernet
      [ 9901 "PORT" book \ unassigned; see port-numbers.txt (clacker)
        "PORT dup nextport <> (f)" "PORT_ON" macro
        60 "SEC" book 10 "Hz" book
      ]
      getuid 0<>
      IF \ non-root requesting DSERVER to start pppoe:
         PORT_ON (f)
         IF IPloop PORT CLIENT "S" book S -1 >
            IF "pppoe-start remotefd remoteput" S remoterun1 (f)
               S sclose dup (f)
               IF (f) dup "_pppconnect" "CONN" bank 
                  (f) dup "PPPCON" "pppcon" bank (f)
               ELSE " pppoe-start: failed to start pppoe" . nl (f)
               THEN
            ELSE " pppoe-start: failed to connect to pppoe server" . nl
               false 
            THEN (f)
         ELSE " pppoe-start: pppoe server is not running" . nl false
         THEN (f)
      ELSE \ root DSERVER is starting pppoe:
         www_open IF " pppoe-start: connected" . nl true return THEN

         SEC "www_open" WAIT_INIT
         Hz "WAITING" RATE

         " Starting pppoe..." .  "pppoe-start" shell

         WAIT_BEGIN \ wait for connection ok
         " done" . nl

         www_open (f) dup 
         IF " pppoe-start: connected"
         ELSE " pppoe-start: connection failed"
         THEN . nl
      THEN
   end

   inline: pppoe-stop ( --- f) \ stop ppp over ethernet
      [ "pppoe-start" "PORT" yank "PORT" book ]
      getuid 0<>
      IF \ non-root requesting DSERVER to stop pppoe:
         "pppoe-start" "PORT_ON" localrun (f)
         IF IPloop PORT CLIENT "S" book S -1 >
            IF "pppoe-stop remotefd remoteput" S remoterun1 (f)
               S sclose dup (f)
               IF false "_pppconnect" "CONN" bank 
                  false "PPPCON" "pppcon" bank (f)
               ELSE " pppoe-stop: failed to stop pppoe" . nl (f)
               THEN
            ELSE " pppoe-stop: failed to connect to pppoe server" . nl
               false 
            THEN (f)
         ELSE " pppoe-stop: pppoe server is not running" . nl false
         THEN (f)
      ELSE \ root DSERVER stopping pppoe:
         www_open 
         IF " Stopping pppoe..." .  "pppoe-stop" shell
            false "_pppconnect" "CONN" bank 
            false "PPPCON" "pppcon" bank 
         THEN true
      THEN
   end

   inline: ppptest (n --- ) \ run pppscript on n modem/number combos
{     To watch the operation of pppd and chat as they log on, in a 
      different window run the command: tail -f /var/log/ppp.
 
      These show a very bad period and a pretty good one (all within
      the same hour):
      
      [tops@gutter] ready > 6 (2 modems and 3 lines) ppptest
       Modem connection test
       Sun Jan 14 19:07:50 PST 2001
       Maximum attempts: 1
        Connecting modem 1 to line 1... ok
        Connecting modem 1 to line 2... ok
        Connecting modem 1 to line 3... failed (NO CARRIER from log)
        Connecting modem 2 to line 1... ok
        Connecting modem 2 to line 2... failed (BUSY)
        Connecting modem 2 to line 3... failed (NO CARRIER)
       Elapsed time: 7.0 minutes

      [tops@gutter] ready > 6 ppptest
       Modem connection test
       Sun Jan 14 19:51:26 PST 2001
       Maximum attempts: 2
        Connecting modem 1 to line 1... ok
        Connecting modem 1 to line 2... ok
        Connecting modem 1 to line 3... ok
        Connecting modem 2 to line 1... ok (2) (got on 2nd attempt)
        Connecting modem 2 to line 2... ok
        Connecting modem 2 to line 3... ok
       Elapsed time: 8.6 minutes

      More tests are shown in the Appendix.

      The lesson from these tests is that phone numbers should be 
      listed in order best-to-worst (best might mean most reliable, 
      or fastest connection when collecting data).  And immediately 
      retrying does lead to success, so putting best first and retry-
      ing is a good strategy.
  
      Details in the approach for calling are as follows, and are re-
      flected in the way word pppconnect works:

         - phone numbers in pppcon.v are listed in order best-to-worst

         - word pppconnect tries three times before calling pppscript
           for the next phone number to try

         - each time word pppconnect is entered for a new round of 
           calls, it resets word pppscript to start again at the first 
           (best) entry in its phone number list
}
      [ three "trying" book ]

      no NUM stkok not IF " specify number of tests" ersys return THEN

      " Modem connection test" . nl date one indent . nl
      " Maximum attempts: " . trying .u
      nl time push (n) 1st
      DO pppscript (hT)

         sp " Connecting modem " . pppModem .u 
         " to line " . pppNumber .u "..." . 
         no "count" book

         (hT) fail (f)
         BEGIN (f) this not count trying < and
         WHILE (f) drop (hT) this _pppconnect (f)
            one count bump
         REPEAT (hT f) lop
            
         IF pppclose " ok" . count one > 
            IF " (" count int$ ")" cat cat . THEN
         ELSE " failed" . 
         THEN nl two idle
      LOOP " Elapsed time: " .  time pull less 60 slash 
      "%0.1f" format " minutes" cat . nl
   end
{
   inline: ppptest0 ( --- ) \ run all modems on all numbers
\     Set up another window to watch the log: tail -f /var/log/ppp
      "PORT_LIB" "Ports" extract rows 1st
      DO "PORT_LIB" "PhoneNumbers" extract rows 1st
         DO J I modem _pppconnect
            IF 5 idle \ sit awhile
            THEN pppclose 2 idle
         LOOP
      LOOP
   end
}

\-----------------------------------------------------------------------

\  Configuring for this machine.

\  File pppcon.v will run an initial ISP_config.

   "PORT_LIB" missing

   IF yes push

    \ Enforcing a user-defined version of pppcon.v at usrpath:

      usrpath "pppcon.v" catpath filefound
      IF pull drop no push, (hFile) source
{
      ELSE " Require your file pppcon.v in directory " usrpath cat
         "  File pppcon.v contains your modem info and phone numbers "
         "  There is an example file pppcon.v in " syspath cat
         3 pilen . nl
}
      THEN

      usrpath "pppsec.v" catpath filefound
      IF pull drop no push, (hFile) drop
{
      ELSE " Require your file pppsec.v in directory " usrpath cat
         "  File pppsec.v contains your user and password info "
         "  There is an example file pppsec.v in " syspath cat
         3 pilen . nl
}
      THEN

\     pull (f) \ missing file or files?
\     IF " Halt web.v due to one or more missing files" ersys halt THEN
      pull drop
   THEN

   "PORT_LIB" missing IF halt THEN

\-----------------------------------------------------------------------

\  Utilities for making ppp scripts.

   "one" "mport" inlinex
   "two" "mcall" inlinex
   "three" "minit" inlinex
   "four" "secrets" inlinex

   inline: modem (p n --- hT) \ ppp script for pth port p, nth number
      "num" book "port" book
      PPPtemplate (hT)
      (hT) num mcall pppset
      (hT) port mport pppset
      (hT) port minit pppset
      (hT) no secrets pppset
      notrailing noblanklines
      "_modem" port suffix num suffix naming
   end

   inline: pppscript ( --- hT) \ cycles through different modem scripts
{     Script T is different each use, so a word like pppconnect will
      get a different number/modem script when it retries.

      Run phrase:
          "pppscript" "reset" localrun (n)
      to run this word's local inlinex reset, which will reset to the
      first script in its list of scripts, Using.  Firing reset also
      places n, the number scripts, on the stack.  Local inlinex reset
      is created below.
}
      [
        -1 "Modem" book, -1 "Number" book \ initially undefined

        xbase 1based \ make indices 1based, then apply ndx when using

      \ Making a matrix of port/phone number index pairs:
        list: "PORT_LIB" "Ports" extract rows 1st
           DO "PORT_LIB" "PhoneNumbers" extract rows 1st
              DO J I LOOP
           LOOP \ col 1 is port index, col 2 is phone number index:
        end these rows 2 slash matrix "Using" book

      \ Making ring, a round-robin list of indices for setups to use:
        2, Using rows (#setups) nit items, 1 pile makes ring \ 1based
        "ring bob ndx pry" \ next 1-based index
        "next" (prev --- next) \ next 1based index in round-robin
        inlinex

      \ Function reset sets the value of used so the next script is the
      \ first one; reset also puts the number of scripts on the stack:

        'Using rows again "used" book (n)' "reset" inlinex

        reset drop

        (xbase) indexbase \ restoring index base
      ]
      Using used next, this is used, ndx reach
      this 1st pry this "Modem"  book ndx (port)
      swap 2nd pry this "Number" book ndx (phone)
      (port phone) modem
   end

   inline: pppset (hT n type --- hT1) \ set type to nth in ppp script T
      \ These are the strings to be matched in incoming template T.
      [ "/dev/tty" "port_string" book           \ line for modem port
        "ATD" "call_string" book                \ line for phone number
        "Your modem string" "minit_string" book \ line for modem init
        "Your user id" "user_string" book       \ line for user
        "Password" "password_string" book       \ line for password
      ]
      its mport = IF (type) drop \ setting to port n:
         port_string "PORT_LIB" "Ports" extract
         rot (n) quote qreplace ELSE

      its minit = IF (type) drop \ setting to initialization string n:
         minit_string "PORT_LIB" "ModemInit" extract
         rot (n) quote qreplace ELSE

      its mcall = IF (type) drop \ setting to call number n:
         call_string "PORT_LIB" "PhoneNumbers" extract
         rot (n) quote qreplace ELSE

      its secrets = IF (n type) 2drop \ setting user name and password:
         "pppsec.v" source (qUser qPassword) push push
         (hT) user_string pull (User) qreplace
         (hT) password_string pull (Password) qreplace ELSE

      lop " pppset: type " . .u " not found" ersys
      THEN THEN THEN THEN
   end

   inline: PPPtemplate ( --- hT) \ ppp script template
      [ \ Script template:
        "ppp.scr" filefound drop asciiload asciify noblanklines
        dup 1st quote swap
        dup 1st catch 1st "#" cite rake lop pile (hT)
        (hT) makes PPPtemplate
      ] PPPtemplate
   end

\-----------------------------------------------------------------------

   "CATMSG_SAVE" exists? IF CATMSG_SAVE catmsg THEN

   private halt, end of words for the web

\-----------------------------------------------------------------------
;
   Appendix

   It takes about 48 seconds to dial and establish a connection:

    Running pppd (showing entries to /var/log/ppp):

    Jul 22 15:32:40 gutter pppd[36]: pppd 2.3.5 started by dale, uid 500
    ...
    Running chat:
    Jul 22 15:33:09 gutter chat[36]: ATD823103702831^M^M
    Jul 22 15:33:09 gutter chat[36]: CONNECT
    Jul 22 15:33:09 gutter chat[36]:  -- got it
    ...

    Jul 22 15:33:10 gutter chat[36]: timeout set to 15 seconds
    ...

    Jul 22 15:33:27 gutter chat[36]: Password:
    Jul 22 15:33:27 gutter chat[36]:  -- got it
    Jul 22 15:33:27 gutter chat[36]: send (************^M)
    Jul 22 15:33:28 gutter chat[36]: send (PPP^M)
    Running pppd:
    Jul 22 15:33:28 gutter pppd[36]: Serial connection established.
    Jul 22 15:33:29 gutter pppd[36]: Using interface ppp0
    Jul 22 15:33:29 gutter pppd[36]: Connect: ppp0 <--> /dev/ttyS1
    ...

   Here is the connection termination message in /var/log/ppp:

    Jul 22 15:48:26 gutter pppd[36]: Connection terminated.

   Here is a data collection run using word pppcollect (note: pppclose 
   depicted in this example has since been removed from pppcollect):

      [tops@gutter] ready > pppcollect 
       Running pppcollect
         Connected 17:22:45
         Collecting... collection complete
         Connection closed 17:24:58

       stack elements:
             0 number: -1
       [1] ok!
      [tops@gutter] ready >

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

[tops@gutter] ready > 6 ppptest
 Modem connection test
 Sun Jan 14 19:07:50 PST 2001
  Connecting modem 1 to line 1... ok
  Connecting modem 1 to line 2... ok
  Connecting modem 1 to line 3... failed (NO CARRIER from log)
  Connecting modem 2 to line 1... ok
  Connecting modem 2 to line 2... failed (BUSY)
  Connecting modem 2 to line 3... failed (NO CARRIER)
 Elapsed time: 7.0 minutes

[tops@gutter] ready > 6 ppptest
 Modem connection test
 Sun Jan 14 19:17:44 PST 2001
  Connecting modem 1 to line 1... ok
  Connecting modem 1 to line 2... failed (NO CARRIER)
  Connecting modem 1 to line 3... failed (NO CARRIER)
  Connecting modem 2 to line 1... ok
  Connecting modem 2 to line 2... ok
  Connecting modem 2 to line 3... failed (NO CARRIER)
 Elapsed time: 7.4 minutes

[tops@gutter] ready > 6 ppptest
 Modem connection test
 Sun Jan 14 19:51:26 PST 2001
 Maximum attempts: 2
  Connecting modem 1 to line 1... ok
  Connecting modem 1 to line 2... ok
  Connecting modem 1 to line 3... ok
  Connecting modem 2 to line 1... ok (2)
  Connecting modem 2 to line 2... ok
  Connecting modem 2 to line 3... ok
 Elapsed time: 8.6 minutes

[tops@gutter] ready > 6 ppptest
 Modem connection test
 Sun Jan 14 20:04:30 PST 2001
 Maximum attempts: 2
  Connecting modem 1 to line 1... ok
  Connecting modem 1 to line 2... ok
  Connecting modem 1 to line 3... ok
  Connecting modem 2 to line 1... ok
  Connecting modem 2 to line 2... ok (2)
  Connecting modem 2 to line 3... failed (NO CARRIER)
 Elapsed time: 9.4 minutes

[tops@gutter] ready > 6 ppptest
 Modem connection test
 Sun Jan 14 20:21:25 PST 2001
 Maximum attempts: 3
  Connecting modem 1 to line 1... ok
  Connecting modem 1 to line 2... ok
  Connecting modem 1 to line 3... failed
  Connecting modem 2 to line 1... ok (3)
  Connecting modem 2 to line 2... ok
  Connecting modem 2 to line 3... ok (3)
 Elapsed time: 14.5 minutes

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Not needed; pppconnect does it all, and ppp scripts using idle time-
\  outs are believed to conflict with the multitasker running SIGALRM.

  _inline: pppnet ( --- hT) \ script for surfing, no idle timeout
\     The script read contains no pppd timeout for inactivity.
      usrpath "pppnet" cat this file? 
      IF asciiload chop 
      ELSE pppscript \ " need file " swap cat ersys 0 0 blockofblanks
      THEN "_pppnet" naming (hT)
   end
pppnet ( --- hT) handle to text for pppconnection
pppnet note: expects at usrpath a file called pppnet
pppnet note: use for surfing: no time out on idle time (see pppscript)
pppnet usage: pppnet _pppconnect IF "aMessage" asciiload pppsend pppclose THEN
pppnet related: _pppconnect, pppconnect, pppcollect, pppscript

\  This discussion is somewhat obsolete with use of file pppcon.v and
\  new version of pppscript and pppconnect:

   Below is a sample script for point-to-point protocol that runs
   program pppd for compuserve.  It might be used in the phrase

      pppcsi _pppconnect IF " Connection established" . nl THEN

   Scripts like pppcsi contain the keys--login ids and passwords--to
   your places on the web.  They can be kept separate in protected
   files.

   The debug option for program pppd is specified to generate a log
   file so word _pppconnect can verify the connection.  Word ppplog
   defined below gives the path/filename of the log file.

   Note that using the debug option for pppd does not cause login and
   password to be written to the log.

   The pppd program invokes the chat program to make the connection
   through the modem.  It is the chat program that might write your
   login id and password to the pppd log.

   The pppd log will contain your login id and password if the chat
   program is invoked with option -v or -r filename options shown be-
   low.  Some use these options only for debugging.

   define: pppcsi ( --- hT)
      [ {" Sample script for pppd, using COM2 (ttyS1) and running chat:
           #
           /usr/sbin/pppd /dev/ttyS1 57600 debug \
           idle 180 \
           connect "/usr/sbin/chat -v -r filename \
           ABORT BUSY \
           ABORT ERROR \
           ABORT 'NO CARRIER' \
           ABORT 'NO DIALTONE' \
           ABORT 'Invalid Login' \
           ABORT 'Login incorrect' \
           '' AT \
           OK ATD823103702831 \
           CONNECT '\d\c' \
           TIMEOUT 15 \
           :--: CIS \
           :--: 'UserName/NOINT/GO:PPPCONNECT' \
           PPP '\c' \
           :--: Password \
           '' PPP"
        "}
        chop "script" book
      ] script
   end

   Rather than containing the script, as pppcsi does above, word
   pppscript given below reads scripts from a file, alternating
   between two that provide alternate phone numbers each time the
   word is said.
}

   \ Revised pppconnect makes this word less necessary:
  _inline: pppconnection (qW n --- f) \ n attempts to connect pppd
{     Tries _pppconnect up to n times, waiting secs between attempts.
      Returns f true if connection is made.

      Note that W is the name of a word in the library that places
      the text handle for a pppd script on the stack.  For example,
      see word pppscript.
}
      [ scalar "secs" book, 5 secs (waiting) bang ]

      those chars any not IF 2drop fail return THEN

      that exists? not
      IF 2drop " expect a library word to supply pppd script"
         ersys fail return
      THEN

      fail (f) push 1st

      DO again main _pppconnect

         IF pull
               whack
                  smash
                     push
                        EXIT
         ELSE secs
                 ontop
                    idle
         THEN

      LOOP (qW) trash pull (f)
   end

pppconnection (qW n --- f) tries n times to connect to the Internet, waiting 30 seconds between attempts
pppconnection note: using point-to-point protocol, program pppd, for connection to an ISP
pppconnection note: W is a word in the catalog that supplies a script for program pppd; for example, pppscript is such a word
pppconnection note: qW means that name W is enclosed in quotes
pppconnection note: once connected, a program like Netscape can be used to access the Internet
pppconnection use > "myISP" 4 pppconnection IF "netscape &" shell
pppconnection related: pppscript, pppclose, ppplog, pppconnect

   Old version.
  _inline: pppscript ( --- hT) \ cycles through different scripts
{     Script is different each use, so a word like pppconnection will
      get a different number when it retries.

      The pppd scripts read contain idle timeouts for no activity, and
      so are best used for continuous activity in a machine-to-machine
      connection.  For connection by a human, word pppnet provides a
      pppd script with no idle timeout.

}     [ "usrpath 'pppconnect1' cat " \ script for primary line
        "usrpath 'pppconnect2' cat " \ script for secondary line
        "usrpath 'pppconnect3' cat " \ script for third line
        "usrpath 'pppconnect4' cat " \ script for fourth line
        "pile pile pile onto line"
        cat cat cat cat "load_scripts" inlinex

        four "calling" book
        \ making ring, a round-robin list of indices for lines to call:
        2, calling (#lines) nit items, 1 pile makes ring \ 1based

        "ring bob ndx pry" \ next 1-based index from ring
        "next" (prev --- next) \ next 1based index in round-robin
        inlinex
      ]
      load_scripts \ reload because they might be edited
      line calling next, this (prev) "calling" book
      (line n) ndx quote this file?
      IF asciiload chop "_pppscript" naming
      ELSE " need file " swap cat ersys 0 0 blockofblanks
      THEN (hT)
   end

   Early form of word that became ppptest in web.v:

  _inline: ppptest ( --- ) \ run all modems on all numbers
\     Set up another window to watch the log: tail -f /var/log/ppp
      PPPtemplate "PORT_LIB" "Ports" extract rows 1st
      DO dup I mport pppset
         dup I minit pppset
         "PORT_LIB" "PhoneNumbers" extract rows 1st
         DO dup I mcall pppset _pppconnect
            IF 10 idle \ sit awhile
            THEN pppclose 5 idle
         LOOP drop
      LOOP drop
   end

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

Words made obsolete by word ALARM:
The following were removed from manual, newman.doc

watch ( --- ) starts timer set by word watchset, and after defined seconds have passed, the defined task will be runwatch note: first set watch and task using word watchset, then start the timer by saying word watch
watch note: watch deactivates itself after it runs; it can be deactivated earlier by saying word watchoff
watch note: watch and watchset can do only one task at a timewatch related: watchoff, watchset, tasks, TASK
watch related (identical in operation): alarm, alarmset, alarmoff
watchoff ( --- ) turn off timer started by word watch
watchoff related: watch, watchset, taskswatchset (qTask secs --- ) set watch so that after secs have passed, Task will be runwatchset note important: this just sets the watch; the timer must be started by saying watch toowatchset note: Task is the word in the catalog that is run when watch goes off
watchset note: watch and watchset can do only one task at a timewatchset related: watch, watchoff, tasks, todayat


\  These work exactly like alarm, alarmoff, and alarmset.  They are
\  available to use in a monitor to kill a pppcollect job if it hangs.

"TASK" exists? IF

  _inline: watch ( --- ) \ after secs, run Task set by watchset
      [ scalar "Task" book, scalar "secs" book, zero "Tstart" book
        scalar "running" book, no running bang
      ] running ontop
      IF time Tstart less secs ontop >=
         IF watchoff Task ontop exe? not
            IF " watch task failed" . nl THEN
         THEN
      ELSE time "Tstart" book, yes running bang "watch" WAKE
      THEN
   end

  _define: watchoff ( --- ) \ turn off watch timer
      "watch" SLEEP, no "watch" "running" extract bang ;

  _define: watchset (qTask secs --- ) \ set watch: after secs run Task
{     Set watch to perform Task after secs have passed; Task is the
      name of the catalog function that is run.
      This word just stores these things in the local library of
      word watch.
}     (secs) "watch" "secs" extract bang
      (qTask) ptr "watch" "Task" extract bang
   end

THEN

  _define: weather ( --- hT) \ your local weather
{     Edit zipcode in the script below.

      Assumes the machine is already connected to the web; see
      word pppconnect.

      Uses perl loaded with modules that access the Internet.  The 
      required perl modules (July 2000) are:

         149864 libwww-perl-5.48.tar.gz
          78978 URI-1.07.tar.gz
          56823 HTML-Parser-3.10.tar.gz
          64719 libnet-1.0703.tar.gz
          90875 Digest-MD5-2.09.tar.gz
          10682 MIME-Base64-2.11.tar.gz

      These modules can be downloaded from the Comprehensive Perl 
      Archive Network (CPAN):
         http://www.perl.com/CPAN-local//modules/01modules.index.html

      They must be untarred and installed into perl so functions like 
      LWP and get are available to the weather script below.

      Here is a valuable script from Al Danial that installs these
      required modules into perl:

---------------------------------------------------
#!/bin/sh
#
# Install perl modules useful for internet access.
# run as root otherwise install step won't work
#
here=`pwd`
for package in Digest-MD5-2.09  \
               URI-1.07         \
               MIME-Base64-2.11 \
               HTML-Parser-3.10 \
               libnet-1.0703    \
               libwww-perl-5.48
do
    tar zxfv $package.tar.gz
    cd $package
    perl Makefile.PL
    make
    make install   # needs root access
    cd $here
    rm -fr $package
done
---------------------------------------------------
}
[ \      weather forecast

"#!" perl$ "-w" cat cat

{" Perl script presented by Al Danial at Linux at LAX meeting, 7-8-00:
##!/usr/bin/perl -w
# Albert Danial April 18 2000
use strict;
use Text::Wrap;      # <- doesn't work
use LWP::Simple qw /get/;
my ($url, $zipcode, $city, $LineNum, $quit, @All, );
$Text::Wrap::columns = 80;
$zipcode = 90274;

$url     = 'http://www.weather.com/weather/us/zips/36hr/' . $zipcode . '.html';
@All     = split(/\n/, get($url));           # print join("\n", @All); exit;
$LineNum = 0;
$quit    = 0;

open(OUT,">weather.dat");

foreach (@All) {
    if (m{<TITLE>\s*The\s+Weather\s+Channel\s+\-\s+(.*?)</TITLE>}) {
        my $city = $1;
        print OUT "$city\n";
    } elsif (m{(Issued\s+at\s+.*?)<}m) {
        $LineNum = 1;
        print OUT "$1\n";
    } elsif ($LineNum) {
        $quit = 1 if (m{</FONT>});
        s{<.*?>}{}g;      # strip html tags
        s{Extended\s+forecast:}{};
        s{(\w+:)}{\n$1};  # newline between Tuesday:, Wednesday:, etc
        print OUT wrap("\t", "", $_);
        last if $quit;
    }
}
print OUT "\n";
      "} pile onto script
      ]
      runid ".weather" cat (qS) script that save
      "chmod u+x " that cat shell
      (qS) this webcollect
      IF "weather.dat" asciiload
      ELSE "" hand
      THEN swap (qS) delete
      "_weather" naming
   end
\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

