\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2008  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File tex.v  July 1999

   Copyright (c) 1999-2008   D. R. Williamson
}
\-----------------------------------------------------------------------

   CATMSG push no catmsg

   inline: 10ths (hV --- hT) \ number column V into text with 10ths
\     Examples: 3595.1 becomes 35951, -0.2 becomes -02
      hand dup sign bit dup plus one +d push 
      abs 10 *f 0.5 + integer 10 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "%1.0f" format park chop
   end

   inline: 100ths (hV --- hT) \ number column V into text with 100ths
\     Examples: 65.875 becomes 6587, -0.2 becomes -020
\     Multiplying by 1000 and then tossing the last character avoids
\     problems with roundoff and truncation not seen with 8ths, 10ths,
\     and 32nds.
      hand dup sign bit dup plus one +d push  
      abs 1000 *f 1000 those dims fill
      /mod pull *by "%5.f" format swap abs
      "%03.f" format park right justify
      1st those chars nit items catch chop \ toss last character
   end

  inline: 100ths+ (hV --- hT) \ number column V into text with 100ths
\     Hundredths with an additional half-hundredth.
\     Like word 100ths, only don't toss the last character.
\     Examples: 65.875 becomes 6587, -0.2 becomes -020
      hand dup sign bit dup plus one +d push
      abs 1000 *f 1000 those dims fill
      /mod pull *by "%5.f" format swap abs
      "%03.f" format park left justify chop
   end

   inline: -32nds (hV --- hT) \ number column V into text T with -32nds
\     Examples: 98.22 becomes 98-07, -0.25 becomes -0-08
      hand dup sign bit dup plus one +d push 
      abs 32 *f 0.5 + integer 32 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "-%02.0f" format park chop
   end

   inline: 32nds (hV --- hT) \ number column V into text T with 32nds
\     Examples: 98.22 becomes 9807, -0.25 becomes -008
      hand dup sign bit dup plus one +d push 
      abs 32 *f 0.5 + integer 32 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "%02.0f" format park chop
   end

   inline: 32nds+ (hV --- hT) \ number column V into text T with 32nds+
\     Thirty-secondths with an additional half-thirtysecond, equivalent
\     to 64ths.
      hand "V" book
      list: V rows 1st 
         DO V I pry dup 0< swap abs 320 * rounded 320 /mod int$
            swap int '%03d' format
            cat swap IF '-' swap cat THEN
         LOOP
      end words
   end

   inline: -8ths (hV --- hT) \ number column V into text T with -8ths
\     Examples: 245.25 becomes 245-2, -0.25 becomes -0-2
      hand dup sign bit dup plus one +d push 
      abs 8 *f 0.5 + integer 8 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "-%1.0f" format park chop
   end

   inline: 8ths (hV --- hT) \ number column V into text T with 8ths
\     Examples: 244.75 becomes 2446, -0.25 becomes -02
      hand dup sign bit dup plus one +d push
      abs 8 *f 0.5 + integer 8 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "%1.0f" format park chop
   end
{
   define: bfile (qS --- qS1) \ create bad-file name
{     Makes a name for a file that is hard for looky loos to read 
      because it contains backspace characters.  On the system it
      looks like a normal name.  (May not work on some systems.)

      But the file can be asciiloaded here.

      Deleting it (or reading it, for that matter) is simply done
      using wildcards and one of the file's characters.

      Writing bfile: (hT) "mybadfile" bfile save
      What name looks like: "mybadfile" bfile .hex
      Reading bfile: "mybadfile" bfile asciiload eview
     
}    [ " " 8 (backspace) putch tout cat "bch" book ]
     "S" book, bch S chars 1st DO S I character bch cat cat LOOP
   end
}   
   define: choose (hT n1 --- n) \ spinner to choose a row from text T
{     Hit key u or k to increment; key d or j to decrement;
      hit Enter or Esc to quit.
      Example:

         list: "animal" "mineral" "fish" ; words 
         " What is it? " nl nl . 2nd choose

}     [ "(u d Enter): " "prompt" book
        list:
           list: no  no  yes yes ; says response (yes=up)
           list: "d" "j" "k" "u" ; words
           these push rows 1st 
           DO peek I quote 1st byte LOOP pull drop
        end makes keys
        "n" 1st byte says No, " ok? (n y Enter): " says ok?

{        Making these place holders in the local library before inlines
         "showchoice" and "ch" are created, so they will see the same
         addresses for next, choices, and dent:
}        0 into next, "" into choices, no into dent

        "dent choices next quote cat cr dot" "showchoice" inline 

        {" Here is the main text for this word, choose:

           (hT n1) into next, (hT) makes choices
           prompt dot tout says dent

         \ Making the spin lists:
           2nd choices rows nit items, 1st pile this (hN) onto spinup
           (hN) rows ndx, 1st choices rows nit items pile onto spindn

         \ Running the spin loop:
           BEGIN showchoice run, ok? strlen spaces dot, showchoice run
              BEGIN getch, NL that <> over, ESC <> and (ch f)
              WHILE (ch) keys swap bsearch (n f)
                 IF (n) response that pry yes = 
                    IF spinup ELSE spindn THEN (hN)
                    next pry into next showchoice run
                 THEN (n) drop
              REPEAT (ch) drop, ok? dot
              getch (ch) No <> (f)
           UNTIL next "n" naming (n)

        "} "ch" inline
      ] ch run (n)
   end

   inline: nomatch (hT2 hT1 --- hT) \ list of lines that do not match
\     Returned volume T contains lines from master volume T2 that do 
\     not match any lines in volume T1.
      (hT1) noq_alike "T1" book 
      (hT2) noq_alike "T2" book
      list: T2 rows 1st
         DO T1 T2 I quote grepe rows 0= IF I THEN LOOP
      end (hRows)
      any? IF (hRows) T2 swap reach ELSE VOL tpurged THEN
   end

   inline: nomatch1 (hT2 hT1 --- hT) \ list of lines that do not match
\     Uses a hash, and is much faster than word nomatch.
      [ 40 "BINS" book ]
\     Returned volume T contains lines from master volume T2 that do
\     not match any lines in volume T1.
      (hT1) "T1" book
      (hT2) "T2" book

      T1 1st T1 rows items 20 "$nomatch1" hash_make

      list: T2 rows 1st
         DO $nomatch1 T2 I quote hash_lookup (...hV nV)
            over rows 0>
            IF (...hV nV) dump
            ELSE (...hV nV) dump I
            THEN
         LOOP
      end (hRows)
      any? IF (hRows) T2 swap reach ELSE VOL tpurged THEN
      $nomatch1 hash_close
   end

\  This is how it was done before "inline:" was invented:
   define: qmatch (hT qS --- n) \ first row in T that matches quote S
{     First 8 characters are matched; returns n=-1 if no match.
      No match if S is wider than T.

}     [ {"
          true 1 STR stkok and, 2 VOL stkok and not
          IF "qmatch" stknot return THEN
          1st swap cite, 1st those rows items swap rake drop any? 
          IF 1st pry ELSE -1 THEN
        "} "qmatch" inlinex 
      ] qmatch ;

   define: quotes (hT qS --- hT1) \ lines from T that begin with quote S
      push left justify, this 1st peek, cite, rake trash
      "_" pull cat naming ;

\-----------------------------------------------------------------------

\  Words for English definitions and hyphenation (December 2007).

   inline: def (qS --- qS1) \ define English word S
{     Obtain the definition of word S from web site www.askoxford.com
      (December 2007).

      If the string used in the site URL has different characters 
      than incoming S, this word will fail.  Conforming strings can 
      be obtained with word defr() before running this word.

      Examples:

         [tops@plunger] ready > "naive" def COLS .out
         /nieev/ (also nave) adjective 1 lacking experience, wisdom,
           or judgement.  2 (of art or an artist) produced in or
           adopting a simple, childlike style which deliberately
           rejects sophisticated techniques.  naively.  French, from
           Latin nativus 'native, natural.'

      Here is an example of a simple word that is not found because
      the site modifies its string; returned S1 from this word is an 
      empty string:

         [tops@plunger] ready > "resume" def  

          stack elements:
                0 string:   0 characters
          [1] ok!

      Because the site stores even some simple words with modified
      strings, word defr() (created below) is needed to fetch the con-
      forming URL string or strings for word S.

      Results from defr() for the failed "resume" case are shown next.

      The first column shows valid site strings for word resume, and 
      the second column shows a descriptive string that can be used 
      when the definition is displayed later (&#233; is html for ASCII
      character 233, which is the non-English letter  (233 emit .)).

         [tops@plunger] ready > "resume" defr .
         orexxsume  | resume
         orexxsumex | r&#233;sum&#233;

      Here is running separately these site strings for word resume in
      word def().  Now some definitions for "resume" are obtained:

         [tops@plunger] ready > "orexxsume" def 64 .out
         verb 1 begin again or continue after a pause or interruption.
           2 take or put on again; return to the use of.  resumption.
           Latin resumere 'take back.'

         [tops@plunger] ready > "orexxsumex" def 64 .out
         /rezyoomay/ noun 1 a summary.  2 a curriculum vitae.  from
           French, 'resumed.'

      Word define() automates this process by calling defr() to first
      obtain conforming strings for S, and then obtaining their defini-
      tions and displaying them:

         [tops@plunger] ready > "resume" define   
         resume
          verb 1 begin again or continue after a pause or
            interruption.  2 take or put on again; return to the
            use of.  resumption.  Latin resumere 'take back.'
         r&#233;sum&#233;
          /rezyoomay/ noun 1 a summary.  2 a curriculum vitae.
            from French, 'resumed.'

       As noted above, string &#233; is html for the  in word rsum.  
       Word defr() is not fancy enough to transform non-English char-
       acters.  Here are some tools for doing that some day:

          This shows the higher ASCII chars:
             255 127 DO I .i sp I emit nl LOOP

          See http://www.thesauruslex.com/typo/eng/enghtml.htm
          for the html associated with them in various languages.

          Also see word def() where some translation of non-English
          characters is done.

          Curiosities to understand:
             protege:
                h2>prot&#233;g&#233;</h2>
                <p>  /<b>prott</b>i&ulzh;ay, (what is &ulzh;?)
}
      [ no "WWW" book ]

      0 STR stkok 
      IF strchop chpack lowercase "S" book ELSE "def" stknot return THEN

      WWW not
      IF www_open not
         IF " def: not connected to the Internet" . nl return THEN
      THEN

      S "defr" "FETCH" localrun (hT) any? \ run macro FETCH() in defr()
      IF textget "T0" book \ view def.T0 for debugging

         T0 "AskOxford:" "</title>" between vol2str (qS) strchop any?
         IF \ Note: if incoming S was resume, the S booked here is 
            \    r&#233;sum&#233; which is html for rsum.
            (qS) "S" book \ view def.S for debugging.

            T0 "<h2>" S + "</h2>" + grepr any?
            IF 1st pry (nrow) T0 swap 1+ (nrow+1) reach (hH)
               dup "H0" book (hH) \ this is the string to take apart
{ 
               Superscripts used with words in the browser display use
               an underscore in the web file name ("went" references 
               web file name GO_1, "lie" references LAY_1, "wend" ref-
               erences WIND_2).  Eliminate the <sup> html and insert
               an underscore to get these names right:
}              "<sup>" "_" strp 
               "/<sup>" " " strp (hH)

             \ The next 9 or 10 lines (excluding comments) pull out
             \ relevant text that is buried inside html font commands 
             \ that will be removed when html2text() is run.

             \ Replace html font directives with NL characters, and
             \ extract text from the remaining html:
               (hH) "<font" NLch strp "/font>" NLch strp html2text (qS)

             \ Turn the text into a VOL (the added NL characters will 
             \ denote the lines of the VOL created by textget(), then 
             \ they are replaced by one blank space):
               (qS) textget NLch " " strp noblanklines "T" book

             \ Buried "fonted" text is in the nonblank rows extracted
             \ by the following:
               T ">" "<" between (hR) left justify (hR)

             \ Add more like these as they are noticed during use
             \ (being here, these changes only affect fonted text,
             \ and not definitions or usage):
               "fem."     "fem" strp     \ "protege"
               "Brit."    "Brit" strp    \ "hotly"
               "N. Amer." "N Amer" strp  \ "flavor"
               "Austral." "Austral" strp \ "dill"
               "pl."      "pl" strp      \ "lied"
               "part."    "part" strp    \ "go"
               "sing."    "sing" strp    \ "WILL_1"

             \ Extract just the nonblank rows and their row numbers:

             \ The following MAT (T1) has patterns like 6920202020202020
             \ (69 is letter E, 20 is blank) and also totally blank ones
             \ like 2020202020202020:
               (hR) dup 1st catch vol2mat bend (hT1) 

             \ The following MAT (T2) has only blank patterns 202020...:
               BL export1 str2num over dims fill (hT2)

             \ Put the row numbers of the nonblank rows into list Rows:
               (hT1 hT2) = \ true for blank rows of R (202020...)
               1st T rows items swap rake drop (hA0) "Rows" book 

             \ Ram the nonblank rows of fonted text into T at Rows, 
             \ overwriting the former ones (first, pad the nonblank 
             \ rows with blanks to the width of T):
               (hR) Rows reach 1 indent T chars blpad (hR)
               (hR) Rows T ram T textput NLch "" strp (qS)

               (qS) dup "H" book \ def.H can be viewed for debugging

             \ Note: the conversion below of various html strings into 
             \ equivalent ASCII characters is a job perhaps better done
             \ in a fancier version of word html2text or a new word.

               "&nbsp;" " " strp \ blank space
               "&em;" "" strp \ emphasize style ("too")

               "&#145;" "'" strp
               "&#146;" "'" strp
               "&#038;" "&" strp

               "&#233;" "&eacute;" strp \ html # into html name
             {
               Below, export1 is used to convert some common html
               strings into ASCII text bytes (note that a numbered 
               html entry must first be converted to its equivalent 
               html text entry, like #233 into eacute, done above):
             }
               "&Euml;" 203 export1 strp
               "&euml;" 235 export1 strp

               "&Iuml;" 220 export1 strp 
               "&iuml;" 239 export1 strp \ the  in nave

               "&Uuml;" 220 export1 strp
               "&uuml;" 252 export1 strp

               "&yuml;" 255 export1 strp

               "&Ntilde;" 209 export1 strp
               "&ntilde;" 241 export1 strp

               "&Eacute;" 201 export1 strp 
               "&eacute;" 233 export1 strp \ the  in rsum

               strings "&#" "" qreplace noblanklines vol2str

             \ Miscellaneous fixup; these are added when perceived 
             \ (note that the order of some changes matters, like the 
             \ ones involving period):
               " ." "." strp   \ no space before a period
               '".' '."' strp  \ period before quote not after
               "'." ".'" strp  \ period before single quote not after

               ". " ".  " strp \ two spaces after a period, not one

{              Try "between" define.  Due to the loop below for 
               initials, (verified by temporarily removing it), the 
               following is obtained: 
                  ... object pronouns such as me rather than subject 
                  pronouns such as I.It is therefore correct to say 
                  between you and me rather than between you and 
                  I.ORIGIN Old English, related to TWO.
               The following removes this case, but means an initial I.
               will not be handle correctly.
}              " I. " " I.  " strp \

               '",' ',"' strp \ comma before quote not after
               "'," ",'" strp \ comma before single quote not after

               "&" " &" strp   \ one space before &
               "  &" " &" strp \ one space, not two, before &

               ";" "; " strp   \ one space after semicolon
               ";  " "; " strp \ one space, not two, after semicolon

               "( " "(" strp \ no blank following left parenthesis

               "(usu.  " "(usu. " strp \ see "escape"
               "e.g.  " "e.g. " strp
               "e.g." "e.g. " strp \ ref: "fly" e.g. dragonfly
               "i.e.  " "i.e. " strp
               "etc.  " "etc. " strp \ works sometimes; see console

               (qS)

{              It's overkill, but this is a demo of string manipula-
               tions, so here are some lines to remove one of the two 
               spaces now present after a period when it is used with 
               a person's initial (this only works for an initial of 
               one letter; example: for "verylight" see Edward W. Very):
}              (qS) dup vol2str words 1 indent (hW) \ 1st char blank
               (hW) dup 3rd catch vol2mat bend \ test the 3rd char
               "." str2num = (hF) \ true flags at rows with period
               (hF) rake (hA0 hW) lop (hW) any?      
               IF (qS hW) dup push rows 1st 
                  DO (qS) peek I quote strchop dup " " + swap strp LOOP 
                  pull drop
               THEN (qS)

               (qS) return
            THEN
         THEN
      THEN
      STR tpurged
   end

   inline: define (qS --- ) \ define English word S
{     Go to www.askoxford.com and get the definition of word S
      (December 2007).

      This word combines the work of words defr() and def() and
      displays the result.

      Example:

         [tops@plunger] ready > "behavior" define
         behaviour
          (US behavior) noun the way in which someone or something
            behaves.  behavioural.
         [tops@plunger] ready > 

      October 2008.  Problems with the site www.askoxford.com:
         Site Unavailable at Present

         The server is currently unable to handle your request due to 
         a temporary overloading or maintenance of the server.

         Our engineers are investigating this issue. Our apologies for 
         any inconvenience caused.
}
      [ 72 "OUT" book ]

      0 STR stkok
      IF strchop (chpack) lowercase "S" book
      ELSE "define" stknot return
      THEN

      www_open not
      IF " define: not connected to the Internet" . nl return 
      ELSE yes "WWW" "def" bank \ avoids testing again in def and defr
           yes "WWW" "defr" bank
      THEN

      S defr (hT) any? 
      IF (hT) dup 1st word drop "W" book
         "|" tug -1 indent "D" book
         D rows 1st
         DO D I quote strchop 
            dup "&" grepr rows any \ hypertext in name = non-English
            IF drop W I quote strchop \ use W until higher ascii works
            THEN . nl 
            W I quote def (qDEF) sp OUT 1- .out nl
         LOOP
      ELSE
         " define: word " S + " not found" + . nl
      THEN
      no "WWW" "def" bank
      no "WWW" "defr" bank
   end

   inline: define1 (qS --- hT) \ define English word S
{     Same as define(), but return the displayed result in a VOL on 
      the stack.  OUT1 here controls the displayed width separately 
      from OUT in define().
}     [ 72 "OUT1" book ]

      "define" "OUT" yank push
      OUT1 "define" "OUT" bank

      (qS) "define" >stk "_define1" naming

      pull "define" "OUT" bank
   end

   inline: defr (qS --- hT) \ definitions related to English word S
{     Go to www.askoxford.com and get references to words with defini-
      tions that are related to word S (including S itself).
      (December 2007).

      The following example for the word "dill" shows the first column
      of returned T contains the string used in the web URL, and the
      second column contains a descriptive string:

         [tops@plunger] ready > "dill" defr (hT) .
         dillpickle    | dill pickle
         dill_1        | dill (def 1)
         dill_2        | dill (def 2)
         anise         | anise
         cedilla       | cedilla
         dilatory      | dilatory
         diligence_1   | diligence (def 1)
         diligence_2   | diligence (def 2)
         granadilla    | granadilla
         grandiloquent | grandiloquent
         peccadillo    | peccadillo
         sapodilla     | sapodilla

      The site sends back words that are only marginally related; for
      example, peccadillo that simply contains the string dill.

      The site web page highlights the most likely matches, but the 
      highlighting is not part of the html examined here, so there is
      no way to take advantage of it.  (It is believed that highlight-
      ing is in an image.gif file returned to the browser.) 

      So this word attempts to weed out marginal entries by selecting
      lines from returned T that most closely match the original string.

      Here are results for the "dill" search when the code below narrows
      the list (not perfect: marginal diligence still appears):

         [tops@plunger] ready > "dill" defr .
         dill_1      | dill (def 1)
         dill_2      | dill (def 2)
         dillpickle  | dill pickle
         diligence_1 | diligence (def 1)
         diligence_2 | diligence (def 2)

      If no reference is found, returned T is an empty volume.
}
      [ no "WWW" book, "" "S0" book 
        
      \ Macros for www.askoxford.com:

        {" (qS --- hT) \ return text from site
           SYSOUT push 
           (qS) push

           ftempsys (qFile)       \ temp file from system
           (qFile) dup set_sysout \ HTTPget output to temp file

           "http://www.askoxford.com"
           "/concise_oed/" pull (qS) + "?view=uk" + HTTPget (hT)

           pull (SYSOUT) set_sysout

           (qFile hT) swap (qFile) delete \ delete temp file

        "} "FETCH" macro 

        {" (qS --- f) \ return f true if S is found at site
           (qS) FETCH (hT) "404 Not found" grepr (hR) rows 0= (f)
        "} "PING" macro

        {" (qS --- hT) \ return text from site search
           SYSOUT push 
           (qS) push

           ftempsys (qFile)       \ temp file from system
           (qFile) dup set_sysout \ HTTPget output to temp file

           "http://www.askoxford.com"
           "/results/?view=searchresults&freesearch=" pull (qS) +
           "&branch=&textsearchtype=exact" + HTTPget (hT)

           pull (SYSOUT) set_sysout

           (qFile hT) swap (qFile) delete \ delete temp file

        "} "SEARCH" macro 
      ]

      0 STR stkok
      IF strchop chpack lowercase "S" book
      ELSE "defr" stknot return
      THEN

      WWW not
      IF www_open not
         IF " def: not connected to the Internet" . nl return THEN
      THEN

{     Part 1.  Find word S and variants on the site.

      Look for literal S and up to 3 variations (S_1, S_2, S_3).  
      For example, "will" exists only as will_1 and will_2 (in fact,
      a search for "will" from a browser will fail):
}     depth push
      S PING IF S ELSE VOL tpurged THEN (qS) 3 1
      DO S "_" I int$ + + (qS_I) dup PING (f) not
         IF drop EXIT THEN
      LOOP
      (qS qS_1 qS_2 ... ) depth pull less (n) pilen chop (hT)
      dup "W" book "D" book

    \ Part 2.  Run the site search (at a URL different from Part 1). 

      S SEARCH (hT) any?
      IF (hT) textget "T" book \ eview(defr.T) to view original html
         T "<p><b>" S + "</b>" + grepr any?
         IF T swap reach (hR)
{
            Gather all the results into a VOL, one result per line. 
            (Only the first page (about 20 results) is obtained here; 
            getting other pages means accessing the site again and
            again).

            The following loop replaces strings 1., 2., ..., 0. (that
            number each result) with NL chars, so each result goes to 
            a new line in the VOL created by word textget.

            This works for any number of results, not just 10; for ex-
            ample, "100." is a match with "0." so it goes to a new line
            (the "10" part of "100." stays behind on the previous line 
            and gets discarded).

}           (hR) 9 0 DO I int$ "." + NLch over + strp LOOP
            textget (hT) dup "T1" book (hT) \ eview(defr.T1) when debug

          \ Fetch just the rows for English entries:
            dup "English dictionary entry" grepr any?
            IF reach "<a" "</a>" between
               "H" book \ eview(defr.H) to view html
               H "_oed/" '">' between chop any?
               IF W swap pile S chars blpad
                  "W" book \ web string (for URL, always one string/row)
                  H '"><span>' "</span>" between chop any?
                  IF "<sup>" " (def " strp
                     "</sup>" ")" strp
                     D swap pile S chars blpad
                     "D" book \ description (one or more strings/row)
                  THEN
               THEN
            ELSE drop
            THEN
         THEN
      THEN

      W rows 0>
      IF W "W0" book D "D0" book
       \ This section narrows lists W and D to relevant entries.
         depth push
{
         Keep rows in lists W and D that exactly match S in their 
         left-most characters; keep rows that contain non-English 
         characters, since they probably go with S (an example is 
         rsum); and keep rows with underscore in the web file name
         since they are probably related to S.
}        
         0 1 null (hR0) \ initial purged, single column MAT

         W S chkeep 1st S chars items catch S grepe (hR1) \ matches S
         W "_" grepr (hR2)  \ rows with underscore, meaning related
         W "&#" grepr (hR3) \ has some non-English characters

         D S chkeep 1st S chars items catch S grepe (hR4) \ matches S
         D "&#" grepr (hR5) \ has some non-English characters

         (hR1 hR2 ... ) depth pull less (n)
         (hR1 hR2 ... n) pilen nodupes yes sort (hR) any? not (f)

{        If we come up empty after narrowing, take the first entry or 
         two (this covers words with British spelling--after all, this 
         is Oxford--like colour for color and flavour for flavor):
}        IF 1st 2 W rows min items (hR) \ list of 1 or 2 ("syntactic")
         THEN (hR) "R" book

       \ Now take out duplicates from Part 1 and Part 2:
         W R reach noq_alike1 (hW1 hA) push "W" book
         D R reach pull (hA) rake lop "D" book

       \ Return web URL string, W, and description string, D, sepa-
       \ rated by |:
         W chop (hW) " | " tail D + "_defr" naming (hT)
      ELSE 
         VOL tpurged (hT)
      THEN (hT)
   end

   inline: hyph (qS --- qS1) \ hyphenate word S
{     Go to dictionary.reference.com and get the hyphenation for word S
      (December 2007).

      Example:
         December 2007:
            [tops@plunger] ready > "hyphenation" hyph

             stack elements:
                   0 volume: _hyph  2 by 31
             [1] ok!
            [tops@plunger] ready > .
            hy-phen-ate
            -at-ed
            -at-ing
            hy-phen-a-tion

         November 2008 after the site was modified:
            [tops@plunger] ready > "hyphenation" hyph
   
             stack elements:
                   0 volume: _hyph  5 by 14
             [1] ok!
            [tops@plunger] ready > .
            hy-phen-ate
            hy-phen-at-ed
            hy-phen-at-ing
            hy-phen-ates
            hy-phen-a-tion
}
      0 STR stkok 
      IF strchop lowercase "S" book ELSE "hyph" stknot return THEN 

      www_open not
      IF " hyph: not connected to the Internet" . nl return THEN

      SYSOUT push 
      ftempsys (qFile)       \ temp file from system
      (qFile) dup set_sysout \ HTTPget output to temp file

      "http://dictionary.reference.com" "/browse/" S + HTTPget (hT)
      (hT) "T" book

      pull (SYSOUT) set_sysout
      (qFile) delete \ delete temp file

    \ Take apart the returned html (the strategy for doing this is 
    \ developed by viewing html VOL T in an editor):
{
    \ December 2007.
    \ Part 1:
      T '<div class="luna-Ent"><span class="me">' "</span>" between
      asciify (qS1)
 
    \ The hyphen between syllables is represented by ascii characters
    \ 194 and 183 (run 194 emit 183 emit).  Replace them with a hyphen:
      (qS1) 194 export1 183 export1 + "-" strp (qS1)

    \ Part 2:
      T '<span class="secondary-bf">' "</span>" between (qS2)
      (qS2) 194 export1 183 export1 + "-" strp (qS2) \ hyphen
      "." ", " strp   \ a period into a comma and a space
      ",  " ", " strp \ comma + two spaces into comma + one space
      words dup "-" grepr any?
      IF (hT hRows) reach ELSE drop "" THEN
}
    \ Update November 2008.

    \ Part 1 (like display):
      T '<div class="luna-Ent"> <h2 class="me">' '</h2' between
      asciify (qS1)

    \ The hyphen between syllables is represented by ascii characters 
    \ 226+139+133 (to see, run (qS1) uimport1 .m).  Replace them with 
    \ a hyphen:
      (qS1) 226 export1 139 export1 + 133 export1 + "-" strp (qS1)

    \ Part 2 (like displayed, displaying, displays):
      T '<table><tbody><tr><td><b>' "</b>" between spaced (qS2)

      T "<!--BOF_SUBHEAD-->" "<!--EOF_SUBHEAD-->" between (qS)
      (qS) "<b>" "</b>" between spaced + (qS2)

      T "<!--BOF_DEF-->" "<!--EOF_DEF-->" between (qS)
      (qS) "<b>" "</b>" between + (qS2)

    \ The hyphen between syllables is represented by ascii characters 
    \ 194+183 (to see, run (qS2) uimport1 .m).  Replace them with a 
    \ hyphen:
      (qS2) 194 export1 183 export1 + "-" strp (qS2)
      "<b>" "" strp "</b>" "" strp (qS2)
      "'" "-" strp (qS2) \ instance of ' used for - (hy'phen-a'tion)

    \ Combine parts 1 and 2:
      (qS1 qS2) pile words (hT)

    \ Blank out lines that contain html:
      "=" "" qreplace
      ">" "" qreplace
      "<" "" qreplace
      "(" "" qreplace
      ")" "" qreplace

      noblanklines noq_alike (hT)

    \ Remove lines where first 3 chars don't match S:
      (hT) dup rows 0> 
      IF (hT) dup "-" chblank chpack (hT1)
         1st 3 S chars min items catch (hT1) 
         (hT hT1) S 1st 3 S chars min items catch grepr (hRows) any?
         IF (hT hRows) reach THEN (hT)
      THEN

      (hT) these rows 1 = 
      IF vol2str (qS1) ELSE "_hyph" naming (hT) THEN

      "" "T" book
   end

   pull catmsg halt
 
\-----------------------------------------------------------------------
;  Appendix.
\-----------------------------------------------------------------------

  _inline: +BL (hT --- hT1) \ making bytes in T at least equal to BL
\     Bytes in T are ORed with BL, making them BL or above.
\     Example:
\        "ABC" 2 nulls "XYZ" cat cat dup .hex nl
\        hand +BL dup .hex nl .
      these dims blockofblanks
      swap vol2mat swap vol2mat or mat2vol
   end

   The version of 100ths shown below suffers from bad rounding.  

   For example, 140.7 becomes 14069, not 14070.
   The problem comes from the multiplication by 100:

      [tops@gutter] ready > 140.7 100 * "%2.32f" format . 
      14069.99999999999818101059645414352417

   Yet multiplying by 1000 and dividing by 10 gives exact bytes:

      [tops@gutter] ready > 140.7 1000 * 10 / "%2.32f" format . 
      14070.00000000000000000000000000000000

   This result is the same on big endian and little endian machines, 
   so it must be a "feature" of IEEE floating point arithmetic.

   While replacing 100 *f with 1000 *f 10 /f fixes that problem, 65.875 
   still does not truncate in the desired way:
   [tops@gutter] ready > 65.875 100ths .
   6588

   Formatting these values is not as trivial as one might think.  The 
   new version of 100ths fixes all these problems.

  _inline: 100ths (hV --- hT) \ number column V into text with 100ths
\     Examples: 65.875 becomes 65.87, -0.2 becomes -020
      hand dup sign bit dup plus one +d push
      abs 100 *f 100 those dims fill
      /mod pull *by "%5.0f" format swap abs
      "%02.f" format park chop
   end
   
\  Now a C function in tex.c:
  _inline: replace$ (qR qS qS1 --- qR1) \ in string R, replace S with S1
\     Unpredictable if length of S1 is greater than length of S.
      "S1" book, "S" book 
      this (qS) S smap (hMap) any?
      IF (qR hMap) 
         swap (qR) 1st quote cop hand push
         (hMap) 1st +d (hMap) dup push rows 1st
         DO peek I pry, S1 chars items LOOP peek rows pilen
         S1 pull rows cats swap peek (qR) cram
         pull (qR) 1st quote 
      ELSE (qR) cop
      THEN (qR) "_R1" naming
   end

\  Better version in file.v:
  _define: voc (qFile --- hT) \ text matrix of definitions on File
      asciiload 
      dup "define: " quotes, -8 indent
      bob "inline: " quotes, -8 indent
      pile alphabetize
      3 indent notrailing "_voc" naming ;


