{ {{{1 GNU General Public License
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} }

{ File sparse.v  July 2002

   Copyright (c) 2002-2005   A. Danial

}
#-----------------------------------------------------------------------

   CATMSG push no catmsg

   inline: sppartition (A r01 c01 --- A00 A10 A01 A11)  # {{{1
# documentation in doc/newman.doc
      swap, push claw,   (Aleft Aright)
      swap, peek rake,   (Aright A00 A10)
      two roll, pull rake, (A00 A10 A01 A11)

      [ "spcomb" "claw" overload, "sprake" "rake" overload ]
   end
# 1}}}
   inline: sprnull (hspT r01 --- hspT1) # expanding sparse T by rake R # {{{1
# man entry:  sprnull {{{2
# (hspT r01 --- hspT1) Expand rows of sparse T to the row-size of rake R, using nulls.  The ones (or non-zeroes) in R correspond to rows where T will go in T1, so there must be as many ones in R as there are rows in T.
Example:
  2 speye 3 spscale  #  2x2 identity * 3
  list: 0 1 0 0 1 ;  #  [0 1 0 0 1]
  sprnull .m
produces
  Row 1:        0        0
  Row 2:        3        0
  Row 3:        0        0
  Row 4:        0        0
  Row 5:        0        3
# category: math::matrix::sparse, math::matrix::partitioning
# related:  submat, spcatch, spreach, partition
# 2}}}
      these rows them sprows less (r)
      them spcols (r c) spnull (hT hR hNull)
      rot rot (hNull hT hR) sptier
   end 
# 1}}}
define: spsubmat (hA hRows hCols --- hA1) # {{{1
# man entry:  spsubmat {{{2
# (hA hRows hCols --- hA1) Extracts the submatrix of [A] defined by the row and column partition vectors.
# category: math::matrix::sparse, math::matrix::partitioning
# related:  submat, spcatch, spreach, partition
# 2}}}
        rot swap ( hA hRows hCols --- hRows hA hCols )
        spcatch  ( hRows hC' )
        swap spreach  ( hRows hC' )
    ;   # 1}}} 
define: sptier (hA0_sp hA1_sp r01 --- hA_sp) # {{{1
# man entry:  sptier {{{2
# (hA0_sp hA1_sp r01 --- hA_sp) Merge sparse matrices A0:A1 into top:bottom of A using row rake r01.  The algorithm first transposes the inputs then operates on columns with spmesh, then transposes spmesh's output.  This is the sparse version of tier.
# category: math::matrix::sparse, math::matrix::partitioning
# related:  tier, spmesh, mesh, spsubmat, submat, spcatch, spreach
# 2}}}
        rot spbend ( hA1_sp r01 hA0_sp' )
        rot spbend ( r01 hA0_sp' hA1_sp' )
        rot        ( hA0_sp' hA1_sp' r01 )
        spmesh     ( hA_sp' )
        spbend     ( hA_sp )
    ;   # 1}}} 
inline: spnegate -1.0 spscale ; # {{{1
# documentation in doc/newman.doc
# 1}}}

   pull catmsg # restore user's setting
