\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

\  File nasrun.v  May 2000

\  Words that run MSC Nastran
{
   Text for your own file usr/nasrun.v with several machines, versions,
   and your words additional.  

   Put the following into a file called nasrun.v at your usrpath; then,
   sourcing nasrun.v will run it instead of this one at syspath.  But
   note that the first line it runs is going to source this file at
   syspath, then it will go on to run phrases and create words for your
   machines. 

------------------------------- clip -----------------------------------
\  File usr/nasrun.v

   "nasMem" missing
   IF syspath "nasrun.v" cat source \ sourcing file at syspath first
   THEN

\  Versions to run on various machines:

      "nast705" (qS)
      host "bach"   alike IF "nast682"  lop THEN
      host "hayden" alike IF "nast707"  lop THEN
      host "blake"  alike IF "nast2001" lop THEN
      (qS) nasVer \ setting version in word nasScript

\  Additional words for running Nastran:

------------------------------- clip -----------------------------------
 
\-----------------------------------------------------------------------
}
   CATMSG push no catmsg

   define: nasMem (n --- ) \ set memory size in the Nastran script
      "nasScript" "mem" implant ;

\  This word supplies the script that runs Nastran:
   define: nasScript ( --- hT) \ script that runs Nastran 
      [ 10000000 "mem" book, "" makes addrDir 
        "nast705" "nasVersion" book 
      ]
        "echo ' Running Nastran.  Standby...'" (qS)
        keys? IF " > /dev/tty" cat THEN (qS)

        nasVersion
        " 'nas.dat' scr=yes bat=no app=yes not=no mem=" cat
        mem "%.f" format cat
        " > nas.lug" cat
        "rm nas.lug" pile (qS1)

        (qS qS1) pile onto nasScript

        "cd " addrDir cat 
        nasScript pile
   end

\  Fire word nasSubDir to initialize script if you are running Nastran 
\  in a subdirectory that is different from the current one, as in:
\      "/overthere/blastoff/run/" nasSubDir

   define: nasSubDir (qS --- ) \ subdirectory where running Nastran 
      "" catpath "nasScript" "addrDir" bank ;

   "./" nasSubDir \ running in the current subdirectory

\  Fire word nasVer to initialize nasScript for your Nastran version:
   define: nasVer (qS --- ) \ set version to run
      "nasScript" "nasVersion" implant ;

   "nast2001" nasVer \ setting default version

\-----------------------------------------------------------------------

   define: /symnas (hF hK --- hX) \ solve K*x=F for x, using Nastran
{     Driver for /symnas1.

      The following makes F and symmetric K and runs a timed test case:
         2067 ones (F), these rows dup random (K)
         dup bend plus 2 /f (K symmetric)
         these rows identity 1e4 *f plus (K diagonally dominant)
         time push, /symnas, time pull - .i " seconds" . nl beep
}
      [ scalar "temp" book
        runid "K.op4" cat is qK
        runid "F.op4" cat is qF
      ]
      temp filetrue IF temp close THEN

      qK again deleteif new binary "temp" file
      (hK) temp put4, temp close

      qF again deleteif new binary "temp" file
      (hF) temp put4, temp close

      qF qK /symnas1 (qX) any?
      IF dup (qX) old binary "temp" file temp "" get4 (hX)
         swap (qX) delete, qF delete, qK delete
      ELSE purged
      THEN
   end

   define: /symnas1 (qF qK --- qX) \ solve K*x=F for x, using Nastran
{     Solve K*x=F for x using Nastran .op4 files for F and symmetric K.

      Returns name of file that contains the solution.  If error, qX has
      no characters.
}     [
      {"
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
       $
          inputt4 /F,,,,/1/31/-1/1 $ binary
          inputt4 /K,,,,/1/32/-1/1 $ binary
          modtrl K////6 $
       $
          decomp K/L,U,/////////58 $
          fbs L,U,F/X $
          output4 X,,,,//0/33 $ binary out
       $
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32" are deletions
      runid "X.op4" cat is fname
      " no static analysis results" is errmsg
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qK) swap " fort.32" cat cat shell
      "ln -fs " (qF) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.33" file?
      IF "/bin/mv fort.33 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   define: asciiop4 (qFile --- hA) \ read matrix from Nastran ascii op4
\     Edit the items in INPUTT4 and OUTPUT4 lines.  Note that INPUTT4 
\     also requires the number of matrices coming in.
      [
      {"
       $ Read the first matrix from a Nastran ascii op4 file
       $
       Nastran buffsize=20482 $
       $ Assign statements are required for formatted files only.
       ASSIGN INPUTT4='fort.31',form=formatted,old,unit=31
       id op4,op4
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
          INPUTT4 /A,,,,/1/31/-1/0 $ ascii in
          OUTPUT4 A,,,,//0/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "dummy" "op4" book

      "/bin/rm nas.dat fort.31 fort.41" are deletions
      " no output4 matrix" is errmsg
      ]
      op4 filetrue IF op4 fclose THEN \ closes op4 if still active

      nas.dat "nas.dat" save
      "ln -fs " (qFile) swap " fort.31" cat cat shell
      600 expectout, nasScript (hT) running drop, 30 expectout

      "fort.41" file?
      IF "fort.41" old binary "op4" file, op4 "" get4 op4 fclose
         deletions shell
      ELSE errmsg nl . nl ""
      THEN
   end

   define: ascii44 (qAsc qBin --- ) \ ascii .op4 to binary .op4
\     Edit the items in INPUTT4 and OUTPUT4 lines.  Note that INPUTT4 
\     also requires the number of matrices coming in.
      [
      {"
       $ Assign statements are required for formatted files only.
       ASSIGN INPUTT4='fort.31',form=formatted,old,unit=31
       id op4,op4
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
          INPUTT4 /A,B,C,,/3/31/-1/0 $ ascii in
          OUTPUT4 A,B,C,,//0/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      " no binary output4 file" is errmsg
      ]
      strchop "Bin" book
      strchop "Asc" book

      nas.dat "nas.dat" save
      "ln -fs " Asc " fort.31" cat cat shell
      600 expectout, nasScript (hT) running drop, 30 expectout

      "fort.41" file?
      IF "mv fort.41 " Bin cat shell deletions shell
      ELSE errmsg nl . nl ""
      THEN
   end

   define: binary44 (qBin qAsc --- ) \ binary .op4 to ascii .op4
\     Edit the items in INPUTT4 and OUTPUT4 lines.  Note that INPUTT4
\     also requires the number of matrices coming in.
      [
      {"
       $ Assign statements are required for formatted files only.
       ASSIGN OUTPUT4='fort.41',form=formatted,unknown,unit=41
       id op4,op4
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $
          INPUTT4 /A,,,,/1/31/-1/1 $ binary in
          OUTPUT4 A,,,,//0/41/0//16 $ ascii out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      " no ascii output4 file" is errmsg
      ]
      strchop "Asc" book
      strchop "Bin" book

      nas.dat "nas.dat" save
      "ln -fs " Asc " fort.31" cat cat shell
      600 expectout, nasScript (hT) running drop, 30 expectout

      "fort.41" file?
      IF "mv fort.41 " Asc cat shell deletions shell
      ELSE errmsg nl . nl ""
      THEN
   end

   define: cinv_nast (qA --- qB) \ inverse of complex matrix A
\     Returns name of file that contains the result.  If error, qB has 
\     no characters.

\     Uses matmod(34), requiring msc version 70.7 or above.
      [
      {"
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $
          inputt4 /Ar,Ai,,,/2/31/-1/1 $ binary
          add Ar,Ai/A/(1.0,0.0)/(0.0,1.0) $

          solve A,,,,/B/3 $

          matmod B,,,,,/Br,Bi/34//2 $
          output4 Br,Bi,,,//0/41 $ binary out

        $ Checking the inverse:
          mpyad A,B,/C
          matmod C,,,,,/Cr,Ci/34//2 $

          matmod Cr,,,,,/UnitReal,/2////v,y,filt1=0.000001 $
          diagonal UnitReal/DiagReal $
          matprn DiagReal,,,,// $

          matmod Ci,,,,,/NullImag,/2////v,y,filt2=0.000001 $
          diagonal NullImag/DiagImag $
          matprn DiagImag,,,,// $

        $ Put check matrices on fort.42:
          output4 UnitReal,NullImag,,,//0/42 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      " no complex matrix inverse results" is errmsg
      runid "C.op4" cat is fname
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qA) swap " fort.31" cat cat shell

      6 3600 * expectout 
      "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell deletions shell 
         fname (qB)
      ELSE errmsg nl . nl ""
      THEN
   end

   define: cmpynas (qA qB --- qC) \ complex multiply A*B=C
\     Returns name of file that contains the result.  If error, qC has 
\     no characters.
      [
      {"
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $

          $ Cr = Ar*Br - Ai*Bi
          $ Ci = Ar*Bi + Ai*Br

          inputt4 /Ar,Ai,,,/2/31/-1/1 $ binary
          inputt4 /Br,Bi,,,/2/32/-1/1 $ binary

          mpyad Ar,Br,/C1 $
          mpyad Ai,Bi,C1/Cr//-1 $

          mpyad Ar,Bi,/C2 $
          mpyad Ai,Br,C2/Ci $

          output4 Cr,Ci,,,//0/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32" are deletions
      " no complex matrix multiplication results" is errmsg
      runid "C.op4" cat is fname
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qB) swap " fort.32" cat cat shell
      "ln -fs " (qA) swap " fort.31" cat cat shell

      6 3600 * expectout 
      "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   define: eig2nas (qM qK --- qA) \ eigenanalysis of sym 2nd order sys
{     Eigenanalysis of symmetric 2nd order system in Nastran using 
      .op4 files M and K.  

      Returns name of file that contains modes up to frequency 
      defined below in line EIGR.

      If error, qA has no characters--test with word any?.

      Note: Frequency range is defined on EIGR line below.

      Example: "MFV.op4" "KFV.op4" eig2nas
}     [ 
      {"
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $
       $
          inputt4 /M,,,,/1/31/-1/1 $ binary
          inputt4 /K,,,,/1/32/-1/1 $ binary
       $
          read K,M,,,DYNAMICS,,CASECC,,,,,,/LAMA1,PHI,MI,OEIGS,,/
             'modes'/s,n,neigv $
          ofp LAMA1,OEIGS// $
       $
          lamx, ,LAMA1/LAMA2/-1 $
          matgen ,/vec1/6/5/1/4 $
          partn LAMA2,vec1,/LAMAt,,,/0 $
          trnsp LAMAt/LAMA $
          call pile LAMA,PHI/A $
          output4 A,,,,//0/41 $ binary out
       end $
       $
       compile subdmap=pile list noref
       subdmap pile A,B/C $
       $ Existing A is piled on top of new B to form C; number 
       $ of columns must match
       $ If A may not exist the first time, be sure and purge it
       $ in the calling routine, as: purge A/always $
       file C=ovrwrt $
       type parm,,i,n,Arows $
       paraml A//'presence'////s,n,purged $
       IF(purged < 0) THEN
         Arows = 0
       ELSE
         paraml A//'trailer'/2/s,n,Arows $
       ENDIF
       paraml B//'trailer'/2/s,n,Brows $
       param //'add'/s,n,Crows/Arows/Brows $
       matgen, /vecpile/6/Crows/Arows/Brows $
       merge A,B,,,,vecpile/C/0 $
       return $
       end $
       cend
       method=1
       BEGIN BULK
       $           | freq range, Hz |       
       EIGR, 1 GIV  0.0       10000.0   0  0
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32" are deletions
      runid "A.op4" cat is Aname
      " no eigenanalysis results" is errmsg
      ] 
      nas.dat "nas.dat" save

      "ln -fs " (qK) swap " fort.32" cat cat shell
      "ln -fs " (qM) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " Aname cat shell deletions shell 
         Aname (qA)
      ELSE errmsg nl . nl ""
      THEN
   end

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   define: eig2snas (qFileIn -- qFileOut) \ eigenanalysis of sym 2nd ord
{     
      Compute eigenvalues and eigenvectors of supported M and K.

      Eigenanalysis of symmetric 2nd order system in Nastran using 
      .op4 FileIn containing:

         Maa, Kaa, Va 

      where Va contains zero at rows that support Kaa.

      Returns name of file that contains modes up to frequency 
      defined below in line EIGR.

      If error, qFileOut has no characters--test with word any?.

      Note: Frequency range is defined on EIGR line below.
}     [ 
      {"
       sol 100
       time 1000
       diag 8
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
       $
          inputt4 /Maa,Kaa,Va,,/3/31/-1/1 $ binary
       $
          partn Maa,Va,/,,,M/-1 $
          partn Kaa,Va,/,,,K/-1 $
       $
          read K,M,,,DYNAMICS,,CASECC,,,,,,/LAMA1,PHI0,MI,OEIGS,,/
             'modes'/s,n,neigv $
          ofp LAMA1,OEIGS// $
          merge, ,PHI0,,,,Va/PHI/0 $
       $
          lamx, ,LAMA1/LAMA2/-1 $
          matgen ,/vec1/6/5/1/4 $
          partn LAMA2,vec1,/LAMAt,,,/0 $
          trnsp LAMAt/LAMA $
          call pile LAMA,PHI/A $
          output4 A,,,,//0/41 $ binary out
       end $
       $
       compile subdmap=pile list noref
       subdmap pile A,B/C $
       $ Existing A is piled on top of new B to form C; number 
       $ of columns must match
       $ If A may not exist the first time, be sure and purge it
       $ in the calling routine, as: purge A/always $
       file C=ovrwrt $
       type parm,,i,n,Arows $
       paraml A//'presence'////s,n,purged $
       IF(purged < 0) THEN
         Arows = 0
       ELSE
         paraml A//'trailer'/2/s,n,Arows $
       ENDIF
       paraml B//'trailer'/2/s,n,Brows $
       param //'add'/s,n,Crows/Arows/Brows $
       matgen, /vecpile/6/Crows/Arows/Brows $
       merge A,B,,,,vecpile/C/0 $
       return $
       end $
       cend
       method=1
       BEGIN BULK
       $           | freq range, Hz |       
       $EIGR, 1 GIV  0.0      10000.0   0  0
       $           | freq range, Hz |       
       EIGRL, 1 -.1  10000.
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      runid "A.op4" cat is Aname
      " no eigenanalysis results" is errmsg
      ] 
      nas.dat "nas.dat" save

      "ln -fs " (qFileIn) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " Aname cat shell deletions shell 
         Aname (qFileOut)
      ELSE errmsg nl . nl ""
      THEN
   end

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
{
   This word, get2, runs express to get a datablock from an op2 file.  
   It has been replaced by new code in this program that can read op2 
   files.

   Here is the obsolete man entry:

[tops@clacker] ready > man get2
 Entry for get2:
  get2 (qFile qA --- hA) read the data block named A from a Nastran
    output2 file and return matrix A
  get2 note: runs the Express program to write the desired data block
    to an output4 file that is then read by the program
  get2 note: requires program Express available for batch execution
    through script expressb
  get2 related: get4
 Source for get2: sys.v

  _inline: get2 (qFile qA --- hA) \ read A from a Nastran op2 file
\     This program cannot read nastran op2 files, so it runs express
\     to write the desired matrix to an op4 file that it can read.

      [ {" Phrases for express to run:
        push binary open
        dup peek get2 swap close
        peek naming pull '.op4' cat
        binary open dup rev put4
        close finis
        "} left justify "command" book
        scalar "fop4" book
      ]
        that file? not IF " file not found" ersys return THEN

      \ Running express in batch mode:
         runid "work.voc" cat "infile" book
         (qA) push quoted spaced
         peek quoted cat
         command pile infile save
         "expressb " infile " &" cat cat shell

      \ Sit here until the file arrives:
         600 expectout
         peek ".op4" cat dup (qFile) quoted " file?" cat expecting (f)
         10 expectout

      \ Reading the file from express:
         IF 15 idle \ giving time for file to settle into the system
            (qFile) dup "fop4"
            old binary file
            fop4 peek get4
            fop4 close (hA)
            (qFile hA) swap delete
            "xpr.out" delete \ dayfile from express
         ELSE (timed out, no file) drop purged
         THEN (hA) infile delete, pull drop
   end
}

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   define: gload (qFileIn --- qFileOut) \ quasi-static acceleration
{     Static analysis, quasi-static acceleration with support.

      Compute static solution to Kaa*ua=-Maa*Rar*rdd under unit rdd.

      FileIn contains the following:

         Kaa, Maa, Rar, Vr 

      where Vr contains zero at determinate rows, r, that support Kaa.

      Returns name of file that contains the solution.  If error,
      qFileOut has no characters--test with word any?.
}     [
      {"
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $
       $
          inputt4 /Kaa,Maa,Rar,Vr,/4/31/-1/1 $ binary
          modtrl Kaa////6 $
       $
          partn Kaa,Vr,/,,,Kll/-1 $
          decomp Kll/L,U,/////////58 $
       $
          partn Maa,,Vr/,Mla,,/0 $
          mpyad Mla,Rar,/Flr/0/-1 $
       $
          fbs L,U,Flr/Xl $
       $
       $  Checking the solution:
       $  mpyad Kll,Xl,/Fl $
       $  add Fl,Flr/F2/(-1.0,0.0) $
       $  matmod F2,,,,,/F3,/2////1.0e-2 $
       $  matprn F3,,,,// $
       $
          merge, ,Xl,,,,Vr/X/0 $
       $
          output4 X,,,,//0/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      runid "X.op4" cat is fname
      " no static gravity analysis results" is errmsg
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qFileIn) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell deletions shell 
         fname (qFileOut)
      ELSE errmsg nl . nl ""
      THEN
   end

   define: gload1 (qFileIn --- qFileOut) \ static gravity loading
{     Solves Kaa*xa=-Maa*Rab*xbdd for xa.

      FileIn contains the following:

         Kaa, Maa, Rab, Va 

      where Va contains zero at rows that support Kaa.

      This version removes from xa the rigid body motion due to the 
      support points chosen, so that the mass center is undeformed.

      Returns name of file that contains the solution.  If error,
      qFileOut has no characters--test with word any?.
}     [
      \ Nastran input file for static analysis with support:
      {"
       $ Compute static solution to K*x=-M*R*xdd for unit xdd
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $
          alter 2 $
       $
          inputt4 /Kaa,Maa,Rab,Va,/4/31/-1/1 $ binary
          modtrl Kaa////6 $
       $
          partn Kaa,Va,/,Klr,,Kll/-1 $
          decomp Kll/L,U,/////////58 $
       $
          mpyad Maa,Rab,/Fab/0/-1 $
          partn Fab,,Va/,Flb,,/0 $
       $
          fbs L,U,Flb/Xlbar $ deformations for supports held to zero
       $
          partn Rab,,Va/Rrc,Rlc,,/0 $
          partn Maa,Va,/Mrr,Mlr,Mrl,Mll/-1 $
       $
          fbs L,U,Klr/K1//-1 $ 
          mpyad Mrl,K1,Mrr/A1//-1 $
          mpyad Rrc,A1,/A2/1 $
          mpyad Mll,K1,Mlr/A3//-1 $
          mpyad Rlc,A3,A1/A4/1 $
       $
          decomp A4/L4,U4,/////////58 $
       $
          mpyad Rrc,Mrl,/B1/1 $
          mpyad Rlc,Mll,B1/B2/1 $
          mpyad B2,Xlbar,/B3 $
       $
          fbs L4,U4,B3/Trc//-1 $ 
       $
          matprn Trc,,,,// $
          mpyad K1,Trc,/Xdelta//-1 $
          matprn Xlbar,Xdelta,,,// $ shows how Xldelta corrects Xl
          add Xlbar,Xdelta/Xl $
          merge Trc,Xl,,,,Va/X/0 $
       $
          output4 X,,,,//0/41 $ binary out
       $
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31" are deletions
      runid "X.op4" cat is fname
      " no static gravity analysis results" is errmsg
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qFileIn) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   define: makeop2 (qFile --- ) \ read a matrix from op4 and write op2
      [
      {"
       $ Read matrix from Nastran op4 file and write op2
       $
       Nastran buffsize=20482 $ for large op2 files
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
          INPUTT4 /G,,,,/1/31/-1/1 $ binary in
          OUTPUT2 G,,,,//-1/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "dummy" "op4" book

      "/bin/rm nas.dat fort.31" are deletions
      " no output2 file" is errmsg
      ]
      strchop "name" book
      op4 filetrue IF op4 fclose THEN \ closes op4 if still active

      nas.dat "nas.dat" save
      "ln -fs " (qFile) name " fort.31" cat cat shell
      600 expectout, nasScript (hT) running drop, 30 expectout

      "fort.41" file?
      IF "mv fort.41 " name -ext ".op2" cat cat shell deletions shell
      ELSE errmsg nl . nl ""
      THEN
   end

   define: mpynas (qA qB --- qC) \ multiply A*B=C
      [
      {"
       $ Multiplication.  C=A*B.
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
       
          inputt4 /A,,,,/1/31/-1/1 $ binary
          inputt4 /B,,,,/1/32/-1/1 $ binary
          mpyad A,B,/C $
          output4 C,,,,//0/41 $ binary out
       $
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32" are deletions
      runid "C.op4" cat is fname
      " no matrix multiplication results" is errmsg

      ]
      nas.dat "nas.dat" save

      "ln -fs " (qB) swap " fort.32" cat cat shell
      "ln -fs " (qA) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout
      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   define: transform1 (qM qT --- qM1) \ M1=T'*M*T
\     Transform M: M1=T'*M*T
      [
      {"
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
          inputt4 /M,,,,/1/31/-1/1 $ binary
          inputt4 /T,,,,/1/32/-1/1 $ binary
          smpyad T,M,T,,,/M1/3////1////6 $
          output4 M1,,,,//0/41 $ binary out
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32" are deletions
      runid "M.op4" cat is fname
      " no matrix transformation results" is errmsg

      ]
      nas.dat "nas.dat" save

      "ln -fs " (qT) swap " fort.32" cat cat shell
      "ln -fs " (qM) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   define: xortho (qPsi qPhi qM --- qM1) \ M1=Psi'*M*Phi
      [
      {"
       $ M1=Psi'*M*Phi
       sol 100
       time 1000
       diag 8
       $
       compile userdmap,souin=mscsou,list,noref $ 
          alter 2 $
       
          inputt4 /PSI,,,,/1/31/-1/1 $ binary
          inputt4 /PHI,,,,/1/32/-1/1 $ binary
          inputt4 /M,,,,/1/33/-1/1 $ binary
          mpyad PSI,M,/PM/1 $
          mpyad PM,PHI,/M1 $
          output4 M1,,,,//0/41 $ binary out
       $
       cend
       BEGIN BULK
       ENDDATA
      "} left justify into nas.dat

      "/bin/rm nas.dat fort.31 fort.32 fort.33" are deletions
      runid "M.op4" cat is fname
      " no cross ortho results" is errmsg
      ]
      nas.dat "nas.dat" save

      "ln -fs " (qM)   swap " fort.33" cat cat shell
      "ln -fs " (qPhi) swap " fort.32" cat cat shell
      "ln -fs " (qPsi) swap " fort.31" cat cat shell

      600 expectout, "nasScript" main (hT) running drop, 30 expectout

      "fort.41" file?
      IF "/bin/mv fort.41 " fname cat shell
         deletions shell fname 1st quote
      ELSE errmsg nl . nl ""
      THEN
   end

   pull catmsg private halt

\-----------------------------------------------------------------------

;  Appendix
